# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TrendsGraphDataInfo(BaseModel):
    """
    TrendsGraphDataInfo
    """ # noqa: E501
    date_from: Optional[StrictStr] = Field(default=None, description="start date of the corresponding time range in the UTC format: “yyyy-mm-dd”")
    date_to: Optional[StrictStr] = Field(default=None, description="end date of the corresponding time range in the UTC format: “yyyy-mm-dd”")
    timestamp: Optional[StrictInt] = Field(default=None, description="a point in time in the Unix time format")
    missing_data: Optional[StrictBool] = Field(default=None, description="indicates whether the data is unavailable if true the data on the graph in the Google Trends interface is missing and thus labelled with a dotted line")
    values: Optional[List[Optional[StrictInt]]] = Field(default=None, description="relative keyword popularity rate at a specific timestamp represents the keyword popularity rate over the given time range if you specify more than one keyword, the values will be averaged to the highest value across all specified keywords a value of 100 is the peak popularity for the term. A value of 50 means that the term is half as popular. A score of 0 means there was not enough data for this term")
    __properties: ClassVar[List[str]] = ["date_from", "date_to", "timestamp", "missing_data", "values"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TrendsGraphDataInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if date_from (nullable) is None
        # and model_fields_set contains the field
        if self.date_from is None and "date_from" in self.model_fields_set:
            _dict['date_from'] = None

        # set to None if date_to (nullable) is None
        # and model_fields_set contains the field
        if self.date_to is None and "date_to" in self.model_fields_set:
            _dict['date_to'] = None

        # set to None if timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.timestamp is None and "timestamp" in self.model_fields_set:
            _dict['timestamp'] = None

        # set to None if missing_data (nullable) is None
        # and model_fields_set contains the field
        if self.missing_data is None and "missing_data" in self.model_fields_set:
            _dict['missing_data'] = None

        # set to None if values (nullable) is None
        # and model_fields_set contains the field
        if self.values is None and "values" in self.model_fields_set:
            _dict['values'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TrendsGraphDataInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date_from": obj.get("date_from"),
            "date_to": obj.get("date_to"),
            "timestamp": obj.get("timestamp"),
            "missing_data": obj.get("missing_data"),
            "values": obj.get("values")
        })
        return _obj


