/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.zip;

import fr.gael.streams.ObservableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RemoteFileInputStream
extends ObservableInputStream {
    private static Logger LOGGER = LogManager.getLogger(RemoteFileInputStream.class);
    private final URL url;
    private URLConnection conn;

    public RemoteFileInputStream(URL url) throws IOException {
        this.url = url;
    }

    public int read() throws IOException {
        return -1;
    }

    public int read(byte[] data, int offset, int count) throws IOException {
        int total;
        if (this.conn == null) {
            this.conn = this.url.openConnection();
        }
        InputStream is = this.conn.getInputStream();
        for (total = 0; total < count; total += is.read(data, total, count - total)) {
        }
        LOGGER.debug((Object)("RemoteFileInputStream.read : offset : " + offset + "length : " + count + " read : " + total));
        RemoteFileInputStream.informObservers((String)String.format("%d|%d", total, 0));
        this.conn = null;
        return total;
    }

    public long skip(long n) throws IOException {
        this.conn = this.url.openConnection();
        this.conn.setRequestProperty("Range", "bytes=" + n + "-");
        return n;
    }
}

