/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.zip;

import fr.gael.drb.zip.RemoteFileInputStream;
import fr.gael.drb.zip.RemoteZipEntry;
import fr.gael.drb.zip.RemoteZipUtils;
import fr.gael.drb.zip.ZipConstants;
import fr.gael.streams.ObservableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RemoteZip
implements ZipConstants {
    private final URL url;
    private int diskNumber;
    private int diskCentralDirectory;
    private int entriesCount;
    private int centralDirectorySize;
    private int commentLength;
    private long totalEntriesCount;
    private long centralDirectoryOffset;
    private String comment = "";
    private boolean zip64;
    private final SortedMap<String, RemoteZipEntry> entries = new TreeMap<String, RemoteZipEntry>();
    private boolean zipStructureBuilt;
    private static Logger LOGGER = LogManager.getLogger(RemoteZip.class);
    private static final int BUFFER_SIZE = 0x1000000;

    public RemoteZip(URL url) {
        this.url = Objects.requireNonNull(url);
    }

    private void buildZipStructure() throws IOException {
        long length;
        this.zipStructureBuilt = true;
        long totalLength = length = this.url.openConnection().getContentLengthLong();
        int totalBytesRead = 0;
        if (length == -1L) {
            LOGGER.error((Object)"Cannot retrieve the length of the remote zip, its structure cannot be created.");
            return;
        }
        int eocdLength = 22;
        URLConnection connection = this.url.openConnection();
        connection.setRequestProperty("Range", "bytes=" + (length - 22L) + "-");
        connection.connect();
        length = connection.getContentLengthLong();
        if (length < 1L) {
            LOGGER.error((Object)"Cannot retrieve the end of the central directory of the remote zip");
            return;
        }
        InputStream inputStream = connection.getInputStream();
        byte[] b = RemoteZipUtils.readOneChunk(inputStream, 22);
        inputStream.close();
        totalBytesRead += 22;
        int offset = 0;
        int result = (int)RemoteZipUtils.readIntFromByteArray(b, offset, 4);
        if (result != 101010256) {
            long bytesToRead = length - 65558L;
            connection = this.url.openConnection();
            if (bytesToRead > 0L) {
                connection.setRequestProperty("Range", "bytes=" + bytesToRead + "-");
            }
            connection.connect();
            length = connection.getContentLengthLong();
            if (length < 1L) {
                LOGGER.error((Object)"Cannot retrieve the end of the central directory of the remote zip");
                return;
            }
            inputStream = connection.getInputStream();
            b = RemoteZipUtils.readOneChunk(inputStream, (int)length);
            inputStream.close();
            totalBytesRead = (int)((long)totalBytesRead + length);
            boolean signatureFound = false;
            for (offset = (int)length - 4; offset >= 0; --offset) {
                result = (int)RemoteZipUtils.readIntFromByteArray(b, offset, 4);
                if (result != 101010256) continue;
                signatureFound = true;
                break;
            }
            eocdLength = offset;
            if (!signatureFound) {
                LOGGER.error((Object)"Cannot retrieve the beginning of the central directory of the remote zip, zip is malformed.");
                return;
            }
        }
        this.diskNumber = (int)RemoteZipUtils.readIntFromByteArray(b, offset + 4, 2);
        this.diskCentralDirectory = (int)RemoteZipUtils.readIntFromByteArray(b, offset + 6, 2);
        this.entriesCount = (int)RemoteZipUtils.readIntFromByteArray(b, offset + 8, 2);
        this.totalEntriesCount = (int)RemoteZipUtils.readIntFromByteArray(b, offset + 10, 2);
        this.centralDirectorySize = (int)RemoteZipUtils.readIntFromByteArray(b, offset + 12, 4);
        this.centralDirectoryOffset = RemoteZipUtils.readIntFromByteArray(b, offset + 16, 4);
        this.commentLength = (int)RemoteZipUtils.readIntFromByteArray(b, offset + 20, 2);
        if (this.commentLength > 0) {
            this.comment = RemoteZipUtils.readStringFromByteArray(b, offset + 22, this.commentLength);
        }
        connection = this.url.openConnection();
        connection.setRequestProperty("Range", "bytes=" + (totalLength - (long)(eocdLength + 20)) + "-" + (totalLength - (long)eocdLength - 1L));
        connection.connect();
        length = connection.getContentLengthLong();
        if (length < 1L) {
            LOGGER.error((Object)"Cannot retrieve the Zip64 EOCD locator of the remote zip");
            return;
        }
        inputStream = connection.getInputStream();
        byte[] loc64 = RemoteZipUtils.readOneChunk(inputStream, 20);
        inputStream.close();
        totalBytesRead += 20;
        int eocdLocatorSignature = (int)RemoteZipUtils.readIntFromByteArray(loc64, 0, 4);
        if (eocdLocatorSignature == 117853008) {
            this.zip64 = true;
            long centralDirectoryOffset64 = RemoteZipUtils.readLongFromByteArray(loc64, 8, 8);
            connection = this.url.openConnection();
            connection.setRequestProperty("Range", "bytes=" + centralDirectoryOffset64 + "-" + (totalLength + centralDirectoryOffset64 - (long)(42 + this.commentLength) - 1L));
            connection.connect();
            length = connection.getContentLengthLong();
            if (length < 1L) {
                LOGGER.error((Object)"Cannot retrieve the Zip64 CD of the remote zip");
                return;
            }
            inputStream = connection.getInputStream();
            byte[] eocd64 = RemoteZipUtils.readOneChunk(inputStream, (int)length);
            inputStream.close();
            totalBytesRead = (int)((long)totalBytesRead + length);
            int eocdSignature = (int)RemoteZipUtils.readIntFromByteArray(eocd64, 0, 4);
            if (eocdSignature != 101075792) {
                LOGGER.error((Object)("Zip64 EOCD starts with " + Integer.toHexString(eocdSignature) + " instead of " + Integer.toHexString(101075792)));
                return;
            }
            this.totalEntriesCount = RemoteZipUtils.readLongFromByteArray(eocd64, 32, 8);
            this.centralDirectoryOffset = RemoteZipUtils.readLongFromByteArray(eocd64, 48, 8);
        }
        connection = this.url.openConnection();
        connection.setRequestProperty("Range", "bytes=" + this.centralDirectoryOffset + "-" + (this.centralDirectoryOffset + (long)this.centralDirectorySize - 1L));
        connection.connect();
        length = connection.getContentLengthLong();
        if (length < 1L) {
            LOGGER.error((Object)"Cannot retrieve the central directory of the remote zip");
            return;
        }
        inputStream = connection.getInputStream();
        byte[] cd = RemoteZipUtils.readOneChunk(inputStream, this.centralDirectorySize);
        inputStream.close();
        totalBytesRead += this.centralDirectorySize;
        int cdSignature = (int)RemoteZipUtils.readIntFromByteArray(cd, 0, 4);
        if (cdSignature != 33639248) {
            LOGGER.error((Object)("Central Directory starts with " + Integer.toHexString(cdSignature) + " instead of " + Integer.toHexString(33639248)));
            return;
        }
        offset = 0;
        for (long i = 0L; i < this.totalEntriesCount; ++i) {
            int fileNameLength = (int)RemoteZipUtils.readIntFromByteArray(cd, offset + 28, 2);
            int extraFieldength = (int)RemoteZipUtils.readIntFromByteArray(cd, offset + 30, 2);
            int fileCommentLength = (int)RemoteZipUtils.readIntFromByteArray(cd, offset + 32, 2);
            int entryLength = 46 + fileNameLength + extraFieldength + fileCommentLength;
            RemoteZipEntry remoteEntry = new RemoteZipEntry(this.url, Arrays.copyOfRange(cd, offset, offset + entryLength));
            this.entries.put(remoteEntry.getName(), remoteEntry);
            offset += entryLength;
            LOGGER.debug((Object)remoteEntry);
        }
        LOGGER.info((Object)("Zip discovery - " + this.url.getPath() + " - " + totalBytesRead + " bytes read"));
        ObservableInputStream.informObservers((String)String.format("%d|0", totalBytesRead));
    }

    public InputStream getInputStream() {
        try {
            return new RemoteFileInputStream(this.url);
        }
        catch (IOException e) {
            LOGGER.error((Object)"An I/O error occured while get an inputstream on remote zip", (Throwable)e);
            return null;
        }
    }

    private void lazyBuild() {
        if (!this.zipStructureBuilt) {
            try {
                this.buildZipStructure();
            }
            catch (IOException e) {
                LOGGER.error((Object)"An I/O exception occured while fetching the remote zip structure", (Throwable)e);
            }
        }
    }

    public String getName() {
        String path = this.url.getPath();
        return path.substring(path.lastIndexOf("/") + 1, path.length());
    }

    public SortedMap<String, RemoteZipEntry> getEntries() {
        this.lazyBuild();
        return this.entries;
    }

    public int getDiskNumber() {
        this.lazyBuild();
        return this.diskNumber;
    }

    public int getDiskCentralDirectory() {
        this.lazyBuild();
        return this.diskCentralDirectory;
    }

    public int getEntriesCount() {
        this.lazyBuild();
        return this.entriesCount;
    }

    public long getTotalEntriesCount() {
        this.lazyBuild();
        return this.totalEntriesCount;
    }

    public int getCentralDirectorySize() {
        this.lazyBuild();
        return this.centralDirectorySize;
    }

    public long getCentralDirectoryOffset() {
        this.lazyBuild();
        return this.centralDirectoryOffset;
    }

    public int getCommentLength() {
        this.lazyBuild();
        return this.commentLength;
    }

    public String getComment() {
        this.lazyBuild();
        return this.comment;
    }

    public boolean isZip64() {
        this.lazyBuild();
        return this.zip64;
    }
}

