/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.zip;

import fr.gael.drb.zip.RemoteZipUtils;
import fr.gael.drb.zip.ZipConstants;
import fr.gael.streams.ObservableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RemoteZipEntry
implements ZipConstants {
    private static Logger LOGGER = LogManager.getLogger(RemoteZipEntry.class);
    private final URL url;
    private boolean extraFieldLengthChecked;
    private final String name;
    private final int compressionMethod;
    private final int nameLength;
    private final int commentLength;
    private int extraFieldLength;
    private long headerOffset;
    private long compressedSize;
    private long uncompressedSize;
    private long dataOffset;

    public RemoteZipEntry(URL url, byte[] b) {
        this.url = url;
        this.compressionMethod = (int)RemoteZipUtils.readIntFromByteArray(b, 10, 2);
        this.nameLength = (int)RemoteZipUtils.readIntFromByteArray(b, 28, 2);
        this.name = RemoteZipUtils.readStringFromByteArray(b, 46, this.nameLength);
        this.extraFieldLength = (int)RemoteZipUtils.readIntFromByteArray(b, 30, 2);
        this.commentLength = (int)RemoteZipUtils.readIntFromByteArray(b, 32, 2);
        boolean uncompressedSize64 = false;
        this.uncompressedSize = RemoteZipUtils.readLongFromByteArray(b, 24, 4);
        if (this.uncompressedSize == 0xFFFFFFFFL) {
            this.uncompressedSize = RemoteZipUtils.readLongFromByteArray(b, this.getOffsetForExtraFields64(b, 46 + this.nameLength) + 4, 8);
            uncompressedSize64 = true;
        }
        boolean compressedSize64 = false;
        this.compressedSize = RemoteZipUtils.readLongFromByteArray(b, 20, 4);
        if (this.compressedSize == 0xFFFFFFFFL) {
            this.compressedSize = uncompressedSize64 ? RemoteZipUtils.readLongFromByteArray(b, this.getOffsetForExtraFields64(b, 46 + this.nameLength) + 12, 8) : RemoteZipUtils.readLongFromByteArray(b, this.getOffsetForExtraFields64(b, 46 + this.nameLength) + 4, 8);
            compressedSize64 = true;
        }
        this.headerOffset = RemoteZipUtils.readIntFromByteArray(b, 42, 4);
        if (this.headerOffset == 0xFFFFFFFFL) {
            this.headerOffset = uncompressedSize64 && compressedSize64 ? RemoteZipUtils.readLongFromByteArray(b, this.getOffsetForExtraFields64(b, 46 + this.nameLength) + 20, 8) : (uncompressedSize64 || compressedSize64 ? RemoteZipUtils.readLongFromByteArray(b, this.getOffsetForExtraFields64(b, 46 + this.nameLength) + 12, 8) : RemoteZipUtils.readLongFromByteArray(b, this.getOffsetForExtraFields64(b, 46 + this.nameLength) + 4, 8));
        }
        this.dataOffset = this.headerOffset + 30L + (long)this.nameLength + (long)this.extraFieldLength;
    }

    public InputStream getInputStream() throws IOException {
        this.checkExtraFieldLength();
        LOGGER.debug((Object)("Get input stream for entry " + this.name));
        URLConnection connection = this.url.openConnection();
        connection.setRequestProperty("Range", "bytes=" + this.dataOffset + "-" + (this.dataOffset + this.compressedSize));
        connection.connect();
        long length = connection.getContentLengthLong();
        if (length < 1L) {
            LOGGER.error((Object)("Cannot download the entry: " + this.name));
            return null;
        }
        LimitedInputStream inputStream = new LimitedInputStream(connection.getInputStream(), this.compressedSize);
        switch (this.compressionMethod) {
            case 0: {
                LOGGER.debug((Object)"Entry is stored without compression");
                return inputStream;
            }
            case 8: {
                LOGGER.debug((Object)"Entry is compressed (deflated)");
                return new InflaterInputStream(inputStream, new Inflater(true));
            }
        }
        LOGGER.error((Object)("Compression method (" + this.compressionMethod + ") not supported"));
        return null;
    }

    private void checkExtraFieldLength() throws IOException {
        if (this.extraFieldLengthChecked) {
            return;
        }
        URLConnection connection = this.url.openConnection();
        connection.setRequestProperty("Range", "bytes=" + this.headerOffset + "-" + (this.headerOffset + 30L - 1L));
        connection.connect();
        InputStream inputStream = connection.getInputStream();
        byte[] data = RemoteZipUtils.readOneChunk(inputStream, 30);
        inputStream.close();
        LOGGER.info((Object)("Zip entry discovery - " + this.url.getPath() + "(" + this.name + ") - " + 30 + " bytes read"));
        ObservableInputStream.informObservers((String)String.format("%d|0", 30));
        int newExtraFieldLength = (int)RemoteZipUtils.readIntFromByteArray(data, 28, 2);
        if (newExtraFieldLength != this.extraFieldLength) {
            LOGGER.debug((Object)("Extra field length was different for entry " + this.name + " | " + this.extraFieldLength + " instead of " + newExtraFieldLength));
            this.extraFieldLength = newExtraFieldLength;
            this.dataOffset = this.headerOffset + 30L + (long)this.nameLength + (long)this.extraFieldLength;
        }
        this.extraFieldLengthChecked = true;
    }

    private int getOffsetForExtraFields64(byte[] b, int offset) {
        for (int offset64 = offset; offset64 < b.length - 2; offset64 += 2) {
            long header = RemoteZipUtils.readIntFromByteArray(b, offset64, 2);
            if (header != 1L) continue;
            return offset64;
        }
        return -1;
    }

    public String toString() {
        return "[name: " + this.name + " | header offset: " + this.headerOffset + " | dataOffset: " + this.dataOffset + " | method: " + this.compressionMethod + "]";
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public int getExtraFieldLength() {
        return this.extraFieldLength;
    }

    public int getNameLength() {
        return this.nameLength;
    }

    public String getName() {
        return this.name;
    }

    public long getHeaderOffset() {
        return this.headerOffset;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public int getCommentLength() {
        return this.commentLength;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    private class LimitedInputStream
    extends InputStream {
        private InputStream stream;
        private long bytesRead;
        private long limit;

        public LimitedInputStream(InputStream stream, long limit) {
            this.stream = stream;
            this.limit = limit;
        }

        @Override
        public int read() throws IOException {
            if (this.bytesRead == this.limit) {
                return -1;
            }
            ++this.bytesRead;
            return this.stream.read();
        }
    }
}

