/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.zip;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.Value;
import fr.gael.drb.zip.RemoteZipEntry;
import fr.gael.drb.zip.RemoteZipNode;
import fr.gael.streams.RandomAccessInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.function.Function;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RemoteZipEntryNode
extends DrbNodeImpl {
    private static Logger LOGGER = LogManager.getLogger(RemoteZipEntryNode.class);
    private final RemoteZipNode remoteZipNode;
    private final RemoteZipEntry entry;
    private final DrbNode parent;
    private DrbNodeList children;
    private java.lang.String canonicalName;
    private DrbAttributeList attributes;
    private boolean attributesBuilt;

    public RemoteZipEntryNode(RemoteZipNode remoteZip, RemoteZipEntry entry, DrbNode parent) {
        this.remoteZipNode = remoteZip;
        this.entry = entry;
        this.parent = parent;
    }

    public DrbNode getParent() {
        return this.parent;
    }

    public DrbNodeList getChildren() {
        if (this.children != null) {
            return this.children;
        }
        DrbDefaultNodeList list = new DrbDefaultNodeList();
        ArrayList<RemoteZipEntryNode> leafChildren = new ArrayList<RemoteZipEntryNode>();
        java.lang.String entryName = this.entry.getName();
        SortedMap<java.lang.String, RemoteZipEntry> trailingMap = this.remoteZipNode.getRemoteZip().getEntries().tailMap(entryName);
        boolean selfSkipped = false;
        for (RemoteZipEntry currententry : trailingMap.values()) {
            if (!selfSkipped) {
                selfSkipped = true;
                continue;
            }
            java.lang.String currentName = currententry.getName();
            if (!currentName.startsWith(entryName)) break;
            java.lang.String trailingPath = currentName.substring(entryName.length());
            int slashIndex = trailingPath.indexOf(47);
            if (slashIndex >= 0 && trailingPath.length() != slashIndex + 1) continue;
            RemoteZipEntryNode zip_node = new RemoteZipEntryNode(this.remoteZipNode, currententry, (DrbNode)this);
            if (currententry.isDirectory()) {
                list.add((Object)zip_node);
                continue;
            }
            leafChildren.add(zip_node);
        }
        list.addAll(leafChildren);
        this.children = list;
        return this.children;
    }

    public boolean hasImpl(Class api) {
        if (api.isAssignableFrom(InputStream.class)) {
            return !this.entry.isDirectory();
        }
        return super.hasImpl(api);
    }

    public Object getImpl(Class api) {
        if (api.isAssignableFrom(InputStream.class)) {
            try {
                Function<Void, InputStream> fn = param -> this.getStream();
                RandomAccessInputStream rais = new RandomAccessInputStream(fn, this.entry.getName());
                return rais;
            }
            catch (IOException e) {
                LOGGER.error((Object)("An I/O error occured while getting an inputStream on entry :" + this.entry), (Throwable)e);
                return null;
            }
        }
        return super.getImpl(api);
    }

    private InputStream getStream() {
        try {
            return this.entry.getInputStream();
        }
        catch (IOException e) {
            LOGGER.error((Object)("An I/O error occured while getting an inputStream on entry :" + this.entry), (Throwable)e);
            return null;
        }
    }

    public java.lang.String getName() {
        int separatorIndex;
        if (this.canonicalName != null) {
            return this.canonicalName;
        }
        java.lang.String entryPath = this.entry.getName();
        if (entryPath.endsWith("/")) {
            entryPath = entryPath.substring(0, entryPath.length() - 1);
        }
        if ((separatorIndex = entryPath.lastIndexOf("/")) >= 0) {
            entryPath = entryPath.substring(separatorIndex + 1);
        }
        this.canonicalName = entryPath;
        return this.canonicalName;
    }

    public DrbNode getChildAt(int index) {
        DrbNodeList children = this.getChildren();
        if (children != null) {
            return children.item(index);
        }
        return null;
    }

    public int getChildrenCount() {
        DrbNodeList children = this.getChildren();
        if (children != null) {
            return children.getLength();
        }
        return 0;
    }

    public boolean hasChild() {
        return this.getChildrenCount() != 0;
    }

    public DrbNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.getIndex();
        if (index == 0) {
            return null;
        }
        if (index > 0) {
            return this.parent.getChildAt(index - 1);
        }
        DrbNodeList parentChildren = this.parent.getChildren();
        if (parentChildren == null) {
            return null;
        }
        DrbNode previousNode = parentChildren.item(0);
        for (int inode = 1; inode < parentChildren.getLength(); ++inode) {
            DrbNode currentNode = parentChildren.item(inode);
            if (this.equals(currentNode)) {
                return previousNode;
            }
            previousNode = currentNode;
        }
        return null;
    }

    public DrbNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.getIndex();
        if (index >= 0) {
            return this.parent.getChildAt(index + 1);
        }
        DrbNodeList parentChildren = this.parent.getChildren();
        if (parentChildren == null) {
            return null;
        }
        for (int inode = 0; inode < parentChildren.getLength() - 1; ++inode) {
            if (!this.equals(parentChildren.item(inode))) continue;
            return parentChildren.item(inode + 1);
        }
        return null;
    }

    private void buildAttributes() {
        this.attributesBuilt = true;
        DrbDefaultAttributeList attrList = new DrbDefaultAttributeList();
        long sizeUncompressed = this.entry.getUncompressedSize();
        long sizeCompressed = this.entry.getCompressedSize();
        java.lang.String ratioString = null;
        boolean isDirectory = this.entry.isDirectory();
        attrList.add((Object)new DrbDefaultAttribute("size", (Value)new UnsignedLong(sizeUncompressed), true, (DrbNode)this));
        attrList.add((Object)new DrbDefaultAttribute("packed", (Value)new UnsignedLong(sizeCompressed), true, (DrbNode)this));
        if (sizeCompressed > 0L) {
            Long ratio = new Long(sizeUncompressed / sizeCompressed);
            ratioString = ratio.toString();
            ratioString = ratioString.concat(" %");
            attrList.add((Object)new DrbDefaultAttribute("ratio", (Value)new String(ratioString), true, (DrbNode)this));
        } else {
            ratioString = "0 %";
            attrList.add((Object)new DrbDefaultAttribute("ratio", (Value)new String(ratioString), true, (DrbNode)this));
        }
        attrList.add((Object)new DrbDefaultAttribute("directory", (Value)new Boolean(isDirectory), true, (DrbNode)this));
        attrList.add((Object)new DrbDefaultAttribute("compressionMethod", (Value)new Int(this.entry.getCompressionMethod()), true, (DrbNode)this));
        attrList.add((Object)new DrbDefaultAttribute("offset", (Value)new Long(this.entry.getDataOffset()), true, (DrbNode)this));
        attrList.add((Object)new DrbDefaultAttribute("compressedSize", (Value)new Long(this.entry.getCompressedSize()), true, (DrbNode)this));
        attrList.add((Object)new DrbDefaultAttribute("uncompressedSize", (Value)new Long(this.entry.getUncompressedSize()), true, (DrbNode)this));
        this.attributes = attrList;
    }

    public RemoteZipNode getRemoteZip() {
        return this.remoteZipNode;
    }

    public RemoteZipEntry getEntry() {
        return this.entry;
    }

    public DrbAttributeList getAttributes() {
        if (!this.attributesBuilt) {
            this.buildAttributes();
        }
        return this.attributes;
    }
}

