/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.zip;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.http.HttpNode;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.zip.RemoteZip;
import fr.gael.drb.zip.RemoteZipEntry;
import fr.gael.drb.zip.RemoteZipEntryNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;

public class RemoteZipNode
extends DrbNodeImpl {
    private final HttpNode baseNode;
    private final RemoteZip remoteZip;
    private DrbAttributeList attributes;
    private DrbNodeList children;
    private boolean attributesBuilt;

    public RemoteZipNode(HttpNode baseNode) {
        this.baseNode = Objects.requireNonNull(baseNode);
        this.remoteZip = new RemoteZip(Objects.requireNonNull(baseNode.getUrl()));
    }

    private void buildAttributes() {
        this.attributesBuilt = true;
        DrbAttributeList attributes = this.baseNode.getAttributes();
        if (attributes == null || attributes.getLength() == 0) {
            return;
        }
        DrbDefaultAttributeList list = new DrbDefaultAttributeList();
        for (int i = 0; i < attributes.getLength(); ++i) {
            DrbAttribute attrib = attributes.item(i);
            if (attrib == null) continue;
            list.add((Object)new DrbDefaultAttribute(attrib.getName(), attrib.getValue(), (DrbNode)this));
        }
        list.add((Object)new DrbDefaultAttribute("directory", (Value)new Boolean(true)));
        list.add((Object)new DrbDefaultAttribute("diskNumber", (Value)new Int(this.remoteZip.getDiskNumber())));
        list.add((Object)new DrbDefaultAttribute("diskCentralDirectory", (Value)new Int(this.remoteZip.getDiskCentralDirectory())));
        list.add((Object)new DrbDefaultAttribute("entriesCount", (Value)new Int(this.remoteZip.getEntriesCount())));
        list.add((Object)new DrbDefaultAttribute("totalEntriesCount", (Value)new Long(this.remoteZip.getTotalEntriesCount())));
        list.add((Object)new DrbDefaultAttribute("centralDirectorySize", (Value)new Int(this.remoteZip.getCentralDirectorySize())));
        list.add((Object)new DrbDefaultAttribute("centralDirectoryOffset", (Value)new Long(this.remoteZip.getCentralDirectoryOffset())));
        list.add((Object)new DrbDefaultAttribute("commentLength", (Value)new Int(this.remoteZip.getCommentLength())));
        list.add((Object)new DrbDefaultAttribute("comment", (Value)new String(this.remoteZip.getComment())));
        this.attributes = list;
    }

    public DrbNode getParent() {
        return this.baseNode.getParent();
    }

    public java.lang.String getName() {
        return this.baseNode.getName();
    }

    public java.lang.String getPath() {
        if (this.baseNode == null) {
            return "/";
        }
        return this.baseNode.getPath();
    }

    public int getIndex() {
        return this.baseNode.getIndex();
    }

    public DrbNodeList getChildren() {
        if (this.children != null) {
            return this.children;
        }
        DrbDefaultNodeList children = new DrbDefaultNodeList();
        ArrayList<RemoteZipEntryNode> leafChildren = new ArrayList<RemoteZipEntryNode>();
        for (RemoteZipEntry entry : this.remoteZip.getEntries().values()) {
            java.lang.String entryName;
            int slashIndex;
            if (entry == null || (slashIndex = (entryName = entry.getName()).indexOf(47)) >= 0 && entryName.length() != slashIndex + 1) continue;
            RemoteZipEntryNode zipNode = new RemoteZipEntryNode(this, entry, (DrbNode)this);
            if (entry.isDirectory()) {
                children.add((Object)zipNode);
                continue;
            }
            leafChildren.add(zipNode);
        }
        children.addAll(leafChildren);
        this.children = children;
        return children;
    }

    public DrbAttributeList getAttributes() {
        if (!this.attributesBuilt) {
            this.buildAttributes();
        }
        return this.attributes;
    }

    public boolean hasImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return this.baseNode.hasImpl(api);
        }
        return super.hasImpl(api);
    }

    public Object getImpl(Class api) {
        if (api.isAssignableFrom(InputStream.class)) {
            return this.remoteZip.getInputStream();
        }
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return this.baseNode.getImpl(api);
        }
        return super.getImpl(api);
    }

    public boolean hasChild() {
        return true;
    }

    public HttpNode getBaseNode() {
        return this.baseNode;
    }

    public RemoteZip getRemoteZip() {
        return this.remoteZip;
    }
}

