/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.zip;

import fr.gael.drb.zip.RemoteZipEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RemoteZipUtils {
    private static Logger LOGGER = LogManager.getLogger(RemoteZipUtils.class);

    private RemoteZipUtils() {
    }

    public static long readIntFromByteArray(byte[] b, int offset, int length) {
        if (length > 4) {
            LOGGER.error((Object)"Cannot read more than 4 bytes in an integer");
            return -1L;
        }
        if (offset + length > b.length) {
            LOGGER.error((Object)"Bytes to read not in the array");
            return -1L;
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result |= (long)(b[offset + i] & 0xFF) << (int)((long)(8 * i));
        }
        return result;
    }

    public static long readLongFromByteArray(byte[] b, int offset, int length) {
        if (length > 8) {
            LOGGER.error((Object)"Cannot read more than 8 bytes in a long");
            return -1L;
        }
        if (offset + length > b.length) {
            LOGGER.error((Object)"Bytes to read not in the array");
            return -1L;
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result |= (long)(b[offset + i] & 0xFF) << (int)((long)(8 * i));
        }
        return result;
    }

    public static String readStringFromByteArray(byte[] b, int offset, int length) {
        byte[] comment = Arrays.copyOfRange(b, offset, offset + length);
        try {
            return new String(comment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"Cannot read string", (Throwable)e);
            return "";
        }
    }

    public static byte[] readOneChunk(InputStream stream, int length) throws IOException {
        int read;
        byte[] b = new byte[length];
        for (int offset = 0; offset < length; offset += read) {
            read = stream.read(b, offset, length - offset);
            if (read != -1) continue;
            if (offset != 0) break;
            return b;
        }
        return b;
    }

    public static void downloadEntryAndCopyToFile(RemoteZipEntry entry, String fileName, CopyOption ... options) {
        try {
            Files.copy(entry.getInputStream(), new File(fileName).toPath(), options);
        }
        catch (IOException e) {
            LOGGER.error((Object)("An error happened while downloading entry " + entry.getName()), (Throwable)e);
        }
    }
}

