/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.gzip;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Value;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class GzipNode
extends DrbNodeImpl {
    private DrbNode baseNode;
    DrbAttributeList attrs;

    protected GzipNode(DrbNode base_node) {
        this.baseNode = base_node;
    }

    public String getName() {
        String baseName = this.baseNode.getName();
        if (baseName.toLowerCase().endsWith(".gz")) {
            return baseName.substring(0, baseName.length() - 3);
        }
        if (baseName.toLowerCase().endsWith(".tgz")) {
            return baseName.substring(0, baseName.length() - 3) + "tar";
        }
        return baseName;
    }

    public boolean hasChild() {
        return false;
    }

    public DrbNodeList getChildren() {
        return null;
    }

    public DrbAttributeList getAttributes() {
        if (this.attrs == null) {
            this.attrs = new DrbDefaultAttributeList();
            this.attrs.addItem(0, (DrbItem)new DrbDefaultAttribute("directory", (Value)new Boolean(false)));
        }
        return this.attrs;
    }

    public boolean hasImpl(Class api) {
        if (api.isAssignableFrom(InputStream.class) || api.isAssignableFrom(OutputStream.class)) {
            return true;
        }
        return super.hasImpl(api);
    }

    public Object getImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            try {
                if (api.isAssignableFrom(InputStream.class)) {
                    InputStream stream = (InputStream)((DrbNodeImpl)this.baseNode).getImpl(InputStream.class);
                    if (stream == null) {
                        return null;
                    }
                    return new GZIPInputStream(stream);
                }
                if (api.isAssignableFrom(OutputStream.class)) {
                    OutputStream stream = (OutputStream)((DrbNodeImpl)this.baseNode).getImpl(OutputStream.class);
                    if (stream == null) {
                        return null;
                    }
                    return new GZIPOutputStream(stream);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getImpl(api);
    }

    public DrbNode getParent() {
        return this.baseNode;
    }
}

