/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.zip;

import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.URLNode;
import fr.gael.drb.impl.http.HttpNode;
import fr.gael.drb.impl.spi.DrbNodeSpi;
import fr.gael.drb.impl.zip.ZipFileNode;
import fr.gael.drb.zip.RemoteZipNode;
import java.net.URL;
import org.apache.log4j.Logger;

public class ZipFactory
implements DrbFactoryImpl {
    private static Logger logger = Logger.getLogger(ZipFactory.class);

    public String getIdentifier() {
        return "zip";
    }

    public String getName() {
        return "File zip";
    }

    public DrbNode open(URL uri) {
        if (uri == null) {
            return null;
        }
        return new ZipFileNode((DrbNode)new URLNode(uri));
    }

    public DrbNode open(DrbNode base_node) {
        if (base_node == null || !(base_node instanceof DrbNodeImpl)) {
            return null;
        }
        if (base_node instanceof DrbNodeSpi) {
            DrbNodeSpi baseNodeSpi = (DrbNodeSpi)base_node;
            DrbNode baseNode = baseNodeSpi.getBaseNode();
            if (baseNode instanceof HttpNode) {
                HttpNode httpNode = (HttpNode)baseNode;
                logger.debug((Object)("Zip factory, URL base node : " + httpNode.getUrl()));
                return new RemoteZipNode(httpNode);
            }
            if (baseNode instanceof RemoteZipNode) {
                return baseNode;
            }
        }
        logger.debug((Object)("fr.gael.drb.impl.zip.ZipFactory: opening " + base_node.getPath()));
        return new ZipFileNode(base_node);
    }

    public DrbNode open(URL uri, DrbNode base_node) {
        return this.open(base_node);
    }
}

