/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.zip;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.zip.ZipNode;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Value;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.log4j.Logger;

public class ZipFileNode
extends DrbNodeImpl
implements Closeable {
    private static Logger logger = Logger.getLogger(ZipFileNode.class);
    private final DrbNode baseNode;
    private final ZipFile zipFile;
    private SortedMap<String, ZipArchiveEntry> cachedEntries = null;
    private DrbDefaultNodeList cachedChildren = null;

    public ZipFileNode(DrbNode base_node) throws IllegalArgumentException {
        if (base_node == null) {
            throw new IllegalArgumentException("Null base node.");
        }
        this.baseNode = base_node;
        ZipFile zip_file = null;
        try {
            DrbNodeImpl base_node_impl;
            File base_file = null;
            if (base_node instanceof DrbNodeImpl && (base_node_impl = (DrbNodeImpl)base_node).hasImpl(File.class)) {
                base_file = (File)base_node_impl.getImpl(File.class);
            }
            if (base_file == null) {
                base_file = new File(new URI(base_node.getPath()));
            }
            if (base_file != null) {
                zip_file = new ZipFile(base_file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.zipFile = zip_file;
    }

    public String getPath() {
        if (this.baseNode == null) {
            return "/";
        }
        return this.baseNode.getPath();
    }

    SortedMap<String, ZipArchiveEntry> getEntries() {
        if (this.cachedEntries != null) {
            return this.cachedEntries;
        }
        SortedMap<String, ZipArchiveEntry> entries = Collections.synchronizedSortedMap(new TreeMap());
        if (this.zipFile != null) {
            Enumeration entries_enumeration = this.zipFile.getEntries();
            while (entries_enumeration.hasMoreElements()) {
                ZipArchiveEntry current_entry = (ZipArchiveEntry)entries_enumeration.nextElement();
                if (current_entry == null) continue;
                this.cacheEntry(entries, current_entry.getName(), current_entry);
            }
        } else {
            ZipArchiveEntry current_entry = null;
            DrbNodeImpl baseImpl = (DrbNodeImpl)this.baseNode;
            InputStream base_stream = (InputStream)baseImpl.getImpl(InputStream.class);
            ZipArchiveInputStream zip_stream = new ZipArchiveInputStream(base_stream);
            try {
                while ((current_entry = zip_stream.getNextZipEntry()) != null) {
                    this.cacheEntry(entries, current_entry.getName(), current_entry);
                    if (current_entry != null) continue;
                }
                base_stream.close();
                zip_stream.close();
            }
            catch (IOException e) {
                Object var2_3 = null;
            }
        }
        this.checkEntries(entries);
        this.cachedEntries = entries;
        return this.cachedEntries;
    }

    void checkEntries(Map<String, ZipArchiveEntry> entries) {
        HashMap<String, ZipArchiveEntry> map = new HashMap<String, ZipArchiveEntry>();
        for (String full_path : entries.keySet()) {
            boolean is_file = true;
            String path = "";
            if (full_path.endsWith("/")) {
                is_file = false;
            }
            String[] directories = full_path.split("/");
            for (int index = 0; index < directories.length - (is_file ? 1 : 0); ++index) {
                if (entries.containsKey(path = path + directories[index] + "/")) continue;
                ZipArchiveEntry zae = new ZipArchiveEntry(path);
                map.put(path, zae);
                logger.info((Object)("Add Folder \"" + path + "\""));
            }
        }
        if (!map.isEmpty()) {
            entries.putAll(map);
        }
    }

    private void cacheEntry(SortedMap<String, ZipArchiveEntry> entries, String path, ZipArchiveEntry entry) {
        String new_path;
        int index = path.lastIndexOf(47);
        if (index > 0 && index < path.length() - 1 && !entries.containsKey(new_path = path.substring(0, index + 1))) {
            ZipArchiveEntry zae = new ZipArchiveEntry(new_path);
            this.cacheEntry(entries, new_path, zae);
        }
        entries.put(path, entry);
    }

    public String getName() {
        return this.baseNode.getName();
    }

    public int getIndex() {
        return this.baseNode.getIndex();
    }

    public DrbNode getParent() {
        return this.baseNode.getParent();
    }

    public DrbNodeList getChildren() {
        if (this.cachedChildren != null) {
            return this.cachedChildren;
        }
        DrbDefaultNodeList children = new DrbDefaultNodeList();
        ArrayList<ZipNode> leaf_children = new ArrayList<ZipNode>();
        for (ZipArchiveEntry currententry : this.getEntries().values()) {
            String entry_name;
            int slash_index;
            if (currententry == null || (slash_index = (entry_name = currententry.getName()).indexOf(47)) >= 0 && entry_name.length() != slash_index + 1) continue;
            ZipNode zip_node = new ZipNode(this, currententry, (DrbNode)this);
            if (currententry.isDirectory()) {
                children.add((Object)zip_node);
                continue;
            }
            leaf_children.add(zip_node);
        }
        children.addAll(leaf_children);
        this.cachedChildren = children;
        return this.cachedChildren;
    }

    public final DrbAttributeList getAttributes() {
        DrbAttributeList attributes = this.baseNode.getAttributes();
        if (attributes == null || attributes.getLength() == 0) {
            return null;
        }
        DrbDefaultAttributeList list = new DrbDefaultAttributeList();
        for (int i = 0; i < attributes.getLength(); ++i) {
            DrbAttribute attrib = attributes.item(i);
            if (attrib == null) continue;
            list.add((Object)new DrbDefaultAttribute(attrib.getName(), attrib.getValue(), (DrbNode)this));
        }
        list.add((Object)new DrbDefaultAttribute("directory", (Value)new Boolean(true)));
        return list;
    }

    InputStream getInputstream(ZipArchiveEntry zip_entry) {
        if (zip_entry == null) {
            logger.error((Object)"Invalid null ZIP entry");
            return null;
        }
        if (this.zipFile != null) {
            try {
                return new BufferedInputStream(new ZipBoundedInputStream(this.zipFile.getInputStream(zip_entry), zip_entry.getSize())){

                    protected void finalize() throws Throwable {
                        IOUtils.closeQuietly((Closeable)this);
                        super.finalize();
                    }
                };
            }
            catch (Exception exception) {
                logger.error((Object)("Cannot derive input stream from ZIP file \"" + this.baseNode.getName() + "\""), (Throwable)exception);
                return null;
            }
        }
        ZipArchiveInputStream zip_stream = new ZipArchiveInputStream((InputStream)this.getImpl(InputStream.class)){

            protected void finalize() throws Throwable {
                try {
                    this.close();
                }
                catch (IOException e) {
                    logger.warn((Object)"Cannot close zip stream !");
                }
                super.finalize();
            }
        };
        try {
            ZipArchiveEntry currentEntry;
            do {
                if ((currentEntry = zip_stream.getNextZipEntry()) != null) continue;
                logger.error((Object)("Cannot retrieve stream entry for \"" + zip_entry.getName() + "\""));
                return null;
            } while (!currentEntry.getName().equals(zip_entry.getName()));
            return zip_stream;
        }
        catch (IOException exception) {
            logger.error((Object)("Cannot derive input stream from base stream \"" + this.baseNode.getName() + "\""), (Throwable)exception);
            logger.error((Object)("Invalid state: cannot derive input stream from either ZIP file or from a base stream \"" + this.baseNode.getName() + "\""));
            return null;
        }
    }

    public boolean hasImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).hasImpl(api);
        }
        return super.hasImpl(api);
    }

    public Object getImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).getImpl(api);
        }
        return super.getImpl(api);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean deep) {
        if (deep && this.cachedChildren != null) {
            for (int index = 0; index < this.cachedChildren.getLength(); ++index) {
                DrbNode node = this.cachedChildren.item(index);
                if (node == null || !(node instanceof DrbNodeImpl)) continue;
                ((DrbNodeImpl)DrbNodeImpl.class.cast(node)).close(deep);
            }
        }
        ZipFile.closeQuietly((ZipFile)this.zipFile);
    }

    public boolean hasChild() {
        return true;
    }

    class ZipBoundedInputStream
    extends InputStream {
        private final InputStream in;
        private long bytesRemaining;

        public ZipBoundedInputStream(InputStream in, long size) {
            this.in = in;
            this.bytesRemaining = size;
        }

        @Override
        public int read() throws IOException {
            if (this.bytesRemaining <= 0L) {
                return -1;
            }
            int res = this.in.read();
            if (res != -1) {
                --this.bytesRemaining;
            }
            return res;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead;
            if (this.bytesRemaining <= 0L) {
                return -1;
            }
            int bytesToRead = len;
            if ((long)bytesToRead > this.bytesRemaining) {
                bytesToRead = (int)this.bytesRemaining;
            }
            if ((bytesRead = this.in.read(b, off, bytesToRead)) >= 0) {
                this.bytesRemaining -= (long)bytesRead;
            }
            return bytesRead;
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
            }
        }

        @Override
        public int available() {
            return new Long(this.bytesRemaining).intValue();
        }
    }
}

