/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.zip;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.zip.ZipFileNode;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.Value;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class ZipNode
extends DrbNodeImpl {
    private final ZipArchiveEntry zipEntry;
    private final ZipFileNode zipFileNode;
    private final DrbNode parent;
    private java.lang.String cachedName = null;
    private DrbDefaultNodeList cachedChildren = null;

    ZipNode(ZipFileNode zipfilen, ZipArchiveEntry zipentry, DrbNode parent) {
        this.zipEntry = zipentry;
        this.zipFileNode = zipfilen;
        this.parent = parent;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ZipNode) {
            ZipNode zip_node = (ZipNode)((Object)obj);
            boolean eq = this.zipFileNode == zip_node.zipFileNode && this.zipEntry.getName().equals(zip_node.zipEntry.getName());
            return eq;
        }
        return false;
    }

    public java.lang.String getName() {
        int separator_index;
        if (this.cachedName != null) {
            return this.cachedName;
        }
        java.lang.String entry_path = this.zipEntry.getName();
        if (entry_path.endsWith("/")) {
            entry_path = entry_path.substring(0, entry_path.length() - 1);
        }
        if ((separator_index = entry_path.lastIndexOf("/")) >= 0) {
            entry_path = entry_path.substring(separator_index + 1);
        }
        this.cachedName = entry_path;
        return this.cachedName;
    }

    public boolean allowsMultiOccurrence() {
        return false;
    }

    public boolean hasChild() {
        return this.getChildrenCount() != 0;
    }

    public DrbNodeList getChildren() {
        if (this.cachedChildren != null) {
            return this.cachedChildren;
        }
        DrbDefaultNodeList list = new DrbDefaultNodeList();
        ArrayList<ZipNode> leaf_children = new ArrayList<ZipNode>();
        java.lang.String node_entry_name = this.zipEntry.getName();
        SortedMap<java.lang.String, ZipArchiveEntry> trailing_map = this.zipFileNode.getEntries().tailMap(this.zipEntry.getName());
        boolean self_entry_skipped = false;
        for (ZipArchiveEntry currententry : trailing_map.values()) {
            if (!self_entry_skipped) {
                self_entry_skipped = true;
                continue;
            }
            java.lang.String current_name = currententry.getName();
            if (!current_name.startsWith(node_entry_name)) break;
            java.lang.String trailing_path = current_name.substring(node_entry_name.length());
            int slash_index = trailing_path.indexOf(47);
            if (slash_index >= 0 && trailing_path.length() != slash_index + 1) continue;
            ZipNode zip_node = new ZipNode(this.zipFileNode, currententry, (DrbNode)this);
            if (currententry.isDirectory()) {
                list.add((Object)zip_node);
                continue;
            }
            leaf_children.add(zip_node);
        }
        list.addAll(leaf_children);
        this.cachedChildren = list;
        return this.cachedChildren;
    }

    public boolean hasImpl(Class api) {
        if (api.isAssignableFrom(InputStream.class)) {
            return !this.zipEntry.isDirectory();
        }
        if (api.isAssignableFrom(ZipFile.class)) {
            return true;
        }
        return super.hasImpl(api);
    }

    public Object getImpl(Class api) {
        if (api.isAssignableFrom(InputStream.class)) {
            try {
                return this.zipFileNode.getInputstream(this.zipEntry);
            }
            catch (Exception e) {
                return null;
            }
        }
        return super.getImpl(api);
    }

    protected ZipArchiveEntry getZipEntry() {
        return this.zipEntry;
    }

    protected ZipFileNode getZipFileNode() {
        return this.zipFileNode;
    }

    public DrbNode getParent() {
        return this.parent;
    }

    public final DrbAttributeList getAttributes() {
        DrbDefaultAttribute attr = null;
        DrbDefaultAttributeList attrList = new DrbDefaultAttributeList();
        attr = new DrbDefaultAttribute("size", (Value)new UnsignedLong(this.zipEntry.getSize()), true, (DrbNode)this);
        attrList.add((Object)attr);
        long sizeCompressed = this.zipEntry.getCompressedSize();
        java.lang.String ratioString = null;
        boolean is_directory = this.zipEntry.isDirectory();
        if (sizeCompressed > 0L) {
            Long ratio = new Long(this.zipEntry.getSize() / this.zipEntry.getCompressedSize());
            ratioString = ratio.toString();
            ratioString = ratioString.concat(" %");
            attr = new DrbDefaultAttribute("ratio", (Value)new String(ratioString), true, (DrbNode)this);
        } else {
            ratioString = "0 %";
            attr = new DrbDefaultAttribute("ratio", (Value)new String(ratioString), true, (DrbNode)this);
        }
        attrList.add((Object)attr);
        attr = new DrbDefaultAttribute("packed", (Value)new UnsignedLong(sizeCompressed), true, (DrbNode)this);
        attrList.add((Object)attr);
        attr = new DrbDefaultAttribute("directory", (Value)new Boolean(is_directory), true, (DrbNode)this);
        attrList.add((Object)attr);
        return attrList;
    }

    public void close(boolean deep) {
        this.zipFileNode.close(false);
        super.close(deep);
    }
}

