/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.tiff;

import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.tiff.TiffFieldNode;
import fr.gael.drb.impl.tiff.TiffNode;
import it.geosolutions.imageio.plugins.tiff.TIFFDirectory;
import it.geosolutions.imageio.plugins.tiff.TIFFField;

public class TiffDirectoryNode
extends TiffNode {
    TIFFDirectory tiffDirectory = null;

    public TiffDirectoryNode() {
        super("tiff_directory_node");
    }

    public TiffDirectoryNode(String name, TIFFDirectory tiff_directory, DrbNode parent, int index, DrbNode previous_sibling, DrbNode next_sibling) {
        super(name, parent, index, previous_sibling, next_sibling);
        this.tiffDirectory = tiff_directory;
    }

    private void initChildren() {
        TIFFField[] fields = this.tiffDirectory.getTIFFFields();
        if (fields != null) {
            int length = fields.length;
            if (length <= 0) {
                return;
            }
            this.children = new DrbDefaultNodeList();
            int current_field_index = 0;
            for (int i_field = 0; i_field < length; ++i_field) {
                if (fields[i_field].getCount() == 0) continue;
                this.children.addItem(this.children.getLength(), (DrbItem)new TiffFieldNode(fields[i_field].getTag().getName(), fields[i_field], (DrbNode)this, current_field_index, null, null));
                ++current_field_index;
            }
        }
    }

    @Override
    public DrbNodeList getChildren() {
        if (this.children == null) {
            this.initChildren();
        }
        return super.getChildren();
    }

    public boolean hasChild() {
        return this.children != null && this.children.getLength() > 0 || this.tiffDirectory.getTIFFFields() != null;
    }

    public DrbNode getNamedChild(String name, int occurence) {
        if (this.children == null) {
            this.initChildren();
        }
        return super.getNamedChild(name, occurence);
    }

    public DrbNode getFirstChild() {
        if (this.children == null) {
            this.initChildren();
        }
        return super.getFirstChild();
    }

    public DrbNode getLastChild() {
        if (this.children == null) {
            this.initChildren();
        }
        return super.getLastChild();
    }

    public int getChildrenCount() {
        if (this.children != null) {
            return super.getChildrenCount();
        }
        TIFFField[] fields = this.tiffDirectory.getTIFFFields();
        if (fields != null) {
            return fields.length;
        }
        return 0;
    }
}

