/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.spi.DrbNodeSpi;
import fr.gael.drb.impl.tiff.TiffDirectoryNode;
import fr.gael.drb.impl.tiff.TiffNode;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import it.geosolutions.imageio.plugins.tiff.TIFFDirectory;
import it.geosolutions.imageio.plugins.tiff.TIFFField;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.stream.FileImageInputStream;
import org.apache.log4j.Logger;

public class TiffFactory
implements DrbFactoryImpl {
    private static Logger logger;

    public java.lang.String getIdentifier() {
        return "tiff";
    }

    public java.lang.String getName() {
        return "Tag Image File Format (TIFF)";
    }

    public DrbNode open(URL uri) {
        return null;
    }

    public DrbNode open(DrbNode base_node) {
        if (base_node == null || !(base_node instanceof DrbNodeImpl)) {
            return null;
        }
        DrbNodeImpl base_impl = (DrbNodeImpl)base_node;
        File file = (File)base_impl.getImpl(File.class);
        if (file == null) {
            return null;
        }
        TiffNode tiff_node = new TiffNode("tiff", base_node, 0, null, null);
        int current_directory_index = 0;
        TIFFDirectory dir = null;
        Iterator<ImageReader> readers = ImageIO.getImageReaders(file);
        if (!readers.hasNext()) {
            readers = ImageIO.getImageReadersByFormatName("tiff");
        }
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            try {
                logger.debug((Object)(" - " + reader.getFormatName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                FileImageInputStream stream = new FileImageInputStream(file);
                reader.setInput(stream);
                for (int index = 0; index < reader.getNumImages(true); ++index) {
                    IIOMetadata metadata = reader.getImageMetadata(index);
                    dir = TIFFDirectory.createFromMetadata((IIOMetadata)metadata);
                    if (logger.isDebugEnabled()) {
                        TIFFField[] fields;
                        for (TIFFField field : fields = dir.getTIFFFields()) {
                            logger.debug((Object)("  " + field.getTagNumber() + " -> " + field.getTag().getName() + " : " + (field.getData() != null ? field.getValueAsString(0) : "")));
                        }
                    }
                    tiff_node.appendChild((DrbNode)new TiffDirectoryNode("tiff_directory", dir, base_node, current_directory_index, null, null));
                }
                TiffNode byteOrderNode = new TiffNode("ByteOrder");
                if (ByteOrder.BIG_ENDIAN.equals(stream.getByteOrder())) {
                    byteOrderNode.setValue((Value)new String("big endian"));
                } else {
                    byteOrderNode.setValue((Value)new String("little endian"));
                }
                tiff_node.appendChild((DrbNode)byteOrderNode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            return DrbNodeSpi.getDrb250FileNodeFromImplNode((DrbNode)tiff_node, (DrbNode)base_node);
        }
        catch (NoSuchMethodError e) {
            return tiff_node;
        }
    }

    public DrbNode open(URL uri, DrbNode base_node) {
        return this.open(base_node);
    }

    static {
        Object provider;
        Iterator<?> providers;
        Class<?> category;
        logger = Logger.getLogger(TiffFactory.class);
        Object reader = null;
        Object writer = null;
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<Class<?>> it = registry.getCategories();
        while (it.hasNext()) {
            category = it.next();
            logger.debug((Object)("  - Category \"" + category.getCanonicalName() + "\" :"));
            providers = registry.getServiceProviders(category, false);
            while (providers.hasNext()) {
                provider = providers.next();
                logger.debug((Object)("     -> " + provider.getClass().getCanonicalName()));
                if (provider.getClass().equals(TIFFImageReaderSpi.class)) {
                    reader = provider;
                }
                if (!provider.getClass().equals(TIFFImageWriterSpi.class)) continue;
                writer = provider;
            }
        }
        if (reader != null) {
            logger.debug((Object)"com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi  --> removed <++");
            IIORegistry.getDefaultInstance().deregisterServiceProvider(reader);
        }
        if (writer != null) {
            logger.debug((Object)"com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriterSpi  --> removed <++");
            IIORegistry.getDefaultInstance().deregisterServiceProvider(writer);
        }
        if (logger.isDebugEnabled()) {
            registry = IIORegistry.getDefaultInstance();
            it = registry.getCategories();
            while (it.hasNext()) {
                category = it.next();
                logger.debug((Object)("  - Category \"" + category.getCanonicalName() + "\" :"));
                providers = registry.getServiceProviders(category, false);
                while (providers.hasNext()) {
                    provider = providers.next();
                    logger.debug((Object)("     -> " + provider.getClass().getCanonicalName()));
                }
            }
        }
    }
}

