/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.tiff;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.tiff.TiffNode;
import fr.gael.drb.impl.tiff.TiffProperties;
import fr.gael.drb.value.Byte;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.Float;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.LongArray;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedByte;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.UnsignedLongArray;
import fr.gael.drb.value.UnsignedShort;
import fr.gael.drb.value.Value;
import it.geosolutions.imageio.plugins.tiff.TIFFField;
import org.apache.log4j.Logger;

public class TiffFieldNode
extends TiffNode {
    private static Logger logger = Logger.getLogger(TiffFieldNode.class);
    TIFFField field = null;
    int indexInOccurrence = -1;

    public TiffFieldNode() {
        super("field_node");
    }

    public TiffFieldNode(java.lang.String name, TIFFField tiff_field, DrbNode parent, int index, DrbNode previous_sibling, DrbNode next_sibling) {
        super(name, parent, index, previous_sibling, next_sibling);
        this.field = tiff_field;
        this.indexInOccurrence = 0;
        if (this.field.getCount() > 1) {
            this.initChildrenList();
        }
        this.initializeAttributes();
        this.rename(this.computeName());
    }

    public TiffFieldNode(java.lang.String name, TIFFField field, DrbNode parent, int index, int index_in_occurrence, DrbNode previous_sibling, DrbNode next_sibling) {
        super(name, parent, index, previous_sibling, next_sibling);
        this.field = field;
        this.indexInOccurrence = index_in_occurrence;
        this.initializeAttributes();
        this.rename(this.computeName());
    }

    public TiffFieldNode(TIFFField field, DrbNode parent, int index, int index_in_occurrence) {
        super(null, parent, index, null, null);
        this.field = field;
        this.indexInOccurrence = index_in_occurrence;
        this.initializeAttributes();
        this.rename(this.computeName());
    }

    private void initChildrenList() {
        int field_count = this.field.getCount();
        this.children = new DrbDefaultNodeList();
        for (int i_field_occurrence = 0; i_field_occurrence < field_count; ++i_field_occurrence) {
            this.children.addItem(this.children.getLength(), (DrbItem)new TiffFieldNode("value", this.field, (DrbNode)this, i_field_occurrence, i_field_occurrence, null, null));
        }
    }

    public void initializeAttributes() {
        int tag_id = this.field.getTag().getNumber();
        DrbDefaultAttributeList attribute_list = new DrbDefaultAttributeList();
        DrbDefaultAttribute attribute = new DrbDefaultAttribute("encoding", (Value)new String("Binary"), false, (DrbNode)this);
        attribute_list.add((Object)attribute);
        int occurrence = this.indexInOccurrence;
        if (occurrence > 0) {
            String string_value = new String(occurrence + 1 + "/" + this.field.getCount());
            attribute = new DrbDefaultAttribute("occurrence", (Value)string_value, false, (DrbNode)this);
            attribute_list.add((Object)attribute);
        }
        attribute = new DrbDefaultAttribute("id", (Value)new Int(tag_id), false, (DrbNode)this);
        attribute_list.add((Object)attribute);
        java.lang.String tmp_string = this.getTypeName();
        if (tmp_string != null) {
            attribute = new DrbDefaultAttribute("type", (Value)new String(tmp_string), false, (DrbNode)this);
            attribute_list.add((Object)attribute);
        }
        if ((tmp_string = this.getUnitaryTypeLength()) != null) {
            attribute = new DrbDefaultAttribute("bitLength", (Value)new String(tmp_string), false, (DrbNode)this);
            attribute_list.add((Object)attribute);
        }
        this.setAttributes((DrbAttributeList)attribute_list);
    }

    public int getOccurrence() {
        return this.indexInOccurrence;
    }

    @Override
    public int getValueType() {
        if (this.hasChild()) {
            return -1;
        }
        int type = this.field.getType();
        int value_type = -1;
        switch (type) {
            case 2: {
                value_type = 7;
                break;
            }
            case 1: {
                value_type = 12;
                break;
            }
            case 3: {
                value_type = 13;
                break;
            }
            case 4: {
                value_type = 15;
                break;
            }
            case 5: {
                value_type = 10;
                break;
            }
            case 6: {
                value_type = 1;
                break;
            }
            case 8: {
                value_type = 2;
                break;
            }
            case 9: {
                value_type = 4;
                break;
            }
            case 10: {
                value_type = 10;
                break;
            }
            case 11: {
                value_type = 5;
                break;
            }
            case 12: {
                value_type = 6;
                break;
            }
            case 7: {
                value_type = 1;
            }
        }
        return value_type;
    }

    public java.lang.String getUnitaryTypeLength() {
        int type = this.field.getType();
        java.lang.String length = null;
        switch (type) {
            case 2: {
                break;
            }
            case 1: {
                length = "8";
                break;
            }
            case 3: {
                length = "16";
                break;
            }
            case 4: {
                length = "32";
                break;
            }
            case 5: {
                length = "32";
                break;
            }
            case 6: {
                length = "8";
                break;
            }
            case 8: {
                length = "16";
                break;
            }
            case 9: {
                length = "32";
                break;
            }
            case 10: {
                length = "32";
                break;
            }
            case 11: {
                length = "32";
                break;
            }
            case 12: {
                length = "64";
                break;
            }
            case 7: {
                length = "8";
            }
        }
        return length;
    }

    public java.lang.String getTypeName() {
        return TIFFField.getTypeName((int)this.field.getType());
    }

    @Override
    public Value getValue() {
        if (this.hasChild()) {
            return null;
        }
        int type = this.field.getType();
        String value = null;
        int index = 0;
        if (this.indexInOccurrence >= 0) {
            index = this.indexInOccurrence;
        }
        try {
            switch (type) {
                case 2: {
                    value = new String(this.field.getAsString(0));
                    break;
                }
                case 1: {
                    value = new UnsignedByte(this.field.getAsInt(index));
                    break;
                }
                case 3: {
                    value = new UnsignedShort(this.field.getAsInt(index));
                    break;
                }
                case 4: {
                    value = new UnsignedLong(this.field.getAsLong(index));
                    break;
                }
                case 5: {
                    value = new UnsignedLongArray(this.field.getAsRational(index));
                    break;
                }
                case 6: {
                    value = new Byte(this.field.getAsInt(index));
                    break;
                }
                case 8: {
                    value = new Short(this.field.getAsInt(index));
                    break;
                }
                case 9: {
                    value = new Long(this.field.getAsLong(index));
                    break;
                }
                case 10: {
                    value = new LongArray(this.field.getAsRational(index));
                    break;
                }
                case 11: {
                    value = new Float(this.field.getAsFloat(index));
                    break;
                }
                case 12: {
                    value = new Double(this.field.getAsDouble(index));
                    break;
                }
                case 7: {
                    value = new Byte(this.field.getAsInt(index));
                    break;
                }
                default: {
                    logger.error((Object)("TIFF Type \"" + TIFFField.getTypeName((int)type) + "\" not managed."));
                    break;
                }
            }
        }
        catch (ClassCastException exception) {
            exception.printStackTrace();
            return null;
        }
        return value;
    }

    @Override
    public DrbNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getChildAt(this.getIndex() - 1);
    }

    @Override
    public DrbNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getChildAt(this.getIndex() + 1);
    }

    private java.lang.String computeName() {
        if (!this.hasChild() && this.field.getCount() > 1) {
            return "value";
        }
        int tag_id = this.field.getTag().getNumber();
        java.lang.String tag_id_string = "" + tag_id;
        java.lang.String name = TiffProperties.getTagName(tag_id_string);
        if (name != null || (name = this.field.getTag().getName()) != null) {
            return name;
        }
        return "tiff_node_" + tag_id;
    }
}

