/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.tiff;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbNodesChangeEvent;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.value.Value;
import org.apache.log4j.Logger;

public class TiffNode
extends DrbNodeImpl {
    private String name;
    private String namespaceURI;
    protected DrbNode parent;
    private DrbAttributeList attributes;
    protected Value value;
    private int index;
    protected DrbNodeList children;
    private DrbNode previousSibling;
    private DrbNode nextSibling;
    private static Logger logger = Logger.getLogger(TiffNode.class);

    public TiffNode(String name) {
        this.name = name;
        this.index = 0;
    }

    public TiffNode(String name, DrbNode parent, int index, DrbNode previous_sibling, DrbNode next_sibling) {
        this.name = name;
        this.index = index;
        this.parent = parent;
        this.previousSibling = previous_sibling;
        this.nextSibling = next_sibling;
    }

    public String getName() {
        return this.name;
    }

    public void rename(String name) throws NullPointerException, UnsupportedOperationException {
        if (name == null) {
            throw new NullPointerException("TiffNode.rename() : The reference to the new name is null.");
        }
        this.name = name;
        this.nodesChanged(new DrbNodesChangeEvent((DrbNode)this));
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        if (namespace_uri == null) {
            throw new NullPointerException("TiffNode.setNamespaceURI() : The reference to the nameapce URI is null.");
        }
        this.namespaceURI = namespace_uri;
        this.nodesChanged(new DrbNodesChangeEvent((DrbNode)this));
    }

    public int getValueType() {
        if (this.value != null) {
            return this.value.getType();
        }
        return -1;
    }

    public Value getValue() {
        return this.value;
    }

    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        if (value == null) {
            throw new NullPointerException("TiffNode.setValue() : The reference to the value to assign is null.");
        }
        this.value = value;
        this.nodesChanged(new DrbNodesChangeEvent((DrbNode)this));
        return value;
    }

    public DrbAttributeList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(DrbAttributeList attributes) throws NullPointerException, UnsupportedOperationException {
        if (attributes == null) {
            throw new NullPointerException("TiffNode.setAttributes() : The reference to the attributes is null.");
        }
        this.attributes = attributes;
        this.nodesChanged(new DrbNodesChangeEvent((DrbNode)this));
    }

    public DrbNode getParent() {
        return this.parent;
    }

    public void setParent(DrbNode parent) {
        this.parent = parent;
    }

    public DrbNodeList getChildren() {
        return this.children;
    }

    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        if (node == null) {
            throw new NullPointerException("TiffNode.appendChild() : The reference to the node to append is null.");
        }
        if (this.children == null) {
            this.children = new DrbDefaultNodeList();
        }
        this.children.addItem(this.children.getLength(), (DrbItem)node);
        if (!(node instanceof TiffNode)) {
            throw new UnsupportedOperationException("TiffNode.appendChild() :Cannot insert a non TiffNode.");
        }
        TiffNode new_node = (TiffNode)node;
        new_node.setParent((DrbNode)this);
        int node_index = this.children.getLength() - 1;
        new_node.setIndex(node_index);
        if (node_index > 0) {
            new_node.setPreviousSibling(this.children.item(node_index - 1));
        } else {
            new_node.setPreviousSibling(null);
        }
        new_node.setNextSibling(null);
        DrbDefaultNodeList node_list = new DrbDefaultNodeList();
        node_list.addItem((DrbItem)new_node);
        this.nodesInserted(new DrbNodesChangeEvent((DrbNode)this, (DrbNodeList)node_list));
        return new_node;
    }

    public DrbNode insertChild(DrbNode node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        if (node == null) {
            throw new NullPointerException("TiffNode.insertChild() : The reference to the node to append is null.");
        }
        if (index < 0 || this.children == null && index != 0 || this.children != null && index > this.children.getLength()) {
            throw new IndexOutOfBoundsException("TiffNode.insertChild() : Invalid requested index (children count=" + (this.children != null ? this.children.getLength() : 0) + ", index=" + index);
        }
        if (!(node instanceof TiffNode)) {
            throw new UnsupportedOperationException("TiffNode.insertChild() :Cannot duplicate input tree.");
        }
        TiffNode new_node = (TiffNode)node;
        if (this.children == null) {
            this.children = new DrbDefaultNodeList();
        }
        try {
            this.children.addItem(index, (DrbItem)new_node);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("TiffNode.insertChild() : " + e + "\nThe index had however already been checked !?");
        }
        new_node.setParent((DrbNode)this);
        new_node.setIndex(index);
        if (index > 0) {
            new_node.setPreviousSibling(this.children.item(index - 1));
        } else {
            new_node.setPreviousSibling(null);
        }
        if (index < this.children.getLength() - 2) {
            new_node.setNextSibling(this.children.item(index + 1));
        } else {
            new_node.setNextSibling(null);
        }
        for (int ichild = index + 1; ichild < this.children.getLength(); ++ichild) {
            TiffNode next_sibling = (TiffNode)this.children.item(ichild);
            if (next_sibling != null) {
                next_sibling.setIndex(ichild);
                continue;
            }
            logger.error((Object)("TiffNode.insertChild() : Warning : Cannot set index of the next sibling #" + ichild));
        }
        DrbDefaultNodeList node_list = new DrbDefaultNodeList();
        node_list.add((Object)new_node);
        this.nodesInserted(new DrbNodesChangeEvent((DrbNode)this, (DrbNodeList)node_list));
        return new_node;
    }

    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        TiffNode removed_child;
        try {
            if (this.children == null) {
                throw new IndexOutOfBoundsException("TiffNode.removeChild() : No child to removed (index = " + index + ").");
            }
            removed_child = (TiffNode)this.children.item(index);
            this.children.removeItem(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new UnsupportedOperationException("TiffNode.removeChild() : " + e);
        }
        TiffNode previous_sibling = (TiffNode)removed_child.getPreviousSibling();
        TiffNode next_sibling = (TiffNode)removed_child.getNextSibling();
        if (previous_sibling != null) {
            previous_sibling.setNextSibling((DrbNode)next_sibling);
        }
        if (next_sibling != null) {
            next_sibling.setPreviousSibling((DrbNode)previous_sibling);
        }
        for (TiffNode child = next_sibling; child != null; child = (TiffNode)child.getNextSibling()) {
            child.setIndex(child.getIndex() - 1);
        }
        DrbDefaultNodeList node_list = new DrbDefaultNodeList();
        node_list.add((Object)removed_child);
        this.nodesRemoved(new DrbNodesChangeEvent((DrbNode)this, (DrbNodeList)node_list));
    }

    public DrbNode replaceChild(int index, DrbNode node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        if (node == null) {
            throw new NullPointerException("TiffNode.replaceChild() : Reference to the node is null.");
        }
        TiffNode replacing_node = null;
        try {
            this.removeChild(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("TiffNode.replaceChild() : " + e + "\n   Unable to remove node because the index is outside range.");
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("TiffNode.replaceChild() : " + e + "\n   This exception should never be thrown !!!\n   The children list may be inconsistent.");
        }
        try {
            replacing_node = (TiffNode)this.insertChild(node, index);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("TiffNode.replaceChild() : " + e + "\n   Unable to insert a null child.\n   This exception should never be thrown !!!");
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("TiffNode.replaceChild() : " + e + "\n   Unable to insert the child at the position #" + index + ".\n   This exception should never be thrown !!!");
        }
        catch (UnsupportedOperationException e) {
            throw new IndexOutOfBoundsException("TiffNode.replaceChild() : " + e + "\n   Unable to insert the child for unknown reason.\n   This exception should never be thrown !!!");
        }
        DrbDefaultNodeList node_list = new DrbDefaultNodeList();
        node_list.add((Object)replacing_node);
        this.structureChanged(new DrbNodesChangeEvent((DrbNode)this, (DrbNodeList)node_list));
        return replacing_node;
    }

    public DrbNode getPreviousSibling() {
        return this.previousSibling;
    }

    private void setPreviousSibling(DrbNode previous_sibling) {
        this.previousSibling = previous_sibling;
    }

    public DrbNode getNextSibling() {
        return this.nextSibling;
    }

    private void setNextSibling(DrbNode next_sibling) {
        this.nextSibling = next_sibling;
    }

    public boolean isSame(DrbNode node) {
        return node == this;
    }

    public String toString() {
        String output_string = "<" + this.getName() + ">\n";
        if (this.getValue() != null) {
            output_string = output_string + "   " + this.getValue() + "\n";
        }
        if (this.children != null) {
            for (int ichild = 0; ichild < this.children.getLength(); ++ichild) {
                output_string = output_string + this.children.item(ichild);
            }
        }
        output_string = output_string + "</" + this.getName() + ">\n";
        return output_string;
    }
}

