/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.tiff;

import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.Query;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Value;
import java.net.URL;
import org.apache.log4j.Logger;

public final class TiffProperties {
    private static Logger logger = Logger.getLogger(TiffProperties.class);
    private static final String PROPERTIES_FILE = "fr/gael/drb/impl/tiff/geotiff_properties.xml";
    private static DrbNode propertyNode = null;

    public static void initProperties(boolean force) {
        if (force) {
            propertyNode = null;
        }
        TiffProperties.initProperties();
    }

    private static void initProperties() {
        if (propertyNode != null) {
            return;
        }
        try {
            URL properties_url = TiffProperties.class.getClassLoader().getResource(PROPERTIES_FILE);
            DrbNode file = DrbFactory.openURI((String)properties_url.toString());
            if (file != null) {
                propertyNode = file.getFirstChild();
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Warning : Cannot use resource 'fr/gael/drb/impl/tiff/geotiff_properties.xml'");
            exception.printStackTrace();
        }
    }

    protected static Value getValueForQuery(String query_string) {
        if (propertyNode == null) {
            TiffProperties.initProperties();
        }
        if (query_string == null || propertyNode == null) {
            logger.error((Object)("TiffProperties.getValueForString() : Invalid parameters : query_string=" + query_string + ", propertyNode=" + propertyNode));
            return null;
        }
        try {
            Query query = new Query(query_string);
            DrbSequence result = query.evaluate((DrbItem)propertyNode);
            if (result == null || result.getLength() <= 0) {
                return null;
            }
            return result.getItem(0).getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected static String getTagName(String tag_id) {
        if (tag_id == null) {
            logger.error((Object)("TiffProperties.getTagName() : Invalid parameter : tag_id=" + tag_id));
            return null;
        }
        Value value_node = TiffProperties.getValueForQuery("./tag[@id=\"" + tag_id + "\"]/@name");
        if (value_node == null) {
            return null;
        }
        return value_node.toString();
    }

    protected static int getIntValue(String name) {
        if (name == null) {
            logger.error((Object)("TiffProperties.getIntValue() : Invalid parameters : name=" + name));
            return -1;
        }
        Value value_node = TiffProperties.getValueForQuery("./tag[@name=\"" + name + "\"]/@id");
        if (value_node == null) {
            return -1;
        }
        try {
            if (value_node.convertTo(3) == null) {
                return -1;
            }
            return ((Int)value_node.convertTo(3)).intValue();
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

