/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.tiff;

import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.tiff.TiffNode;
import fr.gael.drb.impl.tiff.TiffRasterNodeList;
import fr.gael.drb.value.UnsignedIntArray;
import fr.gael.drb.value.Value;
import java.awt.image.BufferedImage;
import javax.media.jai.RenderedOp;

public class TiffRasterNode
extends TiffNode {
    private boolean isRoot = false;
    private boolean isBand = false;
    private boolean isLine = false;
    private RenderedOp renderedOperator = null;
    private int bandNumber = -1;
    private int lineNumber = -1;
    BufferedImage bufferedImage = null;

    public TiffRasterNode() {
        super("generic_tiff_raster_node");
    }

    public TiffRasterNode(RenderedOp rendered_operator, DrbNode parent, int index, DrbNode previous_sibling, DrbNode next_sibling) {
        super("raster", parent, index, previous_sibling, next_sibling);
        this.renderedOperator = rendered_operator;
        this.isRoot = true;
        this.initChildrenList();
        this.initializeAttributes();
    }

    protected TiffRasterNode(String name, RenderedOp rendered_operator, DrbNode parent, int index, int band_number, int line_number, DrbNode previous_sibling, DrbNode next_sibling) {
        super(name, parent, index, previous_sibling, next_sibling);
        this.renderedOperator = rendered_operator;
        this.bandNumber = band_number;
        this.lineNumber = line_number;
        if (line_number < 0) {
            this.isBand = true;
        } else {
            this.isLine = true;
        }
        this.initChildrenList();
        this.initializeAttributes();
    }

    private void initChildrenList() {
        if (this.isRoot && this.renderedOperator != null) {
            int band_number = this.renderedOperator.getNumBands();
            if (band_number < 0) {
                this.children = null;
                return;
            }
            this.children = new DrbDefaultNodeList();
            for (int i_child = 0; i_child < band_number; ++i_child) {
                this.children.addItem(this.children.getLength(), (DrbItem)new TiffRasterNode("band", this.renderedOperator, (DrbNode)this, i_child, i_child, -1, null, null));
            }
        } else if (this.isBand && this.renderedOperator != null) {
            this.children = new TiffRasterNodeList(this.renderedOperator, (DrbNode)this, this.getIndex());
        }
    }

    public void initializeAttributes() {
    }

    public String getPath() {
        if (this.isRoot) {
            return this.parent.getPath() + "/" + this.getName();
        }
        return this.parent.getPath() + "/" + this.getName() + "[" + (this.getIndex() + 1) + "]";
    }

    @Override
    public int getValueType() {
        if (this.hasChild()) {
            return -1;
        }
        return 10;
    }

    public void setImage(BufferedImage buffered_image) {
        this.bufferedImage = buffered_image;
    }

    @Override
    public Value getValue() {
        if (this.hasChild()) {
            return null;
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.bufferedImage == null) {
            return null;
        }
        int[] pixels = this.bufferedImage.getRGB(0, this.getIndex(), this.bufferedImage.getWidth(), 1, null, 0, this.bufferedImage.getWidth());
        this.value = new UnsignedIntArray(pixels);
        return this.value;
    }

    @Override
    public DrbNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getChildAt(this.getIndex() - 1);
    }

    @Override
    public DrbNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getChildAt(this.getIndex() + 1);
    }

    public boolean hasChild() {
        return this.children != null;
    }
}

