/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.tiff;

import fr.gael.drb.DrbAbstractNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.tiff.TiffRasterNode;
import java.awt.image.BufferedImage;
import javax.media.jai.RenderedOp;

public class TiffRasterNodeList
extends DrbAbstractNodeList {
    private RenderedOp renderedOperator = null;
    private DrbNode parent = null;
    private int bandNumber = -1;
    private int childrenNumber = 0;
    private BufferedImage bufferedImage = null;

    public TiffRasterNodeList(RenderedOp rendered_operator, DrbNode parent, int index) {
        this.parent = parent;
        this.renderedOperator = rendered_operator;
        this.bandNumber = index;
        if (this.renderedOperator != null) {
            this.childrenNumber = this.renderedOperator.getHeight();
        }
    }

    public DrbNode item(int index) {
        if (index > this.childrenNumber || index < 0) {
            return null;
        }
        if (this.renderedOperator != null && this.bufferedImage == null) {
            this.bufferedImage = this.renderedOperator.getRendering().getAsBufferedImage();
        }
        Object value = null;
        TiffRasterNode node = new TiffRasterNode("pixels", this.renderedOperator, this.parent, index, this.bandNumber, index, null, null);
        node.setImage(this.bufferedImage);
        return node;
    }

    public int getLength() {
        return this.childrenNumber;
    }

    public String toString() {
        String string = "{ ";
        for (int index = 0; index < this.getLength(); ++index) {
            string = index != 0 ? string + " ; " + this.item(index) : string + this.item(index);
        }
        string = string + " }";
        return string;
    }
}

