/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.text;

import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.spi.DrbNodeSpi;
import fr.gael.drb.impl.text.TextNode;
import fr.gael.drb.value.Binary;
import fr.gael.drb.value.Value;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class TextFactory
implements DrbFactoryImpl {
    public String getIdentifier() {
        return "text";
    }

    public String getName() {
        return "Multi-lined ASCII Text interpreter";
    }

    public DrbNode open(URL uri) {
        return this.open(uri, null);
    }

    public DrbNode open(DrbNode base_node) {
        return this.open(null, base_node);
    }

    public DrbNode open(URL uri, DrbNode base_node) {
        TextNode node = null;
        try {
            if (uri != null) {
                node = new TextNode(new File(uri.toURI()), base_node);
            } else {
                DrbNodeImpl impl;
                Value val = base_node.getValue();
                if (val != null && val instanceof Binary) {
                    Binary bin = (Binary)val;
                    InputStream is = bin.getInput();
                    node = new TextNode(is, base_node);
                    is.close();
                } else if (base_node instanceof DrbNodeImpl && (impl = (DrbNodeImpl)base_node).hasImpl(InputStream.class)) {
                    InputStream is = (InputStream)impl.getImpl(InputStream.class);
                    node = new TextNode(is, base_node);
                    is.close();
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return DrbNodeSpi.getDrb250FileNodeFromImplNode((DrbNode)node, (DrbNode)base_node);
    }
}

