/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.text;

import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.query.Query;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class TextNode
extends DrbNodeImpl {
    private java.lang.String delimiter;
    private DrbNodeList children;
    private DrbNode parent;

    public TextNode(File file, DrbNode parent) throws IOException {
        this(file, null, parent);
    }

    public TextNode(File file, java.lang.String delimiter, DrbNode parent) throws IOException {
        this(new FileInputStream(file), delimiter, parent);
    }

    public TextNode(InputStream in, DrbNode parent) throws IOException {
        this(in, null, parent);
    }

    public TextNode(InputStream in, java.lang.String delimiter, DrbNode parent) throws IOException {
        this.parent = parent;
        this.setDelimiter(delimiter);
        DrbDefaultNodeList nodes = new DrbDefaultNodeList();
        if (this.getDelimiter() != null) {
            byte[] buf = new byte[1024];
            java.lang.String current_line = "";
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                StringTokenizer st = new StringTokenizer(new java.lang.String(buf).substring(0, len), this.getDelimiter(), true);
                while (st.hasMoreTokens()) {
                    if (!(current_line = current_line + st.nextToken()).endsWith(this.getDelimiter())) continue;
                    TextNode.insertNode((DrbNodeList)nodes, current_line, (DrbNode)this);
                    current_line = "";
                }
            }
            if (!current_line.endsWith(this.getDelimiter())) {
                TextNode.insertNode((DrbNodeList)nodes, current_line, (DrbNode)this);
            }
        } else {
            java.lang.String current_line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((current_line = reader.readLine()) != null) {
                TextNode.insertNode((DrbNodeList)nodes, current_line, (DrbNode)this);
            }
        }
        this.children = nodes;
    }

    private static void insertNode(DrbNodeList nodes, java.lang.String value, DrbNode parent) {
        DrbDefaultMutableNode node = new DrbDefaultMutableNode("line", parent, nodes.getLength(), null, null);
        node.setValue((Value)new String(value));
        nodes.addItem(nodes.getLength(), (DrbItem)node);
    }

    public DrbNodeList getChildren() {
        return this.children;
    }

    public DrbNode getParent() {
        return this.parent;
    }

    public java.lang.String getName() {
        return "text";
    }

    public java.lang.String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(java.lang.String delimiter) {
        this.delimiter = delimiter;
    }

    public static void main(java.lang.String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: TextNode <Text file> [<XQuery string>]");
            System.exit(-1);
        }
        File file = new File(args[0]);
        TextNode root = null;
        try {
            root = new TextNode(file, DrbFactory.openURI((java.lang.String)file.getPath()));
        }
        catch (Exception exception) {
            System.err.println("Cannot open Text file (" + exception + ").");
            System.exit(-1);
        }
        if (root == null) {
            System.err.println("Could not get DRB Text node.");
            System.exit(-1);
            return;
        }
        if (args.length >= 2) {
            try {
                Query query = new Query(args[1]);
                DrbSequence sequence = query.evaluate((DrbItem)root);
                System.out.println(sequence);
            }
            catch (Exception exception) {
                System.err.println("Cannot parse/evaluate XQuery (" + exception + ").");
                System.exit(-1);
            }
        } else {
            for (int index = 0; index < root.getChildrenCount(); ++index) {
                System.out.print(root.getChildAt(index).getValue().toString());
            }
        }
        System.exit(0);
    }
}

