/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.mtl;

import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.mtl.MtlParser;
import fr.gael.drb.impl.spi.DrbNodeSpi;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;

public class MtlFactory
implements DrbFactoryImpl {
    Logger logger = Logger.getLogger(MtlFactory.class);

    public String getIdentifier() {
        return "mtl";
    }

    public String getName() {
        return "USGS Landsat MTL file support";
    }

    public DrbNode open(URL u) {
        return null;
    }

    public DrbNode open(DrbNode base_node) {
        if (base_node == null || !(base_node instanceof DrbNodeImpl) || !((DrbNodeImpl)base_node).hasImpl(InputStream.class)) {
            return null;
        }
        DrbNodeImpl node_impl = (DrbNodeImpl)base_node;
        InputStream stream = (InputStream)node_impl.getImpl(InputStream.class);
        if (stream == null) {
            DrbNodeImpl node = node_impl;
            if (node instanceof DrbNodeSpi) {
                node = ((DrbNodeSpi)node_impl).getBaseNode();
            }
            throw new UnsupportedOperationException(String.format("Cannot retrieve input stream from Implementation %s", node.getClass().getCanonicalName()));
        }
        MtlParser parser = new MtlParser(stream);
        DrbDefaultMutableNode output_node = null;
        try {
            output_node = parser.parse();
        }
        catch (Throwable exception) {
            this.logger.error((Object)("Cannot parse MTL content (" + base_node.getPath() + ")"), exception);
            return null;
        }
        output_node.setParent(base_node);
        try {
            return DrbNodeSpi.getDrb250FileNodeFromImplNode((DrbNode)output_node, (DrbNode)base_node);
        }
        catch (NoSuchMethodError e) {
            return output_node;
        }
    }

    public DrbNode open(URL uri, DrbNode base_node) {
        return this.open(base_node);
    }
}

