/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.tar;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.tar.TarNode;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Value;
import fr.gael.streams.RandomAccessInputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TarFileNode
extends DrbNodeImpl {
    private static Logger LOGGER = LogManager.getLogger(TarFileNode.class);
    private DrbNode baseNode;
    DrbNodeList children;
    DrbAttributeList attributes;
    TarEntriesInfo[] tarInfo;
    private static Logger logger = Logger.getLogger(TarFileNode.class);

    protected TarFileNode(DrbNode basenode) {
        this.baseNode = basenode;
    }

    private TarEntriesInfo[] getTarEntries() {
        if (this.tarInfo == null) {
            this.tarInfo = this._getTarEntries();
        }
        return this.tarInfo;
    }

    private TarEntriesInfo[] _getTarEntries() {
        long offset = 0L;
        BufferedInputStream input = new BufferedInputStream(this.getInputStream());
        TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)input);
        ArrayList<TarEntriesInfo> list_entries = new ArrayList<TarEntriesInfo>();
        while (true) {
            try {
                TarArchiveEntry entry;
                while ((entry = tis.getNextTarEntry()) != null) {
                    long skip = 512L + entry.getSize() + this.numSkipRecordPadding(entry);
                    LOGGER.debug((Object)String.format("%010d - %s", offset, entry.getName()));
                    list_entries.add(new TarEntriesInfo(entry, offset));
                    offset += skip;
                }
            }
            catch (IOException e) {
                logger.error((Object)("tar.tarFileNode.getTarEntries " + e.getMessage()));
                IOUtils.closeQuietly((Closeable)input);
                IOUtils.closeQuietly((Closeable)tis);
                if (list_entries.size() > 0) {
                    list_entries.toArray(new TarEntriesInfo[list_entries.size()]);
                    continue;
                }
                return null;
            }
            break;
        }
        IOUtils.closeQuietly((Closeable)input);
        IOUtils.closeQuietly((Closeable)tis);
        return list_entries.toArray(new TarEntriesInfo[list_entries.size()]);
    }

    private long numSkipRecordPadding(TarArchiveEntry entry) throws IOException {
        if (!entry.isDirectory() && entry.getSize() > 0L && entry.getSize() % 512L != 0L) {
            long numRecords = entry.getSize() / 512L + 1L;
            return numRecords * 512L - entry.getSize();
        }
        return 0L;
    }

    public String getName() {
        String name = this.baseNode.getName().replaceAll("(.*)\\.\\w*", "$1");
        return name;
    }

    public int getIndex() {
        return this.baseNode.getIndex();
    }

    public DrbNode getParent() {
        return this.baseNode.getParent();
    }

    public String getPath() {
        if (this.baseNode == null) {
            return "/";
        }
        return this.baseNode.getPath();
    }

    public DrbNodeList getChildren() {
        if (this.children == null) {
            DrbDefaultNodeList list = new DrbDefaultNodeList();
            TarEntriesInfo[] infos = this.getTarEntries();
            if (infos != null) {
                for (TarEntriesInfo info : infos) {
                    TarArchiveEntry currententry = info.entry;
                    if (currententry == null) continue;
                    boolean candidate = true;
                    for (int inode = 0; inode < list.getLength(); ++inode) {
                        TarNode tarnode = (TarNode)list.item(inode);
                        TarArchiveEntry tarentry = tarnode.getTarEntry();
                        if (!currententry.getName().startsWith(tarentry.getName())) continue;
                        candidate = false;
                    }
                    if (!candidate) continue;
                    LOGGER.info((Object)("found : " + currententry.getName()));
                    list.add((Object)new TarNode(this, currententry, list.getLength(), this.baseNode, infos));
                }
                this.children = list;
            }
        }
        return this.children;
    }

    public final DrbAttributeList getAttributes() {
        if (this.attributes == null) {
            DrbAttributeList base_attrs = this.baseNode.getAttributes();
            DrbDefaultAttributeList list = new DrbDefaultAttributeList();
            if (base_attrs == null || base_attrs.getLength() == 0) {
                list.add((Object)new DrbDefaultAttribute("directory", (Value)new Boolean(false)));
            } else {
                for (int i = 0; i < base_attrs.getLength(); ++i) {
                    DrbAttribute attrib = base_attrs.item(i);
                    if (attrib == null) continue;
                    list.add((Object)new DrbDefaultAttribute(attrib.getName(), attrib.getValue(), (DrbNode)this));
                }
            }
            this.attributes = list;
        }
        return this.attributes;
    }

    public InputStream getInputStream(TarArchiveEntry tar_entry) {
        for (TarEntriesInfo info : this.getTarEntries()) {
            TarArchiveEntry current_entry = info.entry;
            LOGGER.info((Object)("Checking tar entry " + tar_entry.getName() + " vs. " + current_entry.getName()));
            if (!current_entry.getName().equals(tar_entry.getName())) continue;
            try {
                Function<Void, InputStream> fn = param -> this.getInputStream();
                RandomAccessInputStream streamIn = new RandomAccessInputStream(fn, this.baseNode.getPath());
                streamIn.seek(info.offset + 512L);
                return new TarBoundedInputStream((InputStream)streamIn, current_entry.getSize());
            }
            catch (IOException e) {
                LOGGER.error((Object)("Cannot skip tar stream " + info.offset + " bytes."), (Throwable)e);
            }
        }
        LOGGER.error((Object)("No Entry found for " + tar_entry.getName()));
        return null;
    }

    private InputStream getInputStream() {
        DrbNodeImpl baseImpl;
        if (this.baseNode instanceof DrbNodeImpl && (baseImpl = (DrbNodeImpl)this.baseNode).hasImpl(InputStream.class)) {
            InputStream str = (InputStream)baseImpl.getImpl(InputStream.class);
            if (str == null) {
                throw new NullPointerException("Error recovering tar file stream.");
            }
            return str;
        }
        throw new UnsupportedOperationException("Cannot find stream from node " + this.baseNode.getName());
    }

    public boolean hasImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).hasImpl(api);
        }
        return super.hasImpl(api);
    }

    public Object getImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).getImpl(api);
        }
        return super.getImpl(api);
    }

    class TarBoundedInputStream
    extends InputStream {
        private final InputStream in;
        private long bytesRemaining;

        public TarBoundedInputStream(InputStream in, long size) {
            this.in = in;
            this.bytesRemaining = size;
        }

        @Override
        public int read() throws IOException {
            if (this.bytesRemaining > 0L) {
                --this.bytesRemaining;
                return this.in.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead;
            if (this.bytesRemaining == 0L) {
                return -1;
            }
            int bytesToRead = len;
            if ((long)bytesToRead > this.bytesRemaining) {
                bytesToRead = (int)this.bytesRemaining;
            }
            if ((bytesRead = this.in.read(b, off, bytesToRead)) >= 0) {
                this.bytesRemaining -= (long)bytesRead;
            }
            return bytesRead;
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
            }
        }

        @Override
        public int available() {
            return new Long(this.bytesRemaining).intValue();
        }
    }

    class TarEntriesInfo {
        long offset;
        TarArchiveEntry entry;

        public TarEntriesInfo(TarArchiveEntry entry, long offset) {
            this.offset = offset;
            this.entry = entry;
        }
    }
}

