/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.tar;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.tar.TarFileNode;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.DateTime;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.Value;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.log4j.Logger;

public class TarNode
extends DrbNodeImpl {
    private TarArchiveEntry tarEntry;
    DrbNodeList children;
    DrbAttributeList attributes;
    private TarFileNode tarFileNode;
    private DrbNode parent;
    private TarFileNode.TarEntriesInfo[] infos;
    private int index;
    private static Logger logger = Logger.getLogger(TarNode.class);

    protected TarNode(TarFileNode tarfilen, TarArchiveEntry tarentry, int index, DrbNode parent, TarFileNode.TarEntriesInfo[] infos) {
        this.tarEntry = tarentry;
        this.tarFileNode = tarfilen;
        this.parent = parent;
        this.infos = infos;
        this.index = index;
    }

    public boolean allowsMultiOccurrence() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        logger.debug((Object)("TarNode.equals(" + obj.getClass().getName() + ")"));
        if (obj instanceof TarNode) {
            TarNode tar_node = (TarNode)((Object)obj);
            boolean ret = this.tarFileNode == tar_node.tarFileNode && this.tarEntry.getName().equals(tar_node.tarEntry.getName());
            return ret;
        }
        return false;
    }

    public String getName() {
        int separatorindex;
        String entrypath = this.getTarEntry().getName();
        if (entrypath.endsWith("/")) {
            entrypath = entrypath.substring(0, entrypath.length() - 1);
        }
        if ((separatorindex = entrypath.lastIndexOf("/")) < 0) {
            return entrypath;
        }
        return entrypath.substring(separatorindex + 1);
    }

    public int getIndex() {
        return this.index;
    }

    public DrbNodeList getChildren() {
        if (this.children == null) {
            DrbDefaultNodeList list = new DrbDefaultNodeList();
            for (TarFileNode.TarEntriesInfo info : this.infos) {
                TarArchiveEntry currententry = info.entry;
                if (currententry == null || !this.isChild(currententry)) continue;
                list.add((Object)new TarNode(this.tarFileNode, currententry, list.getLength(), (DrbNode)this, this.infos));
            }
            this.children = list;
        }
        return this.children;
    }

    private boolean isChild(TarArchiveEntry entry) {
        String this_name = this.getTarEntry().getName();
        String name = entry.getName();
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return !name.equals(this_name) && name.startsWith(this_name) && name.indexOf("/", this_name.length()) < 0;
    }

    public boolean hasImpl(Class api) {
        if (api.isAssignableFrom(InputStream.class)) {
            return true;
        }
        return super.hasImpl(api);
    }

    public Object getImpl(Class api) {
        if (api.isAssignableFrom(InputStream.class)) {
            try {
                return this.tarFileNode.getInputStream(this.getTarEntry());
            }
            catch (Exception e) {
                Logger.getLogger(TarNode.class).error((Object)"ERROR getting tar stream.", (Throwable)e);
                return null;
            }
        }
        return super.getImpl(api);
    }

    protected TarArchiveEntry getTarEntry() {
        return this.tarEntry;
    }

    public DrbNode getParent() {
        return this.parent;
    }

    public final DrbAttributeList getAttributes() {
        if (this.attributes == null) {
            if (this.getTarEntry() == null) {
                return null;
            }
            DrbDefaultAttribute attr = null;
            DrbDefaultAttributeList attrs = new DrbDefaultAttributeList();
            attr = new DrbDefaultAttribute("size", (Value)new UnsignedLong(this.getTarEntry().getSize()), true, (DrbNode)this);
            attrs.add((Object)attr);
            attr = new DrbDefaultAttribute("modified", (Value)new DateTime(this.getTarEntry().getModTime().getTime()), true, (DrbNode)this);
            attrs.add((Object)attr);
            attr = new DrbDefaultAttribute("directory", (Value)new Boolean(this.hasChild()), true, (DrbNode)this);
            attrs.add((Object)attr);
            this.attributes = attrs;
        }
        return this.attributes;
    }

    public boolean hasChild() {
        return this.getTarEntry().isDirectory();
    }
}

