from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.input_widget import InputWidget


T = TypeVar("T", bound="ThreadForm")


@_attrs_define
class ThreadForm:
    """发送Html 表单 向用户询问要执行任务的相关参数

    Attributes:
        inputs (List['InputWidget']):
        open_ (Union[Unset, bool]):  Default: True.
        title (Union[Unset, str]):  Default: 'ThreadForm'.
        description (Union[Unset, str]):  Default: 'ThreadForm'.
    """

    inputs: List["InputWidget"]
    open_: Union[Unset, bool] = True
    title: Union[Unset, str] = "ThreadForm"
    description: Union[Unset, str] = "ThreadForm"
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        inputs = []
        for inputs_item_data in self.inputs:
            inputs_item = inputs_item_data.to_dict()
            inputs.append(inputs_item)

        open_ = self.open_

        title = self.title

        description = self.description

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "inputs": inputs,
            }
        )
        if open_ is not UNSET:
            field_dict["open"] = open_
        if title is not UNSET:
            field_dict["title"] = title
        if description is not UNSET:
            field_dict["description"] = description

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.input_widget import InputWidget

        d = src_dict.copy()
        inputs = []
        _inputs = d.pop("inputs")
        for inputs_item_data in _inputs:
            inputs_item = InputWidget.from_dict(inputs_item_data)

            inputs.append(inputs_item)

        open_ = d.pop("open", UNSET)

        title = d.pop("title", UNSET)

        description = d.pop("description", UNSET)

        thread_form = cls(
            inputs=inputs,
            open_=open_,
            title=title,
            description=description,
        )

        thread_form.additional_properties = d
        return thread_form

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
