
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "scf"

@_ods_cext.register_operation(_Dialect)
class ConditionOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.condition"

  _ODS_REGIONS = (0, True)

  def __init__(self, condition, args, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(condition)
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def condition(self):
    return self.operation.operands[0]

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

def condition(condition, args, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ConditionOp(condition=condition, args=args, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ExecuteRegionOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.execute_region"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, *, no_inline=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(no_inline): attributes["no_inline"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def no_inline(self):
    return "no_inline" in self.operation.attributes

  @no_inline.setter
  def no_inline(self, value):
    if bool(value):
      self.operation.attributes["no_inline"] = _ods_ir.UnitAttr.get()
    elif "no_inline" in self.operation.attributes:
      del self.operation.attributes["no_inline"]

  @no_inline.deleter
  def no_inline(self):
    del self.operation.attributes["no_inline"]

  @builtins.property
  def region(self):
    return self.regions[0]

def execute_region(result, *, no_inline=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ExecuteRegionOp(result=result, no_inline=no_inline, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ForOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.for"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, lowerBound, upperBound, step, initArgs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lowerBound)
    operands.append(upperBound)
    operands.append(step)
    operands.extend(_get_op_results_or_values(initArgs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lowerBound(self):
    return self.operation.operands[0]

  @builtins.property
  def upperBound(self):
    return self.operation.operands[1]

  @builtins.property
  def step(self):
    return self.operation.operands[2]

  @builtins.property
  def initArgs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3:3 + _ods_variadic_group_length]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def for_(results_, lower_bound, upper_bound, step, init_args, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ForOp(results_=results_, lowerBound=lower_bound, upperBound=upper_bound, step=step, initArgs=init_args, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ForallOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.forall"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, dynamicLowerBound, dynamicUpperBound, dynamicStep, staticLowerBound, staticUpperBound, staticStep, outputs, *, mapping=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(dynamicLowerBound))
    operands.append(_get_op_results_or_values(dynamicUpperBound))
    operands.append(_get_op_results_or_values(dynamicStep))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["staticLowerBound"] = (staticLowerBound if (
    isinstance(staticLowerBound, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(staticLowerBound, context=_ods_context))
    attributes["staticUpperBound"] = (staticUpperBound if (
    isinstance(staticUpperBound, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(staticUpperBound, context=_ods_context))
    attributes["staticStep"] = (staticStep if (
    isinstance(staticStep, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(staticStep, context=_ods_context))
    if mapping is not None: attributes["mapping"] = (mapping if (
        isinstance(mapping, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DeviceMappingArrayAttr')) else
          _ods_ir.AttrBuilder.get('DeviceMappingArrayAttr')(mapping, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def dynamicLowerBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def dynamicUpperBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def dynamicStep(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def staticLowerBound(self):
    return self.operation.attributes["staticLowerBound"]

  @staticLowerBound.setter
  def staticLowerBound(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["staticLowerBound"] = value

  @builtins.property
  def staticUpperBound(self):
    return self.operation.attributes["staticUpperBound"]

  @staticUpperBound.setter
  def staticUpperBound(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["staticUpperBound"] = value

  @builtins.property
  def staticStep(self):
    return self.operation.attributes["staticStep"]

  @staticStep.setter
  def staticStep(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["staticStep"] = value

  @builtins.property
  def mapping(self):
    if "mapping" not in self.operation.attributes:
      return None
    return self.operation.attributes["mapping"]

  @mapping.setter
  def mapping(self, value):
    if value is not None:
      self.operation.attributes["mapping"] = value
    elif "mapping" in self.operation.attributes:
      del self.operation.attributes["mapping"]

  @mapping.deleter
  def mapping(self):
    del self.operation.attributes["mapping"]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def forall(results_, dynamic_lower_bound, dynamic_upper_bound, dynamic_step, static_lower_bound, static_upper_bound, static_step, outputs, *, mapping=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ForallOp(results_=results_, dynamicLowerBound=dynamic_lower_bound, dynamicUpperBound=dynamic_upper_bound, dynamicStep=dynamic_step, staticLowerBound=static_lower_bound, staticUpperBound=static_upper_bound, staticStep=static_step, outputs=outputs, mapping=mapping, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IfOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.if"

  _ODS_REGIONS = (2, True)

  def __init__(self, results_, condition, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(condition)
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def condition(self):
    return self.operation.operands[0]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def thenRegion(self):
    return self.regions[0]

  @builtins.property
  def elseRegion(self):
    return self.regions[1]

def if_(results_, condition, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(IfOp(results_=results_, condition=condition, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InParallelOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.forall.in_parallel"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def region(self):
    return self.regions[0]

def forall_in_parallel(*, loc=None, ip=None) -> _ods_ir.Operation:
  return InParallelOp(loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class IndexSwitchOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.index_switch"

  _ODS_REGIONS = (1, False)

  def __init__(self, results_, arg, cases, num_caseRegions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(arg)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["cases"] = (cases if (
    isinstance(cases, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(cases, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    regions = 1 + num_caseRegions
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def cases(self):
    return self.operation.attributes["cases"]

  @cases.setter
  def cases(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cases"] = value

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def defaultRegion(self):
    return self.regions[0]

  @builtins.property
  def caseRegions(self):
    return self.regions[1:]

def index_switch(results_, arg, cases, num_case_regions, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(IndexSwitchOp(results_=results_, arg=arg, cases=cases, num_caseRegions=num_case_regions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ParallelOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.parallel"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, lowerBound, upperBound, step, initVals, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(lowerBound))
    operands.append(_get_op_results_or_values(upperBound))
    operands.append(_get_op_results_or_values(step))
    operands.append(_get_op_results_or_values(initVals))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lowerBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def upperBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def step(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def initVals(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def parallel(results_, lower_bound, upper_bound, step, init_vals, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ParallelOp(results_=results_, lowerBound=lower_bound, upperBound=upper_bound, step=step, initVals=init_vals, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.reduce"

  _ODS_REGIONS = (0, False)

  def __init__(self, operands_, num_reductions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    regions = 0 + num_reductions
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def reductions(self):
    return self.regions[0:]

def reduce(operands_, num_reductions, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ReduceOp(operands_=operands_, num_reductions=num_reductions, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ReduceReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.reduce.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(result)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self):
    return self.operation.operands[0]

def reduce_return(result, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ReduceReturnOp(result=result, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WhileOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.while"

  _ODS_REGIONS = (2, True)

  def __init__(self, results_, inits, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inits))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inits(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def before(self):
    return self.regions[0]

  @builtins.property
  def after(self):
    return self.regions[1]

def while_(results_, inits, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(WhileOp(results_=results_, inits=inits, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "scf.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(results_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(results_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return YieldOp(results_=results_, loc=loc, ip=ip)
