# coding: utf-8

"""
    GroupDocs.Rewriter API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 24.11.0
    Contact: anton.perhunov@aspose.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CloudTextRequest(BaseModel):
    """
    CloudTextRequest
    """ # noqa: E501
    language: Optional[StrictInt] = Field(default=None, description="Language of original text")
    handler: Optional[StrictStr] = Field(default=None, description="Defines handler in cloud service")
    text: Optional[StrictStr] = Field(default=None, description="Text to rewrite")
    action: Optional[StrictStr] = Field(default=None, description="Rewrite or summarize")
    texts: Optional[List[StrictStr]] = Field(default=None, description="Text array to rewrite")
    suggestions: Optional[StrictInt] = Field(default=None, description="Number of suggested variants, 3 maximum")
    diversity: Optional[StrictInt] = Field(default=None, description="Diversity of text")
    tokenize: Optional[StrictBool] = Field(default=None, description="Should source and target texts be returned in tokenized form")
    origin: Optional[StrictStr] = Field(default=None, description="for analysis only")
    originaltext: Optional[StrictStr] = Field(default=None, description="Original text")
    alternativetext: Optional[StrictStr] = Field(default=None, description="Modified text")
    request_id: Optional[StrictStr] = Field(default=None, alias="requestId")
    user_email: Optional[StrictStr] = Field(default=None, alias="userEmail")
    __properties: ClassVar[List[str]] = ["language", "handler", "text", "action", "texts", "suggestions", "diversity", "tokenize", "origin", "originaltext", "alternativetext", "requestId", "userEmail"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CloudTextRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CloudTextRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "language": obj.get("language"),
            "handler": obj.get("handler"),
            "text": obj.get("text"),
            "action": obj.get("action"),
            "texts": obj.get("texts"),
            "suggestions": obj.get("suggestions"),
            "diversity": obj.get("diversity"),
            "tokenize": obj.get("tokenize"),
            "origin": obj.get("origin"),
            "originaltext": obj.get("originaltext"),
            "alternativetext": obj.get("alternativetext"),
            "requestId": obj.get("requestId"),
            "userEmail": obj.get("userEmail")
        })
        return _obj


