# coding: utf-8

"""
    GroupDocs.Rewriter API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 24.11.0
    Contact: anton.perhunov@aspose.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from groupdocs_rewriter_cloud.models.cloud_text_request import CloudTextRequest
from groupdocs_rewriter_cloud.models.health_check_info import HealthCheckInfo
from groupdocs_rewriter_cloud.models.model import Model
from typing import Optional, Set
from typing_extensions import Self

class HealthCheckResponse(BaseModel):
    """
    HealthCheckResponse
    """ # noqa: E501
    initial_request: Optional[CloudTextRequest] = Field(default=None, alias="initialRequest")
    health_check_info: Optional[HealthCheckInfo] = Field(default=None, alias="healthCheckInfo")
    models: Optional[List[Model]] = None
    __properties: ClassVar[List[str]] = ["initialRequest", "healthCheckInfo", "models"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HealthCheckResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of initial_request
        if self.initial_request:
            _dict['initialRequest'] = self.initial_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of health_check_info
        if self.health_check_info:
            _dict['healthCheckInfo'] = self.health_check_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in models (list)
        _items = []
        if self.models:
            for _item in self.models:
                if _item:
                    _items.append(_item.to_dict())
            _dict['models'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HealthCheckResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "initialRequest": CloudTextRequest.from_dict(obj["initialRequest"]) if obj.get("initialRequest") is not None else None,
            "healthCheckInfo": HealthCheckInfo.from_dict(obj["healthCheckInfo"]) if obj.get("healthCheckInfo") is not None else None,
            "models": [Model.from_dict(_item) for _item in obj["models"]] if obj.get("models") is not None else None
        })
        return _obj


