# coding: utf-8

"""
    GroupDocs.Rewriter API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 24.11.0
    Contact: anton.perhunov@aspose.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class SynonymizeTextRequest(BaseModel):
    """
    SynonymizeTextRequest
    """ # noqa: E501
    language: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Set language of text")
    text: Optional[StrictStr] = Field(default=None, description="Single text paragraph")
    texts: Optional[List[StrictStr]] = Field(default=None, description="Text paragraphs")
    origin: Optional[StrictStr] = Field(default=None, description="Information about SDK user, like a User-Agent")
    synonyms: Optional[StrictStr] = Field(default=None, description="Number of variants for rewriting")
    __properties: ClassVar[List[str]] = ["language", "text", "texts", "origin", "synonyms"]

    @field_validator('synonyms')
    def synonyms_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['All', 'One', 'Two', 'Three', 'Four', 'Five']):
            raise ValueError("must be one of enum values ('All', 'One', 'Two', 'Three', 'Four', 'Five')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SynonymizeTextRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SynonymizeTextRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "language": obj.get("language"),
            "text": obj.get("text"),
            "texts": obj.get("texts"),
            "origin": obj.get("origin"),
            "synonyms": obj.get("synonyms")
        })
        return _obj


