"use strict";
const lib_1 = require("../lib");
module.exports = {
    'plainText'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.plainText('this just resolves to a string');
        // THEN
        test.deepEqual(stack.resolve(v), 'this just resolves to a string');
        test.done();
    },
    'secretsManager'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.secretsManager('secret-id', {
            jsonField: 'json-key',
            versionId: 'version-id',
            versionStage: 'version-stage'
        });
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:secretsmanager:secret-id:SecretString:json-key:version-stage:version-id}}');
        test.done();
    },
    'secretsManager with defaults'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.secretsManager('secret-id');
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:secretsmanager:secret-id:SecretString:::}}');
        test.done();
    },
    'secretsManager with an empty ID'(test) {
        test.throws(() => lib_1.SecretValue.secretsManager(''), /secretId cannot be empty/);
        test.done();
    },
    'secretsManager with a non-ARN ID that has colon'(test) {
        test.throws(() => lib_1.SecretValue.secretsManager('not:an:arn'), /is not an ARN but contains ":"/);
        test.done();
    },
    'ssmSecure'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.ssmSecure('param-name', 'param-version');
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:ssm-secure:param-name:param-version}}');
        test.done();
    },
    'cfnDynamicReference'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.cfnDynamicReference(new lib_1.CfnDynamicReference(lib_1.CfnDynamicReferenceService.SSM, 'foo:bar'));
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:ssm:foo:bar}}');
        test.done();
    },
    'cfnParameter (with NoEcho)'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const p = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String', noEcho: true });
        // WHEN
        const v = lib_1.SecretValue.cfnParameter(p);
        // THEN
        test.deepEqual(stack.resolve(v), { Ref: 'MyParam' });
        test.done();
    },
    'fails if cfnParameter does not have NoEcho'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const p = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String' });
        // THEN
        test.throws(() => lib_1.SecretValue.cfnParameter(p), /CloudFormation parameter must be configured with "NoEcho"/);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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