# coding: utf-8

"""
extractor-api-lib

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from extractor_api_lib.models.key_value_pair import KeyValuePair

try:
    from typing import Self
except ImportError:
    from typing_extensions import Self


class ConfluenceParameters(BaseModel):
    """ """  # noqa: E501

    url: StrictStr = Field(description="url of the confluence space.")
    token: StrictStr = Field(description="api key to access confluence.")
    space_key: StrictStr = Field(description="the space key of the confluence pages.")
    include_attachments: Optional[StrictBool] = Field(
        default=False,
        description="whether to include file attachments (e.g., images, documents) in the parsed content. Default is `false`.",
    )
    keep_markdown_format: Optional[StrictBool] = Field(
        default=True, description="whether to preserve markdown formatting in the output. Default is `true`."
    )
    keep_newlines: Optional[StrictBool] = Field(
        default=True,
        description="whether to retain newline characters in the output for better readability. Default is `true`.",
    )
    document_name: StrictStr = Field(
        description="The name that will be used to store the confluence db in the key value db and the vectordatabase (metadata.document)."
    )
    confluence_kwargs: Optional[List[KeyValuePair]] = Field(
        default=None, description="Additional kwargs like verify_ssl"
    )
    __properties: ClassVar[List[str]] = [
        "url",
        "token",
        "space_key",
        "include_attachments",
        "keep_markdown_format",
        "keep_newlines",
        "document_name",
        "confluence_kwargs",
    ]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ConfluenceParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={},
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in confluence_kwargs (list)
        _items = []
        if self.confluence_kwargs:
            for _item in self.confluence_kwargs:
                if _item:
                    _items.append(_item.to_dict())
            _dict["confluence_kwargs"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ConfluenceParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "url": obj.get("url"),
                "token": obj.get("token"),
                "space_key": obj.get("space_key"),
                "include_attachments": (
                    obj.get("include_attachments") if obj.get("include_attachments") is not None else False
                ),
                "keep_markdown_format": (
                    obj.get("keep_markdown_format") if obj.get("keep_markdown_format") is not None else True
                ),
                "keep_newlines": obj.get("keep_newlines") if obj.get("keep_newlines") is not None else True,
                "document_name": obj.get("document_name"),
                "confluence_kwargs": (
                    [KeyValuePair.from_dict(_item) for _item in obj.get("confluence_kwargs")]
                    if obj.get("confluence_kwargs") is not None
                    else None
                ),
            }
        )
        return _obj
