# -*- coding: utf-8 -*-
# !python
# cython: language_level=3
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
# -*- coding: utf-8 -*-
"""This Cython module implements the performance-critical features of the
Python module |quadtools|."""

# import...
# ...from standard library
from typing import *
# ...from site-packages
from numpy import array, nan
cimport cython
from libc.math cimport fabs
from libc.math cimport INFINITY as inf
from libc.math cimport NAN as nan


cdef double[:, :] xs = array(
    [
        [
            0.5,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.5,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.27639320225002106,
            0.7236067977499789,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.1726731646460114,
            0.5,
            0.8273268353539887,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.11747233803526763,
            0.3573842417596774,
            0.6426157582403226,
            0.8825276619647324,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.08488805186071652,
            0.2655756032646429,
            0.5,
            0.7344243967353571,
            0.9151119481392835,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.06412992574519671,
            0.20414990928342885,
            0.3953503910487606,
            0.6046496089512394,
            0.7958500907165711,
            0.9358700742548033,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.05012100229426991,
            0.16140686024463113,
            0.3184412680869109,
            0.5,
            0.6815587319130891,
            0.8385931397553689,
            0.94987899770573,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.04023304591677057,
            0.1306130674472475,
            0.26103752509477773,
            0.4173605211668065,
            0.5826394788331936,
            0.7389624749052223,
            0.8693869325527526,
            0.9597669540832294,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.03299928479597042,
            0.10775826316842779,
            0.21738233650189748,
            0.3521209322065303,
            0.5,
            0.6478790677934697,
            0.7826176634981026,
            0.8922417368315723,
            0.9670007152040296,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.027550363888558915,
            0.09036033917799668,
            0.18356192348406963,
            0.30023452951732554,
            0.43172353357253623,
            0.5682764664274638,
            0.6997654704826745,
            0.8164380765159304,
            0.9096396608220033,
            0.9724496361114411,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.023345076678918053,
            0.07682621767406383,
            0.15690576545912127,
            0.2585450894543319,
            0.37535653494688004,
            0.5,
            0.62464346505312,
            0.741454910545668,
            0.8430942345408787,
            0.9231737823259362,
            0.976654923321082,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.02003247736636954,
            0.06609947308482639,
            0.1355657004543369,
            0.22468029853567645,
            0.3286379933286436,
            0.4418340655581481,
            0.5581659344418519,
            0.6713620066713564,
            0.7753197014643236,
            0.8644342995456631,
            0.9339005269151737,
            0.9799675226336304,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.01737703674808072,
            0.05745897788851184,
            0.11824015502409241,
            0.19687339726507713,
            0.2896809726431637,
            0.3923230223181029,
            0.5,
            0.6076769776818971,
            0.7103190273568363,
            0.8031266027349229,
            0.8817598449759076,
            0.9425410221114882,
            0.9826229632519192,
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.015215976864891012,
            0.05039973345326393,
            0.10399585406909245,
            0.17380564855875347,
            0.25697028905643116,
            0.3500847655496184,
            0.4493368632390253,
            0.5506631367609747,
            0.6499152344503816,
            0.7430297109435688,
            0.8261943514412465,
            0.8960041459309076,
            0.949600266546736,
            0.984784023135109,
            1.0,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.013433911684290867,
            0.04456000204221322,
            0.09215187438911487,
            0.15448550968615765,
            0.22930730033494923,
            0.31391278321726146,
            0.4052440132408413,
            0.5,
            0.5947559867591588,
            0.6860872167827385,
            0.7706926996650507,
            0.8455144903138423,
            0.9078481256108851,
            0.9554399979577868,
            0.9865660883157091,
            1.0,
            nan,
            nan,
            nan,
        ],
        [
            0.0,
            0.011947221293900745,
            0.039675407326233036,
            0.0822032323909549,
            0.13816033535837868,
            0.20574758284066913,
            0.282792481543938,
            0.3668186735608595,
            0.45512545325767395,
            0.544874546742326,
            0.6331813264391405,
            0.717207518456062,
            0.7942524171593308,
            0.8618396646416213,
            0.917796767609045,
            0.9603245926737669,
            0.9880527787060993,
            1.0,
            nan,
            nan,
        ],
        [
            0.0,
            0.010694116888959937,
            0.0355492359237069,
            0.07376971110167696,
            0.1242528987236935,
            0.18554593136738973,
            0.2558853571596432,
            0.3332475760877507,
            0.4154069882953592,
            0.5,
            0.5845930117046407,
            0.6667524239122493,
            0.7441146428403568,
            0.8144540686326103,
            0.8757471012763065,
            0.926230288898323,
            0.9644507640762932,
            0.9893058831110401,
            1.0,
            nan,
        ],
        [
            0.0,
            0.00962814755304292,
            0.03203275059366728,
            0.06656101095502492,
            0.11231586952397205,
            0.16811179885484434,
            0.23250356798405686,
            0.3038234081430453,
            0.38022414703850677,
            0.45972703138058907,
            0.5402729686194109,
            0.6197758529614933,
            0.6961765918569547,
            0.7674964320159432,
            0.8318882011451556,
            0.8876841304760279,
            0.933438989044975,
            0.9679672494063327,
            0.9903718524469571,
            1.0,
        ],
    ]
)
cdef double[:, :] ws = array(
    [
        [
            1.0,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.5,
            0.5,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.16666666666666666,
            0.6666666666666666,
            0.16666666666666666,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.08333333333333333,
            0.4166666666666667,
            0.4166666666666667,
            0.08333333333333333,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.05,
            0.2722222222222222,
            0.35555555555555557,
            0.2722222222222222,
            0.05,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.03333333333333333,
            0.1892374781489235,
            0.2774291885177432,
            0.2774291885177432,
            0.1892374781489235,
            0.03333333333333333,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.023809523809523808,
            0.13841302368078298,
            0.2158726906049313,
            0.2438095238095238,
            0.2158726906049313,
            0.13841302368078298,
            0.023809523809523808,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.017857142857142856,
            0.10535211357175302,
            0.17056134624175218,
            0.20622939732935194,
            0.20622939732935194,
            0.17056134624175218,
            0.10535211357175302,
            0.017857142857142856,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.013888888888888888,
            0.08274768078040276,
            0.13726935625008085,
            0.17321425548652317,
            0.18575963718820862,
            0.17321425548652317,
            0.13726935625008085,
            0.08274768078040276,
            0.013888888888888888,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.011111111111111112,
            0.06665299542553506,
            0.11244467103156322,
            0.1460213418398419,
            0.16376988059194872,
            0.16376988059194872,
            0.1460213418398419,
            0.11244467103156322,
            0.06665299542553506,
            0.011111111111111112,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.00909090909090909,
            0.05480613663349743,
            0.0935849408901526,
            0.12402405213201416,
            0.14343956238950403,
            0.15010879772784536,
            0.14343956238950403,
            0.12402405213201416,
            0.0935849408901526,
            0.05480613663349743,
            0.00909090909090909,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.007575757575757576,
            0.04584225870659807,
            0.07898735278218506,
            0.10625420888051057,
            0.12563780159960064,
            0.1357026204553481,
            0.1357026204553481,
            0.12563780159960064,
            0.10625420888051057,
            0.07898735278218506,
            0.04584225870659807,
            0.007575757575757576,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.00641025641025641,
            0.03890084337340946,
            0.06749096334480417,
            0.09182343260177504,
            0.11038389678305505,
            0.12200789515333818,
            0.12596542466672336,
            0.12200789515333818,
            0.11038389678305505,
            0.09182343260177504,
            0.06749096334480417,
            0.03890084337340946,
            0.00641025641025641,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.005494505494505495,
            0.03341864224884064,
            0.05829332794935583,
            0.08001092588147607,
            0.09741307468670805,
            0.10956312650488538,
            0.11580639723422853,
            0.11580639723422853,
            0.10956312650488538,
            0.09741307468670805,
            0.08001092588147607,
            0.05829332794935583,
            0.03341864224884064,
            0.005494505494505495,
            nan,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.004761904761904762,
            0.029014946514300626,
            0.050830035162859034,
            0.07025584990121406,
            0.08639482362680047,
            0.09849361798230667,
            0.10598679296341046,
            0.10852405817440783,
            0.10598679296341046,
            0.09849361798230667,
            0.08639482362680047,
            0.07025584990121406,
            0.050830035162859034,
            0.029014946514300626,
            0.004761904761904762,
            nan,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.004166666666666667,
            0.025425180502959954,
            0.0446968486629654,
            0.06212769106625705,
            0.07701349040358214,
            0.08874595669585206,
            0.0968450119126018,
            0.10097915408911494,
            0.10097915408911494,
            0.0968450119126018,
            0.08874595669585206,
            0.07701349040358214,
            0.06212769106625705,
            0.0446968486629654,
            0.025425180502959954,
            0.004166666666666667,
            nan,
            nan,
            nan,
            nan,
        ],
        [
            0.003676470588235294,
            0.022460970271627106,
            0.03959913525184356,
            0.05529645450351408,
            0.06899387310096328,
            0.08019733099881077,
            0.08850212675782894,
            0.09360816983880962,
            0.09533093737673472,
            0.09360816983880962,
            0.08850212675782894,
            0.08019733099881077,
            0.06899387310096328,
            0.05529645450351408,
            0.03959913525184356,
            0.022460970271627106,
            0.003676470588235294,
            nan,
            nan,
            nan,
        ],
        [
            0.0032679738562091504,
            0.019985314405457033,
            0.03531858344281683,
            0.0495081358587514,
            0.06210526656648355,
            0.07270598078690113,
            0.08096975861880125,
            0.08663105474472811,
            0.08950793171985154,
            0.08950793171985154,
            0.08663105474472811,
            0.08096975861880125,
            0.07270598078690113,
            0.06210526656648355,
            0.0495081358587514,
            0.03531858344281683,
            0.019985314405457033,
            0.0032679738562091504,
            nan,
            nan,
        ],
        [
            0.0029239766081871343,
            0.01789668259308824,
            0.031690945881314866,
            0.04456587854960354,
            0.05615767073865252,
            0.06613364022437539,
            0.07420697129796944,
            0.08014546202203061,
            0.08377829226357143,
            0.08500095964241362,
            0.08377829226357143,
            0.08014546202203061,
            0.07420697129796944,
            0.06613364022437539,
            0.05615767073865252,
            0.04456587854960354,
            0.031690945881314866,
            0.01789668259308824,
            0.0029239766081871343,
            nan,
        ],
        [
            0.002631578947368421,
            0.01611856159424447,
            0.028590901063783414,
            0.0403158819980598,
            0.05099574984972541,
            0.06035461381433736,
            0.0681502411793621,
            0.07418077703545842,
            0.07829005132373774,
            0.08037164319392287,
            0.08037164319392287,
            0.07829005132373774,
            0.07418077703545842,
            0.0681502411793621,
            0.06035461381433736,
            0.05099574984972541,
            0.0403158819980598,
            0.028590901063783414,
            0.01611856159424447,
            0.002631578947368421,
        ],
    ]
)


cdef class QuadBase:

    cdef double apply_method0(self, double x) nogil:
        return nan

    cdef double integrate(
        self,
        double x0,
        double x1,
        numpy.int32_t nmin,
        numpy.int32_t nmax,
        double tol,
    ) nogil:
        cdef numpy.int32_t i, j
        cdef double x, dx, yold, ynew
        if x0 == x1:
            return 0.0
        if x0 > x1:
            x0, x1 = x1, x0
        dx = x1 - x0
        y00 = self.apply_method0(x0)
        y05 = self.apply_method0((x0 + x1) / 2.0)
        y10 = self.apply_method0(x1)
        ynew = inf
        for i in range(nmin-1, nmax):
            yold = ynew
            ynew = 0.0
            for j in range(i+1):
                x = xs[i, j]
                if x == 0.0:
                    y = y00
                elif x == 0.5:
                    y = y05
                elif x == 1.0:
                    y = y10
                else:
                    y = self.apply_method0(x * dx + x0)
                ynew += ws[i, j] * y
            ynew *= dx
            if fabs(ynew - yold) <= tol:
                return ynew
        return ynew


@cython.final
cdef class QuadPython(QuadBase):

    cdef public object method0

    cpdef double integrate(
        self,
        double x0,
        double x1,
        numpy.int32_t nmin,
        numpy.int32_t nmax,
        double tol,
    ) nogil:
        return QuadBase.integrate(self, x0, x1, nmin, nmax, tol)

    cpdef double apply_method0(self, double x) nogil:
        with gil:
            return self.method0(x)
