import { Stage } from "aws-cdk-lib";
import type { StageDeployment } from "aws-cdk-lib/pipelines";
import { Construct } from "constructs";
import type { AwsCredentialsProvider } from "./aws-credentials";
import type { IJobPhase } from "./jobs";
import type { Synth } from "./steps";
import type { StageOptions, WaveOptions } from "./wave";
import { GitHubWave } from "./wave";
/**
 * Properties for configuring the GitHub Actions pipeline.
 */
export interface GitHubActionsPipelineProps {
    /**
     * Optional name for the GitHub Actions workflow.
     *
     * @default "Deploy"
     */
    readonly workflowName?: string;
    /**
     * Optional output directory for the workflow files.
     *
     * @default ".github/workflows"
     */
    readonly workflowOutdir?: string;
    /**
     * Optional filename for the workflow.
     *
     * @default "deploy"
     */
    readonly workflowFilename?: string;
    /**
     * Optional phase for pre-build jobs.
     */
    readonly preBuild?: IJobPhase;
    /**
     * Optional phase for post-build jobs.
     */
    readonly postBuild?: IJobPhase;
    /**
     * The AWS credentials provider for authenticating AWS actions.
     */
    readonly awsCredentials: AwsCredentialsProvider;
    /**
     * Synthesizer for CDK applications.
     */
    readonly synth: Synth;
}
/**
 * Constructs a GitHub Actions pipeline for deploying AWS resources.
 *
 * This construct provides methods to define the workflow, add stages, and manage waves of jobs.
 */
export declare class GitHubActionsPipeline extends Construct {
    private readonly innerPipeline;
    /**
     * Constructs a new instance of `GitHubActionsPipeline`.
     *
     * @param scope - The parent construct.
     * @param id - Unique identifier for this construct.
     * @param props - Configuration properties for the pipeline.
     */
    constructor(scope: Construct, id: string, props: GitHubActionsPipelineProps);
    /**
     * Returns the name of the workflow.
     */
    get workflowName(): string;
    /**
     * Returns the output directory for the workflow files.
     */
    get workflowOutdir(): string;
    /**
     * Returns the filename for the workflow.
     */
    get workflowFilename(): string;
    /**
     * Adds a stage to the pipeline with GitHub-specific options.
     *
     * @param stage - The stage to add to the pipeline.
     * @param options - Optional configuration for the stage.
     * @returns The deployment information for the added stage.
     */
    addStage(stage: Stage, options?: StageOptions): StageDeployment;
    /**
     * Adds a wave of jobs to the pipeline.
     *
     * @param id - Unique identifier for the wave.
     * @param options - Configuration options for the wave.
     * @returns The created GitHub wave.
     */
    addWave(id: string, options?: WaveOptions): GitHubWave;
}
