"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StagePipelineJob = exports.DeployPipelineJob = exports.PublishPipelineJob = exports.SynthPipelineJob = exports.PipelineJob = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = __importStar(require("node:fs"));
const path = __importStar(require("node:path"));
const github_actions_cdk_1 = require("github-actions-cdk");
const ASSET_HASH_NAME = "asset-hash";
const CDKOUT_ARTIFACT = "cdk.out";
/**
 * Represents a job in the pipeline that requires AWS credentials and CDK output.
 */
class PipelineJob extends github_actions_cdk_1.Job {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.PipelineJob", version: "0.0.19" };
    awsCredentials;
    cdkoutDir;
    /**
     * Constructs a new instance of `PipelineJob`.
     *
     * @param scope - The scope in which this job is defined.
     * @param id - The unique identifier for this job.
     * @param props - The properties for the pipeline job.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.awsCredentials = props.awsCredentials;
        this.cdkoutDir = props.cdkoutDir;
    }
}
exports.PipelineJob = PipelineJob;
/**
 * A job that synthesizes the CloudFormation template using CDK.
 */
class SynthPipelineJob extends PipelineJob {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.SynthPipelineJob", version: "0.0.19" };
    constructor(scope, id, props) {
        super(scope, id, props);
        new github_actions_cdk_1.actions.CheckoutV4(this, "checkout", {
            name: "Checkout",
        });
        if (props.preBuild)
            props.preBuild.steps(this);
        if (props.installCommands && props.installCommands.length > 0) {
            new github_actions_cdk_1.RunStep(this, "install", {
                name: "Install",
                run: props.installCommands,
            });
        }
        new github_actions_cdk_1.RunStep(this, "build", {
            name: "Build",
            run: props.commands,
        });
        if (props.postBuild)
            props.postBuild.steps(this);
        new github_actions_cdk_1.actions.UploadArtifactV4(this, "upload", {
            name: `Upload ${CDKOUT_ARTIFACT}`,
            artifactName: CDKOUT_ARTIFACT,
            path: props.cdkoutDir,
            includeHiddenFiles: true,
        });
    }
}
exports.SynthPipelineJob = SynthPipelineJob;
/**
 * A job that publishes stack assets to AWS.
 */
class PublishPipelineJob extends PipelineJob {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.PublishPipelineJob", version: "0.0.19" };
    constructor(scope, id, props) {
        super(scope, id, props);
        new github_actions_cdk_1.actions.DownloadArtifactV4(this, "DownloadArtifact", {
            name: `Download ${CDKOUT_ARTIFACT}`,
            artifactName: CDKOUT_ARTIFACT,
            path: props.cdkoutDir,
        });
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : "";
        new github_actions_cdk_1.RunStep(this, "install", {
            name: "Install",
            run: `npm install --no-save cdk-assets${installSuffix}`,
        });
        props.awsCredentials.credentialSteps(this, "eu-central-1");
        const { assetId, assetManifestPath } = props.assets[0];
        const relativeToAssembly = (p) => posixPath(path.join(props.cdkoutDir, path.relative(path.resolve(props.cdkoutDir), p)));
        const fileContents = ["set -ex"].concat(props.assets.map((asset) => {
            return `npx cdk-assets --path "${relativeToAssembly(asset.assetManifestPath)}" --verbose publish "${asset.assetSelector}"`;
        }));
        // Capture the asset ID for later reference
        fileContents.push(`echo '${ASSET_HASH_NAME}=${assetId}' >> $GITHUB_OUTPUT`);
        const publishStepFile = posixPath(path.join(path.dirname(relativeToAssembly(assetManifestPath)), `publish-${id}-step.sh`));
        fs.mkdirSync(path.dirname(publishStepFile), { recursive: true });
        fs.writeFileSync(publishStepFile, fileContents.join("\n"), { encoding: "utf-8" });
        const publishStep = new github_actions_cdk_1.RunStep(this, "publish", {
            name: `Publish ${id}`,
            run: `/bin/bash ./cdk.out/${posixPath(path.relative(props.cdkoutDir, publishStepFile))}`,
        });
        this.addOutput(ASSET_HASH_NAME, publishStep.outputExpression(ASSET_HASH_NAME));
    }
}
exports.PublishPipelineJob = PublishPipelineJob;
/**
 * A job that deploys a CloudFormation stack.
 */
class DeployPipelineJob extends PipelineJob {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.DeployPipelineJob", version: "0.0.19" };
    constructor(scope, id, props) {
        super(scope, id, props);
        if (!props.stack.region) {
            throw new Error('"region" is required');
        }
        if (!props.stack.templateUrl) {
            throw new Error(`unable to determine template URL for stack ${props.stack.stackArtifactId}`);
        }
        props.awsCredentials.credentialSteps(this, props.stack.region, props.stack.assumeRoleArn);
        new github_actions_cdk_1.actions.AwsCloudFormationGitHubDeployV1(this, "deploy", {
            stackName: props.stack.stackName,
            template: props.stack.templateUrl,
            noFailOnEmptyChangeset: "1",
            roleArn: props.stack.executionRoleArn,
            capabilities: props.stackOptions?.capabilities?.join(","),
        });
    }
}
exports.DeployPipelineJob = DeployPipelineJob;
/**
 * A job that executes a specific phase of steps in the pipeline.
 */
class StagePipelineJob extends PipelineJob {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.StagePipelineJob", version: "0.0.19" };
    constructor(scope, id, props) {
        super(scope, id, props);
        props.phase.steps(this);
    }
}
exports.StagePipelineJob = StagePipelineJob;
/**
 * Converts a Windows or POSIX path to a POSIX path format.
 *
 * @param windowsOrPosixPath - The input path in either Windows or POSIX format.
 * @returns The normalized POSIX path.
 */
function posixPath(windowsOrPosixPath) {
    return windowsOrPosixPath.split(path.sep).join(path.posix.sep);
}
//# sourceMappingURL=data:application/json;base64,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