# eis-tenants
The EMIL TenantService API description

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.20.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.emil.de](https://www.emil.de)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install eis.tenant
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/emilDev/eis-tenant-sdk.git`)

Then import the package:
```python
import eis.tenant
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import eis.tenant
```

## Getting Started

The environment variables must be set in order to properly use this SDK.

```shell 
export EMIL_USERNAME=XXXXXXX
export EMIL_PASSWORD=XXXXXXX
```

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import time
import eis.tenant
from pprint import pprint
from eis.tenant.api import custom_schema_api
from eis.tenant.model.create_custom_schema_request_dto import CreateCustomSchemaRequestDto
from eis.tenant.model.create_custom_schema_response_class import CreateCustomSchemaResponseClass
from eis.tenant.model.get_custom_schema_response_class import GetCustomSchemaResponseClass
from eis.tenant.model.list_custom_schemas_response_class import ListCustomSchemasResponseClass
from eis.tenant.model.update_custom_schema_request_dto import UpdateCustomSchemaRequestDto
from eis.tenant.model.update_custom_schema_response_class import UpdateCustomSchemaResponseClass
# Defining the host is optional and defaults to https://apiv2.emil.de
# See configuration.py for a list of all supported configuration parameters.
configuration = eis.tenant.Configuration(
    host = "https://apiv2.emil.de"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Bearer is automatically handled with exported environment variables. However, you
# can manuallay configure Bearer authorization (JWT): bearer
configuration = eis.tenant.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# After manual token becomes invalid, the SDK will default to re-login automatically
# with environment variable credentials.


# Enter a context with an instance of the API client
with eis.tenant.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = custom_schema_api.CustomSchemaApi(api_client)
    create_custom_schema_request_dto = CreateCustomSchemaRequestDto(
        items=[
            CustomFieldDto(
                name="customDate",
                label="Custom date",
                type="string",
                is_required=True,
                minimum=3.14,
                maximum=3.14,
                min_length=3.14,
                max_length=3.14,
                options={},
                min_items=3.14,
                max_items=3.14,
                items=None,
                properties={},
                regex_expression="regex_expression_example",
            ),
        ],
        entity="account",
        product_code="product_code_example",
    ) # CreateCustomSchemaRequestDto | 
    authorization = "Authorization_example" # str | Bearer Token: provided by the login endpoint under the name accessToken. (optional)

    try:
        # Create the custom-schema
        api_response = api_instance.create_custom_schema(create_custom_schema_request_dto, authorization=authorization)
        pprint(api_response)
    except eis.tenant.ApiException as e:
        print("Exception when calling CustomSchemaApi->create_custom_schema: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://apiv2.emil.de*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CustomSchemaApi* | [**create_custom_schema**](docs/CustomSchemaApi.md#create_custom_schema) | **POST** /tenantservice/v1/custom-schemas | Create the custom-schema
*CustomSchemaApi* | [**get_custom_schema**](docs/CustomSchemaApi.md#get_custom_schema) | **GET** /tenantservice/v1/custom-schemas/{code} | Retrieve the custom-schema
*CustomSchemaApi* | [**list_custom_schemas**](docs/CustomSchemaApi.md#list_custom_schemas) | **GET** /tenantservice/v1/custom-schemas | List custom-schemas
*CustomSchemaApi* | [**update_custom_schema**](docs/CustomSchemaApi.md#update_custom_schema) | **PUT** /tenantservice/v1/custom-schemas/{code} | Update the custom-schema
*DashboardApi* | [**create_dashboard**](docs/DashboardApi.md#create_dashboard) | **POST** /tenantservice/v1/dashboards | 
*DashboardApi* | [**delete_dashboard**](docs/DashboardApi.md#delete_dashboard) | **DELETE** /tenantservice/v1/dashboards/{code} | 
*DashboardApi* | [**get_dashboard**](docs/DashboardApi.md#get_dashboard) | **GET** /tenantservice/v1/dashboards/{code} | 
*DashboardApi* | [**list_dashboards**](docs/DashboardApi.md#list_dashboards) | **GET** /tenantservice/v1/dashboards | 
*DashboardApi* | [**update_dashboard**](docs/DashboardApi.md#update_dashboard) | **PUT** /tenantservice/v1/dashboards/{code} | 
*DashboardGroupApi* | [**create_dashboard_group**](docs/DashboardGroupApi.md#create_dashboard_group) | **POST** /tenantservice/v1/dashboards-groups | 
*DashboardGroupApi* | [**delete_dashboard_group**](docs/DashboardGroupApi.md#delete_dashboard_group) | **DELETE** /tenantservice/v1/dashboards-groups/{code} | 
*DashboardGroupApi* | [**get_dashboard_group**](docs/DashboardGroupApi.md#get_dashboard_group) | **GET** /tenantservice/v1/dashboards-groups/{code} | 
*DashboardGroupApi* | [**list_dashboard_groups**](docs/DashboardGroupApi.md#list_dashboard_groups) | **GET** /tenantservice/v1/dashboards-groups | 
*DashboardGroupApi* | [**update_dashboard_group**](docs/DashboardGroupApi.md#update_dashboard_group) | **PUT** /tenantservice/v1/dashboards-groups/{code} | 
*DataReportApi* | [**create_data_report**](docs/DataReportApi.md#create_data_report) | **POST** /tenantservice/v1/data-reports | Create the data-report
*DataReportApi* | [**delete_alert**](docs/DataReportApi.md#delete_alert) | **DELETE** /tenantservice/v1/data-reports/{id} | 
*DataReportApi* | [**get_data_report**](docs/DataReportApi.md#get_data_report) | **GET** /tenantservice/v1/data-reports/{code} | Retrieve the data-report
*DataReportApi* | [**list_data_reports**](docs/DataReportApi.md#list_data_reports) | **GET** /tenantservice/v1/data-reports | List data-reports
*DataReportApi* | [**update_data_report**](docs/DataReportApi.md#update_data_report) | **PUT** /tenantservice/v1/data-reports/{code} | Update the data-report
*DataReportExecutorApi* | [**run_data_report**](docs/DataReportExecutorApi.md#run_data_report) | **POST** /tenantservice/v1/data-report-executor | 
*DeleteOrganizationInvitationsApi* | [**delete_org_invitation**](docs/DeleteOrganizationInvitationsApi.md#delete_org_invitation) | **DELETE** /tenantservice/v1/invitations/organizations/{id} | Delete the organization invitation
*HealthCheckApi* | [**check**](docs/HealthCheckApi.md#check) | **GET** /tenantservice/health | Health Check
*InviteOrganizationsApi* | [**invite_org**](docs/InviteOrganizationsApi.md#invite_org) | **POST** /tenantservice/v1/invitations/organizations | Invite an organization
*InviteUsersApi* | [**delete_invite**](docs/InviteUsersApi.md#delete_invite) | **DELETE** /tenantservice/v1/users/invites/{id} | Delete the invited user
*InviteUsersApi* | [**delete_invites**](docs/InviteUsersApi.md#delete_invites) | **POST** /tenantservice/v1/users/invites/delete-batch | Delete invited users.
*InviteUsersApi* | [**invite_user**](docs/InviteUsersApi.md#invite_user) | **POST** /tenantservice/v1/users/invites | Invite a user
*InviteUsersApi* | [**invite_users**](docs/InviteUsersApi.md#invite_users) | **POST** /tenantservice/v1/users/invites/batch | Invite batch of users
*InviteUsersApi* | [**list_invites**](docs/InviteUsersApi.md#list_invites) | **GET** /tenantservice/v1/users/invites | List invited users
*ListOrganizationInvitationsApi* | [**list_org_invitations**](docs/ListOrganizationInvitationsApi.md#list_org_invitations) | **GET** /tenantservice/v1/invitations/organizations | List organization invitations
*OrganizationsApi* | [**get_organization**](docs/OrganizationsApi.md#get_organization) | **GET** /tenantservice/v1/organizations/{code} | Retrieve the Organization
*OrganizationsApi* | [**list_organizations**](docs/OrganizationsApi.md#list_organizations) | **GET** /tenantservice/v1/organizations | List organizations
*OrganizationsApi* | [**update_organization**](docs/OrganizationsApi.md#update_organization) | **PUT** /tenantservice/v1/organizations/{code} | Update the Organization
*ReInviteAnOrganizationApi* | [**re_invite_organization**](docs/ReInviteAnOrganizationApi.md#re_invite_organization) | **PATCH** /tenantservice/v1/invitations/organizations | 
*RolesApi* | [**list_roles**](docs/RolesApi.md#list_roles) | **GET** /tenantservice/v1/roles | List roles
*SettingsApi* | [**get_tenant_settings**](docs/SettingsApi.md#get_tenant_settings) | **GET** /tenantservice/v1/settings/tenant | Retrieve the settings
*UsersApi* | [**assign_user_roles**](docs/UsersApi.md#assign_user_roles) | **POST** /tenantservice/v1/users/{id}/assign-roles | 
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /tenantservice/v1/users/{id} | 
*UsersApi* | [**delete_users**](docs/UsersApi.md#delete_users) | **POST** /tenantservice/v1/users/delete-batch | 
*UsersApi* | [**disable_user**](docs/UsersApi.md#disable_user) | **POST** /tenantservice/v1/users/{id}/disable | 
*UsersApi* | [**disable_users**](docs/UsersApi.md#disable_users) | **POST** /tenantservice/v1/users/disable-batch | 
*UsersApi* | [**enable_user**](docs/UsersApi.md#enable_user) | **POST** /tenantservice/v1/users/{id}/enable | 
*UsersApi* | [**enable_users**](docs/UsersApi.md#enable_users) | **POST** /tenantservice/v1/users/enable-batch | 
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /tenantservice/v1/users/{code} | 
*UsersApi* | [**link_user_with_partner**](docs/UsersApi.md#link_user_with_partner) | **POST** /tenantservice/v1/users/{code}/link-partner | 
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /tenantservice/v1/users | List users


## Documentation For Models

 - [AssignUserRolesRequestDto](docs/AssignUserRolesRequestDto.md)
 - [AssignUserRolesResponseClass](docs/AssignUserRolesResponseClass.md)
 - [BatchDeleteRequestDto](docs/BatchDeleteRequestDto.md)
 - [BatchDeleteResponseClass](docs/BatchDeleteResponseClass.md)
 - [CreateCustomSchemaRequestDto](docs/CreateCustomSchemaRequestDto.md)
 - [CreateCustomSchemaResponseClass](docs/CreateCustomSchemaResponseClass.md)
 - [CreateDashboardGroupRequestDto](docs/CreateDashboardGroupRequestDto.md)
 - [CreateDashboardGroupResponseClass](docs/CreateDashboardGroupResponseClass.md)
 - [CreateDashboardRequestDto](docs/CreateDashboardRequestDto.md)
 - [CreateDashboardResponseClass](docs/CreateDashboardResponseClass.md)
 - [CreateDataReportRequestDto](docs/CreateDataReportRequestDto.md)
 - [CreateDataReportResponseClass](docs/CreateDataReportResponseClass.md)
 - [CreatePermissionRequestDto](docs/CreatePermissionRequestDto.md)
 - [CreateRoleRequestDto](docs/CreateRoleRequestDto.md)
 - [CreateTenantRequestDto](docs/CreateTenantRequestDto.md)
 - [CustomFieldDto](docs/CustomFieldDto.md)
 - [CustomSchemaClass](docs/CustomSchemaClass.md)
 - [DBConfigDto](docs/DBConfigDto.md)
 - [DashboardClass](docs/DashboardClass.md)
 - [DashboardGroupClass](docs/DashboardGroupClass.md)
 - [DataReportClass](docs/DataReportClass.md)
 - [DataReportFilterClass](docs/DataReportFilterClass.md)
 - [DataReportFilterDto](docs/DataReportFilterDto.md)
 - [DataReportFilterSingleValueDto](docs/DataReportFilterSingleValueDto.md)
 - [DataReportFilterValueDto](docs/DataReportFilterValueDto.md)
 - [DeleteResponseClass](docs/DeleteResponseClass.md)
 - [DisableUserResponseClass](docs/DisableUserResponseClass.md)
 - [DisableUsersRequestDto](docs/DisableUsersRequestDto.md)
 - [DisableUsersResponseClass](docs/DisableUsersResponseClass.md)
 - [EnableUserResponseClass](docs/EnableUserResponseClass.md)
 - [EnableUsersRequestDto](docs/EnableUsersRequestDto.md)
 - [EnableUsersResponseClass](docs/EnableUsersResponseClass.md)
 - [FormatTenantSettingsClass](docs/FormatTenantSettingsClass.md)
 - [GetCustomSchemaResponseClass](docs/GetCustomSchemaResponseClass.md)
 - [GetDashboardGroupResponseClass](docs/GetDashboardGroupResponseClass.md)
 - [GetDashboardResponseClass](docs/GetDashboardResponseClass.md)
 - [GetDataReportResponseClass](docs/GetDataReportResponseClass.md)
 - [GetOrganizationResponseClass](docs/GetOrganizationResponseClass.md)
 - [GetSettingsResponseClass](docs/GetSettingsResponseClass.md)
 - [GetUserResponseClass](docs/GetUserResponseClass.md)
 - [InitialTenantConfigClass](docs/InitialTenantConfigClass.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InviteClass](docs/InviteClass.md)
 - [InviteOrgRequestDto](docs/InviteOrgRequestDto.md)
 - [InviteUserRequestDto](docs/InviteUserRequestDto.md)
 - [InviteUserResponseClass](docs/InviteUserResponseClass.md)
 - [InviteUsersRequestDto](docs/InviteUsersRequestDto.md)
 - [InviteUsersResponseClass](docs/InviteUsersResponseClass.md)
 - [LinkUserWithPartnerRequestDtoRest](docs/LinkUserWithPartnerRequestDtoRest.md)
 - [LinkUserWithPartnerResponseClass](docs/LinkUserWithPartnerResponseClass.md)
 - [ListCustomSchemasResponseClass](docs/ListCustomSchemasResponseClass.md)
 - [ListDashboardGroupsResponseClass](docs/ListDashboardGroupsResponseClass.md)
 - [ListDashboardsResponseClass](docs/ListDashboardsResponseClass.md)
 - [ListDataReportsResponseClass](docs/ListDataReportsResponseClass.md)
 - [ListInvitesResponseClass](docs/ListInvitesResponseClass.md)
 - [ListOrgInvitationsResponseClass](docs/ListOrgInvitationsResponseClass.md)
 - [ListOrganizationsResponseClass](docs/ListOrganizationsResponseClass.md)
 - [ListRolesResponseClass](docs/ListRolesResponseClass.md)
 - [ListUsersResponseClass](docs/ListUsersResponseClass.md)
 - [OrgInvitationClass](docs/OrgInvitationClass.md)
 - [OrgInvitationResponseClass](docs/OrgInvitationResponseClass.md)
 - [OrganizationClass](docs/OrganizationClass.md)
 - [PartnerInvitationDataDto](docs/PartnerInvitationDataDto.md)
 - [PermissionClass](docs/PermissionClass.md)
 - [ReInviteOrgRequestDto](docs/ReInviteOrgRequestDto.md)
 - [RoleClass](docs/RoleClass.md)
 - [RunDataReportRequestDto](docs/RunDataReportRequestDto.md)
 - [RunDataReportResponseClass](docs/RunDataReportResponseClass.md)
 - [SetSettingRequestDto](docs/SetSettingRequestDto.md)
 - [SubscriptionClass](docs/SubscriptionClass.md)
 - [TenantAdminUserDto](docs/TenantAdminUserDto.md)
 - [TenantSettingsClass](docs/TenantSettingsClass.md)
 - [UpdateCustomSchemaRequestDto](docs/UpdateCustomSchemaRequestDto.md)
 - [UpdateCustomSchemaResponseClass](docs/UpdateCustomSchemaResponseClass.md)
 - [UpdateDashboardGroupRequestDto](docs/UpdateDashboardGroupRequestDto.md)
 - [UpdateDashboardGroupResponseClass](docs/UpdateDashboardGroupResponseClass.md)
 - [UpdateDashboardRequestDto](docs/UpdateDashboardRequestDto.md)
 - [UpdateDashboardResponseClass](docs/UpdateDashboardResponseClass.md)
 - [UpdateDataReportRequestDto](docs/UpdateDataReportRequestDto.md)
 - [UpdateDataReportResponseClass](docs/UpdateDataReportResponseClass.md)
 - [UpdateOrganizationRequestDtoRest](docs/UpdateOrganizationRequestDtoRest.md)
 - [UpdateOrganizationResponseClass](docs/UpdateOrganizationResponseClass.md)
 - [UpdateRoleRequestDto](docs/UpdateRoleRequestDto.md)
 - [UserClass](docs/UserClass.md)


## Documentation For Authorization


## bearer

- **Type**: Bearer authentication (JWT)


## Author

kontakt@emil.de


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in eis.tenant.apis and eis.tenant.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from eis.tenant.api.default_api import DefaultApi`
- `from eis.tenant.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import eis.tenant
from eis.tenant.apis import *
from eis.tenant.models import *
```

