"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Literal, Union, overload
from loguru import logger
from cityfront.utils import UNSET, Unset, exclude_unset
from pydantic import BaseModel, parse_obj_as

from .models import (
    AccountPrefsGetResponse200,
    Jwt,
    LogList,
    Payload,
    Payload1,
    Payload2,
    Payload3,
    Payload4,
    Payload5,
    Payload6,
    Payload7,
    Payload9,
    Payload10,
    Payload11,
    Payload13,
    Session,
    SessionList,
    Token,
    User,
)
from .types import (
    Payload1Type,
    Payload2Type,
    Payload3Type,
    Payload4Type,
    Payload5PropPrefsType,
    Payload5Type,
    Payload6Type,
    Payload7Type,
    Payload9Type,
    Payload10Type,
    Payload11Type,
    Payload13Type,
    PayloadType,
)

if TYPE_CHECKING:
    from cityfront import AppWrite
    from cityfront.response import Response


class AccountClient:
    def __init__(self, appwrite: 'AppWrite'):
        self._appwrite = appwrite

    def account_get(
        self,
    ) -> 'Response[User]':
        headers = {}
        url = '/account'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=User,
        )

    async def async_account_get(
        self,
    ) -> 'Response[User]':
        url = '/account'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=User,
        )

    @overload
    def account_create(
        self, *, data: Union[Unset, PayloadType] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def account_create(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        email: str,
        password: str,
        name: Union[Unset, str] = UNSET,
    ) -> 'Response[User]':
        ...

    def account_create(
        self, *, data: Union[Unset, PayloadType] = UNSET, **kwargs
    ) -> 'Response[User]':
        headers = {}
        url = '/account'
        logger.info(data)
        logger.warning(kwargs)
        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )
        logger.error(json)
        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_account_create(
        self, *, data: Union[Unset, PayloadType] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_account_create(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        email: str,
        password: str,
        name: Union[Unset, str] = UNSET,
    ) -> 'Response[User]':
        ...

    async def async_account_create(
        self, *, data: Union[Unset, PayloadType] = UNSET, **kwargs
    ) -> 'Response[User]':
        url = '/account'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    def account_update_email(
        self, *, data: Union[Unset, Payload1Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def account_update_email(
        self,
        *,
        data: Unset = UNSET,
        email: str,
        password: str,
    ) -> 'Response[User]':
        ...

    def account_update_email(
        self, *, data: Union[Unset, Payload1Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        headers = {}
        url = '/account/email'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload1, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_account_update_email(
        self, *, data: Union[Unset, Payload1Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_account_update_email(
        self,
        *,
        data: Unset = UNSET,
        email: str,
        password: str,
    ) -> 'Response[User]':
        ...

    async def async_account_update_email(
        self, *, data: Union[Unset, Payload1Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        url = '/account/email'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload1, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    def account_create_j_w_t(
        self,
    ) -> 'Response[Jwt]':
        headers = {}
        url = '/account/jwt'

        return self._appwrite.request(
            'POST',
            url,
            headers=exclude_unset(headers),
            response_model=Jwt,
        )

    async def async_account_create_j_w_t(
        self,
    ) -> 'Response[Jwt]':
        url = '/account/jwt'

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            headers=exclude_unset(headers),
            response_model=Jwt,
        )

    def account_get_logs(
        self,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
    ) -> 'Response[LogList]':
        headers = {}
        url = '/account/logs'

        params = {
            'limit': limit,
            'offset': offset,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=LogList,
        )

    async def async_account_get_logs(
        self,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
    ) -> 'Response[LogList]':
        url = '/account/logs'

        params = {
            'limit': limit,
            'offset': offset,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=LogList,
        )

    @overload
    def account_update_name(
        self, *, data: Union[Unset, Payload2Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def account_update_name(
        self,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> 'Response[User]':
        ...

    def account_update_name(
        self, *, data: Union[Unset, Payload2Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        headers = {}
        url = '/account/name'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload2, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_account_update_name(
        self, *, data: Union[Unset, Payload2Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_account_update_name(
        self,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> 'Response[User]':
        ...

    async def async_account_update_name(
        self, *, data: Union[Unset, Payload2Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        url = '/account/name'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload2, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    def account_update_password(
        self, *, data: Union[Unset, Payload3Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def account_update_password(
        self,
        *,
        data: Unset = UNSET,
        password: str,
        old_password: Union[Unset, str] = UNSET,
    ) -> 'Response[User]':
        ...

    def account_update_password(
        self, *, data: Union[Unset, Payload3Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        headers = {}
        url = '/account/password'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload3, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_account_update_password(
        self, *, data: Union[Unset, Payload3Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_account_update_password(
        self,
        *,
        data: Unset = UNSET,
        password: str,
        old_password: Union[Unset, str] = UNSET,
    ) -> 'Response[User]':
        ...

    async def async_account_update_password(
        self, *, data: Union[Unset, Payload3Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        url = '/account/password'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload3, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    def account_update_phone(
        self, *, data: Union[Unset, Payload4Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def account_update_phone(
        self,
        *,
        data: Unset = UNSET,
        number: str,
        password: str,
    ) -> 'Response[User]':
        ...

    def account_update_phone(
        self, *, data: Union[Unset, Payload4Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        headers = {}
        url = '/account/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload4, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_account_update_phone(
        self, *, data: Union[Unset, Payload4Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_account_update_phone(
        self,
        *,
        data: Unset = UNSET,
        number: str,
        password: str,
    ) -> 'Response[User]':
        ...

    async def async_account_update_phone(
        self, *, data: Union[Unset, Payload4Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        url = '/account/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload4, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    def account_get_prefs(
        self,
    ) -> 'Response[AccountPrefsGetResponse200]':
        headers = {}
        url = '/account/prefs'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=AccountPrefsGetResponse200,
        )

    async def async_account_get_prefs(
        self,
    ) -> 'Response[AccountPrefsGetResponse200]':
        url = '/account/prefs'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=AccountPrefsGetResponse200,
        )

    @overload
    def account_update_prefs(
        self, *, data: Union[Unset, Payload5Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def account_update_prefs(
        self,
        *,
        data: Unset = UNSET,
        prefs: Payload5PropPrefsType,
    ) -> 'Response[User]':
        ...

    def account_update_prefs(
        self, *, data: Union[Unset, Payload5Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        headers = {}
        url = '/account/prefs'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload5, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_account_update_prefs(
        self, *, data: Union[Unset, Payload5Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_account_update_prefs(
        self,
        *,
        data: Unset = UNSET,
        prefs: Payload5PropPrefsType,
    ) -> 'Response[User]':
        ...

    async def async_account_update_prefs(
        self, *, data: Union[Unset, Payload5Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        url = '/account/prefs'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload5, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    def account_update_recovery(
        self, *, data: Union[Unset, Payload7Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    def account_update_recovery(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
        password: str,
        password_again: str,
    ) -> 'Response[Token]':
        ...

    def account_update_recovery(
        self, *, data: Union[Unset, Payload7Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        headers = {}
        url = '/account/recovery'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload7, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    async def async_account_update_recovery(
        self, *, data: Union[Unset, Payload7Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    async def async_account_update_recovery(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
        password: str,
        password_again: str,
    ) -> 'Response[Token]':
        ...

    async def async_account_update_recovery(
        self, *, data: Union[Unset, Payload7Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        url = '/account/recovery'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload7, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    def account_create_recovery(
        self, *, data: Union[Unset, Payload6Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    def account_create_recovery(
        self,
        *,
        data: Unset = UNSET,
        email: str,
        url: str,
    ) -> 'Response[Token]':
        ...

    def account_create_recovery(
        self, *, data: Union[Unset, Payload6Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        headers = {}
        url = '/account/recovery'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload6, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    async def async_account_create_recovery(
        self, *, data: Union[Unset, Payload6Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    async def async_account_create_recovery(
        self,
        *,
        data: Unset = UNSET,
        email: str,
        url: str,
    ) -> 'Response[Token]':
        ...

    async def async_account_create_recovery(
        self, *, data: Union[Unset, Payload6Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        url = '/account/recovery'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload6, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    def account_get_sessions(
        self,
    ) -> 'Response[SessionList]':
        headers = {}
        url = '/account/sessions'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=SessionList,
        )

    async def async_account_get_sessions(
        self,
    ) -> 'Response[SessionList]':
        url = '/account/sessions'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=SessionList,
        )

    def account_delete_sessions(
        self,
    ) -> 'Response':
        headers = {}
        url = '/account/sessions'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_account_delete_sessions(
        self,
    ) -> 'Response':
        url = '/account/sessions'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def account_create_anonymous_session(
        self,
    ) -> 'Response[Session]':
        headers = {}
        url = '/account/sessions/anonymous'

        return self._appwrite.request(
            'POST',
            url,
            headers=exclude_unset(headers),
            response_model=Session,
        )

    async def async_account_create_anonymous_session(
        self,
    ) -> 'Response[Session]':
        url = '/account/sessions/anonymous'

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            headers=exclude_unset(headers),
            response_model=Session,
        )

    @overload
    def account_create_email_session(
        self, *, data: Union[Unset, Payload1Type] = UNSET
    ) -> 'Response[Session]':
        ...

    @overload
    def account_create_email_session(
        self,
        *,
        data: Unset = UNSET,
        email: str,
        password: str,
    ) -> 'Response[Session]':
        ...

    def account_create_email_session(
        self, *, data: Union[Unset, Payload1Type] = UNSET, **kwargs
    ) -> 'Response[Session]':
        headers = {}
        url = '/account/sessions/email'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload1, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Session,
        )

    @overload
    async def async_account_create_email_session(
        self, *, data: Union[Unset, Payload1Type] = UNSET
    ) -> 'Response[Session]':
        ...

    @overload
    async def async_account_create_email_session(
        self,
        *,
        data: Unset = UNSET,
        email: str,
        password: str,
    ) -> 'Response[Session]':
        ...

    async def async_account_create_email_session(
        self, *, data: Union[Unset, Payload1Type] = UNSET, **kwargs
    ) -> 'Response[Session]':
        url = '/account/sessions/email'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload1, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Session,
        )

    @overload
    def account_update_magic_u_r_l_session(
        self, *, data: Union[Unset, Payload10Type] = UNSET
    ) -> 'Response[Session]':
        ...

    @overload
    def account_update_magic_u_r_l_session(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Session]':
        ...

    def account_update_magic_u_r_l_session(
        self, *, data: Union[Unset, Payload10Type] = UNSET, **kwargs
    ) -> 'Response[Session]':
        headers = {}
        url = '/account/sessions/magic_url'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload10, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Session,
        )

    @overload
    async def async_account_update_magic_u_r_l_session(
        self, *, data: Union[Unset, Payload10Type] = UNSET
    ) -> 'Response[Session]':
        ...

    @overload
    async def async_account_update_magic_u_r_l_session(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Session]':
        ...

    async def async_account_update_magic_u_r_l_session(
        self, *, data: Union[Unset, Payload10Type] = UNSET, **kwargs
    ) -> 'Response[Session]':
        url = '/account/sessions/magic_url'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload10, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Session,
        )

    @overload
    def account_create_magic_u_r_l_session(
        self, *, data: Union[Unset, Payload9Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    def account_create_magic_u_r_l_session(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        email: str,
        url: Union[Unset, str] = UNSET,
    ) -> 'Response[Token]':
        ...

    def account_create_magic_u_r_l_session(
        self, *, data: Union[Unset, Payload9Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        headers = {}
        url = '/account/sessions/magic_url'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload9, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    async def async_account_create_magic_u_r_l_session(
        self, *, data: Union[Unset, Payload9Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    async def async_account_create_magic_u_r_l_session(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        email: str,
        url: Union[Unset, str] = UNSET,
    ) -> 'Response[Token]':
        ...

    async def async_account_create_magic_u_r_l_session(
        self, *, data: Union[Unset, Payload9Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        url = '/account/sessions/magic_url'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload9, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    def account_create_o_auth2_session(
        self,
        provider: str,
        success: Union[Unset, str] = UNSET,
        failure: Union[Unset, str] = UNSET,
        scopes: Union[Unset, List[str]] = UNSET,
    ) -> 'Response':
        headers = {}
        url = f'/account/sessions/oauth2/{provider}'

        params = {
            'success': success,
            'failure': failure,
            'scopes': scopes,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
        )

    async def async_account_create_o_auth2_session(
        self,
        provider: str,
        success: Union[Unset, str] = UNSET,
        failure: Union[Unset, str] = UNSET,
        scopes: Union[Unset, List[str]] = UNSET,
    ) -> 'Response':
        url = f'/account/sessions/oauth2/{provider}'

        params = {
            'success': success,
            'failure': failure,
            'scopes': scopes,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
        )

    @overload
    def account_update_phone_session(
        self, *, data: Union[Unset, Payload10Type] = UNSET
    ) -> 'Response[Session]':
        ...

    @overload
    def account_update_phone_session(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Session]':
        ...

    def account_update_phone_session(
        self, *, data: Union[Unset, Payload10Type] = UNSET, **kwargs
    ) -> 'Response[Session]':
        headers = {}
        url = '/account/sessions/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload10, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Session,
        )

    @overload
    async def async_account_update_phone_session(
        self, *, data: Union[Unset, Payload10Type] = UNSET
    ) -> 'Response[Session]':
        ...

    @overload
    async def async_account_update_phone_session(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Session]':
        ...

    async def async_account_update_phone_session(
        self, *, data: Union[Unset, Payload10Type] = UNSET, **kwargs
    ) -> 'Response[Session]':
        url = '/account/sessions/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload10, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Session,
        )

    @overload
    def account_create_phone_session(
        self, *, data: Union[Unset, Payload11Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    def account_create_phone_session(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        number: str,
    ) -> 'Response[Token]':
        ...

    def account_create_phone_session(
        self, *, data: Union[Unset, Payload11Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        headers = {}
        url = '/account/sessions/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload11, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    async def async_account_create_phone_session(
        self, *, data: Union[Unset, Payload11Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    async def async_account_create_phone_session(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        number: str,
    ) -> 'Response[Token]':
        ...

    async def async_account_create_phone_session(
        self, *, data: Union[Unset, Payload11Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        url = '/account/sessions/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload11, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    def account_get_session(
        self,
        session_id: str,
    ) -> 'Response[Session]':
        headers = {}
        url = f'/account/sessions/{session_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Session,
        )

    async def async_account_get_session(
        self,
        session_id: str,
    ) -> 'Response[Session]':
        url = f'/account/sessions/{session_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Session,
        )

    def account_delete_session(
        self,
        session_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/account/sessions/{session_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_account_delete_session(
        self,
        session_id: str,
    ) -> 'Response':
        url = f'/account/sessions/{session_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def account_update_session(
        self,
        session_id: str,
    ) -> 'Response[Session]':
        headers = {}
        url = f'/account/sessions/{session_id}'

        return self._appwrite.request(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=Session,
        )

    async def async_account_update_session(
        self,
        session_id: str,
    ) -> 'Response[Session]':
        url = f'/account/sessions/{session_id}'

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=Session,
        )

    def account_update_status(
        self,
    ) -> 'Response[User]':
        headers = {}
        url = '/account/status'

        return self._appwrite.request(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=User,
        )

    async def async_account_update_status(
        self,
    ) -> 'Response[User]':
        url = '/account/status'

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=User,
        )

    @overload
    def account_update_verification(
        self, *, data: Union[Unset, Payload10Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    def account_update_verification(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Token]':
        ...

    def account_update_verification(
        self, *, data: Union[Unset, Payload10Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        headers = {}
        url = '/account/verification'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload10, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    async def async_account_update_verification(
        self, *, data: Union[Unset, Payload10Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    async def async_account_update_verification(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Token]':
        ...

    async def async_account_update_verification(
        self, *, data: Union[Unset, Payload10Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        url = '/account/verification'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload10, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    def account_create_verification(
        self, *, data: Union[Unset, Payload13Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    def account_create_verification(
        self,
        *,
        data: Unset = UNSET,
        url: str,
    ) -> 'Response[Token]':
        ...

    def account_create_verification(
        self, *, data: Union[Unset, Payload13Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        headers = {}
        url = '/account/verification'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload13, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    async def async_account_create_verification(
        self, *, data: Union[Unset, Payload13Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    async def async_account_create_verification(
        self,
        *,
        data: Unset = UNSET,
        url: str,
    ) -> 'Response[Token]':
        ...

    async def async_account_create_verification(
        self, *, data: Union[Unset, Payload13Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        url = '/account/verification'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload13, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    def account_update_phone_verification(
        self, *, data: Union[Unset, Payload10Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    def account_update_phone_verification(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Token]':
        ...

    def account_update_phone_verification(
        self, *, data: Union[Unset, Payload10Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        headers = {}
        url = '/account/verification/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload10, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    @overload
    async def async_account_update_phone_verification(
        self, *, data: Union[Unset, Payload10Type] = UNSET
    ) -> 'Response[Token]':
        ...

    @overload
    async def async_account_update_phone_verification(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Token]':
        ...

    async def async_account_update_phone_verification(
        self, *, data: Union[Unset, Payload10Type] = UNSET, **kwargs
    ) -> 'Response[Token]':
        url = '/account/verification/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload10, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Token,
        )

    def account_create_phone_verification(
        self,
    ) -> 'Response[Token]':
        headers = {}
        url = '/account/verification/phone'

        return self._appwrite.request(
            'POST',
            url,
            headers=exclude_unset(headers),
            response_model=Token,
        )

    async def async_account_create_phone_verification(
        self,
    ) -> 'Response[Token]':
        url = '/account/verification/phone'

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            headers=exclude_unset(headers),
            response_model=Token,
        )
