"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Any, Literal, Union, overload

from cityfront.utils import UNSET, Unset, exclude_unset
from pydantic import BaseModel, parse_obj_as

if TYPE_CHECKING:
    from cityfront import AppWrite
    from cityfront.response import Response


class AvatarsClient:
    def __init__(self, appwrite: 'AppWrite'):
        self._appwrite = appwrite

    def avatars_get_browser(
        self,
        code: str,
        width: Union[Unset, int] = 100,
        height: Union[Unset, int] = 100,
        quality: Union[Unset, int] = 100,
    ) -> 'Response[Any]':
        headers = {}
        url = f'/avatars/browsers/{code}'

        params = {
            'width': width,
            'height': height,
            'quality': quality,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_avatars_get_browser(
        self,
        code: str,
        width: Union[Unset, int] = 100,
        height: Union[Unset, int] = 100,
        quality: Union[Unset, int] = 100,
    ) -> 'Response[Any]':
        url = f'/avatars/browsers/{code}'

        params = {
            'width': width,
            'height': height,
            'quality': quality,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    def avatars_get_credit_card(
        self,
        code: str,
        width: Union[Unset, int] = 100,
        height: Union[Unset, int] = 100,
        quality: Union[Unset, int] = 100,
    ) -> 'Response[Any]':
        headers = {}
        url = f'/avatars/credit_cards/{code}'

        params = {
            'width': width,
            'height': height,
            'quality': quality,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_avatars_get_credit_card(
        self,
        code: str,
        width: Union[Unset, int] = 100,
        height: Union[Unset, int] = 100,
        quality: Union[Unset, int] = 100,
    ) -> 'Response[Any]':
        url = f'/avatars/credit_cards/{code}'

        params = {
            'width': width,
            'height': height,
            'quality': quality,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    def avatars_get_favicon(
        self,
        url: str,
    ) -> 'Response[Any]':
        headers = {}
        url = '/avatars/favicon'

        params = {
            'url': url,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_avatars_get_favicon(
        self,
        url: str,
    ) -> 'Response[Any]':
        url = '/avatars/favicon'

        params = {
            'url': url,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    def avatars_get_flag(
        self,
        code: str,
        width: Union[Unset, int] = 100,
        height: Union[Unset, int] = 100,
        quality: Union[Unset, int] = 100,
    ) -> 'Response[Any]':
        headers = {}
        url = f'/avatars/flags/{code}'

        params = {
            'width': width,
            'height': height,
            'quality': quality,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_avatars_get_flag(
        self,
        code: str,
        width: Union[Unset, int] = 100,
        height: Union[Unset, int] = 100,
        quality: Union[Unset, int] = 100,
    ) -> 'Response[Any]':
        url = f'/avatars/flags/{code}'

        params = {
            'width': width,
            'height': height,
            'quality': quality,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    def avatars_get_image(
        self,
        url: str,
        width: Union[Unset, int] = 400,
        height: Union[Unset, int] = 400,
    ) -> 'Response[Any]':
        headers = {}
        url = '/avatars/image'

        params = {
            'url': url,
            'width': width,
            'height': height,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_avatars_get_image(
        self,
        url: str,
        width: Union[Unset, int] = 400,
        height: Union[Unset, int] = 400,
    ) -> 'Response[Any]':
        url = '/avatars/image'

        params = {
            'url': url,
            'width': width,
            'height': height,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    def avatars_get_initials(
        self,
        name: Union[Unset, str] = UNSET,
        width: Union[Unset, int] = 500,
        height: Union[Unset, int] = 500,
        color: Union[Unset, str] = UNSET,
        background: Union[Unset, str] = UNSET,
    ) -> 'Response[Any]':
        headers = {}
        url = '/avatars/initials'

        params = {
            'name': name,
            'width': width,
            'height': height,
            'color': color,
            'background': background,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_avatars_get_initials(
        self,
        name: Union[Unset, str] = UNSET,
        width: Union[Unset, int] = 500,
        height: Union[Unset, int] = 500,
        color: Union[Unset, str] = UNSET,
        background: Union[Unset, str] = UNSET,
    ) -> 'Response[Any]':
        url = '/avatars/initials'

        params = {
            'name': name,
            'width': width,
            'height': height,
            'color': color,
            'background': background,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    def avatars_get_q_r(
        self,
        text: str,
        size: Union[Unset, int] = 400,
        margin: Union[Unset, int] = 1,
        download: Union[Unset, bool] = False,
    ) -> 'Response[Any]':
        headers = {}
        url = '/avatars/qr'

        params = {
            'text': text,
            'size': size,
            'margin': margin,
            'download': download,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_avatars_get_q_r(
        self,
        text: str,
        size: Union[Unset, int] = 400,
        margin: Union[Unset, int] = 1,
        download: Union[Unset, bool] = False,
    ) -> 'Response[Any]':
        url = '/avatars/qr'

        params = {
            'text': text,
            'size': size,
            'margin': margin,
            'download': download,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )
