"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Literal, Union, overload

from cityfront.utils import UNSET, Unset, exclude_unset
from pydantic import BaseModel, parse_obj_as

from .models import (
    Deployment,
    DeploymentList,
    Execution,
    ExecutionList,
    Function,
    FunctionList,
    FunctionsFunctionIdDeploymentsPostBody,
    Payload31,
    Payload32,
    Payload33,
    RuntimeList,
    UsageFunctions,
)
from .types import (
    FunctionsFunctionIdDeploymentsPostBodyType,
    Payload31PropVarsType,
    Payload31Type,
    Payload32PropVarsType,
    Payload32Type,
    Payload33Type,
)

if TYPE_CHECKING:
    from cityfront import AppWrite
    from cityfront.response import Response


class FunctionsClient:
    def __init__(self, appwrite: 'AppWrite'):
        self._appwrite = appwrite

    def functions_list(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[FunctionList]':
        headers = {}
        url = '/functions'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=FunctionList,
        )

    async def async_functions_list(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[FunctionList]':
        url = '/functions'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=FunctionList,
        )

    @overload
    def functions_create(
        self, *, data: Union[Unset, Payload31Type] = UNSET
    ) -> 'Response[Function]':
        ...

    @overload
    def functions_create(
        self,
        *,
        data: Unset = UNSET,
        function_id: str,
        name: str,
        execute: List[str],
        runtime: str,
        vars_: Union[Unset, Payload31PropVarsType] = UNSET,
        events: Union[Unset, List[str]] = [],
        schedule: Union[Unset, str] = UNSET,
        timeout: Union[Unset, int] = 15,
    ) -> 'Response[Function]':
        ...

    def functions_create(
        self, *, data: Union[Unset, Payload31Type] = UNSET, **kwargs
    ) -> 'Response[Function]':
        headers = {}
        url = '/functions'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload31, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Function,
        )

    @overload
    async def async_functions_create(
        self, *, data: Union[Unset, Payload31Type] = UNSET
    ) -> 'Response[Function]':
        ...

    @overload
    async def async_functions_create(
        self,
        *,
        data: Unset = UNSET,
        function_id: str,
        name: str,
        execute: List[str],
        runtime: str,
        vars_: Union[Unset, Payload31PropVarsType] = UNSET,
        events: Union[Unset, List[str]] = [],
        schedule: Union[Unset, str] = UNSET,
        timeout: Union[Unset, int] = 15,
    ) -> 'Response[Function]':
        ...

    async def async_functions_create(
        self, *, data: Union[Unset, Payload31Type] = UNSET, **kwargs
    ) -> 'Response[Function]':
        url = '/functions'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload31, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Function,
        )

    def functions_list_runtimes(
        self,
    ) -> 'Response[RuntimeList]':
        headers = {}
        url = '/functions/runtimes'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=RuntimeList,
        )

    async def async_functions_list_runtimes(
        self,
    ) -> 'Response[RuntimeList]':
        url = '/functions/runtimes'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=RuntimeList,
        )

    def functions_get(
        self,
        function_id: str,
    ) -> 'Response[Function]':
        headers = {}
        url = f'/functions/{function_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Function,
        )

    async def async_functions_get(
        self,
        function_id: str,
    ) -> 'Response[Function]':
        url = f'/functions/{function_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Function,
        )

    @overload
    def functions_update(
        self, function_id: str, *, data: Union[Unset, Payload32Type] = UNSET
    ) -> 'Response[Function]':
        ...

    @overload
    def functions_update(
        self,
        function_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        execute: List[str],
        vars_: Union[Unset, Payload32PropVarsType] = UNSET,
        events: Union[Unset, List[str]] = [],
        schedule: Union[Unset, str] = UNSET,
        timeout: Union[Unset, int] = 15,
    ) -> 'Response[Function]':
        ...

    def functions_update(
        self,
        function_id: str,
        *,
        data: Union[Unset, Payload32Type] = UNSET,
        **kwargs,
    ) -> 'Response[Function]':
        headers = {}
        url = f'/functions/{function_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload32, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Function,
        )

    @overload
    async def async_functions_update(
        self, function_id: str, *, data: Union[Unset, Payload32Type] = UNSET
    ) -> 'Response[Function]':
        ...

    @overload
    async def async_functions_update(
        self,
        function_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        execute: List[str],
        vars_: Union[Unset, Payload32PropVarsType] = UNSET,
        events: Union[Unset, List[str]] = [],
        schedule: Union[Unset, str] = UNSET,
        timeout: Union[Unset, int] = 15,
    ) -> 'Response[Function]':
        ...

    async def async_functions_update(
        self,
        function_id: str,
        *,
        data: Union[Unset, Payload32Type] = UNSET,
        **kwargs,
    ) -> 'Response[Function]':
        url = f'/functions/{function_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload32, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Function,
        )

    def functions_delete(
        self,
        function_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/functions/{function_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_functions_delete(
        self,
        function_id: str,
    ) -> 'Response':
        url = f'/functions/{function_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def functions_list_deployments(
        self,
        function_id: str,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[DeploymentList]':
        headers = {}
        url = f'/functions/{function_id}/deployments'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=DeploymentList,
        )

    async def async_functions_list_deployments(
        self,
        function_id: str,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[DeploymentList]':
        url = f'/functions/{function_id}/deployments'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=DeploymentList,
        )

    @overload
    def functions_create_deployment(
        self,
        function_id: str,
        *,
        data: Union[Unset, FunctionsFunctionIdDeploymentsPostBodyType] = UNSET,
    ) -> 'Response[Deployment]':
        ...

    @overload
    def functions_create_deployment(
        self,
        function_id: str,
        *,
        data: Unset = UNSET,
        entrypoint: str,
        code: str,
        activate: bool,
    ) -> 'Response[Deployment]':
        ...

    def functions_create_deployment(
        self,
        function_id: str,
        *,
        data: Union[Unset, FunctionsFunctionIdDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> 'Response[Deployment]':
        headers = {}
        url = f'/functions/{function_id}/deployments'

        if not kwargs:
            kwargs = UNSET

        data = kwargs if data is UNSET else data
        data = parse_obj_as(FunctionsFunctionIdDeploymentsPostBody, data)
        data = (
            data.dict(by_alias=True) if isinstance(data, BaseModel) else data
        )

        return self._appwrite.request(
            'POST',
            url,
            data=exclude_unset(data),
            response_model=Deployment,
        )

    @overload
    async def async_functions_create_deployment(
        self,
        function_id: str,
        *,
        data: Union[Unset, FunctionsFunctionIdDeploymentsPostBodyType] = UNSET,
    ) -> 'Response[Deployment]':
        ...

    @overload
    async def async_functions_create_deployment(
        self,
        function_id: str,
        *,
        data: Unset = UNSET,
        entrypoint: str,
        code: str,
        activate: bool,
    ) -> 'Response[Deployment]':
        ...

    async def async_functions_create_deployment(
        self,
        function_id: str,
        *,
        data: Union[Unset, FunctionsFunctionIdDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> 'Response[Deployment]':
        url = f'/functions/{function_id}/deployments'

        if not kwargs:
            kwargs = UNSET

        data = kwargs if data is UNSET else data
        data = parse_obj_as(FunctionsFunctionIdDeploymentsPostBody, data)
        data = (
            data.dict(by_alias=True) if isinstance(data, BaseModel) else data
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            data=exclude_unset(data),
            response_model=Deployment,
        )

    def functions_get_deployment(
        self,
        function_id: str,
        deployment_id: str,
    ) -> 'Response[Deployment]':
        headers = {}
        url = f'/functions/{function_id}/deployments/{deployment_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Deployment,
        )

    async def async_functions_get_deployment(
        self,
        function_id: str,
        deployment_id: str,
    ) -> 'Response[Deployment]':
        url = f'/functions/{function_id}/deployments/{deployment_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Deployment,
        )

    def functions_delete_deployment(
        self,
        function_id: str,
        deployment_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/functions/{function_id}/deployments/{deployment_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_functions_delete_deployment(
        self,
        function_id: str,
        deployment_id: str,
    ) -> 'Response':
        url = f'/functions/{function_id}/deployments/{deployment_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def functions_update_deployment(
        self,
        function_id: str,
        deployment_id: str,
    ) -> 'Response[Function]':
        headers = {}
        url = f'/functions/{function_id}/deployments/{deployment_id}'

        return self._appwrite.request(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=Function,
        )

    async def async_functions_update_deployment(
        self,
        function_id: str,
        deployment_id: str,
    ) -> 'Response[Function]':
        url = f'/functions/{function_id}/deployments/{deployment_id}'

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=Function,
        )

    def functions_retry_build(
        self,
        function_id: str,
        deployment_id: str,
        build_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/functions/{function_id}/deployments/{deployment_id}/builds/{build_id}'

        return self._appwrite.request(
            'POST',
            url,
            headers=exclude_unset(headers),
        )

    async def async_functions_retry_build(
        self,
        function_id: str,
        deployment_id: str,
        build_id: str,
    ) -> 'Response':
        url = f'/functions/{function_id}/deployments/{deployment_id}/builds/{build_id}'

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            headers=exclude_unset(headers),
        )

    def functions_list_executions(
        self,
        function_id: str,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        search: Union[Unset, str] = UNSET,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
    ) -> 'Response[ExecutionList]':
        headers = {}
        url = f'/functions/{function_id}/executions'

        params = {
            'limit': limit,
            'offset': offset,
            'search': search,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExecutionList,
        )

    async def async_functions_list_executions(
        self,
        function_id: str,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        search: Union[Unset, str] = UNSET,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
    ) -> 'Response[ExecutionList]':
        url = f'/functions/{function_id}/executions'

        params = {
            'limit': limit,
            'offset': offset,
            'search': search,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExecutionList,
        )

    @overload
    def functions_create_execution(
        self, function_id: str, *, data: Union[Unset, Payload33Type] = UNSET
    ) -> 'Response[Execution]':
        ...

    @overload
    def functions_create_execution(
        self,
        function_id: str,
        *,
        data: Unset = UNSET,
        async_: Union[Unset, bool] = True,
    ) -> 'Response[Execution]':
        ...

    def functions_create_execution(
        self,
        function_id: str,
        *,
        data: Union[Unset, Payload33Type] = UNSET,
        **kwargs,
    ) -> 'Response[Execution]':
        headers = {}
        url = f'/functions/{function_id}/executions'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload33, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Execution,
        )

    @overload
    async def async_functions_create_execution(
        self, function_id: str, *, data: Union[Unset, Payload33Type] = UNSET
    ) -> 'Response[Execution]':
        ...

    @overload
    async def async_functions_create_execution(
        self,
        function_id: str,
        *,
        data: Unset = UNSET,
        async_: Union[Unset, bool] = True,
    ) -> 'Response[Execution]':
        ...

    async def async_functions_create_execution(
        self,
        function_id: str,
        *,
        data: Union[Unset, Payload33Type] = UNSET,
        **kwargs,
    ) -> 'Response[Execution]':
        url = f'/functions/{function_id}/executions'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload33, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Execution,
        )

    def functions_get_execution(
        self,
        function_id: str,
        execution_id: str,
    ) -> 'Response[Execution]':
        headers = {}
        url = f'/functions/{function_id}/executions/{execution_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Execution,
        )

    async def async_functions_get_execution(
        self,
        function_id: str,
        execution_id: str,
    ) -> 'Response[Execution]':
        url = f'/functions/{function_id}/executions/{execution_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Execution,
        )

    def functions_get_usage(
        self,
        function_id: str,
        range_: Union[Unset, str] = '30d',
    ) -> 'Response[UsageFunctions]':
        headers = {}
        url = f'/functions/{function_id}/usage'

        params = {
            'range': range_,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageFunctions,
        )

    async def async_functions_get_usage(
        self,
        function_id: str,
        range_: Union[Unset, str] = '30d',
    ) -> 'Response[UsageFunctions]':
        url = f'/functions/{function_id}/usage'

        params = {
            'range': range_,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageFunctions,
        )
