"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from __future__ import annotations

from typing import Any, List, Union

from cityfront.utils import UNSET, Unset
from pydantic import BaseModel, Field


class CityFrontModel(BaseModel, allow_population_by_field_name=True):
    ...


class DocumentList(CityFrontModel):
    """documentList

    Documents List
    """

    total: int = Field(
        description='Total number of documents documents that matched your query.',
        default=...,
    )
    documents: List[Document] = Field(
        description='List of documents.', default=...
    )


class Document(CityFrontModel):
    """document

    Document
    """

    id: str = Field(description='Document ID.', default=..., alias='$id')
    collection: str = Field(
        description='Collection ID.', default=..., alias='$collection'
    )
    created_at: int = Field(
        description='Document creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Document update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    read: List[str] = Field(
        description='Document read permissions.', default=..., alias='$read'
    )
    write: List[str] = Field(
        description='Document write permissions.', default=..., alias='$write'
    )


class CollectionList(CityFrontModel):
    """collectionList

    Collections List
    """

    total: int = Field(
        description='Total number of collections documents that matched your query.',
        default=...,
    )
    collections: List[Collection] = Field(
        description='List of collections.', default=...
    )


class Collection(CityFrontModel):
    """collection

    Collection
    """

    id: str = Field(description='Collection ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Collection creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Collection update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    read: List[str] = Field(
        description='Collection read permissions.', default=..., alias='$read'
    )
    write: List[str] = Field(
        description='Collection write permissions.',
        default=...,
        alias='$write',
    )
    database_id: str = Field(
        description='Database ID.', default=..., alias='databaseId'
    )
    name: str = Field(description='Collection name.', default=...)
    enabled: bool = Field(description='Collection enabled.', default=...)
    permission: str = Field(
        description='Collection permission model. Possible values: `document` or `collection`',
        default=...,
    )
    attributes: List[Any] = Field(
        description='Collection attributes.', default=...
    )
    indexes: List[Index] = Field(
        description='Collection indexes.', default=...
    )


class Index(CityFrontModel):
    """index

    Index
    """

    key: str = Field(description='Index Key.', default=...)
    type: str = Field(description='Index type.', default=...)
    status: str = Field(
        description='Index status. Possible values: `available`, `processing`, `deleting`, `stuck`, or `failed`',
        default=...,
    )
    attributes: List[str] = Field(description='Index attributes.', default=...)
    orders: List[str] = Field(description='Index orders.', default=...)


class DatabaseList(CityFrontModel):
    """databaseList

    Databases List
    """

    total: int = Field(
        description='Total number of databases documents that matched your query.',
        default=...,
    )
    databases: List[Database] = Field(
        description='List of databases.', default=...
    )


class Database(CityFrontModel):
    """database

    Database
    """

    id: str = Field(description='Database ID.', default=..., alias='$id')
    name: str = Field(description='Database name.', default=...)
    created_at: int = Field(
        description='Collection creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Collection update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )


class IndexList(CityFrontModel):
    """indexList

    Indexes List
    """

    total: int = Field(
        description='Total number of indexes documents that matched your query.',
        default=...,
    )
    indexes: List[Index] = Field(description='List of indexes.', default=...)


class UserList(CityFrontModel):
    """userList

    Users List
    """

    total: int = Field(
        description='Total number of users documents that matched your query.',
        default=...,
    )
    users: List[User] = Field(description='List of users.', default=...)


class User(CityFrontModel):
    """user

    User
    """

    id: str = Field(description='User ID.', default=..., alias='$id')
    created_at: int = Field(
        description='User creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='User update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    name: str = Field(description='User name.', default=...)
    registration: int = Field(
        description='User registration date in Unix timestamp.', default=...
    )
    status: bool = Field(
        description='User status. Pass `true` for enabled and `false` for disabled.',
        default=...,
    )
    password_update: int = Field(
        description='Unix timestamp of the most recent password update',
        default=...,
        alias='passwordUpdate',
    )
    email: str = Field(description='User email address.', default=...)
    phone: str = Field(
        description='User phone number in E.164 format.', default=...
    )
    email_verification: bool = Field(
        description='Email verification status.',
        default=...,
        alias='emailVerification',
    )
    phone_verification: bool = Field(
        description='Phone verification status.',
        default=...,
        alias='phoneVerification',
    )
    prefs: List[UserPropPrefsItems] = Field(
        description='User preferences as a key-value object', default=...
    )


class UserPropPrefsItems(CityFrontModel):
    """UserPropPrefsItems"""


class SessionList(CityFrontModel):
    """sessionList

    Sessions List
    """

    total: int = Field(
        description='Total number of sessions documents that matched your query.',
        default=...,
    )
    sessions: List[Session] = Field(
        description='List of sessions.', default=...
    )


class Session(CityFrontModel):
    """session

    Session
    """

    id: str = Field(description='Session ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Session creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    user_id: str = Field(description='User ID.', default=..., alias='userId')
    expire: int = Field(
        description='Session expiration date in Unix timestamp.', default=...
    )
    provider: str = Field(description='Session Provider.', default=...)
    provider_uid: str = Field(
        description='Session Provider User ID.',
        default=...,
        alias='providerUid',
    )
    provider_access_token: str = Field(
        description='Session Provider Access Token.',
        default=...,
        alias='providerAccessToken',
    )
    provider_access_token_expiry: int = Field(
        description='Date, the Unix timestamp of when the access token expires.',
        default=...,
        alias='providerAccessTokenExpiry',
    )
    provider_refresh_token: str = Field(
        description='Session Provider Refresh Token.',
        default=...,
        alias='providerRefreshToken',
    )
    ip: str = Field(
        description='IP in use when the session was created.', default=...
    )
    os_code: str = Field(
        description='Operating system code name. View list of [available options](https://github.com/appwrite/appwrite/blob/master/docs/lists/os.json).',
        default=...,
        alias='osCode',
    )
    os_name: str = Field(
        description='Operating system name.', default=..., alias='osName'
    )
    os_version: str = Field(
        description='Operating system version.', default=..., alias='osVersion'
    )
    client_type: str = Field(
        description='Client type.', default=..., alias='clientType'
    )
    client_code: str = Field(
        description='Client code name. View list of [available options](https://github.com/appwrite/appwrite/blob/master/docs/lists/clients.json).',
        default=...,
        alias='clientCode',
    )
    client_name: str = Field(
        description='Client name.', default=..., alias='clientName'
    )
    client_version: str = Field(
        description='Client version.', default=..., alias='clientVersion'
    )
    client_engine: str = Field(
        description='Client engine name.', default=..., alias='clientEngine'
    )
    client_engine_version: str = Field(
        description='Client engine name.',
        default=...,
        alias='clientEngineVersion',
    )
    device_name: str = Field(
        description='Device name.', default=..., alias='deviceName'
    )
    device_brand: str = Field(
        description='Device brand name.', default=..., alias='deviceBrand'
    )
    device_model: str = Field(
        description='Device model name.', default=..., alias='deviceModel'
    )
    country_code: str = Field(
        description='Country two-character ISO 3166-1 alpha code.',
        default=...,
        alias='countryCode',
    )
    country_name: str = Field(
        description='Country name.', default=..., alias='countryName'
    )
    current: bool = Field(
        description='Returns true if this the current user session.',
        default=...,
    )


class LogList(CityFrontModel):
    """logList

    Logs List
    """

    total: int = Field(
        description='Total number of logs documents that matched your query.',
        default=...,
    )
    logs: List[Log] = Field(description='List of logs.', default=...)


class Log(CityFrontModel):
    """log

    Log
    """

    event: str = Field(description='Event name.', default=...)
    user_id: str = Field(description='User ID.', default=..., alias='userId')
    user_email: str = Field(
        description='User Email.', default=..., alias='userEmail'
    )
    user_name: str = Field(
        description='User Name.', default=..., alias='userName'
    )
    mode: str = Field(
        description='API mode when event triggered.', default=...
    )
    ip: str = Field(
        description='IP session in use when the session was created.',
        default=...,
    )
    time: int = Field(
        description='Log creation time in Unix timestamp.', default=...
    )
    os_code: str = Field(
        description='Operating system code name. View list of [available options](https://github.com/appwrite/appwrite/blob/master/docs/lists/os.json).',
        default=...,
        alias='osCode',
    )
    os_name: str = Field(
        description='Operating system name.', default=..., alias='osName'
    )
    os_version: str = Field(
        description='Operating system version.', default=..., alias='osVersion'
    )
    client_type: str = Field(
        description='Client type.', default=..., alias='clientType'
    )
    client_code: str = Field(
        description='Client code name. View list of [available options](https://github.com/appwrite/appwrite/blob/master/docs/lists/clients.json).',
        default=...,
        alias='clientCode',
    )
    client_name: str = Field(
        description='Client name.', default=..., alias='clientName'
    )
    client_version: str = Field(
        description='Client version.', default=..., alias='clientVersion'
    )
    client_engine: str = Field(
        description='Client engine name.', default=..., alias='clientEngine'
    )
    client_engine_version: str = Field(
        description='Client engine name.',
        default=...,
        alias='clientEngineVersion',
    )
    device_name: str = Field(
        description='Device name.', default=..., alias='deviceName'
    )
    device_brand: str = Field(
        description='Device brand name.', default=..., alias='deviceBrand'
    )
    device_model: str = Field(
        description='Device model name.', default=..., alias='deviceModel'
    )
    country_code: str = Field(
        description='Country two-character ISO 3166-1 alpha code.',
        default=...,
        alias='countryCode',
    )
    country_name: str = Field(
        description='Country name.', default=..., alias='countryName'
    )


class FileList(CityFrontModel):
    """fileList

    Files List
    """

    total: int = Field(
        description='Total number of files documents that matched your query.',
        default=...,
    )
    files: List[File] = Field(description='List of files.', default=...)


class File(CityFrontModel):
    """file

    File
    """

    id: str = Field(description='File ID.', default=..., alias='$id')
    bucket_id: str = Field(
        description='Bucket ID.', default=..., alias='bucketId'
    )
    created_at: int = Field(
        description='File creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='File update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    read: List[str] = Field(
        description='File read permissions.', default=..., alias='$read'
    )
    write: List[str] = Field(
        description='File write permissions.', default=..., alias='$write'
    )
    name: str = Field(description='File name.', default=...)
    signature: str = Field(description='File MD5 signature.', default=...)
    mime_type: str = Field(
        description='File mime type.', default=..., alias='mimeType'
    )
    size_original: int = Field(
        description='File original size in bytes.',
        default=...,
        alias='sizeOriginal',
    )
    chunks_total: int = Field(
        description='Total number of chunks available',
        default=...,
        alias='chunksTotal',
    )
    chunks_uploaded: int = Field(
        description='Total number of chunks uploaded',
        default=...,
        alias='chunksUploaded',
    )


class BucketList(CityFrontModel):
    """bucketList

    Buckets List
    """

    total: int = Field(
        description='Total number of buckets documents that matched your query.',
        default=...,
    )
    buckets: List[Bucket] = Field(description='List of buckets.', default=...)


class Bucket(CityFrontModel):
    """bucket

    Bucket
    """

    id: str = Field(description='Bucket ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Bucket creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Bucket update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    read: List[str] = Field(
        description='File read permissions.', default=..., alias='$read'
    )
    write: List[str] = Field(
        description='File write permissions.', default=..., alias='$write'
    )
    permission: str = Field(
        description='Bucket permission model. Possible values: `bucket` or `file`',
        default=...,
    )
    name: str = Field(description='Bucket name.', default=...)
    enabled: bool = Field(description='Bucket enabled.', default=...)
    maximum_file_size: int = Field(
        description='Maximum file size supported.',
        default=...,
        alias='maximumFileSize',
    )
    allowed_file_extensions: List[str] = Field(
        description='Allowed file extensions.',
        default=...,
        alias='allowedFileExtensions',
    )
    encryption: bool = Field(description='Bucket is encrypted.', default=...)
    antivirus: bool = Field(
        description='Virus scanning is enabled.', default=...
    )


class TeamList(CityFrontModel):
    """teamList

    Teams List
    """

    total: int = Field(
        description='Total number of teams documents that matched your query.',
        default=...,
    )
    teams: List[Team] = Field(description='List of teams.', default=...)


class Team(CityFrontModel):
    """team

    Team
    """

    id: str = Field(description='Team ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Team creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Team update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    name: str = Field(description='Team name.', default=...)
    total: int = Field(
        description='Total number of team members.', default=...
    )


class MembershipList(CityFrontModel):
    """membershipList

    Memberships List
    """

    total: int = Field(
        description='Total number of memberships documents that matched your query.',
        default=...,
    )
    memberships: List[Membership] = Field(
        description='List of memberships.', default=...
    )


class Membership(CityFrontModel):
    """membership

    Membership
    """

    id: str = Field(description='Membership ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Membership creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Membership update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    user_id: str = Field(description='User ID.', default=..., alias='userId')
    user_name: str = Field(
        description='User name.', default=..., alias='userName'
    )
    user_email: str = Field(
        description='User email address.', default=..., alias='userEmail'
    )
    team_id: str = Field(description='Team ID.', default=..., alias='teamId')
    team_name: str = Field(
        description='Team name.', default=..., alias='teamName'
    )
    invited: int = Field(
        description='Date, the user has been invited to join the team in Unix timestamp.',
        default=...,
    )
    joined: int = Field(
        description='Date, the user has accepted the invitation to join the team in Unix timestamp.',
        default=...,
    )
    confirm: bool = Field(
        description='User confirmation status, true if the user has joined the team or false otherwise.',
        default=...,
    )
    roles: List[str] = Field(description='User list of roles', default=...)


class FunctionList(CityFrontModel):
    """functionList

    Functions List
    """

    total: int = Field(
        description='Total number of functions documents that matched your query.',
        default=...,
    )
    functions: List[Function] = Field(
        description='List of functions.', default=...
    )


class Function(CityFrontModel):
    """function

    Function
    """

    id: str = Field(description='Function ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Function creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Function update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    execute: List[str] = Field(
        description='Execution permissions.', default=...
    )
    name: str = Field(description='Function name.', default=...)
    status: str = Field(
        description='Function status. Possible values: `disabled`, `enabled`',
        default=...,
    )
    runtime: str = Field(
        description='Function execution runtime.', default=...
    )
    deployment: str = Field(
        description="Function's active deployment ID.", default=...
    )
    vars_: FunctionPropVars = Field(
        description='Function environment variables.',
        default=...,
        alias='vars',
    )
    events: List[str] = Field(
        description='Function trigger events.', default=...
    )
    schedule: str = Field(
        description='Function execution schedult in CRON format.', default=...
    )
    schedule_next: int = Field(
        description='Function next scheduled execution date in Unix timestamp.',
        default=...,
        alias='scheduleNext',
    )
    schedule_previous: int = Field(
        description='Function next scheduled execution date in Unix timestamp.',
        default=...,
        alias='schedulePrevious',
    )
    timeout: int = Field(
        description='Function execution timeout in seconds.', default=...
    )


class FunctionPropVars(CityFrontModel):
    """FunctionPropVars

    Function environment variables.
    """


class RuntimeList(CityFrontModel):
    """runtimeList

    Runtimes List
    """

    total: int = Field(
        description='Total number of runtimes documents that matched your query.',
        default=...,
    )
    runtimes: List[Runtime] = Field(
        description='List of runtimes.', default=...
    )


class Runtime(CityFrontModel):
    """runtime

    Runtime
    """

    id: str = Field(description='Runtime ID.', default=..., alias='$id')
    name: str = Field(description='Runtime Name.', default=...)
    version: str = Field(description='Runtime version.', default=...)
    base: str = Field(
        description='Base Docker image used to build the runtime.', default=...
    )
    image: str = Field(description='Image name of Docker Hub.', default=...)
    logo: str = Field(description='Name of the logo image.', default=...)
    supports: List[str] = Field(
        description='List of supported architectures.', default=...
    )


class DeploymentList(CityFrontModel):
    """deploymentList

    Deployments List
    """

    total: int = Field(
        description='Total number of deployments documents that matched your query.',
        default=...,
    )
    deployments: List[Deployment] = Field(
        description='List of deployments.', default=...
    )


class Deployment(CityFrontModel):
    """deployment

    Deployment
    """

    id: str = Field(description='Deployment ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Deployment creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Deployment update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    resource_id: str = Field(
        description='Resource ID.', default=..., alias='resourceId'
    )
    resource_type: str = Field(
        description='Resource type.', default=..., alias='resourceType'
    )
    entrypoint: str = Field(
        description='The entrypoint file to use to execute the deployment code.',
        default=...,
    )
    size: int = Field(description='The code size in bytes.', default=...)
    build_id: str = Field(
        description='The current build ID.', default=..., alias='buildId'
    )
    activate: bool = Field(
        description='Whether the deployment should be automatically activated.',
        default=...,
    )
    status: str = Field(description='The deployment status.', default=...)
    build_stdout: str = Field(
        description='The build stdout.', default=..., alias='buildStdout'
    )
    build_stderr: str = Field(
        description='The build stderr.', default=..., alias='buildStderr'
    )


class ExecutionList(CityFrontModel):
    """executionList

    Executions List
    """

    total: int = Field(
        description='Total number of executions documents that matched your query.',
        default=...,
    )
    executions: List[Execution] = Field(
        description='List of executions.', default=...
    )


class Execution(CityFrontModel):
    """execution

    Execution
    """

    id: str = Field(description='Execution ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Execution creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Execution update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    read: List[str] = Field(
        description='Execution read permissions.', default=..., alias='$read'
    )
    function_id: str = Field(
        description='Function ID.', default=..., alias='functionId'
    )
    trigger: str = Field(
        description='The trigger that caused the function to execute. Possible values can be: `http`, `schedule`, or `event`.',
        default=...,
    )
    status: str = Field(
        description='The status of the function execution. Possible values can be: `waiting`, `processing`, `completed`, or `failed`.',
        default=...,
    )
    status_code: int = Field(
        description='The script status code.', default=..., alias='statusCode'
    )
    response: str = Field(
        description='The script response output string. Logs the last 4,000 characters of the execution response output.',
        default=...,
    )
    stderr: str = Field(
        description='The script stderr output string. Logs the last 4,000 characters of the execution stderr output',
        default=...,
    )
    time: float = Field(
        description='The script execution time in seconds.', default=...
    )


class ProjectList(CityFrontModel):
    """projectList

    Projects List
    """

    total: int = Field(
        description='Total number of projects documents that matched your query.',
        default=...,
    )
    projects: List[Project] = Field(
        description='List of projects.', default=...
    )


class Project(CityFrontModel):
    """project

    Project
    """

    id: str = Field(description='Project ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Project creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Project update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    name: str = Field(description='Project name.', default=...)
    description: str = Field(description='Project description.', default=...)
    team_id: str = Field(
        description='Project team ID.', default=..., alias='teamId'
    )
    logo: str = Field(description='Project logo file ID.', default=...)
    url: str = Field(description='Project website URL.', default=...)
    legal_name: str = Field(
        description='Company legal name.', default=..., alias='legalName'
    )
    legal_country: str = Field(
        description='Country code in [ISO 3166-1](http://en.wikipedia.org/wiki/ISO_3166-1) two-character format.',
        default=...,
        alias='legalCountry',
    )
    legal_state: str = Field(
        description='State name.', default=..., alias='legalState'
    )
    legal_city: str = Field(
        description='City name.', default=..., alias='legalCity'
    )
    legal_address: str = Field(
        description='Company Address.', default=..., alias='legalAddress'
    )
    legal_tax_id: str = Field(
        description='Company Tax ID.', default=..., alias='legalTaxId'
    )
    auth_limit: int = Field(
        description='Max users allowed. 0 is unlimited.',
        default=...,
        alias='authLimit',
    )
    platforms: List[Platform] = Field(
        description='List of Platforms.', default=...
    )
    webhooks: List[Webhook] = Field(
        description='List of Webhooks.', default=...
    )
    keys: List[Key] = Field(description='List of API Keys.', default=...)
    domains: List[Domain] = Field(description='List of Domains.', default=...)
    provider_amazon_appid: str = Field(
        description='Amazon OAuth app ID.',
        default=...,
        alias='providerAmazonAppid',
    )
    provider_amazon_secret: str = Field(
        description='Amazon OAuth secret ID.',
        default=...,
        alias='providerAmazonSecret',
    )
    provider_apple_appid: str = Field(
        description='Apple OAuth app ID.',
        default=...,
        alias='providerAppleAppid',
    )
    provider_apple_secret: str = Field(
        description='Apple OAuth secret ID.',
        default=...,
        alias='providerAppleSecret',
    )
    provider_auth0_appid: str = Field(
        description='Auth0 OAuth app ID.',
        default=...,
        alias='providerAuth0Appid',
    )
    provider_auth0_secret: str = Field(
        description='Auth0 OAuth secret ID.',
        default=...,
        alias='providerAuth0Secret',
    )
    provider_autodesk_appid: str = Field(
        description='Autodesk OAuth app ID.',
        default=...,
        alias='providerAutodeskAppid',
    )
    provider_autodesk_secret: str = Field(
        description='Autodesk OAuth secret ID.',
        default=...,
        alias='providerAutodeskSecret',
    )
    provider_bitbucket_appid: str = Field(
        description='BitBucket OAuth app ID.',
        default=...,
        alias='providerBitbucketAppid',
    )
    provider_bitbucket_secret: str = Field(
        description='BitBucket OAuth secret ID.',
        default=...,
        alias='providerBitbucketSecret',
    )
    provider_bitly_appid: str = Field(
        description='Bitly OAuth app ID.',
        default=...,
        alias='providerBitlyAppid',
    )
    provider_bitly_secret: str = Field(
        description='Bitly OAuth secret ID.',
        default=...,
        alias='providerBitlySecret',
    )
    provider_box_appid: str = Field(
        description='Box OAuth app ID.', default=..., alias='providerBoxAppid'
    )
    provider_box_secret: str = Field(
        description='Box OAuth secret ID.',
        default=...,
        alias='providerBoxSecret',
    )
    provider_dailymotion_appid: str = Field(
        description='Dailymotion OAuth app ID.',
        default=...,
        alias='providerDailymotionAppid',
    )
    provider_dailymotion_secret: str = Field(
        description='Dailymotion OAuth secret ID.',
        default=...,
        alias='providerDailymotionSecret',
    )
    provider_discord_appid: str = Field(
        description='Discord OAuth app ID.',
        default=...,
        alias='providerDiscordAppid',
    )
    provider_discord_secret: str = Field(
        description='Discord OAuth secret ID.',
        default=...,
        alias='providerDiscordSecret',
    )
    provider_dropbox_appid: str = Field(
        description='Dropbox OAuth app ID.',
        default=...,
        alias='providerDropboxAppid',
    )
    provider_dropbox_secret: str = Field(
        description='Dropbox OAuth secret ID.',
        default=...,
        alias='providerDropboxSecret',
    )
    provider_facebook_appid: str = Field(
        description='Facebook OAuth app ID.',
        default=...,
        alias='providerFacebookAppid',
    )
    provider_facebook_secret: str = Field(
        description='Facebook OAuth secret ID.',
        default=...,
        alias='providerFacebookSecret',
    )
    provider_github_appid: str = Field(
        description='GitHub OAuth app ID.',
        default=...,
        alias='providerGithubAppid',
    )
    provider_github_secret: str = Field(
        description='GitHub OAuth secret ID.',
        default=...,
        alias='providerGithubSecret',
    )
    provider_gitlab_appid: str = Field(
        description='GitLab OAuth app ID.',
        default=...,
        alias='providerGitlabAppid',
    )
    provider_gitlab_secret: str = Field(
        description='GitLab OAuth secret ID.',
        default=...,
        alias='providerGitlabSecret',
    )
    provider_google_appid: str = Field(
        description='Google OAuth app ID.',
        default=...,
        alias='providerGoogleAppid',
    )
    provider_google_secret: str = Field(
        description='Google OAuth secret ID.',
        default=...,
        alias='providerGoogleSecret',
    )
    provider_linkedin_appid: str = Field(
        description='LinkedIn OAuth app ID.',
        default=...,
        alias='providerLinkedinAppid',
    )
    provider_linkedin_secret: str = Field(
        description='LinkedIn OAuth secret ID.',
        default=...,
        alias='providerLinkedinSecret',
    )
    provider_microsoft_appid: str = Field(
        description='Microsoft OAuth app ID.',
        default=...,
        alias='providerMicrosoftAppid',
    )
    provider_microsoft_secret: str = Field(
        description='Microsoft OAuth secret ID.',
        default=...,
        alias='providerMicrosoftSecret',
    )
    provider_notion_appid: str = Field(
        description='Notion OAuth app ID.',
        default=...,
        alias='providerNotionAppid',
    )
    provider_notion_secret: str = Field(
        description='Notion OAuth secret ID.',
        default=...,
        alias='providerNotionSecret',
    )
    provider_okta_appid: str = Field(
        description='Okta OAuth app ID.',
        default=...,
        alias='providerOktaAppid',
    )
    provider_okta_secret: str = Field(
        description='Okta OAuth secret ID.',
        default=...,
        alias='providerOktaSecret',
    )
    provider_paypal_appid: str = Field(
        description='PayPal OAuth app ID.',
        default=...,
        alias='providerPaypalAppid',
    )
    provider_paypal_secret: str = Field(
        description='PayPal OAuth secret ID.',
        default=...,
        alias='providerPaypalSecret',
    )
    provider_paypal_sandbox_appid: str = Field(
        description='PayPal OAuth app ID.',
        default=...,
        alias='providerPaypalSandboxAppid',
    )
    provider_paypal_sandbox_secret: str = Field(
        description='PayPal OAuth secret ID.',
        default=...,
        alias='providerPaypalSandboxSecret',
    )
    provider_salesforce_appid: str = Field(
        description='Salesforce OAuth app ID.',
        default=...,
        alias='providerSalesforceAppid',
    )
    provider_salesforce_secret: str = Field(
        description='Salesforce OAuth secret ID.',
        default=...,
        alias='providerSalesforceSecret',
    )
    provider_slack_appid: str = Field(
        description='Slack OAuth app ID.',
        default=...,
        alias='providerSlackAppid',
    )
    provider_slack_secret: str = Field(
        description='Slack OAuth secret ID.',
        default=...,
        alias='providerSlackSecret',
    )
    provider_spotify_appid: str = Field(
        description='Spotify OAuth app ID.',
        default=...,
        alias='providerSpotifyAppid',
    )
    provider_spotify_secret: str = Field(
        description='Spotify OAuth secret ID.',
        default=...,
        alias='providerSpotifySecret',
    )
    provider_stripe_appid: str = Field(
        description='Stripe OAuth app ID.',
        default=...,
        alias='providerStripeAppid',
    )
    provider_stripe_secret: str = Field(
        description='Stripe OAuth secret ID.',
        default=...,
        alias='providerStripeSecret',
    )
    provider_tradeshift_appid: str = Field(
        description='Tradeshift OAuth app ID.',
        default=...,
        alias='providerTradeshiftAppid',
    )
    provider_tradeshift_secret: str = Field(
        description='Tradeshift OAuth secret ID.',
        default=...,
        alias='providerTradeshiftSecret',
    )
    provider_tradeshift_box_appid: str = Field(
        description='Tradeshift OAuth app ID.',
        default=...,
        alias='providerTradeshiftBoxAppid',
    )
    provider_tradeshift_box_secret: str = Field(
        description='Tradeshift OAuth secret ID.',
        default=...,
        alias='providerTradeshiftBoxSecret',
    )
    provider_twitch_appid: str = Field(
        description='Twitch OAuth app ID.',
        default=...,
        alias='providerTwitchAppid',
    )
    provider_twitch_secret: str = Field(
        description='Twitch OAuth secret ID.',
        default=...,
        alias='providerTwitchSecret',
    )
    provider_wordpress_appid: str = Field(
        description='WordPress OAuth app ID.',
        default=...,
        alias='providerWordpressAppid',
    )
    provider_wordpress_secret: str = Field(
        description='WordPress OAuth secret ID.',
        default=...,
        alias='providerWordpressSecret',
    )
    provider_yahoo_appid: str = Field(
        description='Yahoo OAuth app ID.',
        default=...,
        alias='providerYahooAppid',
    )
    provider_yahoo_secret: str = Field(
        description='Yahoo OAuth secret ID.',
        default=...,
        alias='providerYahooSecret',
    )
    provider_yammer_appid: str = Field(
        description='Yammer OAuth app ID.',
        default=...,
        alias='providerYammerAppid',
    )
    provider_yammer_secret: str = Field(
        description='Yammer OAuth secret ID.',
        default=...,
        alias='providerYammerSecret',
    )
    provider_yandex_appid: str = Field(
        description='Yandex OAuth app ID.',
        default=...,
        alias='providerYandexAppid',
    )
    provider_yandex_secret: str = Field(
        description='Yandex OAuth secret ID.',
        default=...,
        alias='providerYandexSecret',
    )
    provider_zoom_appid: str = Field(
        description='Zoom OAuth app ID.',
        default=...,
        alias='providerZoomAppid',
    )
    provider_zoom_secret: str = Field(
        description='Zoom OAuth secret ID.',
        default=...,
        alias='providerZoomSecret',
    )
    provider_mock_appid: str = Field(
        description='Mock OAuth app ID.',
        default=...,
        alias='providerMockAppid',
    )
    provider_mock_secret: str = Field(
        description='Mock OAuth secret ID.',
        default=...,
        alias='providerMockSecret',
    )
    auth_email_password: bool = Field(
        description='Email/Password auth method status',
        default=...,
        alias='authEmailPassword',
    )
    auth_users_auth_magic_u_r_l: bool = Field(
        description='Magic URL auth method status',
        default=...,
        alias='authUsersAuthMagicURL',
    )
    auth_anonymous: bool = Field(
        description='Anonymous auth method status',
        default=...,
        alias='authAnonymous',
    )
    auth_invites: bool = Field(
        description='Invites auth method status',
        default=...,
        alias='authInvites',
    )
    auth_j_w_t: bool = Field(
        description='JWT auth method status', default=..., alias='authJWT'
    )
    auth_phone: bool = Field(
        description='Phone auth method status', default=..., alias='authPhone'
    )
    service_status_for_account: bool = Field(
        description='Account service status',
        default=...,
        alias='serviceStatusForAccount',
    )
    service_status_for_avatars: bool = Field(
        description='Avatars service status',
        default=...,
        alias='serviceStatusForAvatars',
    )
    service_status_for_databases: bool = Field(
        description='Databases service status',
        default=...,
        alias='serviceStatusForDatabases',
    )
    service_status_for_locale: bool = Field(
        description='Locale service status',
        default=...,
        alias='serviceStatusForLocale',
    )
    service_status_for_health: bool = Field(
        description='Health service status',
        default=...,
        alias='serviceStatusForHealth',
    )
    service_status_for_storage: bool = Field(
        description='Storage service status',
        default=...,
        alias='serviceStatusForStorage',
    )
    service_status_for_teams: bool = Field(
        description='Teams service status',
        default=...,
        alias='serviceStatusForTeams',
    )
    service_status_for_users: bool = Field(
        description='Users service status',
        default=...,
        alias='serviceStatusForUsers',
    )
    service_status_for_functions: bool = Field(
        description='Functions service status',
        default=...,
        alias='serviceStatusForFunctions',
    )


class Platform(CityFrontModel):
    """platform

    Platform
    """

    id: str = Field(description='Platform ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Project creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Project update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    name: str = Field(description='Platform name.', default=...)
    type: str = Field(
        description='Platform type. Possible values are: web, flutter-ios, flutter-android, ios, android, and unity.',
        default=...,
    )
    key: str = Field(
        description='Platform Key. iOS bundle ID or Android package name.  Empty string for other platforms.',
        default=...,
    )
    store: str = Field(
        description='App store or Google Play store ID.', default=...
    )
    hostname: str = Field(
        description='Web app hostname. Empty string for other platforms.',
        default=...,
    )
    http_user: str = Field(
        description='HTTP basic authentication username.',
        default=...,
        alias='httpUser',
    )
    http_pass: str = Field(
        description='HTTP basic authentication password.',
        default=...,
        alias='httpPass',
    )


class Webhook(CityFrontModel):
    """webhook

    Webhook
    """

    id: str = Field(description='Webhook ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Webhook creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Webhook update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    name: str = Field(description='Webhook name.', default=...)
    url: str = Field(description='Webhook URL endpoint.', default=...)
    events: List[str] = Field(
        description='Webhook trigger events.', default=...
    )
    security: bool = Field(
        description='Indicated if SSL / TLS Certificate verification is enabled.',
        default=...,
    )
    http_user: str = Field(
        description='HTTP basic authentication username.',
        default=...,
        alias='httpUser',
    )
    http_pass: str = Field(
        description='HTTP basic authentication password.',
        default=...,
        alias='httpPass',
    )
    signature_key: str = Field(
        description='Signature key which can be used to validated incoming',
        default=...,
        alias='signatureKey',
    )


class Key(CityFrontModel):
    """key

    Key
    """

    id: str = Field(description='Key ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Key creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Key update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    name: str = Field(description='Key name.', default=...)
    expire: int = Field(
        description='Key expiration in Unix timestamp.', default=...
    )
    scopes: List[str] = Field(
        description='Allowed permission scopes.', default=...
    )
    secret: str = Field(description='Secret key.', default=...)


class Domain(CityFrontModel):
    """domain

    Domain
    """

    id: str = Field(description='Domain ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Domain creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    updated_at: int = Field(
        description='Domain update date in Unix timestamp.',
        default=...,
        alias='$updatedAt',
    )
    domain: str = Field(description='Domain name.', default=...)
    registerable: str = Field(
        description='Registerable domain name.', default=...
    )
    tld: str = Field(description='TLD name.', default=...)
    verification: bool = Field(
        description='Verification process status.', default=...
    )
    certificate_id: str = Field(
        description='Certificate ID.', default=..., alias='certificateId'
    )


class WebhookList(CityFrontModel):
    """webhookList

    Webhooks List
    """

    total: int = Field(
        description='Total number of webhooks documents that matched your query.',
        default=...,
    )
    webhooks: List[Webhook] = Field(
        description='List of webhooks.', default=...
    )


class KeyList(CityFrontModel):
    """keyList

    API Keys List
    """

    total: int = Field(
        description='Total number of keys documents that matched your query.',
        default=...,
    )
    keys: List[Key] = Field(description='List of keys.', default=...)


class PlatformList(CityFrontModel):
    """platformList

    Platforms List
    """

    total: int = Field(
        description='Total number of platforms documents that matched your query.',
        default=...,
    )
    platforms: List[Platform] = Field(
        description='List of platforms.', default=...
    )


class DomainList(CityFrontModel):
    """domainList

    Domains List
    """

    total: int = Field(
        description='Total number of domains documents that matched your query.',
        default=...,
    )
    domains: List[Domain] = Field(description='List of domains.', default=...)


class CountryList(CityFrontModel):
    """countryList

    Countries List
    """

    total: int = Field(
        description='Total number of countries documents that matched your query.',
        default=...,
    )
    countries: List[Country] = Field(
        description='List of countries.', default=...
    )


class Country(CityFrontModel):
    """country

    Country
    """

    name: str = Field(description='Country name.', default=...)
    code: str = Field(
        description='Country two-character ISO 3166-1 alpha code.', default=...
    )


class ContinentList(CityFrontModel):
    """continentList

    Continents List
    """

    total: int = Field(
        description='Total number of continents documents that matched your query.',
        default=...,
    )
    continents: List[Continent] = Field(
        description='List of continents.', default=...
    )


class Continent(CityFrontModel):
    """continent

    Continent
    """

    name: str = Field(description='Continent name.', default=...)
    code: str = Field(description='Continent two letter code.', default=...)


class LanguageList(CityFrontModel):
    """languageList

    Languages List
    """

    total: int = Field(
        description='Total number of languages documents that matched your query.',
        default=...,
    )
    languages: List[Language] = Field(
        description='List of languages.', default=...
    )


class Language(CityFrontModel):
    """language

    Language
    """

    name: str = Field(description='Language name.', default=...)
    code: str = Field(
        description='Language two-character ISO 639-1 codes.', default=...
    )
    native_name: str = Field(
        description='Language native name.', default=..., alias='nativeName'
    )


class CurrencyList(CityFrontModel):
    """currencyList

    Currencies List
    """

    total: int = Field(
        description='Total number of currencies documents that matched your query.',
        default=...,
    )
    currencies: List[Currency] = Field(
        description='List of currencies.', default=...
    )


class Currency(CityFrontModel):
    """currency

    Currency
    """

    symbol: str = Field(description='Currency symbol.', default=...)
    name: str = Field(description='Currency name.', default=...)
    symbol_native: str = Field(
        description='Currency native symbol.',
        default=...,
        alias='symbolNative',
    )
    decimal_digits: int = Field(
        description='Number of decimal digits.',
        default=...,
        alias='decimalDigits',
    )
    rounding: float = Field(
        description='Currency digit rounding.', default=...
    )
    code: str = Field(
        description='Currency code in [ISO 4217-1](http://en.wikipedia.org/wiki/ISO_4217) three-character format.',
        default=...,
    )
    name_plural: str = Field(
        description='Currency plural name', default=..., alias='namePlural'
    )


class PhoneList(CityFrontModel):
    """phoneList

    Phones List
    """

    total: int = Field(
        description='Total number of phones documents that matched your query.',
        default=...,
    )
    phones: List[Phone] = Field(description='List of phones.', default=...)


class Phone(CityFrontModel):
    """phone

    Phone
    """

    code: str = Field(description='Phone code.', default=...)
    country_code: str = Field(
        description='Country two-character ISO 3166-1 alpha code.',
        default=...,
        alias='countryCode',
    )
    country_name: str = Field(
        description='Country name.', default=..., alias='countryName'
    )


class MetricList(CityFrontModel):
    """metricList

    Metric List
    """

    total: int = Field(
        description='Total number of metrics documents that matched your query.',
        default=...,
    )
    metrics: List[Metric] = Field(description='List of metrics.', default=...)


class Metric(CityFrontModel):
    """metric

    Metric
    """

    value: int = Field(
        description='The value of this metric at the timestamp.', default=...
    )
    timestamp: int = Field(
        description='The UNIX timestamp at which this metric was aggregated.',
        default=...,
    )


class AttributeList(CityFrontModel):
    """attributeList

    Attributes List
    """

    total: int = Field(
        description='Total number of attributes in the given collection.',
        default=...,
    )
    attributes: List[Any] = Field(
        description='List of attributes.', default=...
    )


class AttributeString(CityFrontModel):
    """attributeString

    AttributeString
    """

    key: str = Field(description='Attribute Key.', default=...)
    type: str = Field(description='Attribute type.', default=...)
    status: str = Field(
        description='Attribute status. Possible values: `available`, `processing`, `deleting`, `stuck`, or `failed`',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=UNSET
    )
    size: int = Field(description='Attribute size.', default=...)
    default: Union[Unset, str] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )


class AttributeInteger(CityFrontModel):
    """attributeInteger

    AttributeInteger
    """

    key: str = Field(description='Attribute Key.', default=...)
    type: str = Field(description='Attribute type.', default=...)
    status: str = Field(
        description='Attribute status. Possible values: `available`, `processing`, `deleting`, `stuck`, or `failed`',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=UNSET
    )
    min_: Union[Unset, int] = Field(
        description='Minimum value to enforce for new documents.',
        default=UNSET,
        alias='min',
    )
    max_: Union[Unset, int] = Field(
        description='Maximum value to enforce for new documents.',
        default=UNSET,
        alias='max',
    )
    default: Union[Unset, int] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )


class AttributeFloat(CityFrontModel):
    """attributeFloat

    AttributeFloat
    """

    key: str = Field(description='Attribute Key.', default=...)
    type: str = Field(description='Attribute type.', default=...)
    status: str = Field(
        description='Attribute status. Possible values: `available`, `processing`, `deleting`, `stuck`, or `failed`',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=UNSET
    )
    min_: Union[Unset, float] = Field(
        description='Minimum value to enforce for new documents.',
        default=UNSET,
        alias='min',
    )
    max_: Union[Unset, float] = Field(
        description='Maximum value to enforce for new documents.',
        default=UNSET,
        alias='max',
    )
    default: Union[Unset, float] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )


class AttributeBoolean(CityFrontModel):
    """attributeBoolean

    AttributeBoolean
    """

    key: str = Field(description='Attribute Key.', default=...)
    type: str = Field(description='Attribute type.', default=...)
    status: str = Field(
        description='Attribute status. Possible values: `available`, `processing`, `deleting`, `stuck`, or `failed`',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=UNSET
    )
    default: Union[Unset, bool] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )


class AttributeEmail(CityFrontModel):
    """attributeEmail

    AttributeEmail
    """

    key: str = Field(description='Attribute Key.', default=...)
    type: str = Field(description='Attribute type.', default=...)
    status: str = Field(
        description='Attribute status. Possible values: `available`, `processing`, `deleting`, `stuck`, or `failed`',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=UNSET
    )
    format_: str = Field(
        description='String format.', default=..., alias='format'
    )
    default: Union[Unset, str] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )


class AttributeEnum(CityFrontModel):
    """attributeEnum

    AttributeEnum
    """

    key: str = Field(description='Attribute Key.', default=...)
    type: str = Field(description='Attribute type.', default=...)
    status: str = Field(
        description='Attribute status. Possible values: `available`, `processing`, `deleting`, `stuck`, or `failed`',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=UNSET
    )
    elements: List[str] = Field(
        description='Array of elements in enumerated type.', default=...
    )
    format_: str = Field(
        description='String format.', default=..., alias='format'
    )
    default: Union[Unset, str] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )


class AttributeIp(CityFrontModel):
    """attributeIp

    AttributeIP
    """

    key: str = Field(description='Attribute Key.', default=...)
    type: str = Field(description='Attribute type.', default=...)
    status: str = Field(
        description='Attribute status. Possible values: `available`, `processing`, `deleting`, `stuck`, or `failed`',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=UNSET
    )
    format_: str = Field(
        description='String format.', default=..., alias='format'
    )
    default: Union[Unset, str] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )


class AttributeUrl(CityFrontModel):
    """attributeUrl

    AttributeURL
    """

    key: str = Field(description='Attribute Key.', default=...)
    type: str = Field(description='Attribute type.', default=...)
    status: str = Field(
        description='Attribute status. Possible values: `available`, `processing`, `deleting`, `stuck`, or `failed`',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=UNSET
    )
    format_: str = Field(
        description='String format.', default=..., alias='format'
    )
    default: Union[Unset, str] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )


class Token(CityFrontModel):
    """token

    Token
    """

    id: str = Field(description='Token ID.', default=..., alias='$id')
    created_at: int = Field(
        description='Token creation date in Unix timestamp.',
        default=...,
        alias='$createdAt',
    )
    user_id: str = Field(description='User ID.', default=..., alias='userId')
    secret: str = Field(
        description='Token secret key. This will return an empty string unless the response is returned using an API key or as part of a webhook payload.',
        default=...,
    )
    expire: int = Field(
        description='Token expiration date in Unix timestamp.', default=...
    )


class Jwt(CityFrontModel):
    """jwt

    JWT
    """

    jwt: str = Field(description='JWT encoded string.', default=...)


class Locale(CityFrontModel):
    """locale

    Locale
    """

    ip: str = Field(description='User IP address.', default=...)
    country_code: str = Field(
        description='Country code in [ISO 3166-1](http://en.wikipedia.org/wiki/ISO_3166-1) two-character format',
        default=...,
        alias='countryCode',
    )
    country: str = Field(
        description='Country name. This field support localization.',
        default=...,
    )
    continent_code: str = Field(
        description='Continent code. A two character continent code "AF" for Africa, "AN" for Antarctica, "AS" for Asia, "EU" for Europe, "NA" for North America, "OC" for Oceania, and "SA" for South America.',
        default=...,
        alias='continentCode',
    )
    continent: str = Field(
        description='Continent name. This field support localization.',
        default=...,
    )
    eu: bool = Field(
        description='True if country is part of the Europian Union.',
        default=...,
    )
    currency: str = Field(
        description='Currency code in [ISO 4217-1](http://en.wikipedia.org/wiki/ISO_4217) three-character format',
        default=...,
    )


class HealthAntivirus(CityFrontModel):
    """healthAntivirus

    Health Antivirus
    """

    version: str = Field(description='Antivirus version.', default=...)
    status: str = Field(
        description='Antivirus status. Possible values can are: `disabled`, `offline`, `online`',
        default=...,
    )


class HealthQueue(CityFrontModel):
    """healthQueue

    Health Queue
    """

    size: int = Field(
        description='Amount of actions in the queue.', default=...
    )


class HealthStatus(CityFrontModel):
    """healthStatus

    Health Status
    """

    ping: int = Field(
        description='Duration in milliseconds how long the health check took.',
        default=...,
    )
    status: str = Field(
        description='Service status. Possible values can are: `pass`, `fail`',
        default=...,
    )


class HealthTime(CityFrontModel):
    """healthTime

    Health Time
    """

    remote_time: int = Field(
        description='Current unix timestamp on trustful remote server.',
        default=...,
        alias='remoteTime',
    )
    local_time: int = Field(
        description='Current unix timestamp of local server where Appwrite runs.',
        default=...,
        alias='localTime',
    )
    diff: int = Field(
        description='Difference of unix remote and local timestamps in milliseconds.',
        default=...,
    )


class UsageDatabases(CityFrontModel):
    """usageDatabases

    UsageDatabases
    """

    range_: str = Field(
        description='The time range of the usage stats.',
        default=...,
        alias='range',
    )
    databases_count: List[MetricList] = Field(
        description='Aggregated stats for total number of documents.',
        default=...,
        alias='databasesCount',
    )
    documents_count: List[MetricList] = Field(
        description='Aggregated stats for total number of documents.',
        default=...,
        alias='documentsCount',
    )
    collections_count: List[MetricList] = Field(
        description='Aggregated stats for total number of collections.',
        default=...,
        alias='collectionsCount',
    )
    databases_create: List[MetricList] = Field(
        description='Aggregated stats for documents created.',
        default=...,
        alias='databasesCreate',
    )
    databases_read: List[MetricList] = Field(
        description='Aggregated stats for documents read.',
        default=...,
        alias='databasesRead',
    )
    databases_update: List[MetricList] = Field(
        description='Aggregated stats for documents updated.',
        default=...,
        alias='databasesUpdate',
    )
    databases_delete: List[MetricList] = Field(
        description='Aggregated stats for total number of collections.',
        default=...,
        alias='databasesDelete',
    )
    documents_create: List[MetricList] = Field(
        description='Aggregated stats for documents created.',
        default=...,
        alias='documentsCreate',
    )
    documents_read: List[MetricList] = Field(
        description='Aggregated stats for documents read.',
        default=...,
        alias='documentsRead',
    )
    documents_update: List[MetricList] = Field(
        description='Aggregated stats for documents updated.',
        default=...,
        alias='documentsUpdate',
    )
    documents_delete: List[MetricList] = Field(
        description='Aggregated stats for documents deleted.',
        default=...,
        alias='documentsDelete',
    )
    collections_create: List[MetricList] = Field(
        description='Aggregated stats for collections created.',
        default=...,
        alias='collectionsCreate',
    )
    collections_read: List[MetricList] = Field(
        description='Aggregated stats for collections read.',
        default=...,
        alias='collectionsRead',
    )
    collections_update: List[MetricList] = Field(
        description='Aggregated stats for collections updated.',
        default=...,
        alias='collectionsUpdate',
    )
    collections_delete: List[MetricList] = Field(
        description='Aggregated stats for collections delete.',
        default=...,
        alias='collectionsDelete',
    )


class UsageDatabase(CityFrontModel):
    """usageDatabase

    UsageDatabase
    """

    range_: str = Field(
        description='The time range of the usage stats.',
        default=...,
        alias='range',
    )
    documents_count: List[MetricList] = Field(
        description='Aggregated stats for total number of documents.',
        default=...,
        alias='documentsCount',
    )
    collections_count: List[MetricList] = Field(
        description='Aggregated stats for total number of collections.',
        default=...,
        alias='collectionsCount',
    )
    documents_create: List[MetricList] = Field(
        description='Aggregated stats for documents created.',
        default=...,
        alias='documentsCreate',
    )
    documents_read: List[MetricList] = Field(
        description='Aggregated stats for documents read.',
        default=...,
        alias='documentsRead',
    )
    documents_update: List[MetricList] = Field(
        description='Aggregated stats for documents updated.',
        default=...,
        alias='documentsUpdate',
    )
    documents_delete: List[MetricList] = Field(
        description='Aggregated stats for documents deleted.',
        default=...,
        alias='documentsDelete',
    )
    collections_create: List[MetricList] = Field(
        description='Aggregated stats for collections created.',
        default=...,
        alias='collectionsCreate',
    )
    collections_read: List[MetricList] = Field(
        description='Aggregated stats for collections read.',
        default=...,
        alias='collectionsRead',
    )
    collections_update: List[MetricList] = Field(
        description='Aggregated stats for collections updated.',
        default=...,
        alias='collectionsUpdate',
    )
    collections_delete: List[MetricList] = Field(
        description='Aggregated stats for collections delete.',
        default=...,
        alias='collectionsDelete',
    )


class UsageCollection(CityFrontModel):
    """usageCollection

    UsageCollection
    """

    range_: str = Field(
        description='The time range of the usage stats.',
        default=...,
        alias='range',
    )
    documents_count: List[MetricList] = Field(
        description='Aggregated stats for total number of documents.',
        default=...,
        alias='documentsCount',
    )
    documents_create: List[MetricList] = Field(
        description='Aggregated stats for documents created.',
        default=...,
        alias='documentsCreate',
    )
    documents_read: List[MetricList] = Field(
        description='Aggregated stats for documents read.',
        default=...,
        alias='documentsRead',
    )
    documents_update: List[MetricList] = Field(
        description='Aggregated stats for documents updated.',
        default=...,
        alias='documentsUpdate',
    )
    documents_delete: List[MetricList] = Field(
        description='Aggregated stats for documents deleted.',
        default=...,
        alias='documentsDelete',
    )


class UsageUsers(CityFrontModel):
    """usageUsers

    UsageUsers
    """

    range_: str = Field(
        description='The time range of the usage stats.',
        default=...,
        alias='range',
    )
    users_count: List[MetricList] = Field(
        description='Aggregated stats for total number of users.',
        default=...,
        alias='usersCount',
    )
    users_create: List[MetricList] = Field(
        description='Aggregated stats for users created.',
        default=...,
        alias='usersCreate',
    )
    users_read: List[MetricList] = Field(
        description='Aggregated stats for users read.',
        default=...,
        alias='usersRead',
    )
    users_update: List[MetricList] = Field(
        description='Aggregated stats for users updated.',
        default=...,
        alias='usersUpdate',
    )
    users_delete: List[MetricList] = Field(
        description='Aggregated stats for users deleted.',
        default=...,
        alias='usersDelete',
    )
    sessions_create: List[MetricList] = Field(
        description='Aggregated stats for sessions created.',
        default=...,
        alias='sessionsCreate',
    )
    sessions_provider_create: List[MetricList] = Field(
        description='Aggregated stats for sessions created for a provider ( email, anonymous or oauth2 ).',
        default=...,
        alias='sessionsProviderCreate',
    )
    sessions_delete: List[MetricList] = Field(
        description='Aggregated stats for sessions deleted.',
        default=...,
        alias='sessionsDelete',
    )


class UsageStorage(CityFrontModel):
    """usageStorage

    StorageUsage
    """

    range_: str = Field(
        description='The time range of the usage stats.',
        default=...,
        alias='range',
    )
    files_storage: List[MetricList] = Field(
        description='Aggregated stats for the occupied storage size by files (in bytes).',
        default=...,
        alias='filesStorage',
    )
    tags_storage: List[MetricList] = Field(
        description='Aggregated stats for the occupied storage size by tags (in bytes).',
        default=...,
        alias='tagsStorage',
    )
    files_count: List[MetricList] = Field(
        description='Aggregated stats for total number of files.',
        default=...,
        alias='filesCount',
    )
    buckets_count: List[MetricList] = Field(
        description='Aggregated stats for total number of buckets.',
        default=...,
        alias='bucketsCount',
    )
    buckets_create: List[MetricList] = Field(
        description='Aggregated stats for buckets created.',
        default=...,
        alias='bucketsCreate',
    )
    buckets_read: List[MetricList] = Field(
        description='Aggregated stats for buckets read.',
        default=...,
        alias='bucketsRead',
    )
    buckets_update: List[MetricList] = Field(
        description='Aggregated stats for buckets updated.',
        default=...,
        alias='bucketsUpdate',
    )
    buckets_delete: List[MetricList] = Field(
        description='Aggregated stats for buckets deleted.',
        default=...,
        alias='bucketsDelete',
    )
    files_create: List[MetricList] = Field(
        description='Aggregated stats for files created.',
        default=...,
        alias='filesCreate',
    )
    files_read: List[MetricList] = Field(
        description='Aggregated stats for files read.',
        default=...,
        alias='filesRead',
    )
    files_update: List[MetricList] = Field(
        description='Aggregated stats for files updated.',
        default=...,
        alias='filesUpdate',
    )
    files_delete: List[MetricList] = Field(
        description='Aggregated stats for files deleted.',
        default=...,
        alias='filesDelete',
    )


class UsageBuckets(CityFrontModel):
    """usageBuckets

    UsageBuckets
    """

    range_: str = Field(
        description='The time range of the usage stats.',
        default=...,
        alias='range',
    )
    files_count: List[MetricList] = Field(
        description='Aggregated stats for total number of files in this bucket.',
        default=...,
        alias='filesCount',
    )
    files_storage: List[MetricList] = Field(
        description='Aggregated stats for total storage of files in this bucket.',
        default=...,
        alias='filesStorage',
    )
    files_create: List[MetricList] = Field(
        description='Aggregated stats for files created.',
        default=...,
        alias='filesCreate',
    )
    files_read: List[MetricList] = Field(
        description='Aggregated stats for files read.',
        default=...,
        alias='filesRead',
    )
    files_update: List[MetricList] = Field(
        description='Aggregated stats for files updated.',
        default=...,
        alias='filesUpdate',
    )
    files_delete: List[MetricList] = Field(
        description='Aggregated stats for files deleted.',
        default=...,
        alias='filesDelete',
    )


class UsageFunctions(CityFrontModel):
    """usageFunctions

    UsageFunctions
    """

    range_: str = Field(
        description='The time range of the usage stats.',
        default=...,
        alias='range',
    )
    functions_executions: List[MetricList] = Field(
        description='Aggregated stats for function executions.',
        default=...,
        alias='functionsExecutions',
    )
    functions_failures: List[MetricList] = Field(
        description='Aggregated stats for function execution failures.',
        default=...,
        alias='functionsFailures',
    )
    functions_compute: List[MetricList] = Field(
        description='Aggregated stats for function execution duration.',
        default=...,
        alias='functionsCompute',
    )


class UsageProject(CityFrontModel):
    """usageProject

    UsageProject
    """

    range_: str = Field(
        description='The time range of the usage stats.',
        default=...,
        alias='range',
    )
    requests: List[MetricList] = Field(
        description='Aggregated stats for number of requests.', default=...
    )
    network: List[MetricList] = Field(
        description='Aggregated stats for consumed bandwidth.', default=...
    )
    functions: List[MetricList] = Field(
        description='Aggregated stats for function executions.', default=...
    )
    documents: List[MetricList] = Field(
        description='Aggregated stats for number of documents.', default=...
    )
    collections: List[MetricList] = Field(
        description='Aggregated stats for number of collections.', default=...
    )
    users: List[MetricList] = Field(
        description='Aggregated stats for number of users.', default=...
    )
    storage: List[MetricList] = Field(
        description='Aggregated stats for the occupied storage size (in bytes).',
        default=...,
    )


class Payload(CityFrontModel):
    """payload"""

    user_id: str = Field(
        description='Unique Id. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='userId',
    )
    email: str = Field(description='User email.', default=...)
    password: str = Field(
        description='User password. Must be at least 8 chars.', default=...
    )
    name: Union[Unset, str] = Field(
        description='User name. Max length: 128 chars.', default=UNSET
    )


class Payload1(CityFrontModel):
    """payload1"""

    email: str = Field(description='User email.', default=...)
    password: str = Field(
        description='User password. Must be at least 8 chars.', default=...
    )


class Payload2(CityFrontModel):
    """payload2"""

    name: str = Field(
        description='User name. Max length: 128 chars.', default=...
    )


class Payload3(CityFrontModel):
    """payload3"""

    password: str = Field(
        description='New user password. Must be at least 8 chars.', default=...
    )
    old_password: Union[Unset, str] = Field(
        description='Current user password. Must be at least 8 chars.',
        default=UNSET,
        alias='oldPassword',
    )


class Payload4(CityFrontModel):
    """payload4"""

    number: str = Field(
        description="Phone number. Format this number with a leading '+' and a country code, e.g., +16175551212.",
        default=...,
    )
    password: str = Field(
        description='User password. Must be at least 8 chars.', default=...
    )


class Payload5(CityFrontModel):
    """payload5"""

    prefs: Payload5PropPrefs = Field(
        description='Prefs key-value JSON object.', default=...
    )


class Payload5PropPrefs(CityFrontModel):
    """Payload5PropPrefs

    Prefs key-value JSON object.
    """


class Payload6(CityFrontModel):
    """payload6"""

    email: str = Field(description='User email.', default=...)
    url: str = Field(
        description='URL to redirect the user back to your app from the recovery email. Only URLs from hostnames in your project platform list are allowed. This requirement helps to prevent an [open redirect](https://cheatsheetseries.owasp.org/cheatsheets/Unvalidated_Redirects_and_Forwards_Cheat_Sheet.html) attack against your project API.',
        default=...,
    )


class Payload7(CityFrontModel):
    """payload7"""

    user_id: str = Field(description='User ID.', default=..., alias='userId')
    secret: str = Field(description='Valid reset token.', default=...)
    password: str = Field(
        description='New user password. Must be at least 8 chars.', default=...
    )
    password_again: str = Field(
        description='Repeat new user password. Must be at least 8 chars.',
        default=...,
        alias='passwordAgain',
    )


class Payload9(CityFrontModel):
    """payload9"""

    user_id: str = Field(
        description='Unique Id. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='userId',
    )
    email: str = Field(description='User email.', default=...)
    url: Union[Unset, str] = Field(
        description='URL to redirect the user back to your app from the magic URL login. Only URLs from hostnames in your project platform list are allowed. This requirement helps to prevent an [open redirect](https://cheatsheetseries.owasp.org/cheatsheets/Unvalidated_Redirects_and_Forwards_Cheat_Sheet.html) attack against your project API.',
        default=UNSET,
    )


class Payload10(CityFrontModel):
    """payload10"""

    user_id: str = Field(description='User ID.', default=..., alias='userId')
    secret: str = Field(description='Valid verification token.', default=...)


class Payload11(CityFrontModel):
    """payload11"""

    user_id: str = Field(
        description='Unique Id. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='userId',
    )
    number: str = Field(
        description="Phone number. Format this number with a leading '+' and a country code, e.g., +16175551212.",
        default=...,
    )


class Payload13(CityFrontModel):
    """payload13"""

    url: str = Field(
        description='URL to redirect the user back to your app from the verification email. Only URLs from hostnames in your project platform list are allowed. This requirement helps to prevent an [open redirect](https://cheatsheetseries.owasp.org/cheatsheets/Unvalidated_Redirects_and_Forwards_Cheat_Sheet.html) attack against your project API.',
        default=...,
    )


class Payload16(CityFrontModel):
    """payload16"""

    database_id: str = Field(
        description='Unique Id. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='databaseId',
    )
    name: str = Field(
        description='Collection name. Max length: 128 chars.', default=...
    )


class Payload17(CityFrontModel):
    """payload17"""

    name: str = Field(
        description='Collection name. Max length: 128 chars.', default=...
    )


class Payload18(CityFrontModel):
    """payload18"""

    collection_id: str = Field(
        description='Unique Id. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='collectionId',
    )
    name: str = Field(
        description='Collection name. Max length: 128 chars.', default=...
    )
    permission: str = Field(
        description="Specifies the permissions model used in this collection, which accepts either 'collection' or 'document'. For 'collection' level permission, the permissions specified in read and write params are applied to all documents in the collection. For 'document' level permissions, read and write permissions are specified in each document. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.",
        default=...,
    )
    read: List[str] = Field(
        description='An array of strings with read permissions. By default no user is granted with any read permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=...,
    )
    write: List[str] = Field(
        description='An array of strings with write permissions. By default no user is granted with any write permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=...,
    )


class Payload19(CityFrontModel):
    """payload19"""

    name: str = Field(
        description='Collection name. Max length: 128 chars.', default=...
    )
    permission: str = Field(
        description='Permissions type model to use for reading documents in this collection. You can use collection-level permission set once on the collection using the `read` and `write` params, or you can set document-level permission where each document read and write params will decide who has access to read and write to each document individually. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=...,
    )
    read: Union[Unset, List[str]] = Field(
        description='An array of strings with read permissions. By default inherits the existing read permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    write: Union[Unset, List[str]] = Field(
        description='An array of strings with write permissions. By default inherits the existing write permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    enabled: Union[Unset, bool] = Field(
        description='Is collection enabled?', default=True
    )


class Payload20(CityFrontModel):
    """payload20"""

    key: str = Field(description='Attribute Key.', default=...)
    required: bool = Field(description='Is attribute required?', default=...)
    default: Union[Unset, bool] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=False
    )


class Payload21(CityFrontModel):
    """payload21"""

    key: str = Field(description='Attribute Key.', default=...)
    required: bool = Field(description='Is attribute required?', default=...)
    default: Union[Unset, str] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=False
    )


class Payload22(CityFrontModel):
    """payload22"""

    key: str = Field(description='Attribute Key.', default=...)
    elements: List[str] = Field(
        description='Array of elements in enumerated type. Uses length of longest element to determine size. Maximum of 100 elements are allowed, each 4096 characters long.',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    default: Union[Unset, str] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=False
    )


class Payload23(CityFrontModel):
    """payload23"""

    key: str = Field(description='Attribute Key.', default=...)
    required: bool = Field(description='Is attribute required?', default=...)
    min_: Union[Unset, float] = Field(
        description='Minimum value to enforce on new documents',
        default=UNSET,
        alias='min',
    )
    max_: Union[Unset, float] = Field(
        description='Maximum value to enforce on new documents',
        default=UNSET,
        alias='max',
    )
    default: Union[Unset, float] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=False
    )


class Payload24(CityFrontModel):
    """payload24"""

    key: str = Field(description='Attribute Key.', default=...)
    required: bool = Field(description='Is attribute required?', default=...)
    min_: Union[Unset, int] = Field(
        description='Minimum value to enforce on new documents',
        default=UNSET,
        alias='min',
    )
    max_: Union[Unset, int] = Field(
        description='Maximum value to enforce on new documents',
        default=UNSET,
        alias='max',
    )
    default: Union[Unset, int] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=False
    )


class Payload26(CityFrontModel):
    """payload26"""

    key: str = Field(description='Attribute Key.', default=...)
    size: int = Field(
        description='Attribute size for text attributes, in number of characters.',
        default=...,
    )
    required: bool = Field(description='Is attribute required?', default=...)
    default: Union[Unset, str] = Field(
        description='Default value for attribute when not provided. Cannot be set when attribute is required.',
        default=UNSET,
    )
    array: Union[Unset, bool] = Field(
        description='Is attribute an array?', default=False
    )


class Payload28(CityFrontModel):
    """payload28"""

    document_id: str = Field(
        description='Document ID. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='documentId',
    )
    data: Payload28PropData = Field(
        description='Document data as JSON object.', default=...
    )
    read: Union[Unset, List[str]] = Field(
        description='An array of strings with read permissions. By default only the current user is granted with read permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    write: Union[Unset, List[str]] = Field(
        description='An array of strings with write permissions. By default only the current user is granted with write permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )


class Payload28PropData(CityFrontModel):
    """Payload28PropData

    Document data as JSON object.
    """


class Payload29(CityFrontModel):
    """payload29"""

    data: Union[Unset, Payload29PropData] = Field(
        description='Document data as JSON object. Include only attribute and value pairs to be updated.',
        default=UNSET,
    )
    read: Union[Unset, List[str]] = Field(
        description='An array of strings with read permissions. By default inherits the existing read permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    write: Union[Unset, List[str]] = Field(
        description='An array of strings with write permissions. By default inherits the existing write permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )


class Payload29PropData(CityFrontModel):
    """Payload29PropData

    Document data as JSON object. Include only attribute and value pairs to be
    updated.
    """


class Payload30(CityFrontModel):
    """payload30"""

    key: str = Field(description='Index Key.', default=...)
    type: str = Field(description='Index type.', default=...)
    attributes: List[str] = Field(
        description='Array of attributes to index. Maximum of 100 attributes are allowed, each 32 characters long.',
        default=...,
    )
    orders: Union[Unset, List[str]] = Field(
        description='Array of index orders. Maximum of 100 orders are allowed.',
        default=[],
    )


class Payload31(CityFrontModel):
    """payload31"""

    function_id: str = Field(
        description='Function ID. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='functionId',
    )
    name: str = Field(
        description='Function name. Max length: 128 chars.', default=...
    )
    execute: List[str] = Field(
        description='An array of strings with execution permissions. By default no user is granted with any execute permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions. Maximum of 100 scopes are allowed, each 64 characters long.',
        default=...,
    )
    runtime: str = Field(description='Execution runtime.', default=...)
    vars_: Union[Unset, Payload31PropVars] = Field(
        description='Key-value JSON object that will be passed to the function as environment variables.',
        default=UNSET,
        alias='vars',
    )
    events: Union[Unset, List[str]] = Field(
        description='Events list. Maximum of 100 events are allowed.',
        default=[],
    )
    schedule: Union[Unset, str] = Field(
        description='Schedule CRON syntax.', default=UNSET
    )
    timeout: Union[Unset, int] = Field(
        description='Function maximum execution time in seconds.', default=15
    )


class Payload31PropVars(CityFrontModel):
    """Payload31PropVars

    Key-value JSON object that will be passed to the function as environment
    variables.
    """


class Payload32(CityFrontModel):
    """payload32"""

    name: str = Field(
        description='Function name. Max length: 128 chars.', default=...
    )
    execute: List[str] = Field(
        description='An array of strings with execution permissions. By default no user is granted with any execute permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions. Maximum of 100 scopes are allowed, each 64 characters long.',
        default=...,
    )
    vars_: Union[Unset, Payload32PropVars] = Field(
        description='Key-value JSON object that will be passed to the function as environment variables.',
        default=UNSET,
        alias='vars',
    )
    events: Union[Unset, List[str]] = Field(
        description='Events list. Maximum of 100 events are allowed.',
        default=[],
    )
    schedule: Union[Unset, str] = Field(
        description='Schedule CRON syntax.', default=UNSET
    )
    timeout: Union[Unset, int] = Field(
        description='Maximum execution time in seconds.', default=15
    )


class Payload32PropVars(CityFrontModel):
    """Payload32PropVars

    Key-value JSON object that will be passed to the function as environment
    variables.
    """


class Payload33(CityFrontModel):
    """payload33"""

    data: Union[Unset, str] = Field(
        description='String of custom data to send to function.', default=UNSET
    )
    async_: Union[Unset, bool] = Field(
        description='Execute code asynchronously. Default value is true.',
        default=True,
        alias='async',
    )


class Payload34(CityFrontModel):
    """payload34"""

    project_id: str = Field(
        description='Unique Id. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='projectId',
    )
    name: str = Field(
        description='Project name. Max length: 128 chars.', default=...
    )
    team_id: str = Field(
        description='Team unique ID.', default=..., alias='teamId'
    )
    description: Union[Unset, str] = Field(
        description='Project description. Max length: 256 chars.',
        default=UNSET,
    )
    logo: Union[Unset, str] = Field(description='Project logo.', default=UNSET)
    url: Union[Unset, str] = Field(description='Project URL.', default=UNSET)
    legal_name: Union[Unset, str] = Field(
        description='Project legal Name. Max length: 256 chars.',
        default=UNSET,
        alias='legalName',
    )
    legal_country: Union[Unset, str] = Field(
        description='Project legal Country. Max length: 256 chars.',
        default=UNSET,
        alias='legalCountry',
    )
    legal_state: Union[Unset, str] = Field(
        description='Project legal State. Max length: 256 chars.',
        default=UNSET,
        alias='legalState',
    )
    legal_city: Union[Unset, str] = Field(
        description='Project legal City. Max length: 256 chars.',
        default=UNSET,
        alias='legalCity',
    )
    legal_address: Union[Unset, str] = Field(
        description='Project legal Address. Max length: 256 chars.',
        default=UNSET,
        alias='legalAddress',
    )
    legal_tax_id: Union[Unset, str] = Field(
        description='Project legal Tax ID. Max length: 256 chars.',
        default=UNSET,
        alias='legalTaxId',
    )


class Payload35(CityFrontModel):
    """payload35"""

    name: str = Field(
        description='Project name. Max length: 128 chars.', default=...
    )
    description: Union[Unset, str] = Field(
        description='Project description. Max length: 256 chars.',
        default=UNSET,
    )
    logo: Union[Unset, str] = Field(description='Project logo.', default=UNSET)
    url: Union[Unset, str] = Field(description='Project URL.', default=UNSET)
    legal_name: Union[Unset, str] = Field(
        description='Project legal name. Max length: 256 chars.',
        default=UNSET,
        alias='legalName',
    )
    legal_country: Union[Unset, str] = Field(
        description='Project legal country. Max length: 256 chars.',
        default=UNSET,
        alias='legalCountry',
    )
    legal_state: Union[Unset, str] = Field(
        description='Project legal state. Max length: 256 chars.',
        default=UNSET,
        alias='legalState',
    )
    legal_city: Union[Unset, str] = Field(
        description='Project legal city. Max length: 256 chars.',
        default=UNSET,
        alias='legalCity',
    )
    legal_address: Union[Unset, str] = Field(
        description='Project legal address. Max length: 256 chars.',
        default=UNSET,
        alias='legalAddress',
    )
    legal_tax_id: Union[Unset, str] = Field(
        description='Project legal tax ID. Max length: 256 chars.',
        default=UNSET,
        alias='legalTaxId',
    )


class Payload36(CityFrontModel):
    """payload36"""

    password: str = Field(
        description='Your user password for confirmation. Must be at least 8 chars.',
        default=...,
    )


class Payload37(CityFrontModel):
    """payload37"""

    limit: int = Field(
        description='Set the max number of users allowed in this project. Use 0 for unlimited.',
        default=...,
    )


class Payload38(CityFrontModel):
    """payload38"""

    status: bool = Field(
        description='Set the status of this auth method.', default=...
    )


class Payload39(CityFrontModel):
    """payload39"""

    domain: str = Field(description='Domain name.', default=...)


class Payload40(CityFrontModel):
    """payload40"""

    name: str = Field(
        description='Key name. Max length: 128 chars.', default=...
    )
    scopes: List[str] = Field(
        description='Key scopes list. Maximum of 100 scopes are allowed.',
        default=...,
    )
    expire: Union[Unset, int] = Field(
        description='Key expiration time in Unix timestamp. Use 0 for unlimited expiration.',
        default=0,
    )


class Payload41(CityFrontModel):
    """payload41"""

    name: str = Field(
        description='Key name. Max length: 128 chars.', default=...
    )
    scopes: List[str] = Field(
        description='Key scopes list. Maximum of 100 events are allowed.',
        default=...,
    )
    expire: Union[Unset, int] = Field(
        description='Key expiration time in Unix timestamp. Use 0 for unlimited expiration.',
        default=0,
    )


class Payload42(CityFrontModel):
    """payload42"""

    provider: str = Field(description='Provider Name', default=...)
    app_id: Union[Unset, str] = Field(
        description='Provider app ID. Max length: 256 chars.',
        default=UNSET,
        alias='appId',
    )
    secret: Union[Unset, str] = Field(
        description='Provider secret key. Max length: 512 chars.',
        default=UNSET,
    )


class Payload43(CityFrontModel):
    """payload43"""

    type: str = Field(description='Platform type.', default=...)
    name: str = Field(
        description='Platform name. Max length: 128 chars.', default=...
    )
    key: Union[Unset, str] = Field(
        description='Package name for Android or bundle ID for iOS or macOS. Max length: 256 chars.',
        default=UNSET,
    )
    store: Union[Unset, str] = Field(
        description='App store or Google Play store ID. Max length: 256 chars.',
        default=UNSET,
    )
    hostname: Union[Unset, str] = Field(
        description='Platform client hostname. Max length: 256 chars.',
        default=UNSET,
    )


class Payload44(CityFrontModel):
    """payload44"""

    name: str = Field(
        description='Platform name. Max length: 128 chars.', default=...
    )
    key: Union[Unset, str] = Field(
        description='Package name for android or bundle ID for iOS. Max length: 256 chars.',
        default=UNSET,
    )
    store: Union[Unset, str] = Field(
        description='App store or Google Play store ID. Max length: 256 chars.',
        default=UNSET,
    )
    hostname: Union[Unset, str] = Field(
        description='Platform client URL. Max length: 256 chars.',
        default=UNSET,
    )


class Payload45(CityFrontModel):
    """payload45"""

    service: str = Field(description='Service name.', default=...)
    status: bool = Field(description='Service status.', default=...)


class Payload46(CityFrontModel):
    """payload46"""

    name: str = Field(
        description='Webhook name. Max length: 128 chars.', default=...
    )
    events: List[str] = Field(
        description='Events list. Maximum of 100 events are allowed.',
        default=...,
    )
    url: str = Field(description='Webhook URL.', default=...)
    security: bool = Field(
        description='Certificate verification, false for disabled or true for enabled.',
        default=...,
    )
    http_user: Union[Unset, str] = Field(
        description='Webhook HTTP user. Max length: 256 chars.',
        default=UNSET,
        alias='httpUser',
    )
    http_pass: Union[Unset, str] = Field(
        description='Webhook HTTP password. Max length: 256 chars.',
        default=UNSET,
        alias='httpPass',
    )


class Payload48(CityFrontModel):
    """payload48"""

    bucket_id: str = Field(
        description="Unique Id. Choose your own unique ID or pass the string `unique()` to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can't start with a special char. Max length is 36 chars.",
        default=...,
        alias='bucketId',
    )
    name: str = Field(description='Bucket name', default=...)
    permission: str = Field(
        description='Permissions type model to use for reading files in this bucket. You can use bucket-level permission set once on the bucket using the `read` and `write` params, or you can set file-level permission where each file read and write params will decide who has access to read and write to each file individually. [learn more about permissions](/docs/permissions) and get a full list of available permissions.',
        default=...,
    )
    read: Union[Unset, List[str]] = Field(
        description='An array of strings with read permissions. By default no user is granted with any read permissions. [learn more about permissions](/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    write: Union[Unset, List[str]] = Field(
        description='An array of strings with write permissions. By default no user is granted with any write permissions. [learn more about permissions](/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    enabled: Union[Unset, bool] = Field(
        description='Is bucket enabled?', default=True
    )
    maximum_file_size: Union[Unset, int] = Field(
        description='Maximum file size allowed in bytes. Maximum allowed value is 30MB. For self-hosted setups you can change the max limit by changing the `_APP_STORAGE_LIMIT` environment variable. [Learn more about storage environment variables](docs/environment-variables#storage)',
        default=30000000,
        alias='maximumFileSize',
    )
    allowed_file_extensions: Union[Unset, List[str]] = Field(
        description='Allowed file extensions. Maximum of 100 extensions are allowed, each 64 characters long.',
        default=[],
        alias='allowedFileExtensions',
    )
    encryption: Union[Unset, bool] = Field(
        description="Is encryption enabled? For file size above 20MB encryption is skipped even if it's enabled",
        default=True,
    )
    antivirus: Union[Unset, bool] = Field(
        description="Is virus scanning enabled? For file size above 20MB AntiVirus scanning is skipped even if it's enabled",
        default=True,
    )


class Payload49(CityFrontModel):
    """payload49"""

    name: str = Field(description='Bucket name', default=...)
    permission: str = Field(
        description='Permissions type model to use for reading files in this bucket. You can use bucket-level permission set once on the bucket using the `read` and `write` params, or you can set file-level permission where each file read and write params will decide who has access to read and write to each file individually. [learn more about permissions](/docs/permissions) and get a full list of available permissions.',
        default=...,
    )
    read: Union[Unset, List[str]] = Field(
        description='An array of strings with read permissions. By default inherits the existing read permissions. [learn more about permissions](/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    write: Union[Unset, List[str]] = Field(
        description='An array of strings with write permissions. By default inherits the existing write permissions. [learn more about permissions](/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    enabled: Union[Unset, bool] = Field(
        description='Is bucket enabled?', default=True
    )
    maximum_file_size: Union[Unset, int] = Field(
        description='Maximum file size allowed in bytes. Maximum allowed value is 30MB. For self hosted version you can change the limit by changing _APP_STORAGE_LIMIT environment variable. [Learn more about storage environment variables](docs/environment-variables#storage)',
        default=UNSET,
        alias='maximumFileSize',
    )
    allowed_file_extensions: Union[Unset, List[str]] = Field(
        description='Allowed file extensions. Maximum of 100 extensions are allowed, each 64 characters long.',
        default=[],
        alias='allowedFileExtensions',
    )
    encryption: Union[Unset, bool] = Field(
        description="Is encryption enabled? For file size above 20MB encryption is skipped even if it's enabled",
        default=True,
    )
    antivirus: Union[Unset, bool] = Field(
        description="Is virus scanning enabled? For file size above 20MB AntiVirus scanning is skipped even if it's enabled",
        default=True,
    )


class Payload50(CityFrontModel):
    """payload50"""

    read: Union[Unset, List[str]] = Field(
        description='An array of strings with read permissions. By default no user is granted with any read permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    write: Union[Unset, List[str]] = Field(
        description='An array of strings with write permissions. By default no user is granted with any write permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )


class Payload51(CityFrontModel):
    """payload51"""

    team_id: str = Field(
        description='Team ID. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='teamId',
    )
    name: str = Field(
        description='Team name. Max length: 128 chars.', default=...
    )
    roles: Union[Unset, List[str]] = Field(
        description='Array of strings. Use this param to set the roles in the team for the user who created it. The default role is **owner**. A role can be any string. Learn more about [roles and permissions](/docs/permissions). Maximum of 100 roles are allowed, each 32 characters long.',
        default=['owner'],
    )


class Payload52(CityFrontModel):
    """payload52"""

    name: str = Field(
        description='New team name. Max length: 128 chars.', default=...
    )


class Payload53(CityFrontModel):
    """payload53"""

    email: str = Field(
        description='Email of the new team member.', default=...
    )
    roles: List[str] = Field(
        description='Array of strings. Use this param to set the user roles in the team. A role can be any string. Learn more about [roles and permissions](/docs/permissions). Maximum of 100 roles are allowed, each 32 characters long.',
        default=...,
    )
    url: str = Field(
        description='URL to redirect the user back to your app from the invitation email.  Only URLs from hostnames in your project platform list are allowed. This requirement helps to prevent an [open redirect](https://cheatsheetseries.owasp.org/cheatsheets/Unvalidated_Redirects_and_Forwards_Cheat_Sheet.html) attack against your project API.',
        default=...,
    )
    name: Union[Unset, str] = Field(
        description='Name of the new team member. Max length: 128 chars.',
        default=UNSET,
    )


class Payload54(CityFrontModel):
    """payload54"""

    roles: List[str] = Field(
        description="An array of strings. Use this param to set the user's roles in the team. A role can be any string. Learn more about [roles and permissions](https://appwrite.io/docs/permissions). Maximum of 100 roles are allowed, each 32 characters long.",
        default=...,
    )


class Payload55(CityFrontModel):
    """payload55"""

    user_id: str = Field(description='User ID.', default=..., alias='userId')
    secret: str = Field(description='Secret key.', default=...)


class Payload56(CityFrontModel):
    """payload56"""

    user_id: str = Field(
        description='User ID. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='userId',
    )
    email: str = Field(description='User email.', default=...)
    password: str = Field(
        description='User password. Must be at least 8 chars.', default=...
    )
    name: Union[Unset, str] = Field(
        description='User name. Max length: 128 chars.', default=UNSET
    )


class Payload57(CityFrontModel):
    """payload57"""

    email: str = Field(description='User email.', default=...)


class Payload59(CityFrontModel):
    """payload59"""

    password: str = Field(
        description='New user password. Must be at least 8 chars.', default=...
    )


class Payload60(CityFrontModel):
    """payload60"""

    number: str = Field(description='User phone number.', default=...)


class Payload62(CityFrontModel):
    """payload62"""

    status: bool = Field(
        description='User Status. To activate the user pass `true` and to block the user pass `false`.',
        default=...,
    )


class Payload63(CityFrontModel):
    """payload63"""

    email_verification: bool = Field(
        description='User email verification status.',
        default=...,
        alias='emailVerification',
    )


class Payload64(CityFrontModel):
    """payload64"""

    phone_verification: bool = Field(
        description='User phone verification status.',
        default=...,
        alias='phoneVerification',
    )


class AccountPrefsGetResponse200(CityFrontModel):
    """AccountPrefsGetResponse200"""


class StorageBucketsBucketIdFilesPostBody(CityFrontModel):
    """StorageBucketsBucketIdFilesPostBody"""

    file_id: str = Field(
        description='File ID. Choose your own unique ID or pass the string "unique()" to auto generate it. Valid chars are a-z, A-Z, 0-9, period, hyphen, and underscore. Can\'t start with a special char. Max length is 36 chars.',
        default=...,
        alias='fileId',
    )
    file: str = Field(description='Binary file.', default=...)
    read: Union[Unset, List[str]] = Field(
        description='An array of strings with read permissions. By default only the current user is granted with read permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )
    write: Union[Unset, List[str]] = Field(
        description='An array of strings with write permissions. By default only the current user is granted with write permissions. [learn more about permissions](https://appwrite.io/docs/permissions) and get a full list of available permissions.',
        default=UNSET,
    )


class UsersUserIdPrefsGetResponse200(CityFrontModel):
    """UsersUserIdPrefsGetResponse200"""


class UsersUserIdPrefsPatchResponse200(CityFrontModel):
    """UsersUserIdPrefsPatchResponse200"""


class FunctionsFunctionIdDeploymentsPostBody(CityFrontModel):
    """FunctionsFunctionIdDeploymentsPostBody"""

    entrypoint: str = Field(description='Entrypoint File.', default=...)
    code: str = Field(
        description='Gzip file with your code package. When used with the Appwrite CLI, pass the path to your code directory, and the CLI will automatically package your code. Use a path that is within the current directory.',
        default=...,
    )
    activate: bool = Field(
        description='Automatically activate the deployment when it is finished building.',
        default=...,
    )


DocumentList.update_forward_refs()
Document.update_forward_refs()
CollectionList.update_forward_refs()
Collection.update_forward_refs()
Index.update_forward_refs()
DatabaseList.update_forward_refs()
Database.update_forward_refs()
IndexList.update_forward_refs()
UserList.update_forward_refs()
User.update_forward_refs()
UserPropPrefsItems.update_forward_refs()
SessionList.update_forward_refs()
Session.update_forward_refs()
LogList.update_forward_refs()
Log.update_forward_refs()
FileList.update_forward_refs()
File.update_forward_refs()
BucketList.update_forward_refs()
Bucket.update_forward_refs()
TeamList.update_forward_refs()
Team.update_forward_refs()
MembershipList.update_forward_refs()
Membership.update_forward_refs()
FunctionList.update_forward_refs()
Function.update_forward_refs()
FunctionPropVars.update_forward_refs()
RuntimeList.update_forward_refs()
Runtime.update_forward_refs()
DeploymentList.update_forward_refs()
Deployment.update_forward_refs()
ExecutionList.update_forward_refs()
Execution.update_forward_refs()
ProjectList.update_forward_refs()
Project.update_forward_refs()
Platform.update_forward_refs()
Webhook.update_forward_refs()
Key.update_forward_refs()
Domain.update_forward_refs()
WebhookList.update_forward_refs()
KeyList.update_forward_refs()
PlatformList.update_forward_refs()
DomainList.update_forward_refs()
CountryList.update_forward_refs()
Country.update_forward_refs()
ContinentList.update_forward_refs()
Continent.update_forward_refs()
LanguageList.update_forward_refs()
Language.update_forward_refs()
CurrencyList.update_forward_refs()
Currency.update_forward_refs()
PhoneList.update_forward_refs()
Phone.update_forward_refs()
MetricList.update_forward_refs()
Metric.update_forward_refs()
AttributeList.update_forward_refs()
AttributeString.update_forward_refs()
AttributeInteger.update_forward_refs()
AttributeFloat.update_forward_refs()
AttributeBoolean.update_forward_refs()
AttributeEmail.update_forward_refs()
AttributeEnum.update_forward_refs()
AttributeIp.update_forward_refs()
AttributeUrl.update_forward_refs()
Token.update_forward_refs()
Jwt.update_forward_refs()
Locale.update_forward_refs()
HealthAntivirus.update_forward_refs()
HealthQueue.update_forward_refs()
HealthStatus.update_forward_refs()
HealthTime.update_forward_refs()
UsageDatabases.update_forward_refs()
UsageDatabase.update_forward_refs()
UsageCollection.update_forward_refs()
UsageUsers.update_forward_refs()
UsageStorage.update_forward_refs()
UsageBuckets.update_forward_refs()
UsageFunctions.update_forward_refs()
UsageProject.update_forward_refs()
Payload.update_forward_refs()
Payload1.update_forward_refs()
Payload2.update_forward_refs()
Payload3.update_forward_refs()
Payload4.update_forward_refs()
Payload5.update_forward_refs()
Payload5PropPrefs.update_forward_refs()
Payload6.update_forward_refs()
Payload7.update_forward_refs()
Payload9.update_forward_refs()
Payload10.update_forward_refs()
Payload11.update_forward_refs()
Payload13.update_forward_refs()
Payload16.update_forward_refs()
Payload17.update_forward_refs()
Payload18.update_forward_refs()
Payload19.update_forward_refs()
Payload20.update_forward_refs()
Payload21.update_forward_refs()
Payload22.update_forward_refs()
Payload23.update_forward_refs()
Payload24.update_forward_refs()
Payload26.update_forward_refs()
Payload28.update_forward_refs()
Payload28PropData.update_forward_refs()
Payload29.update_forward_refs()
Payload29PropData.update_forward_refs()
Payload30.update_forward_refs()
Payload31.update_forward_refs()
Payload31PropVars.update_forward_refs()
Payload32.update_forward_refs()
Payload32PropVars.update_forward_refs()
Payload33.update_forward_refs()
Payload34.update_forward_refs()
Payload35.update_forward_refs()
Payload36.update_forward_refs()
Payload37.update_forward_refs()
Payload38.update_forward_refs()
Payload39.update_forward_refs()
Payload40.update_forward_refs()
Payload41.update_forward_refs()
Payload42.update_forward_refs()
Payload43.update_forward_refs()
Payload44.update_forward_refs()
Payload45.update_forward_refs()
Payload46.update_forward_refs()
Payload48.update_forward_refs()
Payload49.update_forward_refs()
Payload50.update_forward_refs()
Payload51.update_forward_refs()
Payload52.update_forward_refs()
Payload53.update_forward_refs()
Payload54.update_forward_refs()
Payload55.update_forward_refs()
Payload56.update_forward_refs()
Payload57.update_forward_refs()
Payload59.update_forward_refs()
Payload60.update_forward_refs()
Payload62.update_forward_refs()
Payload63.update_forward_refs()
Payload64.update_forward_refs()
AccountPrefsGetResponse200.update_forward_refs()
StorageBucketsBucketIdFilesPostBody.update_forward_refs()
UsersUserIdPrefsGetResponse200.update_forward_refs()
UsersUserIdPrefsPatchResponse200.update_forward_refs()
FunctionsFunctionIdDeploymentsPostBody.update_forward_refs()

__all__ = [
    'CityFrontModel',
    'DocumentList',
    'Document',
    'CollectionList',
    'Collection',
    'Index',
    'DatabaseList',
    'Database',
    'IndexList',
    'UserList',
    'User',
    'UserPropPrefsItems',
    'SessionList',
    'Session',
    'LogList',
    'Log',
    'FileList',
    'File',
    'BucketList',
    'Bucket',
    'TeamList',
    'Team',
    'MembershipList',
    'Membership',
    'FunctionList',
    'Function',
    'FunctionPropVars',
    'RuntimeList',
    'Runtime',
    'DeploymentList',
    'Deployment',
    'ExecutionList',
    'Execution',
    'ProjectList',
    'Project',
    'Platform',
    'Webhook',
    'Key',
    'Domain',
    'WebhookList',
    'KeyList',
    'PlatformList',
    'DomainList',
    'CountryList',
    'Country',
    'ContinentList',
    'Continent',
    'LanguageList',
    'Language',
    'CurrencyList',
    'Currency',
    'PhoneList',
    'Phone',
    'MetricList',
    'Metric',
    'AttributeList',
    'AttributeString',
    'AttributeInteger',
    'AttributeFloat',
    'AttributeBoolean',
    'AttributeEmail',
    'AttributeEnum',
    'AttributeIp',
    'AttributeUrl',
    'Token',
    'Jwt',
    'Locale',
    'HealthAntivirus',
    'HealthQueue',
    'HealthStatus',
    'HealthTime',
    'UsageDatabases',
    'UsageDatabase',
    'UsageCollection',
    'UsageUsers',
    'UsageStorage',
    'UsageBuckets',
    'UsageFunctions',
    'UsageProject',
    'Payload',
    'Payload1',
    'Payload2',
    'Payload3',
    'Payload4',
    'Payload5',
    'Payload5PropPrefs',
    'Payload6',
    'Payload7',
    'Payload9',
    'Payload10',
    'Payload11',
    'Payload13',
    'Payload16',
    'Payload17',
    'Payload18',
    'Payload19',
    'Payload20',
    'Payload21',
    'Payload22',
    'Payload23',
    'Payload24',
    'Payload26',
    'Payload28',
    'Payload28PropData',
    'Payload29',
    'Payload29PropData',
    'Payload30',
    'Payload31',
    'Payload31PropVars',
    'Payload32',
    'Payload32PropVars',
    'Payload33',
    'Payload34',
    'Payload35',
    'Payload36',
    'Payload37',
    'Payload38',
    'Payload39',
    'Payload40',
    'Payload41',
    'Payload42',
    'Payload43',
    'Payload44',
    'Payload45',
    'Payload46',
    'Payload48',
    'Payload49',
    'Payload50',
    'Payload51',
    'Payload52',
    'Payload53',
    'Payload54',
    'Payload55',
    'Payload56',
    'Payload57',
    'Payload59',
    'Payload60',
    'Payload62',
    'Payload63',
    'Payload64',
    'AccountPrefsGetResponse200',
    'StorageBucketsBucketIdFilesPostBody',
    'UsersUserIdPrefsGetResponse200',
    'UsersUserIdPrefsPatchResponse200',
    'FunctionsFunctionIdDeploymentsPostBody',
]
