"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Literal, Union, overload

from cityfront.utils import UNSET, Unset, exclude_unset
from pydantic import BaseModel, parse_obj_as

from .models import (Domain, DomainList, Key, KeyList, Payload34, Payload35,
                     Payload36, Payload37, Payload38, Payload39, Payload40,
                     Payload41, Payload42, Payload43, Payload44, Payload45,
                     Payload46, Platform, PlatformList, Project, ProjectList,
                     UsageProject, Webhook, WebhookList)
from .types import (Payload34Type, Payload35Type, Payload36Type, Payload37Type,
                    Payload38Type, Payload39Type, Payload40Type, Payload41Type,
                    Payload42Type, Payload43Type, Payload44Type, Payload45Type,
                    Payload46Type)

if TYPE_CHECKING:
    from cityfront import AppWrite
    from cityfront.response import Response


class ProjectsClient:
    def __init__(self, appwrite: 'AppWrite'):
        self._appwrite = appwrite

    def projects_list(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[ProjectList]':
        headers = {}
        url = '/projects'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ProjectList,
        )

    async def async_projects_list(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[ProjectList]':
        url = '/projects'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ProjectList,
        )

    @overload
    def projects_create(
        self, *, data: Union[Unset, Payload34Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    def projects_create(
        self,
        *,
        data: Unset = UNSET,
        project_id: str,
        name: str,
        team_id: str,
        description: Union[Unset, str] = UNSET,
        logo: Union[Unset, str] = UNSET,
        url: Union[Unset, str] = UNSET,
        legal_name: Union[Unset, str] = UNSET,
        legal_country: Union[Unset, str] = UNSET,
        legal_state: Union[Unset, str] = UNSET,
        legal_city: Union[Unset, str] = UNSET,
        legal_address: Union[Unset, str] = UNSET,
        legal_tax_id: Union[Unset, str] = UNSET,
    ) -> 'Response[Project]':
        ...

    def projects_create(
        self, *, data: Union[Unset, Payload34Type] = UNSET, **kwargs
    ) -> 'Response[Project]':
        headers = {}
        url = '/projects'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload34, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    @overload
    async def async_projects_create(
        self, *, data: Union[Unset, Payload34Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    async def async_projects_create(
        self,
        *,
        data: Unset = UNSET,
        project_id: str,
        name: str,
        team_id: str,
        description: Union[Unset, str] = UNSET,
        logo: Union[Unset, str] = UNSET,
        url: Union[Unset, str] = UNSET,
        legal_name: Union[Unset, str] = UNSET,
        legal_country: Union[Unset, str] = UNSET,
        legal_state: Union[Unset, str] = UNSET,
        legal_city: Union[Unset, str] = UNSET,
        legal_address: Union[Unset, str] = UNSET,
        legal_tax_id: Union[Unset, str] = UNSET,
    ) -> 'Response[Project]':
        ...

    async def async_projects_create(
        self, *, data: Union[Unset, Payload34Type] = UNSET, **kwargs
    ) -> 'Response[Project]':
        url = '/projects'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload34, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    def projects_get(
        self,
        project_id: str,
    ) -> 'Response[Project]':
        headers = {}
        url = f'/projects/{project_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Project,
        )

    async def async_projects_get(
        self,
        project_id: str,
    ) -> 'Response[Project]':
        url = f'/projects/{project_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Project,
        )

    @overload
    def projects_delete(
        self, project_id: str, *, data: Union[Unset, Payload36Type] = UNSET
    ) -> 'Response':
        ...

    @overload
    def projects_delete(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        password: str,
    ) -> 'Response':
        ...

    def projects_delete(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload36Type] = UNSET,
        **kwargs,
    ) -> 'Response':
        headers = {}
        url = f'/projects/{project_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload36, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'DELETE',
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_projects_delete(
        self, project_id: str, *, data: Union[Unset, Payload36Type] = UNSET
    ) -> 'Response':
        ...

    @overload
    async def async_projects_delete(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        password: str,
    ) -> 'Response':
        ...

    async def async_projects_delete(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload36Type] = UNSET,
        **kwargs,
    ) -> 'Response':
        url = f'/projects/{project_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload36, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            json=exclude_unset(json),
        )

    @overload
    def projects_update(
        self, project_id: str, *, data: Union[Unset, Payload35Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    def projects_update(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        logo: Union[Unset, str] = UNSET,
        url: Union[Unset, str] = UNSET,
        legal_name: Union[Unset, str] = UNSET,
        legal_country: Union[Unset, str] = UNSET,
        legal_state: Union[Unset, str] = UNSET,
        legal_city: Union[Unset, str] = UNSET,
        legal_address: Union[Unset, str] = UNSET,
        legal_tax_id: Union[Unset, str] = UNSET,
    ) -> 'Response[Project]':
        ...

    def projects_update(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload35Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        headers = {}
        url = f'/projects/{project_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload35, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    @overload
    async def async_projects_update(
        self, project_id: str, *, data: Union[Unset, Payload35Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    async def async_projects_update(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        logo: Union[Unset, str] = UNSET,
        url: Union[Unset, str] = UNSET,
        legal_name: Union[Unset, str] = UNSET,
        legal_country: Union[Unset, str] = UNSET,
        legal_state: Union[Unset, str] = UNSET,
        legal_city: Union[Unset, str] = UNSET,
        legal_address: Union[Unset, str] = UNSET,
        legal_tax_id: Union[Unset, str] = UNSET,
    ) -> 'Response[Project]':
        ...

    async def async_projects_update(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload35Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        url = f'/projects/{project_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload35, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    @overload
    def projects_update_auth_limit(
        self, project_id: str, *, data: Union[Unset, Payload37Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    def projects_update_auth_limit(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        limit: int,
    ) -> 'Response[Project]':
        ...

    def projects_update_auth_limit(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload37Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        headers = {}
        url = f'/projects/{project_id}/auth/limit'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload37, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    @overload
    async def async_projects_update_auth_limit(
        self, project_id: str, *, data: Union[Unset, Payload37Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    async def async_projects_update_auth_limit(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        limit: int,
    ) -> 'Response[Project]':
        ...

    async def async_projects_update_auth_limit(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload37Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        url = f'/projects/{project_id}/auth/limit'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload37, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    @overload
    def projects_update_auth_status(
        self,
        project_id: str,
        method: str,
        *,
        data: Union[Unset, Payload38Type] = UNSET,
    ) -> 'Response[Project]':
        ...

    @overload
    def projects_update_auth_status(
        self,
        project_id: str,
        method: str,
        *,
        data: Unset = UNSET,
        status: bool,
    ) -> 'Response[Project]':
        ...

    def projects_update_auth_status(
        self,
        project_id: str,
        method: str,
        *,
        data: Union[Unset, Payload38Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        headers = {}
        url = f'/projects/{project_id}/auth/{method}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload38, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    @overload
    async def async_projects_update_auth_status(
        self,
        project_id: str,
        method: str,
        *,
        data: Union[Unset, Payload38Type] = UNSET,
    ) -> 'Response[Project]':
        ...

    @overload
    async def async_projects_update_auth_status(
        self,
        project_id: str,
        method: str,
        *,
        data: Unset = UNSET,
        status: bool,
    ) -> 'Response[Project]':
        ...

    async def async_projects_update_auth_status(
        self,
        project_id: str,
        method: str,
        *,
        data: Union[Unset, Payload38Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        url = f'/projects/{project_id}/auth/{method}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload38, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    def projects_list_domains(
        self,
        project_id: str,
    ) -> 'Response[DomainList]':
        headers = {}
        url = f'/projects/{project_id}/domains'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=DomainList,
        )

    async def async_projects_list_domains(
        self,
        project_id: str,
    ) -> 'Response[DomainList]':
        url = f'/projects/{project_id}/domains'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=DomainList,
        )

    @overload
    def projects_create_domain(
        self, project_id: str, *, data: Union[Unset, Payload39Type] = UNSET
    ) -> 'Response[Domain]':
        ...

    @overload
    def projects_create_domain(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        domain: str,
    ) -> 'Response[Domain]':
        ...

    def projects_create_domain(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload39Type] = UNSET,
        **kwargs,
    ) -> 'Response[Domain]':
        headers = {}
        url = f'/projects/{project_id}/domains'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload39, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Domain,
        )

    @overload
    async def async_projects_create_domain(
        self, project_id: str, *, data: Union[Unset, Payload39Type] = UNSET
    ) -> 'Response[Domain]':
        ...

    @overload
    async def async_projects_create_domain(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        domain: str,
    ) -> 'Response[Domain]':
        ...

    async def async_projects_create_domain(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload39Type] = UNSET,
        **kwargs,
    ) -> 'Response[Domain]':
        url = f'/projects/{project_id}/domains'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload39, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Domain,
        )

    def projects_get_domain(
        self,
        project_id: str,
        domain_id: str,
    ) -> 'Response[Domain]':
        headers = {}
        url = f'/projects/{project_id}/domains/{domain_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Domain,
        )

    async def async_projects_get_domain(
        self,
        project_id: str,
        domain_id: str,
    ) -> 'Response[Domain]':
        url = f'/projects/{project_id}/domains/{domain_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Domain,
        )

    def projects_delete_domain(
        self,
        project_id: str,
        domain_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/projects/{project_id}/domains/{domain_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_projects_delete_domain(
        self,
        project_id: str,
        domain_id: str,
    ) -> 'Response':
        url = f'/projects/{project_id}/domains/{domain_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def projects_update_domain_verification(
        self,
        project_id: str,
        domain_id: str,
    ) -> 'Response[Domain]':
        headers = {}
        url = f'/projects/{project_id}/domains/{domain_id}/verification'

        return self._appwrite.request(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=Domain,
        )

    async def async_projects_update_domain_verification(
        self,
        project_id: str,
        domain_id: str,
    ) -> 'Response[Domain]':
        url = f'/projects/{project_id}/domains/{domain_id}/verification'

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=Domain,
        )

    def projects_list_keys(
        self,
        project_id: str,
    ) -> 'Response[KeyList]':
        headers = {}
        url = f'/projects/{project_id}/keys'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=KeyList,
        )

    async def async_projects_list_keys(
        self,
        project_id: str,
    ) -> 'Response[KeyList]':
        url = f'/projects/{project_id}/keys'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=KeyList,
        )

    @overload
    def projects_create_key(
        self, project_id: str, *, data: Union[Unset, Payload40Type] = UNSET
    ) -> 'Response[Key]':
        ...

    @overload
    def projects_create_key(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        scopes: List[str],
        expire: Union[Unset, int] = 0,
    ) -> 'Response[Key]':
        ...

    def projects_create_key(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload40Type] = UNSET,
        **kwargs,
    ) -> 'Response[Key]':
        headers = {}
        url = f'/projects/{project_id}/keys'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload40, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Key,
        )

    @overload
    async def async_projects_create_key(
        self, project_id: str, *, data: Union[Unset, Payload40Type] = UNSET
    ) -> 'Response[Key]':
        ...

    @overload
    async def async_projects_create_key(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        scopes: List[str],
        expire: Union[Unset, int] = 0,
    ) -> 'Response[Key]':
        ...

    async def async_projects_create_key(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload40Type] = UNSET,
        **kwargs,
    ) -> 'Response[Key]':
        url = f'/projects/{project_id}/keys'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload40, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Key,
        )

    def projects_get_key(
        self,
        project_id: str,
        key_id: str,
    ) -> 'Response[Key]':
        headers = {}
        url = f'/projects/{project_id}/keys/{key_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Key,
        )

    async def async_projects_get_key(
        self,
        project_id: str,
        key_id: str,
    ) -> 'Response[Key]':
        url = f'/projects/{project_id}/keys/{key_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Key,
        )

    @overload
    def projects_update_key(
        self,
        project_id: str,
        key_id: str,
        *,
        data: Union[Unset, Payload41Type] = UNSET,
    ) -> 'Response[Key]':
        ...

    @overload
    def projects_update_key(
        self,
        project_id: str,
        key_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        scopes: List[str],
        expire: Union[Unset, int] = 0,
    ) -> 'Response[Key]':
        ...

    def projects_update_key(
        self,
        project_id: str,
        key_id: str,
        *,
        data: Union[Unset, Payload41Type] = UNSET,
        **kwargs,
    ) -> 'Response[Key]':
        headers = {}
        url = f'/projects/{project_id}/keys/{key_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload41, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Key,
        )

    @overload
    async def async_projects_update_key(
        self,
        project_id: str,
        key_id: str,
        *,
        data: Union[Unset, Payload41Type] = UNSET,
    ) -> 'Response[Key]':
        ...

    @overload
    async def async_projects_update_key(
        self,
        project_id: str,
        key_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        scopes: List[str],
        expire: Union[Unset, int] = 0,
    ) -> 'Response[Key]':
        ...

    async def async_projects_update_key(
        self,
        project_id: str,
        key_id: str,
        *,
        data: Union[Unset, Payload41Type] = UNSET,
        **kwargs,
    ) -> 'Response[Key]':
        url = f'/projects/{project_id}/keys/{key_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload41, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Key,
        )

    def projects_delete_key(
        self,
        project_id: str,
        key_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/projects/{project_id}/keys/{key_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_projects_delete_key(
        self,
        project_id: str,
        key_id: str,
    ) -> 'Response':
        url = f'/projects/{project_id}/keys/{key_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def projects_update_o_auth2(
        self, project_id: str, *, data: Union[Unset, Payload42Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    def projects_update_o_auth2(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        provider: str,
        app_id: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
    ) -> 'Response[Project]':
        ...

    def projects_update_o_auth2(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload42Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        headers = {}
        url = f'/projects/{project_id}/oauth2'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload42, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    @overload
    async def async_projects_update_o_auth2(
        self, project_id: str, *, data: Union[Unset, Payload42Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    async def async_projects_update_o_auth2(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        provider: str,
        app_id: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
    ) -> 'Response[Project]':
        ...

    async def async_projects_update_o_auth2(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload42Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        url = f'/projects/{project_id}/oauth2'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload42, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    def projects_list_platforms(
        self,
        project_id: str,
    ) -> 'Response[PlatformList]':
        headers = {}
        url = f'/projects/{project_id}/platforms'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=PlatformList,
        )

    async def async_projects_list_platforms(
        self,
        project_id: str,
    ) -> 'Response[PlatformList]':
        url = f'/projects/{project_id}/platforms'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=PlatformList,
        )

    @overload
    def projects_create_platform(
        self, project_id: str, *, data: Union[Unset, Payload43Type] = UNSET
    ) -> 'Response[Platform]':
        ...

    @overload
    def projects_create_platform(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        type: str,
        name: str,
        key: Union[Unset, str] = UNSET,
        store: Union[Unset, str] = UNSET,
        hostname: Union[Unset, str] = UNSET,
    ) -> 'Response[Platform]':
        ...

    def projects_create_platform(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload43Type] = UNSET,
        **kwargs,
    ) -> 'Response[Platform]':
        headers = {}
        url = f'/projects/{project_id}/platforms'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload43, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Platform,
        )

    @overload
    async def async_projects_create_platform(
        self, project_id: str, *, data: Union[Unset, Payload43Type] = UNSET
    ) -> 'Response[Platform]':
        ...

    @overload
    async def async_projects_create_platform(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        type: str,
        name: str,
        key: Union[Unset, str] = UNSET,
        store: Union[Unset, str] = UNSET,
        hostname: Union[Unset, str] = UNSET,
    ) -> 'Response[Platform]':
        ...

    async def async_projects_create_platform(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload43Type] = UNSET,
        **kwargs,
    ) -> 'Response[Platform]':
        url = f'/projects/{project_id}/platforms'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload43, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Platform,
        )

    def projects_get_platform(
        self,
        project_id: str,
        platform_id: str,
    ) -> 'Response[Platform]':
        headers = {}
        url = f'/projects/{project_id}/platforms/{platform_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Platform,
        )

    async def async_projects_get_platform(
        self,
        project_id: str,
        platform_id: str,
    ) -> 'Response[Platform]':
        url = f'/projects/{project_id}/platforms/{platform_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Platform,
        )

    @overload
    def projects_update_platform(
        self,
        project_id: str,
        platform_id: str,
        *,
        data: Union[Unset, Payload44Type] = UNSET,
    ) -> 'Response[Platform]':
        ...

    @overload
    def projects_update_platform(
        self,
        project_id: str,
        platform_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        key: Union[Unset, str] = UNSET,
        store: Union[Unset, str] = UNSET,
        hostname: Union[Unset, str] = UNSET,
    ) -> 'Response[Platform]':
        ...

    def projects_update_platform(
        self,
        project_id: str,
        platform_id: str,
        *,
        data: Union[Unset, Payload44Type] = UNSET,
        **kwargs,
    ) -> 'Response[Platform]':
        headers = {}
        url = f'/projects/{project_id}/platforms/{platform_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload44, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Platform,
        )

    @overload
    async def async_projects_update_platform(
        self,
        project_id: str,
        platform_id: str,
        *,
        data: Union[Unset, Payload44Type] = UNSET,
    ) -> 'Response[Platform]':
        ...

    @overload
    async def async_projects_update_platform(
        self,
        project_id: str,
        platform_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        key: Union[Unset, str] = UNSET,
        store: Union[Unset, str] = UNSET,
        hostname: Union[Unset, str] = UNSET,
    ) -> 'Response[Platform]':
        ...

    async def async_projects_update_platform(
        self,
        project_id: str,
        platform_id: str,
        *,
        data: Union[Unset, Payload44Type] = UNSET,
        **kwargs,
    ) -> 'Response[Platform]':
        url = f'/projects/{project_id}/platforms/{platform_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload44, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Platform,
        )

    def projects_delete_platform(
        self,
        project_id: str,
        platform_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/projects/{project_id}/platforms/{platform_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_projects_delete_platform(
        self,
        project_id: str,
        platform_id: str,
    ) -> 'Response':
        url = f'/projects/{project_id}/platforms/{platform_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def projects_update_service_status(
        self, project_id: str, *, data: Union[Unset, Payload45Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    def projects_update_service_status(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        service: str,
        status: bool,
    ) -> 'Response[Project]':
        ...

    def projects_update_service_status(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload45Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        headers = {}
        url = f'/projects/{project_id}/service'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload45, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    @overload
    async def async_projects_update_service_status(
        self, project_id: str, *, data: Union[Unset, Payload45Type] = UNSET
    ) -> 'Response[Project]':
        ...

    @overload
    async def async_projects_update_service_status(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        service: str,
        status: bool,
    ) -> 'Response[Project]':
        ...

    async def async_projects_update_service_status(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload45Type] = UNSET,
        **kwargs,
    ) -> 'Response[Project]':
        url = f'/projects/{project_id}/service'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload45, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Project,
        )

    def projects_get_usage(
        self,
        project_id: str,
        range_: Union[Unset, str] = '30d',
    ) -> 'Response[UsageProject]':
        headers = {}
        url = f'/projects/{project_id}/usage'

        params = {
            'range': range_,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageProject,
        )

    async def async_projects_get_usage(
        self,
        project_id: str,
        range_: Union[Unset, str] = '30d',
    ) -> 'Response[UsageProject]':
        url = f'/projects/{project_id}/usage'

        params = {
            'range': range_,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageProject,
        )

    def projects_list_webhooks(
        self,
        project_id: str,
    ) -> 'Response[WebhookList]':
        headers = {}
        url = f'/projects/{project_id}/webhooks'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=WebhookList,
        )

    async def async_projects_list_webhooks(
        self,
        project_id: str,
    ) -> 'Response[WebhookList]':
        url = f'/projects/{project_id}/webhooks'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=WebhookList,
        )

    @overload
    def projects_create_webhook(
        self, project_id: str, *, data: Union[Unset, Payload46Type] = UNSET
    ) -> 'Response[Webhook]':
        ...

    @overload
    def projects_create_webhook(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        events: List[str],
        url: str,
        security: bool,
        http_user: Union[Unset, str] = UNSET,
        http_pass: Union[Unset, str] = UNSET,
    ) -> 'Response[Webhook]':
        ...

    def projects_create_webhook(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload46Type] = UNSET,
        **kwargs,
    ) -> 'Response[Webhook]':
        headers = {}
        url = f'/projects/{project_id}/webhooks'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload46, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Webhook,
        )

    @overload
    async def async_projects_create_webhook(
        self, project_id: str, *, data: Union[Unset, Payload46Type] = UNSET
    ) -> 'Response[Webhook]':
        ...

    @overload
    async def async_projects_create_webhook(
        self,
        project_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        events: List[str],
        url: str,
        security: bool,
        http_user: Union[Unset, str] = UNSET,
        http_pass: Union[Unset, str] = UNSET,
    ) -> 'Response[Webhook]':
        ...

    async def async_projects_create_webhook(
        self,
        project_id: str,
        *,
        data: Union[Unset, Payload46Type] = UNSET,
        **kwargs,
    ) -> 'Response[Webhook]':
        url = f'/projects/{project_id}/webhooks'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload46, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Webhook,
        )

    def projects_get_webhook(
        self,
        project_id: str,
        webhook_id: str,
    ) -> 'Response[Webhook]':
        headers = {}
        url = f'/projects/{project_id}/webhooks/{webhook_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Webhook,
        )

    async def async_projects_get_webhook(
        self,
        project_id: str,
        webhook_id: str,
    ) -> 'Response[Webhook]':
        url = f'/projects/{project_id}/webhooks/{webhook_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Webhook,
        )

    @overload
    def projects_update_webhook(
        self,
        project_id: str,
        webhook_id: str,
        *,
        data: Union[Unset, Payload46Type] = UNSET,
    ) -> 'Response[Webhook]':
        ...

    @overload
    def projects_update_webhook(
        self,
        project_id: str,
        webhook_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        events: List[str],
        url: str,
        security: bool,
        http_user: Union[Unset, str] = UNSET,
        http_pass: Union[Unset, str] = UNSET,
    ) -> 'Response[Webhook]':
        ...

    def projects_update_webhook(
        self,
        project_id: str,
        webhook_id: str,
        *,
        data: Union[Unset, Payload46Type] = UNSET,
        **kwargs,
    ) -> 'Response[Webhook]':
        headers = {}
        url = f'/projects/{project_id}/webhooks/{webhook_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload46, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Webhook,
        )

    @overload
    async def async_projects_update_webhook(
        self,
        project_id: str,
        webhook_id: str,
        *,
        data: Union[Unset, Payload46Type] = UNSET,
    ) -> 'Response[Webhook]':
        ...

    @overload
    async def async_projects_update_webhook(
        self,
        project_id: str,
        webhook_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        events: List[str],
        url: str,
        security: bool,
        http_user: Union[Unset, str] = UNSET,
        http_pass: Union[Unset, str] = UNSET,
    ) -> 'Response[Webhook]':
        ...

    async def async_projects_update_webhook(
        self,
        project_id: str,
        webhook_id: str,
        *,
        data: Union[Unset, Payload46Type] = UNSET,
        **kwargs,
    ) -> 'Response[Webhook]':
        url = f'/projects/{project_id}/webhooks/{webhook_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload46, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Webhook,
        )

    def projects_delete_webhook(
        self,
        project_id: str,
        webhook_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/projects/{project_id}/webhooks/{webhook_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_projects_delete_webhook(
        self,
        project_id: str,
        webhook_id: str,
    ) -> 'Response':
        url = f'/projects/{project_id}/webhooks/{webhook_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def projects_update_webhook_signature(
        self,
        project_id: str,
        webhook_id: str,
    ) -> 'Response[Webhook]':
        headers = {}
        url = f'/projects/{project_id}/webhooks/{webhook_id}/signature'

        return self._appwrite.request(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=Webhook,
        )

    async def async_projects_update_webhook_signature(
        self,
        project_id: str,
        webhook_id: str,
    ) -> 'Response[Webhook]':
        url = f'/projects/{project_id}/webhooks/{webhook_id}/signature'

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            headers=exclude_unset(headers),
            response_model=Webhook,
        )
