"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Any, List, Literal, Union, overload

from cityfront.utils import UNSET, Unset, exclude_unset
from pydantic import BaseModel, parse_obj_as

from .models import (Bucket, BucketList, File, FileList, Payload48, Payload49,
                     Payload50, StorageBucketsBucketIdFilesPostBody,
                     UsageBuckets, UsageStorage)
from .types import (Payload48Type, Payload49Type, Payload50Type,
                    StorageBucketsBucketIdFilesPostBodyType)

if TYPE_CHECKING:
    from cityfront import AppWrite
    from cityfront.response import Response


class StorageClient:
    def __init__(self, appwrite: 'AppWrite'):
        self._appwrite = appwrite

    def storage_list_buckets(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[BucketList]':
        headers = {}
        url = '/storage/buckets'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=BucketList,
        )

    async def async_storage_list_buckets(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[BucketList]':
        url = '/storage/buckets'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=BucketList,
        )

    @overload
    def storage_create_bucket(
        self, *, data: Union[Unset, Payload48Type] = UNSET
    ) -> 'Response[Bucket]':
        ...

    @overload
    def storage_create_bucket(
        self,
        *,
        data: Unset = UNSET,
        bucket_id: str,
        name: str,
        permission: str,
        read: Union[Unset, List[str]] = UNSET,
        write: Union[Unset, List[str]] = UNSET,
        enabled: Union[Unset, bool] = True,
        maximum_file_size: Union[Unset, int] = 30000000,
        allowed_file_extensions: Union[Unset, List[str]] = [],
        encryption: Union[Unset, bool] = True,
        antivirus: Union[Unset, bool] = True,
    ) -> 'Response[Bucket]':
        ...

    def storage_create_bucket(
        self, *, data: Union[Unset, Payload48Type] = UNSET, **kwargs
    ) -> 'Response[Bucket]':
        headers = {}
        url = '/storage/buckets'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload48, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Bucket,
        )

    @overload
    async def async_storage_create_bucket(
        self, *, data: Union[Unset, Payload48Type] = UNSET
    ) -> 'Response[Bucket]':
        ...

    @overload
    async def async_storage_create_bucket(
        self,
        *,
        data: Unset = UNSET,
        bucket_id: str,
        name: str,
        permission: str,
        read: Union[Unset, List[str]] = UNSET,
        write: Union[Unset, List[str]] = UNSET,
        enabled: Union[Unset, bool] = True,
        maximum_file_size: Union[Unset, int] = 30000000,
        allowed_file_extensions: Union[Unset, List[str]] = [],
        encryption: Union[Unset, bool] = True,
        antivirus: Union[Unset, bool] = True,
    ) -> 'Response[Bucket]':
        ...

    async def async_storage_create_bucket(
        self, *, data: Union[Unset, Payload48Type] = UNSET, **kwargs
    ) -> 'Response[Bucket]':
        url = '/storage/buckets'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload48, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Bucket,
        )

    def storage_get_bucket(
        self,
        bucket_id: str,
    ) -> 'Response[Bucket]':
        headers = {}
        url = f'/storage/buckets/{bucket_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Bucket,
        )

    async def async_storage_get_bucket(
        self,
        bucket_id: str,
    ) -> 'Response[Bucket]':
        url = f'/storage/buckets/{bucket_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Bucket,
        )

    @overload
    def storage_update_bucket(
        self, bucket_id: str, *, data: Union[Unset, Payload49Type] = UNSET
    ) -> 'Response[Bucket]':
        ...

    @overload
    def storage_update_bucket(
        self,
        bucket_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        permission: str,
        read: Union[Unset, List[str]] = UNSET,
        write: Union[Unset, List[str]] = UNSET,
        enabled: Union[Unset, bool] = True,
        maximum_file_size: Union[Unset, int] = UNSET,
        allowed_file_extensions: Union[Unset, List[str]] = [],
        encryption: Union[Unset, bool] = True,
        antivirus: Union[Unset, bool] = True,
    ) -> 'Response[Bucket]':
        ...

    def storage_update_bucket(
        self,
        bucket_id: str,
        *,
        data: Union[Unset, Payload49Type] = UNSET,
        **kwargs,
    ) -> 'Response[Bucket]':
        headers = {}
        url = f'/storage/buckets/{bucket_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload49, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Bucket,
        )

    @overload
    async def async_storage_update_bucket(
        self, bucket_id: str, *, data: Union[Unset, Payload49Type] = UNSET
    ) -> 'Response[Bucket]':
        ...

    @overload
    async def async_storage_update_bucket(
        self,
        bucket_id: str,
        *,
        data: Unset = UNSET,
        name: str,
        permission: str,
        read: Union[Unset, List[str]] = UNSET,
        write: Union[Unset, List[str]] = UNSET,
        enabled: Union[Unset, bool] = True,
        maximum_file_size: Union[Unset, int] = UNSET,
        allowed_file_extensions: Union[Unset, List[str]] = [],
        encryption: Union[Unset, bool] = True,
        antivirus: Union[Unset, bool] = True,
    ) -> 'Response[Bucket]':
        ...

    async def async_storage_update_bucket(
        self,
        bucket_id: str,
        *,
        data: Union[Unset, Payload49Type] = UNSET,
        **kwargs,
    ) -> 'Response[Bucket]':
        url = f'/storage/buckets/{bucket_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload49, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Bucket,
        )

    def storage_delete_bucket(
        self,
        bucket_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/storage/buckets/{bucket_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_storage_delete_bucket(
        self,
        bucket_id: str,
    ) -> 'Response':
        url = f'/storage/buckets/{bucket_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def storage_list_files(
        self,
        bucket_id: str,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[FileList]':
        headers = {}
        url = f'/storage/buckets/{bucket_id}/files'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=FileList,
        )

    async def async_storage_list_files(
        self,
        bucket_id: str,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[FileList]':
        url = f'/storage/buckets/{bucket_id}/files'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=FileList,
        )

    @overload
    def storage_create_file(
        self,
        bucket_id: str,
        *,
        data: Union[Unset, StorageBucketsBucketIdFilesPostBodyType] = UNSET,
    ) -> 'Response[File]':
        ...

    @overload
    def storage_create_file(
        self,
        bucket_id: str,
        *,
        data: Unset = UNSET,
        file_id: str,
        file: str,
        read: Union[Unset, List[str]] = UNSET,
        write: Union[Unset, List[str]] = UNSET,
    ) -> 'Response[File]':
        ...

    def storage_create_file(
        self,
        bucket_id: str,
        *,
        data: Union[Unset, StorageBucketsBucketIdFilesPostBodyType] = UNSET,
        **kwargs,
    ) -> 'Response[File]':
        headers = {}
        url = f'/storage/buckets/{bucket_id}/files'

        if not kwargs:
            kwargs = UNSET

        data = kwargs if data is UNSET else data
        data = parse_obj_as(StorageBucketsBucketIdFilesPostBody, data)
        data = (
            data.dict(by_alias=True) if isinstance(data, BaseModel) else data
        )

        return self._appwrite.request(
            'POST',
            url,
            data=exclude_unset(data),
            response_model=File,
        )

    @overload
    async def async_storage_create_file(
        self,
        bucket_id: str,
        *,
        data: Union[Unset, StorageBucketsBucketIdFilesPostBodyType] = UNSET,
    ) -> 'Response[File]':
        ...

    @overload
    async def async_storage_create_file(
        self,
        bucket_id: str,
        *,
        data: Unset = UNSET,
        file_id: str,
        file: str,
        read: Union[Unset, List[str]] = UNSET,
        write: Union[Unset, List[str]] = UNSET,
    ) -> 'Response[File]':
        ...

    async def async_storage_create_file(
        self,
        bucket_id: str,
        *,
        data: Union[Unset, StorageBucketsBucketIdFilesPostBodyType] = UNSET,
        **kwargs,
    ) -> 'Response[File]':
        url = f'/storage/buckets/{bucket_id}/files'

        if not kwargs:
            kwargs = UNSET

        data = kwargs if data is UNSET else data
        data = parse_obj_as(StorageBucketsBucketIdFilesPostBody, data)
        data = (
            data.dict(by_alias=True) if isinstance(data, BaseModel) else data
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            data=exclude_unset(data),
            response_model=File,
        )

    def storage_get_file(
        self,
        bucket_id: str,
        file_id: str,
    ) -> 'Response[File]':
        headers = {}
        url = f'/storage/buckets/{bucket_id}/files/{file_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=File,
        )

    async def async_storage_get_file(
        self,
        bucket_id: str,
        file_id: str,
    ) -> 'Response[File]':
        url = f'/storage/buckets/{bucket_id}/files/{file_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=File,
        )

    @overload
    def storage_update_file(
        self,
        bucket_id: str,
        file_id: str,
        *,
        data: Union[Unset, Payload50Type] = UNSET,
    ) -> 'Response[File]':
        ...

    @overload
    def storage_update_file(
        self,
        bucket_id: str,
        file_id: str,
        *,
        data: Unset = UNSET,
        read: Union[Unset, List[str]] = UNSET,
        write: Union[Unset, List[str]] = UNSET,
    ) -> 'Response[File]':
        ...

    def storage_update_file(
        self,
        bucket_id: str,
        file_id: str,
        *,
        data: Union[Unset, Payload50Type] = UNSET,
        **kwargs,
    ) -> 'Response[File]':
        headers = {}
        url = f'/storage/buckets/{bucket_id}/files/{file_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload50, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=File,
        )

    @overload
    async def async_storage_update_file(
        self,
        bucket_id: str,
        file_id: str,
        *,
        data: Union[Unset, Payload50Type] = UNSET,
    ) -> 'Response[File]':
        ...

    @overload
    async def async_storage_update_file(
        self,
        bucket_id: str,
        file_id: str,
        *,
        data: Unset = UNSET,
        read: Union[Unset, List[str]] = UNSET,
        write: Union[Unset, List[str]] = UNSET,
    ) -> 'Response[File]':
        ...

    async def async_storage_update_file(
        self,
        bucket_id: str,
        file_id: str,
        *,
        data: Union[Unset, Payload50Type] = UNSET,
        **kwargs,
    ) -> 'Response[File]':
        url = f'/storage/buckets/{bucket_id}/files/{file_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload50, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=File,
        )

    def storage_delete_file(
        self,
        bucket_id: str,
        file_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/storage/buckets/{bucket_id}/files/{file_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_storage_delete_file(
        self,
        bucket_id: str,
        file_id: str,
    ) -> 'Response':
        url = f'/storage/buckets/{bucket_id}/files/{file_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def storage_get_file_download(
        self,
        bucket_id: str,
        file_id: str,
    ) -> 'Response[Any]':
        headers = {}
        url = f'/storage/buckets/{bucket_id}/files/{file_id}/download'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_storage_get_file_download(
        self,
        bucket_id: str,
        file_id: str,
    ) -> 'Response[Any]':
        url = f'/storage/buckets/{bucket_id}/files/{file_id}/download'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Any,
        )

    def storage_get_file_preview(
        self,
        bucket_id: str,
        file_id: str,
        width: Union[Unset, int] = 0,
        height: Union[Unset, int] = 0,
        gravity: Union[Unset, str] = 'center',
        quality: Union[Unset, int] = 100,
        border_width: Union[Unset, int] = 0,
        border_color: Union[Unset, str] = UNSET,
        border_radius: Union[Unset, int] = 0,
        opacity: Union[Unset, float] = 1,
        rotation: Union[Unset, int] = 0,
        background: Union[Unset, str] = UNSET,
        output: Union[Unset, str] = UNSET,
    ) -> 'Response[Any]':
        headers = {}
        url = f'/storage/buckets/{bucket_id}/files/{file_id}/preview'

        params = {
            'width': width,
            'height': height,
            'gravity': gravity,
            'quality': quality,
            'borderWidth': border_width,
            'borderColor': border_color,
            'borderRadius': border_radius,
            'opacity': opacity,
            'rotation': rotation,
            'background': background,
            'output': output,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_storage_get_file_preview(
        self,
        bucket_id: str,
        file_id: str,
        width: Union[Unset, int] = 0,
        height: Union[Unset, int] = 0,
        gravity: Union[Unset, str] = 'center',
        quality: Union[Unset, int] = 100,
        border_width: Union[Unset, int] = 0,
        border_color: Union[Unset, str] = UNSET,
        border_radius: Union[Unset, int] = 0,
        opacity: Union[Unset, float] = 1,
        rotation: Union[Unset, int] = 0,
        background: Union[Unset, str] = UNSET,
        output: Union[Unset, str] = UNSET,
    ) -> 'Response[Any]':
        url = f'/storage/buckets/{bucket_id}/files/{file_id}/preview'

        params = {
            'width': width,
            'height': height,
            'gravity': gravity,
            'quality': quality,
            'borderWidth': border_width,
            'borderColor': border_color,
            'borderRadius': border_radius,
            'opacity': opacity,
            'rotation': rotation,
            'background': background,
            'output': output,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Any,
        )

    def storage_get_file_view(
        self,
        bucket_id: str,
        file_id: str,
    ) -> 'Response[Any]':
        headers = {}
        url = f'/storage/buckets/{bucket_id}/files/{file_id}/view'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Any,
        )

    async def async_storage_get_file_view(
        self,
        bucket_id: str,
        file_id: str,
    ) -> 'Response[Any]':
        url = f'/storage/buckets/{bucket_id}/files/{file_id}/view'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Any,
        )

    def storage_get_usage(
        self,
        range_: Union[Unset, str] = '30d',
    ) -> 'Response[UsageStorage]':
        headers = {}
        url = '/storage/usage'

        params = {
            'range': range_,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageStorage,
        )

    async def async_storage_get_usage(
        self,
        range_: Union[Unset, str] = '30d',
    ) -> 'Response[UsageStorage]':
        url = '/storage/usage'

        params = {
            'range': range_,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageStorage,
        )

    def storage_get_bucket_usage(
        self,
        bucket_id: str,
        range_: Union[Unset, str] = '30d',
    ) -> 'Response[UsageBuckets]':
        headers = {}
        url = f'/storage/{bucket_id}/usage'

        params = {
            'range': range_,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageBuckets,
        )

    async def async_storage_get_bucket_usage(
        self,
        bucket_id: str,
        range_: Union[Unset, str] = '30d',
    ) -> 'Response[UsageBuckets]':
        url = f'/storage/{bucket_id}/usage'

        params = {
            'range': range_,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageBuckets,
        )
