"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Literal, Union, overload

from cityfront.utils import UNSET, Unset, exclude_unset
from pydantic import BaseModel, parse_obj_as

from .models import (LogList, Membership, MembershipList, Payload51, Payload52,
                     Payload53, Payload54, Payload55, Team, TeamList)
from .types import (Payload51Type, Payload52Type, Payload53Type, Payload54Type,
                    Payload55Type)

if TYPE_CHECKING:
    from cityfront import AppWrite
    from cityfront.response import Response


class TeamsClient:
    def __init__(self, appwrite: 'AppWrite'):
        self._appwrite = appwrite

    def teams_list(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[TeamList]':
        headers = {}
        url = '/teams'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=TeamList,
        )

    async def async_teams_list(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[TeamList]':
        url = '/teams'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=TeamList,
        )

    @overload
    def teams_create(
        self, *, data: Union[Unset, Payload51Type] = UNSET
    ) -> 'Response[Team]':
        ...

    @overload
    def teams_create(
        self,
        *,
        data: Unset = UNSET,
        team_id: str,
        name: str,
        roles: Union[Unset, List[str]] = ['owner'],
    ) -> 'Response[Team]':
        ...

    def teams_create(
        self, *, data: Union[Unset, Payload51Type] = UNSET, **kwargs
    ) -> 'Response[Team]':
        headers = {}
        url = '/teams'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload51, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Team,
        )

    @overload
    async def async_teams_create(
        self, *, data: Union[Unset, Payload51Type] = UNSET
    ) -> 'Response[Team]':
        ...

    @overload
    async def async_teams_create(
        self,
        *,
        data: Unset = UNSET,
        team_id: str,
        name: str,
        roles: Union[Unset, List[str]] = ['owner'],
    ) -> 'Response[Team]':
        ...

    async def async_teams_create(
        self, *, data: Union[Unset, Payload51Type] = UNSET, **kwargs
    ) -> 'Response[Team]':
        url = '/teams'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload51, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Team,
        )

    def teams_get(
        self,
        team_id: str,
    ) -> 'Response[Team]':
        headers = {}
        url = f'/teams/{team_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Team,
        )

    async def async_teams_get(
        self,
        team_id: str,
    ) -> 'Response[Team]':
        url = f'/teams/{team_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=Team,
        )

    @overload
    def teams_update(
        self, team_id: str, *, data: Union[Unset, Payload52Type] = UNSET
    ) -> 'Response[Team]':
        ...

    @overload
    def teams_update(
        self,
        team_id: str,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> 'Response[Team]':
        ...

    def teams_update(
        self,
        team_id: str,
        *,
        data: Union[Unset, Payload52Type] = UNSET,
        **kwargs,
    ) -> 'Response[Team]':
        headers = {}
        url = f'/teams/{team_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload52, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Team,
        )

    @overload
    async def async_teams_update(
        self, team_id: str, *, data: Union[Unset, Payload52Type] = UNSET
    ) -> 'Response[Team]':
        ...

    @overload
    async def async_teams_update(
        self,
        team_id: str,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> 'Response[Team]':
        ...

    async def async_teams_update(
        self,
        team_id: str,
        *,
        data: Union[Unset, Payload52Type] = UNSET,
        **kwargs,
    ) -> 'Response[Team]':
        url = f'/teams/{team_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload52, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PUT',
            url,
            json=exclude_unset(json),
            response_model=Team,
        )

    def teams_delete(
        self,
        team_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/teams/{team_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_teams_delete(
        self,
        team_id: str,
    ) -> 'Response':
        url = f'/teams/{team_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def teams_list_logs(
        self,
        team_id: str,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
    ) -> 'Response[LogList]':
        headers = {}
        url = f'/teams/{team_id}/logs'

        params = {
            'limit': limit,
            'offset': offset,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=LogList,
        )

    async def async_teams_list_logs(
        self,
        team_id: str,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
    ) -> 'Response[LogList]':
        url = f'/teams/{team_id}/logs'

        params = {
            'limit': limit,
            'offset': offset,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=LogList,
        )

    def teams_get_memberships(
        self,
        team_id: str,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[MembershipList]':
        headers = {}
        url = f'/teams/{team_id}/memberships'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=MembershipList,
        )

    async def async_teams_get_memberships(
        self,
        team_id: str,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[MembershipList]':
        url = f'/teams/{team_id}/memberships'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=MembershipList,
        )

    @overload
    def teams_create_membership(
        self, team_id: str, *, data: Union[Unset, Payload53Type] = UNSET
    ) -> 'Response[Membership]':
        ...

    @overload
    def teams_create_membership(
        self,
        team_id: str,
        *,
        data: Unset = UNSET,
        email: str,
        roles: List[str],
        url: str,
        name: Union[Unset, str] = UNSET,
    ) -> 'Response[Membership]':
        ...

    def teams_create_membership(
        self,
        team_id: str,
        *,
        data: Union[Unset, Payload53Type] = UNSET,
        **kwargs,
    ) -> 'Response[Membership]':
        headers = {}
        url = f'/teams/{team_id}/memberships'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload53, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Membership,
        )

    @overload
    async def async_teams_create_membership(
        self, team_id: str, *, data: Union[Unset, Payload53Type] = UNSET
    ) -> 'Response[Membership]':
        ...

    @overload
    async def async_teams_create_membership(
        self,
        team_id: str,
        *,
        data: Unset = UNSET,
        email: str,
        roles: List[str],
        url: str,
        name: Union[Unset, str] = UNSET,
    ) -> 'Response[Membership]':
        ...

    async def async_teams_create_membership(
        self,
        team_id: str,
        *,
        data: Union[Unset, Payload53Type] = UNSET,
        **kwargs,
    ) -> 'Response[Membership]':
        url = f'/teams/{team_id}/memberships'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload53, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=Membership,
        )

    def teams_get_membership(
        self,
        team_id: str,
        membership_id: str,
    ) -> 'Response[MembershipList]':
        headers = {}
        url = f'/teams/{team_id}/memberships/{membership_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=MembershipList,
        )

    async def async_teams_get_membership(
        self,
        team_id: str,
        membership_id: str,
    ) -> 'Response[MembershipList]':
        url = f'/teams/{team_id}/memberships/{membership_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=MembershipList,
        )

    def teams_delete_membership(
        self,
        team_id: str,
        membership_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/teams/{team_id}/memberships/{membership_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_teams_delete_membership(
        self,
        team_id: str,
        membership_id: str,
    ) -> 'Response':
        url = f'/teams/{team_id}/memberships/{membership_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def teams_update_membership_roles(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Union[Unset, Payload54Type] = UNSET,
    ) -> 'Response[Membership]':
        ...

    @overload
    def teams_update_membership_roles(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Unset = UNSET,
        roles: List[str],
    ) -> 'Response[Membership]':
        ...

    def teams_update_membership_roles(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Union[Unset, Payload54Type] = UNSET,
        **kwargs,
    ) -> 'Response[Membership]':
        headers = {}
        url = f'/teams/{team_id}/memberships/{membership_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload54, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Membership,
        )

    @overload
    async def async_teams_update_membership_roles(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Union[Unset, Payload54Type] = UNSET,
    ) -> 'Response[Membership]':
        ...

    @overload
    async def async_teams_update_membership_roles(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Unset = UNSET,
        roles: List[str],
    ) -> 'Response[Membership]':
        ...

    async def async_teams_update_membership_roles(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Union[Unset, Payload54Type] = UNSET,
        **kwargs,
    ) -> 'Response[Membership]':
        url = f'/teams/{team_id}/memberships/{membership_id}'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload54, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Membership,
        )

    @overload
    def teams_update_membership_status(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Union[Unset, Payload55Type] = UNSET,
    ) -> 'Response[Membership]':
        ...

    @overload
    def teams_update_membership_status(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Membership]':
        ...

    def teams_update_membership_status(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Union[Unset, Payload55Type] = UNSET,
        **kwargs,
    ) -> 'Response[Membership]':
        headers = {}
        url = f'/teams/{team_id}/memberships/{membership_id}/status'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload55, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Membership,
        )

    @overload
    async def async_teams_update_membership_status(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Union[Unset, Payload55Type] = UNSET,
    ) -> 'Response[Membership]':
        ...

    @overload
    async def async_teams_update_membership_status(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Unset = UNSET,
        user_id: str,
        secret: str,
    ) -> 'Response[Membership]':
        ...

    async def async_teams_update_membership_status(
        self,
        team_id: str,
        membership_id: str,
        *,
        data: Union[Unset, Payload55Type] = UNSET,
        **kwargs,
    ) -> 'Response[Membership]':
        url = f'/teams/{team_id}/memberships/{membership_id}/status'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload55, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=Membership,
        )
