"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Literal, Union, overload

from cityfront.utils import UNSET, Unset, exclude_unset
from pydantic import BaseModel, parse_obj_as

from .models import (LogList, MembershipList, Payload2, Payload5, Payload56,
                     Payload57, Payload59, Payload60, Payload62, Payload63,
                     Payload64, SessionList, UsageUsers, User, UserList,
                     UsersUserIdPrefsGetResponse200,
                     UsersUserIdPrefsPatchResponse200)
from .types import (Payload2Type, Payload5PropPrefsType, Payload5Type,
                    Payload56Type, Payload57Type, Payload59Type, Payload60Type,
                    Payload62Type, Payload63Type, Payload64Type)

if TYPE_CHECKING:
    from cityfront import AppWrite
    from cityfront.response import Response


class UsersClient:
    def __init__(self, appwrite: 'AppWrite'):
        self._appwrite = appwrite

    def users_list(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[UserList]':
        headers = {}
        url = '/users'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserList,
        )

    async def async_users_list(
        self,
        search: Union[Unset, str] = UNSET,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
        cursor: Union[Unset, str] = UNSET,
        cursor_direction: Union[Unset, str] = 'after',
        order_type: Union[Unset, str] = 'ASC',
    ) -> 'Response[UserList]':
        url = '/users'

        params = {
            'search': search,
            'limit': limit,
            'offset': offset,
            'cursor': cursor,
            'cursorDirection': cursor_direction,
            'orderType': order_type,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserList,
        )

    @overload
    def users_create(
        self, *, data: Union[Unset, Payload56Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def users_create(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        email: str,
        password: str,
        name: Union[Unset, str] = UNSET,
    ) -> 'Response[User]':
        ...

    def users_create(
        self, *, data: Union[Unset, Payload56Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        headers = {}
        url = '/users'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload56, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_users_create(
        self, *, data: Union[Unset, Payload56Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_users_create(
        self,
        *,
        data: Unset = UNSET,
        user_id: str,
        email: str,
        password: str,
        name: Union[Unset, str] = UNSET,
    ) -> 'Response[User]':
        ...

    async def async_users_create(
        self, *, data: Union[Unset, Payload56Type] = UNSET, **kwargs
    ) -> 'Response[User]':
        url = '/users'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload56, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'POST',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    def users_get_usage(
        self,
        range_: Union[Unset, str] = '30d',
        provider: Union[Unset, str] = UNSET,
    ) -> 'Response[UsageUsers]':
        headers = {}
        url = '/users/usage'

        params = {
            'range': range_,
            'provider': provider,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageUsers,
        )

    async def async_users_get_usage(
        self,
        range_: Union[Unset, str] = '30d',
        provider: Union[Unset, str] = UNSET,
    ) -> 'Response[UsageUsers]':
        url = '/users/usage'

        params = {
            'range': range_,
            'provider': provider,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsageUsers,
        )

    def users_get(
        self,
        user_id: str,
    ) -> 'Response[User]':
        headers = {}
        url = f'/users/{user_id}'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=User,
        )

    async def async_users_get(
        self,
        user_id: str,
    ) -> 'Response[User]':
        url = f'/users/{user_id}'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=User,
        )

    def users_delete(
        self,
        user_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/users/{user_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_users_delete(
        self,
        user_id: str,
    ) -> 'Response':
        url = f'/users/{user_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def users_update_email(
        self, user_id: str, *, data: Union[Unset, Payload57Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def users_update_email(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        email: str,
    ) -> 'Response[User]':
        ...

    def users_update_email(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload57Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        headers = {}
        url = f'/users/{user_id}/email'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload57, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_users_update_email(
        self, user_id: str, *, data: Union[Unset, Payload57Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_users_update_email(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        email: str,
    ) -> 'Response[User]':
        ...

    async def async_users_update_email(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload57Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        url = f'/users/{user_id}/email'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload57, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    def users_get_logs(
        self,
        user_id: str,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
    ) -> 'Response[LogList]':
        headers = {}
        url = f'/users/{user_id}/logs'

        params = {
            'limit': limit,
            'offset': offset,
        }

        return self._appwrite.request(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=LogList,
        )

    async def async_users_get_logs(
        self,
        user_id: str,
        limit: Union[Unset, int] = 25,
        offset: Union[Unset, int] = 0,
    ) -> 'Response[LogList]':
        url = f'/users/{user_id}/logs'

        params = {
            'limit': limit,
            'offset': offset,
        }

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=LogList,
        )

    def users_get_memberships(
        self,
        user_id: str,
    ) -> 'Response[MembershipList]':
        headers = {}
        url = f'/users/{user_id}/memberships'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=MembershipList,
        )

    async def async_users_get_memberships(
        self,
        user_id: str,
    ) -> 'Response[MembershipList]':
        url = f'/users/{user_id}/memberships'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=MembershipList,
        )

    @overload
    def users_update_name(
        self, user_id: str, *, data: Union[Unset, Payload2Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def users_update_name(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> 'Response[User]':
        ...

    def users_update_name(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload2Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        headers = {}
        url = f'/users/{user_id}/name'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload2, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_users_update_name(
        self, user_id: str, *, data: Union[Unset, Payload2Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_users_update_name(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> 'Response[User]':
        ...

    async def async_users_update_name(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload2Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        url = f'/users/{user_id}/name'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload2, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    def users_update_password(
        self, user_id: str, *, data: Union[Unset, Payload59Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def users_update_password(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        password: str,
    ) -> 'Response[User]':
        ...

    def users_update_password(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload59Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        headers = {}
        url = f'/users/{user_id}/password'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload59, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_users_update_password(
        self, user_id: str, *, data: Union[Unset, Payload59Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_users_update_password(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        password: str,
    ) -> 'Response[User]':
        ...

    async def async_users_update_password(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload59Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        url = f'/users/{user_id}/password'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload59, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    def users_update_phone(
        self, user_id: str, *, data: Union[Unset, Payload60Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def users_update_phone(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        number: str,
    ) -> 'Response[User]':
        ...

    def users_update_phone(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload60Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        headers = {}
        url = f'/users/{user_id}/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload60, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_users_update_phone(
        self, user_id: str, *, data: Union[Unset, Payload60Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_users_update_phone(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        number: str,
    ) -> 'Response[User]':
        ...

    async def async_users_update_phone(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload60Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        url = f'/users/{user_id}/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload60, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    def users_get_prefs(
        self,
        user_id: str,
    ) -> 'Response[UsersUserIdPrefsGetResponse200]':
        headers = {}
        url = f'/users/{user_id}/prefs'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=UsersUserIdPrefsGetResponse200,
        )

    async def async_users_get_prefs(
        self,
        user_id: str,
    ) -> 'Response[UsersUserIdPrefsGetResponse200]':
        url = f'/users/{user_id}/prefs'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=UsersUserIdPrefsGetResponse200,
        )

    @overload
    def users_update_prefs(
        self, user_id: str, *, data: Union[Unset, Payload5Type] = UNSET
    ) -> 'Response[UsersUserIdPrefsPatchResponse200]':
        ...

    @overload
    def users_update_prefs(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        prefs: Payload5PropPrefsType,
    ) -> 'Response[UsersUserIdPrefsPatchResponse200]':
        ...

    def users_update_prefs(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload5Type] = UNSET,
        **kwargs,
    ) -> 'Response[UsersUserIdPrefsPatchResponse200]':
        headers = {}
        url = f'/users/{user_id}/prefs'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload5, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=UsersUserIdPrefsPatchResponse200,
        )

    @overload
    async def async_users_update_prefs(
        self, user_id: str, *, data: Union[Unset, Payload5Type] = UNSET
    ) -> 'Response[UsersUserIdPrefsPatchResponse200]':
        ...

    @overload
    async def async_users_update_prefs(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        prefs: Payload5PropPrefsType,
    ) -> 'Response[UsersUserIdPrefsPatchResponse200]':
        ...

    async def async_users_update_prefs(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload5Type] = UNSET,
        **kwargs,
    ) -> 'Response[UsersUserIdPrefsPatchResponse200]':
        url = f'/users/{user_id}/prefs'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload5, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=UsersUserIdPrefsPatchResponse200,
        )

    def users_get_sessions(
        self,
        user_id: str,
    ) -> 'Response[SessionList]':
        headers = {}
        url = f'/users/{user_id}/sessions'

        return self._appwrite.request(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=SessionList,
        )

    async def async_users_get_sessions(
        self,
        user_id: str,
    ) -> 'Response[SessionList]':
        url = f'/users/{user_id}/sessions'

        headers = {}
        return await self._appwrite.arequest(
            'GET',
            url,
            headers=exclude_unset(headers),
            response_model=SessionList,
        )

    def users_delete_sessions(
        self,
        user_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/users/{user_id}/sessions'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_users_delete_sessions(
        self,
        user_id: str,
    ) -> 'Response':
        url = f'/users/{user_id}/sessions'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    def users_delete_session(
        self,
        user_id: str,
        session_id: str,
    ) -> 'Response':
        headers = {}
        url = f'/users/{user_id}/sessions/{session_id}'

        return self._appwrite.request(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    async def async_users_delete_session(
        self,
        user_id: str,
        session_id: str,
    ) -> 'Response':
        url = f'/users/{user_id}/sessions/{session_id}'

        headers = {}
        return await self._appwrite.arequest(
            'DELETE',
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def users_update_status(
        self, user_id: str, *, data: Union[Unset, Payload62Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def users_update_status(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        status: bool,
    ) -> 'Response[User]':
        ...

    def users_update_status(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload62Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        headers = {}
        url = f'/users/{user_id}/status'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload62, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_users_update_status(
        self, user_id: str, *, data: Union[Unset, Payload62Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_users_update_status(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        status: bool,
    ) -> 'Response[User]':
        ...

    async def async_users_update_status(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload62Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        url = f'/users/{user_id}/status'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload62, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    def users_update_email_verification(
        self, user_id: str, *, data: Union[Unset, Payload63Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def users_update_email_verification(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        email_verification: bool,
    ) -> 'Response[User]':
        ...

    def users_update_email_verification(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload63Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        headers = {}
        url = f'/users/{user_id}/verification'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload63, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_users_update_email_verification(
        self, user_id: str, *, data: Union[Unset, Payload63Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_users_update_email_verification(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        email_verification: bool,
    ) -> 'Response[User]':
        ...

    async def async_users_update_email_verification(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload63Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        url = f'/users/{user_id}/verification'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload63, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    def users_update_phone_verification(
        self, user_id: str, *, data: Union[Unset, Payload64Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    def users_update_phone_verification(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        phone_verification: bool,
    ) -> 'Response[User]':
        ...

    def users_update_phone_verification(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload64Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        headers = {}
        url = f'/users/{user_id}/verification/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload64, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        return self._appwrite.request(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )

    @overload
    async def async_users_update_phone_verification(
        self, user_id: str, *, data: Union[Unset, Payload64Type] = UNSET
    ) -> 'Response[User]':
        ...

    @overload
    async def async_users_update_phone_verification(
        self,
        user_id: str,
        *,
        data: Unset = UNSET,
        phone_verification: bool,
    ) -> 'Response[User]':
        ...

    async def async_users_update_phone_verification(
        self,
        user_id: str,
        *,
        data: Union[Unset, Payload64Type] = UNSET,
        **kwargs,
    ) -> 'Response[User]':
        url = f'/users/{user_id}/verification/phone'

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Payload64, json)
        json = (
            json.dict(by_alias=True) if isinstance(json, BaseModel) else json
        )

        headers = {}
        return await self._appwrite.arequest(
            'PATCH',
            url,
            json=exclude_unset(json),
            response_model=User,
        )
