// Legendre-Gauss Quadrature Points and Weights

#if defined(_WIN32) || defined(__WIN32__)
  #define EXPORTIT __declspec(dllexport)
#else
  #define EXPORTIT
#endif

EXPORTIT void leggauss_quad_304(int n, double *points, double *weights) {
    switch(n) {
    case 2:
        points[0] = -0.577350269189625764509148780501957455647601751270126876;
        points[1] = 0.577350269189625764509148780501957455647601751270126876;
        weights[0] = 1.;
        weights[1] = 1.;
        return;
    case 3:
        points[0] = -0.774596669241483377035853079956479922166584341058318165;
        points[1] = 0;
        points[2] = 0.774596669241483377035853079956479922166584341058318165;
        weights[0] = 0.555555555555555555555555555555555555555555555555555556;
        weights[1] = 0.888888888888888888888888888888888888888888888888888889;
        weights[2] = 0.555555555555555555555555555555555555555555555555555556;
        return;
    case 4:
        points[0] = -0.861136311594052575223946488892809505095725379629717638;
        points[1] = -0.339981043584856264802665759103244687200575869770914353;
        points[2] = 0.339981043584856264802665759103244687200575869770914353;
        points[3] = 0.861136311594052575223946488892809505095725379629717638;
        weights[0] = 0.34785484513745385737306394922199940723534869583389354;
        weights[1] = 0.65214515486254614262693605077800059276465130416610646;
        weights[2] = 0.65214515486254614262693605077800059276465130416610646;
        weights[3] = 0.34785484513745385737306394922199940723534869583389354;
        return;
    case 5:
        points[0] = -0.906179845938663992797626878299392965125651910762530863;
        points[1] = -0.538469310105683091036314420700208804967286606905559956;
        points[2] = 0;
        points[3] = 0.538469310105683091036314420700208804967286606905559956;
        points[4] = 0.906179845938663992797626878299392965125651910762530863;
        weights[0] = 0.236926885056189087514264040719917362643260002212414016;
        weights[1] = 0.47862867049936646804129151483563819291229555334314154;
        weights[2] = 0.568888888888888888888888888888888888888888888888888889;
        weights[3] = 0.47862867049936646804129151483563819291229555334314154;
        weights[4] = 0.236926885056189087514264040719917362643260002212414016;
        return;
    case 6:
        points[0] = -0.932469514203152027812301554493994609134765737712289825;
        points[1] = -0.661209386466264513661399595019905347006448564395170071;
        points[2] = -0.23861918608319690863050172168071193541861063014002135;
        points[3] = 0.23861918608319690863050172168071193541861063014002135;
        points[4] = 0.661209386466264513661399595019905347006448564395170071;
        points[5] = 0.932469514203152027812301554493994609134765737712289825;
        weights[0] = 0.171324492379170345040296142172732893526822501484043982;
        weights[1] = 0.360761573048138607569833513837716111661521892746745482;
        weights[2] = 0.467913934572691047389870343989550994811655605769210535;
        weights[3] = 0.467913934572691047389870343989550994811655605769210535;
        weights[4] = 0.360761573048138607569833513837716111661521892746745482;
        weights[5] = 0.171324492379170345040296142172732893526822501484043982;
        return;
    case 7:
        points[0] = -0.949107912342758524526189684047851262400770937670617784;
        points[1] = -0.74153118559939443986386477328078840707414764714139026;
        points[2] = -0.405845151377397166906606412076961463347382014099370126;
        points[3] = 0;
        points[4] = 0.405845151377397166906606412076961463347382014099370126;
        points[5] = 0.74153118559939443986386477328078840707414764714139026;
        points[6] = 0.949107912342758524526189684047851262400770937670617784;
        weights[0] = 0.129484966168869693270611432679082018328587402259946664;
        weights[1] = 0.279705391489276667901467771423779582486925065226598765;
        weights[2] = 0.381830050505118944950369775488975133878365083533862735;
        weights[3] = 0.417959183673469387755102040816326530612244897959183673;
        weights[4] = 0.381830050505118944950369775488975133878365083533862735;
        weights[5] = 0.279705391489276667901467771423779582486925065226598765;
        weights[6] = 0.129484966168869693270611432679082018328587402259946664;
        return;
    case 8:
        points[0] = -0.960289856497536231683560868569472990428235234301452038;
        points[1] = -0.796666477413626739591553936475830436837171731615964832;
        points[2] = -0.525532409916328985817739049189246349041964243120392858;
        points[3] = -0.183434642495649804939476142360183980666757812912973782;
        points[4] = 0.183434642495649804939476142360183980666757812912973782;
        points[5] = 0.525532409916328985817739049189246349041964243120392858;
        points[6] = 0.796666477413626739591553936475830436837171731615964832;
        points[7] = 0.960289856497536231683560868569472990428235234301452038;
        weights[0] = 0.101228536290376259152531354309962190115394091051684957;
        weights[1] = 0.222381034453374470544355994426240884430130870051249565;
        weights[2] = 0.313706645877887287337962201986601313260328999002734938;
        weights[3] = 0.362683783378361982965150449277195612194146039894330541;
        weights[4] = 0.362683783378361982965150449277195612194146039894330541;
        weights[5] = 0.313706645877887287337962201986601313260328999002734938;
        weights[6] = 0.222381034453374470544355994426240884430130870051249565;
        weights[7] = 0.101228536290376259152531354309962190115394091051684957;
        return;
    case 9:
        points[0] = -0.96816023950762608983557620290367287004940480049192533;
        points[1] = -0.836031107326635794299429788069734876544106718124675996;
        points[2] = -0.613371432700590397308702039341474184785720604940564693;
        points[3] = -0.324253423403808929038538014643336608571956260736973089;
        points[4] = 0;
        points[5] = 0.324253423403808929038538014643336608571956260736973089;
        points[6] = 0.613371432700590397308702039341474184785720604940564693;
        points[7] = 0.836031107326635794299429788069734876544106718124675996;
        points[8] = 0.96816023950762608983557620290367287004940480049192533;
        weights[0] = 0.0812743883615744119718921581105236506756617207824107507;
        weights[1] = 0.180648160694857404058472031242912809514337821732040484;
        weights[2] = 0.260610696402935462318742869418632849771840204437299952;
        weights[3] = 0.312347077040002840068630406584443665598754861261904646;
        weights[4] = 0.330239355001259763164525069286974048878810783572688335;
        weights[5] = 0.312347077040002840068630406584443665598754861261904646;
        weights[6] = 0.260610696402935462318742869418632849771840204437299952;
        weights[7] = 0.180648160694857404058472031242912809514337821732040484;
        weights[8] = 0.0812743883615744119718921581105236506756617207824107507;
        return;
    case 10:
        points[0] = -0.973906528517171720077964012084452053428269946692382119;
        points[1] = -0.865063366688984510732096688423493048527543014965330453;
        points[2] = -0.679409568299024406234327365114873575769294711834809468;
        points[3] = -0.433395394129247190799265943165784162200071837656246497;
        points[4] = -0.148874338981631210884826001129719984617564859420691696;
        points[5] = 0.148874338981631210884826001129719984617564859420691696;
        points[6] = 0.433395394129247190799265943165784162200071837656246497;
        points[7] = 0.679409568299024406234327365114873575769294711834809468;
        points[8] = 0.865063366688984510732096688423493048527543014965330453;
        points[9] = 0.973906528517171720077964012084452053428269946692382119;
        weights[0] = 0.0666713443086881375935688098933317928578648343201581451;
        weights[1] = 0.149451349150580593145776339657697332402556639669427368;
        weights[2] = 0.21908636251598204399553493422816319245877187052267709;
        weights[3] = 0.269266719309996355091226921569469352859759938460883796;
        weights[4] = 0.295524224714752870173892994651338329421046717026853601;
        weights[5] = 0.295524224714752870173892994651338329421046717026853601;
        weights[6] = 0.269266719309996355091226921569469352859759938460883796;
        weights[7] = 0.21908636251598204399553493422816319245877187052267709;
        weights[8] = 0.149451349150580593145776339657697332402556639669427368;
        weights[9] = 0.0666713443086881375935688098933317928578648343201581451;
        return;
    case 11:
        points[0] = -0.978228658146056992803938001122857390771422408919784415;
        points[1] = -0.887062599768095299075157769303927266631675751225314385;
        points[2] = -0.730152005574049324093416252031153458049643062026130312;
        points[3] = -0.519096129206811815925725669458609554480227115119928489;
        points[4] = -0.269543155952344972331531985400861524679621862439052282;
        points[5] = 0;
        points[6] = 0.269543155952344972331531985400861524679621862439052282;
        points[7] = 0.519096129206811815925725669458609554480227115119928489;
        points[8] = 0.730152005574049324093416252031153458049643062026130312;
        points[9] = 0.887062599768095299075157769303927266631675751225314385;
        points[10] = 0.978228658146056992803938001122857390771422408919784415;
        weights[0] = 0.0556685671161736664827537204425485787285156256968981483;
        weights[1] = 0.125580369464904624634694299223940100197615791395403501;
        weights[2] = 0.186290210927734251426097641431655891691284748040203412;
        weights[3] = 0.233193764591990479918523704843175139431798172316958509;
        weights[4] = 0.262804544510246662180688869890509195372764677603144556;
        weights[5] = 0.272925086777900630714483528336342189156041969894783748;
        weights[6] = 0.262804544510246662180688869890509195372764677603144556;
        weights[7] = 0.233193764591990479918523704843175139431798172316958509;
        weights[8] = 0.186290210927734251426097641431655891691284748040203412;
        weights[9] = 0.125580369464904624634694299223940100197615791395403501;
        weights[10] = 0.0556685671161736664827537204425485787285156256968981483;
        return;
    case 12:
        points[0] = -0.98156063424671925069054909014928082296015519981373151;
        points[1] = -0.904117256370474856678465866119096192537596709213297547;
        points[2] = -0.769902674194304687036893833212818075984925750018931638;
        points[3] = -0.587317954286617447296702418940534280369098514048052482;
        points[4] = -0.367831498998180193752691536643717561256360141335409621;
        points[5] = -0.125233408511468915472441369463853129983396916305444273;
        points[6] = 0.125233408511468915472441369463853129983396916305444273;
        points[7] = 0.367831498998180193752691536643717561256360141335409621;
        points[8] = 0.587317954286617447296702418940534280369098514048052482;
        points[9] = 0.769902674194304687036893833212818075984925750018931638;
        points[10] = 0.904117256370474856678465866119096192537596709213297547;
        points[11] = 0.98156063424671925069054909014928082296015519981373151;
        weights[0] = 0.0471753363865118271946159614850170603170290739948470896;
        weights[1] = 0.10693932599531843096025471819399622421457017347032488;
        weights[2] = 0.160078328543346226334652529543359071872011730490864178;
        weights[3] = 0.203167426723065921749064455809798376506518147274590146;
        weights[4] = 0.233492536538354808760849898924878056259409972199754875;
        weights[5] = 0.249147045813402785000562436042951210830460902569618831;
        weights[6] = 0.249147045813402785000562436042951210830460902569618831;
        weights[7] = 0.233492536538354808760849898924878056259409972199754875;
        weights[8] = 0.203167426723065921749064455809798376506518147274590146;
        weights[9] = 0.160078328543346226334652529543359071872011730490864178;
        weights[10] = 0.10693932599531843096025471819399622421457017347032488;
        weights[11] = 0.0471753363865118271946159614850170603170290739948470896;
        return;
    case 13:
        points[0] = -0.984183054718588149472829448807109611064990561925874909;
        points[1] = -0.917598399222977965206547836500719512390474790111683296;
        points[2] = -0.80157809073330991279420648958285989030561572479050003;
        points[3] = -0.642349339440340220643984606995515650071697398261576857;
        points[4] = -0.448492751036446852877912852127639867801921667441757879;
        points[5] = -0.230458315955134794065528121097988835211542375883531163;
        points[6] = 0;
        points[7] = 0.230458315955134794065528121097988835211542375883531163;
        points[8] = 0.448492751036446852877912852127639867801921667441757879;
        points[9] = 0.642349339440340220643984606995515650071697398261576857;
        points[10] = 0.80157809073330991279420648958285989030561572479050003;
        points[11] = 0.917598399222977965206547836500719512390474790111683296;
        points[12] = 0.984183054718588149472829448807109611064990561925874909;
        weights[0] = 0.0404840047653158795200215922009860600419865457449888681;
        weights[1] = 0.0921214998377284479144217759537971209236839998622368391;
        weights[2] = 0.138873510219787238463601776868871467621862718263298228;
        weights[3] = 0.178145980761945738280046691996097995512812650661016503;
        weights[4] = 0.207816047536888502312523219306052763386582609199503549;
        weights[5] = 0.22628318026289723841209018603977661843475773761555702;
        weights[6] = 0.232551553230873910194589515268835948156627477306797986;
        weights[7] = 0.22628318026289723841209018603977661843475773761555702;
        weights[8] = 0.207816047536888502312523219306052763386582609199503549;
        weights[9] = 0.178145980761945738280046691996097995512812650661016503;
        weights[10] = 0.138873510219787238463601776868871467621862718263298228;
        weights[11] = 0.0921214998377284479144217759537971209236839998622368391;
        weights[12] = 0.0404840047653158795200215922009860600419865457449888681;
        return;
    case 14:
        points[0] = -0.986283808696812338841597266704052801676091407239225882;
        points[1] = -0.928434883663573517336391139377874264477039210409837619;
        points[2] = -0.827201315069764993189794742650394961039701101475081182;
        points[3] = -0.687292904811685470148019803019334137538401212747170676;
        points[4] = -0.515248636358154091965290718551188662308885282569306037;
        points[5] = -0.319112368927889760435671824168475466834261203533843957;
        points[6] = -0.108054948707343662066244650219834747611951605474237557;
        points[7] = 0.108054948707343662066244650219834747611951605474237557;
        points[8] = 0.319112368927889760435671824168475466834261203533843957;
        points[9] = 0.515248636358154091965290718551188662308885282569306037;
        points[10] = 0.687292904811685470148019803019334137538401212747170676;
        points[11] = 0.827201315069764993189794742650394961039701101475081182;
        points[12] = 0.928434883663573517336391139377874264477039210409837619;
        points[13] = 0.986283808696812338841597266704052801676091407239225882;
        weights[0] = 0.0351194603317518630318328761381917806197056092771272766;
        weights[1] = 0.0801580871597602098056332770628543095836977853945947652;
        weights[2] = 0.121518570687903184689414809072476625956669345690074672;
        weights[3] = 0.157203167158193534569601938623842156605668037337323375;
        weights[4] = 0.185538397477937813741716590125157036248922602937331659;
        weights[5] = 0.205198463721295603965924065661218055710339061309419452;
        weights[6] = 0.2152638534631577901958764433162600352749975580541288;
        weights[7] = 0.2152638534631577901958764433162600352749975580541288;
        weights[8] = 0.205198463721295603965924065661218055710339061309419452;
        weights[9] = 0.185538397477937813741716590125157036248922602937331659;
        weights[10] = 0.157203167158193534569601938623842156605668037337323375;
        weights[11] = 0.121518570687903184689414809072476625956669345690074672;
        weights[12] = 0.0801580871597602098056332770628543095836977853945947652;
        weights[13] = 0.0351194603317518630318328761381917806197056092771272766;
        return;
    case 15:
        points[0] = -0.98799251802048542848956571858661258114697281712376149;
        points[1] = -0.937273392400705904307758947710209471243996273515304458;
        points[2] = -0.848206583410427216200648320774216851366256174736992634;
        points[3] = -0.724417731360170047416186054613938009630899294584102564;
        points[4] = -0.570972172608538847537226737253910641238386396282749605;
        points[5] = -0.394151347077563369897207370981045468362752776158698255;
        points[6] = -0.20119409399743452230062830339459620781283645446263768;
        points[7] = 0;
        points[8] = 0.20119409399743452230062830339459620781283645446263768;
        points[9] = 0.394151347077563369897207370981045468362752776158698255;
        points[10] = 0.570972172608538847537226737253910641238386396282749605;
        points[11] = 0.724417731360170047416186054613938009630899294584102564;
        points[12] = 0.848206583410427216200648320774216851366256174736992634;
        points[13] = 0.937273392400705904307758947710209471243996273515304458;
        points[14] = 0.98799251802048542848956571858661258114697281712376149;
        weights[0] = 0.0307532419961172683546283935772044177217481448334340743;
        weights[1] = 0.0703660474881081247092674164506673384667080327543307198;
        weights[2] = 0.107159220467171935011869546685869303415543715758101981;
        weights[3] = 0.139570677926154314447804794511028322520850275315511243;
        weights[4] = 0.166269205816993933553200860481208811130900180098412907;
        weights[5] = 0.186161000015562211026800561866422824506226012277928403;
        weights[6] = 0.198431485327111576456118326443839324818692559957541993;
        weights[7] = 0.202578241925561272880620199967519314838662158009477357;
        weights[8] = 0.198431485327111576456118326443839324818692559957541993;
        weights[9] = 0.186161000015562211026800561866422824506226012277928403;
        weights[10] = 0.166269205816993933553200860481208811130900180098412907;
        weights[11] = 0.139570677926154314447804794511028322520850275315511243;
        weights[12] = 0.107159220467171935011869546685869303415543715758101981;
        weights[13] = 0.0703660474881081247092674164506673384667080327543307198;
        weights[14] = 0.0307532419961172683546283935772044177217481448334340743;
        return;
    case 16:
        points[0] = -0.98940093499164993259615417345033262742627407165764513;
        points[1] = -0.944575023073232576077988415534608345091139272591072601;
        points[2] = -0.865631202387831743880467897712393132387335384847526708;
        points[3] = -0.75540440835500303389510119484744226835381365645750301;
        points[4] = -0.617876244402643748446671764048791018991882217765657794;
        points[5] = -0.458016777657227386342419442983577573540031613035523491;
        points[6] = -0.281603550779258913230460501460496106486069490770599801;
        points[7] = -0.0950125098376374401853193354249580631303530556890654567;
        points[8] = 0.0950125098376374401853193354249580631303530556890654567;
        points[9] = 0.281603550779258913230460501460496106486069490770599801;
        points[10] = 0.458016777657227386342419442983577573540031613035523491;
        points[11] = 0.617876244402643748446671764048791018991882217765657794;
        points[12] = 0.75540440835500303389510119484744226835381365645750301;
        points[13] = 0.865631202387831743880467897712393132387335384847526708;
        points[14] = 0.944575023073232576077988415534608345091139272591072601;
        points[15] = 0.98940093499164993259615417345033262742627407165764513;
        weights[0] = 0.027152459411754094851780572456018103512267375566760798;
        weights[1] = 0.0622535239386478928628438369943776942749865083529068579;
        weights[2] = 0.0951585116824927848099251076022462263552635031837126582;
        weights[3] = 0.12462897125553387205247628219201642014488685922220268;
        weights[4] = 0.149595988816576732081501730547478548970491068207836467;
        weights[5] = 0.169156519395002538189312079030359962211639473416028282;
        weights[6] = 0.182603415044923588866763667969219939383556223654649282;
        weights[7] = 0.189450610455068496285396723208283105146908988395902975;
        weights[8] = 0.189450610455068496285396723208283105146908988395902975;
        weights[9] = 0.182603415044923588866763667969219939383556223654649282;
        weights[10] = 0.169156519395002538189312079030359962211639473416028282;
        weights[11] = 0.149595988816576732081501730547478548970491068207836467;
        weights[12] = 0.12462897125553387205247628219201642014488685922220268;
        weights[13] = 0.0951585116824927848099251076022462263552635031837126582;
        weights[14] = 0.0622535239386478928628438369943776942749865083529068579;
        weights[15] = 0.027152459411754094851780572456018103512267375566760798;
        return;
    case 17:
        points[0] = -0.990575475314417335675434019940665276507789850459564303;
        points[1] = -0.950675521768767761222716957895803021443385046559108708;
        points[2] = -0.8802391537269859021229556944881556926234168179344279;
        points[3] = -0.781514003896801406925230055520476050223972472740568513;
        points[4] = -0.657671159216690765850302216643002335147805891475973244;
        points[5] = -0.512690537086476967886246568629551874582923722411172906;
        points[6] = -0.351231763453876315297185517095346005040539751575675023;
        points[7] = -0.178484181495847855850677493654065557475419332691525644;
        points[8] = 0;
        points[9] = 0.178484181495847855850677493654065557475419332691525644;
        points[10] = 0.351231763453876315297185517095346005040539751575675023;
        points[11] = 0.512690537086476967886246568629551874582923722411172906;
        points[12] = 0.657671159216690765850302216643002335147805891475973244;
        points[13] = 0.781514003896801406925230055520476050223972472740568513;
        points[14] = 0.8802391537269859021229556944881556926234168179344279;
        points[15] = 0.950675521768767761222716957895803021443385046559108708;
        points[16] = 0.990575475314417335675434019940665276507789850459564303;
        weights[0] = 0.0241483028685479319601100262875653246916973159450252783;
        weights[1] = 0.055459529373987201129440165358244660512846251953228847;
        weights[2] = 0.0850361483171791808835353701910620738504913892185054758;
        weights[3] = 0.11188384719340397109478838562635592673584342426307705;
        weights[4] = 0.13513636846852547328631998170235019737212585323448902;
        weights[5] = 0.154045761076810288081431594801958611940483058471017934;
        weights[6] = 0.168004102156450044509970663788323155021198128965074014;
        weights[7] = 0.176562705366992646325270990113197239150924418000748118;
        weights[8] = 0.179446470356206525458265644261885621448780319897668524;
        weights[9] = 0.176562705366992646325270990113197239150924418000748118;
        weights[10] = 0.168004102156450044509970663788323155021198128965074014;
        weights[11] = 0.154045761076810288081431594801958611940483058471017934;
        weights[12] = 0.13513636846852547328631998170235019737212585323448902;
        weights[13] = 0.11188384719340397109478838562635592673584342426307705;
        weights[14] = 0.0850361483171791808835353701910620738504913892185054758;
        weights[15] = 0.055459529373987201129440165358244660512846251953228847;
        weights[16] = 0.0241483028685479319601100262875653246916973159450252783;
        return;
    case 18:
        points[0] = -0.991565168420930946730016004706150770252578936845439693;
        points[1] = -0.955823949571397755181195892929776309972844134811306479;
        points[2] = -0.892602466497555739206060591127145515407895271352298214;
        points[3] = -0.803704958972523115682417455014590797103298921611922482;
        points[4] = -0.691687043060353207874891081288848389452270572817507759;
        points[5] = -0.559770831073947534607871548525329136927626485770709417;
        points[6] = -0.411751161462842646035931793833051637078989682120025511;
        points[7] = -0.251886225691505509588972854877911230162861765659640458;
        points[8] = -0.08477501304173530124226185293578381173331738690608992;
        points[9] = 0.08477501304173530124226185293578381173331738690608992;
        points[10] = 0.251886225691505509588972854877911230162861765659640458;
        points[11] = 0.411751161462842646035931793833051637078989682120025511;
        points[12] = 0.559770831073947534607871548525329136927626485770709417;
        points[13] = 0.691687043060353207874891081288848389452270572817507759;
        points[14] = 0.803704958972523115682417455014590797103298921611922482;
        points[15] = 0.892602466497555739206060591127145515407895271352298214;
        points[16] = 0.955823949571397755181195892929776309972844134811306479;
        points[17] = 0.991565168420930946730016004706150770252578936845439693;
        weights[0] = 0.0216160135264833103133427102664524693876852314755899455;
        weights[1] = 0.0497145488949697964533349462026386416808662461289102022;
        weights[2] = 0.0764257302548890565291296776166365256053179062083582874;
        weights[3] = 0.100942044106287165562813984924834607062801138887678902;
        weights[4] = 0.122555206711478460184519126800201555228163897333439097;
        weights[5] = 0.14064291467065065120473130375194722809550241033097256;
        weights[6] = 0.154684675126265244925418003836374772193218396267354173;
        weights[7] = 0.164276483745832722986053776465927590412338953997352953;
        weights[8] = 0.16914238296314359184065647013498661033410581937034388;
        weights[9] = 0.16914238296314359184065647013498661033410581937034388;
        weights[10] = 0.164276483745832722986053776465927590412338953997352953;
        weights[11] = 0.154684675126265244925418003836374772193218396267354173;
        weights[12] = 0.14064291467065065120473130375194722809550241033097256;
        weights[13] = 0.122555206711478460184519126800201555228163897333439097;
        weights[14] = 0.100942044106287165562813984924834607062801138887678902;
        weights[15] = 0.0764257302548890565291296776166365256053179062083582874;
        weights[16] = 0.0497145488949697964533349462026386416808662461289102022;
        weights[17] = 0.0216160135264833103133427102664524693876852314755899455;
        return;
    case 19:
        points[0] = -0.992406843843584403189017670253260493589316401403210787;
        points[1] = -0.960208152134830030852778840687651526615091503274138106;
        points[2] = -0.903155903614817901642660928532312487809393934057355818;
        points[3] = -0.822714656537142824978922486712713901774538486206830041;
        points[4] = -0.720966177335229378617095860823781629657141832908666775;
        points[5] = -0.600545304661681023469638164946239279868322082732292568;
        points[6] = -0.464570741375960945717267148104102367976285714624136597;
        points[7] = -0.316564099963629831990117328849844917892285219132887245;
        points[8] = -0.160358645640225375868096115740743549504873500470875379;
        points[9] = 0;
        points[10] = 0.160358645640225375868096115740743549504873500470875379;
        points[11] = 0.316564099963629831990117328849844917892285219132887245;
        points[12] = 0.464570741375960945717267148104102367976285714624136597;
        points[13] = 0.600545304661681023469638164946239279868322082732292568;
        points[14] = 0.720966177335229378617095860823781629657141832908666775;
        points[15] = 0.822714656537142824978922486712713901774538486206830041;
        points[16] = 0.903155903614817901642660928532312487809393934057355818;
        points[17] = 0.960208152134830030852778840687651526615091503274138106;
        points[18] = 0.992406843843584403189017670253260493589316401403210787;
        weights[0] = 0.0194617882297264770363120414644384357529066090692866408;
        weights[1] = 0.0448142267656996003328381574019942119517542274678576021;
        weights[2] = 0.0690445427376412265807082580060130449618480316876131311;
        weights[3] = 0.0914900216224499994644620941238396526609116512965987847;
        weights[4] = 0.111566645547333994716023901681765997481331853839893776;
        weights[5] = 0.128753962539336227675515784856877117055839577093463035;
        weights[6] = 0.142606702173606611775746109441902972475668344824473861;
        weights[7] = 0.152766042065859666778855400897662998461008267236428624;
        weights[8] = 0.158968843393954347649956439465047201678780158195126096;
        weights[9] = 0.161054449848783695979163625320916735039902558578516902;
        weights[10] = 0.158968843393954347649956439465047201678780158195126096;
        weights[11] = 0.152766042065859666778855400897662998461008267236428624;
        weights[12] = 0.142606702173606611775746109441902972475668344824473861;
        weights[13] = 0.128753962539336227675515784856877117055839577093463035;
        weights[14] = 0.111566645547333994716023901681765997481331853839893776;
        weights[15] = 0.0914900216224499994644620941238396526609116512965987847;
        weights[16] = 0.0690445427376412265807082580060130449618480316876131311;
        weights[17] = 0.0448142267656996003328381574019942119517542274678576021;
        weights[18] = 0.0194617882297264770363120414644384357529066090692866408;
        return;
    case 20:
        points[0] = -0.993128599185094924786122388471320278222647130901655896;
        points[1] = -0.963971927277913791267666131197277221912060327806188856;
        points[2] = -0.912234428251325905867752441203298113049184797423691775;
        points[3] = -0.839116971822218823394529061701520685329629365065637373;
        points[4] = -0.746331906460150792614305070355641590310730679569176444;
        points[5] = -0.636053680726515025452836696226285936743389116799368464;
        points[6] = -0.510867001950827098004364050955250998425491329202426833;
        points[7] = -0.373706088715419560672548177024927237395746321705682712;
        points[8] = -0.227785851141645078080496195368574624743088937682927472;
        points[9] = -0.0765265211334973337546404093988382110047962668134975008;
        points[10] = 0.0765265211334973337546404093988382110047962668134975008;
        points[11] = 0.227785851141645078080496195368574624743088937682927472;
        points[12] = 0.373706088715419560672548177024927237395746321705682712;
        points[13] = 0.510867001950827098004364050955250998425491329202426833;
        points[14] = 0.636053680726515025452836696226285936743389116799368464;
        points[15] = 0.746331906460150792614305070355641590310730679569176444;
        points[16] = 0.839116971822218823394529061701520685329629365065637373;
        points[17] = 0.912234428251325905867752441203298113049184797423691775;
        points[18] = 0.963971927277913791267666131197277221912060327806188856;
        points[19] = 0.993128599185094924786122388471320278222647130901655896;
        weights[0] = 0.0176140071391521183118619623518528163621431055433367325;
        weights[1] = 0.0406014298003869413310399522749321098790906399899515368;
        weights[2] = 0.0626720483341090635695065351870416063516010765784363641;
        weights[3] = 0.0832767415767047487247581432220462061001778285831632907;
        weights[4] = 0.101930119817240435036750135480349876166691656023392556;
        weights[5] = 0.118194531961518417312377377711382287005041219548968775;
        weights[6] = 0.131688638449176626898494499748163134916110511146983527;
        weights[7] = 0.142096109318382051329298325067164933034515413392020303;
        weights[8] = 0.149172986472603746787828737001969436692679904081368316;
        weights[9] = 0.152753387130725850698084331955097593491948645112378597;
        weights[10] = 0.152753387130725850698084331955097593491948645112378597;
        weights[11] = 0.149172986472603746787828737001969436692679904081368316;
        weights[12] = 0.142096109318382051329298325067164933034515413392020303;
        weights[13] = 0.131688638449176626898494499748163134916110511146983527;
        weights[14] = 0.118194531961518417312377377711382287005041219548968775;
        weights[15] = 0.101930119817240435036750135480349876166691656023392556;
        weights[16] = 0.0832767415767047487247581432220462061001778285831632907;
        weights[17] = 0.0626720483341090635695065351870416063516010765784363641;
        weights[18] = 0.0406014298003869413310399522749321098790906399899515368;
        weights[19] = 0.0176140071391521183118619623518528163621431055433367325;
        return;
    case 21:
        points[0] = -0.993752170620389500260242035937940929193338454782329186;
        points[1] = -0.96722683856630629431662221490769516142469368732984685;
        points[2] = -0.920099334150400828790187133714968894159147609648221697;
        points[3] = -0.853363364583317283647250638587567670276105803179343971;
        points[4] = -0.768439963475677908615877851306228034820976705771369551;
        points[5] = -0.667138804197412319305966669990339162597029343311402842;
        points[6] = -0.551618835887219807059018796724313286622060224230679665;
        points[7] = -0.424342120207438783573668888543788052096445231839634584;
        points[8] = -0.288021316802401096600792516064600319909018263646033229;
        points[9] = -0.145561854160895090937030982338686330116326024437937757;
        points[10] = 0;
        points[11] = 0.145561854160895090937030982338686330116326024437937757;
        points[12] = 0.288021316802401096600792516064600319909018263646033229;
        points[13] = 0.424342120207438783573668888543788052096445231839634584;
        points[14] = 0.551618835887219807059018796724313286622060224230679665;
        points[15] = 0.667138804197412319305966669990339162597029343311402842;
        points[16] = 0.768439963475677908615877851306228034820976705771369551;
        points[17] = 0.853363364583317283647250638587567670276105803179343971;
        points[18] = 0.920099334150400828790187133714968894159147609648221697;
        points[19] = 0.96722683856630629431662221490769516142469368732984685;
        points[20] = 0.993752170620389500260242035937940929193338454782329186;
        weights[0] = 0.0160172282577743333242246168584710152658904221179024825;
        weights[1] = 0.0369537897708524937999506682993296661889443081487298374;
        weights[2] = 0.0571344254268572082836358264724479574912875968262560414;
        weights[3] = 0.0761001136283793020170516533001831792261543524239660285;
        weights[4] = 0.0934444234560338615532897411139320884835266473615928449;
        weights[5] = 0.108797299167148377663474578070105642033699595793856331;
        weights[6] = 0.12183141605372853419536717712573359835633762556153745;
        weights[7] = 0.132268938633337461781052574496775604329011540143156823;
        weights[8] = 0.139887394791073154722133423867583110892793160954919604;
        weights[9] = 0.144524403989970059063827166553752543609949962197099835;
        weights[10] = 0.146081133649690427191985147683371188244809576941965444;
        weights[11] = 0.144524403989970059063827166553752543609949962197099835;
        weights[12] = 0.139887394791073154722133423867583110892793160954919604;
        weights[13] = 0.132268938633337461781052574496775604329011540143156823;
        weights[14] = 0.12183141605372853419536717712573359835633762556153745;
        weights[15] = 0.108797299167148377663474578070105642033699595793856331;
        weights[16] = 0.0934444234560338615532897411139320884835266473615928449;
        weights[17] = 0.0761001136283793020170516533001831792261543524239660285;
        weights[18] = 0.0571344254268572082836358264724479574912875968262560414;
        weights[19] = 0.0369537897708524937999506682993296661889443081487298374;
        weights[20] = 0.0160172282577743333242246168584710152658904221179024825;
        return;
    case 22:
        points[0] = -0.994294585482399292073031421161298980393054198396031535;
        points[1] = -0.97006049783542872712395098676526871080596892313780297;
        points[2] = -0.926956772187174000520692939259053196635329653372051982;
        points[3] = -0.865812577720300136536425637019378729084796755588446156;
        points[4] = -0.787816805979208162004277955408351521388178671331563158;
        points[5] = -0.694487263186682780050689835762256771267342289977435161;
        points[6] = -0.58764040350691159295887692763864734887761560357371784;
        points[7] = -0.469355837986757026406330710966406346095343791130736548;
        points[8] = -0.341935820892084225158147420427379619559173299170687344;
        points[9] = -0.20786042668822128547884653391954573421567510909793365;
        points[10] = -0.0697392733197222212138417961186280818222962994802314747;
        points[11] = 0.0697392733197222212138417961186280818222962994802314747;
        points[12] = 0.20786042668822128547884653391954573421567510909793365;
        points[13] = 0.341935820892084225158147420427379619559173299170687344;
        points[14] = 0.469355837986757026406330710966406346095343791130736548;
        points[15] = 0.58764040350691159295887692763864734887761560357371784;
        points[16] = 0.694487263186682780050689835762256771267342289977435161;
        points[17] = 0.787816805979208162004277955408351521388178671331563158;
        points[18] = 0.865812577720300136536425637019378729084796755588446156;
        points[19] = 0.926956772187174000520692939259053196635329653372051982;
        points[20] = 0.97006049783542872712395098676526871080596892313780297;
        points[21] = 0.994294585482399292073031421161298980393054198396031535;
        weights[0] = 0.0146279952982722006849910980471854451902119491243237309;
        weights[1] = 0.0337749015848141547933022468659129013491693144744746604;
        weights[2] = 0.0522933351526832859403120512732112561121500935692363161;
        weights[3] = 0.0697964684245204880949614189302176573987750529550805274;
        weights[4] = 0.0859416062170677274144436813727028661891444053490797833;
        weights[5] = 0.100414144442880964932078837830536282350811088767699626;
        weights[6] = 0.112932296080539218393400607421784319114263332120994704;
        weights[7] = 0.123252376810512424285560986154814471959444999004967972;
        weights[8] = 0.131173504787062370732964992530307445875741894188030653;
        weights[9] = 0.136541498346015171352573831231517396586367652988686168;
        weights[10] = 0.139251872855631993375410248341809957873920217457425858;
        weights[11] = 0.139251872855631993375410248341809957873920217457425858;
        weights[12] = 0.136541498346015171352573831231517396586367652988686168;
        weights[13] = 0.131173504787062370732964992530307445875741894188030653;
        weights[14] = 0.123252376810512424285560986154814471959444999004967972;
        weights[15] = 0.112932296080539218393400607421784319114263332120994704;
        weights[16] = 0.100414144442880964932078837830536282350811088767699626;
        weights[17] = 0.0859416062170677274144436813727028661891444053490797833;
        weights[18] = 0.0697964684245204880949614189302176573987750529550805274;
        weights[19] = 0.0522933351526832859403120512732112561121500935692363161;
        weights[20] = 0.0337749015848141547933022468659129013491693144744746604;
        weights[21] = 0.0146279952982722006849910980471854451902119491243237309;
        return;
    case 23:
        points[0] = -0.994769334997552123523925715445574360573627372458870421;
        points[1] = -0.972542471218115231956024076820777375181613795353973942;
        points[2] = -0.932971086826016102349196989038422978235701820151390771;
        points[3] = -0.876752358270441667378156885934145671638929029960650635;
        points[4] = -0.804888401618839892151118406996778557941430139730308023;
        points[5] = -0.718661363131950194461624483748618848329929745131292796;
        points[6] = -0.619609875763646156385097311649595653387180658807092296;
        points[7] = -0.509501477846007549689793047866846430544842769184857623;
        points[8] = -0.390301038030290831421488872880605458578050850692503481;
        points[9] = -0.264135680970344930533869538283309602979013250194139605;
        points[10] = -0.133256824298466110931742682241766137010405276253382157;
        points[11] = 0;
        points[12] = 0.133256824298466110931742682241766137010405276253382157;
        points[13] = 0.264135680970344930533869538283309602979013250194139605;
        points[14] = 0.390301038030290831421488872880605458578050850692503481;
        points[15] = 0.509501477846007549689793047866846430544842769184857623;
        points[16] = 0.619609875763646156385097311649595653387180658807092296;
        points[17] = 0.718661363131950194461624483748618848329929745131292796;
        points[18] = 0.804888401618839892151118406996778557941430139730308023;
        points[19] = 0.876752358270441667378156885934145671638929029960650635;
        points[20] = 0.932971086826016102349196989038422978235701820151390771;
        points[21] = 0.972542471218115231956024076820777375181613795353973942;
        points[22] = 0.994769334997552123523925715445574360573627372458870421;
        weights[0] = 0.0134118594871417720813094934586150649766183341057372334;
        weights[1] = 0.0309880058569794443106942196418845053837725289999280664;
        weights[2] = 0.0480376717310846685716410716320339965612163083035116113;
        weights[3] = 0.0642324214085258521271696151589109980391582757548068305;
        weights[4] = 0.0792814117767189549228925247420432269137119919384065026;
        weights[5] = 0.0929157660600351474770186173697646486034600717431298937;
        weights[6] = 0.104892091464541410074086185014743854858471583193975006;
        weights[7] = 0.114996640222411364941643512933961301491410522929585607;
        weights[8] = 0.123049084306729530467578400672009654815852812546470574;
        weights[9] = 0.128905722188082149978595339399793653259715497191783492;
        weights[10] = 0.132462039404696617371642464703316925805035669474223524;
        weights[11] = 0.133654572186106175351457110545844338583152807636883317;
        weights[12] = 0.132462039404696617371642464703316925805035669474223524;
        weights[13] = 0.128905722188082149978595339399793653259715497191783492;
        weights[14] = 0.123049084306729530467578400672009654815852812546470574;
        weights[15] = 0.114996640222411364941643512933961301491410522929585607;
        weights[16] = 0.104892091464541410074086185014743854858471583193975006;
        weights[17] = 0.0929157660600351474770186173697646486034600717431298937;
        weights[18] = 0.0792814117767189549228925247420432269137119919384065026;
        weights[19] = 0.0642324214085258521271696151589109980391582757548068305;
        weights[20] = 0.0480376717310846685716410716320339965612163083035116113;
        weights[21] = 0.0309880058569794443106942196418845053837725289999280664;
        weights[22] = 0.0134118594871417720813094934586150649766183341057372334;
        return;
    case 24:
        points[0] = -0.995187219997021360179997409700736811874597692596002877;
        points[1] = -0.97472855597130949819839199300816906174118305304017872;
        points[2] = -0.938274552002732758523649001708721449654819658077451347;
        points[3] = -0.88641552700440103421315434198219675508733304330892004;
        points[4] = -0.820001985973902921953949872669745208076126477667855587;
        points[5] = -0.740124191578554364243828103099978425523292487014185457;
        points[6] = -0.64809365193697556925249578691074762666965829861895678;
        points[7] = -0.545421471388839535658375617218372370010783992587618175;
        points[8] = -0.433793507626045138487084231913349712452421510927968808;
        points[9] = -0.315042679696163374386793291319810240786478260824817269;
        points[10] = -0.191118867473616309158639820757069631840405103314753356;
        points[11] = -0.0640568928626056260850430826247450385909991954207473934;
        points[12] = 0.0640568928626056260850430826247450385909991954207473934;
        points[13] = 0.191118867473616309158639820757069631840405103314753356;
        points[14] = 0.315042679696163374386793291319810240786478260824817269;
        points[15] = 0.433793507626045138487084231913349712452421510927968808;
        points[16] = 0.545421471388839535658375617218372370010783992587618175;
        points[17] = 0.64809365193697556925249578691074762666965829861895678;
        points[18] = 0.740124191578554364243828103099978425523292487014185457;
        points[19] = 0.820001985973902921953949872669745208076126477667855587;
        points[20] = 0.88641552700440103421315434198219675508733304330892004;
        points[21] = 0.938274552002732758523649001708721449654819658077451347;
        points[22] = 0.97472855597130949819839199300816906174118305304017872;
        points[23] = 0.995187219997021360179997409700736811874597692596002877;
        weights[0] = 0.0123412297999871995468056670700372915759100408913665168;
        weights[1] = 0.0285313886289336631813078159518782864491977979319081166;
        weights[2] = 0.0442774388174198061686027482113382288593128418338578967;
        weights[3] = 0.059298584915436780746367758500108584541200126565213491;
        weights[4] = 0.0733464814110803057340336152531165181193365098484994714;
        weights[5] = 0.0861901615319532759171852029837426671850805882379330056;
        weights[6] = 0.0976186521041138882698806644642471544279189688536859441;
        weights[7] = 0.107444270115965634782577342446606222794628690134220022;
        weights[8] = 0.115505668053725601353344483906783559862270311376496471;
        weights[9] = 0.121670472927803391204463153476262425607029559203805779;
        weights[10] = 0.125837456346828296121375382511183688726403325581345404;
        weights[11] = 0.127938195346752156974056165224695371851711239541667882;
        weights[12] = 0.127938195346752156974056165224695371851711239541667882;
        weights[13] = 0.125837456346828296121375382511183688726403325581345404;
        weights[14] = 0.121670472927803391204463153476262425607029559203805779;
        weights[15] = 0.115505668053725601353344483906783559862270311376496471;
        weights[16] = 0.107444270115965634782577342446606222794628690134220022;
        weights[17] = 0.0976186521041138882698806644642471544279189688536859441;
        weights[18] = 0.0861901615319532759171852029837426671850805882379330056;
        weights[19] = 0.0733464814110803057340336152531165181193365098484994714;
        weights[20] = 0.059298584915436780746367758500108584541200126565213491;
        weights[21] = 0.0442774388174198061686027482113382288593128418338578967;
        weights[22] = 0.0285313886289336631813078159518782864491977979319081166;
        weights[23] = 0.0123412297999871995468056670700372915759100408913665168;
        return;
    case 25:
        points[0] = -0.995556969790498097908784946893901617257562649404808171;
        points[1] = -0.976663921459517511498315386479594067745370555314406745;
        points[2] = -0.942974571228974339414011169658470531905201570608990142;
        points[3] = -0.894991997878275368851042006782804954174554849753583903;
        points[4] = -0.833442628760834001421021108693569569460964113823520786;
        points[5] = -0.759259263037357630577282865204360976387522018898334121;
        points[6] = -0.673566368473468364485120633247622175883416728072749317;
        points[7] = -0.577662930241222967723689841612654067395735039291518257;
        points[8] = -0.473002731445714960522182115009192041331817738461627291;
        points[9] = -0.36117230580938783773582173012764066742207834704337507;
        points[10] = -0.243866883720988432045190362797451586405633156325984476;
        points[11] = -0.122864692610710396387359818808036805532205346049783738;
        points[12] = 0;
        points[13] = 0.122864692610710396387359818808036805532205346049783738;
        points[14] = 0.243866883720988432045190362797451586405633156325984476;
        points[15] = 0.36117230580938783773582173012764066742207834704337507;
        points[16] = 0.473002731445714960522182115009192041331817738461627291;
        points[17] = 0.577662930241222967723689841612654067395735039291518257;
        points[18] = 0.673566368473468364485120633247622175883416728072749317;
        points[19] = 0.759259263037357630577282865204360976387522018898334121;
        points[20] = 0.833442628760834001421021108693569569460964113823520786;
        points[21] = 0.894991997878275368851042006782804954174554849753583903;
        points[22] = 0.942974571228974339414011169658470531905201570608990142;
        points[23] = 0.976663921459517511498315386479594067745370555314406745;
        points[24] = 0.995556969790498097908784946893901617257562649404808171;
        weights[0] = 0.0113937985010262879479029641132347736033205262929096964;
        weights[1] = 0.0263549866150321372619018152952991449359632817033224688;
        weights[2] = 0.0409391567013063126556234877116459536608457833641043465;
        weights[3] = 0.054904695975835191925936891540473324160109985553111349;
        weights[4] = 0.0680383338123569172071871856567079685547094943546365626;
        weights[5] = 0.0801407003350010180132349596691113022902257328536758937;
        weights[6] = 0.091028261982963649811497220702891653380992558959334311;
        weights[7] = 0.100535949067050644202206890392685826988466094528141907;
        weights[8] = 0.108519624474263653116093957050116619340077587986722016;
        weights[9] = 0.11485825914571164833932554586955580864093619166818015;
        weights[10] = 0.119455763535784772228178126512901047390176701413726426;
        weights[11] = 0.122242442990310041688959518945851505835059247563059041;
        weights[12] = 0.123176053726715451203902873079050142438233627518151665;
        weights[13] = 0.122242442990310041688959518945851505835059247563059041;
        weights[14] = 0.119455763535784772228178126512901047390176701413726426;
        weights[15] = 0.11485825914571164833932554586955580864093619166818015;
        weights[16] = 0.108519624474263653116093957050116619340077587986722016;
        weights[17] = 0.100535949067050644202206890392685826988466094528141907;
        weights[18] = 0.091028261982963649811497220702891653380992558959334311;
        weights[19] = 0.0801407003350010180132349596691113022902257328536758937;
        weights[20] = 0.0680383338123569172071871856567079685547094943546365626;
        weights[21] = 0.054904695975835191925936891540473324160109985553111349;
        weights[22] = 0.0409391567013063126556234877116459536608457833641043465;
        weights[23] = 0.0263549866150321372619018152952991449359632817033224688;
        weights[24] = 0.0113937985010262879479029641132347736033205262929096964;
        return;
    case 26:
        points[0] = -0.995885701145616929003216959322906025956857855119559667;
        points[1] = -0.978385445956470991100580354311926305446916563747318502;
        points[2] = -0.94715906666171425013591528351803675452071033768431527;
        points[3] = -0.902637861984307074217665599231210251341124005372905373;
        points[4] = -0.845445942788498018797507061467838161572075102091329569;
        points[5] = -0.776385948820678856192967247242283866976218256255194872;
        points[6] = -0.696427260419957264863813913729424697860753317790819152;
        points[7] = -0.60669229301761806323197874691688705443526457226590989;
        points[8] = -0.508440714824505717695703064725569175376306754185750814;
        points[9] = -0.403051755123486306481077377098883103659937409699316183;
        points[10] = -0.292004839485956895142835382077830296884719386962990378;
        points[11] = -0.176858820356890183969057748418344749977383763801264261;
        points[12] = -0.0592300934293132070937185751984033607902347353890355822;
        points[13] = 0.0592300934293132070937185751984033607902347353890355822;
        points[14] = 0.176858820356890183969057748418344749977383763801264261;
        points[15] = 0.292004839485956895142835382077830296884719386962990378;
        points[16] = 0.403051755123486306481077377098883103659937409699316183;
        points[17] = 0.508440714824505717695703064725569175376306754185750814;
        points[18] = 0.60669229301761806323197874691688705443526457226590989;
        points[19] = 0.696427260419957264863813913729424697860753317790819152;
        points[20] = 0.776385948820678856192967247242283866976218256255194872;
        points[21] = 0.845445942788498018797507061467838161572075102091329569;
        points[22] = 0.902637861984307074217665599231210251341124005372905373;
        points[23] = 0.94715906666171425013591528351803675452071033768431527;
        points[24] = 0.978385445956470991100580354311926305446916563747318502;
        points[25] = 0.995885701145616929003216959322906025956857855119559667;
        weights[0] = 0.0105513726173430071556511876852519779043457371796946146;
        weights[1] = 0.0244178510926319087896158275197884002404959261972703421;
        weights[2] = 0.0379623832943627639503031412488504946907704217440489577;
        weights[3] = 0.0509758252971478119983199007240733795258793185429719348;
        weights[4] = 0.0632740463295748355394536899070450957222228420126945107;
        weights[5] = 0.0746841497656597458870757961028483386387471618810406808;
        weights[6] = 0.0850458943134852392104477650799816965839203167766782762;
        weights[7] = 0.0942138003559141484636648830673031985491657459142072799;
        weights[8] = 0.10205916109442542323841407025343079232720881135424201;
        weights[9] = 0.108471840528576590656579426727997582289438203421306645;
        weights[10] = 0.113361816546319666549440718442598145245950362925015214;
        weights[11] = 0.116660443485296582044662507540362213631964881221924216;
        weights[12] = 0.118321415279262276516371085700468684649890270828905318;
        weights[13] = 0.118321415279262276516371085700468684649890270828905318;
        weights[14] = 0.116660443485296582044662507540362213631964881221924216;
        weights[15] = 0.113361816546319666549440718442598145245950362925015214;
        weights[16] = 0.108471840528576590656579426727997582289438203421306645;
        weights[17] = 0.10205916109442542323841407025343079232720881135424201;
        weights[18] = 0.0942138003559141484636648830673031985491657459142072799;
        weights[19] = 0.0850458943134852392104477650799816965839203167766782762;
        weights[20] = 0.0746841497656597458870757961028483386387471618810406808;
        weights[21] = 0.0632740463295748355394536899070450957222228420126945107;
        weights[22] = 0.0509758252971478119983199007240733795258793185429719348;
        weights[23] = 0.0379623832943627639503031412488504946907704217440489577;
        weights[24] = 0.0244178510926319087896158275197884002404959261972703421;
        weights[25] = 0.0105513726173430071556511876852519779043457371796946146;
        return;
    case 27:
        points[0] = -0.996179262888988566938887208381229990260688055565871188;
        points[1] = -0.979923475961501222855873355661047184567642221389950763;
        points[2] = -0.950900557814705006851908030643882893092589933484417651;
        points[3] = -0.909482320677491104300645018209689254948044335594960959;
        points[4] = -0.856207908018294490302737222706842797764286998603505827;
        points[5] = -0.791771639070508227144397344107270732919401065747863512;
        points[6] = -0.717013473739423699294816211642339549750672052098563143;
        points[7] = -0.632907971946495140927734637634488612103076017569336697;
        points[8] = -0.54055156457945689490030094155998282095918044898718169;
        points[9] = -0.441148251750026880585974155689281452447684595163099388;
        points[10] = -0.335993903638508899730319034207284541790020018907594191;
        points[11] = -0.226459365439536858857239107360230171179446732928203677;
        points[12] = -0.113972585609529966932894983869976627173280533978140995;
        points[13] = 0;
        points[14] = 0.113972585609529966932894983869976627173280533978140995;
        points[15] = 0.226459365439536858857239107360230171179446732928203677;
        points[16] = 0.335993903638508899730319034207284541790020018907594191;
        points[17] = 0.441148251750026880585974155689281452447684595163099388;
        points[18] = 0.54055156457945689490030094155998282095918044898718169;
        points[19] = 0.632907971946495140927734637634488612103076017569336697;
        points[20] = 0.717013473739423699294816211642339549750672052098563143;
        points[21] = 0.791771639070508227144397344107270732919401065747863512;
        points[22] = 0.856207908018294490302737222706842797764286998603505827;
        points[23] = 0.909482320677491104300645018209689254948044335594960959;
        points[24] = 0.950900557814705006851908030643882893092589933484417651;
        points[25] = 0.979923475961501222855873355661047184567642221389950763;
        points[26] = 0.996179262888988566938887208381229990260688055565871188;
        weights[0] = 0.00979899605129436026115005509125909809822581893509159217;
        weights[1] = 0.0226862315961806231960342064467614888127677202881663556;
        weights[2] = 0.0352970537574197110225782893047116411361388895229418116;
        weights[3] = 0.0474494125206150627040967101141847182247256201661847285;
        weights[4] = 0.0589835368598335991103008337195316331652405907064121625;
        weights[5] = 0.0697488237662455929843228883566672761328246932569520004;
        weights[6] = 0.0796048677730577712630749590098424029761466729870029514;
        weights[7] = 0.0884231585437569501943228028537491110565367500510991098;
        weights[8] = 0.0960887273700285075656526465581058591602116295370293344;
        weights[9] = 0.10250163781774579867124771153266380932440989491471733;
        weights[10] = 0.107578285788533187212162984426657404818966099063764666;
        weights[11] = 0.111252488356845192672163096042848674832920380085083267;
        weights[12] = 0.113476346108965148620369948092099257920524518810472026;
        weights[13] = 0.11422086737895698904504573690183524868072144335016533;
        weights[14] = 0.113476346108965148620369948092099257920524518810472026;
        weights[15] = 0.111252488356845192672163096042848674832920380085083267;
        weights[16] = 0.107578285788533187212162984426657404818966099063764666;
        weights[17] = 0.10250163781774579867124771153266380932440989491471733;
        weights[18] = 0.0960887273700285075656526465581058591602116295370293344;
        weights[19] = 0.0884231585437569501943228028537491110565367500510991098;
        weights[20] = 0.0796048677730577712630749590098424029761466729870029514;
        weights[21] = 0.0697488237662455929843228883566672761328246932569520004;
        weights[22] = 0.0589835368598335991103008337195316331652405907064121625;
        weights[23] = 0.0474494125206150627040967101141847182247256201661847285;
        weights[24] = 0.0352970537574197110225782893047116411361388895229418116;
        weights[25] = 0.0226862315961806231960342064467614888127677202881663556;
        weights[26] = 0.00979899605129436026115005509125909809822581893509159217;
        return;
    case 28:
        points[0] = -0.996442497573954449950436390483310991750130432096425905;
        points[1] = -0.98130316537087275369455994580783027644415495325313831;
        points[2] = -0.954259280628938197254101839705215589003403874087951675;
        points[3] = -0.915633026392132073869689423329927146352496795209121509;
        points[4] = -0.865892522574395048942254567379686804341862830784226337;
        points[5] = -0.805641370917179171447885955425277658671701414808311668;
        points[6] = -0.735610878013631772028144510292534368016061019993041893;
        points[7] = -0.656651094038864961219898176506742821569601690249929962;
        points[8] = -0.569720471811401719308003283356430933124712685656647228;
        points[9] = -0.475874224955118261034411847667434042627216145378655951;
        points[10] = -0.37625151608907871022135720955608698287169397704322291;
        points[11] = -0.272061627635178077676826356125769734824761296693522952;
        points[12] = -0.164569282133380771281471777891165457145725415601168176;
        points[13] = -0.0550792898840342704265165273418799778507959910608336837;
        points[14] = 0.0550792898840342704265165273418799778507959910608336837;
        points[15] = 0.164569282133380771281471777891165457145725415601168176;
        points[16] = 0.272061627635178077676826356125769734824761296693522952;
        points[17] = 0.37625151608907871022135720955608698287169397704322291;
        points[18] = 0.475874224955118261034411847667434042627216145378655951;
        points[19] = 0.569720471811401719308003283356430933124712685656647228;
        points[20] = 0.656651094038864961219898176506742821569601690249929962;
        points[21] = 0.735610878013631772028144510292534368016061019993041893;
        points[22] = 0.805641370917179171447885955425277658671701414808311668;
        points[23] = 0.865892522574395048942254567379686804341862830784226337;
        points[24] = 0.915633026392132073869689423329927146352496795209121509;
        points[25] = 0.954259280628938197254101839705215589003403874087951675;
        points[26] = 0.98130316537087275369455994580783027644415495325313831;
        points[27] = 0.996442497573954449950436390483310991750130432096425905;
        weights[0] = 0.00912428259309451773881615392295170624034449109829099942;
        weights[1] = 0.0211321125927712597515003809932654344513693507232856378;
        weights[2] = 0.0329014277823043799776308191705320459815308174200971879;
        weights[3] = 0.0442729347590042278395878776532073906149941127085668437;
        weights[4] = 0.0551073456757167454314829182269455912190579642256653884;
        weights[5] = 0.0652729239669995957933975667755046363536354311626070263;
        weights[6] = 0.0746462142345687790239318871730220380216358612063334474;
        weights[7] = 0.083113417228901218390396498244332479861134413443851333;
        weights[8] = 0.0905717443930328409421860313367841298228574854544848724;
        weights[9] = 0.096930657997929915850489006095440601765033123356461605;
        weights[10] = 0.102112967578060769814216638505712135046580002357920541;
        weights[11] = 0.106055765922846417910416436996810828789922962685159517;
        weights[12] = 0.108711192258294135253571519303673367875278454666043968;
        weights[13] = 0.110047013016475196282376265601817613956625529491231633;
        weights[14] = 0.110047013016475196282376265601817613956625529491231633;
        weights[15] = 0.108711192258294135253571519303673367875278454666043968;
        weights[16] = 0.106055765922846417910416436996810828789922962685159517;
        weights[17] = 0.102112967578060769814216638505712135046580002357920541;
        weights[18] = 0.096930657997929915850489006095440601765033123356461605;
        weights[19] = 0.0905717443930328409421860313367841298228574854544848724;
        weights[20] = 0.083113417228901218390396498244332479861134413443851333;
        weights[21] = 0.0746462142345687790239318871730220380216358612063334474;
        weights[22] = 0.0652729239669995957933975667755046363536354311626070263;
        weights[23] = 0.0551073456757167454314829182269455912190579642256653884;
        weights[24] = 0.0442729347590042278395878776532073906149941127085668437;
        weights[25] = 0.0329014277823043799776308191705320459815308174200971879;
        weights[26] = 0.0211321125927712597515003809932654344513693507232856378;
        weights[27] = 0.00912428259309451773881615392295170624034449109829099942;
        return;
    case 29:
        points[0] = -0.996679442260596586163191532549353885651773453250880002;
        points[1] = -0.982545505261413174870926015786376956106781948906431559;
        points[2] = -0.957285595778087725798208036980823563737559553954097071;
        points[3] = -0.921180232953058785093753436083106425408839343312293598;
        points[4] = -0.874637804920102790417793421256578546910616863119041371;
        points[5] = -0.818185487615252444989572214578784975630021561882293771;
        points[6] = -0.752462851734477133912610077212138190212591968228986608;
        points[7] = -0.678214537602686515156185005391985926388262930014645163;
        points[8] = -0.596281797138227820379586211188989780078186810385577638;
        points[9] = -0.507592955124227642102627919627520153351223840384584164;
        points[10] = -0.41315288817400866389070658603161682332343851873631392;
        points[11] = -0.314031637867639934948195923191047448258448819090827481;
        points[12] = -0.211352286166001074506375728902937499056650817712095148;
        points[13] = -0.106278230132679230170982392430376980917195439295607136;
        points[14] = 0;
        points[15] = 0.106278230132679230170982392430376980917195439295607136;
        points[16] = 0.211352286166001074506375728902937499056650817712095148;
        points[17] = 0.314031637867639934948195923191047448258448819090827481;
        points[18] = 0.41315288817400866389070658603161682332343851873631392;
        points[19] = 0.507592955124227642102627919627520153351223840384584164;
        points[20] = 0.596281797138227820379586211188989780078186810385577638;
        points[21] = 0.678214537602686515156185005391985926388262930014645163;
        points[22] = 0.752462851734477133912610077212138190212591968228986608;
        points[23] = 0.818185487615252444989572214578784975630021561882293771;
        points[24] = 0.874637804920102790417793421256578546910616863119041371;
        points[25] = 0.921180232953058785093753436083106425408839343312293598;
        points[26] = 0.957285595778087725798208036980823563737559553954097071;
        points[27] = 0.982545505261413174870926015786376956106781948906431559;
        points[28] = 0.996679442260596586163191532549353885651773453250880002;
        weights[0] = 0.00851690387874640965426381330224980300239888979851848605;
        weights[1] = 0.0197320850561227059838598016403956311496065681903615877;
        weights[2] = 0.0307404922020936226444085253746167497471162609687095103;
        weights[3] = 0.0414020625186828361048300101140769215334907803885743973;
        weights[4] = 0.0515948269024979239125943811795425979196221106461420677;
        weights[5] = 0.0612030906570791385421098480239070449240645397791302083;
        weights[6] = 0.0701179332550512785695814869488791731023948886747735819;
        weights[7] = 0.0782383271357637838281448886596803313668790769596697095;
        weights[8] = 0.0854722573661725275453448492972080713816982566135933953;
        weights[9] = 0.0917377571392587633479664110771108068982290209819545713;
        weights[10] = 0.0969638340944086063019000748826887591763562779218035643;
        weights[11] = 0.101091273759914966121820546907497363647567278852525199;
        weights[12] = 0.104073310077729373913328471285120068910652220675467692;
        weights[13] = 0.10587615509732094140659132785218789307483131374227804;
        weights[14] = 0.10647938171831424424651112690967756833018503161299598;
        weights[15] = 0.10587615509732094140659132785218789307483131374227804;
        weights[16] = 0.104073310077729373913328471285120068910652220675467692;
        weights[17] = 0.101091273759914966121820546907497363647567278852525199;
        weights[18] = 0.0969638340944086063019000748826887591763562779218035643;
        weights[19] = 0.0917377571392587633479664110771108068982290209819545713;
        weights[20] = 0.0854722573661725275453448492972080713816982566135933953;
        weights[21] = 0.0782383271357637838281448886596803313668790769596697095;
        weights[22] = 0.0701179332550512785695814869488791731023948886747735819;
        weights[23] = 0.0612030906570791385421098480239070449240645397791302083;
        weights[24] = 0.0515948269024979239125943811795425979196221106461420677;
        weights[25] = 0.0414020625186828361048300101140769215334907803885743973;
        weights[26] = 0.0307404922020936226444085253746167497471162609687095103;
        weights[27] = 0.0197320850561227059838598016403956311496065681903615877;
        weights[28] = 0.00851690387874640965426381330224980300239888979851848605;
        return;
    case 30:
        points[0] = -0.99689348407464954027163005091869528334088203811775079;
        points[1] = -0.983668123279747209970032581605662801940317854709711364;
        points[2] = -0.960021864968307512216871025581797662930359217403923399;
        points[3] = -0.926200047429274325879324277080474004086474536825329061;
        points[4] = -0.882560535792052681543116462530225590056689147146484232;
        points[5] = -0.829565762382768397442898119732501916439068696170341679;
        points[6] = -0.767777432104826194917977340974503131694883617232908453;
        points[7] = -0.697850494793315796932292388026640068382353800653954656;
        points[8] = -0.620526182989242861140477556431189299207364692829528133;
        points[9] = -0.536624148142019899264169793311072794164178006930297105;
        points[10] = -0.44703376953808917678060990032285400016240759386142441;
        points[11] = -0.352704725530878113471037207089373860653631008021425627;
        points[12] = -0.254636926167889846439805129817805107882789303302518426;
        points[13] = -0.153869913608583546963794672743255920418551971244338462;
        points[14] = -0.0514718425553176958330252131667225737491414536665695643;
        points[15] = 0.0514718425553176958330252131667225737491414536665695643;
        points[16] = 0.153869913608583546963794672743255920418551971244338462;
        points[17] = 0.254636926167889846439805129817805107882789303302518426;
        points[18] = 0.352704725530878113471037207089373860653631008021425627;
        points[19] = 0.44703376953808917678060990032285400016240759386142441;
        points[20] = 0.536624148142019899264169793311072794164178006930297105;
        points[21] = 0.620526182989242861140477556431189299207364692829528133;
        points[22] = 0.697850494793315796932292388026640068382353800653954656;
        points[23] = 0.767777432104826194917977340974503131694883617232908453;
        points[24] = 0.829565762382768397442898119732501916439068696170341679;
        points[25] = 0.882560535792052681543116462530225590056689147146484232;
        points[26] = 0.926200047429274325879324277080474004086474536825329061;
        points[27] = 0.960021864968307512216871025581797662930359217403923399;
        points[28] = 0.983668123279747209970032581605662801940317854709711364;
        points[29] = 0.99689348407464954027163005091869528334088203811775079;
        weights[0] = 0.00796819249616660561546588347467362245048069658715172123;
        weights[1] = 0.0184664683110909591423021319120472690962065339681814034;
        weights[2] = 0.0287847078833233693497191796112920436395888945462874965;
        weights[3] = 0.0387991925696270495968019364463476920332009767663953521;
        weights[4] = 0.0484026728305940529029381404228075178152718091973727363;
        weights[5] = 0.0574931562176190664817216894020561287971206707217631345;
        weights[6] = 0.065974229882180495128128515115962361237442953656660379;
        weights[7] = 0.0737559747377052062682438500221907341537705260370494389;
        weights[8] = 0.0807558952294202153546949384605297308758928037084392999;
        weights[9] = 0.086899787201082979802387530715125702576753328743545344;
        weights[10] = 0.0921225222377861287176327070876187671969132344182341075;
        weights[11] = 0.0963687371746442596394686263518098650964064614301602459;
        weights[12] = 0.0995934205867952670627802821035694765298692636667042772;
        weights[13] = 0.101762389748405504596428952168554044632706289487126841;
        weights[14] = 0.102852652893558840341285636705415043868375557064928223;
        weights[15] = 0.102852652893558840341285636705415043868375557064928223;
        weights[16] = 0.101762389748405504596428952168554044632706289487126841;
        weights[17] = 0.0995934205867952670627802821035694765298692636667042772;
        weights[18] = 0.0963687371746442596394686263518098650964064614301602459;
        weights[19] = 0.0921225222377861287176327070876187671969132344182341075;
        weights[20] = 0.086899787201082979802387530715125702576753328743545344;
        weights[21] = 0.0807558952294202153546949384605297308758928037084392999;
        weights[22] = 0.0737559747377052062682438500221907341537705260370494389;
        weights[23] = 0.065974229882180495128128515115962361237442953656660379;
        weights[24] = 0.0574931562176190664817216894020561287971206707217631345;
        weights[25] = 0.0484026728305940529029381404228075178152718091973727363;
        weights[26] = 0.0387991925696270495968019364463476920332009767663953521;
        weights[27] = 0.0287847078833233693497191796112920436395888945462874965;
        weights[28] = 0.0184664683110909591423021319120472690962065339681814034;
        weights[29] = 0.00796819249616660561546588347467362245048069658715172123;
        return;
    case 31:
        points[0] = -0.997087481819477074055626554223102508251445334117069631;
        points[1] = -0.984685909665152484002465166734684710938518269514643671;
        points[2] = -0.962503925092949661789052404105858301897219485152558377;
        points[3] = -0.930756997896648164956945759729263512813397687258082036;
        points[4] = -0.88976002994827104337419200898215926154359741186519095;
        points[5] = -0.839920320146267340086904535940178356054737301074749523;
        points[6] = -0.78173314841662494040636002019468449109541037201339888;
        points[7] = -0.715776784586853283905970865366485955890193476169588433;
        points[8] = -0.642706722924260346184418203232501453991690683336206757;
        points[9] = -0.563249161407149262720944923595161427948602273166887031;
        points[10] = -0.478193782044902480440594039356485748439523371497423125;
        points[11] = -0.388385901608232943061351461287520101985106267893544036;
        points[12] = -0.294718069981701616617903897671704338752855185278358557;
        points[13] = -0.19812119933557062877241299603283393777479481216155488;
        points[14] = -0.0995553121523415203251747901189407338389953587775273061;
        points[15] = 0;
        points[16] = 0.0995553121523415203251747901189407338389953587775273061;
        points[17] = 0.19812119933557062877241299603283393777479481216155488;
        points[18] = 0.294718069981701616617903897671704338752855185278358557;
        points[19] = 0.388385901608232943061351461287520101985106267893544036;
        points[20] = 0.478193782044902480440594039356485748439523371497423125;
        points[21] = 0.563249161407149262720944923595161427948602273166887031;
        points[22] = 0.642706722924260346184418203232501453991690683336206757;
        points[23] = 0.715776784586853283905970865366485955890193476169588433;
        points[24] = 0.78173314841662494040636002019468449109541037201339888;
        points[25] = 0.839920320146267340086904535940178356054737301074749523;
        points[26] = 0.88976002994827104337419200898215926154359741186519095;
        points[27] = 0.930756997896648164956945759729263512813397687258082036;
        points[28] = 0.962503925092949661789052404105858301897219485152558377;
        points[29] = 0.984685909665152484002465166734684710938518269514643671;
        points[30] = 0.997087481819477074055626554223102508251445334117069631;
        weights[0] = 0.0074708315792487758586968750322124070221508524840480397;
        weights[1] = 0.0173186207903105824631579960868211413662728627679957766;
        weights[2] = 0.0270090191849794218006087080919321561423566460021166459;
        weights[3] = 0.0364322739123854640243920104678034423271453320476676859;
        weights[4] = 0.0454937075272011029023158578946296772635527193100289649;
        weights[5] = 0.0541030824249168537116662590866200427203894625962118077;
        weights[6] = 0.0621747865610284269103435436866966671587287993646513153;
        weights[7] = 0.0696285832354103661677561262551257105150857073973433937;
        weights[8] = 0.0763903865987766164263576749013306449257569136942086541;
        weights[9] = 0.0823929917615892639038233674319617706157682665566462778;
        weights[10] = 0.0875767406084778761261980696953330922292581597712042515;
        weights[11] = 0.0918901138936414782153628716071501254973108253791578042;
        weights[12] = 0.0952902429123195128072041974875966845413247382469590227;
        weights[13] = 0.0977433353863287250934740109789967038357287886760951145;
        weights[14] = 0.0992250112266723078748755144286150140175432199555630698;
        weights[15] = 0.0997205447934264514275338337343494396432534115002043515;
        weights[16] = 0.0992250112266723078748755144286150140175432199555630698;
        weights[17] = 0.0977433353863287250934740109789967038357287886760951145;
        weights[18] = 0.0952902429123195128072041974875966845413247382469590227;
        weights[19] = 0.0918901138936414782153628716071501254973108253791578042;
        weights[20] = 0.0875767406084778761261980696953330922292581597712042515;
        weights[21] = 0.0823929917615892639038233674319617706157682665566462778;
        weights[22] = 0.0763903865987766164263576749013306449257569136942086541;
        weights[23] = 0.0696285832354103661677561262551257105150857073973433937;
        weights[24] = 0.0621747865610284269103435436866966671587287993646513153;
        weights[25] = 0.0541030824249168537116662590866200427203894625962118077;
        weights[26] = 0.0454937075272011029023158578946296772635527193100289649;
        weights[27] = 0.0364322739123854640243920104678034423271453320476676859;
        weights[28] = 0.0270090191849794218006087080919321561423566460021166459;
        weights[29] = 0.0173186207903105824631579960868211413662728627679957766;
        weights[30] = 0.0074708315792487758586968750322124070221508524840480397;
        return;
    case 32:
        points[0] = -0.997263861849481563544981128665040727138537663729461159;
        points[1] = -0.985611511545268335400175044630901978632395714335806318;
        points[2] = -0.964762255587506430773811928118274960388895220443018719;
        points[3] = -0.934906075937739689170919134835409325528671432282837218;
        points[4] = -0.896321155766052123965307243719212268478996496795759577;
        points[5] = -0.849367613732569970133693004967742538954886793049759233;
        points[6] = -0.794483795967942406963097298970428902095479401638835453;
        points[7] = -0.732182118740289680387426665091267146630270483506629101;
        points[8] = -0.663044266930215200975115168663238368977022285960505301;
        points[9] = -0.587715757240762329040745476401826858450940115454420573;
        points[10] = -0.506899908932229390023747474377821230180283699599435464;
        points[11] = -0.421351276130635345364119436172426478335877288632443331;
        points[12] = -0.331868602282127649779916805730187996195775136805059836;
        points[13] = -0.239287362252137074544603209165501520608855421960253016;
        points[14] = -0.144471961582796493485186373598810652203845991315635552;
        points[15] = -0.0483076656877383162348125704405021636908472517308488972;
        points[16] = 0.0483076656877383162348125704405021636908472517308488972;
        points[17] = 0.144471961582796493485186373598810652203845991315635552;
        points[18] = 0.239287362252137074544603209165501520608855421960253016;
        points[19] = 0.331868602282127649779916805730187996195775136805059836;
        points[20] = 0.421351276130635345364119436172426478335877288632443331;
        points[21] = 0.506899908932229390023747474377821230180283699599435464;
        points[22] = 0.587715757240762329040745476401826858450940115454420573;
        points[23] = 0.663044266930215200975115168663238368977022285960505301;
        points[24] = 0.732182118740289680387426665091267146630270483506629101;
        points[25] = 0.794483795967942406963097298970428902095479401638835453;
        points[26] = 0.849367613732569970133693004967742538954886793049759233;
        points[27] = 0.896321155766052123965307243719212268478996496795759577;
        points[28] = 0.934906075937739689170919134835409325528671432282837218;
        points[29] = 0.964762255587506430773811928118274960388895220443018719;
        points[30] = 0.985611511545268335400175044630901978632395714335806318;
        points[31] = 0.997263861849481563544981128665040727138537663729461159;
        weights[0] = 0.00701861000947009660040706373885318251337722072893960323;
        weights[1] = 0.0162743947309056706051705622063866181795429637952095664;
        weights[2] = 0.0253920653092620594557525897892240292875540475469487209;
        weights[3] = 0.0342738629130214331026877322523727069948402029116274338;
        weights[4] = 0.0428358980222266806568786466061255284928108575989407396;
        weights[5] = 0.0509980592623761761961632446895216952601847767397628437;
        weights[6] = 0.0586840934785355471452836373001708867501204674575467587;
        weights[7] = 0.0658222227763618468376500637069387728775364473732465154;
        weights[8] = 0.0723457941088485062253993564784877916043369833018248707;
        weights[9] = 0.0781938957870703064717409188283066710397867984821591903;
        weights[10] = 0.0833119242269467552221990746043486115387468839428344598;
        weights[11] = 0.0876520930044038111427714627518022875484497217017572223;
        weights[12] = 0.0911738786957638847128685771116370625448614132753900053;
        weights[13] = 0.0938443990808045656391802376681172600361000757462364501;
        weights[14] = 0.095638720079274859419082002204131100594890508162005551;
        weights[15] = 0.0965400885147278005667648300635757947368606312355700687;
        weights[16] = 0.0965400885147278005667648300635757947368606312355700687;
        weights[17] = 0.095638720079274859419082002204131100594890508162005551;
        weights[18] = 0.0938443990808045656391802376681172600361000757462364501;
        weights[19] = 0.0911738786957638847128685771116370625448614132753900053;
        weights[20] = 0.0876520930044038111427714627518022875484497217017572223;
        weights[21] = 0.0833119242269467552221990746043486115387468839428344598;
        weights[22] = 0.0781938957870703064717409188283066710397867984821591903;
        weights[23] = 0.0723457941088485062253993564784877916043369833018248707;
        weights[24] = 0.0658222227763618468376500637069387728775364473732465154;
        weights[25] = 0.0586840934785355471452836373001708867501204674575467587;
        weights[26] = 0.0509980592623761761961632446895216952601847767397628437;
        weights[27] = 0.0428358980222266806568786466061255284928108575989407396;
        weights[28] = 0.0342738629130214331026877322523727069948402029116274338;
        weights[29] = 0.0253920653092620594557525897892240292875540475469487209;
        weights[30] = 0.0162743947309056706051705622063866181795429637952095664;
        weights[31] = 0.00701861000947009660040706373885318251337722072893960323;
        return;
    case 33:
        points[0] = -0.997424694246455217266168017580404161078229010881361921;
        points[1] = -0.9864557262306424881103756982646259215891711142156511;
        points[2] = -0.9668229096899927689283777066785922452183143365799866;
        points[3] = -0.938694372611168350355835124363553712614434484096546826;
        points[4] = -0.902316767743433583040531331518761607475205558190918115;
        points[5] = -0.858009652676504064643061480146068473327351068896720066;
        points[6] = -0.806162356274166589796200870782777175697710618135446112;
        points[7] = -0.747230496449562157859055124897948268854288086463824479;
        points[8] = -0.681731959969742786268215946919328134668935180714294029;
        points[9] = -0.610242345836379027307287513538097431406342930888033949;
        points[10] = -0.533389904786347643548894264995492125452665092224422469;
        points[11] = -0.451850017272450695725993277240767053798771734390531177;
        points[12] = -0.366339257748073341070220623253871111296934681100140172;
        points[13] = -0.277609097152497029403248067298321005754758329278243219;
        points[14] = -0.186439298827991572335798759218823987837344302823165342;
        points[15] = -0.0936310658547333856707429241225377213215057781526368813;
        points[16] = 0;
        points[17] = 0.0936310658547333856707429241225377213215057781526368813;
        points[18] = 0.186439298827991572335798759218823987837344302823165342;
        points[19] = 0.277609097152497029403248067298321005754758329278243219;
        points[20] = 0.366339257748073341070220623253871111296934681100140172;
        points[21] = 0.451850017272450695725993277240767053798771734390531177;
        points[22] = 0.533389904786347643548894264995492125452665092224422469;
        points[23] = 0.610242345836379027307287513538097431406342930888033949;
        points[24] = 0.681731959969742786268215946919328134668935180714294029;
        points[25] = 0.747230496449562157859055124897948268854288086463824479;
        points[26] = 0.806162356274166589796200870782777175697710618135446112;
        points[27] = 0.858009652676504064643061480146068473327351068896720066;
        points[28] = 0.902316767743433583040531331518761607475205558190918115;
        points[29] = 0.938694372611168350355835124363553712614434484096546826;
        points[30] = 0.9668229096899927689283777066785922452183143365799866;
        points[31] = 0.9864557262306424881103756982646259215891711142156511;
        points[32] = 0.997424694246455217266168017580404161078229010881361921;
        weights[0] = 0.00660622784758737805864923520847385503105916250321107135;
        weights[1] = 0.0153217015129346761279457685336618667575353547807562368;
        weights[2] = 0.0239155481017494803505332575291862420660083611445149192;
        weights[3] = 0.0323003586323289532815614472494312880682527230506729272;
        weights[4] = 0.0404015413316695915634097905273984961668627883826539169;
        weights[5] = 0.0481477428187116956701468801381196497417511486769690613;
        weights[6] = 0.0554708466316635612849444954392591104205084071502204403;
        weights[7] = 0.0623064825303174800316277257708976114217684275793131068;
        weights[8] = 0.0685945728186567128059550730149586524873610929403886977;
        weights[9] = 0.0742798548439541493424721759184720467100983931962553235;
        weights[10] = 0.0793123647948867383639083849419975880886880293922986427;
        weights[11] = 0.0836478760670387076139280145176605974203276865458260165;
        weights[12] = 0.0872482876188443376072816709454464565666960712939022884;
        weights[13] = 0.090081958660638577239743705500223621187370682079491485;
        weights[14] = 0.0921239866433168462132409777173630607214710032039817206;
        weights[15] = 0.093356426065596116160999126274275464952003986088630805;
        weights[16] = 0.0937684461602099965673045415463487843844733639818266813;
        weights[17] = 0.093356426065596116160999126274275464952003986088630805;
        weights[18] = 0.0921239866433168462132409777173630607214710032039817206;
        weights[19] = 0.090081958660638577239743705500223621187370682079491485;
        weights[20] = 0.0872482876188443376072816709454464565666960712939022884;
        weights[21] = 0.0836478760670387076139280145176605974203276865458260165;
        weights[22] = 0.0793123647948867383639083849419975880886880293922986427;
        weights[23] = 0.0742798548439541493424721759184720467100983931962553235;
        weights[24] = 0.0685945728186567128059550730149586524873610929403886977;
        weights[25] = 0.0623064825303174800316277257708976114217684275793131068;
        weights[26] = 0.0554708466316635612849444954392591104205084071502204403;
        weights[27] = 0.0481477428187116956701468801381196497417511486769690613;
        weights[28] = 0.0404015413316695915634097905273984961668627883826539169;
        weights[29] = 0.0323003586323289532815614472494312880682527230506729272;
        weights[30] = 0.0239155481017494803505332575291862420660083611445149192;
        weights[31] = 0.0153217015129346761279457685336618667575353547807562368;
        weights[32] = 0.00660622784758737805864923520847385503105916250321107135;
        return;
    case 34:
        points[0] = -0.997571753790841919243372437454629231400509882684929773;
        points[1] = -0.987227816406309485049750431099684972948770148660132219;
        points[2] = -0.968708262533344281764646573055993510967808745353473336;
        points[3] = -0.942162397405107091631676025460572903006205692337117558;
        points[4] = -0.907809677718324468800899889019287460162397572803152094;
        points[5] = -0.865934638334564469263572090671299844696635301736783069;
        points[6] = -0.816884227900933664591578906586973258393149910974253902;
        points[7] = -0.761064876629873014187408968978736833604499366726196922;
        points[8] = -0.69893911321626290793300010657577718263776403145575631;
        points[9] = -0.631021727080528545317775755519008277810897254073443531;
        points[10] = -0.557875500669746642736459886216274581337441378045353895;
        points[11] = -0.480106545190327034194102680507397108587354948903905784;
        points[12] = -0.398359277758645940631494752932351529342462129655648215;
        points[13] = -0.313311081339463247458316765650977994771229865584492941;
        points[14] = -0.225666691616449483868641180934347244352189721047980553;
        points[15] = -0.136152357259182975894428824331117831497280617764536282;
        points[16] = -0.045509821953102542749075670851930163831084150187205402;
        points[17] = 0.045509821953102542749075670851930163831084150187205402;
        points[18] = 0.136152357259182975894428824331117831497280617764536282;
        points[19] = 0.225666691616449483868641180934347244352189721047980553;
        points[20] = 0.313311081339463247458316765650977994771229865584492941;
        points[21] = 0.398359277758645940631494752932351529342462129655648215;
        points[22] = 0.480106545190327034194102680507397108587354948903905784;
        points[23] = 0.557875500669746642736459886216274581337441378045353895;
        points[24] = 0.631021727080528545317775755519008277810897254073443531;
        points[25] = 0.69893911321626290793300010657577718263776403145575631;
        points[26] = 0.761064876629873014187408968978736833604499366726196922;
        points[27] = 0.816884227900933664591578906586973258393149910974253902;
        points[28] = 0.865934638334564469263572090671299844696635301736783069;
        points[29] = 0.907809677718324468800899889019287460162397572803152094;
        points[30] = 0.942162397405107091631676025460572903006205692337117558;
        points[31] = 0.968708262533344281764646573055993510967808745353473336;
        points[32] = 0.987227816406309485049750431099684972948770148660132219;
        points[33] = 0.997571753790841919243372437454629231400509882684929773;
        weights[0] = 0.00622914055590868471860646107143778612452732842980484594;
        weights[1] = 0.0144501627485950354152022103287469906875404335846560601;
        weights[2] = 0.0225637219854949700840940887149542612490345883881878338;
        weights[3] = 0.0304913806384461318094423876813175910306268453895807875;
        weights[4] = 0.0381665937963875163217659202899765588239470061266673516;
        weights[5] = 0.0455256115233532724538225633952706029982384189963153821;
        weights[6] = 0.0525074145726781061682459748424675996587196809469698659;
        weights[7] = 0.059054135827524493193960972350526190828486182346504483;
        weights[8] = 0.0651115215540764113785444300648937735836372460728131919;
        weights[9] = 0.0706293758142557249990387965676853550011627204909059651;
        weights[10] = 0.0755619746600319312708339742284357240588192694813414625;
        weights[11] = 0.0798684443397718447388188328064379935505558719721942996;
        weights[12] = 0.0835130996998456551870202280461493905807155938575466916;
        weights[13] = 0.0864657397470357497842468562807475803140706909018175725;
        weights[14] = 0.088701897835693869287076457364880712744283006703804131;
        weights[15] = 0.0902030443706407295739422420174939288410295000506306357;
        weights[16] = 0.0909567403302598736153376039485779599246056162602594401;
        weights[17] = 0.0909567403302598736153376039485779599246056162602594401;
        weights[18] = 0.0902030443706407295739422420174939288410295000506306357;
        weights[19] = 0.088701897835693869287076457364880712744283006703804131;
        weights[20] = 0.0864657397470357497842468562807475803140706909018175725;
        weights[21] = 0.0835130996998456551870202280461493905807155938575466916;
        weights[22] = 0.0798684443397718447388188328064379935505558719721942996;
        weights[23] = 0.0755619746600319312708339742284357240588192694813414625;
        weights[24] = 0.0706293758142557249990387965676853550011627204909059651;
        weights[25] = 0.0651115215540764113785444300648937735836372460728131919;
        weights[26] = 0.059054135827524493193960972350526190828486182346504483;
        weights[27] = 0.0525074145726781061682459748424675996587196809469698659;
        weights[28] = 0.0455256115233532724538225633952706029982384189963153821;
        weights[29] = 0.0381665937963875163217659202899765588239470061266673516;
        weights[30] = 0.0304913806384461318094423876813175910306268453895807875;
        weights[31] = 0.0225637219854949700840940887149542612490345883881878338;
        weights[32] = 0.0144501627485950354152022103287469906875404335846560601;
        weights[33] = 0.00622914055590868471860646107143778612452732842980484594;
        return;
    case 35:
        points[0] = -0.997706569099600297260163139312094725193274637171013317;
        points[1] = -0.987935764443851498035117089185485985313008295714174355;
        points[2] = -0.970437616039229833215070482584770142524881239312376607;
        points[3] = -0.945345148207827329538725985529974644862811251247873154;
        points[4] = -0.912854261359317614464937063555764230488061013625558005;
        points[5] = -0.873219125025222331523282349141385266644338902279374947;
        points[6] = -0.826749899092225406834050612748557579046890617982307341;
        points[7] = -0.773810252286912555267423009209887481011810072971545926;
        points[8] = -0.714814501556628783264408631224446746962043968521730512;
        points[9] = -0.650224364665890388675792808984559263369762325928374001;
        points[10] = -0.580545344749764509934502008189690070932070203564332434;
        points[11] = -0.506322773241488615024297555837327376586087938636369248;
        points[12] = -0.428137541517814254187620613001479858784718446488533844;
        points[13] = -0.346601554430813945876979834930238231808408769377292109;
        points[14] = -0.262352941209296057970895200455580513486304398645781284;
        points[15] = -0.176051061165989569974303656445059929675429712329757047;
        points[16] = -0.0883713432756592636009294334975488034241174347650981414;
        points[17] = 0;
        points[18] = 0.0883713432756592636009294334975488034241174347650981414;
        points[19] = 0.176051061165989569974303656445059929675429712329757047;
        points[20] = 0.262352941209296057970895200455580513486304398645781284;
        points[21] = 0.346601554430813945876979834930238231808408769377292109;
        points[22] = 0.428137541517814254187620613001479858784718446488533844;
        points[23] = 0.506322773241488615024297555837327376586087938636369248;
        points[24] = 0.580545344749764509934502008189690070932070203564332434;
        points[25] = 0.650224364665890388675792808984559263369762325928374001;
        points[26] = 0.714814501556628783264408631224446746962043968521730512;
        points[27] = 0.773810252286912555267423009209887481011810072971545926;
        points[28] = 0.826749899092225406834050612748557579046890617982307341;
        points[29] = 0.873219125025222331523282349141385266644338902279374947;
        points[30] = 0.912854261359317614464937063555764230488061013625558005;
        points[31] = 0.945345148207827329538725985529974644862811251247873154;
        points[32] = 0.970437616039229833215070482584770142524881239312376607;
        points[33] = 0.987935764443851498035117089185485985313008295714174355;
        points[34] = 0.997706569099600297260163139312094725193274637171013317;
        weights[0] = 0.00588343342044308497575389624011262403075431779823297371;
        weights[1] = 0.013650828348361492266404002920516383973994037841424921;
        weights[2] = 0.0213229799114835808834379839662050783238096447199362073;
        weights[3] = 0.0288292601088942540487160397144849162615277266295949997;
        weights[4] = 0.0361101158634633805327169696475499383085357789699869432;
        weights[5] = 0.0431084223261702187823064593749082034228065871639902087;
        weights[6] = 0.0497693704013535298051996760849949585944949531945731637;
        weights[7] = 0.0560408162123701285783277471651009644403485349045563455;
        weights[8] = 0.0618736719660801888870141387886886522653712258040964351;
        weights[9] = 0.0672222852690869039643055087481485585470931191496048085;
        weights[10] = 0.0720447947725600646654619097852777561472673930274272606;
        weights[11] = 0.0763034571554420535386585378842262255270800818956365344;
        weights[12] = 0.0799649422423242629326620809850457563288354994300888474;
        weights[13] = 0.08300059372885658837992652821617700348517450381345112;
        weights[14] = 0.0853866533920991252259439873911175676411909882837507511;
        weights[15] = 0.0871044469971835342433220316055409366850567150938549314;
        weights[16] = 0.0881405304302754629707388075930966414254543172744908372;
        weights[17] = 0.0884867949071042906382073877776156691824091500106054233;
        weights[18] = 0.0881405304302754629707388075930966414254543172744908372;
        weights[19] = 0.0871044469971835342433220316055409366850567150938549314;
        weights[20] = 0.0853866533920991252259439873911175676411909882837507511;
        weights[21] = 0.08300059372885658837992652821617700348517450381345112;
        weights[22] = 0.0799649422423242629326620809850457563288354994300888474;
        weights[23] = 0.0763034571554420535386585378842262255270800818956365344;
        weights[24] = 0.0720447947725600646654619097852777561472673930274272606;
        weights[25] = 0.0672222852690869039643055087481485585470931191496048085;
        weights[26] = 0.0618736719660801888870141387886886522653712258040964351;
        weights[27] = 0.0560408162123701285783277471651009644403485349045563455;
        weights[28] = 0.0497693704013535298051996760849949585944949531945731637;
        weights[29] = 0.0431084223261702187823064593749082034228065871639902087;
        weights[30] = 0.0361101158634633805327169696475499383085357789699869432;
        weights[31] = 0.0288292601088942540487160397144849162615277266295949997;
        weights[32] = 0.0213229799114835808834379839662050783238096447199362073;
        weights[33] = 0.013650828348361492266404002920516383973994037841424921;
        weights[34] = 0.00588343342044308497575389624011262403075431779823297371;
        return;
    case 36:
        points[0] = -0.997830462484085836198828345580750238649816462396631313;
        points[1] = -0.988586478902212238073395107877107446607162520065287056;
        points[2] = -0.972027691049697949335605048431108327616046396265951741;
        points[3] = -0.948272984399507545202474114945227846289376525333673633;
        points[4] = -0.917497774515659066075867223026156399936909467813654856;
        points[5] = -0.879929800890397131982427337465835588773292842080756928;
        points[6] = -0.835847166992475306418820872498600653346779379392325144;
        points[7] = -0.785576230132206512827768965080292603302330505839601361;
        points[8] = -0.729489171593556582090260479006108985565843046905197004;
        points[9] = -0.668001236585521062097191344340917639164702490212637653;
        points[10] = -0.60156765813598053507994497507359475174295415598675191;
        points[11] = -0.530680285926245161640709080121569817661222872646822076;
        points[12] = -0.455863944433420267207217669327440925957842388296857473;
        points[13] = -0.377672547119689216322736389669907622166172804885287866;
        points[14] = -0.296684995344028270503239047745170452700241822959825327;
        points[15] = -0.213500892316865578943226228902713916758461731272768195;
        points[16] = -0.128736103809384788651993388005152301177289724599373134;
        points[17] = -0.0430181984737086072269689782283634345542947948060091898;
        points[18] = 0.0430181984737086072269689782283634345542947948060091898;
        points[19] = 0.128736103809384788651993388005152301177289724599373134;
        points[20] = 0.213500892316865578943226228902713916758461731272768195;
        points[21] = 0.296684995344028270503239047745170452700241822959825327;
        points[22] = 0.377672547119689216322736389669907622166172804885287866;
        points[23] = 0.455863944433420267207217669327440925957842388296857473;
        points[24] = 0.530680285926245161640709080121569817661222872646822076;
        points[25] = 0.60156765813598053507994497507359475174295415598675191;
        points[26] = 0.668001236585521062097191344340917639164702490212637653;
        points[27] = 0.729489171593556582090260479006108985565843046905197004;
        points[28] = 0.785576230132206512827768965080292603302330505839601361;
        points[29] = 0.835847166992475306418820872498600653346779379392325144;
        points[30] = 0.879929800890397131982427337465835588773292842080756928;
        points[31] = 0.917497774515659066075867223026156399936909467813654856;
        points[32] = 0.948272984399507545202474114945227846289376525333673633;
        points[33] = 0.972027691049697949335605048431108327616046396265951741;
        points[34] = 0.988586478902212238073395107877107446607162520065287056;
        points[35] = 0.997830462484085836198828345580750238649816462396631313;
        weights[0] = 0.00556571966424504536125598439054783741722459189417851018;
        weights[1] = 0.0129159472840655744045034114977916491919612128514796719;
        weights[2] = 0.0201815152977354715320989289582211274195865102408615653;
        weights[3] = 0.0272986214985687790944171808679833579904568281420508554;
        weights[4] = 0.0342138107703072299212450615627145540700969113267764835;
        weights[5] = 0.0408757509236448954741145451432631915479370611190781462;
        weights[6] = 0.0472350834902659784166168296166748320731517874343696303;
        weights[7] = 0.0532447139777599190920256282862196496889296110589429207;
        weights[8] = 0.0588601442453248173096753998189200359427540957825592892;
        weights[9] = 0.0640397973550154895563847986258563397460214705508407249;
        weights[10] = 0.0687453238357364426136896393636132083417307646421384912;
        weights[11] = 0.0729418850056530613538733769412742182869469526169905444;
        weights[12] = 0.0765984106458706745287577337215016417279275568319918338;
        weights[13] = 0.0796878289120716019087246655018639073275341575147260202;
        weights[14] = 0.082187266704339709517223473544942302864963072934622121;
        weights[15] = 0.0840782189796619349334576242915958212039359139576060455;
        weights[16] = 0.0853466857393386274918505430764897709987865854972912941;
        weights[17] = 0.0859832756703947474900851747905265541600549156034958523;
        weights[18] = 0.0859832756703947474900851747905265541600549156034958523;
        weights[19] = 0.0853466857393386274918505430764897709987865854972912941;
        weights[20] = 0.0840782189796619349334576242915958212039359139576060455;
        weights[21] = 0.082187266704339709517223473544942302864963072934622121;
        weights[22] = 0.0796878289120716019087246655018639073275341575147260202;
        weights[23] = 0.0765984106458706745287577337215016417279275568319918338;
        weights[24] = 0.0729418850056530613538733769412742182869469526169905444;
        weights[25] = 0.0687453238357364426136896393636132083417307646421384912;
        weights[26] = 0.0640397973550154895563847986258563397460214705508407249;
        weights[27] = 0.0588601442453248173096753998189200359427540957825592892;
        weights[28] = 0.0532447139777599190920256282862196496889296110589429207;
        weights[29] = 0.0472350834902659784166168296166748320731517874343696303;
        weights[30] = 0.0408757509236448954741145451432631915479370611190781462;
        weights[31] = 0.0342138107703072299212450615627145540700969113267764835;
        weights[32] = 0.0272986214985687790944171808679833579904568281420508554;
        weights[33] = 0.0201815152977354715320989289582211274195865102408615653;
        weights[34] = 0.0129159472840655744045034114977916491919612128514796719;
        weights[35] = 0.00556571966424504536125598439054783741722459189417851018;
        return;
    case 37:
        points[0] = -0.997944582477913648940803074317363283669007849486729154;
        points[1] = -0.98918596321431918668409906058427230896245291758067398;
        points[2] = -0.973493030056485744328890475665759344815384616708608268;
        points[3] = -0.950972343262094821328576096816325933997548579804577386;
        points[4] = -0.921781437412463742668143686700713488781595267162329661;
        points[5] = -0.886124962155486078946149509016886440106813234826896308;
        points[6] = -0.844252987340555967987456276174860231690634495897622184;
        points[7] = -0.796459200509902293393046335500324523485631158940521608;
        points[8] = -0.743078833981965262547047417473812879089901853263012602;
        points[9] = -0.684486309130959357445523212431153708044343810970077687;
        points[10] = -0.621092608408924483148152591595057310041726400604135159;
        points[11] = -0.553342391861581781235098358229264473472286552240982324;
        points[12] = -0.481710877803205554147192868882639171989522434347350396;
        points[13] = -0.4067005093183261101009315916139666085224712793505589;
        points[14] = -0.328837429883706999498471801339940483680022575292308038;
        points[15] = -0.248667792791365758805567751487716218531677651682945158;
        points[16] = -0.166753930239851976968671730411824437466648396031276349;
        points[17] = -0.0836704089547699019430483317363991775635216320351522936;
        points[18] = 0;
        points[19] = 0.0836704089547699019430483317363991775635216320351522936;
        points[20] = 0.166753930239851976968671730411824437466648396031276349;
        points[21] = 0.248667792791365758805567751487716218531677651682945158;
        points[22] = 0.328837429883706999498471801339940483680022575292308038;
        points[23] = 0.4067005093183261101009315916139666085224712793505589;
        points[24] = 0.481710877803205554147192868882639171989522434347350396;
        points[25] = 0.553342391861581781235098358229264473472286552240982324;
        points[26] = 0.621092608408924483148152591595057310041726400604135159;
        points[27] = 0.684486309130959357445523212431153708044343810970077687;
        points[28] = 0.743078833981965262547047417473812879089901853263012602;
        points[29] = 0.796459200509902293393046335500324523485631158940521608;
        points[30] = 0.844252987340555967987456276174860231690634495897622184;
        points[31] = 0.886124962155486078946149509016886440106813234826896308;
        points[32] = 0.921781437412463742668143686700713488781595267162329661;
        points[33] = 0.950972343262094821328576096816325933997548579804577386;
        points[34] = 0.973493030056485744328890475665759344815384616708608268;
        points[35] = 0.98918596321431918668409906058427230896245291758067398;
        points[36] = 0.997944582477913648940803074317363283669007849486729154;
        weights[0] = 0.00527305727949793935172205423353038918308830590652726543;
        weights[1] = 0.0122387801003075565263048524363465759422909531112660823;
        weights[2] = 0.0191290444890839660435019479401061741302952357462103257;
        weights[3] = 0.0258860369905589335227594813624872980294841825751032704;
        weights[4] = 0.0324616398475214810672342535014587287990945591225246664;
        weights[5] = 0.0388096025019345444889623703284760199673891892736854008;
        weights[6] = 0.044885364662437166657410304110196360194723306514413933;
        weights[7] = 0.0506462976548246016038758630867163440527057629453541097;
        weights[8] = 0.0560519879982749178085392396642526664267538552877670788;
        weights[9] = 0.0610645165232259861309881045004965856779940090623631049;
        weights[10] = 0.0656487228727512494840237662979712181966773211497249265;
        weights[11] = 0.0697724515557003448850813567930192911860236786977560874;
        weights[12] = 0.0734067772484881727246266315197954649834699421976482146;
        weights[13] = 0.0765262075705292378858879912066225154953633155315440516;
        weights[14] = 0.079108861837529380767212187396645238516006935064182366;
        weights[15] = 0.0811366245084650305098776017997922635664600449746249385;
        weights[16] = 0.0825952722364372508912303011528384707733064526020397682;
        weights[17] = 0.0834745736258627872522530094845186990204353102030260501;
        weights[18] = 0.0837683609931389047970173663694593917168752800684767192;
        weights[19] = 0.0834745736258627872522530094845186990204353102030260501;
        weights[20] = 0.0825952722364372508912303011528384707733064526020397682;
        weights[21] = 0.0811366245084650305098776017997922635664600449746249385;
        weights[22] = 0.079108861837529380767212187396645238516006935064182366;
        weights[23] = 0.0765262075705292378858879912066225154953633155315440516;
        weights[24] = 0.0734067772484881727246266315197954649834699421976482146;
        weights[25] = 0.0697724515557003448850813567930192911860236786977560874;
        weights[26] = 0.0656487228727512494840237662979712181966773211497249265;
        weights[27] = 0.0610645165232259861309881045004965856779940090623631049;
        weights[28] = 0.0560519879982749178085392396642526664267538552877670788;
        weights[29] = 0.0506462976548246016038758630867163440527057629453541097;
        weights[30] = 0.044885364662437166657410304110196360194723306514413933;
        weights[31] = 0.0388096025019345444889623703284760199673891892736854008;
        weights[32] = 0.0324616398475214810672342535014587287990945591225246664;
        weights[33] = 0.0258860369905589335227594813624872980294841825751032704;
        weights[34] = 0.0191290444890839660435019479401061741302952357462103257;
        weights[35] = 0.0122387801003075565263048524363465759422909531112660823;
        weights[36] = 0.00527305727949793935172205423353038918308830590652726543;
        return;
    case 38:
        points[0] = -0.99804993053568761981284707655158099749046537027458809;
        points[1] = -0.989739454266385571944425891105679347324381246908022206;
        points[2] = -0.974846328590153507640885540946388642591975358766073516;
        points[3] = -0.95346633093352959567054215311744121738577897072292871;
        points[4] = -0.925741332048584396825109562213050911480917876481105521;
        points[5] = -0.891855739004632216794937031973917511579899053234515361;
        points[6] = -0.852035021932362188859649711247276280440385037327630969;
        points[7] = -0.806544167605316815551565375979698325731772981329319621;
        points[8] = -0.755685903753970680737738096779387413503837570746703927;
        points[9] = -0.699798680379184355912825840627415875638207015300590438;
        points[10] = -0.639254415829681707180344869500260271701170395409661429;
        points[11] = -0.574456021047807081132927500924472510210199597853798765;
        points[12] = -0.505834717927931103240533716467652002793846550637187645;
        points[13] = -0.433847169432376484373256162517842204005923800406839124;
        points[14] = -0.358972440479435013256717621456534291796062949211368074;
        points[15] = -0.281708809790165261360114071418700076769670508783611332;
        points[16] = -0.202570453892116703203977781514607057371655085753703517;
        points[17] = -0.122084025337867419869612381329407116568118141499300009;
        points[18] = -0.0407851479045782399133164323297849207847736426836548117;
        points[19] = 0.0407851479045782399133164323297849207847736426836548117;
        points[20] = 0.122084025337867419869612381329407116568118141499300009;
        points[21] = 0.202570453892116703203977781514607057371655085753703517;
        points[22] = 0.281708809790165261360114071418700076769670508783611332;
        points[23] = 0.358972440479435013256717621456534291796062949211368074;
        points[24] = 0.433847169432376484373256162517842204005923800406839124;
        points[25] = 0.505834717927931103240533716467652002793846550637187645;
        points[26] = 0.574456021047807081132927500924472510210199597853798765;
        points[27] = 0.639254415829681707180344869500260271701170395409661429;
        points[28] = 0.699798680379184355912825840627415875638207015300590438;
        points[29] = 0.755685903753970680737738096779387413503837570746703927;
        points[30] = 0.806544167605316815551565375979698325731772981329319621;
        points[31] = 0.852035021932362188859649711247276280440385037327630969;
        points[32] = 0.891855739004632216794937031973917511579899053234515361;
        points[33] = 0.925741332048584396825109562213050911480917876481105521;
        points[34] = 0.95346633093352959567054215311744121738577897072292871;
        points[35] = 0.974846328590153507640885540946388642591975358766073516;
        points[36] = 0.989739454266385571944425891105679347324381246908022206;
        points[37] = 0.99804993053568761981284707655158099749046537027458809;
        weights[0] = 0.00500288074963934567589954209189937046383927186262170591;
        weights[1] = 0.0116134447164686741776683012004374273572367478601123297;
        weights[2] = 0.0181565777096132368988761257547822022629123390397971224;
        weights[3] = 0.0245797397382323758952012054467062874459591622272020467;
        weights[4] = 0.0308395005451750546587310863133086889204118954971985188;
        weights[5] = 0.03689408159402473816494016233681495034735611724058349;
        weights[6] = 0.0427031585046744342358784343588077086784174845681521442;
        weights[7] = 0.0482280618607586833743521799114202241893610027852761323;
        weights[8] = 0.0534320199103323199737569906312487560769153103387560856;
        weights[9] = 0.0582803991469972060223058682581400559151277021585559865;
        weights[10] = 0.0627409333921330540529696715251370643209038889969087583;
        weights[11] = 0.0667839379791404119350461515290192599559521560352792417;
        weights[12] = 0.0703825070668989547392829675936588408392617017624612065;
        weights[13] = 0.0735126925847434571452064448483364785766371950924317554;
        weights[14] = 0.0761536635484463960659935411044725279963452188325545188;
        weights[15] = 0.0782878446582109480753754033357362625649037448578418256;
        weights[16] = 0.079901033243527821586027683925185696550301239589681579;
        weights[17] = 0.0809824937705971006232694699490581419365151697840887541;
        weights[18] = 0.0815250292803857866992187698858300556016426514704967984;
        weights[19] = 0.0815250292803857866992187698858300556016426514704967984;
        weights[20] = 0.0809824937705971006232694699490581419365151697840887541;
        weights[21] = 0.079901033243527821586027683925185696550301239589681579;
        weights[22] = 0.0782878446582109480753754033357362625649037448578418256;
        weights[23] = 0.0761536635484463960659935411044725279963452188325545188;
        weights[24] = 0.0735126925847434571452064448483364785766371950924317554;
        weights[25] = 0.0703825070668989547392829675936588408392617017624612065;
        weights[26] = 0.0667839379791404119350461515290192599559521560352792417;
        weights[27] = 0.0627409333921330540529696715251370643209038889969087583;
        weights[28] = 0.0582803991469972060223058682581400559151277021585559865;
        weights[29] = 0.0534320199103323199737569906312487560769153103387560856;
        weights[30] = 0.0482280618607586833743521799114202241893610027852761323;
        weights[31] = 0.0427031585046744342358784343588077086784174845681521442;
        weights[32] = 0.03689408159402473816494016233681495034735611724058349;
        weights[33] = 0.0308395005451750546587310863133086889204118954971985188;
        weights[34] = 0.0245797397382323758952012054467062874459591622272020467;
        weights[35] = 0.0181565777096132368988761257547822022629123390397971224;
        weights[36] = 0.0116134447164686741776683012004374273572367478601123297;
        weights[37] = 0.00500288074963934567589954209189937046383927186262170591;
        return;
    case 39:
        points[0] = -0.998147383066432906005472302851820441832009740049664212;
        points[1] = -0.990251536854685983639775117247078204709693821040191796;
        points[2] = -0.976098709333471053844850319889518494290747412680101703;
        points[3] = -0.955775212324652277110891897191082203001771790638876136;
        points[4] = -0.929409148486738229697816964357734561844102809507703527;
        points[5] = -0.897167119292992887848291090860813651065692077975623002;
        points[6] = -0.859252937999906153913797439126042370535084445319822061;
        points[7] = -0.815906297430143104353232678409629827727814060520923857;
        points[8] = -0.767401242931063499832272404228342945472834113459010662;
        points[9] = -0.714044435894534679133867036151830789664345281893698215;
        points[10] = -0.656173213432010910734425934976256184880107611576970431;
        points[11] = -0.594153454957277988692890074619106068165591544678126535;
        points[12] = -0.528377268660437473896343635808222505340717653485424776;
        points[13] = -0.459260512309136048663246633109572362938749153696017238;
        points[14] = -0.387240163971561455853881965636962696012576172716826616;
        points[15] = -0.31277155924818592253599691178562873960190560997753935;
        points[16] = -0.236325512461835767336006327332650448065719224794057596;
        points[17] = -0.15838533999783779992270106136139938446682623686514314;
        points[18] = -0.0794438046087554775819170831926406468850031651067419333;
        points[19] = 0;
        points[20] = 0.0794438046087554775819170831926406468850031651067419333;
        points[21] = 0.15838533999783779992270106136139938446682623686514314;
        points[22] = 0.236325512461835767336006327332650448065719224794057596;
        points[23] = 0.31277155924818592253599691178562873960190560997753935;
        points[24] = 0.387240163971561455853881965636962696012576172716826616;
        points[25] = 0.459260512309136048663246633109572362938749153696017238;
        points[26] = 0.528377268660437473896343635808222505340717653485424776;
        points[27] = 0.594153454957277988692890074619106068165591544678126535;
        points[28] = 0.656173213432010910734425934976256184880107611576970431;
        points[29] = 0.714044435894534679133867036151830789664345281893698215;
        points[30] = 0.767401242931063499832272404228342945472834113459010662;
        points[31] = 0.815906297430143104353232678409629827727814060520923857;
        points[32] = 0.859252937999906153913797439126042370535084445319822061;
        points[33] = 0.897167119292992887848291090860813651065692077975623002;
        points[34] = 0.929409148486738229697816964357734561844102809507703527;
        points[35] = 0.955775212324652277110891897191082203001771790638876136;
        points[36] = 0.976098709333471053844850319889518494290747412680101703;
        points[37] = 0.990251536854685983639775117247078204709693821040191796;
        points[38] = 0.998147383066432906005472302851820441832009740049664212;
        weights[0] = 0.00475294469163510137077621315490694198569508454183706144;
        weights[1] = 0.0110347889391645942426768054521772894535071393731181559;
        weights[2] = 0.0172562290937249190408054711833550472137159018904623154;
        weights[3] = 0.0233693848321781645947123444429246988911975554637566659;
        weights[4] = 0.0293349559839033785921559863562514256114114671016045653;
        weights[5] = 0.0351151114981313307610651852972328163666614876197266856;
        weights[6] = 0.0406732768479338439390565560822614036875724359960629048;
        weights[7] = 0.0459743011089166318841766393992327805988616930339994639;
        weights[8] = 0.0509846652921294052140210336765813350176130838812849053;
        weights[9] = 0.0556726903409162999073911397896814827069609480735800684;
        weights[10] = 0.0600087360885961495749417735488194997366782270918463043;
        weights[11] = 0.0639653881386823889867064044100636448557769168899798797;
        weights[12] = 0.0675176309662312653630213280464485937751527080834770358;
        weights[13] = 0.0706430059706087607701149315281311364674296841590281693;
        weights[14] = 0.0733217534142686173811539328650483064478934242509751308;
        weights[15] = 0.0755369373228360577047844469908093990941879785900218443;
        weights[16] = 0.0772745525446820167285116367331172991204952514887911509;
        weights[17] = 0.0785236132873711767250633009855234715225814764092488609;
        weights[18] = 0.0792762225683684710101557717545079305238041486782664247;
        weights[19] = 0.0795276221394428524174181966058509938456067747658648143;
        weights[20] = 0.0792762225683684710101557717545079305238041486782664247;
        weights[21] = 0.0785236132873711767250633009855234715225814764092488609;
        weights[22] = 0.0772745525446820167285116367331172991204952514887911509;
        weights[23] = 0.0755369373228360577047844469908093990941879785900218443;
        weights[24] = 0.0733217534142686173811539328650483064478934242509751308;
        weights[25] = 0.0706430059706087607701149315281311364674296841590281693;
        weights[26] = 0.0675176309662312653630213280464485937751527080834770358;
        weights[27] = 0.0639653881386823889867064044100636448557769168899798797;
        weights[28] = 0.0600087360885961495749417735488194997366782270918463043;
        weights[29] = 0.0556726903409162999073911397896814827069609480735800684;
        weights[30] = 0.0509846652921294052140210336765813350176130838812849053;
        weights[31] = 0.0459743011089166318841766393992327805988616930339994639;
        weights[32] = 0.0406732768479338439390565560822614036875724359960629048;
        weights[33] = 0.0351151114981313307610651852972328163666614876197266856;
        weights[34] = 0.0293349559839033785921559863562514256114114671016045653;
        weights[35] = 0.0233693848321781645947123444429246988911975554637566659;
        weights[36] = 0.0172562290937249190408054711833550472137159018904623154;
        weights[37] = 0.0110347889391645942426768054521772894535071393731181559;
        weights[38] = 0.00475294469163510137077621315490694198569508454183706144;
        return;
    case 40:
        points[0] = -0.998237709710559200349622702420586492335770381595045907;
        points[1] = -0.990726238699457006453054352221372154962222081351086538;
        points[2] = -0.977259949983774262663370283712903806978667932037986096;
        points[3] = -0.957916819213791655804540999452759285094883490602747032;
        points[4] = -0.932812808278676533360852166845205716434753575282692449;
        points[5] = -0.902098806968874296728253330868493103584488081057669468;
        points[6] = -0.865959503212259503820781808354619963570546553011101649;
        points[7] = -0.8246122308333116631963202306660987739072403842429878;
        points[8] = -0.778305651426519387694971545506494848020691316126891794;
        points[9] = -0.727318255189927103280996451754930548557378673533328138;
        points[10] = -0.67195668461417954837935451496149410997032598138385115;
        points[11] = -0.612553889667980237952612450230694877380123781683149611;
        points[12] = -0.549467125095128202075931305529517970233975101595651465;
        points[13] = -0.483075801686178712908566574244823004599022395533114101;
        points[14] = -0.413779204371605001524879745803713682974099624052918238;
        points[15] = -0.341994090825758473007492481179194310066953620027325796;
        points[16] = -0.268152185007253681141184344808596183424804373236246981;
        points[17] = -0.192697580701371099715516852065149894814092021105208875;
        points[18] = -0.116084070675255208483451284408024113768728530854215949;
        points[19] = -0.0387724175060508219331934440246232946793646343831415992;
        points[20] = 0.0387724175060508219331934440246232946793646343831415992;
        points[21] = 0.116084070675255208483451284408024113768728530854215949;
        points[22] = 0.192697580701371099715516852065149894814092021105208875;
        points[23] = 0.268152185007253681141184344808596183424804373236246981;
        points[24] = 0.341994090825758473007492481179194310066953620027325796;
        points[25] = 0.413779204371605001524879745803713682974099624052918238;
        points[26] = 0.483075801686178712908566574244823004599022395533114101;
        points[27] = 0.549467125095128202075931305529517970233975101595651465;
        points[28] = 0.612553889667980237952612450230694877380123781683149611;
        points[29] = 0.67195668461417954837935451496149410997032598138385115;
        points[30] = 0.727318255189927103280996451754930548557378673533328138;
        points[31] = 0.778305651426519387694971545506494848020691316126891794;
        points[32] = 0.8246122308333116631963202306660987739072403842429878;
        points[33] = 0.865959503212259503820781808354619963570546553011101649;
        points[34] = 0.902098806968874296728253330868493103584488081057669468;
        points[35] = 0.932812808278676533360852166845205716434753575282692449;
        points[36] = 0.957916819213791655804540999452759285094883490602747032;
        points[37] = 0.977259949983774262663370283712903806978667932037986096;
        points[38] = 0.990726238699457006453054352221372154962222081351086538;
        points[39] = 0.998237709710559200349622702420586492335770381595045907;
        weights[0] = 0.0045212770985331912584717328781853327278311101997059907;
        weights[1] = 0.0104982845311528136147421710672796523767926213157967797;
        weights[2] = 0.016421058381907888712863484882363927292342293346957762;
        weights[3] = 0.0222458491941669572615043241842085732070331966793544279;
        weights[4] = 0.0279370069800234010984891575077210773025508620507663984;
        weights[5] = 0.0334601952825478473926781830864108489772417866537643504;
        weights[6] = 0.0387821679744720176399720312904461622534592112320258578;
        weights[7] = 0.0438709081856732719916746860417154958110068371702368898;
        weights[8] = 0.0486958076350722320614341604481463880678430273771197751;
        weights[9] = 0.0532278469839368243549964797722605045553211718220064508;
        weights[10] = 0.0574397690993915513666177309104259856001048358544536265;
        weights[11] = 0.061306242492928939166537996408398595902593763511174322;
        weights[12] = 0.0648040134566010380745545295667527300326929642084889064;
        weights[13] = 0.0679120458152339038256901082319239859841972383792859547;
        weights[14] = 0.0706116473912867796954836308552868323595591039955860973;
        weights[15] = 0.0728865823958040590605106834425178358575590809857986305;
        weights[16] = 0.0747231690579682642001893362613246731912029344203598217;
        weights[17] = 0.0761103619006262423715580759224948230125595538450711071;
        weights[18] = 0.0770398181642479655883075342838102485244397541639404155;
        weights[19] = 0.0775059479784248112637239629583263269636686527881064357;
        weights[20] = 0.0775059479784248112637239629583263269636686527881064357;
        weights[21] = 0.0770398181642479655883075342838102485244397541639404155;
        weights[22] = 0.0761103619006262423715580759224948230125595538450711071;
        weights[23] = 0.0747231690579682642001893362613246731912029344203598217;
        weights[24] = 0.0728865823958040590605106834425178358575590809857986305;
        weights[25] = 0.0706116473912867796954836308552868323595591039955860973;
        weights[26] = 0.0679120458152339038256901082319239859841972383792859547;
        weights[27] = 0.0648040134566010380745545295667527300326929642084889064;
        weights[28] = 0.061306242492928939166537996408398595902593763511174322;
        weights[29] = 0.0574397690993915513666177309104259856001048358544536265;
        weights[30] = 0.0532278469839368243549964797722605045553211718220064508;
        weights[31] = 0.0486958076350722320614341604481463880678430273771197751;
        weights[32] = 0.0438709081856732719916746860417154958110068371702368898;
        weights[33] = 0.0387821679744720176399720312904461622534592112320258578;
        weights[34] = 0.0334601952825478473926781830864108489772417866537643504;
        weights[35] = 0.0279370069800234010984891575077210773025508620507663984;
        weights[36] = 0.0222458491941669572615043241842085732070331966793544279;
        weights[37] = 0.016421058381907888712863484882363927292342293346957762;
        weights[38] = 0.0104982845311528136147421710672796523767926213157967797;
        weights[39] = 0.0045212770985331912584717328781853327278311101997059907;
        return;
    case 41:
        points[0] = -0.998321588574771441519188508088377567931504351513670166;
        points[1] = -0.991167109699016308250158894573169657692756013570003047;
        points[2] = -0.978338673561083384469170706673967198375636781918654282;
        points[3] = -0.959906891730346226099441696068686582066951090829466351;
        points[4] = -0.935976987497853825682318275284766266271237118087344775;
        points[5] = -0.906685944758101172958340413230722973354307185322284854;
        points[6] = -0.872201511692441408833670574234329460282042655539533002;
        points[7] = -0.832721200401361331244272779048543799976975992978582133;
        points[8] = -0.78847114504740937273622178146677028899471207909872721;
        points[9] = -0.739704803069926181060168744468559000395254439052568965;
        points[10] = -0.686701502034951289584603856529134812066438460149673129;
        points[11] = -0.629764839072196320488649091695103501078514780739470874;
        points[12] = -0.569220941610215869654747215282980251610456923979545244;
        points[13] = -0.505416599199406032708336070202694764951075546015180246;
        points[14] = -0.438717277051407088517119856728039248421785758759468643;
        points[15] = -0.369505022640481441428366913299935205624086971331876079;
        points[16] = -0.298176277341824865922982880478924304139955868446148526;
        points[17] = -0.225139605633422775605786256655472330299912420644243222;
        points[18] = -0.150813354863992163574377967884582375775630945329497831;
        points[19] = -0.0756232589891629969237661936512002674810506356066569488;
        points[20] = 0;
        points[21] = 0.0756232589891629969237661936512002674810506356066569488;
        points[22] = 0.150813354863992163574377967884582375775630945329497831;
        points[23] = 0.225139605633422775605786256655472330299912420644243222;
        points[24] = 0.298176277341824865922982880478924304139955868446148526;
        points[25] = 0.369505022640481441428366913299935205624086971331876079;
        points[26] = 0.438717277051407088517119856728039248421785758759468643;
        points[27] = 0.505416599199406032708336070202694764951075546015180246;
        points[28] = 0.569220941610215869654747215282980251610456923979545244;
        points[29] = 0.629764839072196320488649091695103501078514780739470874;
        points[30] = 0.686701502034951289584603856529134812066438460149673129;
        points[31] = 0.739704803069926181060168744468559000395254439052568965;
        points[32] = 0.78847114504740937273622178146677028899471207909872721;
        points[33] = 0.832721200401361331244272779048543799976975992978582133;
        points[34] = 0.872201511692441408833670574234329460282042655539533002;
        points[35] = 0.906685944758101172958340413230722973354307185322284854;
        points[36] = 0.935976987497853825682318275284766266271237118087344775;
        points[37] = 0.959906891730346226099441696068686582066951090829466351;
        points[38] = 0.978338673561083384469170706673967198375636781918654282;
        points[39] = 0.991167109699016308250158894573169657692756013570003047;
        points[40] = 0.998321588574771441519188508088377567931504351513670166;
        weights[0] = 0.00430614035816488768400447790465448618636220399530170482;
        weights[1] = 0.00999993877390594533849629662969883955022493577115020595;
        weights[2] = 0.0156449384078185885308268444795336774408178893696463564;
        weights[3] = 0.0212010633687795530756970334933766265717170543273583082;
        weights[4] = 0.026635899207110445467548575258713277044690492005248138;
        weights[5] = 0.0319182117316992817870669468571455437011877532975110126;
        weights[6] = 0.0370177167035079884352612515801606686062715463218675428;
        weights[7] = 0.0419051951959096894293402743110488379362663774320223833;
        weights[8] = 0.046552648369014342060756586864611423130990198580590185;
        weights[9] = 0.0509334542946174947811703571156886314208034467868703288;
        weights[10] = 0.0550225192425787418801468101714222699737753366053695905;
        weights[11] = 0.0587964209498719449911858533807342740008812386027269409;
        weights[12] = 0.0622335425809663164715734170833464854301598699449434294;
        weights[13] = 0.0653141964535274104361637126537963404198592367210681263;
        weights[14] = 0.0680207367608767667355332397262489282566991201385941654;
        weights[15] = 0.0703376606208174974816589899698814560012333801678102797;
        weights[16] = 0.0722516968610230733963463983487873548852947705248725489;
        weights[17] = 0.0737518820272234699392808183248486794779162804283396427;
        weights[18] = 0.0748296231762215518913050726335053229456830673780307176;
        weights[19] = 0.0754787470927158240272470626746167490736063609030627762;
        weights[20] = 0.0756955356472983723187799610763602558911188813952312331;
        weights[21] = 0.0754787470927158240272470626746167490736063609030627762;
        weights[22] = 0.0748296231762215518913050726335053229456830673780307176;
        weights[23] = 0.0737518820272234699392808183248486794779162804283396427;
        weights[24] = 0.0722516968610230733963463983487873548852947705248725489;
        weights[25] = 0.0703376606208174974816589899698814560012333801678102797;
        weights[26] = 0.0680207367608767667355332397262489282566991201385941654;
        weights[27] = 0.0653141964535274104361637126537963404198592367210681263;
        weights[28] = 0.0622335425809663164715734170833464854301598699449434294;
        weights[29] = 0.0587964209498719449911858533807342740008812386027269409;
        weights[30] = 0.0550225192425787418801468101714222699737753366053695905;
        weights[31] = 0.0509334542946174947811703571156886314208034467868703288;
        weights[32] = 0.046552648369014342060756586864611423130990198580590185;
        weights[33] = 0.0419051951959096894293402743110488379362663774320223833;
        weights[34] = 0.0370177167035079884352612515801606686062715463218675428;
        weights[35] = 0.0319182117316992817870669468571455437011877532975110126;
        weights[36] = 0.026635899207110445467548575258713277044690492005248138;
        weights[37] = 0.0212010633687795530756970334933766265717170543273583082;
        weights[38] = 0.0156449384078185885308268444795336774408178893696463564;
        weights[39] = 0.00999993877390594533849629662969883955022493577115020595;
        weights[40] = 0.00430614035816488768400447790465448618636220399530170482;
        return;
    case 42:
        points[0] = -0.998399618990062415022868126847050276177876083522781252;
        points[1] = -0.991577288340860919792361253280868833452693264737104018;
        points[2] = -0.979342508063748193708982566542856095586474980129062929;
        points[3] = -0.961759365338204488746927157853322681171721288914031999;
        points[4] = -0.938923557354988178533173433625591970251387818450171871;
        points[5] = -0.910959724904127452583847879208506542318900351339455604;
        points[6] = -0.878020569812172742711985103478623534062819716243918599;
        points[7] = -0.840285983261816900925439995086099817823398575193568357;
        points[8] = -0.797962053255487413232705952546376660132375511290654134;
        points[9] = -0.751279935689480489568472175914658655502564519829540925;
        points[10] = -0.700494590556171213741569929055465534300175941800093181;
        points[11] = -0.645883388869247833957496303718411701169086543840143865;
        points[12] = -0.587744597485109322840711345473995719905431304828001646;
        points[13] = -0.526395749931192287592867558791901461435739764929909929;
        points[14] = -0.462171912070421929759075029930635985109664908473608631;
        points[15] = -0.395423852042975057677093954594371980799178576486353488;
        points[16] = -0.326516124465411512197156589375465669058411470498584524;
        points[17] = -0.255825079342879083966414791018708448768766456465400955;
        points[18] = -0.1837368065648545508527556393807429409333239616225151;
        points[19] = -0.110645027208519868349122545002641004867344024483630807;
        points[20] = -0.0369489431653517758130959800375594266417084522492225313;
        points[21] = 0.0369489431653517758130959800375594266417084522492225313;
        points[22] = 0.110645027208519868349122545002641004867344024483630807;
        points[23] = 0.1837368065648545508527556393807429409333239616225151;
        points[24] = 0.255825079342879083966414791018708448768766456465400955;
        points[25] = 0.326516124465411512197156589375465669058411470498584524;
        points[26] = 0.395423852042975057677093954594371980799178576486353488;
        points[27] = 0.462171912070421929759075029930635985109664908473608631;
        points[28] = 0.526395749931192287592867558791901461435739764929909929;
        points[29] = 0.587744597485109322840711345473995719905431304828001646;
        points[30] = 0.645883388869247833957496303718411701169086543840143865;
        points[31] = 0.700494590556171213741569929055465534300175941800093181;
        points[32] = 0.751279935689480489568472175914658655502564519829540925;
        points[33] = 0.797962053255487413232705952546376660132375511290654134;
        points[34] = 0.840285983261816900925439995086099817823398575193568357;
        points[35] = 0.878020569812172742711985103478623534062819716243918599;
        points[36] = 0.910959724904127452583847879208506542318900351339455604;
        points[37] = 0.938923557354988178533173433625591970251387818450171871;
        points[38] = 0.961759365338204488746927157853322681171721288914031999;
        points[39] = 0.979342508063748193708982566542856095586474980129062929;
        points[40] = 0.991577288340860919792361253280868833452693264737104018;
        points[41] = 0.998399618990062415022868126847050276177876083522781252;
        weights[0] = 0.00410599860464908461060277949683596265701677337480229036;
        weights[1] = 0.00953622030174850241182010029269799818868479873501257251;
        weights[2] = 0.0149224436973574941446776781058657676200927474901078966;
        weights[3] = 0.0202278695690526447570557190793541850826714265524220962;
        weights[4] = 0.0254229595261130478867424429094308643861354103739789549;
        weights[5] = 0.0304792406996034683629047335233923977917696542444008948;
        weights[6] = 0.0353690710975921108326621811265075419057485217806414501;
        weights[7] = 0.0400657351806922617605961248300369345537337018657456151;
        weights[8] = 0.0445435777719658778743163659852342413185954660371275812;
        weights[9] = 0.048778140792803245027449363128402723921117696934226903;
        weights[10] = 0.0527462956991740703439425390440974770315659878271861196;
        weights[11] = 0.0564263693580183816464268551396956893988731585762885074;
        weights[12] = 0.0597982622275866543128315457535348515098534186959439095;
        weights[13] = 0.0628435580450025764093182513237798891527970439218897387;
        weights[14] = 0.0655456243649089789270051078517944256097822940857930823;
        weights[15] = 0.0678897033765219448553634022137663072661347346585931979;
        weights[16] = 0.0698629924925941597661547863814822044439273130474320937;
        weights[17] = 0.0714547142651709829218104441174621550225898638775037186;
        weights[18] = 0.07265617524380410488790576149253303127678368396842723;
        weights[19] = 0.0734608134534675282640282570543039387336557834504052394;
        weights[20] = 0.0738642342321728799963855611497914131284705205020709081;
        weights[21] = 0.0738642342321728799963855611497914131284705205020709081;
        weights[22] = 0.0734608134534675282640282570543039387336557834504052394;
        weights[23] = 0.07265617524380410488790576149253303127678368396842723;
        weights[24] = 0.0714547142651709829218104441174621550225898638775037186;
        weights[25] = 0.0698629924925941597661547863814822044439273130474320937;
        weights[26] = 0.0678897033765219448553634022137663072661347346585931979;
        weights[27] = 0.0655456243649089789270051078517944256097822940857930823;
        weights[28] = 0.0628435580450025764093182513237798891527970439218897387;
        weights[29] = 0.0597982622275866543128315457535348515098534186959439095;
        weights[30] = 0.0564263693580183816464268551396956893988731585762885074;
        weights[31] = 0.0527462956991740703439425390440974770315659878271861196;
        weights[32] = 0.048778140792803245027449363128402723921117696934226903;
        weights[33] = 0.0445435777719658778743163659852342413185954660371275812;
        weights[34] = 0.0400657351806922617605961248300369345537337018657456151;
        weights[35] = 0.0353690710975921108326621811265075419057485217806414501;
        weights[36] = 0.0304792406996034683629047335233923977917696542444008948;
        weights[37] = 0.0254229595261130478867424429094308643861354103739789549;
        weights[38] = 0.0202278695690526447570557190793541850826714265524220962;
        weights[39] = 0.0149224436973574941446776781058657676200927474901078966;
        weights[40] = 0.00953622030174850241182010029269799818868479873501257251;
        weights[41] = 0.00410599860464908461060277949683596265701677337480229036;
        return;
    case 43:
        points[0] = -0.998472332242507713517636187318392411962050717847609143;
        points[1] = -0.991959557593244146420718341329618016387053225958952728;
        points[2] = -0.980278220980255331505529382181136390180867596519573484;
        points[3] = -0.963486613014079993410194963574243939867618912278712546;
        points[4] = -0.941671956847637861818477390397938271466476089813827758;
        points[5] = -0.914947907206138729456102870799285616745780103108423057;
        points[6] = -0.883453765218616863337678011642167417862166694242451599;
        points[7] = -0.847353716209315048999086085821792517512596547477239884;
        points[8] = -0.806835964136938635279074740877512126060886243481752597;
        points[9] = -0.762111747194955121460328463029046187807595258685957756;
        points[10] = -0.713414235268957054851920877990904102642529167113636116;
        points[11] = -0.660997313751498133165134763741345394113156812534213293;
        points[12] = -0.605134259639600935725083071123955221438369807894527289;
        points[13] = -0.546116316660084719140405047179660836654854224124755803;
        points[14] = -0.484251176785734724069633434748513777993577081871723296;
        points[15] = -0.419861376029269252487279394560568026074988907714570948;
        points[16] = -0.353282612864303806645476364143467871780445030142565542;
        points[17] = -0.28486199803291362710572289483833793178587981775426117;
        points[18] = -0.214956244860518209014878381473674953737224286385453044;
        points[19] = -0.143929809510713310770299937610744688682788883471342648;
        points[20] = -0.0721529908745862354223272509555610948576552766606143055;
        points[21] = 0;
        points[22] = 0.0721529908745862354223272509555610948576552766606143055;
        points[23] = 0.143929809510713310770299937610744688682788883471342648;
        points[24] = 0.214956244860518209014878381473674953737224286385453044;
        points[25] = 0.28486199803291362710572289483833793178587981775426117;
        points[26] = 0.353282612864303806645476364143467871780445030142565542;
        points[27] = 0.419861376029269252487279394560568026074988907714570948;
        points[28] = 0.484251176785734724069633434748513777993577081871723296;
        points[29] = 0.546116316660084719140405047179660836654854224124755803;
        points[30] = 0.605134259639600935725083071123955221438369807894527289;
        points[31] = 0.660997313751498133165134763741345394113156812534213293;
        points[32] = 0.713414235268957054851920877990904102642529167113636116;
        points[33] = 0.762111747194955121460328463029046187807595258685957756;
        points[34] = 0.806835964136938635279074740877512126060886243481752597;
        points[35] = 0.847353716209315048999086085821792517512596547477239884;
        points[36] = 0.883453765218616863337678011642167417862166694242451599;
        points[37] = 0.914947907206138729456102870799285616745780103108423057;
        points[38] = 0.941671956847637861818477390397938271466476089813827758;
        points[39] = 0.963486613014079993410194963574243939867618912278712546;
        points[40] = 0.980278220980255331505529382181136390180867596519573484;
        points[41] = 0.991959557593244146420718341329618016387053225958952728;
        points[42] = 0.998472332242507713517636187318392411962050717847609143;
        weights[0] = 0.00391949025384412728296716519257643543366036457269087234;
        weights[1] = 0.00910399663740140331886860829589672381301797555982670408;
        weights[2] = 0.0142487564315764861085416017220041935720739931441623353;
        weights[3] = 0.0193199014236839003961246108920713523170235590882569686;
        weights[4] = 0.0242904566138388159020183242542492484552370393358121375;
        weights[5] = 0.029134413261498494915940424825781193787550569840192032;
        weights[6] = 0.0338264920868602923449684757538020910533016106471323669;
        weights[7] = 0.0383422221941326575721284246628491148800725628683971755;
        weights[8] = 0.0426580571979820837638072053385138941049470912367672507;
        weights[9] = 0.0467514947543465800106467663371029339328630959356638568;
        weights[10] = 0.050601192784390156523850398953014745749898009098012191;
        weights[11] = 0.0541870803188817868633731783262654135883905526707112847;
        weights[12] = 0.0574904619569105194276089168444165119278688681945654327;
        weights[13] = 0.0604941152499912945196787419913627933585088798704285874;
        weights[14] = 0.0631823804493961123256298177734082642566962346394688467;
        weights[15] = 0.0655412421263227974912337642492078302249625337784548263;
        weights[16] = 0.0675584022293651691924079047562655921429462925857296083;
        weights[17] = 0.0692233441936566842822994791226351478093049895709278238;
        weights[18] = 0.0705273877650850281262863554779407431837361667849641501;
        weights[19] = 0.0714637342525141412975811177029102485809000193677956732;
        weights[20] = 0.0720275019714219743453075516708570877535042459474147016;
        weights[21] = 0.072215751693798987977462331713736880147070690525250349;
        weights[22] = 0.0720275019714219743453075516708570877535042459474147016;
        weights[23] = 0.0714637342525141412975811177029102485809000193677956732;
        weights[24] = 0.0705273877650850281262863554779407431837361667849641501;
        weights[25] = 0.0692233441936566842822994791226351478093049895709278238;
        weights[26] = 0.0675584022293651691924079047562655921429462925857296083;
        weights[27] = 0.0655412421263227974912337642492078302249625337784548263;
        weights[28] = 0.0631823804493961123256298177734082642566962346394688467;
        weights[29] = 0.0604941152499912945196787419913627933585088798704285874;
        weights[30] = 0.0574904619569105194276089168444165119278688681945654327;
        weights[31] = 0.0541870803188817868633731783262654135883905526707112847;
        weights[32] = 0.050601192784390156523850398953014745749898009098012191;
        weights[33] = 0.0467514947543465800106467663371029339328630959356638568;
        weights[34] = 0.0426580571979820837638072053385138941049470912367672507;
        weights[35] = 0.0383422221941326575721284246628491148800725628683971755;
        weights[36] = 0.0338264920868602923449684757538020910533016106471323669;
        weights[37] = 0.029134413261498494915940424825781193787550569840192032;
        weights[38] = 0.0242904566138388159020183242542492484552370393358121375;
        weights[39] = 0.0193199014236839003961246108920713523170235590882569686;
        weights[40] = 0.0142487564315764861085416017220041935720739931441623353;
        weights[41] = 0.00910399663740140331886860829589672381301797555982670408;
        weights[42] = 0.00391949025384412728296716519257643543366036457269087234;
        return;
    case 44:
        points[0] = -0.998540200636774224936056720606650349056030033175414598;
        points[1] = -0.992316392138515808483338003613538568811897784352210077;
        points[2] = -0.98115183307791396666274900535048782880567555553965774;
        points[3] = -0.965099650422493139394398050580234974716877138589885093;
        points[4] = -0.944239509118194099203254653026989251072454934759922975;
        points[5] = -0.918675259984175774323001086694252048937985263045053006;
        points[6] = -0.8885342382860432023383679101903223247583324582094259;
        points[7] = -0.85396659500471037872830224129268389036116906202906845;
        points[8] = -0.815144539645135010487437635751940550299400574508594244;
        points[9] = -0.77226147924875589901775854923198801372809643956544711;
        points[10] = -0.72553105366071700260696493671995361101246580020809526;
        points[11] = -0.675186070666122365333699038563899923328255401123770875;
        points[12] = -0.621477345903575847802424699121766747144405880017163559;
        points[13] = -0.564672453185470768424636819382075219490745479604266115;
        points[14] = -0.505054391388202317982798352291177238612073295505348613;
        points[15] = -0.442920174525411483834826593647313549538478460308117949;
        points[16] = -0.378579352014707132511764672772197856742820848495670373;
        points[17] = -0.312352466502785812236545163572978535519263621753288636;
        points[18] = -0.244569456928201251507302434740518620530487259280049604;
        points[19] = -0.175568014775516785746507749380976590647374506724513315;
        points[20] = -0.105691901708653247117305848915121752383385998859597614;
        points[21] = -0.0352892369641353590581967046314163558850021975895270768;
        points[22] = 0.0352892369641353590581967046314163558850021975895270768;
        points[23] = 0.105691901708653247117305848915121752383385998859597614;
        points[24] = 0.175568014775516785746507749380976590647374506724513315;
        points[25] = 0.244569456928201251507302434740518620530487259280049604;
        points[26] = 0.312352466502785812236545163572978535519263621753288636;
        points[27] = 0.378579352014707132511764672772197856742820848495670373;
        points[28] = 0.442920174525411483834826593647313549538478460308117949;
        points[29] = 0.505054391388202317982798352291177238612073295505348613;
        points[30] = 0.564672453185470768424636819382075219490745479604266115;
        points[31] = 0.621477345903575847802424699121766747144405880017163559;
        points[32] = 0.675186070666122365333699038563899923328255401123770875;
        points[33] = 0.72553105366071700260696493671995361101246580020809526;
        points[34] = 0.77226147924875589901775854923198801372809643956544711;
        points[35] = 0.815144539645135010487437635751940550299400574508594244;
        points[36] = 0.85396659500471037872830224129268389036116906202906845;
        points[37] = 0.8885342382860432023383679101903223247583324582094259;
        points[38] = 0.918675259984175774323001086694252048937985263045053006;
        points[39] = 0.944239509118194099203254653026989251072454934759922975;
        points[40] = 0.965099650422493139394398050580234974716877138589885093;
        points[41] = 0.98115183307791396666274900535048782880567555553965774;
        points[42] = 0.992316392138515808483338003613538568811897784352210077;
        points[43] = 0.998540200636774224936056720606650349056030033175414598;
        weights[0] = 0.00374540480311277751517377883176153847769791634328217317;
        weights[1] = 0.00870048136752484412256562342431314020846842115836189609;
        weights[2] = 0.0136195867555799855202050663900613788732667197548707233;
        weights[3] = 0.0184714817368147491720422237433998441155207383139018773;
        weights[4] = 0.0232314819020192106289582629387314174882219020356579972;
        weights[5] = 0.0278757828212810100811142917793870643220588398929903486;
        weights[6] = 0.0323812228120698208808469395401116011469480517800294205;
        weights[7] = 0.0367253478138088736429092923487017997107087879997468729;
        weights[8] = 0.040886512310346218908447169283068486854079289026702596;
        weights[9] = 0.0448439840819700314462431864030511071809630216557339997;
        weights[10] = 0.0485780464483520375276394366912927376150513991068246759;
        weights[11] = 0.0520700960917044618812318029931987510562641747411169266;
        weights[12] = 0.0553027355637280525487466326431529914715348464176177601;
        weights[13] = 0.0582598598775954953342106898442771680047561691033535674;
        weights[14] = 0.0609267367015619680385578368743741006725724894816501122;
        weights[15] = 0.0632900797332038549501388710197149306380242882440941854;
        weights[16] = 0.0653381148791814349842408948456221894960108011296769286;
        weights[17] = 0.067060638906293652395704919351719350780713013072761568;
        weights[18] = 0.0684490702693666609854586607043498724451555436359000409;
        weights[19] = 0.0694964918615725780370840909250112567820934753811742274;
        weights[20] = 0.0701976854735582125871420419443993876688266862156284579;
        weights[21] = 0.0705491577893540688113382874802998849910634255089236448;
        weights[22] = 0.0705491577893540688113382874802998849910634255089236448;
        weights[23] = 0.0701976854735582125871420419443993876688266862156284579;
        weights[24] = 0.0694964918615725780370840909250112567820934753811742274;
        weights[25] = 0.0684490702693666609854586607043498724451555436359000409;
        weights[26] = 0.067060638906293652395704919351719350780713013072761568;
        weights[27] = 0.0653381148791814349842408948456221894960108011296769286;
        weights[28] = 0.0632900797332038549501388710197149306380242882440941854;
        weights[29] = 0.0609267367015619680385578368743741006725724894816501122;
        weights[30] = 0.0582598598775954953342106898442771680047561691033535674;
        weights[31] = 0.0553027355637280525487466326431529914715348464176177601;
        weights[32] = 0.0520700960917044618812318029931987510562641747411169266;
        weights[33] = 0.0485780464483520375276394366912927376150513991068246759;
        weights[34] = 0.0448439840819700314462431864030511071809630216557339997;
        weights[35] = 0.040886512310346218908447169283068486854079289026702596;
        weights[36] = 0.0367253478138088736429092923487017997107087879997468729;
        weights[37] = 0.0323812228120698208808469395401116011469480517800294205;
        weights[38] = 0.0278757828212810100811142917793870643220588398929903486;
        weights[39] = 0.0232314819020192106289582629387314174882219020356579972;
        weights[40] = 0.0184714817368147491720422237433998441155207383139018773;
        weights[41] = 0.0136195867555799855202050663900613788732667197548707233;
        weights[42] = 0.00870048136752484412256562342431314020846842115836189609;
        weights[43] = 0.00374540480311277751517377883176153847769791634328217317;
        return;
    case 45:
        points[0] = -0.998603645181936638156547676900820548092288527214475417;
        points[1] = -0.992649998447203741748617120597735344975001643303639351;
        points[2] = -0.981968715034540568239318473634341481538365249220461808;
        points[3] = -0.966608310396894604736425160892478097116679030609415414;
        points[4] = -0.946641690995629061784720596953837078450468344167135051;
        points[5] = -0.922163936719000388097467360960527319265362877250661168;
        points[6] = -0.893291671753241738464649051493057346365401240413792686;
        points[7] = -0.860162475960664225339078870567134387783414423577022101;
        points[8] = -0.822934220502086337035775260026502029993415258056270434;
        points[9] = -0.781784312593906291312363188098602817660273516839061523;
        points[10] = -0.736908848945490352623738848594892019879605680837617081;
        points[11] = -0.688521680771200525232019825880438235955233005618527781;
        points[12] = -0.636853394453223359271223845903383150692031243465676441;
        points[13] = -0.582150212569353186680967334444177131000088825983227146;
        points[14] = -0.524672820462916067091134100460162402607108270800282587;
        points[15] = -0.464695123919635098579601502309748510839812667237190883;
        points[16] = -0.402502943858541914077974508548346455970299357569396439;
        points[17] = -0.338392654250602161643404100031872989532341443137422698;
        points[18] = -0.27266976975237756060876539161564518189821175427664206;
        points[19] = -0.205647489783263745719787225471543930703236385699429831;
        points[20] = -0.13764520598325302875659004142306555310676555654152506;
        points[21] = -0.0689869801631441724904146141038117296939206669309696827;
        points[22] = 0;
        points[23] = 0.0689869801631441724904146141038117296939206669309696827;
        points[24] = 0.13764520598325302875659004142306555310676555654152506;
        points[25] = 0.205647489783263745719787225471543930703236385699429831;
        points[26] = 0.27266976975237756060876539161564518189821175427664206;
        points[27] = 0.338392654250602161643404100031872989532341443137422698;
        points[28] = 0.402502943858541914077974508548346455970299357569396439;
        points[29] = 0.464695123919635098579601502309748510839812667237190883;
        points[30] = 0.524672820462916067091134100460162402607108270800282587;
        points[31] = 0.582150212569353186680967334444177131000088825983227146;
        points[32] = 0.636853394453223359271223845903383150692031243465676441;
        points[33] = 0.688521680771200525232019825880438235955233005618527781;
        points[34] = 0.736908848945490352623738848594892019879605680837617081;
        points[35] = 0.781784312593906291312363188098602817660273516839061523;
        points[36] = 0.822934220502086337035775260026502029993415258056270434;
        points[37] = 0.860162475960664225339078870567134387783414423577022101;
        points[38] = 0.893291671753241738464649051493057346365401240413792686;
        points[39] = 0.922163936719000388097467360960527319265362877250661168;
        points[40] = 0.946641690995629061784720596953837078450468344167135051;
        points[41] = 0.966608310396894604736425160892478097116679030609415414;
        points[42] = 0.981968715034540568239318473634341481538365249220461808;
        points[43] = 0.992649998447203741748617120597735344975001643303639351;
        points[44] = 0.998603645181936638156547676900820548092288527214475417;
        weights[0] = 0.00358266315528355893114302865935139257058563635818394461;
        weights[1] = 0.00832318929621824164573585312223385375615793129294822189;
        weights[2] = 0.0130311049915827843206310824696869260271411715826389911;
        weights[3] = 0.017677535257937590617092546669577088520651278126465788;
        weights[4] = 0.0222398475505787323939507585521689933448757087012999707;
        weights[5] = 0.0266962139675776648056747787931075277878249105658915236;
        weights[6] = 0.0310253749345154671625079388937680638859211521239748004;
        weights[7] = 0.0352066922016090162476997982615750908100880747127146413;
        weights[8] = 0.0392202367293024475641871853439293382181301245963066698;
        weights[9] = 0.0430468807091649711516911130811669417883192361631913202;
        weights[10] = 0.0466683877183733652677684757416541012049861414878535825;
        weights[11] = 0.0500674992379520297991321024748743173914986929351464372;
        weights[12] = 0.053228016731268951945904044019310403798482216940175516;
        weights[13] = 0.0561348787597864766439239403748697632414801849461630158;
        weights[14] = 0.0587742327188417385743615176318314225312657254609802081;
        weights[15] = 0.0611335008310665225018863705363255732601242342652421201;
        weights[16] = 0.063201440073819937749963730290666881866300237275822817;
        weights[17] = 0.0649681957507234308538265703590756950838497254875832731;
        weights[18] = 0.066425348449842528082914715639103737613174546750674816;
        weights[19] = 0.067565954163607536270910223873648630979472580923946462;
        weights[20] = 0.0683845773786696745316920993343160970734849130546449464;
        weights[21] = 0.0688773169776613228820028482980557888845241301106485452;
        weights[22] = 0.0690418248292320201107985551594047407233228922750047781;
        weights[23] = 0.0688773169776613228820028482980557888845241301106485452;
        weights[24] = 0.0683845773786696745316920993343160970734849130546449464;
        weights[25] = 0.067565954163607536270910223873648630979472580923946462;
        weights[26] = 0.066425348449842528082914715639103737613174546750674816;
        weights[27] = 0.0649681957507234308538265703590756950838497254875832731;
        weights[28] = 0.063201440073819937749963730290666881866300237275822817;
        weights[29] = 0.0611335008310665225018863705363255732601242342652421201;
        weights[30] = 0.0587742327188417385743615176318314225312657254609802081;
        weights[31] = 0.0561348787597864766439239403748697632414801849461630158;
        weights[32] = 0.053228016731268951945904044019310403798482216940175516;
        weights[33] = 0.0500674992379520297991321024748743173914986929351464372;
        weights[34] = 0.0466683877183733652677684757416541012049861414878535825;
        weights[35] = 0.0430468807091649711516911130811669417883192361631913202;
        weights[36] = 0.0392202367293024475641871853439293382181301245963066698;
        weights[37] = 0.0352066922016090162476997982615750908100880747127146413;
        weights[38] = 0.0310253749345154671625079388937680638859211521239748004;
        weights[39] = 0.0266962139675776648056747787931075277878249105658915236;
        weights[40] = 0.0222398475505787323939507585521689933448757087012999707;
        weights[41] = 0.017677535257937590617092546669577088520651278126465788;
        weights[42] = 0.0130311049915827843206310824696869260271411715826389911;
        weights[43] = 0.00832318929621824164573585312223385375615793129294822189;
        weights[44] = 0.00358266315528355893114302865935139257058563635818394461;
        return;
    case 46:
        points[0] = -0.998663042133817981128268417390888774584155607434631726;
        points[1] = -0.992962348906174364073095444666193409121102830908384025;
        points[2] = -0.982733669804166863477979579659188720219563370298428801;
        points[3] = -0.968021391853991942737748066371815508522311826353630101;
        points[4] = -0.948892363446089795622213539436914139525771383293245333;
        points[5] = -0.925433798806753950977491357699124258882343756438955848;
        points[6] = -0.89775271153394196570131995131978128945462964530135109;
        points[7] = -0.865975394866858062915888776816598438687304744337904484;
        points[8] = -0.830246837066066053032385304790806117995806253970380608;
        points[9] = -0.79073005707527425518914414742030241114796951308471111;
        points[10] = -0.747605359615666054000336505268002868905722180002546495;
        points[11] = -0.701069512020405697512122089426500450249575983149938646;
        points[12] = -0.651334846201997715106477155816859367227604057318475939;
        points[13] = -0.598628289712715153177172533600167310148466334564629948;
        points[14] = -0.543190330261802635270962691028876836033978470384916085;
        points[15] = -0.485273918388164662772320193708454808319667559283038704;
        points[16] = -0.425143313282828397322146863428567419169337769107934692;
        points[17] = -0.363072877020995710123706978514651689847388842857642471;
        points[18] = -0.299345822701870015483439256577903929356092317554238349;
        points[19] = -0.234252922206269768626056115573792492574088821990498026;
        points[20] = -0.168091179467103528606796737427702127447489281836469397;
        points[21] = -0.10116247530558423951585965700864939088187136050149374;
        points[22] = -0.0337721900160520415195578318914397638159161159962019207;
        points[23] = 0.0337721900160520415195578318914397638159161159962019207;
        points[24] = 0.10116247530558423951585965700864939088187136050149374;
        points[25] = 0.168091179467103528606796737427702127447489281836469397;
        points[26] = 0.234252922206269768626056115573792492574088821990498026;
        points[27] = 0.299345822701870015483439256577903929356092317554238349;
        points[28] = 0.363072877020995710123706978514651689847388842857642471;
        points[29] = 0.425143313282828397322146863428567419169337769107934692;
        points[30] = 0.485273918388164662772320193708454808319667559283038704;
        points[31] = 0.543190330261802635270962691028876836033978470384916085;
        points[32] = 0.598628289712715153177172533600167310148466334564629948;
        points[33] = 0.651334846201997715106477155816859367227604057318475939;
        points[34] = 0.701069512020405697512122089426500450249575983149938646;
        points[35] = 0.747605359615666054000336505268002868905722180002546495;
        points[36] = 0.79073005707527425518914414742030241114796951308471111;
        points[37] = 0.830246837066066053032385304790806117995806253970380608;
        points[38] = 0.865975394866858062915888776816598438687304744337904484;
        points[39] = 0.89775271153394196570131995131978128945462964530135109;
        points[40] = 0.925433798806753950977491357699124258882343756438955848;
        points[41] = 0.948892363446089795622213539436914139525771383293245333;
        points[42] = 0.968021391853991942737748066371815508522311826353630101;
        points[43] = 0.982733669804166863477979579659188720219563370298428801;
        points[44] = 0.992962348906174364073095444666193409121102830908384025;
        points[45] = 0.998663042133817981128268417390888774584155607434631726;
        weights[0] = 0.00343030086810704828601878314804340444117294580521133124;
        weights[1] = 0.00796989822972462245161303892632496542628877099259653938;
        weights[2] = 0.0124798837709886842067345717509833751775225473853508905;
        weights[3] = 0.0169335140078362380462307136717604313337264438256941511;
        weights[4] = 0.0213099987541365010544793610708784018288437765205240164;
        weights[5] = 0.025589286397130010634699512200344028102879560738616994;
        weights[6] = 0.0297518295522027557990517292357229370930287538189488675;
        weights[7] = 0.033778627999106896520603893881145328727799480475200311;
        weights[8] = 0.037651305357386071327660799228459117026955119454260672;
        weights[9] = 0.0413521901096787297042201758702314784242062241137726262;
        weights[10] = 0.0448643952773181267670946135627748564422867005184251784;
        weights[11] = 0.0481718951017122005304688632232209366819754923674621692;
        weights[12] = 0.0512595980071430213353652993714480334641815016265305325;
        weights[13] = 0.0541134153858567544916376432592230752598974690411350662;
        weights[14] = 0.0567203258439912358168744036032867145864270226091147547;
        weights[15] = 0.0590684345955463148075507226369077370982169484922302968;
        weights[16] = 0.0611470277246504810153566079041910377727816328578536076;
        weights[17] = 0.0629466210643945081789519522471109312332461650317862209;
        weights[18] = 0.0644590034671390695882794391082550639237956450450184925;
        weights[19] = 0.0656772742677812073787575656855557676217161397738117155;
        weights[20] = 0.0665958747684548873757619664227337019443637088009921093;
        weights[21] = 0.0672106136006781758623741548270975961765396811656452022;
        weights[22] = 0.0675186858490364588202141891643010802121482695398182551;
        weights[23] = 0.0675186858490364588202141891643010802121482695398182551;
        weights[24] = 0.0672106136006781758623741548270975961765396811656452022;
        weights[25] = 0.0665958747684548873757619664227337019443637088009921093;
        weights[26] = 0.0656772742677812073787575656855557676217161397738117155;
        weights[27] = 0.0644590034671390695882794391082550639237956450450184925;
        weights[28] = 0.0629466210643945081789519522471109312332461650317862209;
        weights[29] = 0.0611470277246504810153566079041910377727816328578536076;
        weights[30] = 0.0590684345955463148075507226369077370982169484922302968;
        weights[31] = 0.0567203258439912358168744036032867145864270226091147547;
        weights[32] = 0.0541134153858567544916376432592230752598974690411350662;
        weights[33] = 0.0512595980071430213353652993714480334641815016265305325;
        weights[34] = 0.0481718951017122005304688632232209366819754923674621692;
        weights[35] = 0.0448643952773181267670946135627748564422867005184251784;
        weights[36] = 0.0413521901096787297042201758702314784242062241137726262;
        weights[37] = 0.037651305357386071327660799228459117026955119454260672;
        weights[38] = 0.033778627999106896520603893881145328727799480475200311;
        weights[39] = 0.0297518295522027557990517292357229370930287538189488675;
        weights[40] = 0.025589286397130010634699512200344028102879560738616994;
        weights[41] = 0.0213099987541365010544793610708784018288437765205240164;
        weights[42] = 0.0169335140078362380462307136717604313337264438256941511;
        weights[43] = 0.0124798837709886842067345717509833751775225473853508905;
        weights[44] = 0.00796989822972462245161303892632496542628877099259653938;
        weights[45] = 0.00343030086810704828601878314804340444117294580521133124;
        return;
    case 47:
        points[0] = -0.998718728584212109183947714787108491627090651231490809;
        points[1] = -0.993255210987768634692189684632463608145712084110630735;
        points[2] = -0.983451003071623708764901034036169851931654219108093774;
        points[3] = -0.969346787326564497145744277560270805338302946979504136;
        points[4] = -0.951003969257708442589802923851442422653601515387379029;
        points[5] = -0.92850269301236064819718492461132098137541878694303399;
        points[6] = -0.90194132943852535686717130197743563963863448643228478;
        points[7] = -0.871436015796896316940985464555606171051926526115779609;
        points[8] = -0.837120139899902121277598948566352364181868949463442594;
        points[9] = -0.799143754167741942915562069203593012040520856198734943;
        points[10] = -0.757672918445438633573996523569682201213419910433653433;
        points[11] = -0.712888973409064301661879327771018811704250245755917143;
        points[12] = -0.664987747390332729136702648572089061430514814533270926;
        points[13] = -0.61417869995637360859546254260425368624817994509020475;
        points[14] = -0.560684005934664194483058317418268791143523454591137439;
        points[15] = -0.504737583863577919774289025351301090273203119224602529;
        points[16] = -0.446584073104855702725182142349407959393417005198721099;
        points[17] = -0.386477764084667139583302387606023270201837608014830015;
        points[18] = -0.324681486337735902210761299179996836399628916007062326;
        points[19] = -0.261465459214974570306982966205170974233322733796879725;
        points[20] = -0.197106110279111807961491358370504617554862870422339665;
        points[21] = -0.131884866554514897053823530724127241363335153438488913;
        points[22] = -0.0660869239163556751604737774741337085922762739362204089;
        points[23] = 0;
        points[24] = 0.0660869239163556751604737774741337085922762739362204089;
        points[25] = 0.131884866554514897053823530724127241363335153438488913;
        points[26] = 0.197106110279111807961491358370504617554862870422339665;
        points[27] = 0.261465459214974570306982966205170974233322733796879725;
        points[28] = 0.324681486337735902210761299179996836399628916007062326;
        points[29] = 0.386477764084667139583302387606023270201837608014830015;
        points[30] = 0.446584073104855702725182142349407959393417005198721099;
        points[31] = 0.504737583863577919774289025351301090273203119224602529;
        points[32] = 0.560684005934664194483058317418268791143523454591137439;
        points[33] = 0.61417869995637360859546254260425368624817994509020475;
        points[34] = 0.664987747390332729136702648572089061430514814533270926;
        points[35] = 0.712888973409064301661879327771018811704250245755917143;
        points[36] = 0.757672918445438633573996523569682201213419910433653433;
        points[37] = 0.799143754167741942915562069203593012040520856198734943;
        points[38] = 0.837120139899902121277598948566352364181868949463442594;
        points[39] = 0.871436015796896316940985464555606171051926526115779609;
        points[40] = 0.90194132943852535686717130197743563963863448643228478;
        points[41] = 0.92850269301236064819718492461132098137541878694303399;
        points[42] = 0.951003969257708442589802923851442422653601515387379029;
        points[43] = 0.969346787326564497145744277560270805338302946979504136;
        points[44] = 0.983451003071623708764901034036169851931654219108093774;
        points[45] = 0.993255210987768634692189684632463608145712084110630735;
        points[46] = 0.998718728584212109183947714787108491627090651231490809;
        weights[0] = 0.00328745384252801488324996420833617985136062240707094616;
        weights[1] = 0.00763861629584883361410435677113165550442058982256510536;
        weights[2] = 0.0119628484643123209639434548499485125233929083624680225;
        weights[3] = 0.0162353331464330596707256874078986210158929190439750067;
        weights[4] = 0.0204369381476684276420347606862553864272310490241569037;
        weights[5] = 0.0245492116596588185378341571525057671376631521648313099;
        weights[6] = 0.0285541507006433865047399246258110816068752178326918684;
        weights[7] = 0.0324342355151847567676174631741701586930886808732865899;
        weights[8] = 0.0361724965841749516134599297663112486734452822013805724;
        weights[9] = 0.0397525861225310037809013801419610165916494688156830593;
        weights[10] = 0.0431588486484795382683017934465031395477193777824471417;
        weights[11] = 0.0463763890865059112044018482427450925486960452628959105;
        weights[12] = 0.049391137747361169604570485862004923119994023790494317;
        weights[13] = 0.0521899117800571448722119417096760777217349799620321767;
        weights[14] = 0.054760472781530225957125176888504805903795366348507213;
        weights[15] = 0.0570915802932315402220166053083827729103294259652469968;
        weights[16] = 0.0591730409423388759761545563857412924638323514930740505;
        weights[17] = 0.0609957530087396453307105781334375211810932043020158768;
        weights[18] = 0.0625517462209216626405643814499535367534158434584604253;
        weights[19] = 0.0638342166057170306312937798558135334823363436906859726;
        weights[20] = 0.0648375562389457267026039391108060188849947526018283188;
        weights[21] = 0.0655573777665497402511430023260759122819998908087335979;
        weights[22] = 0.0659905335888104745335706553304982595773582776265029979;
        weights[23] = 0.0661351296236554796534403543310549711953604527179312406;
        weights[24] = 0.0659905335888104745335706553304982595773582776265029979;
        weights[25] = 0.0655573777665497402511430023260759122819998908087335979;
        weights[26] = 0.0648375562389457267026039391108060188849947526018283188;
        weights[27] = 0.0638342166057170306312937798558135334823363436906859726;
        weights[28] = 0.0625517462209216626405643814499535367534158434584604253;
        weights[29] = 0.0609957530087396453307105781334375211810932043020158768;
        weights[30] = 0.0591730409423388759761545563857412924638323514930740505;
        weights[31] = 0.0570915802932315402220166053083827729103294259652469968;
        weights[32] = 0.054760472781530225957125176888504805903795366348507213;
        weights[33] = 0.0521899117800571448722119417096760777217349799620321767;
        weights[34] = 0.049391137747361169604570485862004923119994023790494317;
        weights[35] = 0.0463763890865059112044018482427450925486960452628959105;
        weights[36] = 0.0431588486484795382683017934465031395477193777824471417;
        weights[37] = 0.0397525861225310037809013801419610165916494688156830593;
        weights[38] = 0.0361724965841749516134599297663112486734452822013805724;
        weights[39] = 0.0324342355151847567676174631741701586930886808732865899;
        weights[40] = 0.0285541507006433865047399246258110816068752178326918684;
        weights[41] = 0.0245492116596588185378341571525057671376631521648313099;
        weights[42] = 0.0204369381476684276420347606862553864272310490241569037;
        weights[43] = 0.0162353331464330596707256874078986210158929190439750067;
        weights[44] = 0.0119628484643123209639434548499485125233929083624680225;
        weights[45] = 0.00763861629584883361410435677113165550442058982256510536;
        weights[46] = 0.00328745384252801488324996420833617985136062240707094616;
        return;
    case 48:
        points[0] = -0.998771007252426118600541491563113640088937650276721039;
        points[1] = -0.99353017226635075754792875084907411835661474959467193;
        points[2] = -0.98412458372282685774458360002659883058923922341738473;
        points[3] = -0.970591592546247250461411983800660057302433911630883706;
        points[4] = -0.952987703160430860722960666025718343208541331823918737;
        points[5] = -0.93138669070655433311417438010160126771999708561895043;
        points[6] = -0.905879136715569672822074835671011788312262199827410845;
        points[7] = -0.876572020274247885905693554805096754561648533729961993;
        points[8] = -0.843588261624393530711089844519656049870887011737552402;
        points[9] = -0.807066204029442627082553043024538445973013029460415387;
        points[10] = -0.767159032515740339253855437522969053622642330848207372;
        points[11] = -0.724034130923814654674482233493665246585092812280722363;
        points[12] = -0.677872379632663905211851280675909058849954679026048613;
        points[13] = -0.628867396776513623995164933069994652024908999790161771;
        points[14] = -0.577224726083972703817809238540478772853997286140195528;
        points[15] = -0.523160974722233033678225869137508526289187621811884108;
        points[16] = -0.466902904750958404544928861650798509236812104258516944;
        points[17] = -0.408686481990716729916225495814633286459922842994888065;
        points[18] = -0.348755886292160738159817937270407916134309649968392576;
        points[19] = -0.287362487355455576735886461316797687851558305801039779;
        points[20] = -0.224763790394689061224865440174692277438561804041654806;
        points[21] = -0.161222356068891718056437390783497694774374379741895118;
        points[22] = -0.0970046992094626989300539558536245201527362293009369864;
        points[23] = -0.0323801709628693620333222431521344420459628023615180924;
        points[24] = 0.0323801709628693620333222431521344420459628023615180924;
        points[25] = 0.0970046992094626989300539558536245201527362293009369864;
        points[26] = 0.161222356068891718056437390783497694774374379741895118;
        points[27] = 0.224763790394689061224865440174692277438561804041654806;
        points[28] = 0.287362487355455576735886461316797687851558305801039779;
        points[29] = 0.348755886292160738159817937270407916134309649968392576;
        points[30] = 0.408686481990716729916225495814633286459922842994888065;
        points[31] = 0.466902904750958404544928861650798509236812104258516944;
        points[32] = 0.523160974722233033678225869137508526289187621811884108;
        points[33] = 0.577224726083972703817809238540478772853997286140195528;
        points[34] = 0.628867396776513623995164933069994652024908999790161771;
        points[35] = 0.677872379632663905211851280675909058849954679026048613;
        points[36] = 0.724034130923814654674482233493665246585092812280722363;
        points[37] = 0.767159032515740339253855437522969053622642330848207372;
        points[38] = 0.807066204029442627082553043024538445973013029460415387;
        points[39] = 0.843588261624393530711089844519656049870887011737552402;
        points[40] = 0.876572020274247885905693554805096754561648533729961993;
        points[41] = 0.905879136715569672822074835671011788312262199827410845;
        points[42] = 0.93138669070655433311417438010160126771999708561895043;
        points[43] = 0.952987703160430860722960666025718343208541331823918737;
        points[44] = 0.970591592546247250461411983800660057302433911630883706;
        points[45] = 0.98412458372282685774458360002659883058923922341738473;
        points[46] = 0.99353017226635075754792875084907411835661474959467193;
        points[47] = 0.998771007252426118600541491563113640088937650276721039;
        weights[0] = 0.0031533460523058386326773115438914875782839388316936223;
        weights[1] = 0.00732755390127626210238397962178655005870790255920135327;
        weights[2] = 0.0114772345792345394895926676090916280864205063087476407;
        weights[3] = 0.0155793157229438487281769558344603139763762689915524695;
        weights[4] = 0.0196161604573555278144607196522127096958130377341322392;
        weights[5] = 0.0235707608393243791405193013784492302217297385221885987;
        weights[6] = 0.027426509708356948200073836262505820451184155161650976;
        weights[7] = 0.0311672278327980889020657568463544194542853414835695355;
        weights[8] = 0.0347772225647704388925485859638024105972813969070680987;
        weights[9] = 0.0382413510658307063172172565237156178638239683549822889;
        weights[10] = 0.0415450829434647492140588223610647977534728260340380631;
        weights[11] = 0.0446745608566942804194485871258503949884627868625020084;
        weights[12] = 0.0476166584924904748259066234789298301579980667434496854;
        weights[13] = 0.0503590355538544749578076190878656060329940930259063307;
        weights[14] = 0.0528901894851936670955050562646989146617264856331091864;
        weights[15] = 0.0551995036999841628682034951916354390044509256075610005;
        weights[16] = 0.0572772921004032157051502346847005762415271230041120775;
        weights[17] = 0.0591148396983956357464748174335199106596556025570549986;
        weights[18] = 0.0607044391658938800529692320278204778852608642564777551;
        weights[19] = 0.0620394231598926639041977841375985183063833996650914616;
        weights[20] = 0.0631141922862540256571260227502333181274136433711007912;
        weights[21] = 0.0639242385846481866239062018255154089189740849826429999;
        weights[22] = 0.0644661644359500822065041936577050657256919244555303088;
        weights[23] = 0.06473769681268392250302493873659155355208191894663651;
        weights[24] = 0.06473769681268392250302493873659155355208191894663651;
        weights[25] = 0.0644661644359500822065041936577050657256919244555303088;
        weights[26] = 0.0639242385846481866239062018255154089189740849826429999;
        weights[27] = 0.0631141922862540256571260227502333181274136433711007912;
        weights[28] = 0.0620394231598926639041977841375985183063833996650914616;
        weights[29] = 0.0607044391658938800529692320278204778852608642564777551;
        weights[30] = 0.0591148396983956357464748174335199106596556025570549986;
        weights[31] = 0.0572772921004032157051502346847005762415271230041120775;
        weights[32] = 0.0551995036999841628682034951916354390044509256075610005;
        weights[33] = 0.0528901894851936670955050562646989146617264856331091864;
        weights[34] = 0.0503590355538544749578076190878656060329940930259063307;
        weights[35] = 0.0476166584924904748259066234789298301579980667434496854;
        weights[36] = 0.0446745608566942804194485871258503949884627868625020084;
        weights[37] = 0.0415450829434647492140588223610647977534728260340380631;
        weights[38] = 0.0382413510658307063172172565237156178638239683549822889;
        weights[39] = 0.0347772225647704388925485859638024105972813969070680987;
        weights[40] = 0.0311672278327980889020657568463544194542853414835695355;
        weights[41] = 0.027426509708356948200073836262505820451184155161650976;
        weights[42] = 0.0235707608393243791405193013784492302217297385221885987;
        weights[43] = 0.0196161604573555278144607196522127096958130377341322392;
        weights[44] = 0.0155793157229438487281769558344603139763762689915524695;
        weights[45] = 0.0114772345792345394895926676090916280864205063087476407;
        weights[46] = 0.00732755390127626210238397962178655005870790255920135327;
        weights[47] = 0.0031533460523058386326773115438914875782839388316936223;
        return;
    case 49:
        points[0] = -0.998820150606635379361831272704110655123680997864501964;
        points[1] = -0.993788661944167790760113859257953618841307394938650168;
        points[2] = -0.984757895914213004359298995368574710353307462145252953;
        points[3] = -0.971762200901555380139972421504774133497862547180905693;
        points[4] = -0.954853658674137233555243679668184419054694451900273792;
        points[5] = -0.934100294755810149058982460636544902460422952810191994;
        points[6] = -0.909585655828073285213019640355800071042771231116718039;
        points[7] = -0.88140844557300891003703153581700492615924003726239134;
        points[8] = -0.849682119844165701034881872242979333326604332464716249;
        points[9] = -0.814534427359855431539500787764777044494672135822753352;
        points[10] = -0.776106894345446635018142812248456071264450461829181865;
        points[11] = -0.734554254237402696213674212858524884652835453323701834;
        points[12] = -0.690043824425132113504751807274941927633505126189035751;
        points[13] = -0.642754832419237664056856948583900109540335472253277533;
        points[14] = -0.59287769410890071245586433679262853463300101531884759;
        points[15] = -0.540613246991726066558225467229435916924101346238365847;
        points[16] = -0.486171941452492042176976096058575062075115194334936605;
        points[17] = -0.42977299334157652465858414180742303306341789787807201;
        points[18] = -0.371643501262284888863734540946960527614744786733926977;
        points[19] = -0.31201753211974876220786067650641626509683340799438725;
        points[20] = -0.251135178612577273507155942824611274582984174573664251;
        points[21] = -0.189241592461813586485310173859986511179678877678819089;
        points[22] = -0.126585997269672051067985288575536190324487121066866714;
        points[23] = -0.0634206849826867860288348208784849731527868727788803875;
        points[24] = 0;
        points[25] = 0.0634206849826867860288348208784849731527868727788803875;
        points[26] = 0.126585997269672051067985288575536190324487121066866714;
        points[27] = 0.189241592461813586485310173859986511179678877678819089;
        points[28] = 0.251135178612577273507155942824611274582984174573664251;
        points[29] = 0.31201753211974876220786067650641626509683340799438725;
        points[30] = 0.371643501262284888863734540946960527614744786733926977;
        points[31] = 0.42977299334157652465858414180742303306341789787807201;
        points[32] = 0.486171941452492042176976096058575062075115194334936605;
        points[33] = 0.540613246991726066558225467229435916924101346238365847;
        points[34] = 0.59287769410890071245586433679262853463300101531884759;
        points[35] = 0.642754832419237664056856948583900109540335472253277533;
        points[36] = 0.690043824425132113504751807274941927633505126189035751;
        points[37] = 0.734554254237402696213674212858524884652835453323701834;
        points[38] = 0.776106894345446635018142812248456071264450461829181865;
        points[39] = 0.814534427359855431539500787764777044494672135822753352;
        points[40] = 0.849682119844165701034881872242979333326604332464716249;
        points[41] = 0.88140844557300891003703153581700492615924003726239134;
        points[42] = 0.909585655828073285213019640355800071042771231116718039;
        points[43] = 0.934100294755810149058982460636544902460422952810191994;
        points[44] = 0.954853658674137233555243679668184419054694451900273792;
        points[45] = 0.971762200901555380139972421504774133497862547180905693;
        points[46] = 0.984757895914213004359298995368574710353307462145252953;
        points[47] = 0.993788661944167790760113859257953618841307394938650168;
        points[48] = 0.998820150606635379361831272704110655123680997864501964;
        weights[0] = 0.00302727898892290507748069817582714097283004200383177339;
        weights[1] = 0.00703509959008645147345067831134841086286385703902733685;
        weights[2] = 0.011020551031593580497508288166833332752193560544957745;
        weights[3] = 0.0149621449356246510295843191202015040362810163727672786;
        weights[4] = 0.0188435958530894584444506533911073492677499020192522803;
        weights[5] = 0.022649201587446676498770964216042887326797499023264776;
        weights[6] = 0.0263636189270660169609457452397420476944609717657405082;
        weights[7] = 0.0299718846205838253506905580741472100620720359508768289;
        weights[8] = 0.0334594667916221743424871508916892018494798678602284556;
        weights[9] = 0.0368123209630006898194672366988822950013615524059829569;
        weights[10] = 0.0400169457663730213686050367431033214278646074650014685;
        weights[11] = 0.0430604369812595979883454840010384958067135812398217601;
        weights[12] = 0.0459305393555958535424996199721276710088243223546234087;
        weights[13] = 0.0486156958878282402776511972878685308813689286185930726;
        weights[14] = 0.0511050943301445906746228060493185613896124493297433889;
        weights[15] = 0.0533887107082589685279429337301762061655860694482272094;
        weights[16] = 0.0554573496748035886904315814826980672042515240737943838;
        weights[17] = 0.0573026815301874754851645923508165363505804388031196816;
        weights[18] = 0.0589172757600272660245276507424925162624961138594794598;
        weights[19] = 0.0602946309531520173031061168755415904977765089197254878;
        weights[20] = 0.0614292009791929362968266461403010749431900091920979337;
        weights[21] = 0.0623164173200572674010768252159497042241335362213208338;
        weights[22] = 0.0629527074651956994743995557828910063637254277695700414;
        weights[23] = 0.0633355092964917485908369274000905201479714165648258204;
        weights[24] = 0.0634632814047905977182534678795296349996295223082522192;
        weights[25] = 0.0633355092964917485908369274000905201479714165648258204;
        weights[26] = 0.0629527074651956994743995557828910063637254277695700414;
        weights[27] = 0.0623164173200572674010768252159497042241335362213208338;
        weights[28] = 0.0614292009791929362968266461403010749431900091920979337;
        weights[29] = 0.0602946309531520173031061168755415904977765089197254878;
        weights[30] = 0.0589172757600272660245276507424925162624961138594794598;
        weights[31] = 0.0573026815301874754851645923508165363505804388031196816;
        weights[32] = 0.0554573496748035886904315814826980672042515240737943838;
        weights[33] = 0.0533887107082589685279429337301762061655860694482272094;
        weights[34] = 0.0511050943301445906746228060493185613896124493297433889;
        weights[35] = 0.0486156958878282402776511972878685308813689286185930726;
        weights[36] = 0.0459305393555958535424996199721276710088243223546234087;
        weights[37] = 0.0430604369812595979883454840010384958067135812398217601;
        weights[38] = 0.0400169457663730213686050367431033214278646074650014685;
        weights[39] = 0.0368123209630006898194672366988822950013615524059829569;
        weights[40] = 0.0334594667916221743424871508916892018494798678602284556;
        weights[41] = 0.0299718846205838253506905580741472100620720359508768289;
        weights[42] = 0.0263636189270660169609457452397420476944609717657405082;
        weights[43] = 0.022649201587446676498770964216042887326797499023264776;
        weights[44] = 0.0188435958530894584444506533911073492677499020192522803;
        weights[45] = 0.0149621449356246510295843191202015040362810163727672786;
        weights[46] = 0.011020551031593580497508288166833332752193560544957745;
        weights[47] = 0.00703509959008645147345067831134841086286385703902733685;
        weights[48] = 0.00302727898892290507748069817582714097283004200383177339;
        return;
    case 50:
        points[0] = -0.998866404420071050185459444974218505996243512904078525;
        points[1] = -0.99403196943209071258510820042069472815747797106832359;
        points[2] = -0.985354084048005882309009625632489404015592630945405809;
        points[3] = -0.972864385106692073713344104606252053669173407049954202;
        points[4] = -0.956610955242807942997745644156622094051434124626046543;
        points[5] = -0.936656618944877933780874947272496602153731598095202922;
        points[6] = -0.91307855665579189308973564277165709478418819169778239;
        points[7] = -0.885967979523613048637540982466753634194290310755808362;
        points[8] = -0.855429769429946084611362643934757467654833039486905963;
        points[9] = -0.821582070859335948356254110873939537760741383343485749;
        points[10] = -0.784555832900399263905305196340991200847316272556444353;
        points[11] = -0.744494302226068538260536252682194242870187931329584579;
        points[12] = -0.701552468706822251089546257883655728149719228484695643;
        points[13] = -0.655896465685439360781624864003679819041410528382331827;
        points[14] = -0.607702927184950239180381796391832893604205020675994356;
        points[15] = -0.557158304514650054315522909625801607815898382237750261;
        points[16] = -0.504458144907464201651459131849141192635378678270679238;
        points[17] = -0.449806334974038789147131467778375817315064513465173666;
        points[18] = -0.393414311897565127394229253823817270246139468672656003;
        points[19] = -0.335500245419437356836988257291071697841218593036795762;
        points[20] = -0.276288193779531990327645278521130185714801587131996151;
        points[21] = -0.216007236876041756847284532617101333705755972510133273;
        points[22] = -0.154890589998145902071628620941109501201850220054937632;
        points[23] = -0.0931747015600861408544503776396003478856713839221386147;
        points[24] = -0.031098338327188876112328989665949194247296222959998043;
        points[25] = 0.031098338327188876112328989665949194247296222959998043;
        points[26] = 0.0931747015600861408544503776396003478856713839221386147;
        points[27] = 0.154890589998145902071628620941109501201850220054937632;
        points[28] = 0.216007236876041756847284532617101333705755972510133273;
        points[29] = 0.276288193779531990327645278521130185714801587131996151;
        points[30] = 0.335500245419437356836988257291071697841218593036795762;
        points[31] = 0.393414311897565127394229253823817270246139468672656003;
        points[32] = 0.449806334974038789147131467778375817315064513465173666;
        points[33] = 0.504458144907464201651459131849141192635378678270679238;
        points[34] = 0.557158304514650054315522909625801607815898382237750261;
        points[35] = 0.607702927184950239180381796391832893604205020675994356;
        points[36] = 0.655896465685439360781624864003679819041410528382331827;
        points[37] = 0.701552468706822251089546257883655728149719228484695643;
        points[38] = 0.744494302226068538260536252682194242870187931329584579;
        points[39] = 0.784555832900399263905305196340991200847316272556444353;
        points[40] = 0.821582070859335948356254110873939537760741383343485749;
        points[41] = 0.855429769429946084611362643934757467654833039486905963;
        points[42] = 0.885967979523613048637540982466753634194290310755808362;
        points[43] = 0.91307855665579189308973564277165709478418819169778239;
        points[44] = 0.936656618944877933780874947272496602153731598095202922;
        points[45] = 0.956610955242807942997745644156622094051434124626046543;
        points[46] = 0.972864385106692073713344104606252053669173407049954202;
        points[47] = 0.985354084048005882309009625632489404015592630945405809;
        points[48] = 0.99403196943209071258510820042069472815747797106832359;
        points[49] = 0.998866404420071050185459444974218505996243512904078525;
        weights[0] = 0.00290862255315514095840072434285548080667299645994632062;
        weights[1] = 0.00675979919574540150277887817798503180187383240646681055;
        weights[2] = 0.0105905483836509692635696814992410223394018190864591295;
        weights[3] = 0.0143808227614855744193789089273243499370317861705878928;
        weights[4] = 0.0181155607134893903512599434223546198446673170497340354;
        weights[5] = 0.021780243170124792981592069062690341227313462357934296;
        weights[6] = 0.0253606735700123904401948783854427234601612599757121373;
        weights[7] = 0.0288429935805351980299063731132324325178468655935374578;
        weights[8] = 0.0322137282235780166481658273230039534485890588334252172;
        weights[9] = 0.0354598356151461541607346110009757970969600004969844709;
        weights[10] = 0.0385687566125876752447701502363859348647717050005189265;
        weights[11] = 0.0415284630901476974224119789640670178089779754858409901;
        weights[12] = 0.0443275043388032754920222868303941974607612983554531657;
        weights[13] = 0.04695505130394843296563301363498768251406430618605273;
        weights[14] = 0.0494009384494663149212435807514327286922870509666131248;
        weights[15] = 0.0516557030695811384899052958400952796498254493954396451;
        weights[16] = 0.053710621888996246523458797255664552768023213529922153;
        weights[17] = 0.0555577448062125176235674256122694975951352999839026758;
        weights[18] = 0.0571899256477283837230293150659931630115753722570917549;
        weights[19] = 0.0586008498132224458351224366308484662097675134440254733;
        weights[20] = 0.0597850587042654575095764053125852307966660420726690046;
        weights[21] = 0.0607379708417702160317500153848110016097992732354035357;
        weights[22] = 0.0614558995903166637564067860839153750972675757640075143;
        weights[23] = 0.0619360674206832433840875097808306885728770566912449049;
        weights[24] = 0.0621766166553472623210331073606134308676824692010266331;
        weights[25] = 0.0621766166553472623210331073606134308676824692010266331;
        weights[26] = 0.0619360674206832433840875097808306885728770566912449049;
        weights[27] = 0.0614558995903166637564067860839153750972675757640075143;
        weights[28] = 0.0607379708417702160317500153848110016097992732354035357;
        weights[29] = 0.0597850587042654575095764053125852307966660420726690046;
        weights[30] = 0.0586008498132224458351224366308484662097675134440254733;
        weights[31] = 0.0571899256477283837230293150659931630115753722570917549;
        weights[32] = 0.0555577448062125176235674256122694975951352999839026758;
        weights[33] = 0.053710621888996246523458797255664552768023213529922153;
        weights[34] = 0.0516557030695811384899052958400952796498254493954396451;
        weights[35] = 0.0494009384494663149212435807514327286922870509666131248;
        weights[36] = 0.04695505130394843296563301363498768251406430618605273;
        weights[37] = 0.0443275043388032754920222868303941974607612983554531657;
        weights[38] = 0.0415284630901476974224119789640670178089779754858409901;
        weights[39] = 0.0385687566125876752447701502363859348647717050005189265;
        weights[40] = 0.0354598356151461541607346110009757970969600004969844709;
        weights[41] = 0.0322137282235780166481658273230039534485890588334252172;
        weights[42] = 0.0288429935805351980299063731132324325178468655935374578;
        weights[43] = 0.0253606735700123904401948783854427234601612599757121373;
        weights[44] = 0.021780243170124792981592069062690341227313462357934296;
        weights[45] = 0.0181155607134893903512599434223546198446673170497340354;
        weights[46] = 0.0143808227614855744193789089273243499370317861705878928;
        weights[47] = 0.0105905483836509692635696814992410223394018190864591295;
        weights[48] = 0.00675979919574540150277887817798503180187383240646681055;
        weights[49] = 0.00290862255315514095840072434285548080667299645994632062;
        return;
    case 51:
        points[0] = -0.99890999084890349516899587727338563708424992188818879;
        points[1] = -0.994261260436752574621084897949263128231784390279014997;
        points[2] = -0.985915991735902996583885707558309632652115778087196917;
        points[3] = -0.973903368019323867231755486394186639013106506315712867;
        points[4] = -0.958267848613908194557707038316323727612444018555868847;
        points[5] = -0.939067544002962383435367806390905144165163822150168441;
        points[6] = -0.916373862309780230823571294251475879366042671731375653;
        points[7] = -0.890271218029527303277795370736726893557799798870588831;
        points[8] = -0.860856711182292371473495743716111323577344925510962628;
        points[9] = -0.82823976382306483285481842401656236426238778158632526;
        points[10] = -0.792541712099381205234410878375875730157322463748367714;
        points[11] = -0.753895354485375525763960025452473987630637363814676515;
        points[12] = -0.712444457577036644580524855400145643036944790217248147;
        points[13] = -0.668343221175370086864460419403988875929608511773375996;
        points[14] = -0.621755704600723273755042745403315950054387566870162836;
        points[15] = -0.572855216351303836522394702590190907420943120723799457;
        points[16] = -0.521823669366185842514087784826818024569350245869358049;
        points[17] = -0.46885090428604106361045725881162246880672263543008758;
        points[18] = -0.414133983226303877936871809744657907923977170469394563;
        points[19] = -0.357876456688409509775201088519666356896383922095968334;
        points[20] = -0.300287606335331939530245649644420333331338380513049916;
        points[21] = -0.241581666447798703846733114869262423738793246472413578;
        points[22] = -0.181977026957077545323998701169214449923920116534003313;
        points[23] = -0.121695421018888766963820420963181108745303287484469844;
        points[24] = -0.0609611001505787247341947068432054046970304642695197844;
        points[25] = 0;
        points[26] = 0.0609611001505787247341947068432054046970304642695197844;
        points[27] = 0.121695421018888766963820420963181108745303287484469844;
        points[28] = 0.181977026957077545323998701169214449923920116534003313;
        points[29] = 0.241581666447798703846733114869262423738793246472413578;
        points[30] = 0.300287606335331939530245649644420333331338380513049916;
        points[31] = 0.357876456688409509775201088519666356896383922095968334;
        points[32] = 0.414133983226303877936871809744657907923977170469394563;
        points[33] = 0.46885090428604106361045725881162246880672263543008758;
        points[34] = 0.521823669366185842514087784826818024569350245869358049;
        points[35] = 0.572855216351303836522394702590190907420943120723799457;
        points[36] = 0.621755704600723273755042745403315950054387566870162836;
        points[37] = 0.668343221175370086864460419403988875929608511773375996;
        points[38] = 0.712444457577036644580524855400145643036944790217248147;
        points[39] = 0.753895354485375525763960025452473987630637363814676515;
        points[40] = 0.792541712099381205234410878375875730157322463748367714;
        points[41] = 0.82823976382306483285481842401656236426238778158632526;
        points[42] = 0.860856711182292371473495743716111323577344925510962628;
        points[43] = 0.890271218029527303277795370736726893557799798870588831;
        points[44] = 0.916373862309780230823571294251475879366042671731375653;
        points[45] = 0.939067544002962383435367806390905144165163822150168441;
        points[46] = 0.958267848613908194557707038316323727612444018555868847;
        points[47] = 0.973903368019323867231755486394186639013106506315712867;
        points[48] = 0.985915991735902996583885707558309632652115778087196917;
        points[49] = 0.994261260436752574621084897949263128231784390279014997;
        points[50] = 0.99890999084890349516899587727338563708424992188818879;
        weights[0] = 0.00279680717108989557554421688180904822421769963401154217;
        weights[1] = 0.00650033778325260029210937519853752883309494300542583879;
        weights[2] = 0.0101851912978217299392375917866067283858116360842121004;
        weights[3] = 0.0138326340064778222966884530218564159560185520765720385;
        weights[4] = 0.0174287147234010522595036464332924355683567782936189403;
        weights[5] = 0.0209599884017032105797926184015141720730404851884300961;
        weights[6] = 0.0244133005737814342731415654168982087436831704720281841;
        weights[7] = 0.0277757985941624771959956656322089163683512486485378396;
        weights[8] = 0.0310349712901600084544255029565473772961089781662175129;
        weights[9] = 0.0341786932041883362362093385947675290488258635830977047;
        weights[10] = 0.03719526892326029284290827581187102513411271037373731;
        weights[11] = 0.0400734762854964531868091159213959112011643310287352421;
        weights[12] = 0.0428026079978800866536095142442857008371752740218520776;
        weights[13] = 0.0453725114076500687481668149884378513138299567195096436;
        weights[14] = 0.0477736262406231019999953537073536173405392804756578877;
        weights[15] = 0.0499970201500574097795488553620057855687367493859867075;
        weights[16] = 0.052034421936697087564136447468662373215483974714382203;
        weights[17] = 0.0538782523130455614340993016969719837600599677404453317;
        weights[18] = 0.0555216520957386930167370590936241607808637054155963884;
        weights[19] = 0.0569585077202586621000777267342771648784094503250927945;
        weights[20] = 0.0581834739825921405984378776617759326678012576445445826;
        weights[21] = 0.0591919939229615437835390077491546088709300460360711795;
        weights[22] = 0.0599803157775032520900639879965171161730620955454330036;
        weights[23] = 0.0605455069347377951381252514677541627536849343772409734;
        weights[24] = 0.0608854648448563438811986142226962197280760102802736524;
        weights[25] = 0.0609989248412058801597976430983560505571218015265784498;
        weights[26] = 0.0608854648448563438811986142226962197280760102802736524;
        weights[27] = 0.0605455069347377951381252514677541627536849343772409734;
        weights[28] = 0.0599803157775032520900639879965171161730620955454330036;
        weights[29] = 0.0591919939229615437835390077491546088709300460360711795;
        weights[30] = 0.0581834739825921405984378776617759326678012576445445826;
        weights[31] = 0.0569585077202586621000777267342771648784094503250927945;
        weights[32] = 0.0555216520957386930167370590936241607808637054155963884;
        weights[33] = 0.0538782523130455614340993016969719837600599677404453317;
        weights[34] = 0.052034421936697087564136447468662373215483974714382203;
        weights[35] = 0.0499970201500574097795488553620057855687367493859867075;
        weights[36] = 0.0477736262406231019999953537073536173405392804756578877;
        weights[37] = 0.0453725114076500687481668149884378513138299567195096436;
        weights[38] = 0.0428026079978800866536095142442857008371752740218520776;
        weights[39] = 0.0400734762854964531868091159213959112011643310287352421;
        weights[40] = 0.03719526892326029284290827581187102513411271037373731;
        weights[41] = 0.0341786932041883362362093385947675290488258635830977047;
        weights[42] = 0.0310349712901600084544255029565473772961089781662175129;
        weights[43] = 0.0277757985941624771959956656322089163683512486485378396;
        weights[44] = 0.0244133005737814342731415654168982087436831704720281841;
        weights[45] = 0.0209599884017032105797926184015141720730404851884300961;
        weights[46] = 0.0174287147234010522595036464332924355683567782936189403;
        weights[47] = 0.0138326340064778222966884530218564159560185520765720385;
        weights[48] = 0.0101851912978217299392375917866067283858116360842121004;
        weights[49] = 0.00650033778325260029210937519853752883309494300542583879;
        weights[50] = 0.00279680717108989557554421688180904822421769963401154217;
        return;
    case 52:
        points[0] = -0.998951111103950278090961440716592561278013261115357562;
        points[1] = -0.994477590929216029245043271799571706631911776097882171;
        points[2] = -0.986446195651549840645322859118397368022739035827326233;
        points[3] = -0.974883884221744503140706470399645554459923663945938398;
        points[4] = -0.959831826933086552532025153425065442787847476037677415;
        points[5] = -0.9413438536413590568435791838505670058287655454363192;
        points[6] = -0.919486128916424539893596376541881585029520272702472057;
        points[7] = -0.894336890534495322520844088263527555345580995562376493;
        points[8] = -0.865986162846067585244358517624206940898338952624290824;
        points[9] = -0.834535432326734534961726389621238685245936312669226053;
        points[10] = -0.800097283430468324334758754225807651197641858607701581;
        points[11] = -0.762794995193744960279211163089050840791830574507621547;
        points[12] = -0.72276209974998319367681667607193595478399390521472002;
        points[13] = -0.680141904227167702092238779736641007900996710165775916;
        points[14] = -0.635086977695245924298124579288809653593598988954989663;
        points[15] = -0.58775860497957906990202578155720422388122016653804349;
        points[16] = -0.538326209285827438375951167975356763823490141403080973;
        points[17] = -0.486966745698096077782458241346465556850455039719023688;
        points[18] = -0.433864067718761670309086568209780260743745852418403386;
        points[19] = -0.379208269116093669246681766939448880462121591351196609;
        points[20] = -0.323195003434807825501099066601447179054047533806579458;
        points[21] = -0.266024783605001827472971730598839884455924374962184668;
        points[22] = -0.207902264156366059686466128122345518272662810828204647;
        points[23] = -0.149035508606949180488634040018113570322269761888233532;
        points[24] = -0.0896352446489005654888546911223993031698512871901984205;
        points[25] = -0.0299141097973387660436807760707999268188436082499469816;
        points[26] = 0.0299141097973387660436807760707999268188436082499469816;
        points[27] = 0.0896352446489005654888546911223993031698512871901984205;
        points[28] = 0.149035508606949180488634040018113570322269761888233532;
        points[29] = 0.207902264156366059686466128122345518272662810828204647;
        points[30] = 0.266024783605001827472971730598839884455924374962184668;
        points[31] = 0.323195003434807825501099066601447179054047533806579458;
        points[32] = 0.379208269116093669246681766939448880462121591351196609;
        points[33] = 0.433864067718761670309086568209780260743745852418403386;
        points[34] = 0.486966745698096077782458241346465556850455039719023688;
        points[35] = 0.538326209285827438375951167975356763823490141403080973;
        points[36] = 0.58775860497957906990202578155720422388122016653804349;
        points[37] = 0.635086977695245924298124579288809653593598988954989663;
        points[38] = 0.680141904227167702092238779736641007900996710165775916;
        points[39] = 0.72276209974998319367681667607193595478399390521472002;
        points[40] = 0.762794995193744960279211163089050840791830574507621547;
        points[41] = 0.800097283430468324334758754225807651197641858607701581;
        points[42] = 0.834535432326734534961726389621238685245936312669226053;
        points[43] = 0.865986162846067585244358517624206940898338952624290824;
        points[44] = 0.894336890534495322520844088263527555345580995562376493;
        points[45] = 0.919486128916424539893596376541881585029520272702472057;
        points[46] = 0.9413438536413590568435791838505670058287655454363192;
        points[47] = 0.959831826933086552532025153425065442787847476037677415;
        points[48] = 0.974883884221744503140706470399645554459923663945938398;
        points[49] = 0.986446195651549840645322859118397368022739035827326233;
        points[50] = 0.994477590929216029245043271799571706631911776097882171;
        points[51] = 0.998951111103950278090961440716592561278013261115357562;
        weights[0] = 0.00269131695004711111895217986884521802366937376106490042;
        weights[1] = 0.00625552396297327689971610216981454661641170465313125936;
        weights[2] = 0.00980263457946275206195116811668950232783841185727930527;
        weights[3] = 0.0133151149823409606566003444777991485546764997333043912;
        weights[4] = 0.016780023396300735677921536870520162083415809163818516;
        weights[5] = 0.0201848915079807922029890342094782372367124670848078202;
        weights[6] = 0.0235175135539844615903225199100546094292291290029855012;
        weights[7] = 0.0267659537465040134494930802860183788552618844990582873;
        weights[8] = 0.0299185811471439466412820687399708879321233155105875175;
        weights[9] = 0.0329641090897187979150100447786951961767273925745843488;
        weights[10] = 0.0358916348350972329419423932852807387853385030651726363;
        weights[11] = 0.0386906783104239789851012067403526469280782659935645861;
        weights[12] = 0.0413512195005602716790402864239551629382699693154642277;
        weights[13] = 0.043863734259000407995129665578764450164160666530204816;
        weights[14] = 0.0462192283727847935076457053352846392239010216264228405;
        weights[15] = 0.0484092697440748968539602492860462780097495217284633973;
        weights[16] = 0.050426018566342377218211254082858754462577958765539797;
        weights[17] = 0.0522622553839069930343941444263921437081990780858669849;
        weights[18] = 0.0539114069327572647508368248937999595766012469593051259;
        weights[19] = 0.0553675696693026525490410934512185822901540032510420234;
        weights[20] = 0.0566255309023685971908082404783701505672200728147146762;
        weights[21] = 0.0576807874525268276539319976634035195394398350513375845;
        weights[22] = 0.0585295617718138685502905989716236936380687327423255988;
        weights[23] = 0.0591688154660429703693320023948709783254170522175978798;
        weights[24] = 0.0595962601712481582583108787484149536622772803819419155;
        weights[25] = 0.0598103657452918602477853788114774609444808036304140629;
        weights[26] = 0.0598103657452918602477853788114774609444808036304140629;
        weights[27] = 0.0595962601712481582583108787484149536622772803819419155;
        weights[28] = 0.0591688154660429703693320023948709783254170522175978798;
        weights[29] = 0.0585295617718138685502905989716236936380687327423255988;
        weights[30] = 0.0576807874525268276539319976634035195394398350513375845;
        weights[31] = 0.0566255309023685971908082404783701505672200728147146762;
        weights[32] = 0.0553675696693026525490410934512185822901540032510420234;
        weights[33] = 0.0539114069327572647508368248937999595766012469593051259;
        weights[34] = 0.0522622553839069930343941444263921437081990780858669849;
        weights[35] = 0.050426018566342377218211254082858754462577958765539797;
        weights[36] = 0.0484092697440748968539602492860462780097495217284633973;
        weights[37] = 0.0462192283727847935076457053352846392239010216264228405;
        weights[38] = 0.043863734259000407995129665578764450164160666530204816;
        weights[39] = 0.0413512195005602716790402864239551629382699693154642277;
        weights[40] = 0.0386906783104239789851012067403526469280782659935645861;
        weights[41] = 0.0358916348350972329419423932852807387853385030651726363;
        weights[42] = 0.0329641090897187979150100447786951961767273925745843488;
        weights[43] = 0.0299185811471439466412820687399708879321233155105875175;
        weights[44] = 0.0267659537465040134494930802860183788552618844990582873;
        weights[45] = 0.0235175135539844615903225199100546094292291290029855012;
        weights[46] = 0.0201848915079807922029890342094782372367124670848078202;
        weights[47] = 0.016780023396300735677921536870520162083415809163818516;
        weights[48] = 0.0133151149823409606566003444777991485546764997333043912;
        weights[49] = 0.00980263457946275206195116811668950232783841185727930527;
        weights[50] = 0.00625552396297327689971610216981454661641170465313125936;
        weights[51] = 0.00269131695004711111895217986884521802366937376106490042;
        return;
    case 53:
        points[0] = -0.998989947776328227121054267032199522587309515651732544;
        points[1] = -0.994681919308007078636035893483993904182826594387975161;
        points[2] = -0.986947035023371521720373081310578188412199510179296258;
        points[3] = -0.975810233714984581632983858106362093512798003573911897;
        points[4] = -0.961309694623136332369858193682639747050422671972138;
        points[5] = -0.943495353464441879021070667696192775681857500148015665;
        points[6] = -0.922428603042812128267819100082516551349942542412314707;
        points[7] = -0.898182057875426625925520029973081195567045739001750682;
        points[8] = -0.870839297558241351601700086888594089821280167981174041;
        points[9] = -0.840494576545801375430127509829946796899962493735098169;
        points[10] = -0.807252498416895478220485638025907210177632560655530226;
        points[11] = -0.771227654925532307866035875626039741261354413619946772;
        points[12] = -0.73254423080751025378213558672175023156563327376066931;
        points[13] = -0.691335575601366723540748823138944565415495376404183951;
        points[14] = -0.647743743916510068751106189938633421813560044836402242;
        points[15] = -0.601919005713769327464294371964623613092953365731746375;
        points[16] = -0.554019328277067881014734990810049287255760837824321594;
        points[17] = -0.504209831657133437039116972887958033395462227703774726;
        points[18] = -0.452662219461845791383144760753315883620479588499372561;
        points[19] = -0.399554186953952977392563136238397571894511656706946257;
        points[20] = -0.345068808495722356694310646069500914856093345832935451;
        points[21] = -0.289393906451626206426547006594012767796057401466450231;
        points[22] = -0.232721403724272593643363642199916218526209311521638329;
        points[23] = -0.175246662155325750729791009132895245828916149942189115;
        points[24] = -0.117167809071955150140256808779323767923321052344431879;
        points[25] = -0.0586850543002594650227119458332315377355912839026442383;
        points[26] = 0;
        points[27] = 0.0586850543002594650227119458332315377355912839026442383;
        points[28] = 0.117167809071955150140256808779323767923321052344431879;
        points[29] = 0.175246662155325750729791009132895245828916149942189115;
        points[30] = 0.232721403724272593643363642199916218526209311521638329;
        points[31] = 0.289393906451626206426547006594012767796057401466450231;
        points[32] = 0.345068808495722356694310646069500914856093345832935451;
        points[33] = 0.399554186953952977392563136238397571894511656706946257;
        points[34] = 0.452662219461845791383144760753315883620479588499372561;
        points[35] = 0.504209831657133437039116972887958033395462227703774726;
        points[36] = 0.554019328277067881014734990810049287255760837824321594;
        points[37] = 0.601919005713769327464294371964623613092953365731746375;
        points[38] = 0.647743743916510068751106189938633421813560044836402242;
        points[39] = 0.691335575601366723540748823138944565415495376404183951;
        points[40] = 0.73254423080751025378213558672175023156563327376066931;
        points[41] = 0.771227654925532307866035875626039741261354413619946772;
        points[42] = 0.807252498416895478220485638025907210177632560655530226;
        points[43] = 0.840494576545801375430127509829946796899962493735098169;
        points[44] = 0.870839297558241351601700086888594089821280167981174041;
        points[45] = 0.898182057875426625925520029973081195567045739001750682;
        points[46] = 0.922428603042812128267819100082516551349942542412314707;
        points[47] = 0.943495353464441879021070667696192775681857500148015665;
        points[48] = 0.961309694623136332369858193682639747050422671972138;
        points[49] = 0.975810233714984581632983858106362093512798003573911897;
        points[50] = 0.986947035023371521720373081310578188412199510179296258;
        points[51] = 0.994681919308007078636035893483993904182826594387975161;
        points[52] = 0.998989947776328227121054267032199522587309515651732544;
        weights[0] = 0.00259168372056703181159923943851093098476299769302276968;
        weights[1] = 0.00602427622694867328124170681629985910095415207448441756;
        weights[2] = 0.00944120228494034438666217882032514328370781491404681093;
        weights[3] = 0.0128260261442403791791501829692037317681640087345531042;
        weights[4] = 0.0161667252566874639280608284040399014377347313970191805;
        weights[5] = 0.0194517211076368953880469222274969404194473647164936671;
        weights[6] = 0.0226696730570702083987892752398278094682488078051167845;
        weights[7] = 0.0258094825107575177139618881666294409037504184422655036;
        weights[8] = 0.0288603236178237362627995530435832618626692062898485273;
        weights[9] = 0.0318116784590193230632358620310809202606800700870432844;
        weights[10] = 0.034653372583534237958387720513010713571317935430580936;
        weights[11] = 0.0373756098034829156741719727853942222098480943725185586;
        weights[12] = 0.0399690058435403821270935457878636259190084633749648655;
        weights[13] = 0.0424246206345200135922816375684503988065642079754230073;
        weights[14] = 0.0447339891036728102127656459185636061376018837171479008;
        weights[15] = 0.0468891503407503140218726395651049478658255358333036262;
        weights[16] = 0.0488826750326991404204484075835840834065845146462682929;
        weights[17] = 0.0507076910692927152964854826345305375999903733365938147;
        weights[18] = 0.0523579072298727181997015209893607044544197086972156836;
        weights[19] = 0.0538276348687310290420814416354026743128101996789120203;
        weights[20] = 0.0551118075239335990023497047658673875514124884898266221;
        weights[21] = 0.0562059983817397098086550620914449937514572251748036418;
        weights[22] = 0.0571064355362671917733833392984188413388344954246130617;
        weights[23] = 0.057810014991713196319683076097252062860029011238475865;
        weights[24] = 0.0583143113622560075562757563376972560520799512442547357;
        weights[25] = 0.0586175862327202633180719370499889415345994806622769869;
        weights[26] = 0.0587187941511643645254869444421341262749937170978526623;
        weights[27] = 0.0586175862327202633180719370499889415345994806622769869;
        weights[28] = 0.0583143113622560075562757563376972560520799512442547357;
        weights[29] = 0.057810014991713196319683076097252062860029011238475865;
        weights[30] = 0.0571064355362671917733833392984188413388344954246130617;
        weights[31] = 0.0562059983817397098086550620914449937514572251748036418;
        weights[32] = 0.0551118075239335990023497047658673875514124884898266221;
        weights[33] = 0.0538276348687310290420814416354026743128101996789120203;
        weights[34] = 0.0523579072298727181997015209893607044544197086972156836;
        weights[35] = 0.0507076910692927152964854826345305375999903733365938147;
        weights[36] = 0.0488826750326991404204484075835840834065845146462682929;
        weights[37] = 0.0468891503407503140218726395651049478658255358333036262;
        weights[38] = 0.0447339891036728102127656459185636061376018837171479008;
        weights[39] = 0.0424246206345200135922816375684503988065642079754230073;
        weights[40] = 0.0399690058435403821270935457878636259190084633749648655;
        weights[41] = 0.0373756098034829156741719727853942222098480943725185586;
        weights[42] = 0.034653372583534237958387720513010713571317935430580936;
        weights[43] = 0.0318116784590193230632358620310809202606800700870432844;
        weights[44] = 0.0288603236178237362627995530435832618626692062898485273;
        weights[45] = 0.0258094825107575177139618881666294409037504184422655036;
        weights[46] = 0.0226696730570702083987892752398278094682488078051167845;
        weights[47] = 0.0194517211076368953880469222274969404194473647164936671;
        weights[48] = 0.0161667252566874639280608284040399014377347313970191805;
        weights[49] = 0.0128260261442403791791501829692037317681640087345531042;
        weights[50] = 0.00944120228494034438666217882032514328370781491404681093;
        weights[51] = 0.00602427622694867328124170681629985910095415207448441756;
        weights[52] = 0.00259168372056703181159923943851093098476299769302276968;
        return;
    case 54:
        points[0] = -0.999026666867340983851071106983958493198042785796960332;
        points[1] = -0.994875117018338884918889995948702659484126758886999829;
        points[2] = -0.987420637397343558552145720403546261534036290839238588;
        points[3] = -0.976686328857903237200010071988306857467805973240003412;
        points[4] = -0.96270764578592358325699392690538994353691817470203757;
        points[5] = -0.945530975164995853763837022906180412563436588500986407;
        points[6] = -0.925213359866651486256276060479791386855584193566834244;
        points[7] = -0.901822286284701580757467231388427964363928404788918474;
        points[8] = -0.875435454065568939417909335722610822486547484807016172;
        points[9] = -0.846140515970772949425887510872842500396632380214141657;
        points[10] = -0.814034785913567835469638304075198944827590183233613975;
        points[11] = -0.779224915346254021535948614840532655748889094829050259;
        points[12] = -0.741826538809184316285766268753578000939729144982815603;
        points[13] = -0.701963889719172919385570976969670601268811110489679439;
        points[14] = -0.659769387631983124692289822856220474788958248594975049;
        points[15] = -0.615383198331127370729937820161728300595972694129498622;
        points[16] = -0.568952768195209429731624834177153942773841437174211619;
        points[17] = -0.52063233438593307332701713874976411887936685525087922;
        points[18] = -0.470582412481382283683212136327742602431446639814420044;
        points[19] = -0.418969263255204528036102697462510005200790183425047583;
        points[20] = -0.3659643403721911819843321081654874061220373897036416;
        points[21] = -0.311743720834468228882550390152123771392948497110182017;
        points[22] = -0.256487520069997300077411214453008302726921873090774152;
        points[23] = -0.200379293606213569778602462829298030454143186091550919;
        points[24] = -0.143605427316256153947089762898789161294705016260067741;
        points[25] = -0.0863545182632482152854431777687496363694015374870635879;
        points[26] = -0.0288167481993417776562358475002270529894545421779078484;
        points[27] = 0.0288167481993417776562358475002270529894545421779078484;
        points[28] = 0.0863545182632482152854431777687496363694015374870635879;
        points[29] = 0.143605427316256153947089762898789161294705016260067741;
        points[30] = 0.200379293606213569778602462829298030454143186091550919;
        points[31] = 0.256487520069997300077411214453008302726921873090774152;
        points[32] = 0.311743720834468228882550390152123771392948497110182017;
        points[33] = 0.3659643403721911819843321081654874061220373897036416;
        points[34] = 0.418969263255204528036102697462510005200790183425047583;
        points[35] = 0.470582412481382283683212136327742602431446639814420044;
        points[36] = 0.52063233438593307332701713874976411887936685525087922;
        points[37] = 0.568952768195209429731624834177153942773841437174211619;
        points[38] = 0.615383198331127370729937820161728300595972694129498622;
        points[39] = 0.659769387631983124692289822856220474788958248594975049;
        points[40] = 0.701963889719172919385570976969670601268811110489679439;
        points[41] = 0.741826538809184316285766268753578000939729144982815603;
        points[42] = 0.779224915346254021535948614840532655748889094829050259;
        points[43] = 0.814034785913567835469638304075198944827590183233613975;
        points[44] = 0.846140515970772949425887510872842500396632380214141657;
        points[45] = 0.875435454065568939417909335722610822486547484807016172;
        points[46] = 0.901822286284701580757467231388427964363928404788918474;
        points[47] = 0.925213359866651486256276060479791386855584193566834244;
        points[48] = 0.945530975164995853763837022906180412563436588500986407;
        points[49] = 0.96270764578592358325699392690538994353691817470203757;
        points[50] = 0.976686328857903237200010071988306857467805973240003412;
        points[51] = 0.987420637397343558552145720403546261534036290839238588;
        points[52] = 0.994875117018338884918889995948702659484126758886999829;
        points[53] = 0.999026666867340983851071106983958493198042785796960332;
        weights[0] = 0.00249748183576158577594603875726602987918509746682711194;
        weights[1] = 0.00580561101523998487882588774587527341152465198940366679;
        weights[2] = 0.00909936945550939694803352106241926172187472240798218021;
        weights[3] = 0.012363328128847644166467824260188096463994498948433693;
        weights[4] = 0.0155863030359241317029689097058367654685878223576398962;
        weights[5] = 0.0187575276214693779120079842840711626886355747427113428;
        weights[6] = 0.0218664514228530859455104265388793009815703165629724421;
        weights[7] = 0.0249027414672087730500549712733890425756231328791233604;
        weights[8] = 0.0278563093105958702870020347639151512373099356257426966;
        weights[9] = 0.0307173424978706760540046099161549110199622120771604655;
        weights[10] = 0.033476336464372645716040444835610792714878607423683773;
        weights[11] = 0.0361241258403835525828870742074248459785730799301673299;
        weights[12] = 0.038651914782102516836857139051579876239011509355728554;
        weights[13] = 0.0410513061366449742217182108776043341937827974464546888;
        weights[14] = 0.0433143293095970154419257603705081181962891240438496887;
        weights[15] = 0.0454334667282767139748521807515445715337756390176710815;
        weights[16] = 0.0474016788064449910585764101153236036382065889832506088;
        weights[17] = 0.0492124273245288860687906303688116280775041129800626816;
        weights[18] = 0.0508596971461881443197092069761187459120602653893317148;
        weights[19] = 0.0523380161982987446655886947526850131804317669734681029;
        weights[20] = 0.0536424736475536112721006277252465768628158596085654399;
        weights[21] = 0.0547687362130579863062226347171090207246210665623550486;
        weights[22] = 0.0557130625605899876833698174273711106847117171157984779;
        weights[23] = 0.0564723157306259650310442646817612479537373621270836423;
        weights[24] = 0.0570439735587945985678284342542272120992117362125463539;
        weights[25] = 0.0574261370541121148592901317732068293892190570504253857;
        weights[26] = 0.0576175367071470246723761288058714771729017447215605723;
        weights[27] = 0.0576175367071470246723761288058714771729017447215605723;
        weights[28] = 0.0574261370541121148592901317732068293892190570504253857;
        weights[29] = 0.0570439735587945985678284342542272120992117362125463539;
        weights[30] = 0.0564723157306259650310442646817612479537373621270836423;
        weights[31] = 0.0557130625605899876833698174273711106847117171157984779;
        weights[32] = 0.0547687362130579863062226347171090207246210665623550486;
        weights[33] = 0.0536424736475536112721006277252465768628158596085654399;
        weights[34] = 0.0523380161982987446655886947526850131804317669734681029;
        weights[35] = 0.0508596971461881443197092069761187459120602653893317148;
        weights[36] = 0.0492124273245288860687906303688116280775041129800626816;
        weights[37] = 0.0474016788064449910585764101153236036382065889832506088;
        weights[38] = 0.0454334667282767139748521807515445715337756390176710815;
        weights[39] = 0.0433143293095970154419257603705081181962891240438496887;
        weights[40] = 0.0410513061366449742217182108776043341937827974464546888;
        weights[41] = 0.038651914782102516836857139051579876239011509355728554;
        weights[42] = 0.0361241258403835525828870742074248459785730799301673299;
        weights[43] = 0.033476336464372645716040444835610792714878607423683773;
        weights[44] = 0.0307173424978706760540046099161549110199622120771604655;
        weights[45] = 0.0278563093105958702870020347639151512373099356257426966;
        weights[46] = 0.0249027414672087730500549712733890425756231328791233604;
        weights[47] = 0.0218664514228530859455104265388793009815703165629724421;
        weights[48] = 0.0187575276214693779120079842840711626886355747427113428;
        weights[49] = 0.0155863030359241317029689097058367654685878223576398962;
        weights[50] = 0.012363328128847644166467824260188096463994498948433693;
        weights[51] = 0.00909936945550939694803352106241926172187472240798218021;
        weights[52] = 0.00580561101523998487882588774587527341152465198940366679;
        weights[53] = 0.00249748183576158577594603875726602987918509746682711194;
        return;
    case 55:
        points[0] = -0.999061419564818541479431839519384423155541278929420157;
        points[1] = -0.99505797784741187504318911650620237159410074640539225;
        points[2] = -0.98786894119888919852238568447347353064860155505648643;
        points[3] = -0.977515735503989208859216606340730211542135462755569801;
        points[4] = -0.964031328593135198778536631377369222637489674164126656;
        points[5] = -0.947458868041210741859979847645291837175186326297240787;
        points[6] = -0.927851424720791696816271269232586379194499280569601184;
        points[7] = -0.905271800744000025781911424629624392227608588470290593;
        points[8] = -0.879792322419895506067590906824086395299913621625734477;
        points[9] = -0.851494606617154471460245320967007027816463989402732402;
        points[10] = -0.820469298559320912454241285034722365392967480105130606;
        points[11] = -0.786815781127622365897636250938041383509091146272250529;
        points[12] = -0.750641856348021908674987682707310917922063464462257535;
        points[13] = -0.712063399986637838909350192121167515172653723145173514;
        points[14] = -0.671203990319826395796326728006015600573927277436610607;
        points[15] = -0.628194512249928140090636215032975432911010309006757968;
        points[16] = -0.583172738026032102974304815587686486221861136254785674;
        points[17] = -0.536282885908343296720599572843597553538275608838743915;
        points[18] = -0.487675158187474097208263673539355611507554019569348864;
        points[19] = -0.437505260037174591808481024297466584242516289220592545;
        points[20] = -0.385933900740979429755848543912589975450407086515743056;
        points[21] = -0.333126278890023885189471490232961963047398261922712874;
        points[22] = -0.279251553200806538549862451175671025558185946282972635;
        points[23] = -0.22448230064784548340018906240292645440811700470895206;
        points[24] = -0.168993963646873208282842493511702229345893529573876111;
        points[25] = -0.112964288059329266588437923888712184012038893009333007;
        points[26] = -0.0565727538183367763273376108931084341626757424523121837;
        points[27] = 0;
        points[28] = 0.0565727538183367763273376108931084341626757424523121837;
        points[29] = 0.112964288059329266588437923888712184012038893009333007;
        points[30] = 0.168993963646873208282842493511702229345893529573876111;
        points[31] = 0.22448230064784548340018906240292645440811700470895206;
        points[32] = 0.279251553200806538549862451175671025558185946282972635;
        points[33] = 0.333126278890023885189471490232961963047398261922712874;
        points[34] = 0.385933900740979429755848543912589975450407086515743056;
        points[35] = 0.437505260037174591808481024297466584242516289220592545;
        points[36] = 0.487675158187474097208263673539355611507554019569348864;
        points[37] = 0.536282885908343296720599572843597553538275608838743915;
        points[38] = 0.583172738026032102974304815587686486221861136254785674;
        points[39] = 0.628194512249928140090636215032975432911010309006757968;
        points[40] = 0.671203990319826395796326728006015600573927277436610607;
        points[41] = 0.712063399986637838909350192121167515172653723145173514;
        points[42] = 0.750641856348021908674987682707310917922063464462257535;
        points[43] = 0.786815781127622365897636250938041383509091146272250529;
        points[44] = 0.820469298559320912454241285034722365392967480105130606;
        points[45] = 0.851494606617154471460245320967007027816463989402732402;
        points[46] = 0.879792322419895506067590906824086395299913621625734477;
        points[47] = 0.905271800744000025781911424629624392227608588470290593;
        points[48] = 0.927851424720791696816271269232586379194499280569601184;
        points[49] = 0.947458868041210741859979847645291837175186326297240787;
        points[50] = 0.964031328593135198778536631377369222637489674164126656;
        points[51] = 0.977515735503989208859216606340730211542135462755569801;
        points[52] = 0.98786894119888919852238568447347353064860155505648643;
        points[53] = 0.99505797784741187504318911650620237159410074640539225;
        points[54] = 0.999061419564818541479431839519384423155541278929420157;
        weights[0] = 0.00240832361997978881917019348912527870416962754170570552;
        weights[1] = 0.00559863226656076735408341687185985724515129524166676;
        weights[2] = 0.0087757461070585281773896006833178381644564407606959352;
        weights[3] = 0.0119251607198486121707525531575898882926403474479889492;
        weights[4] = 0.0150364583335117882131508989019372817118222494995358176;
        weights[5] = 0.0180996145207290624079682026434122304027784945375529721;
        weights[6] = 0.0211048016680164541202093056236983344809343740619170514;
        weights[7] = 0.0240423880097256220077915729286034584992461505618308091;
        weights[8] = 0.0269029614563962706671200286537790971433766611326800207;
        weights[9] = 0.0296773577651610412212965061868853602298586405943297351;
        weights[10] = 0.0323566892261858316847055918757768657576683950311935041;
        weights[11] = 0.034932372873589887407268226802706487974287461289662762;
        weights[12] = 0.037396157867965545282915598582457549515103401503920991;
        weights[13] = 0.0397401518743371796094638319033998358680268513816859788;
        weights[14] = 0.0419568463177187623952073166921441225765663582207783523;
        weights[15] = 0.0440391404216065898951680856532928731346290449452904751;
        weights[16] = 0.0459803639462838381039048608720746681221111540908620405;
        weights[17] = 0.0477742985512006955500367147160559256338183071442882368;
        weights[18] = 0.0494151977115517394807585390160392756818815553283152874;
        weights[19] = 0.0508978051244939792247752742880834388216855409146710738;
        weights[20] = 0.0522173715456320845643935632812950099667420858053508795;
        weights[21] = 0.0533696700016054727235705156360978537270000631466828584;
        weights[22] = 0.0543510093299111020703221181537721488058133091086900951;
        weights[23] = 0.0551582460025086875966511395606667214325306373972057271;
        weights[24] = 0.0557887941952840871029360071099197146724675353885833224;
        weights[25] = 0.0562406340710843680282790880901978272760612597138630147;
        weights[26] = 0.0565123182497720014006583676351890541396881831582519156;
        weights[27] = 0.0566029764445604254401057619812440040389691501015994589;
        weights[28] = 0.0565123182497720014006583676351890541396881831582519156;
        weights[29] = 0.0562406340710843680282790880901978272760612597138630147;
        weights[30] = 0.0557887941952840871029360071099197146724675353885833224;
        weights[31] = 0.0551582460025086875966511395606667214325306373972057271;
        weights[32] = 0.0543510093299111020703221181537721488058133091086900951;
        weights[33] = 0.0533696700016054727235705156360978537270000631466828584;
        weights[34] = 0.0522173715456320845643935632812950099667420858053508795;
        weights[35] = 0.0508978051244939792247752742880834388216855409146710738;
        weights[36] = 0.0494151977115517394807585390160392756818815553283152874;
        weights[37] = 0.0477742985512006955500367147160559256338183071442882368;
        weights[38] = 0.0459803639462838381039048608720746681221111540908620405;
        weights[39] = 0.0440391404216065898951680856532928731346290449452904751;
        weights[40] = 0.0419568463177187623952073166921441225765663582207783523;
        weights[41] = 0.0397401518743371796094638319033998358680268513816859788;
        weights[42] = 0.037396157867965545282915598582457549515103401503920991;
        weights[43] = 0.034932372873589887407268226802706487974287461289662762;
        weights[44] = 0.0323566892261858316847055918757768657576683950311935041;
        weights[45] = 0.0296773577651610412212965061868853602298586405943297351;
        weights[46] = 0.0269029614563962706671200286537790971433766611326800207;
        weights[47] = 0.0240423880097256220077915729286034584992461505618308091;
        weights[48] = 0.0211048016680164541202093056236983344809343740619170514;
        weights[49] = 0.0180996145207290624079682026434122304027784945375529721;
        weights[50] = 0.0150364583335117882131508989019372817118222494995358176;
        weights[51] = 0.0119251607198486121707525531575898882926403474479889492;
        weights[52] = 0.0087757461070585281773896006833178381644564407606959352;
        weights[53] = 0.00559863226656076735408341687185985724515129524166676;
        weights[54] = 0.00240832361997978881917019348912527870416962754170570552;
        return;
    case 56:
        points[0] = -0.99909434380146558435315382509090426217601897845975637;
        points[1] = -0.995231226081069747216308760098940945548538455233990375;
        points[2] = -0.988293715540161511089925163523486216764541143224616165;
        points[3] = -0.978301709140256383376990551538188131227013897750228424;
        points[4] = -0.965285901905490183626194976055095698217551218657663428;
        points[5] = -0.949286479561962635646737602794928066889563522588144522;
        points[6] = -0.930352880247496300547272723291600853026814305996895027;
        points[7] = -0.908543620420655490846107289957241779532211068809586916;
        points[8] = -0.883926108327827540789012285809286727505981410232089252;
        points[9] = -0.856576433762748635402991386766870604073674174709864281;
        points[10] = -0.826579132142881651672126974456850323343042175963860086;
        points[11] = -0.794026922893866498030008308486000477657203301683242045;
        points[12] = -0.759020422705128902202413294445893867364837249273649469;
        points[13] = -0.721667834450188083522593787047553457344048519285738254;
        points[14] = -0.682084612694470455501561477969836333105109367461210194;
        points[15] = -0.640393106807006894267938596062813078923806572947805831;
        points[16] = -0.596722182770663320104135217138408383220500869241944365;
        points[17] = -0.551206824855534618754363514576316602525662578352490243;
        points[18] = -0.503987718384381714195224401218638137709305949354017502;
        points[19] = -0.45521081487845957894883158132460955990722690550390788;
        points[20] = -0.405026880927091278118866962602922894655371382368290726;
        points[21] = -0.353591032174954520969707327033232405634678794381171976;
        points[22] = -0.301062253867220669053094233125234343925071846124383471;
        points[23] = -0.247602909434337203972966554970526972879663243142767006;
        points[24] = -0.193378238635275258240184723012684161816167392763801259;
        points[25] = -0.138555846810376242012886580438490595351490508462528551;
        points[26] = -0.0833051868224353744402873554406624481839874141890305459;
        points[27] = -0.0277970352872754370940611967749205218883766031467744878;
        points[28] = 0.0277970352872754370940611967749205218883766031467744878;
        points[29] = 0.0833051868224353744402873554406624481839874141890305459;
        points[30] = 0.138555846810376242012886580438490595351490508462528551;
        points[31] = 0.193378238635275258240184723012684161816167392763801259;
        points[32] = 0.247602909434337203972966554970526972879663243142767006;
        points[33] = 0.301062253867220669053094233125234343925071846124383471;
        points[34] = 0.353591032174954520969707327033232405634678794381171976;
        points[35] = 0.405026880927091278118866962602922894655371382368290726;
        points[36] = 0.45521081487845957894883158132460955990722690550390788;
        points[37] = 0.503987718384381714195224401218638137709305949354017502;
        points[38] = 0.551206824855534618754363514576316602525662578352490243;
        points[39] = 0.596722182770663320104135217138408383220500869241944365;
        points[40] = 0.640393106807006894267938596062813078923806572947805831;
        points[41] = 0.682084612694470455501561477969836333105109367461210194;
        points[42] = 0.721667834450188083522593787047553457344048519285738254;
        points[43] = 0.759020422705128902202413294445893867364837249273649469;
        points[44] = 0.794026922893866498030008308486000477657203301683242045;
        points[45] = 0.826579132142881651672126974456850323343042175963860086;
        points[46] = 0.856576433762748635402991386766870604073674174709864281;
        points[47] = 0.883926108327827540789012285809286727505981410232089252;
        points[48] = 0.908543620420655490846107289957241779532211068809586916;
        points[49] = 0.930352880247496300547272723291600853026814305996895027;
        points[50] = 0.949286479561962635646737602794928066889563522588144522;
        points[51] = 0.965285901905490183626194976055095698217551218657663428;
        points[52] = 0.978301709140256383376990551538188131227013897750228424;
        points[53] = 0.988293715540161511089925163523486216764541143224616165;
        points[54] = 0.995231226081069747216308760098940945548538455233990375;
        points[55] = 0.99909434380146558435315382509090426217601897845975637;
        weights[0] = 0.00232385537577321550110227644339586473759320991735859403;
        weights[1] = 0.00540252224601533776131126094412087284162781818411397736;
        weights[2] = 0.00846906316330788766162711237500816017607748757412691595;
        weights[3] = 0.0115098243403833821737727593244971192748559048179691436;
        weights[4] = 0.0145150892780214718077707405330129910240961984992442576;
        weights[5] = 0.01747551291140094650495936890545715023078028057687649;
        weights[6] = 0.0203819298824025726348059836669333475071194643986120085;
        weights[7] = 0.0232253515625653169372581575767885265557220198245790044;
        weights[8] = 0.0259969870583919521918194322072723514480102520506943594;
        weights[9] = 0.0286882684738227417298858844303942726041341370468452294;
        weights[10] = 0.0312908767473104478678354777930253469778460131872277166;
        weights[11] = 0.0337967671156117612954266312254470498176070716782671452;
        weights[12] = 0.0361981938723151860358844682888862454006302346723142169;
        weights[13] = 0.0384877342592476624868255916233812793438196346814820133;
        weights[14] = 0.0406583113847445178801250227788527630755422730490527223;
        weights[15] = 0.0427032160846670865110385723624770808934709459666175749;
        weights[16] = 0.0446161276526922832134151929276237403258464384162967042;
        weights[17] = 0.0463911333730018967621901910664960342346098061005004903;
        weights[18] = 0.0480227467936002581207355056669997121440168767700242701;
        weights[19] = 0.049505924683047578919966046430845556418718849071317996;
        weights[20] = 0.0508360826177984805601240184701986559829916379320842155;
        weights[21] = 0.0520091091517413998430522648274847216705325853129013584;
        weights[22] = 0.0530213785240107639679915586076914687273814340810240065;
        weights[23] = 0.0538697618657144857089544104066979942479245356718882474;
        weights[24] = 0.0545516368708894210617506548900901799440607237809163526;
        weights[25] = 0.0550648959017624257963045975478503253413555128006590126;
        weights[26] = 0.055407952503245123217793391843910018909562031380663018;
        weights[27] = 0.055579746306514395846273426835161170144066622556342959;
        weights[28] = 0.055579746306514395846273426835161170144066622556342959;
        weights[29] = 0.055407952503245123217793391843910018909562031380663018;
        weights[30] = 0.0550648959017624257963045975478503253413555128006590126;
        weights[31] = 0.0545516368708894210617506548900901799440607237809163526;
        weights[32] = 0.0538697618657144857089544104066979942479245356718882474;
        weights[33] = 0.0530213785240107639679915586076914687273814340810240065;
        weights[34] = 0.0520091091517413998430522648274847216705325853129013584;
        weights[35] = 0.0508360826177984805601240184701986559829916379320842155;
        weights[36] = 0.049505924683047578919966046430845556418718849071317996;
        weights[37] = 0.0480227467936002581207355056669997121440168767700242701;
        weights[38] = 0.0463911333730018967621901910664960342346098061005004903;
        weights[39] = 0.0446161276526922832134151929276237403258464384162967042;
        weights[40] = 0.0427032160846670865110385723624770808934709459666175749;
        weights[41] = 0.0406583113847445178801250227788527630755422730490527223;
        weights[42] = 0.0384877342592476624868255916233812793438196346814820133;
        weights[43] = 0.0361981938723151860358844682888862454006302346723142169;
        weights[44] = 0.0337967671156117612954266312254470498176070716782671452;
        weights[45] = 0.0312908767473104478678354777930253469778460131872277166;
        weights[46] = 0.0286882684738227417298858844303942726041341370468452294;
        weights[47] = 0.0259969870583919521918194322072723514480102520506943594;
        weights[48] = 0.0232253515625653169372581575767885265557220198245790044;
        weights[49] = 0.0203819298824025726348059836669333475071194643986120085;
        weights[50] = 0.01747551291140094650495936890545715023078028057687649;
        weights[51] = 0.0145150892780214718077707405330129910240961984992442576;
        weights[52] = 0.0115098243403833821737727593244971192748559048179691436;
        weights[53] = 0.00846906316330788766162711237500816017607748757412691595;
        weights[54] = 0.00540252224601533776131126094412087284162781818411397736;
        weights[55] = 0.00232385537577321550110227644339586473759320991735859403;
        return;
    case 57:
        points[0] = -0.999125565625262850572009849554249884999127586007013575;
        points[1] = -0.995395523678430311135125027362419005975068868913413964;
        points[2] = -0.988696577650222048849758398383855438510084086698944006;
        points[3] = -0.979047226709468713798820875366507757360931223767780685;
        points[4] = -0.96647608517188667911485858394233318896849009450238562;
        points[5] = -0.951020626447876741911904110605190328637799339662690428;
        points[6] = -0.932726961067101696100754154297356638067488635116634849;
        points[7] = -0.911649678521391212728430561619670310918248410397413302;
        points[8] = -0.887851678882221329513000147641861716134275787267035282;
        points[9] = -0.861403983262046944722241881805214754221933005613239618;
        points[10] = -0.832385521150439120829010895865203218252265650096639455;
        points[11] = -0.800882894547218242076008718794948567701803620155421602;
        points[12] = -0.766990119359450195491716144018132355236648415822398243;
        points[13] = -0.730808344744523322827344670736778316263122119509612203;
        points[14] = -0.69244555119951773904048368844401044565667663461414289;
        points[15] = -0.65201622828097689124936184079570828367066055697215481;
        points[16] = -0.609641032908715365423848901924740624324000572923964614;
        points[17] = -0.565446429269236759018985552805240429370022074221579729;
        points[18] = -0.519564311391187606315153819806214351080631108269511806;
        points[19] = -0.472131609517975709588060082049234749822237925699326685;
        points[20] = -0.42328988145156395096002435347152437901405095213458829;
        points[21] = -0.373184890086594458552134396144889010556460146092633534;
        points[22] = -0.321966168395378640590207915805397239372739467662806316;
        points[23] = -0.269786573161838765763345609799643344299057994351474759;
        points[24] = -0.216801828796124036413613975979559274256583295504472438;
        points[25] = -0.163170062591264251043280378321512062185909989303105714;
        points[26] = -0.109051332808787800978526521310979049455045137501671027;
        points[27] = -0.0546071510016468242198305597373324454104423343597207808;
        points[28] = 0;
        points[29] = 0.0546071510016468242198305597373324454104423343597207808;
        points[30] = 0.109051332808787800978526521310979049455045137501671027;
        points[31] = 0.163170062591264251043280378321512062185909989303105714;
        points[32] = 0.216801828796124036413613975979559274256583295504472438;
        points[33] = 0.269786573161838765763345609799643344299057994351474759;
        points[34] = 0.321966168395378640590207915805397239372739467662806316;
        points[35] = 0.373184890086594458552134396144889010556460146092633534;
        points[36] = 0.42328988145156395096002435347152437901405095213458829;
        points[37] = 0.472131609517975709588060082049234749822237925699326685;
        points[38] = 0.519564311391187606315153819806214351080631108269511806;
        points[39] = 0.565446429269236759018985552805240429370022074221579729;
        points[40] = 0.609641032908715365423848901924740624324000572923964614;
        points[41] = 0.65201622828097689124936184079570828367066055697215481;
        points[42] = 0.69244555119951773904048368844401044565667663461414289;
        points[43] = 0.730808344744523322827344670736778316263122119509612203;
        points[44] = 0.766990119359450195491716144018132355236648415822398243;
        points[45] = 0.800882894547218242076008718794948567701803620155421602;
        points[46] = 0.832385521150439120829010895865203218252265650096639455;
        points[47] = 0.861403983262046944722241881805214754221933005613239618;
        points[48] = 0.887851678882221329513000147641861716134275787267035282;
        points[49] = 0.911649678521391212728430561619670310918248410397413302;
        points[50] = 0.932726961067101696100754154297356638067488635116634849;
        points[51] = 0.951020626447876741911904110605190328637799339662690428;
        points[52] = 0.96647608517188667911485858394233318896849009450238562;
        points[53] = 0.979047226709468713798820875366507757360931223767780685;
        points[54] = 0.988696577650222048849758398383855438510084086698944006;
        points[55] = 0.995395523678430311135125027362419005975068868913413964;
        points[56] = 0.999125565625262850572009849554249884999127586007013575;
        weights[0] = 0.00224375387225066290973478682263501388626751860515453919;
        weights[1] = 0.00521653347471877939050662987142008532303141539042764462;
        weights[2] = 0.00817816006782123262621099813037940186470942609118705156;
        weights[3] = 0.0111157637323359901456754487681900391395904333631786221;
        weights[4] = 0.0140202707907535561702471513381502513228268482238128456;
        weights[5] = 0.0168829590234415490350008215668332764463059650200004404;
        weights[6] = 0.0196952706994885203824224522735148584246970405778395012;
        weights[7] = 0.0224488078907764380796892388450908804387962019606627317;
        weights[8] = 0.0251353509909181226472737881409554879758809126073346053;
        weights[9] = 0.0277468814021801923212579500383637591696208463159952618;
        weights[10] = 0.0302756048426939994584905988331372111851184545053376682;
        weights[11] = 0.0327139743663715685424901099103934982845747686389306711;
        weights[12] = 0.0350547127823126175057509705965500644569012556759409018;
        weights[13] = 0.0372908343244173173547352639956989655539698724087680564;
        weights[14] = 0.0394156654754801140899527208010555042508151727322945731;
        weights[15] = 0.0414228648708011103631969052736104309601351140912015419;
        weights[16] = 0.0433064422162151965964321083284261257043646513427258084;
        weights[17] = 0.0450607761613811577972135295258329703541113366416026742;
        weights[18] = 0.0466806310736415037838408927788335708830549965242929779;
        weights[19] = 0.0481611726616877512688510517568167367162428543195299778;
        weights[20] = 0.0494979824020196789938379444993879262646728960762586854;
        weights[21] = 0.0506870707249274086566404255636365795531047987116499536;
        weights[22] = 0.0517248889205178247206239086651469806258692764894542553;
        weights[23] = 0.0526083397291774324402313816408841896252559164289825928;
        weights[24] = 0.0533347865848191584265769779914406250959470462378439373;
        weights[25] = 0.0539020614832985746428094817306014534866276745873407168;
        weights[26] = 0.0543084714524986431387467729547915602633775761284777724;
        weights[27] = 0.0545528036047618864801389953641965144760153482295025391;
        weights[28] = 0.0546343287565840240628413879880520765362287641485429065;
        weights[29] = 0.0545528036047618864801389953641965144760153482295025391;
        weights[30] = 0.0543084714524986431387467729547915602633775761284777724;
        weights[31] = 0.0539020614832985746428094817306014534866276745873407168;
        weights[32] = 0.0533347865848191584265769779914406250959470462378439373;
        weights[33] = 0.0526083397291774324402313816408841896252559164289825928;
        weights[34] = 0.0517248889205178247206239086651469806258692764894542553;
        weights[35] = 0.0506870707249274086566404255636365795531047987116499536;
        weights[36] = 0.0494979824020196789938379444993879262646728960762586854;
        weights[37] = 0.0481611726616877512688510517568167367162428543195299778;
        weights[38] = 0.0466806310736415037838408927788335708830549965242929779;
        weights[39] = 0.0450607761613811577972135295258329703541113366416026742;
        weights[40] = 0.0433064422162151965964321083284261257043646513427258084;
        weights[41] = 0.0414228648708011103631969052736104309601351140912015419;
        weights[42] = 0.0394156654754801140899527208010555042508151727322945731;
        weights[43] = 0.0372908343244173173547352639956989655539698724087680564;
        weights[44] = 0.0350547127823126175057509705965500644569012556759409018;
        weights[45] = 0.0327139743663715685424901099103934982845747686389306711;
        weights[46] = 0.0302756048426939994584905988331372111851184545053376682;
        weights[47] = 0.0277468814021801923212579500383637591696208463159952618;
        weights[48] = 0.0251353509909181226472737881409554879758809126073346053;
        weights[49] = 0.0224488078907764380796892388450908804387962019606627317;
        weights[50] = 0.0196952706994885203824224522735148584246970405778395012;
        weights[51] = 0.0168829590234415490350008215668332764463059650200004404;
        weights[52] = 0.0140202707907535561702471513381502513228268482238128456;
        weights[53] = 0.0111157637323359901456754487681900391395904333631786221;
        weights[54] = 0.00817816006782123262621099813037940186470942609118705156;
        weights[55] = 0.00521653347471877939050662987142008532303141539042764462;
        weights[56] = 0.00224375387225066290973478682263501388626751860515453919;
        return;
    case 58:
        points[0] = -0.999155200407386606442737044184605761045813585872715631;
        points[1] = -0.995551476597290902602771526179946141276967280242974881;
        points[2] = -0.989079008248442636499910255275442056883205365501321505;
        points[3] = -0.979755014694350309107816334392598034869875945691289139;
        points[4] = -0.96760620250292409015330078462120619491287277499442596;
        points[5] = -0.952667557518869091442845510022930333705587628975491226;
        points[6] = -0.934982137588259348480843234766247495409147422744563944;
        points[7] = -0.914600928564352540686505649897521820495615095425406115;
        points[8] = -0.891582692022030176399882820812797546482551849941030649;
        points[9] = -0.865993794074807479275071232512087657694274148605561063;
        points[10] = -0.837908013339373316352097920621624361286867305697942394;
        points[11] = -0.807406327913088141048997152207395227983283424010130542;
        points[12] = -0.774576681749652745266140046496826665648970000627280787;
        points[13] = -0.73951373102004226784661723485103279097065744804820353;
        points[14] = -0.702318571153908113479757301458201383660685816647606889;
        points[15] = -0.663098445332125266433016299753565691960643624304121991;
        points[16] = -0.621966435263079111033984058745491120232235253849255085;
        points[17] = -0.579041135130225030489977117136083403820176816683960341;
        points[18] = -0.534446309648847586399802417425204355788763287356337084;
        points[19] = -0.488310537216718463615552572736785420894228720802451279;
        points[20] = -0.440766839186839565193703062214304414122414801908176397;
        points[21] = -0.391952296330753150371216941213010702185017624423004215;
        points[22] = -0.342007653597995261248368267483996950877672821629287289;
        points[23] = -0.291076914311109189533025268314303302189517100857549348;
        points[24] = -0.239306924966153454428948509085334787700528828035330307;
        points[25] = -0.186846951835761321374383881464022406061547888441217035;
        points[26] = -0.13384825059546685702237684787454091195295752427056042;
        points[27] = -0.0804636302141427293098477923805031948893348968318648099;
        points[28] = -0.02684701236594235580333868951737998584342117663189361;
        points[29] = 0.02684701236594235580333868951737998584342117663189361;
        points[30] = 0.0804636302141427293098477923805031948893348968318648099;
        points[31] = 0.13384825059546685702237684787454091195295752427056042;
        points[32] = 0.186846951835761321374383881464022406061547888441217035;
        points[33] = 0.239306924966153454428948509085334787700528828035330307;
        points[34] = 0.291076914311109189533025268314303302189517100857549348;
        points[35] = 0.342007653597995261248368267483996950877672821629287289;
        points[36] = 0.391952296330753150371216941213010702185017624423004215;
        points[37] = 0.440766839186839565193703062214304414122414801908176397;
        points[38] = 0.488310537216718463615552572736785420894228720802451279;
        points[39] = 0.534446309648847586399802417425204355788763287356337084;
        points[40] = 0.579041135130225030489977117136083403820176816683960341;
        points[41] = 0.621966435263079111033984058745491120232235253849255085;
        points[42] = 0.663098445332125266433016299753565691960643624304121991;
        points[43] = 0.702318571153908113479757301458201383660685816647606889;
        points[44] = 0.73951373102004226784661723485103279097065744804820353;
        points[45] = 0.774576681749652745266140046496826665648970000627280787;
        points[46] = 0.807406327913088141048997152207395227983283424010130542;
        points[47] = 0.837908013339373316352097920621624361286867305697942394;
        points[48] = 0.865993794074807479275071232512087657694274148605561063;
        points[49] = 0.891582692022030176399882820812797546482551849941030649;
        points[50] = 0.914600928564352540686505649897521820495615095425406115;
        points[51] = 0.934982137588259348480843234766247495409147422744563944;
        points[52] = 0.952667557518869091442845510022930333705587628975491226;
        points[53] = 0.96760620250292409015330078462120619491287277499442596;
        points[54] = 0.979755014694350309107816334392598034869875945691289139;
        points[55] = 0.989079008248442636499910255275442056883205365501321505;
        points[56] = 0.995551476597290902602771526179946141276967280242974881;
        points[57] = 0.999155200407386606442737044184605761045813585872715631;
        weights[0] = 0.00216772324962744994305434292498451143103544022457861832;
        weights[1] = 0.00503998161265024308501750117462242355333087943674126262;
        weights[2] = 0.00790197384999867475401674567484775950725497451144570023;
        weights[3] = 0.0107415535328787741168563619136618737235674500177416583;
        weights[4] = 0.0135502371129888121451789664017618618308308531829865017;
        weights[5] = 0.0163198742349709650521208304195708874821816105277690602;
        weights[6] = 0.0190424654618934086557876594821076039333641329342966622;
        weights[7] = 0.021710156140146235766916809495118289922602934077950337;
        weights[8] = 0.0243152527249639525402587606257985097442911865134363059;
        weights[9] = 0.0268502431819818684759074786781449555910274646571860066;
        weights[10] = 0.0293078180441604907183940268884438100349616013719531896;
        weights[11] = 0.0316808912538093273202920396219502966872861645240879873;
        weights[12] = 0.0339626204934160107977275551845847994387837763949648006;
        weights[13] = 0.0361464268670872705407808569758552272333427912991269834;
        weights[14] = 0.0382260138458584332294590344571485400659427639863191565;
        weights[15] = 0.0401953854098677968880767508268822923579140402207077844;
        weights[16] = 0.0420488633295821259945699819172542314622665402355190603;
        weights[17] = 0.0437811035336402510390256923483360732427561176600973783;
        weights[18] = 0.0453871115148198025039805360888660491491617686449521352;
        weights[19] = 0.0468622567290263469184180780379200348509136109749744945;
        weights[20] = 0.0482022859454177484065704061098669065750307136268468626;
        weights[21] = 0.0494033355089623928665108657127013196506444226693611684;
        weights[22] = 0.0504619424799531252976598215676317780474879663625451496;
        weights[23] = 0.0513750546182857254745148206110653803029581080956232019;
        weights[24] = 0.0521400391836698189712605560600718257610216901342433444;
        weights[25] = 0.0527546905263708334296457672315231717649335929173374798;
        weights[26] = 0.0532172364465790141034809843773847932124579233045218451;
        weights[27] = 0.0535263433040582521006108138861701805419674894903239215;
        weights[28] = 0.0536811198633348488639059553057246129006819920023619436;
        weights[29] = 0.0536811198633348488639059553057246129006819920023619436;
        weights[30] = 0.0535263433040582521006108138861701805419674894903239215;
        weights[31] = 0.0532172364465790141034809843773847932124579233045218451;
        weights[32] = 0.0527546905263708334296457672315231717649335929173374798;
        weights[33] = 0.0521400391836698189712605560600718257610216901342433444;
        weights[34] = 0.0513750546182857254745148206110653803029581080956232019;
        weights[35] = 0.0504619424799531252976598215676317780474879663625451496;
        weights[36] = 0.0494033355089623928665108657127013196506444226693611684;
        weights[37] = 0.0482022859454177484065704061098669065750307136268468626;
        weights[38] = 0.0468622567290263469184180780379200348509136109749744945;
        weights[39] = 0.0453871115148198025039805360888660491491617686449521352;
        weights[40] = 0.0437811035336402510390256923483360732427561176600973783;
        weights[41] = 0.0420488633295821259945699819172542314622665402355190603;
        weights[42] = 0.0401953854098677968880767508268822923579140402207077844;
        weights[43] = 0.0382260138458584332294590344571485400659427639863191565;
        weights[44] = 0.0361464268670872705407808569758552272333427912991269834;
        weights[45] = 0.0339626204934160107977275551845847994387837763949648006;
        weights[46] = 0.0316808912538093273202920396219502966872861645240879873;
        weights[47] = 0.0293078180441604907183940268884438100349616013719531896;
        weights[48] = 0.0268502431819818684759074786781449555910274646571860066;
        weights[49] = 0.0243152527249639525402587606257985097442911865134363059;
        weights[50] = 0.021710156140146235766916809495118289922602934077950337;
        weights[51] = 0.0190424654618934086557876594821076039333641329342966622;
        weights[52] = 0.0163198742349709650521208304195708874821816105277690602;
        weights[53] = 0.0135502371129888121451789664017618618308308531829865017;
        weights[54] = 0.0107415535328787741168563619136618737235674500177416583;
        weights[55] = 0.00790197384999867475401674567484775950725497451144570023;
        weights[56] = 0.00503998161265024308501750117462242355333087943674126262;
        weights[57] = 0.00216772324962744994305434292498451143103544022457861832;
        return;
    case 59:
        points[0] = -0.999183353909294683756424019504678184974225970330022709;
        points[1] = -0.995699640383245964687201823433448307661855776908591227;
        points[2] = -0.989442365133730931782183935022705793473255280023299343;
        points[3] = -0.980427573956715688449607981403267775462557851139703011;
        points[4] = -0.968680221681781531353633339672562057664889443329818486;
        points[5] = -0.954233009376951055863233112185649937073908138274547126;
        points[6] = -0.93712619035345385940513847104328988491060212647114706;
        points[7] = -0.917407438788155281352541485215245826873143490003803993;
        points[8] = -0.895131711743472085364296829462459275029537139409999277;
        points[9] = -0.870361094292882260963426233104145201284186947396187658;
        points[10] = -0.843164625816872201470350953972236638470225960817232193;
        points[11] = -0.813618107288211571435089773821200447410704065089647454;
        points[12] = -0.781803889862360905632678812767482628029666956950394431;
        points[13] = -0.747810645278640231889257579013212387920894933985514491;
        points[14] = -0.711733118677197731595915721965909353910762452802312234;
        points[15] = -0.673671864504937227024027212755253684415064275115545886;
        points[16] = -0.633732966238850097512580930175007912551898376438962263;
        points[17] = -0.592027740704030144464176159756534339804248169680693676;
        points[18] = -0.548672427808396384372256300387005857440673318324009302;
        points[19] = -0.503787866557717978768087280457308892150980648897875859;
        points[20] = -0.457499158253266690226215260434961508176425775912334218;
        points[21] = -0.409935317810418966722823693755879121014721462678233417;
        points[22] = -0.361228914169794809992312452334048957953413960174839404;
        points[23] = -0.311515700803013700318360149105749750125659237602980342;
        points[24] = -0.260934237342811711610616267414278380003544483433130362;
        points[25] = -0.209625503392036544923366790631491096332050474314493175;
        points[26] = -0.157732505587857968115217856271554304124174624202703188;
        points[27] = -0.105399879016344143836914387761869287053925410936822292;
        points[28] = -0.0527734840883100039516803286033385378247007695091781053;
        points[29] = 0;
        points[30] = 0.0527734840883100039516803286033385378247007695091781053;
        points[31] = 0.105399879016344143836914387761869287053925410936822292;
        points[32] = 0.157732505587857968115217856271554304124174624202703188;
        points[33] = 0.209625503392036544923366790631491096332050474314493175;
        points[34] = 0.260934237342811711610616267414278380003544483433130362;
        points[35] = 0.311515700803013700318360149105749750125659237602980342;
        points[36] = 0.361228914169794809992312452334048957953413960174839404;
        points[37] = 0.409935317810418966722823693755879121014721462678233417;
        points[38] = 0.457499158253266690226215260434961508176425775912334218;
        points[39] = 0.503787866557717978768087280457308892150980648897875859;
        points[40] = 0.548672427808396384372256300387005857440673318324009302;
        points[41] = 0.592027740704030144464176159756534339804248169680693676;
        points[42] = 0.633732966238850097512580930175007912551898376438962263;
        points[43] = 0.673671864504937227024027212755253684415064275115545886;
        points[44] = 0.711733118677197731595915721965909353910762452802312234;
        points[45] = 0.747810645278640231889257579013212387920894933985514491;
        points[46] = 0.781803889862360905632678812767482628029666956950394431;
        points[47] = 0.813618107288211571435089773821200447410704065089647454;
        points[48] = 0.843164625816872201470350953972236638470225960817232193;
        points[49] = 0.870361094292882260963426233104145201284186947396187658;
        points[50] = 0.895131711743472085364296829462459275029537139409999277;
        points[51] = 0.917407438788155281352541485215245826873143490003803993;
        points[52] = 0.93712619035345385940513847104328988491060212647114706;
        points[53] = 0.954233009376951055863233112185649937073908138274547126;
        points[54] = 0.968680221681781531353633339672562057664889443329818486;
        points[55] = 0.980427573956715688449607981403267775462557851139703011;
        points[56] = 0.989442365133730931782183935022705793473255280023299343;
        points[57] = 0.995699640383245964687201823433448307661855776908591227;
        points[58] = 0.999183353909294683756424019504678184974225970330022709;
        weights[0] = 0.00209549228454122340270073148864005976798129321037713635;
        weights[1] = 0.00487223916826528476858200113292406855604266062886634061;
        weights[2] = 0.0076395294534875751427006829747543652575516412084065115;
        weights[3] = 0.0103858855009958621937978744109830403674448291493380061;
        weights[4] = 0.013103366306345191018319546484216966965564839234007091;
        weights[5] = 0.0157843473130814661473204803972491703730725538689579519;
        weights[6] = 0.0184213427536100293606157510564453183105268487171122401;
        weights[7] = 0.0210069982884371873504614732186692650506890277865110939;
        weights[8] = 0.0235341053937133634252753600783577002987844850383689152;
        weights[9] = 0.0259956197312985001866505068017079327139848097316180231;
        weights[10] = 0.0283846802005347979051528693353884987703141837630423358;
        weights[11] = 0.0306946278361116832397503281924808053595267480058283296;
        weights[12] = 0.0329190242710452777575112643535988080802698765574078253;
        weights[13] = 0.0350516696364001087837183589610782511167250811878572546;
        weights[14] = 0.0370866198188709226918379170352773582789499639491344915;
        weights[15] = 0.039018203016160009503030777211285513419091837939024417;
        weights[16] = 0.0408410355386867076602021080894693086860064759028936405;
        weights[17] = 0.0425500368110676386673082004847131274457234133459328312;
        weights[18] = 0.0441404435302973806907980847330809685891863326681307177;
        weights[19] = 0.0456078229405097698318682131583742114179944597204615576;
        weights[20] = 0.046948085186962019193159736482928952238545917474570698;
        weights[21] = 0.0481574947146064403881468292859357839604642187210079111;
        weights[22] = 0.0492326806793619857796936200150241883828630358705233273;
        weights[23] = 0.0501706463429969028107204304421656821438441057158682953;
        weights[24] = 0.0509687774253939168502479689936810100983096097852119893;
        weights[25] = 0.0516248493908914821464399397734228085937643377492687371;
        weights[26] = 0.0521370336483753913839872083078182338745975798794849498;
        weights[27] = 0.0525039026478287390509413220142884653607880584859075305;
        weights[28] = 0.052724433859127931961304248870612502871883937503544267;
        weights[29] = 0.0527980126219904214155123324308552672990156744026711684;
        weights[30] = 0.052724433859127931961304248870612502871883937503544267;
        weights[31] = 0.0525039026478287390509413220142884653607880584859075305;
        weights[32] = 0.0521370336483753913839872083078182338745975798794849498;
        weights[33] = 0.0516248493908914821464399397734228085937643377492687371;
        weights[34] = 0.0509687774253939168502479689936810100983096097852119893;
        weights[35] = 0.0501706463429969028107204304421656821438441057158682953;
        weights[36] = 0.0492326806793619857796936200150241883828630358705233273;
        weights[37] = 0.0481574947146064403881468292859357839604642187210079111;
        weights[38] = 0.046948085186962019193159736482928952238545917474570698;
        weights[39] = 0.0456078229405097698318682131583742114179944597204615576;
        weights[40] = 0.0441404435302973806907980847330809685891863326681307177;
        weights[41] = 0.0425500368110676386673082004847131274457234133459328312;
        weights[42] = 0.0408410355386867076602021080894693086860064759028936405;
        weights[43] = 0.039018203016160009503030777211285513419091837939024417;
        weights[44] = 0.0370866198188709226918379170352773582789499639491344915;
        weights[45] = 0.0350516696364001087837183589610782511167250811878572546;
        weights[46] = 0.0329190242710452777575112643535988080802698765574078253;
        weights[47] = 0.0306946278361116832397503281924808053595267480058283296;
        weights[48] = 0.0283846802005347979051528693353884987703141837630423358;
        weights[49] = 0.0259956197312985001866505068017079327139848097316180231;
        weights[50] = 0.0235341053937133634252753600783577002987844850383689152;
        weights[51] = 0.0210069982884371873504614732186692650506890277865110939;
        weights[52] = 0.0184213427536100293606157510564453183105268487171122401;
        weights[53] = 0.0157843473130814661473204803972491703730725538689579519;
        weights[54] = 0.013103366306345191018319546484216966965564839234007091;
        weights[55] = 0.0103858855009958621937978744109830403674448291493380061;
        weights[56] = 0.0076395294534875751427006829747543652575516412084065115;
        weights[57] = 0.00487223916826528476858200113292406855604266062886634061;
        weights[58] = 0.00209549228454122340270073148864005976798129321037713635;
        return;
    case 60:
        points[0] = -0.999210123227436022034229585797649266398798978711325671;
        points[1] = -0.995840525118838173876746713377440652774890294977139102;
        points[2] = -0.989787895222221717367278987016096042577393153786939041;
        points[3] = -0.981067201752598185618576799826770033880538579221891743;
        points[4] = -0.969701788765052733721544098913794272540934344868247072;
        points[5] = -0.95572225583999610739723184582969950248009374476661422;
        points[6] = -0.939166276116423249495419011609705096419403420401198032;
        points[7] = -0.92007847617762755285665686251989682878376887601370604;
        points[8] = -0.898510310810045941937789329572628330164458442747073825;
        points[9] = -0.874519922646898315129308099912435805159182294435782076;
        points[10] = -0.848171984785929632490515494994375601297528716506778197;
        points[11] = -0.81953752616214575936851810851972357189949051896959251;
        points[12] = -0.78869373993226405456994479977721573524633292787922762;
        points[13] = -0.755723775306585686868842066602373105928900199564707725;
        points[14] = -0.720716513355730399436021061013521077764773994733239043;
        points[15] = -0.68376632738135543722293023922429715908759460433887498;
        points[16] = -0.644972828489477067813447896420444717165190019346660996;
        points[17] = -0.604440597048510363444208776311201720650421053591059838;
        points[18] = -0.5622789007539445391782725874859987290631882376593954;
        points[19] = -0.518601400058569747417889348484721301329846676288685573;
        points[20] = -0.47352584176170711110816305375279463800786800509983689;
        points[21] = -0.42717374158307838930745285353031192335344213618423209;
        points[22] = -0.379670056576797977154952670521887704056374433162389866;
        points[23] = -0.331142848268448194252352965350552704800121496376311203;
        points[24] = -0.281722937423261691690694860339441598308263060795377424;
        points[25] = -0.231543551376029338010344631346755440743539051939585732;
        points[26] = -0.180739964873425417240876941261852631231772168639045493;
        points[27] = -0.129449135396945003146444164649575774759873524366472143;
        points[28] = -0.077809333949536569419285507082225287577594782897723955;
        points[29] = -0.0259597723012477985891703854003448256603147607172752255;
        points[30] = 0.0259597723012477985891703854003448256603147607172752255;
        points[31] = 0.077809333949536569419285507082225287577594782897723955;
        points[32] = 0.129449135396945003146444164649575774759873524366472143;
        points[33] = 0.180739964873425417240876941261852631231772168639045493;
        points[34] = 0.231543551376029338010344631346755440743539051939585732;
        points[35] = 0.281722937423261691690694860339441598308263060795377424;
        points[36] = 0.331142848268448194252352965350552704800121496376311203;
        points[37] = 0.379670056576797977154952670521887704056374433162389866;
        points[38] = 0.42717374158307838930745285353031192335344213618423209;
        points[39] = 0.47352584176170711110816305375279463800786800509983689;
        points[40] = 0.518601400058569747417889348484721301329846676288685573;
        points[41] = 0.5622789007539445391782725874859987290631882376593954;
        points[42] = 0.604440597048510363444208776311201720650421053591059838;
        points[43] = 0.644972828489477067813447896420444717165190019346660996;
        points[44] = 0.68376632738135543722293023922429715908759460433887498;
        points[45] = 0.720716513355730399436021061013521077764773994733239043;
        points[46] = 0.755723775306585686868842066602373105928900199564707725;
        points[47] = 0.78869373993226405456994479977721573524633292787922762;
        points[48] = 0.81953752616214575936851810851972357189949051896959251;
        points[49] = 0.848171984785929632490515494994375601297528716506778197;
        points[50] = 0.874519922646898315129308099912435805159182294435782076;
        points[51] = 0.898510310810045941937789329572628330164458442747073825;
        points[52] = 0.92007847617762755285665686251989682878376887601370604;
        points[53] = 0.939166276116423249495419011609705096419403420401198032;
        points[54] = 0.95572225583999610739723184582969950248009374476661422;
        points[55] = 0.969701788765052733721544098913794272540934344868247072;
        points[56] = 0.981067201752598185618576799826770033880538579221891743;
        points[57] = 0.989787895222221717367278987016096042577393153786939041;
        points[58] = 0.995840525118838173876746713377440652774890294977139102;
        points[59] = 0.999210123227436022034229585797649266398798978711325671;
        weights[0] = 0.00202681196887375849643171020989232469531166822555894991;
        weights[1] = 0.00471272992695356864089482171407723594808497019371506012;
        weights[2] = 0.00738993116334545553151695602208606088222818020622509209;
        weights[3] = 0.0100475571822879843578857643770572564996517474876773843;
        weights[4] = 0.0126781664768159601314953792695142349883383643026329456;
        weights[5] = 0.0152746185967847993067260380988253351779093841150728645;
        weights[6] = 0.0178299010142077202603962612483485676338592195833932469;
        weights[7] = 0.0203371207294572867750321474171063014620171125053439038;
        weights[8] = 0.0227895169439978198637834581929002078101673842152082582;
        weights[9] = 0.0251804776215212483795709659723612791317808329441895486;
        weights[10] = 0.0275035567499247916352231976386222476484034707541621773;
        weights[11] = 0.029752491500788945240836484673487710332475158124107232;
        weights[12] = 0.031921219019296328949458899536760476766697292282991421;
        weights[13] = 0.034003892724946422834914401555258741187276223552858876;
        weights[14] = 0.0359948980510845030665786462880623385942424200210035839;
        weights[15] = 0.0378888675692434440309407942092760318100842810638063715;
        weights[16] = 0.0396806954523807994701228348117100087628035112941742187;
        weights[17] = 0.0413655512355847556131638368066588968801870085215107142;
        weights[18] = 0.042938892835935641954231220656382806949211771964916479;
        weights[19] = 0.0443964787957871133277841640913773696638849857340142985;
        weights[20] = 0.0457343797161144866471964552909093330079349742586849544;
        weights[21] = 0.0469489888489122048470131563947015662755749025834444429;
        weights[22] = 0.0480370318199711809636666527287336536025000292469219569;
        weights[23] = 0.0489955754557568353894756868578942983575838959990902425;
        weights[24] = 0.0498220356905501810111592308937033124792155972437847697;
        weights[25] = 0.0505141845325093745982387357416536432399561627374166281;
        weights[26] = 0.0510701560698556274045491207344910353661970831136710547;
        weights[27] = 0.0514884515009809339950443971770543117339238266595808248;
        weights[28] = 0.0517679431749101875438036430288237329323469454992015641;
        weights[29] = 0.0519078776312206397328649383622696801801515955656409356;
        weights[30] = 0.0519078776312206397328649383622696801801515955656409356;
        weights[31] = 0.0517679431749101875438036430288237329323469454992015641;
        weights[32] = 0.0514884515009809339950443971770543117339238266595808248;
        weights[33] = 0.0510701560698556274045491207344910353661970831136710547;
        weights[34] = 0.0505141845325093745982387357416536432399561627374166281;
        weights[35] = 0.0498220356905501810111592308937033124792155972437847697;
        weights[36] = 0.0489955754557568353894756868578942983575838959990902425;
        weights[37] = 0.0480370318199711809636666527287336536025000292469219569;
        weights[38] = 0.0469489888489122048470131563947015662755749025834444429;
        weights[39] = 0.0457343797161144866471964552909093330079349742586849544;
        weights[40] = 0.0443964787957871133277841640913773696638849857340142985;
        weights[41] = 0.042938892835935641954231220656382806949211771964916479;
        weights[42] = 0.0413655512355847556131638368066588968801870085215107142;
        weights[43] = 0.0396806954523807994701228348117100087628035112941742187;
        weights[44] = 0.0378888675692434440309407942092760318100842810638063715;
        weights[45] = 0.0359948980510845030665786462880623385942424200210035839;
        weights[46] = 0.034003892724946422834914401555258741187276223552858876;
        weights[47] = 0.031921219019296328949458899536760476766697292282991421;
        weights[48] = 0.029752491500788945240836484673487710332475158124107232;
        weights[49] = 0.0275035567499247916352231976386222476484034707541621773;
        weights[50] = 0.0251804776215212483795709659723612791317808329441895486;
        weights[51] = 0.0227895169439978198637834581929002078101673842152082582;
        weights[52] = 0.0203371207294572867750321474171063014620171125053439038;
        weights[53] = 0.0178299010142077202603962612483485676338592195833932469;
        weights[54] = 0.0152746185967847993067260380988253351779093841150728645;
        weights[55] = 0.0126781664768159601314953792695142349883383643026329456;
        weights[56] = 0.0100475571822879843578857643770572564996517474876773843;
        weights[57] = 0.00738993116334545553151695602208606088222818020622509209;
        weights[58] = 0.00471272992695356864089482171407723594808497019371506012;
        weights[59] = 0.00202681196887375849643171020989232469531166822555894991;
        return;
    case 61:
        points[0] = -0.999235597631363471731862259569130862853442048503000831;
        points[1] = -0.995974599815120234268012760712288276286848864789131725;
        points[2] = -0.990116745232517050965531685699916501628756781176497313;
        points[3] = -0.981676011284037079685172540751319422160074062094926546;
        points[4] = -0.97067425883318290824740845354791027256833637675753032;
        points[5] = -0.95714015191298409137208028742121526110444034092702351;
        points[6] = -0.941108986681361147477543860977789008280474711058459422;
        points[7] = -0.922622581382955261257551500555845445450635161298717512;
        points[8] = -0.901729162474001170642040042683511164653117521087263577;
        points[9] = -0.878483237214881032478947513893352631459554520280417946;
        points[10] = -0.852945450847663445564846904674170538339953259984460132;
        points[11] = -0.825182428108659950664281892450847527006394659959583126;
        points[12] = -0.795266599282359649152048802752546264873236870205831179;
        points[13] = -0.763276011172312197145914668494350371044519151098621473;
        points[14] = -0.729294123449465109688956690135531798576371014538177349;
        points[15] = -0.69340959089449115549918436396023173728437756854618546;
        points[16] = -0.655716032095070871699185777836306887000847346441682259;
        points[17] = -0.616311785197921724709616859328591035895671683961232725;
        points[18] = -0.575299651350830618600369981944972878997331925337729135;
        points[19] = -0.532786626502925265638481716373071640324819910945474154;
        points[20] = -0.488883622262252118820698511425829597516530924724996168;
        points[21] = -0.443705176538531601995589301065822559382324637472238324;
        points[22] = -0.39736915472575660917829184736858922181287289269372192;
        points[23] = -0.349996442204066834533434477062093849787504617404883983;
        points[24] = -0.301710628963030712604486525456977125241197632870037328;
        points[25] = -0.252637687169053495833690863334405106227510747560059222;
        points[26] = -0.202905642518058499226947203343057054501439051858363433;
        points[27] = -0.152644240230815300529506761773477416883538976617459301;
        points[28] = -0.10198460656227406895720840476436564197678981705575171;
        points[29] = -0.0510589067079743493668875006189007980701842540412565385;
        points[30] = 0;
        points[31] = 0.0510589067079743493668875006189007980701842540412565385;
        points[32] = 0.10198460656227406895720840476436564197678981705575171;
        points[33] = 0.152644240230815300529506761773477416883538976617459301;
        points[34] = 0.202905642518058499226947203343057054501439051858363433;
        points[35] = 0.252637687169053495833690863334405106227510747560059222;
        points[36] = 0.301710628963030712604486525456977125241197632870037328;
        points[37] = 0.349996442204066834533434477062093849787504617404883983;
        points[38] = 0.39736915472575660917829184736858922181287289269372192;
        points[39] = 0.443705176538531601995589301065822559382324637472238324;
        points[40] = 0.488883622262252118820698511425829597516530924724996168;
        points[41] = 0.532786626502925265638481716373071640324819910945474154;
        points[42] = 0.575299651350830618600369981944972878997331925337729135;
        points[43] = 0.616311785197921724709616859328591035895671683961232725;
        points[44] = 0.655716032095070871699185777836306887000847346441682259;
        points[45] = 0.69340959089449115549918436396023173728437756854618546;
        points[46] = 0.729294123449465109688956690135531798576371014538177349;
        points[47] = 0.763276011172312197145914668494350371044519151098621473;
        points[48] = 0.795266599282359649152048802752546264873236870205831179;
        points[49] = 0.825182428108659950664281892450847527006394659959583126;
        points[50] = 0.852945450847663445564846904674170538339953259984460132;
        points[51] = 0.878483237214881032478947513893352631459554520280417946;
        points[52] = 0.901729162474001170642040042683511164653117521087263577;
        points[53] = 0.922622581382955261257551500555845445450635161298717512;
        points[54] = 0.941108986681361147477543860977789008280474711058459422;
        points[55] = 0.95714015191298409137208028742121526110444034092702351;
        points[56] = 0.97067425883318290824740845354791027256833637675753032;
        points[57] = 0.981676011284037079685172540751319422160074062094926546;
        points[58] = 0.990116745232517050965531685699916501628756781176497313;
        points[59] = 0.995974599815120234268012760712288276286848864789131725;
        points[60] = 0.999235597631363471731862259569130862853442048503000831;
        weights[0] = 0.00196145336167028267177306446192684809414929406187149776;
        weights[1] = 0.00456092400601241718453893257974278827081304337831533151;
        weights[2] = 0.00715235499174908958583399309169417557127328166702841504;
        weights[3] = 0.00972546183035613373613667175557011832684334637992202658;
        weights[4] = 0.0122732635078121046292778003595261313544926604914256755;
        weights[5] = 0.0147890658849379145461785157814882612603715285337802068;
        weights[6] = 0.0172662929876137435944332127724366211841880545205192719;
        weights[7] = 0.019698477746101181330517830212684566665796636136043834;
        weights[8] = 0.0220792731483190440024757656281816274361721240829312286;
        weights[9] = 0.0244024671875442029153406597324675323257701985040236008;
        weights[10] = 0.0266619985241508896628107068449680195640554191241206074;
        weights[11] = 0.0288519720881834015043417755455902525435071199346938874;
        weights[12] = 0.0309666743683973948246979466124893837667092710275253843;
        weights[13] = 0.0330005882759074106327236834410044928074089398081505862;
        weights[14] = 0.0349484075165333510908519192092192782550094709415075836;
        weights[15] = 0.0368050504231548173843210428640674608759007235916177133;
        weights[16] = 0.0385656732070081727461520476296538028292229332149573981;
        weights[17] = 0.0402256825909982473676399837575115791559285285247384514;
        weights[18] = 0.0417807477908884920666755723510730075126973740835647877;
        weights[19] = 0.0432268118124960979010436458226828733502967443538131357;
        weights[20] = 0.0445601020350834882715414198310883529333563351947651631;
        weights[21] = 0.045777140053145959371339833846824791961534814552092104;
        weights[22] = 0.0468747507508090659764294455885907359337142723543964814;
        weights[23] = 0.0478500705850956071618334275186996627134012529702368159;
        weights[24] = 0.0487005550564115260875300883147056067586983721814505763;
        weights[25] = 0.0494239853467355899399687766511164994166596566677484811;
        weights[26] = 0.050018474108178253425051615006358625442055919236672434;
        weights[27] = 0.0504824703867974046481444651881512691728991520000886696;
        weights[28] = 0.0508147636688183432077005292234786973478423438565676647;
        weights[29] = 0.0510144870386972635437350805738520107682023754233863468;
        weights[30] = 0.0510811194407862179779210956063098528020576264040892788;
        weights[31] = 0.0510144870386972635437350805738520107682023754233863468;
        weights[32] = 0.0508147636688183432077005292234786973478423438565676647;
        weights[33] = 0.0504824703867974046481444651881512691728991520000886696;
        weights[34] = 0.050018474108178253425051615006358625442055919236672434;
        weights[35] = 0.0494239853467355899399687766511164994166596566677484811;
        weights[36] = 0.0487005550564115260875300883147056067586983721814505763;
        weights[37] = 0.0478500705850956071618334275186996627134012529702368159;
        weights[38] = 0.0468747507508090659764294455885907359337142723543964814;
        weights[39] = 0.045777140053145959371339833846824791961534814552092104;
        weights[40] = 0.0445601020350834882715414198310883529333563351947651631;
        weights[41] = 0.0432268118124960979010436458226828733502967443538131357;
        weights[42] = 0.0417807477908884920666755723510730075126973740835647877;
        weights[43] = 0.0402256825909982473676399837575115791559285285247384514;
        weights[44] = 0.0385656732070081727461520476296538028292229332149573981;
        weights[45] = 0.0368050504231548173843210428640674608759007235916177133;
        weights[46] = 0.0349484075165333510908519192092192782550094709415075836;
        weights[47] = 0.0330005882759074106327236834410044928074089398081505862;
        weights[48] = 0.0309666743683973948246979466124893837667092710275253843;
        weights[49] = 0.0288519720881834015043417755455902525435071199346938874;
        weights[50] = 0.0266619985241508896628107068449680195640554191241206074;
        weights[51] = 0.0244024671875442029153406597324675323257701985040236008;
        weights[52] = 0.0220792731483190440024757656281816274361721240829312286;
        weights[53] = 0.019698477746101181330517830212684566665796636136043834;
        weights[54] = 0.0172662929876137435944332127724366211841880545205192719;
        weights[55] = 0.0147890658849379145461785157814882612603715285337802068;
        weights[56] = 0.0122732635078121046292778003595261313544926604914256755;
        weights[57] = 0.00972546183035613373613667175557011832684334637992202658;
        weights[58] = 0.00715235499174908958583399309169417557127328166702841504;
        weights[59] = 0.00456092400601241718453893257974278827081304337831533151;
        weights[60] = 0.00196145336167028267177306446192684809414929406187149776;
        return;
    case 62:
        points[0] = -0.999259859308777029698408465035798938019634460510221853;
        points[1] = -0.996102296316267132885148430476171492632140217279841958;
        points[2] = -0.99042997118929035242807106186068064500231531367714058;
        points[3] = -0.982255949097236649491103128009792471563001203053950845;
        points[4] = -0.971600723371651806447179482540305835154160553929264677;
        points[5] = -0.958491172973927092029560475165970943317106647782847211;
        points[6] = -0.942960401392328503826364811623351587241418158740212175;
        points[7] = -0.925047635636203755227300130757048619448630524042658125;
        points[8] = -0.904798122521093465758485602428375624398449892610323052;
        points[9] = -0.88226301283189736307268662435582975601712579191938624;
        points[10] = -0.857499231512070922818403320544675506891508937511621746;
        points[11] = -0.830569333604004851345931109477208222919811239495206516;
        points[12] = -0.801541346103976371538505514495386347306189483107850394;
        points[13] = -0.770488596055419318990944694995048188453809265505423986;
        points[14] = -0.737489525283156749860784276501439460280103435631180086;
        points[15] = -0.702627492222297055120972765059986723144031285289579655;
        points[16] = -0.665990561335479446997546034082388079933208584475695868;
        points[17] = -0.627671280646885180726954764916162788587208438303692503;
        points[18] = -0.587766447953087338002149550121987763858197496847643018;
        points[19] = -0.546376866300251095816100384523633707232171091578385675;
        points[20] = -0.503607089344755955917020805931616276965841967296053744;
        points[21] = -0.459565157240113395207143978075752651418602087013646598;
        points[22] = -0.414362323717126048129588750657611345135889299571842248;
        points[23] = -0.368112775046564529663021830952507922017235455535164745;
        points[24] = -0.320933341594194004074101601003456385085858702159362965;
        points[25] = -0.272943202696726343188683627973480980854861620343509936;
        points[26] = -0.224263585604165531668991393344882700608965256717494693;
        points[27] = -0.17501745924901562855568742390423603170050770944644704;
        points[28] = -0.125329223615896808619648999499726257796755400789475805;
        points[29] = -0.0753243954962343327638269391178708775768458123144207998;
        points[30] = -0.025129291421820614727088275999146962314504918024814949;
        points[31] = 0.025129291421820614727088275999146962314504918024814949;
        points[32] = 0.0753243954962343327638269391178708775768458123144207998;
        points[33] = 0.125329223615896808619648999499726257796755400789475805;
        points[34] = 0.17501745924901562855568742390423603170050770944644704;
        points[35] = 0.224263585604165531668991393344882700608965256717494693;
        points[36] = 0.272943202696726343188683627973480980854861620343509936;
        points[37] = 0.320933341594194004074101601003456385085858702159362965;
        points[38] = 0.368112775046564529663021830952507922017235455535164745;
        points[39] = 0.414362323717126048129588750657611345135889299571842248;
        points[40] = 0.459565157240113395207143978075752651418602087013646598;
        points[41] = 0.503607089344755955917020805931616276965841967296053744;
        points[42] = 0.546376866300251095816100384523633707232171091578385675;
        points[43] = 0.587766447953087338002149550121987763858197496847643018;
        points[44] = 0.627671280646885180726954764916162788587208438303692503;
        points[45] = 0.665990561335479446997546034082388079933208584475695868;
        points[46] = 0.702627492222297055120972765059986723144031285289579655;
        points[47] = 0.737489525283156749860784276501439460280103435631180086;
        points[48] = 0.770488596055419318990944694995048188453809265505423986;
        points[49] = 0.801541346103976371538505514495386347306189483107850394;
        points[50] = 0.830569333604004851345931109477208222919811239495206516;
        points[51] = 0.857499231512070922818403320544675506891508937511621746;
        points[52] = 0.88226301283189736307268662435582975601712579191938624;
        points[53] = 0.904798122521093465758485602428375624398449892610323052;
        points[54] = 0.925047635636203755227300130757048619448630524042658125;
        points[55] = 0.942960401392328503826364811623351587241418158740212175;
        points[56] = 0.958491172973927092029560475165970943317106647782847211;
        points[57] = 0.971600723371651806447179482540305835154160553929264677;
        points[58] = 0.982255949097236649491103128009792471563001203053950845;
        points[59] = 0.99042997118929035242807106186068064500231531367714058;
        points[60] = 0.996102296316267132885148430476171492632140217279841958;
        points[61] = 0.999259859308777029698408465035798938019634460510221853;
        weights[0] = 0.00189920567951369048039734386093514017087884977236897663;
        weights[1] = 0.00441633345693090481327412425549064072971198213049489617;
        weights[2] = 0.00692604190183096087170282409925706711954721309845612182;
        weights[3] = 0.00941857942842038763793756340656642815543364295156699935;
        weights[4] = 0.0118873901170105019448189389667979365274285962699907244;
        weights[5] = 0.0143261918238065177674028823094145960770999460756654786;
        weights[6] = 0.0167288117901773162885504717840924583631319372334291324;
        weights[7] = 0.0190891766585731987325037124822838057744426750473217115;
        weights[8] = 0.0214013222776699688411790899649052776408375205805733304;
        weights[9] = 0.0236594072086827925745168006505345647014315294308404535;
        weights[10] = 0.0258577269540246980270955665535105155948598700257474233;
        weights[11] = 0.0279907281633146375412382927540413048736838088959792964;
        weights[12] = 0.0300530225739898700770094692270623794862287815545353735;
        weights[13] = 0.0320394005816246781063392372781563731304930348629342626;
        weights[14] = 0.0339448443794105450911174772542360577864065417327114703;
        weights[15] = 0.0357645406227681412855873783617220425845980677311738019;
        weights[16] = 0.0374938925822800299856185635187930282343318531675349904;
        weights[17] = 0.0391285317519630841233108018226088606261799149434694791;
        weights[18] = 0.0406643288824174409682850175166634173129867186716685745;
        weights[19] = 0.0420974044103850966430226269038388460100870864191350467;
        weights[20] = 0.0434241382580474195800692304339443041957713299146806061;
        weights[21] = 0.0446411789771244142936446918091377844103487557080767163;
        weights[22] = 0.0457454522145701807772322722976961876704039463776258646;
        weights[23] = 0.0467341684784155248022070550794847787621597834290144551;
        weights[24] = 0.0476048301841012322704500882678663730607374180494971446;
        weights[25] = 0.0483552379634776728348031814784589867622005024623890562;
        weights[26] = 0.0489834962205178371048511270262173725653489027963997494;
        weights[27] = 0.0494880179196992925278658109047740184636337882109571078;
        weights[28] = 0.0498675285949523942447613106348428168881959590452746142;
        weights[29] = 0.050121069569043288074804100101530968004895319933921361;
        weights[30] = 0.0502480003752562816884029489951356683165047234765657809;
        weights[31] = 0.0502480003752562816884029489951356683165047234765657809;
        weights[32] = 0.050121069569043288074804100101530968004895319933921361;
        weights[33] = 0.0498675285949523942447613106348428168881959590452746142;
        weights[34] = 0.0494880179196992925278658109047740184636337882109571078;
        weights[35] = 0.0489834962205178371048511270262173725653489027963997494;
        weights[36] = 0.0483552379634776728348031814784589867622005024623890562;
        weights[37] = 0.0476048301841012322704500882678663730607374180494971446;
        weights[38] = 0.0467341684784155248022070550794847787621597834290144551;
        weights[39] = 0.0457454522145701807772322722976961876704039463776258646;
        weights[40] = 0.0446411789771244142936446918091377844103487557080767163;
        weights[41] = 0.0434241382580474195800692304339443041957713299146806061;
        weights[42] = 0.0420974044103850966430226269038388460100870864191350467;
        weights[43] = 0.0406643288824174409682850175166634173129867186716685745;
        weights[44] = 0.0391285317519630841233108018226088606261799149434694791;
        weights[45] = 0.0374938925822800299856185635187930282343318531675349904;
        weights[46] = 0.0357645406227681412855873783617220425845980677311738019;
        weights[47] = 0.0339448443794105450911174772542360577864065417327114703;
        weights[48] = 0.0320394005816246781063392372781563731304930348629342626;
        weights[49] = 0.0300530225739898700770094692270623794862287815545353735;
        weights[50] = 0.0279907281633146375412382927540413048736838088959792964;
        weights[51] = 0.0258577269540246980270955665535105155948598700257474233;
        weights[52] = 0.0236594072086827925745168006505345647014315294308404535;
        weights[53] = 0.0214013222776699688411790899649052776408375205805733304;
        weights[54] = 0.0190891766585731987325037124822838057744426750473217115;
        weights[55] = 0.0167288117901773162885504717840924583631319372334291324;
        weights[56] = 0.0143261918238065177674028823094145960770999460756654786;
        weights[57] = 0.0118873901170105019448189389667979365274285962699907244;
        weights[58] = 0.00941857942842038763793756340656642815543364295156699935;
        weights[59] = 0.00692604190183096087170282409925706711954721309845612182;
        weights[60] = 0.00441633345693090481327412425549064072971198213049489617;
        weights[61] = 0.00189920567951369048039734386093514017087884977236897663;
        return;
    case 63:
        points[0] = -0.999282984029123780378936140928944461072796718186242813;
        points[1] = -0.996224012777970108602193361146311353293076971857523298;
        points[2] = -0.99072854689218946681089466720470345305426226535032778;
        points[3] = -0.982808810593727234862511405691611739202599161956207342;
        points[4] = -0.972484034697570022801960678576810948164976541203097838;
        points[5] = -0.959779449758941927070354166258988969165416503161655427;
        points[6] = -0.944726134041009802966375319627500663744580688957766982;
        points[7] = -0.927360920621843205447031381325121569456054361068601918;
        points[8] = -0.907726302778531558036953132915953225547793928275658208;
        points[9] = -0.885870328507853426290298457313369875149868469487853717;
        points[10] = -0.861846482364123719539611839431059953996536225216268314;
        points[11] = -0.835713554319502843471807769615705452823614477583885981;
        points[12] = -0.8075354957734567600514659863632431345941923607774963;
        points[13] = -0.777381262990372335563330189911042755759799142048102003;
        points[14] = -0.745324648317847417829321661037587632314602947261940726;
        points[15] = -0.711444099584845807851431537704014879128282511787012492;
        points[16] = -0.675822528114986090131103315969544508779811254723799706;
        points[17] = -0.63854710582136538500030695387337648123329492461318164;
        points[18] = -0.599709051877625235739008926868799861071169523997529146;
        points[19] = -0.559403409486285013267697800070054696540528415606657527;
        points[20] = -0.51772881329003324812447758452631553557737395502174835;
        points[21] = -0.47478724799480439992221230985149474928601795896973317;
        points[22] = -0.430683798795111600662088933918629982066481417200037325;
        points[23] = -0.385526394212247892477615022274398150275045705437133427;
        points[24] = -0.339425541974584402468834431594315085043918046718704485;
        points[25] = -0.29249405858625144003615715555066692368934587193884237;
        points[26] = -0.244846793245953362748404593924829370148342175358214833;
        points[27] = -0.19660034679150668455762745706571769792078300580349276;
        points[28] = -0.147872786357871968569839096552972943441463664083963029;
        points[29] = -0.0987833564469452795297036694539221034395586011789432173;
        points[30] = -0.0494521871161596272342338180518076098977554568999159461;
        points[31] = 0;
        points[32] = 0.0494521871161596272342338180518076098977554568999159461;
        points[33] = 0.0987833564469452795297036694539221034395586011789432173;
        points[34] = 0.147872786357871968569839096552972943441463664083963029;
        points[35] = 0.19660034679150668455762745706571769792078300580349276;
        points[36] = 0.244846793245953362748404593924829370148342175358214833;
        points[37] = 0.29249405858625144003615715555066692368934587193884237;
        points[38] = 0.339425541974584402468834431594315085043918046718704485;
        points[39] = 0.385526394212247892477615022274398150275045705437133427;
        points[40] = 0.430683798795111600662088933918629982066481417200037325;
        points[41] = 0.47478724799480439992221230985149474928601795896973317;
        points[42] = 0.51772881329003324812447758452631553557737395502174835;
        points[43] = 0.559403409486285013267697800070054696540528415606657527;
        points[44] = 0.599709051877625235739008926868799861071169523997529146;
        points[45] = 0.63854710582136538500030695387337648123329492461318164;
        points[46] = 0.675822528114986090131103315969544508779811254723799706;
        points[47] = 0.711444099584845807851431537704014879128282511787012492;
        points[48] = 0.745324648317847417829321661037587632314602947261940726;
        points[49] = 0.777381262990372335563330189911042755759799142048102003;
        points[50] = 0.8075354957734567600514659863632431345941923607774963;
        points[51] = 0.835713554319502843471807769615705452823614477583885981;
        points[52] = 0.861846482364123719539611839431059953996536225216268314;
        points[53] = 0.885870328507853426290298457313369875149868469487853717;
        points[54] = 0.907726302778531558036953132915953225547793928275658208;
        points[55] = 0.927360920621843205447031381325121569456054361068601918;
        points[56] = 0.944726134041009802966375319627500663744580688957766982;
        points[57] = 0.959779449758941927070354166258988969165416503161655427;
        points[58] = 0.972484034697570022801960678576810948164976541203097838;
        points[59] = 0.982808810593727234862511405691611739202599161956207342;
        points[60] = 0.99072854689218946681089466720470345305426226535032778;
        points[61] = 0.996224012777970108602193361146311353293076971857523298;
        points[62] = 0.999282984029123780378936140928944461072796718186242813;
        weights[0] = 0.00183987459557708411709244555404392385263847233884024248;
        weights[1] = 0.0042785083468637618660784110826227855171274726708752114;
        weights[2] = 0.00671029176596013625190693072972880397343602855571611024;
        weights[3] = 0.00912596867632665635405864542175995484969241778837534967;
        weights[4] = 0.0115193760768800417507506061486180648415887939453889832;
        weights[5] = 0.0138846126161156108248660863676244349192776582534906475;
        weights[6] = 0.016215878410338338882283672975130914915815603829930901;
        weights[7] = 0.0185074644601612704092605458051579631102389214176312854;
        weights[8] = 0.0207537612580390907753419534214731533478132648784418211;
        weights[9] = 0.0229492710048899331489423195617705058910474999190868284;
        weights[10] = 0.0250886205533449866186301380684433561023538074476335724;
        weights[11] = 0.0271665743590979332251898394394127266066426839866291275;
        weights[12] = 0.0291780472082805269455515021540288022829409459208054268;
        weights[13] = 0.0311181166222198175082159885571885820249111895329151127;
        weights[14] = 0.0329820348837793417656831796724593071377942161572778556;
        weights[15] = 0.0347652406453558776971805046427881571070733024941471943;
        weights[16] = 0.0364633700854572896304524097875417918318329502542965112;
        weights[17] = 0.0380722675843495567636383249278892186273033572541754295;
        weights[18] = 0.0395879958915440939848079281492023644541949391141024388;
        weights[19] = 0.0410068457596663986351100370090723507401779662124993039;
        weights[20] = 0.0423253450208158229825054854030274564828433789141963751;
        weights[21] = 0.0435402670830275907989643157044011396409312119283805381;
        weights[22] = 0.0446486388259413953703326695168133932341005635625203337;
        weights[23] = 0.0456477478762926086858859926085425224266073239389639298;
        weights[24] = 0.0465351492453836965103954187469531872278224771737984217;
        weights[25] = 0.0473086713122689190806049883388440623866200019726457181;
        weights[26] = 0.0479664211379951314110527561951322536106849214321465806;
        weights[27] = 0.048506789097883847864090099145801582027591769247826655;
        weights[28] = 0.0489284528205119899447093615492148212325258099816152682;
        weights[29] = 0.0492303804237475607850431169881445875918765328199142233;
        weights[30] = 0.0494118330399181789670396461167048596977283900845409696;
        weights[31] = 0.0494723666239310208886693604209259446135322539423832672;
        weights[32] = 0.0494118330399181789670396461167048596977283900845409696;
        weights[33] = 0.0492303804237475607850431169881445875918765328199142233;
        weights[34] = 0.0489284528205119899447093615492148212325258099816152682;
        weights[35] = 0.048506789097883847864090099145801582027591769247826655;
        weights[36] = 0.0479664211379951314110527561951322536106849214321465806;
        weights[37] = 0.0473086713122689190806049883388440623866200019726457181;
        weights[38] = 0.0465351492453836965103954187469531872278224771737984217;
        weights[39] = 0.0456477478762926086858859926085425224266073239389639298;
        weights[40] = 0.0446486388259413953703326695168133932341005635625203337;
        weights[41] = 0.0435402670830275907989643157044011396409312119283805381;
        weights[42] = 0.0423253450208158229825054854030274564828433789141963751;
        weights[43] = 0.0410068457596663986351100370090723507401779662124993039;
        weights[44] = 0.0395879958915440939848079281492023644541949391141024388;
        weights[45] = 0.0380722675843495567636383249278892186273033572541754295;
        weights[46] = 0.0364633700854572896304524097875417918318329502542965112;
        weights[47] = 0.0347652406453558776971805046427881571070733024941471943;
        weights[48] = 0.0329820348837793417656831796724593071377942161572778556;
        weights[49] = 0.0311181166222198175082159885571885820249111895329151127;
        weights[50] = 0.0291780472082805269455515021540288022829409459208054268;
        weights[51] = 0.0271665743590979332251898394394127266066426839866291275;
        weights[52] = 0.0250886205533449866186301380684433561023538074476335724;
        weights[53] = 0.0229492710048899331489423195617705058910474999190868284;
        weights[54] = 0.0207537612580390907753419534214731533478132648784418211;
        weights[55] = 0.0185074644601612704092605458051579631102389214176312854;
        weights[56] = 0.016215878410338338882283672975130914915815603829930901;
        weights[57] = 0.0138846126161156108248660863676244349192776582534906475;
        weights[58] = 0.0115193760768800417507506061486180648415887939453889832;
        weights[59] = 0.00912596867632665635405864542175995484969241778837534967;
        weights[60] = 0.00671029176596013625190693072972880397343602855571611024;
        weights[61] = 0.0042785083468637618660784110826227855171274726708752114;
        weights[62] = 0.00183987459557708411709244555404392385263847233884024248;
        return;
    case 64:
        points[0] = -0.999305041735772139456905624345636311969712191675608776;
        points[1] = -0.996340116771955279346924500676399123209857506340226612;
        points[2] = -0.991013371476744320739382383443303113641349445390790485;
        points[3] = -0.983336253884625956931299302156831116945247506623740384;
        points[4] = -0.973326827789910963741853507352272668026145294455174176;
        points[5] = -0.961008799652053718918614121897157206762114611037845949;
        points[6] = -0.94641137485840281606248149134726479527939497179523319;
        points[7] = -0.929569172131939575821490154559225607347427014429715498;
        points[8] = -0.910522137078502805756380668008329861013488084888364029;
        points[9] = -0.889315445995114105853404038272851622429194461510452189;
        points[10] = -0.865999398154092819760783385070157502412501918758249643;
        points[11] = -0.840629296252580362751691544695873302982489823801755354;
        points[12] = -0.813265315122797559741923338086303340698141822565597217;
        points[13] = -0.783972358943341407610220525213768284056414124989825933;
        points[14] = -0.752819907260531896611863774885693985551714271322087193;
        points[15] = -0.719881850171610826848940217831947244758138003314901953;
        points[16] = -0.685236313054233242563558371031376301935641078539671868;
        points[17] = -0.648965471254657339857761231993404885529690433473201173;
        points[18] = -0.611155355172393250248852971018548918696124559307971844;
        points[19] = -0.571895646202634034283878116659188643183191006091250993;
        points[20] = -0.531279464019894545658013903544455247408525588734180238;
        points[21] = -0.489403145707052957478526307021921390849373297463739837;
        points[22] = -0.446366017253464087984947714758915189206750757826250176;
        points[23] = -0.402270157963991603695766771260158848713265205615020808;
        points[24] = -0.357220158337668115950442615046202531626264464640909112;
        points[25] = -0.311322871990210956157512698560156883557715357868050127;
        points[26] = -0.264687162208767416373964172510020117980413136295093244;
        points[27] = -0.217423643740007084149648748988822617578485831141222349;
        points[28] = -0.169644420423992818037313629748269844199990266734377851;
        points[29] = -0.121462819296120554470376463492247878218683638337191294;
        points[30] = -0.0729931217877990394495429419403374932441261816687788534;
        points[31] = -0.0243502926634244325089558428537156614268871093149758092;
        points[32] = 0.0243502926634244325089558428537156614268871093149758092;
        points[33] = 0.0729931217877990394495429419403374932441261816687788534;
        points[34] = 0.121462819296120554470376463492247878218683638337191294;
        points[35] = 0.169644420423992818037313629748269844199990266734377851;
        points[36] = 0.217423643740007084149648748988822617578485831141222349;
        points[37] = 0.264687162208767416373964172510020117980413136295093244;
        points[38] = 0.311322871990210956157512698560156883557715357868050127;
        points[39] = 0.357220158337668115950442615046202531626264464640909112;
        points[40] = 0.402270157963991603695766771260158848713265205615020808;
        points[41] = 0.446366017253464087984947714758915189206750757826250176;
        points[42] = 0.489403145707052957478526307021921390849373297463739837;
        points[43] = 0.531279464019894545658013903544455247408525588734180238;
        points[44] = 0.571895646202634034283878116659188643183191006091250993;
        points[45] = 0.611155355172393250248852971018548918696124559307971844;
        points[46] = 0.648965471254657339857761231993404885529690433473201173;
        points[47] = 0.685236313054233242563558371031376301935641078539671868;
        points[48] = 0.719881850171610826848940217831947244758138003314901953;
        points[49] = 0.752819907260531896611863774885693985551714271322087193;
        points[50] = 0.783972358943341407610220525213768284056414124989825933;
        points[51] = 0.813265315122797559741923338086303340698141822565597217;
        points[52] = 0.840629296252580362751691544695873302982489823801755354;
        points[53] = 0.865999398154092819760783385070157502412501918758249643;
        points[54] = 0.889315445995114105853404038272851622429194461510452189;
        points[55] = 0.910522137078502805756380668008329861013488084888364029;
        points[56] = 0.929569172131939575821490154559225607347427014429715498;
        points[57] = 0.94641137485840281606248149134726479527939497179523319;
        points[58] = 0.961008799652053718918614121897157206762114611037845949;
        points[59] = 0.973326827789910963741853507352272668026145294455174176;
        points[60] = 0.983336253884625956931299302156831116945247506623740384;
        points[61] = 0.991013371476744320739382383443303113641349445390790485;
        points[62] = 0.996340116771955279346924500676399123209857506340226612;
        points[63] = 0.999305041735772139456905624345636311969712191675608776;
        weights[0] = 0.00178328072169643294729607914497193317995934727192795567;
        weights[1] = 0.00414703326056246763528753572855141531330281925368480246;
        weights[2] = 0.0065044579689783628561173603999812667711317610549523401;
        weights[3] = 0.0088467598263639477230309146597306476951762660792204998;
        weights[4] = 0.0111681394601311288185904930192081350727787978168272872;
        weights[5] = 0.0134630478967186425980607666859556841084257719773496708;
        weights[6] = 0.0157260304760247193219659952975397944260290098431565122;
        weights[7] = 0.0179517157756973430850453020011193688971673570364158573;
        weights[8] = 0.0201348231535302093723403167285438970895266801007919519;
        weights[9] = 0.0222701738083832541592983303841550024229592905997594051;
        weights[10] = 0.024352702568710873338177550409068987649978415513378412;
        weights[11] = 0.0263774697150546586716917926252251856755993308422457184;
        weights[12] = 0.028339672614259483227511305200237351981207584125754336;
        weights[13] = 0.0302346570724024788679740598195486591582813977684812416;
        weights[14] = 0.0320579283548515535854675043478987169662215738813980623;
        weights[15] = 0.0338051618371416093915654821107254310210499263140045347;
        weights[16] = 0.0354722132568823838106931467152459479480946310024100947;
        weights[17] = 0.0370551285402400460404151018095833750834649453056563022;
        weights[18] = 0.038550153178615629128962496946808991012787112201718032;
        weights[19] = 0.0399537411327203413866569261283360739186769506703336301;
        weights[20] = 0.0412625632426235286101562974736380477399306355305474105;
        weights[21] = 0.0424735151236535890073397679088173661655466481806496697;
        weights[22] = 0.0435837245293234533768278609737374809227888974971180151;
        weights[23] = 0.0445905581637565630601347100309448432940237999912217256;
        weights[24] = 0.0454916279274181444797709969712690588873234618023998968;
        weights[25] = 0.0462847965813144172959532492322611849696503075324468008;
        weights[26] = 0.046968182816210017325326285754581075199897528473812565;
        weights[27] = 0.0475401657148303086622822069442231716408252512625387522;
        weights[28] = 0.0479993885964583077281261798713460699543167134714936209;
        weights[29] = 0.0483447622348029571697695271580178097036925506095010806;
        weights[30] = 0.0485754674415034269347990667839781136875565447049294857;
        weights[31] = 0.0486909570091397203833653907347499124426286922838743305;
        weights[32] = 0.0486909570091397203833653907347499124426286922838743305;
        weights[33] = 0.0485754674415034269347990667839781136875565447049294857;
        weights[34] = 0.0483447622348029571697695271580178097036925506095010806;
        weights[35] = 0.0479993885964583077281261798713460699543167134714936209;
        weights[36] = 0.0475401657148303086622822069442231716408252512625387522;
        weights[37] = 0.046968182816210017325326285754581075199897528473812565;
        weights[38] = 0.0462847965813144172959532492322611849696503075324468008;
        weights[39] = 0.0454916279274181444797709969712690588873234618023998968;
        weights[40] = 0.0445905581637565630601347100309448432940237999912217256;
        weights[41] = 0.0435837245293234533768278609737374809227888974971180151;
        weights[42] = 0.0424735151236535890073397679088173661655466481806496697;
        weights[43] = 0.0412625632426235286101562974736380477399306355305474105;
        weights[44] = 0.0399537411327203413866569261283360739186769506703336301;
        weights[45] = 0.038550153178615629128962496946808991012787112201718032;
        weights[46] = 0.0370551285402400460404151018095833750834649453056563022;
        weights[47] = 0.0354722132568823838106931467152459479480946310024100947;
        weights[48] = 0.0338051618371416093915654821107254310210499263140045347;
        weights[49] = 0.0320579283548515535854675043478987169662215738813980623;
        weights[50] = 0.0302346570724024788679740598195486591582813977684812416;
        weights[51] = 0.028339672614259483227511305200237351981207584125754336;
        weights[52] = 0.0263774697150546586716917926252251856755993308422457184;
        weights[53] = 0.024352702568710873338177550409068987649978415513378412;
        weights[54] = 0.0222701738083832541592983303841550024229592905997594051;
        weights[55] = 0.0201348231535302093723403167285438970895266801007919519;
        weights[56] = 0.0179517157756973430850453020011193688971673570364158573;
        weights[57] = 0.0157260304760247193219659952975397944260290098431565122;
        weights[58] = 0.0134630478967186425980607666859556841084257719773496708;
        weights[59] = 0.0111681394601311288185904930192081350727787978168272872;
        weights[60] = 0.0088467598263639477230309146597306476951762660792204998;
        weights[61] = 0.0065044579689783628561173603999812667711317610549523401;
        weights[62] = 0.00414703326056246763528753572855141531330281925368480246;
        weights[63] = 0.00178328072169643294729607914497193317995934727192795567;
        return;
    case 65:
        points[0] = -0.999326097075412877265693611242147839727936466325934719;
        points[1] = -0.996450948061849163055794938322130784199571786197431583;
        points[2] = -0.99128527617680166872182118106555181388231858638706953;
        points[3] = -0.983839812187034941377637781406066151386596195195840348;
        points[4] = -0.974131539833551169074967887390882895028016694010165648;
        points[5] = -0.962182754718055237711983746467235152493900785656861058;
        points[6] = -0.948020928168407506373769740729286442950295938040169402;
        points[7] = -0.931678628228749337965676987346386047829031407175708404;
        points[8] = -0.913193440542846261736546920982943797907473542612764773;
        points[9] = -0.892607880504738931423285539697500346473871357358717609;
        points[10] = -0.869969294926407036194131958064681326980026934032477642;
        points[11] = -0.845329752899930283942450040735212240645846705304993511;
        points[12] = -0.818745925922651453433919137325798496917470913855979813;
        points[13] = -0.790278957492121843047380416074025449215359039597379682;
        points[14] = -0.759994322441999786873982753116218181338218039483768301;
        points[15] = -0.727961676329424679011973729293198108794050778992376341;
        points[16] = -0.6942546952139916335526224799476448569205159785618265;
        points[17] = -0.658950906193625133040940771960806243984938646175240435;
        points[18] = -0.622131509085400241582599551863802289196064895999243565;
        points[19] = -0.583881189660487313327154462431943612843680166213011755;
        points[20] = -0.544287924862227138545572479747507013226531789982564449;
        points[21] = -0.503442780455006882341043051391038431794343020784289443;
        points[22] = -0.461439701569145057697834100101223929269113888048437132;
        points[23] = -0.41837529662340900926419901075299090344774772143902879;
        points[24] = -0.374348615122066012008793890843023997261194798157029527;
        points[25] = -0.329460919837486407645286712412878443905650240023146395;
        points[26] = -0.283815453902248730617655425960476713778729938071873556;
        points[27] = -0.237517203346416806570712427321939481992152527530063084;
        points[28] = -0.190672655626142769774912359066004515727978438359738359;
        points[29] = -0.143389554698975171131249621985861443718057413189041358;
        points[30] = -0.0957766532091975056522185545424478102243369785399036143;
        points[31] = -0.0479434623531718575225297542899348479423417464951980059;
        points[32] = 0;
        points[33] = 0.0479434623531718575225297542899348479423417464951980059;
        points[34] = 0.0957766532091975056522185545424478102243369785399036143;
        points[35] = 0.143389554698975171131249621985861443718057413189041358;
        points[36] = 0.190672655626142769774912359066004515727978438359738359;
        points[37] = 0.237517203346416806570712427321939481992152527530063084;
        points[38] = 0.283815453902248730617655425960476713778729938071873556;
        points[39] = 0.329460919837486407645286712412878443905650240023146395;
        points[40] = 0.374348615122066012008793890843023997261194798157029527;
        points[41] = 0.41837529662340900926419901075299090344774772143902879;
        points[42] = 0.461439701569145057697834100101223929269113888048437132;
        points[43] = 0.503442780455006882341043051391038431794343020784289443;
        points[44] = 0.544287924862227138545572479747507013226531789982564449;
        points[45] = 0.583881189660487313327154462431943612843680166213011755;
        points[46] = 0.622131509085400241582599551863802289196064895999243565;
        points[47] = 0.658950906193625133040940771960806243984938646175240435;
        points[48] = 0.6942546952139916335526224799476448569205159785618265;
        points[49] = 0.727961676329424679011973729293198108794050778992376341;
        points[50] = 0.759994322441999786873982753116218181338218039483768301;
        points[51] = 0.790278957492121843047380416074025449215359039597379682;
        points[52] = 0.818745925922651453433919137325798496917470913855979813;
        points[53] = 0.845329752899930283942450040735212240645846705304993511;
        points[54] = 0.869969294926407036194131958064681326980026934032477642;
        points[55] = 0.892607880504738931423285539697500346473871357358717609;
        points[56] = 0.913193440542846261736546920982943797907473542612764773;
        points[57] = 0.931678628228749337965676987346386047829031407175708404;
        points[58] = 0.948020928168407506373769740729286442950295938040169402;
        points[59] = 0.962182754718055237711983746467235152493900785656861058;
        points[60] = 0.974131539833551169074967887390882895028016694010165648;
        points[61] = 0.983839812187034941377637781406066151386596195195840348;
        points[62] = 0.99128527617680166872182118106555181388231858638706953;
        points[63] = 0.996450948061849163055794938322130784199571786197431583;
        points[64] = 0.999326097075412877265693611242147839727936466325934719;
        weights[0] = 0.0017292582513002508983395851463039377959561964124784884;
        weights[1] = 0.00402152417200373634707865995282875048468222950319682517;
        weights[2] = 0.00630794257897175455018887190386157109027938640885812619;
        weights[3] = 0.00858014826688145989363581215919812634378621179126470189;
        weights[4] = 0.0108326787895979686215140551272022609271806737221625139;
        weights[5] = 0.0130603116399948463361683429219155172188288200449441813;
        weights[6] = 0.0152579121464483103492653881446228117231372051424117173;
        weights[7] = 0.0174204219976702484953657599691980581920723835076922387;
        weights[8] = 0.019542865836750062826837429313001196837510010477939859;
        weights[9] = 0.0216203612849340628416542746674863712505377365748340193;
        weights[10] = 0.0236481296912872366987809789939901317473315012187950327;
        weights[11] = 0.0256215069380377582140849786935481087424279799194076776;
        weights[12] = 0.0275359540884503439424997223271138376133869834039111236;
        weights[13] = 0.0293870677893106680626448592097737400720759977954941344;
        weights[14] = 0.0311705903801891424644318457766610608829695058462746303;
        weights[15] = 0.0328824196763685749840496380081423129244764973983661516;
        weights[16] = 0.0345186183985490586252212768593925134265223413516449177;
        weights[17] = 0.0360754232255652739321662705244535993695095139996198745;
        weights[18] = 0.0375492534482577098097722231982534366339924266879394096;
        weights[19] = 0.0389367192040511976166738063639470973890826959945470156;
        weights[20] = 0.0402346292730055338154463377433756980405197321226331371;
        weights[21] = 0.0414399984172402930226862992325431859767140077504297321;
        weights[22] = 0.0425500542467558027192171508026537405624256390024983974;
        weights[23] = 0.0435622435958004865322848216613986457490912680230607385;
        weights[24] = 0.0444742383950829744273235039999460242794817050739289604;
        weights[25] = 0.0452839410263002306571282405741799764070605761459167825;
        weights[26] = 0.0459894891466516969638933908178345050250393874265806839;
        weights[27] = 0.0465892599722334983022551367896927343102522359614812994;
        weights[28] = 0.0470818740104545222460068082901623670186743604178590025;
        weights[29] = 0.0474661982328855031526444587400259142208235089438786138;
        weights[30] = 0.0477413486812406215590389722265560270828579632742446702;
        weights[31] = 0.0479066925004958620313472891762263656155111752062376673;
        weights[32] = 0.0479618493944666181207076213690207500916042868989353521;
        weights[33] = 0.0479066925004958620313472891762263656155111752062376673;
        weights[34] = 0.0477413486812406215590389722265560270828579632742446702;
        weights[35] = 0.0474661982328855031526444587400259142208235089438786138;
        weights[36] = 0.0470818740104545222460068082901623670186743604178590025;
        weights[37] = 0.0465892599722334983022551367896927343102522359614812994;
        weights[38] = 0.0459894891466516969638933908178345050250393874265806839;
        weights[39] = 0.0452839410263002306571282405741799764070605761459167825;
        weights[40] = 0.0444742383950829744273235039999460242794817050739289604;
        weights[41] = 0.0435622435958004865322848216613986457490912680230607385;
        weights[42] = 0.0425500542467558027192171508026537405624256390024983974;
        weights[43] = 0.0414399984172402930226862992325431859767140077504297321;
        weights[44] = 0.0402346292730055338154463377433756980405197321226331371;
        weights[45] = 0.0389367192040511976166738063639470973890826959945470156;
        weights[46] = 0.0375492534482577098097722231982534366339924266879394096;
        weights[47] = 0.0360754232255652739321662705244535993695095139996198745;
        weights[48] = 0.0345186183985490586252212768593925134265223413516449177;
        weights[49] = 0.0328824196763685749840496380081423129244764973983661516;
        weights[50] = 0.0311705903801891424644318457766610608829695058462746303;
        weights[51] = 0.0293870677893106680626448592097737400720759977954941344;
        weights[52] = 0.0275359540884503439424997223271138376133869834039111236;
        weights[53] = 0.0256215069380377582140849786935481087424279799194076776;
        weights[54] = 0.0236481296912872366987809789939901317473315012187950327;
        weights[55] = 0.0216203612849340628416542746674863712505377365748340193;
        weights[56] = 0.019542865836750062826837429313001196837510010477939859;
        weights[57] = 0.0174204219976702484953657599691980581920723835076922387;
        weights[58] = 0.0152579121464483103492653881446228117231372051424117173;
        weights[59] = 0.0130603116399948463361683429219155172188288200449441813;
        weights[60] = 0.0108326787895979686215140551272022609271806737221625139;
        weights[61] = 0.00858014826688145989363581215919812634378621179126470189;
        weights[62] = 0.00630794257897175455018887190386157109027938640885812619;
        weights[63] = 0.00402152417200373634707865995282875048468222950319682517;
        weights[64] = 0.0017292582513002508983395851463039377959561964124784884;
        return;
    case 66:
        points[0] = -0.999346209872177882072816984489753403848979817761245522;
        points[1] = -0.996556821089552691122168293627165523147422609860954938;
        points[2] = -0.991545030383375745531762687491502465237964045027890786;
        points[3] = -0.984320904935140132890553113349730451954641606328851891;
        points[4] = -0.974900427746285951855898159795578510090484186910214205;
        points[5] = -0.963304586859257370964861164121587602322143158548154983;
        points[6] = -0.949559246206235339092466777753084072563626669404721795;
        points[7] = -0.933695072544792494372631654664544249101575540342455808;
        points[8] = -0.91574746294520701595042923218565013267573646272893754;
        points[9] = -0.89575646444656393846083634211596791867452056395376704;
        points[10] = -0.873766684166944730401005225238847614070817815072478701;
        points[11] = -0.849827189536016219462098282766272992753464253334736765;
        points[12] = -0.823991398695587611347081960456280207616217687403235901;
        points[13] = -0.796316961245824570532729752983942713705904689774954966;
        points[14] = -0.766865629575319625869542961572164001907062667408906853;
        points[15] = -0.735703121049512799579236998853608089181358039692465954;
        points[16] = -0.702898971358874185836259249186332773833324859759647908;
        points[17] = -0.668526379350967592604287159515839127751556866078531818;
        points[18] = -0.632662043690963169403894629790963211930001398723857427;
        points[19] = -0.595385991714138458327934361973917511629777683415722127;
        points[20] = -0.556781400851723064234947814414697267306050565270026881;
        points[21] = -0.516934413028231513572575402172146270874893104916999539;
        points[22] = -0.475933942444236842961930014463218415035287995158227952;
        points[23] = -0.433871477173370668357695636159347366022314937083437581;
        points[24] = -0.390840875016182949755122144974839972496275272130517696;
        points[25] = -0.346938154066337548899754734326809211560657652280080592;
        points[26] = -0.302261278456436100016128915137292973942246163191935053;
        points[27] = -0.256909939761530222994199579118647798357495906891842156;
        points[28] = -0.210985334548078993474541148946684699703463219276653818;
        points[29] = -0.164589938564714607253650518758744249833372372215304334;
        points[30] = -0.117827278078675997114714302633065447256454282688411791;
        points[31] = -0.0708016988681415912893636751363687998249144872476126015;
        points[32] = -0.0236181333859245705362233216019617321949581503302017119;
        points[33] = 0.0236181333859245705362233216019617321949581503302017119;
        points[34] = 0.0708016988681415912893636751363687998249144872476126015;
        points[35] = 0.117827278078675997114714302633065447256454282688411791;
        points[36] = 0.164589938564714607253650518758744249833372372215304334;
        points[37] = 0.210985334548078993474541148946684699703463219276653818;
        points[38] = 0.256909939761530222994199579118647798357495906891842156;
        points[39] = 0.302261278456436100016128915137292973942246163191935053;
        points[40] = 0.346938154066337548899754734326809211560657652280080592;
        points[41] = 0.390840875016182949755122144974839972496275272130517696;
        points[42] = 0.433871477173370668357695636159347366022314937083437581;
        points[43] = 0.475933942444236842961930014463218415035287995158227952;
        points[44] = 0.516934413028231513572575402172146270874893104916999539;
        points[45] = 0.556781400851723064234947814414697267306050565270026881;
        points[46] = 0.595385991714138458327934361973917511629777683415722127;
        points[47] = 0.632662043690963169403894629790963211930001398723857427;
        points[48] = 0.668526379350967592604287159515839127751556866078531818;
        points[49] = 0.702898971358874185836259249186332773833324859759647908;
        points[50] = 0.735703121049512799579236998853608089181358039692465954;
        points[51] = 0.766865629575319625869542961572164001907062667408906853;
        points[52] = 0.796316961245824570532729752983942713705904689774954966;
        points[53] = 0.823991398695587611347081960456280207616217687403235901;
        points[54] = 0.849827189536016219462098282766272992753464253334736765;
        points[55] = 0.873766684166944730401005225238847614070817815072478701;
        points[56] = 0.89575646444656393846083634211596791867452056395376704;
        points[57] = 0.91574746294520701595042923218565013267573646272893754;
        points[58] = 0.933695072544792494372631654664544249101575540342455808;
        points[59] = 0.949559246206235339092466777753084072563626669404721795;
        points[60] = 0.963304586859257370964861164121587602322143158548154983;
        points[61] = 0.974900427746285951855898159795578510090484186910214205;
        points[62] = 0.984320904935140132890553113349730451954641606328851891;
        points[63] = 0.991545030383375745531762687491502465237964045027890786;
        points[64] = 0.996556821089552691122168293627165523147422609860954938;
        points[65] = 0.999346209872177882072816984489753403848979817761245522;
        weights[0] = 0.00167765374400723859933157293957680009127017189618466718;
        weights[1] = 0.0039016256417442482592284604022347425657962813364451894;
        weights[2] = 0.00612019201844793636556792675993255347330644157955356125;
        weights[3] = 0.0083253887659909014167255456738388969693587825804785884;
        weights[4] = 0.0105120659877057546573769278249091721081347052297638458;
        weights[5] = 0.012675303981261681876445189049054375238138894955081374;
        weights[6] = 0.0148102650027339601736425397826051036863065555219911125;
        weights[7] = 0.0169121814722452171803502951016955502926760434503884133;
        weights[8] = 0.0189763617227713259348670383819130757861983495926243214;
        weights[9] = 0.0209981990918646257773310444331174416065477902625105407;
        weights[10] = 0.0229731817353266559180986454391924792162326571951321387;
        weights[11] = 0.0248969025147573726377309318503257938091117005982664636;
        weights[12] = 0.0267650687542500019087929683072975443072302868403642211;
        weights[13] = 0.0285735117829318711828222973919594511439316321028019622;
        weights[14] = 0.0303181962188685191936407585817467320061137981796811734;
        weights[15] = 0.0319952289640468872712817209497004935905944977073205995;
        weights[16] = 0.0336008678861122326703489271970391461054615942172646311;
        weights[17] = 0.0351315301654725559006410962600436013726504752913634276;
        weights[18] = 0.0365838002881390944136899614906125735117125404444528872;
        weights[19] = 0.0379544376659416209491300993985636595296878140811692359;
        weights[20] = 0.0392403838668283301878128594897690446939494249665888243;
        weights[21] = 0.0404387694389549791258683759329467465993781398673277356;
        weights[22] = 0.0415469203132418813177345366874209908558263933349199698;
        weights[23] = 0.0425623637700557163189067387701321603740804474325544207;
        weights[24] = 0.0434828339566674786475753900171389317346151979363735976;
        weights[25] = 0.0443062769431531619046033551088787193340258854538747776;
        weights[26] = 0.0450308553054415002151928068372887902361572512064144933;
        weights[27] = 0.0456549522252730561204388422105844803377556116308568693;
        weights[28] = 0.0461771750979159754716664715730462420485391845245097895;
        weights[29] = 0.046596358639584103625824137822294161475154741569596168;
        weights[30] = 0.0469115674876208277462540409522384425988782346902238934;
        weights[31] = 0.0471220982876447321854451696446542350705537445376078907;
        weights[32] = 0.0472274812629985548456333277382478682306247297863132158;
        weights[33] = 0.0472274812629985548456333277382478682306247297863132158;
        weights[34] = 0.0471220982876447321854451696446542350705537445376078907;
        weights[35] = 0.0469115674876208277462540409522384425988782346902238934;
        weights[36] = 0.046596358639584103625824137822294161475154741569596168;
        weights[37] = 0.0461771750979159754716664715730462420485391845245097895;
        weights[38] = 0.0456549522252730561204388422105844803377556116308568693;
        weights[39] = 0.0450308553054415002151928068372887902361572512064144933;
        weights[40] = 0.0443062769431531619046033551088787193340258854538747776;
        weights[41] = 0.0434828339566674786475753900171389317346151979363735976;
        weights[42] = 0.0425623637700557163189067387701321603740804474325544207;
        weights[43] = 0.0415469203132418813177345366874209908558263933349199698;
        weights[44] = 0.0404387694389549791258683759329467465993781398673277356;
        weights[45] = 0.0392403838668283301878128594897690446939494249665888243;
        weights[46] = 0.0379544376659416209491300993985636595296878140811692359;
        weights[47] = 0.0365838002881390944136899614906125735117125404444528872;
        weights[48] = 0.0351315301654725559006410962600436013726504752913634276;
        weights[49] = 0.0336008678861122326703489271970391461054615942172646311;
        weights[50] = 0.0319952289640468872712817209497004935905944977073205995;
        weights[51] = 0.0303181962188685191936407585817467320061137981796811734;
        weights[52] = 0.0285735117829318711828222973919594511439316321028019622;
        weights[53] = 0.0267650687542500019087929683072975443072302868403642211;
        weights[54] = 0.0248969025147573726377309318503257938091117005982664636;
        weights[55] = 0.0229731817353266559180986454391924792162326571951321387;
        weights[56] = 0.0209981990918646257773310444331174416065477902625105407;
        weights[57] = 0.0189763617227713259348670383819130757861983495926243214;
        weights[58] = 0.0169121814722452171803502951016955502926760434503884133;
        weights[59] = 0.0148102650027339601736425397826051036863065555219911125;
        weights[60] = 0.012675303981261681876445189049054375238138894955081374;
        weights[61] = 0.0105120659877057546573769278249091721081347052297638458;
        weights[62] = 0.0083253887659909014167255456738388969693587825804785884;
        weights[63] = 0.00612019201844793636556792675993255347330644157955356125;
        weights[64] = 0.0039016256417442482592284604022347425657962813364451894;
        weights[65] = 0.00167765374400723859933157293957680009127017189618466718;
        return;
    case 67:
        points[0] = -0.999365435552976797970416317460717848694349626493986233;
        points[1] = -0.996658027206113735364370743603968226293097980442610234;
        points[2] = -0.991793347082309609461697774458626320997086458343226061;
        points[3] = -0.984780847755951113442592799844473165234707650740274731;
        points[4] = -0.975635583922908052394254411772012610324762811659268776;
        points[5] = -0.964377330427712611695647149930716287584270349429176606;
        points[6] = -0.951030459540145373212348138980838361813526397119158561;
        points[7] = -0.935623873270750876866652904788867800046380778310934619;
        points[8] = -0.918190936812738581247247289003136257575177182742701495;
        points[9] = -0.898769404961320375818489006838239551090042483188489054;
        points[10] = -0.877401339831658720400298181370340580984644264039429342;
        points[11] = -0.854133019537050650790743401660010198910256101077912023;
        points[12] = -0.829014837853301197689073948318830135708164336108999383;
        points[13] = -0.802101195021694434417253564592809976327144393821718645;
        points[14] = -0.773450379899980327541548909768341029833854577366322345;
        points[15] = -0.743124443704366206695961478027469772744609703337119541;
        points[16] = -0.711189065610040327854835944267750869621852155596552143;
        points[17] = -0.677713410498280828780525157184414331101247568286093492;
        points[18] = -0.642769979156615354278134186926244463447314264463674575;
        points[19] = -0.606434451255557386200297831173744134377046987015846728;
        points[20] = -0.568785521441471021257571687169966898010906565555769318;
        points[21] = -0.529904728900236016169800775697716945252874986506134379;
        points[22] = -0.48987628076064662609559297194023945982664814939046173;
        points[23] = -0.448786869719890883995132763371118135631320133363305068;
        points[24] = -0.406725486286013915985299316235310447660328674245595849;
        points[25] = -0.363783226043954170826044467174613446834373597953426578;
        points[26] = -0.320053092362536331066875187822148392498150487314688889;
        points[27] = -0.275629794969689587715555270951732551447858837975872357;
        points[28] = -0.230609544832115737925229867419608211238718268849618702;
        points[29] = -0.185089845783640168816231447423263705618567808453046557;
        points[30] = -0.139169283353523713563890694408504010866954664173752348;
        points[31] = -0.0929473112520798766317206559511767396844461371313871406;
        points[32] = -0.0465240359760172195646391284638115499589296944167082531;
        points[33] = 0;
        points[34] = 0.0465240359760172195646391284638115499589296944167082531;
        points[35] = 0.0929473112520798766317206559511767396844461371313871406;
        points[36] = 0.139169283353523713563890694408504010866954664173752348;
        points[37] = 0.185089845783640168816231447423263705618567808453046557;
        points[38] = 0.230609544832115737925229867419608211238718268849618702;
        points[39] = 0.275629794969689587715555270951732551447858837975872357;
        points[40] = 0.320053092362536331066875187822148392498150487314688889;
        points[41] = 0.363783226043954170826044467174613446834373597953426578;
        points[42] = 0.406725486286013915985299316235310447660328674245595849;
        points[43] = 0.448786869719890883995132763371118135631320133363305068;
        points[44] = 0.48987628076064662609559297194023945982664814939046173;
        points[45] = 0.529904728900236016169800775697716945252874986506134379;
        points[46] = 0.568785521441471021257571687169966898010906565555769318;
        points[47] = 0.606434451255557386200297831173744134377046987015846728;
        points[48] = 0.642769979156615354278134186926244463447314264463674575;
        points[49] = 0.677713410498280828780525157184414331101247568286093492;
        points[50] = 0.711189065610040327854835944267750869621852155596552143;
        points[51] = 0.743124443704366206695961478027469772744609703337119541;
        points[52] = 0.773450379899980327541548909768341029833854577366322345;
        points[53] = 0.802101195021694434417253564592809976327144393821718645;
        points[54] = 0.829014837853301197689073948318830135708164336108999383;
        points[55] = 0.854133019537050650790743401660010198910256101077912023;
        points[56] = 0.877401339831658720400298181370340580984644264039429342;
        points[57] = 0.898769404961320375818489006838239551090042483188489054;
        points[58] = 0.918190936812738581247247289003136257575177182742701495;
        points[59] = 0.935623873270750876866652904788867800046380778310934619;
        points[60] = 0.951030459540145373212348138980838361813526397119158561;
        points[61] = 0.964377330427712611695647149930716287584270349429176606;
        points[62] = 0.975635583922908052394254411772012610324762811659268776;
        points[63] = 0.984780847755951113442592799844473165234707650740274731;
        points[64] = 0.991793347082309609461697774458626320997086458343226061;
        points[65] = 0.996658027206113735364370743603968226293097980442610234;
        points[66] = 0.999365435552976797970416317460717848694349626493986233;
        weights[0] = 0.00162832503524001286646294622189984016353339061144065925;
        weights[1] = 0.0037870083018255084459639168904917828772952495514854382;
        weights[2] = 0.00594069317758223521651336249848012099092897821576293964;
        weights[3] = 0.0080817902990231362153462846924804676737374396179203113;
        weights[4] = 0.0102054400341024409866618690046801834277869047830844079;
        weights[5] = 0.0123070038492881505219541475509542699524789727277993393;
        weights[6] = 0.0143819198272005509309773844232621123987554588768335187;
        weights[7] = 0.0164256906225308792047268102764306925185379225442126459;
        weights[8] = 0.0184338884568045738721659990305259470949373902245231805;
        weights[9] = 0.0204021633713435404492572826207279382578363097510037809;
        weights[10] = 0.0223262521964520769227973111513586620963965540514354048;
        weights[11] = 0.0242019876096731647206918230391879289771963988863499196;
        weights[12] = 0.0260253070862132388037050422861120268445740002467791202;
        weights[13] = 0.0277922616624367699871998305351297626679029611573191281;
        weights[14] = 0.0294990244709456696958472643758798840406153607805168407;
        weights[15] = 0.0311418990194728239374260083446965454035929925695974121;
        weights[16] = 0.0327173271915312054271223079525905290916410120405591831;
        weights[17] = 0.0342218969495366467398387642616566030805192812140912628;
        weights[18] = 0.0356523497227450066613326227872368893814207131612715802;
        weights[19] = 0.037005587463492582023135027178555341855599558187448557;
        weights[20] = 0.0382786793561794806476370583362313017161917295746388486;
        weights[21] = 0.0394688681643088826428868290900495527363518245999003879;
        weights[22] = 0.04057357620174452522725155693860581318994753597249059;
        weights[23] = 0.0415904109151992430985482641594300775145598532903499535;
        weights[24] = 0.0425171700658304914715477554095609078415358649294644783;
        weights[25] = 0.0433518464986995173591557637224285196593369011877415345;
        weights[26] = 0.0440926324897510183078315808822554874879260185392576822;
        weights[27] = 0.0447379236608898254721417672594502685273978020688793495;
        weights[28] = 0.0452863224546695315680500008761662924718834800747675451;
        weights[29] = 0.0457366411610636909368941785693893948130510878083740068;
        weights[30] = 0.0460879044897615761972173892883475749161556766904834857;
        weights[31] = 0.0463393516824156211084470486408646228418745976363828357;
        weights[32] = 0.0464904381602646282083146570531278805449690036749094777;
        weights[33] = 0.0465408367035635082499002893035095538870635495058503884;
        weights[34] = 0.0464904381602646282083146570531278805449690036749094777;
        weights[35] = 0.0463393516824156211084470486408646228418745976363828357;
        weights[36] = 0.0460879044897615761972173892883475749161556766904834857;
        weights[37] = 0.0457366411610636909368941785693893948130510878083740068;
        weights[38] = 0.0452863224546695315680500008761662924718834800747675451;
        weights[39] = 0.0447379236608898254721417672594502685273978020688793495;
        weights[40] = 0.0440926324897510183078315808822554874879260185392576822;
        weights[41] = 0.0433518464986995173591557637224285196593369011877415345;
        weights[42] = 0.0425171700658304914715477554095609078415358649294644783;
        weights[43] = 0.0415904109151992430985482641594300775145598532903499535;
        weights[44] = 0.04057357620174452522725155693860581318994753597249059;
        weights[45] = 0.0394688681643088826428868290900495527363518245999003879;
        weights[46] = 0.0382786793561794806476370583362313017161917295746388486;
        weights[47] = 0.037005587463492582023135027178555341855599558187448557;
        weights[48] = 0.0356523497227450066613326227872368893814207131612715802;
        weights[49] = 0.0342218969495366467398387642616566030805192812140912628;
        weights[50] = 0.0327173271915312054271223079525905290916410120405591831;
        weights[51] = 0.0311418990194728239374260083446965454035929925695974121;
        weights[52] = 0.0294990244709456696958472643758798840406153607805168407;
        weights[53] = 0.0277922616624367699871998305351297626679029611573191281;
        weights[54] = 0.0260253070862132388037050422861120268445740002467791202;
        weights[55] = 0.0242019876096731647206918230391879289771963988863499196;
        weights[56] = 0.0223262521964520769227973111513586620963965540514354048;
        weights[57] = 0.0204021633713435404492572826207279382578363097510037809;
        weights[58] = 0.0184338884568045738721659990305259470949373902245231805;
        weights[59] = 0.0164256906225308792047268102764306925185379225442126459;
        weights[60] = 0.0143819198272005509309773844232621123987554588768335187;
        weights[61] = 0.0123070038492881505219541475509542699524789727277993393;
        weights[62] = 0.0102054400341024409866618690046801834277869047830844079;
        weights[63] = 0.0080817902990231362153462846924804676737374396179203113;
        weights[64] = 0.00594069317758223521651336249848012099092897821576293964;
        weights[65] = 0.0037870083018255084459639168904917828772952495514854382;
        weights[66] = 0.00162832503524001286646294622189984016353339061144065925;
        return;
    case 68:
        points[0] = -0.999383825529704347163934050459670004573390570918937393;
        points[1] = -0.996754836676664292536173472131322173398214925474505685;
        points[2] = -0.992030887742448574647845302787386939979117674308160663;
        points[3] = -0.985220861440244638894495352930746837276199872188422331;
        points[4] = -0.976338950400356956942611559567048374141571609006640441;
        points[5] = -0.965403802582199803231954986555139768749338139041329593;
        points[6] = -0.952438404479602049323358824370307356907307358544799555;
        points[7] = -0.937470018312800886485620552442406837044698830404110264;
        points[8] = -0.920530120847918166460552363202734847091313522627248481;
        points[9] = -0.901654335920107830215709254536957763452163456438746115;
        points[10] = -0.88088235901745591769726413057748417729901888481346134;
        points[11] = -0.858257873582659845494962291728560387441655918630320186;
        points[12] = -0.833828459041670945820711027938652687597040492741830112;
        points[13] = -0.807645490689708665233626258729612335715434223873228823;
        points[14] = -0.779764031618897658744951296887000070456911839130807288;
        points[15] = -0.750242716902916519767578229818773054596859967966174986;
        points[16] = -0.719143630276472992623073444021475353217257492092198456;
        points[17] = -0.686532173566012944784356122405306532499570117020663595;
        points[18] = -0.652476929144676964200554684210327330505422607049256751;
        points[19] = -0.617049515699883422716947129412793540504376828792994466;
        points[20] = -0.580324437616350740175135238780440880853469263656738409;
        points[21] = -0.542378928291003385814490574555459868339556745175507648;
        points[22] = -0.503292787709084872635135283030467432213242346613408827;
        points[23] = -0.463148214622939039172771900030251680825054909296385413;
        points[24] = -0.422029633686313579146938791935479882863669800851361341;
        points[25] = -0.380023517907674477497964175754159008930973707625059842;
        points[26] = -0.337218206795880762727485239668058303296590043098405176;
        points[27] = -0.2937037205806387399784231188079046378098386624317781;
        points[28] = -0.249571570898416734511574761093973629018167577623949001;
        points[29] = -0.2049145683419392958425297811963051365853135898191112;
        points[30] = -0.159826627277978960995220462891633399966486090826812691;
        points[31] = -0.114402568343910684430577720166839865947858252918591585;
        points[32] = -0.0687379190383771522113900529329080477800006619876611418;
        points[33] = -0.0229287128254223497139962432541440276293666799363525178;
        points[34] = 0.0229287128254223497139962432541440276293666799363525178;
        points[35] = 0.0687379190383771522113900529329080477800006619876611418;
        points[36] = 0.114402568343910684430577720166839865947858252918591585;
        points[37] = 0.159826627277978960995220462891633399966486090826812691;
        points[38] = 0.2049145683419392958425297811963051365853135898191112;
        points[39] = 0.249571570898416734511574761093973629018167577623949001;
        points[40] = 0.2937037205806387399784231188079046378098386624317781;
        points[41] = 0.337218206795880762727485239668058303296590043098405176;
        points[42] = 0.380023517907674477497964175754159008930973707625059842;
        points[43] = 0.422029633686313579146938791935479882863669800851361341;
        points[44] = 0.463148214622939039172771900030251680825054909296385413;
        points[45] = 0.503292787709084872635135283030467432213242346613408827;
        points[46] = 0.542378928291003385814490574555459868339556745175507648;
        points[47] = 0.580324437616350740175135238780440880853469263656738409;
        points[48] = 0.617049515699883422716947129412793540504376828792994466;
        points[49] = 0.652476929144676964200554684210327330505422607049256751;
        points[50] = 0.686532173566012944784356122405306532499570117020663595;
        points[51] = 0.719143630276472992623073444021475353217257492092198456;
        points[52] = 0.750242716902916519767578229818773054596859967966174986;
        points[53] = 0.779764031618897658744951296887000070456911839130807288;
        points[54] = 0.807645490689708665233626258729612335715434223873228823;
        points[55] = 0.833828459041670945820711027938652687597040492741830112;
        points[56] = 0.858257873582659845494962291728560387441655918630320186;
        points[57] = 0.88088235901745591769726413057748417729901888481346134;
        points[58] = 0.901654335920107830215709254536957763452163456438746115;
        points[59] = 0.920530120847918166460552363202734847091313522627248481;
        points[60] = 0.937470018312800886485620552442406837044698830404110264;
        points[61] = 0.952438404479602049323358824370307356907307358544799555;
        points[62] = 0.965403802582199803231954986555139768749338139041329593;
        points[63] = 0.976338950400356956942611559567048374141571609006640441;
        points[64] = 0.985220861440244638894495352930746837276199872188422331;
        points[65] = 0.992030887742448574647845302787386939979117674308160663;
        points[66] = 0.996754836676664292536173472131322173398214925474505685;
        points[67] = 0.999383825529704347163934050459670004573390570918937393;
        weights[0] = 0.00158114025637291293909505879110088522006452703205703308;
        weights[1] = 0.00367736659501173063356808201954472409804606584558421839;
        weights[2] = 0.00576896991872995202146847154482818092374561099159650963;
        weights[3] = 0.00784871139317716741505046084617897197593093172391129207;
        weights[4] = 0.00991200125158593720913037839810814172992262138578143897;
        weights[5] = 0.0119544623197694421032230573069476048253406673025999456;
        weights[6] = 0.0139717891744576558159650257495670690492327445799285905;
        weights[7] = 0.0159597359096138000721334043207816550441665700780762082;
        weights[8] = 0.0179141204579231524894054647418151444011612645276624768;
        weights[9] = 0.0198308320879554982910286705829823110192013957875078368;
        weights[10] = 0.0217058396103780798014656808154624128587313914732501825;
        weights[11] = 0.0235351996858763333612929821079980145855066054935099122;
        weights[12] = 0.0253150650451763983239027106259933501336948776025344845;
        weights[13] = 0.0270416925459039615579781182894066143716322732442337776;
        weights[14] = 0.02871145102748499071080392009126806407731680909498927;
        weights[15] = 0.0303208289385539803415792836451648969831405841966331811;
        weights[16] = 0.0318664417168210649393476434206596932006654703266122112;
        weights[17] = 0.0333450389039806879031431278857716102440778524545075883;
        weights[18] = 0.0347535109797515131667931176706359076535136053286712365;
        weights[19] = 0.0360888959001798707149758249590250372882651140971031298;
        weights[20] = 0.0373483853261866677160791228936108890641947994031214076;
        weights[21] = 0.0385293305291067144932536329747254540849293636093458394;
        weights[22] = 0.0396292479607123080254064542895236341167450846133811571;
        weights[23] = 0.0406458244759540761408817271125462239695533503092187653;
        weights[24] = 0.041576922197402916484575482519379672006968341174507117;
        weights[25] = 0.0424205830111424993006142311083854816042159792725021235;
        weights[26] = 0.0431750326846442232258435305398237380725486031277321509;
        weights[27] = 0.0438386845979560520106049582824835901832826258646817545;
        weights[28] = 0.0444101430803527559093486993583644224445228374171958553;
        weights[29] = 0.0448882063454266678263521311872780305162832195914515648;
        weights[30] = 0.04527186901844377786941169899600124659459958076191088;
        weights[31] = 0.0455603242506482859807077125514453645737460175209075204;
        weights[32] = 0.0457529654160679505190061453476045903824825682483919654;
        weights[33] = 0.0458493873872509746865639890255873727025706465189013749;
        weights[34] = 0.0458493873872509746865639890255873727025706465189013749;
        weights[35] = 0.0457529654160679505190061453476045903824825682483919654;
        weights[36] = 0.0455603242506482859807077125514453645737460175209075204;
        weights[37] = 0.04527186901844377786941169899600124659459958076191088;
        weights[38] = 0.0448882063454266678263521311872780305162832195914515648;
        weights[39] = 0.0444101430803527559093486993583644224445228374171958553;
        weights[40] = 0.0438386845979560520106049582824835901832826258646817545;
        weights[41] = 0.0431750326846442232258435305398237380725486031277321509;
        weights[42] = 0.0424205830111424993006142311083854816042159792725021235;
        weights[43] = 0.041576922197402916484575482519379672006968341174507117;
        weights[44] = 0.0406458244759540761408817271125462239695533503092187653;
        weights[45] = 0.0396292479607123080254064542895236341167450846133811571;
        weights[46] = 0.0385293305291067144932536329747254540849293636093458394;
        weights[47] = 0.0373483853261866677160791228936108890641947994031214076;
        weights[48] = 0.0360888959001798707149758249590250372882651140971031298;
        weights[49] = 0.0347535109797515131667931176706359076535136053286712365;
        weights[50] = 0.0333450389039806879031431278857716102440778524545075883;
        weights[51] = 0.0318664417168210649393476434206596932006654703266122112;
        weights[52] = 0.0303208289385539803415792836451648969831405841966331811;
        weights[53] = 0.02871145102748499071080392009126806407731680909498927;
        weights[54] = 0.0270416925459039615579781182894066143716322732442337776;
        weights[55] = 0.0253150650451763983239027106259933501336948776025344845;
        weights[56] = 0.0235351996858763333612929821079980145855066054935099122;
        weights[57] = 0.0217058396103780798014656808154624128587313914732501825;
        weights[58] = 0.0198308320879554982910286705829823110192013957875078368;
        weights[59] = 0.0179141204579231524894054647418151444011612645276624768;
        weights[60] = 0.0159597359096138000721334043207816550441665700780762082;
        weights[61] = 0.0139717891744576558159650257495670690492327445799285905;
        weights[62] = 0.0119544623197694421032230573069476048253406673025999456;
        weights[63] = 0.00991200125158593720913037839810814172992262138578143897;
        weights[64] = 0.00784871139317716741505046084617897197593093172391129207;
        weights[65] = 0.00576896991872995202146847154482818092374561099159650963;
        weights[66] = 0.00367736659501173063356808201954472409804606584558421839;
        weights[67] = 0.00158114025637291293909505879110088522006452703205703308;
        return;
    case 69:
        points[0] = -0.999401427543244788208060967646121418501571749161728442;
        points[1] = -0.996847500485195100459497014953645209357845167340067408;
        points[2] = -0.992258266716853118700433913219466785756114568711453183;
        points[3] = -0.985642080022637593237139352621122545919741596491455174;
        points[4] = -0.977012331622094263389466091021529505984530174637742792;
        points[5] = -0.966386621642860566855799811670797215491623114185112405;
        points[6] = -0.95378664780518189753393983763110313143686431029405191;
        points[7] = -0.939238147041608472966835800156577238157035986768503204;
        points[8] = -0.922770839180444997188817784539705526962242686306349978;
        points[9] = -0.9044183649858271400665248332365862991144343228053598;
        points[10] = -0.884218216947252436662818857563874950920790269303617986;
        points[11] = -0.862211662472744083857172022828939726551682034096877177;
        points[12] = -0.838443659480504213261616472985085945938309810474838293;
        points[13] = -0.81296276450029561385648008097595354706093003983226222;
        points[14] = -0.785821033446759760335369049080552068152902401373973682;
        points[15] = -0.757073915255837851594723194432757345040595811560041361;
        points[16] = -0.726780138596008088657160129952025250195829144929850753;
        points[17] = -0.69500159188292846092974385228659798190073111133365284;
        points[18] = -0.66180319684107824402422623161480798577943791482291333;
        points[19] = -0.627252775869849401767457558667283824227201598428127082;
        points[20] = -0.591420913484555825569309504422024967467834297545004188;
        points[21] = -0.554380812115132014537972991218126579208803180098405525;
        points[22] = -0.516208142556933709171820720450272673190290622857118178;
        points[23] = -0.476980889379045710341440876655055089165849446756501419;
        points[24] = -0.436779191605844420869876893385921824711636148983037638;
        points[25] = -0.395685178997244447351756104594377325152207198132734431;
        points[26] = -0.35378280426206631796012709345286970077740760587556785;
        points[27] = -0.311157671547281186585905330322717104526806291920954782;
        points[28] = -0.267896861553503428581598596625442939347823208479327444;
        points[29] = -0.224088753633999013281464115083415341105068244677770299;
        points[30] = -0.179822845240643164359713218106239913411693524126622252;
        points[31] = -0.13518956908568299215847160396991714534378725948922809;
        points[32] = -0.0902801083928287425621196670640081146019718414708110496;
        points[33] = -0.045186210615101723531632403458113391993108492552853503;
        points[34] = 0;
        points[35] = 0.045186210615101723531632403458113391993108492552853503;
        points[36] = 0.0902801083928287425621196670640081146019718414708110496;
        points[37] = 0.13518956908568299215847160396991714534378725948922809;
        points[38] = 0.179822845240643164359713218106239913411693524126622252;
        points[39] = 0.224088753633999013281464115083415341105068244677770299;
        points[40] = 0.267896861553503428581598596625442939347823208479327444;
        points[41] = 0.311157671547281186585905330322717104526806291920954782;
        points[42] = 0.35378280426206631796012709345286970077740760587556785;
        points[43] = 0.395685178997244447351756104594377325152207198132734431;
        points[44] = 0.436779191605844420869876893385921824711636148983037638;
        points[45] = 0.476980889379045710341440876655055089165849446756501419;
        points[46] = 0.516208142556933709171820720450272673190290622857118178;
        points[47] = 0.554380812115132014537972991218126579208803180098405525;
        points[48] = 0.591420913484555825569309504422024967467834297545004188;
        points[49] = 0.627252775869849401767457558667283824227201598428127082;
        points[50] = 0.66180319684107824402422623161480798577943791482291333;
        points[51] = 0.69500159188292846092974385228659798190073111133365284;
        points[52] = 0.726780138596008088657160129952025250195829144929850753;
        points[53] = 0.757073915255837851594723194432757345040595811560041361;
        points[54] = 0.785821033446759760335369049080552068152902401373973682;
        points[55] = 0.81296276450029561385648008097595354706093003983226222;
        points[56] = 0.838443659480504213261616472985085945938309810474838293;
        points[57] = 0.862211662472744083857172022828939726551682034096877177;
        points[58] = 0.884218216947252436662818857563874950920790269303617986;
        points[59] = 0.9044183649858271400665248332365862991144343228053598;
        points[60] = 0.922770839180444997188817784539705526962242686306349978;
        points[61] = 0.939238147041608472966835800156577238157035986768503204;
        points[62] = 0.95378664780518189753393983763110313143686431029405191;
        points[63] = 0.966386621642860566855799811670797215491623114185112405;
        points[64] = 0.977012331622094263389466091021529505984530174637742792;
        points[65] = 0.985642080022637593237139352621122545919741596491455174;
        points[66] = 0.992258266716853118700433913219466785756114568711453183;
        points[67] = 0.996847500485195100459497014953645209357845167340067408;
        points[68] = 0.999401427543244788208060967646121418501571749161728442;
        weights[0] = 0.00153597695279208407512940183774178973151449727548528822;
        weights[1] = 0.00357241673939737260970374522850139634620145087435641737;
        weights[2] = 0.00560457992787059482853599193369038179748361037867173806;
        weights[3] = 0.00762555593120151061145826961661099781609341245830150381;
        weights[4] = 0.00963100615041557558866029700470875265177358726669011547;
        weights[5] = 0.0116167966106719655487398729454516326321295504701082796;
        weights[6] = 0.0135788606490756709998118676287804256038760391809258658;
        weights[7] = 0.0155131865434061647397691087236705230879590550325184392;
        weights[8] = 0.0174158212319698291320737873085513449390970929609429117;
        weights[9] = 0.0192828771288494027892443780491022746784254014698335699;
        weights[10] = 0.0211105396398718946278901765020821052434214591659614221;
        weights[11] = 0.0228950747907407856555214504806789089692513278609337141;
        weights[12] = 0.0246328367845424553643358975901408466871636471710095202;
        weights[13] = 0.0263202754168694837917607310180191891967610697638415721;
        weights[14] = 0.0279539433121877059908617061046021318025541522017381777;
        weights[15] = 0.0295305029579067117798110611736252380616952276457782968;
        weights[16] = 0.0310467335178905390326857172001527494490632243611955523;
        weights[17] = 0.0324995374096461112447338950072030305981909327980120222;
        weights[18] = 0.0338859466308322894978098207524373574177956443121261666;
        weights[19] = 0.0352031288216834861477543635077868508230234845896327942;
        weights[20] = 0.0364483930507005140566435084686224616857958088674187871;
        weights[21] = 0.0376191953116409065081583665735551734593145203468454751;
        weights[22] = 0.0387131437204925139327394461492304134215773733167518323;
        weights[23] = 0.0397280034017616412064585469100731286394670268614373635;
        weights[24] = 0.0406617010540616005375260203090389439582408581828070241;
        weights[25] = 0.0415123291856545020828740616684119910417435617390464457;
        weights[26] = 0.0422781500112805128515826862576760563444659931294863543;
        weights[27] = 0.0429575990023052138784199022252778143412036251631754711;
        weights[28] = 0.0435492880829267410335757770620688899616513623286060796;
        weights[29] = 0.0440520084659092843809859173220065625820763617635466883;
        weights[30] = 0.0444647331220471380962310973419187631554242652873303657;
        weights[31] = 0.0447866188783125575421352782248060259131767284483552763;
        weights[32] = 0.04501700814039980219871619271604378489294706604367071;
        weights[33] = 0.045155430236145460516517053219963928520630212567322213;
        weights[34] = 0.0452016023770799542422892118755362690976227374322730931;
        weights[35] = 0.045155430236145460516517053219963928520630212567322213;
        weights[36] = 0.04501700814039980219871619271604378489294706604367071;
        weights[37] = 0.0447866188783125575421352782248060259131767284483552763;
        weights[38] = 0.0444647331220471380962310973419187631554242652873303657;
        weights[39] = 0.0440520084659092843809859173220065625820763617635466883;
        weights[40] = 0.0435492880829267410335757770620688899616513623286060796;
        weights[41] = 0.0429575990023052138784199022252778143412036251631754711;
        weights[42] = 0.0422781500112805128515826862576760563444659931294863543;
        weights[43] = 0.0415123291856545020828740616684119910417435617390464457;
        weights[44] = 0.0406617010540616005375260203090389439582408581828070241;
        weights[45] = 0.0397280034017616412064585469100731286394670268614373635;
        weights[46] = 0.0387131437204925139327394461492304134215773733167518323;
        weights[47] = 0.0376191953116409065081583665735551734593145203468454751;
        weights[48] = 0.0364483930507005140566435084686224616857958088674187871;
        weights[49] = 0.0352031288216834861477543635077868508230234845896327942;
        weights[50] = 0.0338859466308322894978098207524373574177956443121261666;
        weights[51] = 0.0324995374096461112447338950072030305981909327980120222;
        weights[52] = 0.0310467335178905390326857172001527494490632243611955523;
        weights[53] = 0.0295305029579067117798110611736252380616952276457782968;
        weights[54] = 0.0279539433121877059908617061046021318025541522017381777;
        weights[55] = 0.0263202754168694837917607310180191891967610697638415721;
        weights[56] = 0.0246328367845424553643358975901408466871636471710095202;
        weights[57] = 0.0228950747907407856555214504806789089692513278609337141;
        weights[58] = 0.0211105396398718946278901765020821052434214591659614221;
        weights[59] = 0.0192828771288494027892443780491022746784254014698335699;
        weights[60] = 0.0174158212319698291320737873085513449390970929609429117;
        weights[61] = 0.0155131865434061647397691087236705230879590550325184392;
        weights[62] = 0.0135788606490756709998118676287804256038760391809258658;
        weights[63] = 0.0116167966106719655487398729454516326321295504701082796;
        weights[64] = 0.00963100615041557558866029700470875265177358726669011547;
        weights[65] = 0.00762555593120151061145826961661099781609341245830150381;
        weights[66] = 0.00560457992787059482853599193369038179748361037867173806;
        weights[67] = 0.00357241673939737260970374522850139634620145087435641737;
        weights[68] = 0.00153597695279208407512940183774178973151449727548528822;
        return;
    case 70:
        points[0] = -0.999418285973575842056742581885209384618536739215528309;
        points[1] = -0.99693625196168015660981349583415551188237527795290519;
        points[2] = -0.99247605521168998109894208575939001848832158272122606;
        points[3] = -0.986045558070398659927101339317334885488302559072793257;
        points[4] = -0.97765740595759240039390762813623274924149571938954332;
        points[5] = -0.967328223664986438388618235724088736777455541193784733;
        points[6] = -0.955078509114292842640327354628519427217414424942369683;
        points[7] = -0.940932579003815355522815415741987060851722725660073913;
        points[8] = -0.924918516897934440272265965184887263954085744574298358;
        points[9] = -0.907068116260922849436352724293941865205171218518326188;
        points[10] = -0.88741681686334817112437348999408750902726155141360317;
        points[11] = -0.866003634213858629380034519420602796192469447322304675;
        points[12] = -0.842871081998980242318593530197434030075337400648440606;
        points[13] = -0.818065087625441189027231987106686883022475115102088671;
        points[14] = -0.791634901007892758107676174484814126749972206320813858;
        points[15] = -0.763632996771899568925095056496733482521691490797050827;
        points[16] = -0.734114970060942641307651678938198495995932358968709632;
        points[17] = -0.703139426151528597062947360222445769574516590788333998;
        points[18] = -0.67076786409407740564628119501142108948390042744508304;
        points[19] = -0.637064554609778096278859644687029961464806364549004033;
        points[20] = -0.602096412485355487336766582203437577979056893510713958;
        points[21] = -0.565932863718808286372959357470011838249852607902384107;
        points[22] = -0.528645707679711127265080756660818242110961513224547135;
        points[23] = -0.490308974557636589269778141352810357007931058610512274;
        points[24] = -0.450998778381647865731639703881117723757798876326141584;
        points[25] = -0.410793165902630589371262767934362980846406357760758232;
        points[26] = -0.369771961638461895839404694632918022944859624674668132;
        points[27] = -0.328016609389643257846131454487055042697674206291355751;
        points[28] = -0.28561001054003786169166478086038845689734732970295686;
        points[29] = -0.242636359463740645783579026383790441240016610966456706;
        points[30] = -0.199180976364857664151403461620060184567263117326871271;
        points[31] = -0.155330137882070247309005491502633998209806039404954865;
        points[32] = -0.111170905794298693735752330550280768977075944584895753;
        points[33] = -0.0667909541675513240037194364395975267568853064277594167;
        points[34] = -0.022278395286140309693492782488810282969566239206609482;
        points[35] = 0.022278395286140309693492782488810282969566239206609482;
        points[36] = 0.0667909541675513240037194364395975267568853064277594167;
        points[37] = 0.111170905794298693735752330550280768977075944584895753;
        points[38] = 0.155330137882070247309005491502633998209806039404954865;
        points[39] = 0.199180976364857664151403461620060184567263117326871271;
        points[40] = 0.242636359463740645783579026383790441240016610966456706;
        points[41] = 0.28561001054003786169166478086038845689734732970295686;
        points[42] = 0.328016609389643257846131454487055042697674206291355751;
        points[43] = 0.369771961638461895839404694632918022944859624674668132;
        points[44] = 0.410793165902630589371262767934362980846406357760758232;
        points[45] = 0.450998778381647865731639703881117723757798876326141584;
        points[46] = 0.490308974557636589269778141352810357007931058610512274;
        points[47] = 0.528645707679711127265080756660818242110961513224547135;
        points[48] = 0.565932863718808286372959357470011838249852607902384107;
        points[49] = 0.602096412485355487336766582203437577979056893510713958;
        points[50] = 0.637064554609778096278859644687029961464806364549004033;
        points[51] = 0.67076786409407740564628119501142108948390042744508304;
        points[52] = 0.703139426151528597062947360222445769574516590788333998;
        points[53] = 0.734114970060942641307651678938198495995932358968709632;
        points[54] = 0.763632996771899568925095056496733482521691490797050827;
        points[55] = 0.791634901007892758107676174484814126749972206320813858;
        points[56] = 0.818065087625441189027231987106686883022475115102088671;
        points[57] = 0.842871081998980242318593530197434030075337400648440606;
        points[58] = 0.866003634213858629380034519420602796192469447322304675;
        points[59] = 0.88741681686334817112437348999408750902726155141360317;
        points[60] = 0.907068116260922849436352724293941865205171218518326188;
        points[61] = 0.924918516897934440272265965184887263954085744574298358;
        points[62] = 0.940932579003815355522815415741987060851722725660073913;
        points[63] = 0.955078509114292842640327354628519427217414424942369683;
        points[64] = 0.967328223664986438388618235724088736777455541193784733;
        points[65] = 0.97765740595759240039390762813623274924149571938954332;
        points[66] = 0.986045558070398659927101339317334885488302559072793257;
        points[67] = 0.99247605521168998109894208575939001848832158272122606;
        points[68] = 0.99693625196168015660981349583415551188237527795290519;
        points[69] = 0.999418285973575842056742581885209384618536739215528309;
        weights[0] = 0.00149272128884451573103935605713785874609565663317193476;
        weights[1] = 0.00347189489307814325499919248104633045533257082327712052;
        weights[2] = 0.00544711187421721831282096562389690174456930156038538385;
        weights[3] = 0.00741176936319021036211092732320302500370900351094819987;
        weights[4] = 0.00936176276969902681149951423578603983793092432081416594;
        weights[5] = 0.0112931846499315376496309969771448417330394257864132138;
        weights[6] = 0.0132021908146767476250734908864842915540377026534410057;
        weights[7] = 0.0150849878654431276822951872143965447146577203184475524;
        weights[8] = 0.016937836376302932531836854174687311580470529779210832;
        weights[9] = 0.0187570570931334234154511303218699167666594567492321396;
        weights[10] = 0.0205390378243264533844925803326730686607172682098703141;
        weights[11] = 0.0222802404522565958338908416195441400042597952088375699;
        weights[12] = 0.0239772078891002922786866941535334270070607040434516983;
        weights[13] = 0.0256265709084684827989848322993845710611559321890696829;
        weights[14] = 0.0272250548186644171591072101624331370211920652672780665;
        weights[15] = 0.0287694859558082806613103837802050405636545230629291044;
        weights[16] = 0.0302567979801542378165367435724326692301726037585702365;
        weights[17] = 0.0316840379613084817346528560224676753805575251747347788;
        weights[18] = 0.033048372239372420470874285397913946312400980911513989;
        weights[19] = 0.034347092049906537568545329348534831569322417024900972;
        weights[20] = 0.035577618901292380532769713952614919112529301127705913;
        weights[21] = 0.0367375096936726953480402758947295870982642189085192747;
        weights[22] = 0.0378244615692228171972721391990150943257448511219678286;
        weights[23] = 0.0388363164840734039790030435968849581569208715341686826;
        weights[24] = 0.0397710654927765674778495459931257406584433745808711951;
        weights[25] = 0.0406268527367896163512259108565387550229281515328837036;
        weights[26] = 0.0414019791290452086382265039797212571647360228484225016;
        weights[27] = 0.0420949057272844060209838881826738959785582891822589322;
        weights[28] = 0.0427042567894497777699657102443388321570764118719078635;
        weights[29] = 0.0432288225050686997893952387744783978136459833689213601;
        weights[30] = 0.0436675613972014402525484288919817064653128790337989319;
        weights[31] = 0.0440196023901834587573557803511148294187090036780144426;
        weights[32] = 0.0442842465390554067757996743919545460663441103089707569;
        weights[33] = 0.0444609684172463708235572766258955363592336871718464545;
        weights[34] = 0.0445494171597546672021674970801563752545567367432441984;
        weights[35] = 0.0445494171597546672021674970801563752545567367432441984;
        weights[36] = 0.0444609684172463708235572766258955363592336871718464545;
        weights[37] = 0.0442842465390554067757996743919545460663441103089707569;
        weights[38] = 0.0440196023901834587573557803511148294187090036780144426;
        weights[39] = 0.0436675613972014402525484288919817064653128790337989319;
        weights[40] = 0.0432288225050686997893952387744783978136459833689213601;
        weights[41] = 0.0427042567894497777699657102443388321570764118719078635;
        weights[42] = 0.0420949057272844060209838881826738959785582891822589322;
        weights[43] = 0.0414019791290452086382265039797212571647360228484225016;
        weights[44] = 0.0406268527367896163512259108565387550229281515328837036;
        weights[45] = 0.0397710654927765674778495459931257406584433745808711951;
        weights[46] = 0.0388363164840734039790030435968849581569208715341686826;
        weights[47] = 0.0378244615692228171972721391990150943257448511219678286;
        weights[48] = 0.0367375096936726953480402758947295870982642189085192747;
        weights[49] = 0.035577618901292380532769713952614919112529301127705913;
        weights[50] = 0.034347092049906537568545329348534831569322417024900972;
        weights[51] = 0.033048372239372420470874285397913946312400980911513989;
        weights[52] = 0.0316840379613084817346528560224676753805575251747347788;
        weights[53] = 0.0302567979801542378165367435724326692301726037585702365;
        weights[54] = 0.0287694859558082806613103837802050405636545230629291044;
        weights[55] = 0.0272250548186644171591072101624331370211920652672780665;
        weights[56] = 0.0256265709084684827989848322993845710611559321890696829;
        weights[57] = 0.0239772078891002922786866941535334270070607040434516983;
        weights[58] = 0.0222802404522565958338908416195441400042597952088375699;
        weights[59] = 0.0205390378243264533844925803326730686607172682098703141;
        weights[60] = 0.0187570570931334234154511303218699167666594567492321396;
        weights[61] = 0.016937836376302932531836854174687311580470529779210832;
        weights[62] = 0.0150849878654431276822951872143965447146577203184475524;
        weights[63] = 0.0132021908146767476250734908864842915540377026534410057;
        weights[64] = 0.0112931846499315376496309969771448417330394257864132138;
        weights[65] = 0.00936176276969902681149951423578603983793092432081416594;
        weights[66] = 0.00741176936319021036211092732320302500370900351094819987;
        weights[67] = 0.00544711187421721831282096562389690174456930156038538385;
        weights[68] = 0.00347189489307814325499919248104633045533257082327712052;
        weights[69] = 0.00149272128884451573103935605713785874609565663317193476;
        return;
    case 71:
        points[0] = -0.999434442119736927561659947165788802298739081612151999;
        points[1] = -0.997021308251255130065672598011236089340474410495241301;
        points[2] = -0.992684784870641569941805634716360934951173602037716405;
        points[3] = -0.986432277268261368092141846666401235736474008513692299;
        points[4] = -0.978275736113601792874824071538055917684983131427922558;
        points[5] = -0.968230877426325345680304591241661204564606949654257647;
        points[6] = -0.956317081041052874884704374972883734077855633548672998;
        points[7] = -0.942557339922271159124395673778629390681514279243345097;
        points[8] = -0.926978212250871410768130508728779607671793079987652055;
        points[9] = -0.909609768984534359441634902284893475411374780683130213;
        points[10] = -0.890485535355206511673911760992317897102725280979527462;
        points[11] = -0.86964242595630741114708820306583113748748033566330565;
        points[12] = -0.847120673391873968941067191862633671351116088011440443;
        points[13] = -0.822963750567552752389365050298679071544958206779541608;
        points[14] = -0.79721828674931796063949074212097726618527835122135463;
        points[15] = -0.769933977541036647405165361694960661515341473569922376;
        points[16] = -0.741163488949376848010344106748474565391591509988864482;
        points[17] = -0.710962355718544370974605259809150893242834795586404824;
        points[18] = -0.679388874129644576284578125360444135533026359641342495;
        points[19] = -0.646503989470787642801403479107570030413989390874414452;
        points[20] = -0.612371178394682336310376090632725793250179577597355833;
        points[21] = -0.577056326390519810485798997182950680454395167071188335;
        points[22] = -0.540627600606487356004911333591178463427493142135686339;
        points[23] = -0.503155318268290070833605381553926540529036365276537955;
        points[24] = -0.46471181094759782294757862729818423251151206992990543;
        points[25] = -0.425371284942369555863251487218949635479469923717792448;
        points[26] = -0.385209678038527295989720328015301205917412926356972099;
        points[27] = -0.344304512929447024710467470167334658277824504944222386;
        points[28] = -0.302734747576191376434942069152515034750656754282699219;
        points[29] = -0.260580622797318662023926452892419042887009652179624225;
        points[30] = -0.217923507382453335534383026417590926518883604027774274;
        points[31] = -0.174845741028584863169687589857438020785521225580316558;
        points[32] = -0.131430475402266087012909921506162567349678731612612243;
        points[33] = -0.0877615136345006823618069033864131301273190178983118113;
        points[34] = -0.0439231485581353293322169351467208224008243615749277493;
        points[35] = 0;
        points[36] = 0.0439231485581353293322169351467208224008243615749277493;
        points[37] = 0.0877615136345006823618069033864131301273190178983118113;
        points[38] = 0.131430475402266087012909921506162567349678731612612243;
        points[39] = 0.174845741028584863169687589857438020785521225580316558;
        points[40] = 0.217923507382453335534383026417590926518883604027774274;
        points[41] = 0.260580622797318662023926452892419042887009652179624225;
        points[42] = 0.302734747576191376434942069152515034750656754282699219;
        points[43] = 0.344304512929447024710467470167334658277824504944222386;
        points[44] = 0.385209678038527295989720328015301205917412926356972099;
        points[45] = 0.425371284942369555863251487218949635479469923717792448;
        points[46] = 0.46471181094759782294757862729818423251151206992990543;
        points[47] = 0.503155318268290070833605381553926540529036365276537955;
        points[48] = 0.540627600606487356004911333591178463427493142135686339;
        points[49] = 0.577056326390519810485798997182950680454395167071188335;
        points[50] = 0.612371178394682336310376090632725793250179577597355833;
        points[51] = 0.646503989470787642801403479107570030413989390874414452;
        points[52] = 0.679388874129644576284578125360444135533026359641342495;
        points[53] = 0.710962355718544370974605259809150893242834795586404824;
        points[54] = 0.741163488949376848010344106748474565391591509988864482;
        points[55] = 0.769933977541036647405165361694960661515341473569922376;
        points[56] = 0.79721828674931796063949074212097726618527835122135463;
        points[57] = 0.822963750567552752389365050298679071544958206779541608;
        points[58] = 0.847120673391873968941067191862633671351116088011440443;
        points[59] = 0.86964242595630741114708820306583113748748033566330565;
        points[60] = 0.890485535355206511673911760992317897102725280979527462;
        points[61] = 0.909609768984534359441634902284893475411374780683130213;
        points[62] = 0.926978212250871410768130508728779607671793079987652055;
        points[63] = 0.942557339922271159124395673778629390681514279243345097;
        points[64] = 0.956317081041052874884704374972883734077855633548672998;
        points[65] = 0.968230877426325345680304591241661204564606949654257647;
        points[66] = 0.978275736113601792874824071538055917684983131427922558;
        points[67] = 0.986432277268261368092141846666401235736474008513692299;
        points[68] = 0.992684784870641569941805634716360934951173602037716405;
        points[69] = 0.997021308251255130065672598011236089340474410495241301;
        points[70] = 0.999434442119736927561659947165788802298739081612151999;
        weights[0] = 0.00145126733002939726849804102686018489901519586038998699;
        weights[1] = 0.00337555549673067586512669060832421978136208028016033245;
        weights[2] = 0.00529618284402589263267962101476412076119244413066531498;
        weights[3] = 0.00720683528183149338734465342193933202203670338671287655;
        weights[4] = 0.00910362646199200585131674754472160157901452217851880557;
        weights[5] = 0.0109828601542985517062745452071540889996357523324228402;
        weights[6] = 0.0128408996680878060704179526044897026106916439843936793;
        weights[7] = 0.0146741553346115292004076279800645766395630090001075663;
        weights[8] = 0.0164790872074623965505924406199875065734512534411498479;
        weights[9] = 0.018252210704678670502329380325133952016450157949167718;
        weights[10] = 0.0199901029323501112874851437274832126170243889393099887;
        weights[11] = 0.0216894091359853679618323264623768608229872512296661273;
        weights[12] = 0.0233468491092232526317149531775968538671412579962484603;
        weights[13] = 0.024959223494313873055275671073154073639685975071255098;
        weights[14] = 0.0265234199421579080081054540525604536793549564920877431;
        weights[15] = 0.0280364191117414906179800139320839996918541463514056201;
        weights[16] = 0.0294953004937088124649364875406447569097802345156641452;
        weights[17] = 0.0308972480450907216986058408727370881455639873679254638;
        weights[18] = 0.0322395556234435269419071602695189567507114721694962288;
        weights[19] = 0.0335196322094540308344061289364005376840632202919492548;
        weights[20] = 0.0347350069076821883753652730701090909702220483983769095;
        weights[21] = 0.0358833337156489107779684272200834485204767402135495215;
        weights[22] = 0.0369623960519820318560829177201379665071053058998415419;
        weights[23] = 0.0379701110348311562144179619185287521897181554699139225;
        weights[24] = 0.0389045335022629474924027429042462590447409289123780387;
        weights[25] = 0.0397638597668575816743370585121029626958116848066630004;
        weights[26] = 0.040546431097246896434925221946931247859629681751330121;
        weights[27] = 0.0412507369198660242491088930370628960099233342715461118;
        weights[28] = 0.0418754177347330061895426032735603106891589097912692504;
        weights[29] = 0.0424192677396245930353393266432897004696246366738321191;
        weights[30] = 0.0428812371575804350206070863518684040449555094764061516;
        weights[31] = 0.0432604342632412665988562556163607474317498272232545569;
        weights[32] = 0.0435561271041085333711339723628755649461455076029219988;
        weights[33] = 0.0437677449134021449723098250860264318153899951801001034;
        weights[34] = 0.0438948792117885863212525666158556738556576455914075369;
        weights[35] = 0.0439372845958523657582259746459289265182208715370240341;
        weights[36] = 0.0438948792117885863212525666158556738556576455914075369;
        weights[37] = 0.0437677449134021449723098250860264318153899951801001034;
        weights[38] = 0.0435561271041085333711339723628755649461455076029219988;
        weights[39] = 0.0432604342632412665988562556163607474317498272232545569;
        weights[40] = 0.0428812371575804350206070863518684040449555094764061516;
        weights[41] = 0.0424192677396245930353393266432897004696246366738321191;
        weights[42] = 0.0418754177347330061895426032735603106891589097912692504;
        weights[43] = 0.0412507369198660242491088930370628960099233342715461118;
        weights[44] = 0.040546431097246896434925221946931247859629681751330121;
        weights[45] = 0.0397638597668575816743370585121029626958116848066630004;
        weights[46] = 0.0389045335022629474924027429042462590447409289123780387;
        weights[47] = 0.0379701110348311562144179619185287521897181554699139225;
        weights[48] = 0.0369623960519820318560829177201379665071053058998415419;
        weights[49] = 0.0358833337156489107779684272200834485204767402135495215;
        weights[50] = 0.0347350069076821883753652730701090909702220483983769095;
        weights[51] = 0.0335196322094540308344061289364005376840632202919492548;
        weights[52] = 0.0322395556234435269419071602695189567507114721694962288;
        weights[53] = 0.0308972480450907216986058408727370881455639873679254638;
        weights[54] = 0.0294953004937088124649364875406447569097802345156641452;
        weights[55] = 0.0280364191117414906179800139320839996918541463514056201;
        weights[56] = 0.0265234199421579080081054540525604536793549564920877431;
        weights[57] = 0.024959223494313873055275671073154073639685975071255098;
        weights[58] = 0.0233468491092232526317149531775968538671412579962484603;
        weights[59] = 0.0216894091359853679618323264623768608229872512296661273;
        weights[60] = 0.0199901029323501112874851437274832126170243889393099887;
        weights[61] = 0.018252210704678670502329380325133952016450157949167718;
        weights[62] = 0.0164790872074623965505924406199875065734512534411498479;
        weights[63] = 0.0146741553346115292004076279800645766395630090001075663;
        weights[64] = 0.0128408996680878060704179526044897026106916439843936793;
        weights[65] = 0.0109828601542985517062745452071540889996357523324228402;
        weights[66] = 0.00910362646199200585131674754472160157901452217851880557;
        weights[67] = 0.00720683528183149338734465342193933202203670338671287655;
        weights[68] = 0.00529618284402589263267962101476412076119244413066531498;
        weights[69] = 0.00337555549673067586512669060832421978136208028016033245;
        weights[70] = 0.00145126733002939726849804102686018489901519586038998699;
        return;
    case 72:
        points[0] = -0.999449934452962642181853817647208191943037763942498471;
        points[1] = -0.997102871642729078465966536352271481423562414633833407;
        points[2] = -0.992884951016801908228103840903380517287036812003722996;
        points[3] = -0.986803152375830465808073392454602236061490759836675542;
        points[4] = -0.978868778557233771796186729955174782408600785151444745;
        points[5] = -0.969096697998780425922170939644283821783434213055247315;
        points[6] = -0.957505247577698225664203305796850587761401137442816126;
        points[7] = -0.944116185272537965007180976330727919384608333337603758;
        points[8] = -0.928954645880918010572223799118714467391618849986938423;
        points[9] = -0.912049092688671469923029846513831333517265437571775665;
        points[10] = -0.893431263588091256195897045686110436686974297720271985;
        points[11] = -0.873136111298778905281708169805328483777882324162533002;
        points[12] = -0.851201737654437851111950000877115772850084594007485261;
        points[13] = -0.827669322022754314616560189735249401431953269668445477;
        points[14] = -0.802583043969291852027002961063169775814992736028369334;
        points[15] = -0.775990000299982562142196683813609418871390105034748903;
        points[16] = -0.747940116632832390670805994538476934840562816779037401;
        points[17] = -0.718486053662234961362461574862375592530012387145197392;
        points[18] = -0.687683108290467807491409378309164680257108729114239501;
        points[19] = -0.655589109811201056148896943420244043843577320716619026;
        points[20] = -0.62226431133946819100772379455238009636569507367064593;
        points[21] = -0.587771276691655599203772983286399223934431166487794964;
        points[22] = -0.55217476292771439740025823496724503252859057411775209;
        points[23] = -0.515541598776003523860158655091492437745301301790870604;
        points[24] = -0.477940559168940457183751040403268936768571123870557095;
        points[25] = -0.439442236124960732083875778821042694638510455751220379;
        points[26] = -0.400118906219161612702707674157539355930384485922288643;
        points[27] = -0.360044394891419237540073772549725279823006385059726094;
        points[28] = -0.319293937846712171332982464737174220646735724871196896;
        points[29] = -0.277944039807847606980110863854742487706061688139209237;
        points[30] = -0.236072330885759925057805077805058023099001249395396883;
        points[31] = -0.193757420837026059803132945231118401010550844475828258;
        points[32] = -0.151078751482210030326707095924422681257410503930780564;
        points[33] = -0.108116447562102814809633287692265318269948863261936598;
        points[34] = -0.0649511663118571140746755438926418450621929868472383722;
        points[35] = -0.02166394603542404467032637911531922077334028216076842;
        points[36] = 0.02166394603542404467032637911531922077334028216076842;
        points[37] = 0.0649511663118571140746755438926418450621929868472383722;
        points[38] = 0.108116447562102814809633287692265318269948863261936598;
        points[39] = 0.151078751482210030326707095924422681257410503930780564;
        points[40] = 0.193757420837026059803132945231118401010550844475828258;
        points[41] = 0.236072330885759925057805077805058023099001249395396883;
        points[42] = 0.277944039807847606980110863854742487706061688139209237;
        points[43] = 0.319293937846712171332982464737174220646735724871196896;
        points[44] = 0.360044394891419237540073772549725279823006385059726094;
        points[45] = 0.400118906219161612702707674157539355930384485922288643;
        points[46] = 0.439442236124960732083875778821042694638510455751220379;
        points[47] = 0.477940559168940457183751040403268936768571123870557095;
        points[48] = 0.515541598776003523860158655091492437745301301790870604;
        points[49] = 0.55217476292771439740025823496724503252859057411775209;
        points[50] = 0.587771276691655599203772983286399223934431166487794964;
        points[51] = 0.62226431133946819100772379455238009636569507367064593;
        points[52] = 0.655589109811201056148896943420244043843577320716619026;
        points[53] = 0.687683108290467807491409378309164680257108729114239501;
        points[54] = 0.718486053662234961362461574862375592530012387145197392;
        points[55] = 0.747940116632832390670805994538476934840562816779037401;
        points[56] = 0.775990000299982562142196683813609418871390105034748903;
        points[57] = 0.802583043969291852027002961063169775814992736028369334;
        points[58] = 0.827669322022754314616560189735249401431953269668445477;
        points[59] = 0.851201737654437851111950000877115772850084594007485261;
        points[60] = 0.873136111298778905281708169805328483777882324162533002;
        points[61] = 0.893431263588091256195897045686110436686974297720271985;
        points[62] = 0.912049092688671469923029846513831333517265437571775665;
        points[63] = 0.928954645880918010572223799118714467391618849986938423;
        points[64] = 0.944116185272537965007180976330727919384608333337603758;
        points[65] = 0.957505247577698225664203305796850587761401137442816126;
        points[66] = 0.969096697998780425922170939644283821783434213055247315;
        points[67] = 0.978868778557233771796186729955174782408600785151444745;
        points[68] = 0.986803152375830465808073392454602236061490759836675542;
        points[69] = 0.992884951016801908228103840903380517287036812003722996;
        points[70] = 0.997102871642729078465966536352271481423562414633833407;
        points[71] = 0.999449934452962642181853817647208191943037763942498471;
        weights[0] = 0.00141151639397343413571906171709048182833703195267548146;
        weights[1] = 0.00328316977466749580190051290237988359823071781861954631;
        weights[2] = 0.00515143601879088690825063475802335592854806742050500307;
        weights[3] = 0.00701027232186186329608132445567622581487516765270516992;
        weights[4] = 0.00885599607370615338395741352752975711654079341890774525;
        weights[5] = 0.0106851081653518971589583076875229766847714936235038694;
        weights[6] = 0.0124941656198737577677828913626861031193200620578123451;
        weights[7] = 0.0142797690545541932665552929582791962318361190984979715;
        weights[8] = 0.016038564950285155218161212178872764456496517710627348;
        weights[9] = 0.0177672507892006535943597954588264178057298225784081944;
        weights[10] = 0.0194625808632942780430172314153163349592372492849823136;
        weights[11] = 0.0211213722164405535098195197003396205379003295401374244;
        weights[12] = 0.022740510555035754455931343063458366667630475263808188;
        weights[13] = 0.0243169560644191643263471421757702704900430178805413807;
        weights[14] = 0.0258477491006558902838977225924504240575095857330458545;
        weights[15] = 0.0273300157389509344337962482431322728306805023869738342;
        weights[16] = 0.0287609731647017610951250137100377077086157995169216947;
        weights[17] = 0.0301379348953754792929827419874671064546116974500069387;
        weights[18] = 0.0314583158225618139777759354873828854194065928811390223;
        weights[19] = 0.0327196370642938467043127010832026749930397667811130843;
        weights[20] = 0.0339195306182860594971961497751678582214306666870311359;
        weights[21] = 0.0350557438072178704341384105199334562429167451607257836;
        weights[22] = 0.0361261435076379929856310579022025963150207319538662332;
        weights[23] = 0.037128720154502899460555212021545041622090753690915631;
        weights[24] = 0.0380615915138021638343755281462191717068379173255564525;
        weights[25] = 0.038923006216169663799962932765852641317717381498549551;
        weights[26] = 0.0397113470448349017823986387904556256702427737089405065;
        weights[27] = 0.0404251339717339700433289142563417761860988977823930798;
        weights[28] = 0.0410630269360750611019360345515061524721904929744935424;
        weights[29] = 0.0416238283601385982076078072662595872395186976252800105;
        weights[30] = 0.0421064853975864641465872817867472678825822434952531183;
        weights[31] = 0.0425100919100577200778008276555410329056044891257852413;
        weights[32] = 0.0428338901683388136668398194080342997620844571731783437;
        weights[33] = 0.0430772722749136997452503605970377500108781010189661059;
        weights[34] = 0.04323978130522261748526514119232974226370931447476813;
        weights[35] = 0.0433211121654865370763938368993811734777155262533647246;
        weights[36] = 0.0433211121654865370763938368993811734777155262533647246;
        weights[37] = 0.04323978130522261748526514119232974226370931447476813;
        weights[38] = 0.0430772722749136997452503605970377500108781010189661059;
        weights[39] = 0.0428338901683388136668398194080342997620844571731783437;
        weights[40] = 0.0425100919100577200778008276555410329056044891257852413;
        weights[41] = 0.0421064853975864641465872817867472678825822434952531183;
        weights[42] = 0.0416238283601385982076078072662595872395186976252800105;
        weights[43] = 0.0410630269360750611019360345515061524721904929744935424;
        weights[44] = 0.0404251339717339700433289142563417761860988977823930798;
        weights[45] = 0.0397113470448349017823986387904556256702427737089405065;
        weights[46] = 0.038923006216169663799962932765852641317717381498549551;
        weights[47] = 0.0380615915138021638343755281462191717068379173255564525;
        weights[48] = 0.037128720154502899460555212021545041622090753690915631;
        weights[49] = 0.0361261435076379929856310579022025963150207319538662332;
        weights[50] = 0.0350557438072178704341384105199334562429167451607257836;
        weights[51] = 0.0339195306182860594971961497751678582214306666870311359;
        weights[52] = 0.0327196370642938467043127010832026749930397667811130843;
        weights[53] = 0.0314583158225618139777759354873828854194065928811390223;
        weights[54] = 0.0301379348953754792929827419874671064546116974500069387;
        weights[55] = 0.0287609731647017610951250137100377077086157995169216947;
        weights[56] = 0.0273300157389509344337962482431322728306805023869738342;
        weights[57] = 0.0258477491006558902838977225924504240575095857330458545;
        weights[58] = 0.0243169560644191643263471421757702704900430178805413807;
        weights[59] = 0.022740510555035754455931343063458366667630475263808188;
        weights[60] = 0.0211213722164405535098195197003396205379003295401374244;
        weights[61] = 0.0194625808632942780430172314153163349592372492849823136;
        weights[62] = 0.0177672507892006535943597954588264178057298225784081944;
        weights[63] = 0.016038564950285155218161212178872764456496517710627348;
        weights[64] = 0.0142797690545541932665552929582791962318361190984979715;
        weights[65] = 0.0124941656198737577677828913626861031193200620578123451;
        weights[66] = 0.0106851081653518971589583076875229766847714936235038694;
        weights[67] = 0.00885599607370615338395741352752975711654079341890774525;
        weights[68] = 0.00701027232186186329608132445567622581487516765270516992;
        weights[69] = 0.00515143601879088690825063475802335592854806742050500307;
        weights[70] = 0.00328316977466749580190051290237988359823071781861954631;
        weights[71] = 0.00141151639397343413571906171709048182833703195267548146;
        return;
    case 73:
        points[0] = -0.999464798845881170996471192948038454278416258977609307;
        points[1] = -0.997181130771611267253561485762526001978674853690970111;
        points[2] = -0.993077015588945151555204208088457019056108664930956207;
        points[3] = -0.987159036624932114781028432961552553901913362767569207;
        points[4] = -0.979437892056483624562704988078151376629416863704376329;
        points[5] = -0.969927659054985912747007663309616617419452652400070422;
        points[6] = -0.958645700697974220413851257028801074700461198133041164;
        points[7] = -0.945612621689483571931667851004401396630104143599519402;
        points[8] = -0.930852227381224559904698238344516143196721840073990642;
        points[9] = -0.914391479176256414741683526450822470512445969475201095;
        points[10] = -0.896260444846691221048938189948598987616389476443385708;
        points[11] = -0.876492243420651499825942880307109296564610608239782963;
        points[12] = -0.855122984594299484507990828399467063393944202064219767;
        points[13] = -0.832191702724909743755788339297687858377545416530969368;
        points[14] = -0.80774028550273592480706124036800510591462008659152357;
        points[15] = -0.781813397421644751334091296952683517505387665289235814;
        points[16] = -0.754458398183323480238445377605006493578006510347124259;
        points[17] = -0.725725256181559818503135729068107060565003811240403087;
        points[18] = -0.695666457223262717220219680898841863482516092778417457;
        points[19] = -0.664336908652196338882376121512606076951400479068907035;
        points[20] = -0.631793839050118456511040762022832048480654060158725706;
        points[21] = -0.598096693698270976000398858689484192693873036584106027;
        points[22] = -0.563307025990016512736242574231754471041331139334941463;
        points[23] = -0.527488384992870936800441040394176254162336695532786037;
        points[24] = -0.490706199365251987700222346627781977470921287404118079;
        points[25] = -0.453027657839945395191990527996064696055124945389304295;
        points[26] = -0.414521586492575763889120927829687025752961978736254792;
        points[27] = -0.375258323019251502905738919716108922360007666272084462;
        points[28] = -0.335309588253022456115741158648728730248254593013335984;
        points[29] = -0.294748355153836768255855097535076808889841828132845891;
        points[30] = -0.253648715511301393555804785177931778131971215065653147;
        points[31] = -0.212085744603730526527243586147974431121007082888561337;
        points[32] = -0.170135364060700758505645569446994515650156036599482235;
        points[33] = -0.127874203179614301754679116254453082190439168219364752;
        points[34] = -0.0853794589495963009958571371560067127775356400209297017;
        points[35] = -0.0427287550384139911856907777124257291815097750039985987;
        points[36] = 0;
        points[37] = 0.0427287550384139911856907777124257291815097750039985987;
        points[38] = 0.0853794589495963009958571371560067127775356400209297017;
        points[39] = 0.127874203179614301754679116254453082190439168219364752;
        points[40] = 0.170135364060700758505645569446994515650156036599482235;
        points[41] = 0.212085744603730526527243586147974431121007082888561337;
        points[42] = 0.253648715511301393555804785177931778131971215065653147;
        points[43] = 0.294748355153836768255855097535076808889841828132845891;
        points[44] = 0.335309588253022456115741158648728730248254593013335984;
        points[45] = 0.375258323019251502905738919716108922360007666272084462;
        points[46] = 0.414521586492575763889120927829687025752961978736254792;
        points[47] = 0.453027657839945395191990527996064696055124945389304295;
        points[48] = 0.490706199365251987700222346627781977470921287404118079;
        points[49] = 0.527488384992870936800441040394176254162336695532786037;
        points[50] = 0.563307025990016512736242574231754471041331139334941463;
        points[51] = 0.598096693698270976000398858689484192693873036584106027;
        points[52] = 0.631793839050118456511040762022832048480654060158725706;
        points[53] = 0.664336908652196338882376121512606076951400479068907035;
        points[54] = 0.695666457223262717220219680898841863482516092778417457;
        points[55] = 0.725725256181559818503135729068107060565003811240403087;
        points[56] = 0.754458398183323480238445377605006493578006510347124259;
        points[57] = 0.781813397421644751334091296952683517505387665289235814;
        points[58] = 0.80774028550273592480706124036800510591462008659152357;
        points[59] = 0.832191702724909743755788339297687858377545416530969368;
        points[60] = 0.855122984594299484507990828399467063393944202064219767;
        points[61] = 0.876492243420651499825942880307109296564610608239782963;
        points[62] = 0.896260444846691221048938189948598987616389476443385708;
        points[63] = 0.914391479176256414741683526450822470512445969475201095;
        points[64] = 0.930852227381224559904698238344516143196721840073990642;
        points[65] = 0.945612621689483571931667851004401396630104143599519402;
        points[66] = 0.958645700697974220413851257028801074700461198133041164;
        points[67] = 0.969927659054985912747007663309616617419452652400070422;
        points[68] = 0.979437892056483624562704988078151376629416863704376329;
        points[69] = 0.987159036624932114781028432961552553901913362767569207;
        points[70] = 0.993077015588945151555204208088457019056108664930956207;
        points[71] = 0.997181130771611267253561485762526001978674853690970111;
        points[72] = 0.999464798845881170996471192948038454278416258977609307;
        weights[0] = 0.00137337646275961922398427080933292592753835470410183443;
        weights[1] = 0.00319452437728903452207771708743307780670523475531846471;
        weights[2] = 0.00501253857160619026381269952866082712802253899133763651;
        weights[3] = 0.00682163134917479236220933937020662116859267429103349169;
        weights[4] = 0.00861831047953224761391181673865822028133660808411668896;
        weights[5] = 0.0103992609950005322013041938640038603538937061885214753;
        weights[6] = 0.0121612209292811127277632230877377379334524079039060074;
        weights[7] = 0.013900968788314650867519634424008277192728339784625353;
        weights[8] = 0.0156153254335914229955336110615515868821355266701637717;
        weights[9] = 0.017301158762489083005607007648463866800056195921877741;
        weights[10] = 0.0189553890486700216897359689847237194104728928194053675;
        weights[11] = 0.0205749944203611691660195017568784187459977507186471494;
        weights[12] = 0.0221570163170400720567698023630444224076066919664469656;
        weights[13] = 0.0236985648642189746266093252715674602327938058164034433;
        weights[14] = 0.0251968241375383128133322522544288396185594446909041866;
        weights[15] = 0.0266490572987274829522304593181915417270612745220657274;
        weights[16] = 0.0280526115905720603238022343412453973487296296566595344;
        weights[17] = 0.0294049231801165601054572299810247238237586992176398432;
        weights[18] = 0.0307035218404335049381260167887429072727418365886316949;
        weights[19] = 0.0319460354619767064865014368985841373644540024457627635;
        weights[20] = 0.0331301943850438406770687994348887853163647408786345671;
        weights[21] = 0.0342538355453022154141295182617634650925065812901629135;
        weights[22] = 0.0353149064247282875090630738286812157283783384788890251;
        weights[23] = 0.0363114688006977846903466650777091111096388603476943659;
        weights[24] = 0.0372417022863497731568942114505920302175465936988042259;
        weights[25] = 0.0381039076557398005955080783652312883876818035479523623;
        weights[26] = 0.0388965099476967395204756018110251685035709504792484312;
        weights[27] = 0.0396180613427061433165080459595499140830513782466470506;
        weights[28] = 0.0402672438075600333649416843312412927914343131813511896;
        weights[29] = 0.0408428715029388615493605585635691230426375669239456636;
        weights[30] = 0.0413438929495254945268833418346880267631489944574464427;
        weights[31] = 0.0417693929486928537541016980203051319687152219293159481;
        weights[32] = 0.0421185942542556362689455221543500630099537633554468565;
        weights[33] = 0.0423908589922315944053739843391425763511304690474385649;
        weights[34] = 0.0425856898260183870257630080715183586215799206936111784;
        weights[35] = 0.0427027308648572220766009896640662046873123418203164039;
        weights[36] = 0.0427417683139235624114549545063793497974210917710513404;
        weights[37] = 0.0427027308648572220766009896640662046873123418203164039;
        weights[38] = 0.0425856898260183870257630080715183586215799206936111784;
        weights[39] = 0.0423908589922315944053739843391425763511304690474385649;
        weights[40] = 0.0421185942542556362689455221543500630099537633554468565;
        weights[41] = 0.0417693929486928537541016980203051319687152219293159481;
        weights[42] = 0.0413438929495254945268833418346880267631489944574464427;
        weights[43] = 0.0408428715029388615493605585635691230426375669239456636;
        weights[44] = 0.0402672438075600333649416843312412927914343131813511896;
        weights[45] = 0.0396180613427061433165080459595499140830513782466470506;
        weights[46] = 0.0388965099476967395204756018110251685035709504792484312;
        weights[47] = 0.0381039076557398005955080783652312883876818035479523623;
        weights[48] = 0.0372417022863497731568942114505920302175465936988042259;
        weights[49] = 0.0363114688006977846903466650777091111096388603476943659;
        weights[50] = 0.0353149064247282875090630738286812157283783384788890251;
        weights[51] = 0.0342538355453022154141295182617634650925065812901629135;
        weights[52] = 0.0331301943850438406770687994348887853163647408786345671;
        weights[53] = 0.0319460354619767064865014368985841373644540024457627635;
        weights[54] = 0.0307035218404335049381260167887429072727418365886316949;
        weights[55] = 0.0294049231801165601054572299810247238237586992176398432;
        weights[56] = 0.0280526115905720603238022343412453973487296296566595344;
        weights[57] = 0.0266490572987274829522304593181915417270612745220657274;
        weights[58] = 0.0251968241375383128133322522544288396185594446909041866;
        weights[59] = 0.0236985648642189746266093252715674602327938058164034433;
        weights[60] = 0.0221570163170400720567698023630444224076066919664469656;
        weights[61] = 0.0205749944203611691660195017568784187459977507186471494;
        weights[62] = 0.0189553890486700216897359689847237194104728928194053675;
        weights[63] = 0.017301158762489083005607007648463866800056195921877741;
        weights[64] = 0.0156153254335914229955336110615515868821355266701637717;
        weights[65] = 0.013900968788314650867519634424008277192728339784625353;
        weights[66] = 0.0121612209292811127277632230877377379334524079039060074;
        weights[67] = 0.0103992609950005322013041938640038603538937061885214753;
        weights[68] = 0.00861831047953224761391181673865822028133660808411668896;
        weights[69] = 0.00682163134917479236220933937020662116859267429103349169;
        weights[70] = 0.00501253857160619026381269952866082712802253899133763651;
        weights[71] = 0.00319452437728903452207771708743307780670523475531846471;
        weights[72] = 0.00137337646275961922398427080933292592753835470410183443;
        return;
    case 74:
        points[0] = -0.999479068780329524271044515109528496839355889552266194;
        points[1] = -0.997256261711016390838064096344457785885078750386873634;
        points[2] = -0.993261409804644972713884927841565624008488785345152326;
        points[3] = -0.987500726616238559607124327139481900183327480467864031;
        points[4] = -0.979984345431300336098804066408403892589708097829521888;
        points[5] = -0.970725604042518726819354559822744926138836973923285893;
        points[6] = -0.959740955459528912699917216038501511324960595109202744;
        points[7] = -0.947049926428385008272628348414517065062184107483141775;
        points[8] = -0.932675079462054566085601129701867580083743327587999591;
        points[9] = -0.916641971642906460677148258286043324813761362065893825;
        points[10] = -0.898979108761895795583715403801278323421553059210322594;
        points[11] = -0.879717894452088809228763264673946931282553536755529294;
        points[12] = -0.858892574265983576796486387287919192951200204948751875;
        points[13] = -0.83654017474281573916834801702132869479992194653114907;
        points[14] = -0.812700437551974373875255111282462202894771986196244029;
        points[15] = -0.787415748819575517819986709906400027953713205048095712;
        points[16] = -0.760731063758994475968622898553480945851369248155809806;
        points[17] = -0.732693826736880277762463403990613937762755443095040949;
        points[18] = -0.703353886915441859060319959214489978824382653935553403;
        points[19] = -0.672763409620247602718505466750305318294137735436361868;
        points[20] = -0.640976783590692388595341945280529946027868340545275104;
        points[21] = -0.60805052427777982552516290547091835412680395972320066;
        points[22] = -0.574043173360994152501892620261297098889453373047721229;
        points[23] = -0.539015194662817083240727032646304843723706487596167643;
        points[24] = -0.503028866645885165914073043877817664410055450351572075;
        points[25] = -0.466148171683881183422059831975418354920715274110522696;
        points[26] = -0.428438682303003279375829294020234725948163034514462172;
        points[27] = -0.389967444596250750571071929966565830249195130681263345;
        points[28] = -0.35080285901779804749253496882847046189000846952910528;
        points[29] = -0.311014558769390637049757721609300928309101820550799296;
        points[30] = -0.270673285994980405537672241270283096176167016721643493;
        points[31] = -0.229850766003717031018169433225752628557662173781728275;
        points[32] = -0.188619579744918578310721067679934081189582783312589715;
        points[33] = -0.147053034761753411728851356888524725001089401112616445;
        points[34] = -0.105225034853070971863988799247950546214578276691474522;
        points[35] = -0.0632099486751162918957266017766211004098019570973614382;
        points[36] = -0.0210824775167483044475352185140474316260076172757574263;
        points[37] = 0.0210824775167483044475352185140474316260076172757574263;
        points[38] = 0.0632099486751162918957266017766211004098019570973614382;
        points[39] = 0.105225034853070971863988799247950546214578276691474522;
        points[40] = 0.147053034761753411728851356888524725001089401112616445;
        points[41] = 0.188619579744918578310721067679934081189582783312589715;
        points[42] = 0.229850766003717031018169433225752628557662173781728275;
        points[43] = 0.270673285994980405537672241270283096176167016721643493;
        points[44] = 0.311014558769390637049757721609300928309101820550799296;
        points[45] = 0.35080285901779804749253496882847046189000846952910528;
        points[46] = 0.389967444596250750571071929966565830249195130681263345;
        points[47] = 0.428438682303003279375829294020234725948163034514462172;
        points[48] = 0.466148171683881183422059831975418354920715274110522696;
        points[49] = 0.503028866645885165914073043877817664410055450351572075;
        points[50] = 0.539015194662817083240727032646304843723706487596167643;
        points[51] = 0.574043173360994152501892620261297098889453373047721229;
        points[52] = 0.60805052427777982552516290547091835412680395972320066;
        points[53] = 0.640976783590692388595341945280529946027868340545275104;
        points[54] = 0.672763409620247602718505466750305318294137735436361868;
        points[55] = 0.703353886915441859060319959214489978824382653935553403;
        points[56] = 0.732693826736880277762463403990613937762755443095040949;
        points[57] = 0.760731063758994475968622898553480945851369248155809806;
        points[58] = 0.787415748819575517819986709906400027953713205048095712;
        points[59] = 0.812700437551974373875255111282462202894771986196244029;
        points[60] = 0.83654017474281573916834801702132869479992194653114907;
        points[61] = 0.858892574265983576796486387287919192951200204948751875;
        points[62] = 0.879717894452088809228763264673946931282553536755529294;
        points[63] = 0.898979108761895795583715403801278323421553059210322594;
        points[64] = 0.916641971642906460677148258286043324813761362065893825;
        points[65] = 0.932675079462054566085601129701867580083743327587999591;
        points[66] = 0.947049926428385008272628348414517065062184107483141775;
        points[67] = 0.959740955459528912699917216038501511324960595109202744;
        points[68] = 0.970725604042518726819354559822744926138836973923285893;
        points[69] = 0.979984345431300336098804066408403892589708097829521888;
        points[70] = 0.987500726616238559607124327139481900183327480467864031;
        points[71] = 0.993261409804644972713884927841565624008488785345152326;
        points[72] = 0.997256261711016390838064096344457785885078750386873634;
        points[73] = 0.999479068780329524271044515109528496839355889552266194;
        weights[0] = 0.00133676165006988355032874913646798588956607350506671463;
        weights[1] = 0.0031094201498967546786733661213291849902969143856129435;
        weights[2] = 0.00487917975859414458428981176704155297752693232414016605;
        weights[3] = 0.00664049290911435763476124870752573675165256017353743622;
        weights[4] = 0.00839004543397139706408834085082922440811856965944249308;
        weights[5] = 0.0101246945382873054211199360180768542226617844986379965;
        weights[6] = 0.0118413475474996673231684741193353615189899672853216968;
        weights[7] = 0.013536949411787494341053351354474172640289041111851204;
        weights[8] = 0.0152084842434012348088747407275396362301309721614336847;
        weights[9] = 0.0168529795820248535848474727664362323524769809444921204;
        weights[10] = 0.0184675113089798797828537296592577326600909105917715438;
        weights[11] = 0.0200492087027949442527346554704768947802938015448118496;
        weights[12] = 0.0215952594816758889696995473220615224659796479650963511;
        weights[13] = 0.0231029147749158230309326268891745040405158047836889739;
        weights[14] = 0.0245694939959427672456492057832262287475823996430840559;
        weights[15] = 0.0259923896007237878667735460436170044085377292477874993;
        weights[16] = 0.0273690717196793523024377727124606912676779775706387333;
        weights[17] = 0.02869709265326987534209510644866333156711096780046526;
        weights[18] = 0.0299740912224611873399647771003799653470679013439501249;
        weights[19] = 0.0311977969659154260333723511056083686148940236976437486;
        weights[20] = 0.0323660341762169995252801864901367563421769689934072231;
        weights[21] = 0.0334767257678287662637224740216670686779638281979054456;
        weights[22] = 0.0345278969698264610033339737986060254145193823802522223;
        weights[23] = 0.0355176788368009599258538694538579004162073720094206849;
        weights[24] = 0.036444311571658564481810907516280945850703250268034666;
        weights[25] = 0.0373061476543941557337066856256952171128476043998132987;
        weights[26] = 0.0381016547712632488963516566586349812925880534004795765;
        weights[27] = 0.0388294185391377077580822729118821102160788256203948353;
        weights[28] = 0.0394881450201964683236327204903400922038011302689509578;
        weights[29] = 0.0400766630224769667591511719233769673422815882778955257;
        weights[30] = 0.0405939261821947280580768198279083024133611460520297213;
        weights[31] = 0.0410390148241272668474188098165169007705427651573340917;
        weights[32] = 0.0414111375967535108200680700198815018151357031751025024;
        weights[33] = 0.041709632879240754378709933608623490234421021311963594;
        weights[34] = 0.0419339699577770214699552078398869823819063938624867494;
        weights[35] = 0.042083749969156972474895765002382886286675062222788294;
        weights[36] = 0.0421587066099434221222306648903396853473289441632660146;
        weights[37] = 0.0421587066099434221222306648903396853473289441632660146;
        weights[38] = 0.042083749969156972474895765002382886286675062222788294;
        weights[39] = 0.0419339699577770214699552078398869823819063938624867494;
        weights[40] = 0.041709632879240754378709933608623490234421021311963594;
        weights[41] = 0.0414111375967535108200680700198815018151357031751025024;
        weights[42] = 0.0410390148241272668474188098165169007705427651573340917;
        weights[43] = 0.0405939261821947280580768198279083024133611460520297213;
        weights[44] = 0.0400766630224769667591511719233769673422815882778955257;
        weights[45] = 0.0394881450201964683236327204903400922038011302689509578;
        weights[46] = 0.0388294185391377077580822729118821102160788256203948353;
        weights[47] = 0.0381016547712632488963516566586349812925880534004795765;
        weights[48] = 0.0373061476543941557337066856256952171128476043998132987;
        weights[49] = 0.036444311571658564481810907516280945850703250268034666;
        weights[50] = 0.0355176788368009599258538694538579004162073720094206849;
        weights[51] = 0.0345278969698264610033339737986060254145193823802522223;
        weights[52] = 0.0334767257678287662637224740216670686779638281979054456;
        weights[53] = 0.0323660341762169995252801864901367563421769689934072231;
        weights[54] = 0.0311977969659154260333723511056083686148940236976437486;
        weights[55] = 0.0299740912224611873399647771003799653470679013439501249;
        weights[56] = 0.02869709265326987534209510644866333156711096780046526;
        weights[57] = 0.0273690717196793523024377727124606912676779775706387333;
        weights[58] = 0.0259923896007237878667735460436170044085377292477874993;
        weights[59] = 0.0245694939959427672456492057832262287475823996430840559;
        weights[60] = 0.0231029147749158230309326268891745040405158047836889739;
        weights[61] = 0.0215952594816758889696995473220615224659796479650963511;
        weights[62] = 0.0200492087027949442527346554704768947802938015448118496;
        weights[63] = 0.0184675113089798797828537296592577326600909105917715438;
        weights[64] = 0.0168529795820248535848474727664362323524769809444921204;
        weights[65] = 0.0152084842434012348088747407275396362301309721614336847;
        weights[66] = 0.013536949411787494341053351354474172640289041111851204;
        weights[67] = 0.0118413475474996673231684741193353615189899672853216968;
        weights[68] = 0.0101246945382873054211199360180768542226617844986379965;
        weights[69] = 0.00839004543397139706408834085082922440811856965944249308;
        weights[70] = 0.00664049290911435763476124870752573675165256017353743622;
        weights[71] = 0.00487917975859414458428981176704155297752693232414016605;
        weights[72] = 0.0031094201498967546786733661213291849902969143856129435;
        weights[73] = 0.00133676165006988355032874913646798588956607350506671463;
        return;
    case 75:
        points[0] = -0.999492775536035456483467194356316110250299884312792209;
        points[1] = -0.997328428962231803309065756743910551040037202827069498;
        points[2] = -0.993438536578892704377047197845772621919036684406806905;
        points[3] = -0.987828966767524520141266680075041950074024589391140505;
        points[4] = -0.980509324597416605771693123735209141644903571089240758;
        points[5] = -0.971492256343063823363813797467682014399763130510318074;
        points[6] = -0.960793363741892314155448000612802246234013218979725978;
        points[7] = -0.948431165079287377921919847246826407740084598911714361;
        points[8] = -0.934427059964107156836194126253732091182474009176760108;
        points[9] = -0.91880529122839399127123949529349118808079230783624819;
        points[10] = -0.901592902548446334093964271936135267281053303678270813;
        points[11] = -0.882819691447895542160092313543597413877400561973605714;
        points[12] = -0.862518157626883425461262345923362543368251560794404342;
        points[13] = -0.840723446654958050097011601406035732595622393933468577;
        points[14] = -0.81747328910354131484339527120461643970905735349253727;
        points[15] = -0.792807935213563510360413945679631767568587189433744682;
        points[16] = -0.766770085206641925524094754183636557141797532497888193;
        points[17] = -0.739404815358032526496513566777360852771864612064262259;
        points[18] = -0.710759499958041126769559334273221374419104300772711138;
        points[19] = -0.680883729296269598044383905502729217711884680038381342;
        points[20] = -0.64982922381026223258688693479515254780305893497952741;
        points[21] = -0.617649744546925964450185877592788716818507533086368454;
        points[22] = -0.584401000091577880319607311343395110299474797186950564;
        points[23] = -0.550140550125645551503014936343069526096997643842164296;
        points[24] = -0.514927705779916640527991952384349715958434868921115275;
        points[25] = -0.478823426955803157015809075989577164271305738547906827;
        points[26] = -0.44189021679234826653733546388109694793294290924975158;
        points[27] = -0.404192013461653613190806873328619079553135555844350544;
        points[28] = -0.365794079480035925326018020903382615310723042819831289;
        points[29] = -0.326762888726526302358399974760230615171354265087882848;
        points[30] = -0.287166011364297246942701665150081638820495431103355381;
        points[31] = -0.247071996864234756904240039398480109280954088729370632;
        points[32] = -0.206550255333159607114474453589905277385332826813754948;
        points[33] = -0.165670937352137818385949520777985796207833156131773608;
        points[34] = -0.124504812532900261625084491739368882801750168150598651;
        points[35] = -0.0831231470026109916974970876587727894186338192139608899;
        points[36] = -0.0415975800290794559748913312280015553347223653530659895;
        points[37] = 0;
        points[38] = 0.0415975800290794559748913312280015553347223653530659895;
        points[39] = 0.0831231470026109916974970876587727894186338192139608899;
        points[40] = 0.124504812532900261625084491739368882801750168150598651;
        points[41] = 0.165670937352137818385949520777985796207833156131773608;
        points[42] = 0.206550255333159607114474453589905277385332826813754948;
        points[43] = 0.247071996864234756904240039398480109280954088729370632;
        points[44] = 0.287166011364297246942701665150081638820495431103355381;
        points[45] = 0.326762888726526302358399974760230615171354265087882848;
        points[46] = 0.365794079480035925326018020903382615310723042819831289;
        points[47] = 0.404192013461653613190806873328619079553135555844350544;
        points[48] = 0.44189021679234826653733546388109694793294290924975158;
        points[49] = 0.478823426955803157015809075989577164271305738547906827;
        points[50] = 0.514927705779916640527991952384349715958434868921115275;
        points[51] = 0.550140550125645551503014936343069526096997643842164296;
        points[52] = 0.584401000091577880319607311343395110299474797186950564;
        points[53] = 0.617649744546925964450185877592788716818507533086368454;
        points[54] = 0.64982922381026223258688693479515254780305893497952741;
        points[55] = 0.680883729296269598044383905502729217711884680038381342;
        points[56] = 0.710759499958041126769559334273221374419104300772711138;
        points[57] = 0.739404815358032526496513566777360852771864612064262259;
        points[58] = 0.766770085206641925524094754183636557141797532497888193;
        points[59] = 0.792807935213563510360413945679631767568587189433744682;
        points[60] = 0.81747328910354131484339527120461643970905735349253727;
        points[61] = 0.840723446654958050097011601406035732595622393933468577;
        points[62] = 0.862518157626883425461262345923362543368251560794404342;
        points[63] = 0.882819691447895542160092313543597413877400561973605714;
        points[64] = 0.901592902548446334093964271936135267281053303678270813;
        points[65] = 0.91880529122839399127123949529349118808079230783624819;
        points[66] = 0.934427059964107156836194126253732091182474009176760108;
        points[67] = 0.948431165079287377921919847246826407740084598911714361;
        points[68] = 0.960793363741892314155448000612802246234013218979725978;
        points[69] = 0.971492256343063823363813797467682014399763130510318074;
        points[70] = 0.980509324597416605771693123735209141644903571089240758;
        points[71] = 0.987828966767524520141266680075041950074024589391140505;
        points[72] = 0.993438536578892704377047197845772621919036684406806905;
        points[73] = 0.997328428962231803309065756743910551040037202827069498;
        points[74] = 0.999492775536035456483467194356316110250299884312792209;
        weights[0] = 0.00130159171737585599389822558245726639911780094144576684;
        weights[1] = 0.00302767101460604129122644578816230094961096121180357519;
        weights[2] = 0.00475106918501527396589875647515466299495021005012024743;
        weights[3] = 0.00646646490703753840196319207359732787158016099990222457;
        weights[4] = 0.00817071070732782640371785917812283208628152907442180227;
        weights[5] = 0.00986082491611401839205174983564076686492510729524142698;
        weights[6] = 0.0115338733283044959668136761875654321749764893671666173;
        weights[7] = 0.0131869567628248021196138741970230798826480546085587222;
        weights[8] = 0.0148172122898144685201377355490909003132007799096593654;
        weights[9] = 0.0164218171190246400435993060787563812924198653461852287;
        weights[10] = 0.0179979931256450506379456744808312063867744950782332421;
        weights[11] = 0.0195430115201278893795709202535551253664684719193498236;
        weights[12] = 0.0210541975122828422364459426083950109173227209820531466;
        weights[13] = 0.0225289349138657764505463799825644212065582466955436652;
        weights[14] = 0.0239646706537169591747654488788657568594592724504453845;
        weights[15] = 0.0253589191902163790942084395913309005649909296811950754;
        weights[16] = 0.0267092668101208517723540830687150451602806036014552769;
        weights[17] = 0.0280133758047805408252590145381061515424984291990562214;
        weights[18] = 0.0292689885157259868050334064839846517273007774191742749;
        weights[19] = 0.0304739312422145392031376219417682480912126114406649662;
        weights[20] = 0.0316261180037496480560323918093918443179643692993972207;
        weights[21] = 0.0327235541509342205215227573099681071248552393668633261;
        weights[22] = 0.033764339818334092646955687040362113349060382394258508;
        weights[23] = 0.0347466732133304065350985386972094986139297674743678935;
        weights[24] = 0.0356688537352404530891183804034152185241630213005093419;
        weights[25] = 0.0365292849192903390068510972435417114282413514745814938;
        weights[26] = 0.0373264772003320901673063926148265517703921580627572872;
        weights[27] = 0.0380590504915136031356309000378778899904279353230027305;
        weights[28] = 0.0387257365734325758414664510051756044277536839543275573;
        weights[29] = 0.0393253812896351625207674689825894830318875007047774178;
        weights[30] = 0.039856946544656352575965304840194506136017118584534711;
        weights[31] = 0.040319512101141577558174368373926889063031556434928943;
        weights[32] = 0.0407122771729373302987578206085518610440029276026361864;
        weights[33] = 0.0410345618113921066762225173102152957064302900935560965;
        weights[34] = 0.0412858080824671890834608725306558644185120174105371048;
        weights[35] = 0.0414655810326190921352483356626358588953980123264186187;
        weights[36] = 0.0415735694417812787829994222333801606617393377174670969;
        weights[37] = 0.0416095863621414093804670810447881456872316264068048249;
        weights[38] = 0.0415735694417812787829994222333801606617393377174670969;
        weights[39] = 0.0414655810326190921352483356626358588953980123264186187;
        weights[40] = 0.0412858080824671890834608725306558644185120174105371048;
        weights[41] = 0.0410345618113921066762225173102152957064302900935560965;
        weights[42] = 0.0407122771729373302987578206085518610440029276026361864;
        weights[43] = 0.040319512101141577558174368373926889063031556434928943;
        weights[44] = 0.039856946544656352575965304840194506136017118584534711;
        weights[45] = 0.0393253812896351625207674689825894830318875007047774178;
        weights[46] = 0.0387257365734325758414664510051756044277536839543275573;
        weights[47] = 0.0380590504915136031356309000378778899904279353230027305;
        weights[48] = 0.0373264772003320901673063926148265517703921580627572872;
        weights[49] = 0.0365292849192903390068510972435417114282413514745814938;
        weights[50] = 0.0356688537352404530891183804034152185241630213005093419;
        weights[51] = 0.0347466732133304065350985386972094986139297674743678935;
        weights[52] = 0.033764339818334092646955687040362113349060382394258508;
        weights[53] = 0.0327235541509342205215227573099681071248552393668633261;
        weights[54] = 0.0316261180037496480560323918093918443179643692993972207;
        weights[55] = 0.0304739312422145392031376219417682480912126114406649662;
        weights[56] = 0.0292689885157259868050334064839846517273007774191742749;
        weights[57] = 0.0280133758047805408252590145381061515424984291990562214;
        weights[58] = 0.0267092668101208517723540830687150451602806036014552769;
        weights[59] = 0.0253589191902163790942084395913309005649909296811950754;
        weights[60] = 0.0239646706537169591747654488788657568594592724504453845;
        weights[61] = 0.0225289349138657764505463799825644212065582466955436652;
        weights[62] = 0.0210541975122828422364459426083950109173227209820531466;
        weights[63] = 0.0195430115201278893795709202535551253664684719193498236;
        weights[64] = 0.0179979931256450506379456744808312063867744950782332421;
        weights[65] = 0.0164218171190246400435993060787563812924198653461852287;
        weights[66] = 0.0148172122898144685201377355490909003132007799096593654;
        weights[67] = 0.0131869567628248021196138741970230798826480546085587222;
        weights[68] = 0.0115338733283044959668136761875654321749764893671666173;
        weights[69] = 0.00986082491611401839205174983564076686492510729524142698;
        weights[70] = 0.00817071070732782640371785917812283208628152907442180227;
        weights[71] = 0.00646646490703753840196319207359732787158016099990222457;
        weights[72] = 0.00475106918501527396589875647515466299495021005012024743;
        weights[73] = 0.00302767101460604129122644578816230094961096121180357519;
        weights[74] = 0.00130159171737585599389822558245726639911780094144576684;
        return;
    case 76:
        points[0] = -0.999505948362153078106201749533763365820349911386739784;
        points[1] = -0.997397786355355436691434380834201280407923935468292963;
        points[2] = -0.993608772723526984616191431928802504614655294878504569;
        points[3] = -0.988144453359837438498644758224228630907922509036090643;
        points[4] = -0.981013938975655895251838113832965029084639862956975202;
        points[5] = -0.972229228520376904478080189594675597352940476861113907;
        points[6] = -0.961805126758767827168032116152345766339651490447105224;
        points[7] = -0.949759207710896385084895436968691365458790633646527639;
        points[8] = -0.936111781934810796263222998921178227050223945244010685;
        points[9] = -0.920885861252150118491581425070997810154222685319538662;
        points[10] = -0.904107119545566828544425930704285315717250054185022642;
        points[11] = -0.885803849292082787214910202536350988146495925972319001;
        points[12] = -0.866006913771981955227867736059168542435332425845288378;
        points[13] = -0.844749694983342394010890285541863952058162025568659496;
        points[14] = -0.822068037328974613477770710261231471791498475684127842;
        points[15] = -0.798000187161200169752810467502382170540680935996660134;
        points[16] = -0.772586728281809761297673467986903007856868143053037324;
        points[17] = -0.745870513503610443148638762053599450329715440402735819;
        points[18] = -0.717896592387703639373005509089984641787404712858834161;
        points[19] = -0.688712135277640596996524675275844280901584500331610211;
        points[20] = -0.658366353758142630275232660208093750481819563159122421;
        points[21] = -0.626910417672266559145452115896092939526952486924531596;
        points[22] = -0.594397368836792918151506290349079075249729058141025773;
        points[23] = -0.560882031601237478999161665630557768399289240356380986;
        points[24] = -0.526420920401242590955307468941036137619225030623547479;
        points[25] = -0.491072144462193864861745245066629254511595457424088085;
        points[26] = -0.454895309813726339433840701780305028293186065703402906;
        points[27] = -0.417951418780327298795659503678897452161640283675748189;
        points[28] = -0.380302767117504443467504475804714586831428445447703656;
        points[29] = -0.342012838966962023931201208974228126242591256717043843;
        points[30] = -0.303146199807907778099415177581090272860183989525931092;
        points[31] = -0.263768387584994276479405483319366151052479897420939676;
        points[32] = -0.223945802196474133762637597327081193799120154519526252;
        points[33] = -0.183745593528914477419244431135180534211878148923124322;
        points[34] = -0.143235548227267521445508091942340103941666957520586373;
        points[35] = -0.102483975391227018300050937253807928275485073591744826;
        points[36] = -0.0615595913906112084286677453088285953319423245747257278;
        points[37] = -0.0205314039939986355017467582099578617246574476034919185;
        points[38] = 0.0205314039939986355017467582099578617246574476034919185;
        points[39] = 0.0615595913906112084286677453088285953319423245747257278;
        points[40] = 0.102483975391227018300050937253807928275485073591744826;
        points[41] = 0.143235548227267521445508091942340103941666957520586373;
        points[42] = 0.183745593528914477419244431135180534211878148923124322;
        points[43] = 0.223945802196474133762637597327081193799120154519526252;
        points[44] = 0.263768387584994276479405483319366151052479897420939676;
        points[45] = 0.303146199807907778099415177581090272860183989525931092;
        points[46] = 0.342012838966962023931201208974228126242591256717043843;
        points[47] = 0.380302767117504443467504475804714586831428445447703656;
        points[48] = 0.417951418780327298795659503678897452161640283675748189;
        points[49] = 0.454895309813726339433840701780305028293186065703402906;
        points[50] = 0.491072144462193864861745245066629254511595457424088085;
        points[51] = 0.526420920401242590955307468941036137619225030623547479;
        points[52] = 0.560882031601237478999161665630557768399289240356380986;
        points[53] = 0.594397368836792918151506290349079075249729058141025773;
        points[54] = 0.626910417672266559145452115896092939526952486924531596;
        points[55] = 0.658366353758142630275232660208093750481819563159122421;
        points[56] = 0.688712135277640596996524675275844280901584500331610211;
        points[57] = 0.717896592387703639373005509089984641787404712858834161;
        points[58] = 0.745870513503610443148638762053599450329715440402735819;
        points[59] = 0.772586728281809761297673467986903007856868143053037324;
        points[60] = 0.798000187161200169752810467502382170540680935996660134;
        points[61] = 0.822068037328974613477770710261231471791498475684127842;
        points[62] = 0.844749694983342394010890285541863952058162025568659496;
        points[63] = 0.866006913771981955227867736059168542435332425845288378;
        points[64] = 0.885803849292082787214910202536350988146495925972319001;
        points[65] = 0.904107119545566828544425930704285315717250054185022642;
        points[66] = 0.920885861252150118491581425070997810154222685319538662;
        points[67] = 0.936111781934810796263222998921178227050223945244010685;
        points[68] = 0.949759207710896385084895436968691365458790633646527639;
        points[69] = 0.961805126758767827168032116152345766339651490447105224;
        points[70] = 0.972229228520376904478080189594675597352940476861113907;
        points[71] = 0.981013938975655895251838113832965029084639862956975202;
        points[72] = 0.988144453359837438498644758224228630907922509036090643;
        points[73] = 0.993608772723526984616191431928802504614655294878504569;
        points[74] = 0.997397786355355436691434380834201280407923935468292963;
        points[75] = 0.999505948362153078106201749533763365820349911386739784;
        weights[0] = 0.00126779163408535966328245939686656544470374536704995483;
        weights[1] = 0.00294910295364247490039336895170898332446101941350172451;
        weights[2] = 0.00462793522803742132612861437639171175052899443698676735;
        weights[3] = 0.00629918049732844586657342024031586533178951964497344722;
        weights[4] = 0.00795984747723973462111880862934738061071909785419442614;
        weights[5] = 0.00960710541471375408240434266004927579934020808489166016;
        weights[6] = 0.0112381685696676872396749095312965106048416923974066906;
        weights[7] = 0.0128502838475101449449253668158210595101917998064548763;
        weights[8] = 0.0144407317482766799398897817242536688730342995335463862;
        weights[9] = 0.0160068299122485708885102273112943802099220693484813198;
        weights[10] = 0.0175459372914742309541996904827437862954389147851647198;
        weights[11] = 0.0190554584671905828068022611703513015153222655943950862;
        weights[12] = 0.0205328479679080210929750518202067218002042356996553824;
        weights[13] = 0.0219756145344162491680130548022530279660278846225831549;
        weights[14] = 0.0233813253070111866224797045206482399256530219787108647;
        weights[15] = 0.0247476099206596716432644633445918054218996739464063415;
        weights[16] = 0.0260721644979859835242745409639064788668970042815852497;
        weights[17] = 0.0273527555318275216741524478615613452199577800960445381;
        weights[18] = 0.0285872236500540037739750531785686993149482155836772934;
        weights[19] = 0.0297734872559050409567073546644355294330262069652330742;
        weights[20] = 0.0309095460374915953899369152555472832430740190851736895;
        weights[21] = 0.0319934843404216000685351788614136407925668316281453412;
        weights[22] = 0.0330234743977917410065415326955970304738119743107038296;
        weights[23] = 0.033997779412056380846742474758256621428848495493338173;
        weights[24] = 0.0349147564835507674441254021073976142469803092482502046;
        weights[25] = 0.0357728593807139475277793793588240289649039559440597077;
        weights[26] = 0.0365706411473296170072440495990840508149143616700578764;
        weights[27] = 0.0373067565423816098275671633617123257529472464552741325;
        weights[28] = 0.0379799643084052831952353322096981090267544912096844133;
        weights[29] = 0.0385891292645067383429211983364555312533144117872695958;
        weights[30] = 0.0391332242205184407675074994579122224899896642862802508;
        weights[31] = 0.039611331709062058423146714848299263047362659780714971;
        weights[32] = 0.0400226455325968261164617317211444482459424880149200923;
        weights[33] = 0.0403664721228440231540956228470661888417253131130032296;
        weights[34] = 0.0406422317102947387774549688589795489675538877307426368;
        weights[35] = 0.0408494593018284922803917962422068007475918270413382571;
        weights[36] = 0.040987805464793951541308403154628223611543895667840153;
        weights[37] = 0.0410570369162294225932597138791647308312665180922604879;
        weights[38] = 0.0410570369162294225932597138791647308312665180922604879;
        weights[39] = 0.040987805464793951541308403154628223611543895667840153;
        weights[40] = 0.0408494593018284922803917962422068007475918270413382571;
        weights[41] = 0.0406422317102947387774549688589795489675538877307426368;
        weights[42] = 0.0403664721228440231540956228470661888417253131130032296;
        weights[43] = 0.0400226455325968261164617317211444482459424880149200923;
        weights[44] = 0.039611331709062058423146714848299263047362659780714971;
        weights[45] = 0.0391332242205184407675074994579122224899896642862802508;
        weights[46] = 0.0385891292645067383429211983364555312533144117872695958;
        weights[47] = 0.0379799643084052831952353322096981090267544912096844133;
        weights[48] = 0.0373067565423816098275671633617123257529472464552741325;
        weights[49] = 0.0365706411473296170072440495990840508149143616700578764;
        weights[50] = 0.0357728593807139475277793793588240289649039559440597077;
        weights[51] = 0.0349147564835507674441254021073976142469803092482502046;
        weights[52] = 0.033997779412056380846742474758256621428848495493338173;
        weights[53] = 0.0330234743977917410065415326955970304738119743107038296;
        weights[54] = 0.0319934843404216000685351788614136407925668316281453412;
        weights[55] = 0.0309095460374915953899369152555472832430740190851736895;
        weights[56] = 0.0297734872559050409567073546644355294330262069652330742;
        weights[57] = 0.0285872236500540037739750531785686993149482155836772934;
        weights[58] = 0.0273527555318275216741524478615613452199577800960445381;
        weights[59] = 0.0260721644979859835242745409639064788668970042815852497;
        weights[60] = 0.0247476099206596716432644633445918054218996739464063415;
        weights[61] = 0.0233813253070111866224797045206482399256530219787108647;
        weights[62] = 0.0219756145344162491680130548022530279660278846225831549;
        weights[63] = 0.0205328479679080210929750518202067218002042356996553824;
        weights[64] = 0.0190554584671905828068022611703513015153222655943950862;
        weights[65] = 0.0175459372914742309541996904827437862954389147851647198;
        weights[66] = 0.0160068299122485708885102273112943802099220693484813198;
        weights[67] = 0.0144407317482766799398897817242536688730342995335463862;
        weights[68] = 0.0128502838475101449449253668158210595101917998064548763;
        weights[69] = 0.0112381685696676872396749095312965106048416923974066906;
        weights[70] = 0.00960710541471375408240434266004927579934020808489166016;
        weights[71] = 0.00795984747723973462111880862934738061071909785419442614;
        weights[72] = 0.00629918049732844586657342024031586533178951964497344722;
        weights[73] = 0.00462793522803742132612861437639171175052899443698676735;
        weights[74] = 0.00294910295364247490039336895170898332446101941350172451;
        weights[75] = 0.00126779163408535966328245939686656544470374536704995483;
        return;
    case 77:
        points[0] = -0.999518614633410009748581040343202822204846455892760663;
        points[1] = -0.997464477869214099874869736334281509695058776289606298;
        points[2] = -0.99377247094987824830891119226718335874057609276822802;
        points[3] = -0.98844783822256130732501902966776799521523932173793365;
        points[4] = -0.981499227331138462388344837192260198759109782301681658;
        points[5] = -0.972938030749108390346306143672228975572311272741722995;
        points[6] = -0.962778306467734311940161867734575270875463804204633752;
        points[7] = -0.951036743600591871523428828180724843142738202261026508;
        points[8] = -0.937732631959061044190142145801946234436179301366755009;
        points[9] = -0.922887829359402199928045435255686606537796861796566031;
        points[10] = -0.906526725321257818021090807691464216912946066558922881;
        points[11] = -0.888676200825564069894834904182990276598685244683130983;
        points[12] = -0.869365584067734059878654379413498502572702510060589036;
        points[13] = -0.848626602229624036469577833301314449099164421297472406;
        points[14] = -0.826493329329002119435586710882311683907184549561017388;
        points[15] = -0.803002130222925227383637799180832625660132989796709179;
        points[16] = -0.778191600852543141872867943895100554773373176230139661;
        points[17] = -0.752102504825215941384386620458921809864698304212439888;
        points[18] = -0.724777706436911728780785514517931978511746304940744219;
        points[19] = -0.696262100244242224791019967655212649334689197907763276;
        points[20] = -0.666602537301451493590916058492997343217121449302984394;
        points[21] = -0.635847748183312367013651211508255733786662338573399781;
        points[22] = -0.604048262920257384970148386065463530425101312962255071;
        points[23] = -0.571256327977198250806983160177293301582360062145075911;
        points[24] = -0.537525820412377739024424827550267541086010702276566983;
        points[25] = -0.502912159357251517807726309437455161078019460711412978;
        points[26] = -0.467472214962811794644643659926733443257635483891516499;
        points[27] = -0.43126421496193568207252416931543919512602840541129039;
        points[28] = -0.394347649001263560468467465320490781986010679132032841;
        points[29] = -0.356783170899781070578555317605293197334129561845802285;
        points[30] = -0.318632498994687308777523081194707874549861275059211566;
        points[31] = -0.279958314738276122064704751512273411763243509790635182;
        points[32] = -0.240824159712432197609681799711166369247999568664223283;
        points[33] = -0.20129433122994435663814765725843533354690931451074071;
        points[34] = -0.161433776694160931607184099717913028515180578227763728;
        points[35] = -0.121307986890552586641806820249756309837679388208799324;
        points[36] = -0.0809828883855031312064977868345239030210771101396969968;
        points[37] = -0.0405247352091159259300698128567524732082909142341761193;
        points[38] = 0;
        points[39] = 0.0405247352091159259300698128567524732082909142341761193;
        points[40] = 0.0809828883855031312064977868345239030210771101396969968;
        points[41] = 0.121307986890552586641806820249756309837679388208799324;
        points[42] = 0.161433776694160931607184099717913028515180578227763728;
        points[43] = 0.20129433122994435663814765725843533354690931451074071;
        points[44] = 0.240824159712432197609681799711166369247999568664223283;
        points[45] = 0.279958314738276122064704751512273411763243509790635182;
        points[46] = 0.318632498994687308777523081194707874549861275059211566;
        points[47] = 0.356783170899781070578555317605293197334129561845802285;
        points[48] = 0.394347649001263560468467465320490781986010679132032841;
        points[49] = 0.43126421496193568207252416931543919512602840541129039;
        points[50] = 0.467472214962811794644643659926733443257635483891516499;
        points[51] = 0.502912159357251517807726309437455161078019460711412978;
        points[52] = 0.537525820412377739024424827550267541086010702276566983;
        points[53] = 0.571256327977198250806983160177293301582360062145075911;
        points[54] = 0.604048262920257384970148386065463530425101312962255071;
        points[55] = 0.635847748183312367013651211508255733786662338573399781;
        points[56] = 0.666602537301451493590916058492997343217121449302984394;
        points[57] = 0.696262100244242224791019967655212649334689197907763276;
        points[58] = 0.724777706436911728780785514517931978511746304940744219;
        points[59] = 0.752102504825215941384386620458921809864698304212439888;
        points[60] = 0.778191600852543141872867943895100554773373176230139661;
        points[61] = 0.803002130222925227383637799180832625660132989796709179;
        points[62] = 0.826493329329002119435586710882311683907184549561017388;
        points[63] = 0.848626602229624036469577833301314449099164421297472406;
        points[64] = 0.869365584067734059878654379413498502572702510060589036;
        points[65] = 0.888676200825564069894834904182990276598685244683130983;
        points[66] = 0.906526725321257818021090807691464216912946066558922881;
        points[67] = 0.922887829359402199928045435255686606537796861796566031;
        points[68] = 0.937732631959061044190142145801946234436179301366755009;
        points[69] = 0.951036743600591871523428828180724843142738202261026508;
        points[70] = 0.962778306467734311940161867734575270875463804204633752;
        points[71] = 0.972938030749108390346306143672228975572311272741722995;
        points[72] = 0.981499227331138462388344837192260198759109782301681658;
        points[73] = 0.98844783822256130732501902966776799521523932173793365;
        points[74] = 0.99377247094987824830891119226718335874057609276822802;
        points[75] = 0.997464477869214099874869736334281509695058776289606298;
        points[76] = 0.999518614633410009748581040343202822204846455892760663;
        weights[0] = 0.00123529117713940961417186935777016848855747114460226085;
        weights[1] = 0.00287355308365269165727841032591900696341613961106779289;
        weights[2] = 0.00450952360020583533323826006172252013521450788789408147;
        weights[3] = 0.0061382961597563418392698976419496857142395451908600026;
        weights[4] = 0.00775702595008307073184237150150868947574025260212923153;
        weights[5] = 0.00936302369238643076926194010921226908301876996387653098;
        weights[6] = 0.0109536428539113542385909906564311012688402729562491386;
        weights[7] = 0.0125262673692273651873599360609261815653350960338751527;
        weights[8] = 0.0140783123400270040501679745469481757596435542442793015;
        weights[9] = 0.0156072272687491312950812528273540552539541773179912689;
        weights[10] = 0.0171104999065311041762396265422816306268623578233327049;
        weights[11] = 0.0185856602483414855091797455372899461996496569499498976;
        weights[12] = 0.0200302845343161763962462341421682348538273255678658763;
        weights[13] = 0.0214419992054561355051249609455896009850809350572560495;
        weights[14] = 0.0228184847901295205129096684242380455145461311131252662;
        weights[15] = 0.0241574797079558449405938786766026000793409194960833186;
        weights[16] = 0.0254567839816944037526377611042545806827778773582593409;
        weights[17] = 0.0267142628495578908320027903339693578628644639853649938;
        weights[18] = 0.027927850271276968541507245838539354767009972818849827;
        weights[19] = 0.0290955523217687613487024909925899428883833118545845882;
        weights[20] = 0.0302154504666229986913986896026689186938004272571748889;
        weights[21] = 0.0312857047139054333939564688248023297020139879358841029;
        weights[22] = 0.0323045566370309755935720248770189554290382213261538264;
        weights[23] = 0.0332703322636985453028394501889424389873258533198666248;
        weights[24] = 0.0341814448261156792653179293666783037308213464727480549;
        weights[25] = 0.0350363973679782784548775341768602636405129216152780398;
        weights[26] = 0.0358337852039119626026426354988714582411472252435756789;
        weights[27] = 0.0365722982273274545334583301884417383226985976441348136;
        weights[28] = 0.0372507230628937188787602752773923820733634087143461606;
        weights[29] = 0.0378679450600893202616668263698825532974203917189201451;
        weights[30] = 0.0384229501245545236736811673950157737264386366565747559;
        weights[31] = 0.0389148263842337856210328195269465615259641522783789781;
        weights[32] = 0.0393427656875701519371323060021403579199550804882202882;
        weights[33] = 0.0397060649312893106810375441064459939795315586951280004;
        weights[34] = 0.0400041272155912374103515108756024938206032414255387913;
        weights[35] = 0.0402364628248510841952652526450911891715909731471765262;
        weights[36] = 0.0404026900322177561703261942869865760713835898719948729;
        weights[37] = 0.0405025357267880319552496042711691702201782295924423334;
        weights[38] = 0.0405358358623256502920522617835547865558188352379329851;
        weights[39] = 0.0405025357267880319552496042711691702201782295924423334;
        weights[40] = 0.0404026900322177561703261942869865760713835898719948729;
        weights[41] = 0.0402364628248510841952652526450911891715909731471765262;
        weights[42] = 0.0400041272155912374103515108756024938206032414255387913;
        weights[43] = 0.0397060649312893106810375441064459939795315586951280004;
        weights[44] = 0.0393427656875701519371323060021403579199550804882202882;
        weights[45] = 0.0389148263842337856210328195269465615259641522783789781;
        weights[46] = 0.0384229501245545236736811673950157737264386366565747559;
        weights[47] = 0.0378679450600893202616668263698825532974203917189201451;
        weights[48] = 0.0372507230628937188787602752773923820733634087143461606;
        weights[49] = 0.0365722982273274545334583301884417383226985976441348136;
        weights[50] = 0.0358337852039119626026426354988714582411472252435756789;
        weights[51] = 0.0350363973679782784548775341768602636405129216152780398;
        weights[52] = 0.0341814448261156792653179293666783037308213464727480549;
        weights[53] = 0.0332703322636985453028394501889424389873258533198666248;
        weights[54] = 0.0323045566370309755935720248770189554290382213261538264;
        weights[55] = 0.0312857047139054333939564688248023297020139879358841029;
        weights[56] = 0.0302154504666229986913986896026689186938004272571748889;
        weights[57] = 0.0290955523217687613487024909925899428883833118545845882;
        weights[58] = 0.027927850271276968541507245838539354767009972818849827;
        weights[59] = 0.0267142628495578908320027903339693578628644639853649938;
        weights[60] = 0.0254567839816944037526377611042545806827778773582593409;
        weights[61] = 0.0241574797079558449405938786766026000793409194960833186;
        weights[62] = 0.0228184847901295205129096684242380455145461311131252662;
        weights[63] = 0.0214419992054561355051249609455896009850809350572560495;
        weights[64] = 0.0200302845343161763962462341421682348538273255678658763;
        weights[65] = 0.0185856602483414855091797455372899461996496569499498976;
        weights[66] = 0.0171104999065311041762396265422816306268623578233327049;
        weights[67] = 0.0156072272687491312950812528273540552539541773179912689;
        weights[68] = 0.0140783123400270040501679745469481757596435542442793015;
        weights[69] = 0.0125262673692273651873599360609261815653350960338751527;
        weights[70] = 0.0109536428539113542385909906564311012688402729562491386;
        weights[71] = 0.00936302369238643076926194010921226908301876996387653098;
        weights[72] = 0.00775702595008307073184237150150868947574025260212923153;
        weights[73] = 0.0061382961597563418392698976419496857142395451908600026;
        weights[74] = 0.00450952360020583533323826006172252013521450788789408147;
        weights[75] = 0.00287355308365269165727841032591900696341613961106779289;
        weights[76] = 0.00123529117713940961417186935777016848855747114460226085;
        return;
    case 78:
        points[0] = -0.999530799992423759518689966892146755520829927333163186;
        points[1] = -0.997528638378724361502298040034378991761224194753942806;
        points[2] = -0.993929961694488743182189805423806202036476877355453159;
        points[3] = -0.988739732093717434384563497029337708077939700599268381;
        points[4] = -0.981966163099550497784517825489786116429330391654437211;
        points[5] = -0.973620078506236442059910463545510743190985539470022371;
        points[6] = -0.963714835986755901559839865638146695740239307223643102;
        points[7] = -0.952266294689863363717211616918954144564146006075451572;
        points[8] = -0.939292786914946593070647145368681090515324457103538473;
        points[9] = -0.924815087780063776360327478109321786696176511991385049;
        points[10] = -0.908856381573188258207326258051021348089425087401289718;
        points[11] = -0.891442224458818578808554861761723567667381845208061297;
        points[12] = -0.872600503472724504931391899271769136954689373945726102;
        points[13] = -0.852361391822557703286001594066995493784831633904864953;
        points[14] = -0.83075730054591127273726781722832050872065818547184589;
        points[15] = -0.807822826594201686768651990436805784349181957618617174;
        points[16] = -0.783594697421142787071317747102904467965773288905111879;
        points[17] = -0.758111712162315315070400665541391211412028184347831434;
        points[18] = -0.73141467949883039749844538869453268151243353201982011;
        points[19] = -0.703546352303923772120564704421471430037472828658019072;
        points[20] = -0.674551359176750790323894360893433878621748066536012501;
        points[21] = -0.644476132972792854593097681356730483167422401859748754;
        points[22] = -0.613368836445184776799409162803244289031466151171958761;
        points[23] = -0.58127928511595175522152961814435579925260711840588708;
        points[24] = -0.548258867500612608746769281180210725033351996480877388;
        points[25] = -0.514360462813864058021890436592088919541472229587259271;
        points[26] = -0.479638356288107239685150390164635669461579251462102211;
        points[27] = -0.444148152240408603067264306947187606919358517151640902;
        points[28] = -0.407946685027098391646849052098990723772480305763352807;
        points[29] = -0.371091928028596274325726862935370748222321447390754835;
        points[30] = -0.333642900810210560782718902729722492894520686349254206;
        points[31] = -0.295659574607580145222958251881725245391437753415347752;
        points[32] = -0.257202776288112442988523146890674380174612921758956589;
        points[33] = -0.218334090942211978813689306719561699545568670324284308;
        points[34] = -0.179115763260289151562422935373625933507733867517286901;
        points[35] = -0.139610597853483594909275817883455609761653949802603029;
        points[36] = -0.0998818586777284105284946538386503503744867683360967446;
        points[37] = -0.059993167722217693635874899911272805363387221532938642;
        points[38] = -0.0200084031245179229520674314415575465206882568348010672;
        points[39] = 0.0200084031245179229520674314415575465206882568348010672;
        points[40] = 0.059993167722217693635874899911272805363387221532938642;
        points[41] = 0.0998818586777284105284946538386503503744867683360967446;
        points[42] = 0.139610597853483594909275817883455609761653949802603029;
        points[43] = 0.179115763260289151562422935373625933507733867517286901;
        points[44] = 0.218334090942211978813689306719561699545568670324284308;
        points[45] = 0.257202776288112442988523146890674380174612921758956589;
        points[46] = 0.295659574607580145222958251881725245391437753415347752;
        points[47] = 0.333642900810210560782718902729722492894520686349254206;
        points[48] = 0.371091928028596274325726862935370748222321447390754835;
        points[49] = 0.407946685027098391646849052098990723772480305763352807;
        points[50] = 0.444148152240408603067264306947187606919358517151640902;
        points[51] = 0.479638356288107239685150390164635669461579251462102211;
        points[52] = 0.514360462813864058021890436592088919541472229587259271;
        points[53] = 0.548258867500612608746769281180210725033351996480877388;
        points[54] = 0.58127928511595175522152961814435579925260711840588708;
        points[55] = 0.613368836445184776799409162803244289031466151171958761;
        points[56] = 0.644476132972792854593097681356730483167422401859748754;
        points[57] = 0.674551359176750790323894360893433878621748066536012501;
        points[58] = 0.703546352303923772120564704421471430037472828658019072;
        points[59] = 0.73141467949883039749844538869453268151243353201982011;
        points[60] = 0.758111712162315315070400665541391211412028184347831434;
        points[61] = 0.783594697421142787071317747102904467965773288905111879;
        points[62] = 0.807822826594201686768651990436805784349181957618617174;
        points[63] = 0.83075730054591127273726781722832050872065818547184589;
        points[64] = 0.852361391822557703286001594066995493784831633904864953;
        points[65] = 0.872600503472724504931391899271769136954689373945726102;
        points[66] = 0.891442224458818578808554861761723567667381845208061297;
        points[67] = 0.908856381573188258207326258051021348089425087401289718;
        points[68] = 0.924815087780063776360327478109321786696176511991385049;
        points[69] = 0.939292786914946593070647145368681090515324457103538473;
        points[70] = 0.952266294689863363717211616918954144564146006075451572;
        points[71] = 0.963714835986755901559839865638146695740239307223643102;
        points[72] = 0.973620078506236442059910463545510743190985539470022371;
        points[73] = 0.981966163099550497784517825489786116429330391654437211;
        points[74] = 0.988739732093717434384563497029337708077939700599268381;
        points[75] = 0.993929961694488743182189805423806202036476877355453159;
        points[76] = 0.997528638378724361502298040034378991761224194753942806;
        points[77] = 0.999530799992423759518689966892146755520829927333163186;
        weights[0] = 0.00120402456606735328032987345147245473547418281707984947;
        weights[1] = 0.00280086881183863041161295632862647685579076626624131794;
        weights[2] = 0.0043955960394603467427381851807474639258283908256452746;
        weights[3] = 0.00598348994444040798964873783509819540236434664914952421;
        weights[4] = 0.00756184318943971882697814601282430445167146480962997833;
        weights[5] = 0.00912809922725508727694235536158806747215398441681047865;
        weights[6] = 0.0106797421574811133535159131082225703262343560138119186;
        weights[7] = 0.0122142845497898863976828362930638274824399371315921863;
        weights[8] = 0.0137292679201441483937267274710523928467454125999486963;
        weights[9] = 0.0152222656801784516933155697645156962223566814739783677;
        weights[10] = 0.0166908866893438918662123608508706621536166070325034962;
        weights[11] = 0.0181327789549823286444063678072723388604310540999213807;
        weights[12] = 0.0195456333433999233779178724489143594194536474206274687;
        weights[13] = 0.0209271872518777267853780976430459606579276268786120928;
        weights[14] = 0.0222752282191138867630504747081217233227542713015923159;
        weights[15] = 0.0235875974614574720964513735150647092999436702146966059;
        weights[16] = 0.0248621933262224507614434434368462294655676760097824623;
        weights[17] = 0.0260969746551088350298336961801127725239346660030226103;
        weights[18] = 0.0272899640516243648645642375433232592022018368621066545;
        weights[19] = 0.0284392510468975162623904961862687848225889923854473974;
        weights[20] = 0.0295429951586069464116200712056021360539832865795945262;
        weights[21] = 0.0305994288380130452894332041449159082056870491514342264;
        weights[22] = 0.0316068603003047977388827561916763920360385525158479185;
        weights[23] = 0.0325636762336890444080555599027974425902355970815539762;
        weights[24] = 0.0334683443828589779729814410384145285356292730748805032;
        weights[25] = 0.034319416002689090290291799626307950986526116021852876;
        weights[26] = 0.0351155281782171894748800556622834607733186012713120572;
        weights[27] = 0.0358554060071916954450057267833688969142867797822130208;
        weights[28] = 0.0365378646416847006481923507563176171475984859301814004;
        weights[29] = 0.0371618111854983868506709980378933162373427217042078583;
        weights[30] = 0.0377262464443242478642901478018203747571658106140581339;
        weights[31] = 0.0382302665258509876496202526172822796352034973834222677;
        weights[32] = 0.0386730642872576740038955581269952993678524855832242994;
        weights[33] = 0.0390539306277734131473113654912042673245125096260087603;
        weights[34] = 0.0393722556242331219372202643373100269874194927341104877;
        weights[35] = 0.0396275295078105429563934932196904736263052637378435163;
        weights[36] = 0.0398193434803640892250317557792179468511576138152116446;
        weights[37] = 0.0399473903690880248793048895754534265313747690319246953;
        weights[38] = 0.0400114651184204829887785885743960059888825231489177548;
        weights[39] = 0.0400114651184204829887785885743960059888825231489177548;
        weights[40] = 0.0399473903690880248793048895754534265313747690319246953;
        weights[41] = 0.0398193434803640892250317557792179468511576138152116446;
        weights[42] = 0.0396275295078105429563934932196904736263052637378435163;
        weights[43] = 0.0393722556242331219372202643373100269874194927341104877;
        weights[44] = 0.0390539306277734131473113654912042673245125096260087603;
        weights[45] = 0.0386730642872576740038955581269952993678524855832242994;
        weights[46] = 0.0382302665258509876496202526172822796352034973834222677;
        weights[47] = 0.0377262464443242478642901478018203747571658106140581339;
        weights[48] = 0.0371618111854983868506709980378933162373427217042078583;
        weights[49] = 0.0365378646416847006481923507563176171475984859301814004;
        weights[50] = 0.0358554060071916954450057267833688969142867797822130208;
        weights[51] = 0.0351155281782171894748800556622834607733186012713120572;
        weights[52] = 0.034319416002689090290291799626307950986526116021852876;
        weights[53] = 0.0334683443828589779729814410384145285356292730748805032;
        weights[54] = 0.0325636762336890444080555599027974425902355970815539762;
        weights[55] = 0.0316068603003047977388827561916763920360385525158479185;
        weights[56] = 0.0305994288380130452894332041449159082056870491514342264;
        weights[57] = 0.0295429951586069464116200712056021360539832865795945262;
        weights[58] = 0.0284392510468975162623904961862687848225889923854473974;
        weights[59] = 0.0272899640516243648645642375433232592022018368621066545;
        weights[60] = 0.0260969746551088350298336961801127725239346660030226103;
        weights[61] = 0.0248621933262224507614434434368462294655676760097824623;
        weights[62] = 0.0235875974614574720964513735150647092999436702146966059;
        weights[63] = 0.0222752282191138867630504747081217233227542713015923159;
        weights[64] = 0.0209271872518777267853780976430459606579276268786120928;
        weights[65] = 0.0195456333433999233779178724489143594194536474206274687;
        weights[66] = 0.0181327789549823286444063678072723388604310540999213807;
        weights[67] = 0.0166908866893438918662123608508706621536166070325034962;
        weights[68] = 0.0152222656801784516933155697645156962223566814739783677;
        weights[69] = 0.0137292679201441483937267274710523928467454125999486963;
        weights[70] = 0.0122142845497898863976828362930638274824399371315921863;
        weights[71] = 0.0106797421574811133535159131082225703262343560138119186;
        weights[72] = 0.00912809922725508727694235536158806747215398441681047865;
        weights[73] = 0.00756184318943971882697814601282430445167146480962997833;
        weights[74] = 0.00598348994444040798964873783509819540236434664914952421;
        weights[75] = 0.0043955960394603467427381851807474639258283908256452746;
        weights[76] = 0.00280086881183863041161295632862647685579076626624131794;
        weights[77] = 0.00120402456606735328032987345147245473547418281707984947;
        return;
    case 79:
        points[0] = -0.999542528479569844324151575956936834036755917636729909;
        points[1] = -0.997590394336941435176854179003281946369339048680847122;
        points[2] = -0.994081554785542622411154989281750253778397198953813262;
        points[3] = -0.989020707687784337874758037557341151749131942235472799;
        points[4] = -0.982415659251278930098581377623963704856168267086843999;
        points[5] = -0.974276699597807118178834189554494185688998246619540196;
        points[6] = -0.964616529114864786107449590864828148569165145984351088;
        points[7] = -0.953450227889269135963276154423409342484292435398361296;
        points[8] = -0.940795229306577250300016736783687970441728154473759339;
        points[9] = -0.926671291880903873664522784006798092582699132120121078;
        points[10] = -0.911100468034580800245006188968332780707465070435916019;
        points[11] = -0.894107069504235101310429787954331809916631561280057878;
        points[12] = -0.875717629303529476659517434981349199742904300491322709;
        points[13] = -0.855960860255219376473270846800301137130305982783760224;
        points[14] = -0.834867610137777882067313399868964573456980441286444717;
        points[15] = -0.812470813507806773764807907463812944382837633732287234;
        points[16] = -0.788805440269197765565028634381372712010212161719715462;
        points[17] = -0.763908441067170108458325761698697589397986694085221287;
        points[18] = -0.737818689591278209525321646778991765501331562462495237;
        points[19] = -0.710576921876824163758205219862439142797151897665642122;
        points[20] = -0.682225672699071059277620331760021501595194926373653496;
        points[21] = -0.652809209159343998524893128147247957116582609852061562;
        points[22] = -0.622373461566577238882909702240571652180706141058655015;
        points[23] = -0.590965951722139982853281611988686670316334316023074672;
        points[24] = -0.558635718719858906655853105292389733214026101284935366;
        points[25] = -0.525433242377054547896267638735354967694469087890660707;
        points[26] = -0.491410364416119821095860854196647925179518269595954468;
        points[27] = -0.456620207519689131148709734231948607797705053530407922;
        points[28] = -0.421117092385771928732145760026309102329579973062319142;
        points[29] = -0.384956452912350883922246837847471229834089774971699736;
        points[30] = -0.348194749643867867239137372131712824659015134690488927;
        points[31] = -0.310889381614736437208874957251312482571752121507641324;
        points[32] = -0.273098596727523543742536067888724643790375469368056561;
        points[33] = -0.234881400805731915877249358919073761466081497663228661;
        points[34] = -0.196297465463184641659193928760542406282653995157130432;
        points[35] = -0.157407034933861605028225613380541922754558191953739393;
        points[36] = -0.118270832007660881166912057233522913723093934773422665;
        points[37] = -0.0789499632189544054480852529555278206822454799277153852;
        points[38] = -0.0395058234359740640589947962427936947449383726853869385;
        points[39] = 0;
        points[40] = 0.0395058234359740640589947962427936947449383726853869385;
        points[41] = 0.0789499632189544054480852529555278206822454799277153852;
        points[42] = 0.118270832007660881166912057233522913723093934773422665;
        points[43] = 0.157407034933861605028225613380541922754558191953739393;
        points[44] = 0.196297465463184641659193928760542406282653995157130432;
        points[45] = 0.234881400805731915877249358919073761466081497663228661;
        points[46] = 0.273098596727523543742536067888724643790375469368056561;
        points[47] = 0.310889381614736437208874957251312482571752121507641324;
        points[48] = 0.348194749643867867239137372131712824659015134690488927;
        points[49] = 0.384956452912350883922246837847471229834089774971699736;
        points[50] = 0.421117092385771928732145760026309102329579973062319142;
        points[51] = 0.456620207519689131148709734231948607797705053530407922;
        points[52] = 0.491410364416119821095860854196647925179518269595954468;
        points[53] = 0.525433242377054547896267638735354967694469087890660707;
        points[54] = 0.558635718719858906655853105292389733214026101284935366;
        points[55] = 0.590965951722139982853281611988686670316334316023074672;
        points[56] = 0.622373461566577238882909702240571652180706141058655015;
        points[57] = 0.652809209159343998524893128147247957116582609852061562;
        points[58] = 0.682225672699071059277620331760021501595194926373653496;
        points[59] = 0.710576921876824163758205219862439142797151897665642122;
        points[60] = 0.737818689591278209525321646778991765501331562462495237;
        points[61] = 0.763908441067170108458325761698697589397986694085221287;
        points[62] = 0.788805440269197765565028634381372712010212161719715462;
        points[63] = 0.812470813507806773764807907463812944382837633732287234;
        points[64] = 0.834867610137777882067313399868964573456980441286444717;
        points[65] = 0.855960860255219376473270846800301137130305982783760224;
        points[66] = 0.875717629303529476659517434981349199742904300491322709;
        points[67] = 0.894107069504235101310429787954331809916631561280057878;
        points[68] = 0.911100468034580800245006188968332780707465070435916019;
        points[69] = 0.926671291880903873664522784006798092582699132120121078;
        points[70] = 0.940795229306577250300016736783687970441728154473759339;
        points[71] = 0.953450227889269135963276154423409342484292435398361296;
        points[72] = 0.964616529114864786107449590864828148569165145984351088;
        points[73] = 0.974276699597807118178834189554494185688998246619540196;
        points[74] = 0.982415659251278930098581377623963704856168267086843999;
        points[75] = 0.989020707687784337874758037557341151749131942235472799;
        points[76] = 0.994081554785542622411154989281750253778397198953813262;
        points[77] = 0.997590394336941435176854179003281946369339048680847122;
        points[78] = 0.999542528479569844324151575956936834036755917636729909;
        weights[0] = 0.00117393012995661302120221447107509423537092512473935466;
        weights[1] = 0.00273090706575485591853339004902126224049268839775511752;
        weights[2] = 0.00428592911312653121821883683228505544774344792073632407;
        weights[3] = 0.00583445986876346558921348615167545283913651763926505765;
        weights[4] = 0.00737392113133017683039118360996146639089899555718186563;
        weights[5] = 0.00890188098265248625373979280548100558212480790353318616;
        weights[6] = 0.0104159462045133825791834693103913526356653127882795744;
        weights[7] = 0.0119137502151169986995998732226717993514472939069096176;
        weights[8] = 0.0133929533448256761973089424655372914169582981233775732;
        weights[9] = 0.0148512455263500693185789509930927691994192230026040931;
        weights[10] = 0.0162863495761916820918372562137234120815802130993978354;
        weights[11] = 0.0176960246243104178646630250667509019003052097074481821;
        weights[12] = 0.0190780695589374885847839693710803110014099800768940624;
        weights[13] = 0.020430326438140859878443379510795629185850111017955803;
        weights[14] = 0.0217506838466080797686419697945810072467302238457528335;
        weights[15] = 0.0230370801857190262769791931930972310876829213523266563;
        weights[16] = 0.0242875068887994926394222753756428831724185226099922615;
        weights[17] = 0.0255000115551287739473395075121561875909525756542420692;
        weights[18] = 0.0266727009971055565378834253756368000278665398559491219;
        weights[19] = 0.027803744195447058944435639832740263276853530023959851;
        weights[20] = 0.0288913751576072667816365241266766508947305565124978217;
        weights[21] = 0.0299338956748383628956487333596106697905824841132115687;
        weights[22] = 0.0309296779735248352882938968193055503146604082156631677;
        weights[23] = 0.0318771672566111703605189632937317454010296156408557967;
        weights[24] = 0.032774884131130817853421503303062889908355528694562468;
        weights[25] = 0.0336214269180309300499226835366750840468166269341614402;
        weights[26] = 0.0344154738406766008825915035919727365859856524504289745;
        weights[27] = 0.0351557850886111311282506986715428737934780854321102099;
        weights[28] = 0.0358412047533457522892069253408778732831231993053742033;
        weights[29] = 0.0364706626331534275292564856465736649122276458032780981;
        weights[30] = 0.0370431759040467841598378556217328534002113424428589387;
        weights[31] = 0.0375578506543297704779069925703500829258590571215817286;
        weights[32] = 0.0380138832803260495455175068056943762873746953251462411;
        weights[33] = 0.0384105617411041774054165937614703207167120561247804561;
        weights[34] = 0.0387472666702399670681853306601330188452642184617409952;
        weights[35] = 0.0390234723428797960265050198093407041718104317453539026;
        weights[36] = 0.0392387474965946435549188629907870602438080201467363144;
        weights[37] = 0.0393927560047430039342642021006702884708122577691127774;
        weights[38] = 0.0394852574012911647537216672689312074151418397911176918;
        weights[39] = 0.0395161072562713117091565391269263453622178807222535301;
        weights[40] = 0.0394852574012911647537216672689312074151418397911176918;
        weights[41] = 0.0393927560047430039342642021006702884708122577691127774;
        weights[42] = 0.0392387474965946435549188629907870602438080201467363144;
        weights[43] = 0.0390234723428797960265050198093407041718104317453539026;
        weights[44] = 0.0387472666702399670681853306601330188452642184617409952;
        weights[45] = 0.0384105617411041774054165937614703207167120561247804561;
        weights[46] = 0.0380138832803260495455175068056943762873746953251462411;
        weights[47] = 0.0375578506543297704779069925703500829258590571215817286;
        weights[48] = 0.0370431759040467841598378556217328534002113424428589387;
        weights[49] = 0.0364706626331534275292564856465736649122276458032780981;
        weights[50] = 0.0358412047533457522892069253408778732831231993053742033;
        weights[51] = 0.0351557850886111311282506986715428737934780854321102099;
        weights[52] = 0.0344154738406766008825915035919727365859856524504289745;
        weights[53] = 0.0336214269180309300499226835366750840468166269341614402;
        weights[54] = 0.032774884131130817853421503303062889908355528694562468;
        weights[55] = 0.0318771672566111703605189632937317454010296156408557967;
        weights[56] = 0.0309296779735248352882938968193055503146604082156631677;
        weights[57] = 0.0299338956748383628956487333596106697905824841132115687;
        weights[58] = 0.0288913751576072667816365241266766508947305565124978217;
        weights[59] = 0.027803744195447058944435639832740263276853530023959851;
        weights[60] = 0.0266727009971055565378834253756368000278665398559491219;
        weights[61] = 0.0255000115551287739473395075121561875909525756542420692;
        weights[62] = 0.0242875068887994926394222753756428831724185226099922615;
        weights[63] = 0.0230370801857190262769791931930972310876829213523266563;
        weights[64] = 0.0217506838466080797686419697945810072467302238457528335;
        weights[65] = 0.020430326438140859878443379510795629185850111017955803;
        weights[66] = 0.0190780695589374885847839693710803110014099800768940624;
        weights[67] = 0.0176960246243104178646630250667509019003052097074481821;
        weights[68] = 0.0162863495761916820918372562137234120815802130993978354;
        weights[69] = 0.0148512455263500693185789509930927691994192230026040931;
        weights[70] = 0.0133929533448256761973089424655372914169582981233775732;
        weights[71] = 0.0119137502151169986995998732226717993514472939069096176;
        weights[72] = 0.0104159462045133825791834693103913526356653127882795744;
        weights[73] = 0.00890188098265248625373979280548100558212480790353318616;
        weights[74] = 0.00737392113133017683039118360996146639089899555718186563;
        weights[75] = 0.00583445986876346558921348615167545283913651763926505765;
        weights[76] = 0.00428592911312653121821883683228505544774344792073632407;
        weights[77] = 0.00273090706575485591853339004902126224049268839775511752;
        weights[78] = 0.00117393012995661302120221447107509423537092512473935466;
        return;
    case 80:
        points[0] = -0.999553822651630629880080499094567184991693557685851818;
        points[1] = -0.997649864398237688899494208183122985331074834396563621;
        points[2] = -0.994227540965688277892063503664911698088808604954712036;
        points[3] = -0.989291302499755531026503167136631385282151777830901615;
        points[4] = -0.982848572738629070418288027709116473568694058814879837;
        points[5] = -0.974909140585727793385645230069136276244959716036304477;
        points[6] = -0.965485089043799251452273155671454998502903485848611304;
        points[7] = -0.954590766343634905493481517021029508783646814704099201;
        points[8] = -0.942242761309872674752266004500001735070833966241979363;
        points[9] = -0.928459877172445795953045959075453133792234988839582012;
        points[10] = -0.913263102571757654164733656150947478111452468310774734;
        points[11] = -0.896675579438770683194324071967395986307299702051986985;
        points[12] = -0.878722567678213828703773343639124407935851776676766267;
        points[13] = -0.859431406663111096977192123491656492839931489614644255;
        points[14] = -0.838831473580255275616623043902867064793623412611807715;
        points[15] = -0.816954138681463470371124994012295707742841200671466249;
        points[16] = -0.793832717504605449948639311738454358610603750752767388;
        points[17] = -0.769502420135041373865616068749026083985405945335283939;
        points[18] = -0.744000297583597272316540527930913673808679084668918215;
        points[19] = -0.717365185362099880254068258293815278566830552925811099;
        points[20] = -0.689637644342027600771207612438935266089722945470212805;
        points[21] = -0.660859898986119801735967122844317234805060118715519195;
        points[22] = -0.631075773046871966247928387289336863089063470073339189;
        points[23] = -0.600330622829751743154746299164006848430055094813786742;
        points[24] = -0.568671268122709784725485786624827158741993573659612861;
        points[25] = -0.536145920897131932019857253125400904911693125079156923;
        points[26] = -0.50280411188878498759367275036756800356494067249959816;
        points[27] = -0.468696615170544477036078364935808657293956006488266802;
        points[28] = -0.433875370831756093062386700363181958302108304345194745;
        points[29] = -0.398393405881969227024379642517533757117249124713572659;
        points[30] = -0.362304753499487315619043286358963588017109625123613372;
        points[31] = -0.325664370747701914619112943627358695036984755109080397;
        points[32] = -0.288528054884511853109139301434713898496405289013765936;
        points[33] = -0.250952358392272120493158816035004797363048927563799213;
        points[34] = -0.212994502857666132572388538666321823094788750834773702;
        points[35] = -0.17471229183264681255933904801128619571881077497706258;
        points[36] = -0.136164022809143886559241078000717067933136249634883111;
        points[37] = -0.0974083984415845990632784501049369020170661844367660926;
        points[38] = -0.0585044371524206686289933218834177944253986747019143982;
        points[39] = -0.0195113832567939976543512341074545479335513016469978151;
        points[40] = 0.0195113832567939976543512341074545479335513016469978151;
        points[41] = 0.0585044371524206686289933218834177944253986747019143982;
        points[42] = 0.0974083984415845990632784501049369020170661844367660926;
        points[43] = 0.136164022809143886559241078000717067933136249634883111;
        points[44] = 0.17471229183264681255933904801128619571881077497706258;
        points[45] = 0.212994502857666132572388538666321823094788750834773702;
        points[46] = 0.250952358392272120493158816035004797363048927563799213;
        points[47] = 0.288528054884511853109139301434713898496405289013765936;
        points[48] = 0.325664370747701914619112943627358695036984755109080397;
        points[49] = 0.362304753499487315619043286358963588017109625123613372;
        points[50] = 0.398393405881969227024379642517533757117249124713572659;
        points[51] = 0.433875370831756093062386700363181958302108304345194745;
        points[52] = 0.468696615170544477036078364935808657293956006488266802;
        points[53] = 0.50280411188878498759367275036756800356494067249959816;
        points[54] = 0.536145920897131932019857253125400904911693125079156923;
        points[55] = 0.568671268122709784725485786624827158741993573659612861;
        points[56] = 0.600330622829751743154746299164006848430055094813786742;
        points[57] = 0.631075773046871966247928387289336863089063470073339189;
        points[58] = 0.660859898986119801735967122844317234805060118715519195;
        points[59] = 0.689637644342027600771207612438935266089722945470212805;
        points[60] = 0.717365185362099880254068258293815278566830552925811099;
        points[61] = 0.744000297583597272316540527930913673808679084668918215;
        points[62] = 0.769502420135041373865616068749026083985405945335283939;
        points[63] = 0.793832717504605449948639311738454358610603750752767388;
        points[64] = 0.816954138681463470371124994012295707742841200671466249;
        points[65] = 0.838831473580255275616623043902867064793623412611807715;
        points[66] = 0.859431406663111096977192123491656492839931489614644255;
        points[67] = 0.878722567678213828703773343639124407935851776676766267;
        points[68] = 0.896675579438770683194324071967395986307299702051986985;
        points[69] = 0.913263102571757654164733656150947478111452468310774734;
        points[70] = 0.928459877172445795953045959075453133792234988839582012;
        points[71] = 0.942242761309872674752266004500001735070833966241979363;
        points[72] = 0.954590766343634905493481517021029508783646814704099201;
        points[73] = 0.965485089043799251452273155671454998502903485848611304;
        points[74] = 0.974909140585727793385645230069136276244959716036304477;
        points[75] = 0.982848572738629070418288027709116473568694058814879837;
        points[76] = 0.989291302499755531026503167136631385282151777830901615;
        points[77] = 0.994227540965688277892063503664911698088808604954712036;
        points[78] = 0.997649864398237688899494208183122985331074834396563621;
        points[79] = 0.999553822651630629880080499094567184991693557685851818;
        weights[0] = 0.00114495000318694153454417194131563611869939240557590287;
        weights[1] = 0.00266353358951268166929353583166845546574455424238714856;
        weights[2] = 0.00418031312469489523673930420168135132354949737310643952;
        weights[3] = 0.00569092245140319864926910711716201847692526383467713252;
        weights[4] = 0.00719290476811731275267557086795650747650703819236530004;
        weights[5] = 0.00868394526926085842640945220403428135240604295506540971;
        weights[6] = 0.0101617660411030645208318503524069436640457818796405253;
        weights[7] = 0.011624114120797826916466769995432634859513181502962133;
        weights[8] = 0.0130687615924013392937868258970563403104186343824144335;
        weights[9] = 0.0144935080405090761169620745834605500559568721551155131;
        weights[10] = 0.0158961835837256880449029092291785257709720926057219327;
        weights[11] = 0.017274652056269306358584207131290999800311029304010341;
        weights[12] = 0.0186268142082990314287354141521572090084477663361644235;
        weights[13] = 0.0199506108781419989288919287151135633605010642850159307;
        weights[14] = 0.0212440261157820063887107372506131285464689242433079805;
        weights[15] = 0.022505090246332461926221589686168739020579588371837063;
        weights[16] = 0.0237318828659301012931925246135684162923425291083218958;
        weights[17] = 0.0249225357641154911051178470032198023571024898755616955;
        weights[18] = 0.02607523576756511790296874360026928712569747582923931;
        weights[19] = 0.0271882275004863806744187066805442598298771757001070704;
        weights[20] = 0.0282598160572768623967531979650145302942654983731397918;
        weights[21] = 0.0292883695832678476927675860195791396612074311446307952;
        weights[22] = 0.0302723217595579806612200100909011747473420675596892781;
        weights[23] = 0.031210174188114701642442866720603551865999720820282766;
        weights[24] = 0.0321004986734877731480564902872506960895167638325936498;
        weights[25] = 0.0329419393976454013828361809019595361280270376927286177;
        weights[26] = 0.0337332149846115228166751630642387284458265038481667028;
        weights[27] = 0.0344731204517539287943642267310298320767807967429529799;
        weights[28] = 0.0351605290447475934955265923886968812291624523105134985;
        weights[29] = 0.0357943939534160546028615888161544542402361352305752708;
        weights[30] = 0.0363737499058359780439649910465228136600628217876101719;
        weights[31] = 0.0368977146382760088391509965734052192685681011318286258;
        weights[32] = 0.0373654902387304900267053770578386691648069079494273797;
        weights[33] = 0.0377763643620013974897749764263210547707019240195695148;
        weights[34] = 0.0381297113144776383442067915657362019141439239065590341;
        weights[35] = 0.0384249930069594231852124363294901384310218762709102464;
        weights[36] = 0.03866175977407646332707711026715669126090092783986442;
        weights[37] = 0.0388396510590519689317741826687871658908802293404858543;
        weights[38] = 0.0389583959627695311986255247722608223149320115862695616;
        weights[39] = 0.0390178136563066548112804392527540483295504740296042598;
        weights[40] = 0.0390178136563066548112804392527540483295504740296042598;
        weights[41] = 0.0389583959627695311986255247722608223149320115862695616;
        weights[42] = 0.0388396510590519689317741826687871658908802293404858543;
        weights[43] = 0.03866175977407646332707711026715669126090092783986442;
        weights[44] = 0.0384249930069594231852124363294901384310218762709102464;
        weights[45] = 0.0381297113144776383442067915657362019141439239065590341;
        weights[46] = 0.0377763643620013974897749764263210547707019240195695148;
        weights[47] = 0.0373654902387304900267053770578386691648069079494273797;
        weights[48] = 0.0368977146382760088391509965734052192685681011318286258;
        weights[49] = 0.0363737499058359780439649910465228136600628217876101719;
        weights[50] = 0.0357943939534160546028615888161544542402361352305752708;
        weights[51] = 0.0351605290447475934955265923886968812291624523105134985;
        weights[52] = 0.0344731204517539287943642267310298320767807967429529799;
        weights[53] = 0.0337332149846115228166751630642387284458265038481667028;
        weights[54] = 0.0329419393976454013828361809019595361280270376927286177;
        weights[55] = 0.0321004986734877731480564902872506960895167638325936498;
        weights[56] = 0.031210174188114701642442866720603551865999720820282766;
        weights[57] = 0.0302723217595579806612200100909011747473420675596892781;
        weights[58] = 0.0292883695832678476927675860195791396612074311446307952;
        weights[59] = 0.0282598160572768623967531979650145302942654983731397918;
        weights[60] = 0.0271882275004863806744187066805442598298771757001070704;
        weights[61] = 0.02607523576756511790296874360026928712569747582923931;
        weights[62] = 0.0249225357641154911051178470032198023571024898755616955;
        weights[63] = 0.0237318828659301012931925246135684162923425291083218958;
        weights[64] = 0.022505090246332461926221589686168739020579588371837063;
        weights[65] = 0.0212440261157820063887107372506131285464689242433079805;
        weights[66] = 0.0199506108781419989288919287151135633605010642850159307;
        weights[67] = 0.0186268142082990314287354141521572090084477663361644235;
        weights[68] = 0.017274652056269306358584207131290999800311029304010341;
        weights[69] = 0.0158961835837256880449029092291785257709720926057219327;
        weights[70] = 0.0144935080405090761169620745834605500559568721551155131;
        weights[71] = 0.0130687615924013392937868258970563403104186343824144335;
        weights[72] = 0.011624114120797826916466769995432634859513181502962133;
        weights[73] = 0.0101617660411030645208318503524069436640457818796405253;
        weights[74] = 0.00868394526926085842640945220403428135240604295506540971;
        weights[75] = 0.00719290476811731275267557086795650747650703819236530004;
        weights[76] = 0.00569092245140319864926910711716201847692526383467713252;
        weights[77] = 0.00418031312469489523673930420168135132354949737310643952;
        weights[78] = 0.00266353358951268166929353583166845546574455424238714856;
        weights[79] = 0.00114495000318694153454417194131563611869939240557590287;
        return;
    case 81:
        points[0] = -0.999564703690319034476721091515535435906809487341047639;
        points[1] = -0.997707159988346463657951071070441547323714007946537966;
        points[2] = -0.994368193285219865022676840380476999300702369451743616;
        points[3] = -0.989552021371021999127889387244924439307630825129068852;
        points[4] = -0.983265708566430227219940909949400189273013925622064671;
        points[5] = -0.975518572672361296916253860825913501012896647223709172;
        points[6] = -0.966322116338056111070092156099435864662616559035229799;
        points[7] = -0.955689999756402515248837068806144149503846608832495781;
        points[8] = -0.943638017652813821180581535384817876975760018684290633;
        points[9] = -0.930184074915167503022545555195016011594110610288171472;
        points[10] = -0.915348159640750717289077682140752603206251815698637666;
        points[11] = -0.899152313286156530852665968224606386618062594254364884;
        points[12] = -0.881620597846720146168274251560532501516329842739645212;
        points[13] = -0.862779060069791894673747431885790825375192931346375724;
        points[14] = -0.842655692736467046206712622806980335288174244659569521;
        points[15] = -0.821280393060910223458767880433111904294988540768440943;
        points[16] = -0.798684918265028282157201455006824055637235472391435949;
        points[17] = -0.774902838392423431405637521084296314516255881420080916;
        points[18] = -0.749969486430620672222514710983212076507915912551040417;
        points[19] = -0.723921905815052614443363963353679813824770666426490347;
        points[20] = -0.696798795392435609681860494729900082278403343372081199;
        points[21] = -0.668640451925090146604899187318929071790302326992537951;
        points[22] = -0.639488710221494554644762007346320645292096179116699607;
        points[23] = -0.609386880981936546058807831697927227469022624116158535;
        points[24] = -0.578379686451551369482078004759956143951079532489398932;
        points[25] = -0.546513193976311273079586333584734953547139879208357337;
        points[26] = -0.513834747560658215522019758498313659415507782003072847;
        points[27] = -0.480392897528448270142662953367969139126263064545441426;
        points[28] = -0.44623732839169905664810302407759449646228106531484679;
        points[29] = -0.411418785034297541686005843022743690701333595053682233;
        points[30] = -0.375988997320331287920516854427329096309614148269496885;
        points[31] = -0.340000603239048339775819437980234867461281512067087402;
        points[32] = -0.303507070700626164551631676357385405292400591400347064;
        points[33] = -0.266562618098935339145502371830308011827037544631206046;
        points[34] = -0.22922213375931610544150731019064231393419972453895992;
        points[35] = -0.191541094391042855739847066208335466946811475231837256;
        points[36] = -0.153575482665630636856788120955432231934526335821132927;
        points[37] = -0.115381704043436711258853860425119554597145362558454076;
        points[38] = -0.0770165029721271773182907027659999792737625360030149001;
        points[39] = -0.0385368785815119838364856354686574582011258909648031356;
        points[40] = 0;
        points[41] = 0.0385368785815119838364856354686574582011258909648031356;
        points[42] = 0.0770165029721271773182907027659999792737625360030149001;
        points[43] = 0.115381704043436711258853860425119554597145362558454076;
        points[44] = 0.153575482665630636856788120955432231934526335821132927;
        points[45] = 0.191541094391042855739847066208335466946811475231837256;
        points[46] = 0.22922213375931610544150731019064231393419972453895992;
        points[47] = 0.266562618098935339145502371830308011827037544631206046;
        points[48] = 0.303507070700626164551631676357385405292400591400347064;
        points[49] = 0.340000603239048339775819437980234867461281512067087402;
        points[50] = 0.375988997320331287920516854427329096309614148269496885;
        points[51] = 0.411418785034297541686005843022743690701333595053682233;
        points[52] = 0.44623732839169905664810302407759449646228106531484679;
        points[53] = 0.480392897528448270142662953367969139126263064545441426;
        points[54] = 0.513834747560658215522019758498313659415507782003072847;
        points[55] = 0.546513193976311273079586333584734953547139879208357337;
        points[56] = 0.578379686451551369482078004759956143951079532489398932;
        points[57] = 0.609386880981936546058807831697927227469022624116158535;
        points[58] = 0.639488710221494554644762007346320645292096179116699607;
        points[59] = 0.668640451925090146604899187318929071790302326992537951;
        points[60] = 0.696798795392435609681860494729900082278403343372081199;
        points[61] = 0.723921905815052614443363963353679813824770666426490347;
        points[62] = 0.749969486430620672222514710983212076507915912551040417;
        points[63] = 0.774902838392423431405637521084296314516255881420080916;
        points[64] = 0.798684918265028282157201455006824055637235472391435949;
        points[65] = 0.821280393060910223458767880433111904294988540768440943;
        points[66] = 0.842655692736467046206712622806980335288174244659569521;
        points[67] = 0.862779060069791894673747431885790825375192931346375724;
        points[68] = 0.881620597846720146168274251560532501516329842739645212;
        points[69] = 0.899152313286156530852665968224606386618062594254364884;
        points[70] = 0.915348159640750717289077682140752603206251815698637666;
        points[71] = 0.930184074915167503022545555195016011594110610288171472;
        points[72] = 0.943638017652813821180581535384817876975760018684290633;
        points[73] = 0.955689999756402515248837068806144149503846608832495781;
        points[74] = 0.966322116338056111070092156099435864662616559035229799;
        points[75] = 0.975518572672361296916253860825913501012896647223709172;
        points[76] = 0.983265708566430227219940909949400189273013925622064671;
        points[77] = 0.989552021371021999127889387244924439307630825129068852;
        points[78] = 0.994368193285219865022676840380476999300702369451743616;
        points[79] = 0.997707159988346463657951071070441547323714007946537966;
        points[80] = 0.999564703690319034476721091515535435906809487341047639;
        weights[0] = 0.00111702984712460660612065036565924661277346117148546778;
        weights[1] = 0.00259862229992895301349678822710502382127206287916916087;
        weights[2] = 0.00407855111342139558602073408255658694639029285561149449;
        weights[3] = 0.00555261137025627890227263264978142968814156148990650494;
        weights[4] = 0.00701846048493162551160995182421636399937929587221684003;
        weights[5] = 0.00847389378534556544961582801983908950629627219676663299;
        weights[6] = 0.00991674180959587549974989978930914631239832053226077366;
        weights[7] = 0.0113448584954162557620081724575723866290670811973653643;
        weights[8] = 0.0127561211151344210002561264439770134132431819893115059;
        weights[9] = 0.0141484325132360655482515810206792450646144543576293841;
        weights[10] = 0.0155197239124643629382452393441641297348514640248627908;
        weights[11] = 0.0168679578676351394743345408515924812603457590462946181;
        weights[12] = 0.0181911312412557611517626738568933111917060664825684925;
        weights[13] = 0.0194872781556019182159270505176313161934169584056890917;
        weights[14] = 0.0207544729014456085395227442379722414266808017331259969;
        weights[15] = 0.0219908327927516327705012584359096579274820364239272546;
        weights[16] = 0.0231945209602739198814553284674548293639897001704604225;
        weights[17] = 0.0243637490785630973324910546010028160546258099716937061;
        weights[18] = 0.0254967800216656770694797790606086925229293132147612182;
        weights[19] = 0.0265919304432199210909197947350353730561755398158166456;
        weights[20] = 0.0276475732769249269110861468401125768900981023044430538;
        weights[21] = 0.0286621401535606762257917554483884258522341481227546832;
        weights[22] = 0.0296341237309055976584751926459669644799646954186307159;
        weights[23] = 0.030562079933052661895659840852220882925637900532890868;
        weights[24] = 0.0314446300957740664180365391442906295579680334808333133;
        weights[25] = 0.0322804630147326888724032321453390107452744491593759189;
        weights[26] = 0.0330683368934880044208752063918929383398132188916206058;
        weights[27] = 0.0338070811883962455511958134966326393653025155120706502;
        weights[28] = 0.0344955983476597958947455286759356464970576308291429702;
        weights[29] = 0.0351328654419393794159790921637166475793452866304013606;
        weights[30] = 0.0357179356841045685307260259993708262320494735396887782;
        weights[31] = 0.0362499398358634127983257816904139987244926244191002959;
        weights[32] = 0.0367280874991804395169059661921141078827515972072972109;
        weights[33] = 0.037151668290563712144742601639887194383082724661897212;
        weights[34] = 0.037520052896475837859239244608524097939402224625258203;
        weights[35] = 0.037832694008300559247575139629384128913399464585015909;
        weights[36] = 0.0380891271354756018310233544370387129983414097469820661;
        weights[37] = 0.0382889712955835244303199893422642638017098557226789661;
        weights[38] = 0.0384319295803751721002565680035270083260507567860555933;
        weights[39] = 0.0385177895968846952378381138334802339263445578930737118;
        weights[40] = 0.038546423782980703389514075661077367827799792199729095;
        weights[41] = 0.0385177895968846952378381138334802339263445578930737118;
        weights[42] = 0.0384319295803751721002565680035270083260507567860555933;
        weights[43] = 0.0382889712955835244303199893422642638017098557226789661;
        weights[44] = 0.0380891271354756018310233544370387129983414097469820661;
        weights[45] = 0.037832694008300559247575139629384128913399464585015909;
        weights[46] = 0.037520052896475837859239244608524097939402224625258203;
        weights[47] = 0.037151668290563712144742601639887194383082724661897212;
        weights[48] = 0.0367280874991804395169059661921141078827515972072972109;
        weights[49] = 0.0362499398358634127983257816904139987244926244191002959;
        weights[50] = 0.0357179356841045685307260259993708262320494735396887782;
        weights[51] = 0.0351328654419393794159790921637166475793452866304013606;
        weights[52] = 0.0344955983476597958947455286759356464970576308291429702;
        weights[53] = 0.0338070811883962455511958134966326393653025155120706502;
        weights[54] = 0.0330683368934880044208752063918929383398132188916206058;
        weights[55] = 0.0322804630147326888724032321453390107452744491593759189;
        weights[56] = 0.0314446300957740664180365391442906295579680334808333133;
        weights[57] = 0.030562079933052661895659840852220882925637900532890868;
        weights[58] = 0.0296341237309055976584751926459669644799646954186307159;
        weights[59] = 0.0286621401535606762257917554483884258522341481227546832;
        weights[60] = 0.0276475732769249269110861468401125768900981023044430538;
        weights[61] = 0.0265919304432199210909197947350353730561755398158166456;
        weights[62] = 0.0254967800216656770694797790606086925229293132147612182;
        weights[63] = 0.0243637490785630973324910546010028160546258099716937061;
        weights[64] = 0.0231945209602739198814553284674548293639897001704604225;
        weights[65] = 0.0219908327927516327705012584359096579274820364239272546;
        weights[66] = 0.0207544729014456085395227442379722414266808017331259969;
        weights[67] = 0.0194872781556019182159270505176313161934169584056890917;
        weights[68] = 0.0181911312412557611517626738568933111917060664825684925;
        weights[69] = 0.0168679578676351394743345408515924812603457590462946181;
        weights[70] = 0.0155197239124643629382452393441641297348514640248627908;
        weights[71] = 0.0141484325132360655482515810206792450646144543576293841;
        weights[72] = 0.0127561211151344210002561264439770134132431819893115059;
        weights[73] = 0.0113448584954162557620081724575723866290670811973653643;
        weights[74] = 0.00991674180959587549974989978930914631239832053226077366;
        weights[75] = 0.00847389378534556544961582801983908950629627219676663299;
        weights[76] = 0.00701846048493162551160995182421636399937929587221684003;
        weights[77] = 0.00555261137025627890227263264978142968814156148990650494;
        weights[78] = 0.00407855111342139558602073408255658694639029285561149449;
        weights[79] = 0.00259862229992895301349678822710502382127206287916916087;
        weights[80] = 0.00111702984712460660612065036565924661277346117148546778;
        return;
    case 82:
        points[0] = -0.999575191501652648874129190535250983081036917180863075;
        points[1] = -0.997762385826385862562358385261417436158255218260849557;
        points[2] = -0.994503768378075628933999775236189465548919152051720587;
        points[3] = -0.9898033388399089499326253172613966089831221609253427;
        points[4] = -0.983667823522007603367888126857244084632201940875534028;
        points[5] = -0.976106097094498828691419767706641542435876033222663777;
        points[6] = -0.967129116252590695996077016681601361301045413297920187;
        points[7] = -0.956749893861610903121799342559577593134969059889408672;
        points[8] = -0.94498347743896048918224602423769275407867390681610543;
        points[9] = -0.931846926454622887854732617574546540652602803899020953;
        points[10] = -0.917359287253280107145761532891843054333368659400557254;
        points[11] = -0.901541565288841258196285005254220258174350845790466371;
        points[12] = -0.884416694596724708227990769085559450923404496457881727;
        points[13] = -0.866009504504765448570684263936116102924951529739427422;
        points[14] = -0.846346683612913701795724335260217893648779664703654294;
        points[15] = -0.825456741085767656028634708875290845534322323109333033;
        points[16] = -0.803369965310108299301882499083462610146539058901299312;
        points[17] = -0.78011837997535824519396673977377651492085185749014316;
        points[18] = -0.755735697639560417297554091220176020628958396553935311;
        points[19] = -0.730257270847596245051693216510415022757991657556966699;
        points[20] = -0.703720040872166678493835628241671930285879698505571518;
        points[21] = -0.676162484151647024565951099540441684045041441445168432;
        points[22] = -0.647624556502346598566311503860792983351082151595061449;
        points[23] = -0.618147635185978682041029999171234429638306980066577944;
        points[24] = -0.587774458916284867153708870468212888749931601553475884;
        points[25] = -0.556549065891763812347321756307151500225031924768716005;
        points[26] = -0.524516729944327767975079464797700034811808078358591021;
        points[27] = -0.491723894896449322463459073148951621528374511194625637;
        points[28] = -0.458218107221963197822863222485324759427228564480061718;
        points[29] = -0.424047947108150722163559277339453409284458297365458224;
        points[30] = -0.389262958019054815921047162555583505642759160337430115;
        points[31] = -0.353913574862147936405394677524792984304512384433421198;
        points[32] = -0.318051050862501505010084338651141180693424202659832777;
        points[33] = -0.281727383250480102368264058032958678714394769166101613;
        points[34] = -0.244995237870704537839176528028221352895894221380402185;
        points[35] = -0.207907872821592350966229177877640381456459914311565017;
        points[36] = -0.170519061236190159767099366920433413716264081537019473;
        points[37] = -0.132883013316257525764813562136429148521714149822781589;
        points[38] = -0.0950542977326448739528867409203856737102453877522802818;
        points[39] = -0.0570877625059269319029596792206648517273489687828694076;
        points[40] = -0.0190384554820068137614546786131953746877775557327497191;
        points[41] = 0.0190384554820068137614546786131953746877775557327497191;
        points[42] = 0.0570877625059269319029596792206648517273489687828694076;
        points[43] = 0.0950542977326448739528867409203856737102453877522802818;
        points[44] = 0.132883013316257525764813562136429148521714149822781589;
        points[45] = 0.170519061236190159767099366920433413716264081537019473;
        points[46] = 0.207907872821592350966229177877640381456459914311565017;
        points[47] = 0.244995237870704537839176528028221352895894221380402185;
        points[48] = 0.281727383250480102368264058032958678714394769166101613;
        points[49] = 0.318051050862501505010084338651141180693424202659832777;
        points[50] = 0.353913574862147936405394677524792984304512384433421198;
        points[51] = 0.389262958019054815921047162555583505642759160337430115;
        points[52] = 0.424047947108150722163559277339453409284458297365458224;
        points[53] = 0.458218107221963197822863222485324759427228564480061718;
        points[54] = 0.491723894896449322463459073148951621528374511194625637;
        points[55] = 0.524516729944327767975079464797700034811808078358591021;
        points[56] = 0.556549065891763812347321756307151500225031924768716005;
        points[57] = 0.587774458916284867153708870468212888749931601553475884;
        points[58] = 0.618147635185978682041029999171234429638306980066577944;
        points[59] = 0.647624556502346598566311503860792983351082151595061449;
        points[60] = 0.676162484151647024565951099540441684045041441445168432;
        points[61] = 0.703720040872166678493835628241671930285879698505571518;
        points[62] = 0.730257270847596245051693216510415022757991657556966699;
        points[63] = 0.755735697639560417297554091220176020628958396553935311;
        points[64] = 0.78011837997535824519396673977377651492085185749014316;
        points[65] = 0.803369965310108299301882499083462610146539058901299312;
        points[66] = 0.825456741085767656028634708875290845534322323109333033;
        points[67] = 0.846346683612913701795724335260217893648779664703654294;
        points[68] = 0.866009504504765448570684263936116102924951529739427422;
        points[69] = 0.884416694596724708227990769085559450923404496457881727;
        points[70] = 0.901541565288841258196285005254220258174350845790466371;
        points[71] = 0.917359287253280107145761532891843054333368659400557254;
        points[72] = 0.931846926454622887854732617574546540652602803899020953;
        points[73] = 0.94498347743896048918224602423769275407867390681610543;
        points[74] = 0.956749893861610903121799342559577593134969059889408672;
        points[75] = 0.967129116252590695996077016681601361301045413297920187;
        points[76] = 0.976106097094498828691419767706641542435876033222663777;
        points[77] = 0.983667823522007603367888126857244084632201940875534028;
        points[78] = 0.9898033388399089499326253172613966089831221609253427;
        points[79] = 0.994503768378075628933999775236189465548919152051720587;
        points[80] = 0.997762385826385862562358385261417436158255218260849557;
        points[81] = 0.999575191501652648874129190535250983081036917180863075;
        weights[0] = 0.0010901185952758308661071915382399943192336068879330838;
        weights[1] = 0.00253605469685610610982175385098102812203389999933228317;
        weights[2] = 0.00398045793785607461902884673413414375141661773412442932;
        weights[3] = 0.0054192762324467650907045797337047345896059908872982594;
        weights[4] = 0.00685027453418352618432626451004709674231340277993038106;
        weights[5] = 0.00827135181838368560443038270665605143203198286512771221;
        weights[6] = 0.00968044070437107373696549431410863256593982767663205241;
        weights[7] = 0.0110754957817598963202250549646583254314081016302030152;
        weights[8] = 0.0124544934011421046797336165010059687610817304951596731;
        weights[9] = 0.0138154337141264593877276836865589227729547654500005344;
        weights[10] = 0.0151563432707625617884689528120764324610473584376475674;
        weights[11] = 0.0164752777639837088910122366082057038079616306747691303;
        weights[12] = 0.0177703247984984071469819681257935127863830610600643164;
        weights[13] = 0.0190396066401789250730393645914118791617888847439611518;
        weights[14] = 0.0202812829269121589015706796706799725547575206633584162;
        weights[15] = 0.021493553330774844043489663808120621554271080822857706;
        weights[16] = 0.0226746601649141031024419830178022352344910812409552531;
        weights[17] = 0.0238228909300478263422270849747114695614948273049929426;
        weights[18] = 0.024936580796240755155772228285557895790896723954245384;
        weights[19] = 0.0260141150160170237538685231099498223310720673895295577;
        weights[20] = 0.0270539312651247715197867966623128210646580138543035256;
        weights[21] = 0.0280545219074542304717139753327372167831395899050286291;
        weights[22] = 0.0290144361807644039614530300613370847175292553805220391;
        weights[23] = 0.0299322823000127246350859619826187512902048713075355169;
        weights[24] = 0.030806729475215629813667882788313931059472167720342803;
        weights[25] = 0.0316365098409002455376233243220748522877292071071711551;
        weights[26] = 0.0324204202943406050778364078264249687298695060308868303;
        weights[27] = 0.0331573242399072113277583844033247814787709504668201628;
        weights[28] = 0.0338461532369968587446365621322667183636043624173830744;
        weights[29] = 0.0344859085491507055073788069655919769659472697458593311;
        weights[30] = 0.0350756625921126903847803057747133558315780668107624887;
        weights[31] = 0.0356145602787274726804959152594490211974036692669733913;
        weights[32] = 0.0361018202587270230756955225213376756703200135783449958;
        weights[33] = 0.0365367360516076528421977328252687511401480881133258473;
        weights[34] = 0.0369186770709544569985316728321329461793810273865084787;
        weights[35] = 0.0372470895387276641878400360702367115600056836726997633;
        weights[36] = 0.0375214972881850208715740719807007412142276558075945697;
        weights[37] = 0.0377415024542758696715370386310274864968513629397145196;
        weights[38] = 0.0379067860505057847794642260219639305618309762176857077;
        weights[39] = 0.0380171084314352699053027742360904481048756814057811028;
        weights[40] = 0.0380723096401418712076960178256713855702684181666332183;
        weights[41] = 0.0380723096401418712076960178256713855702684181666332183;
        weights[42] = 0.0380171084314352699053027742360904481048756814057811028;
        weights[43] = 0.0379067860505057847794642260219639305618309762176857077;
        weights[44] = 0.0377415024542758696715370386310274864968513629397145196;
        weights[45] = 0.0375214972881850208715740719807007412142276558075945697;
        weights[46] = 0.0372470895387276641878400360702367115600056836726997633;
        weights[47] = 0.0369186770709544569985316728321329461793810273865084787;
        weights[48] = 0.0365367360516076528421977328252687511401480881133258473;
        weights[49] = 0.0361018202587270230756955225213376756703200135783449958;
        weights[50] = 0.0356145602787274726804959152594490211974036692669733913;
        weights[51] = 0.0350756625921126903847803057747133558315780668107624887;
        weights[52] = 0.0344859085491507055073788069655919769659472697458593311;
        weights[53] = 0.0338461532369968587446365621322667183636043624173830744;
        weights[54] = 0.0331573242399072113277583844033247814787709504668201628;
        weights[55] = 0.0324204202943406050778364078264249687298695060308868303;
        weights[56] = 0.0316365098409002455376233243220748522877292071071711551;
        weights[57] = 0.030806729475215629813667882788313931059472167720342803;
        weights[58] = 0.0299322823000127246350859619826187512902048713075355169;
        weights[59] = 0.0290144361807644039614530300613370847175292553805220391;
        weights[60] = 0.0280545219074542304717139753327372167831395899050286291;
        weights[61] = 0.0270539312651247715197867966623128210646580138543035256;
        weights[62] = 0.0260141150160170237538685231099498223310720673895295577;
        weights[63] = 0.024936580796240755155772228285557895790896723954245384;
        weights[64] = 0.0238228909300478263422270849747114695614948273049929426;
        weights[65] = 0.0226746601649141031024419830178022352344910812409552531;
        weights[66] = 0.021493553330774844043489663808120621554271080822857706;
        weights[67] = 0.0202812829269121589015706796706799725547575206633584162;
        weights[68] = 0.0190396066401789250730393645914118791617888847439611518;
        weights[69] = 0.0177703247984984071469819681257935127863830610600643164;
        weights[70] = 0.0164752777639837088910122366082057038079616306747691303;
        weights[71] = 0.0151563432707625617884689528120764324610473584376475674;
        weights[72] = 0.0138154337141264593877276836865589227729547654500005344;
        weights[73] = 0.0124544934011421046797336165010059687610817304951596731;
        weights[74] = 0.0110754957817598963202250549646583254314081016302030152;
        weights[75] = 0.00968044070437107373696549431410863256593982767663205241;
        weights[76] = 0.00827135181838368560443038270665605143203198286512771221;
        weights[77] = 0.00685027453418352618432626451004709674231340277993038106;
        weights[78] = 0.0054192762324467650907045797337047345896059908872982594;
        weights[79] = 0.00398045793785607461902884673413414375141661773412442932;
        weights[80] = 0.00253605469685610610982175385098102812203389999933228317;
        weights[81] = 0.0010901185952758308661071915382399943192336068879330838;
        return;
    case 83:
        points[0] = -0.999585304807049343812604479811704835944572799856613551;
        points[1] = -0.997815640403429961756266273637745524427507816254882029;
        points[2] = -0.994634507631780323407966478826055559037071023433838435;
        points[3] = -0.990045701297265222772328057225512439088831027390690426;
        points[4] = -0.984055629596681471537066851699230729588099873062654272;
        points[5] = -0.976672750072842934232187870211190741212806053965758312;
        points[6] = -0.967907505450128729547014851893800133768508785146304657;
        points[7] = -0.957772299122767105961511740153088049085772463550661347;
        points[8] = -0.946281475011790874442295256371980327303829346330153813;
        points[9] = -0.933451296401838619235679773572839778659517293133588729;
        points[10] = -0.919299922587207943780996219175625575382509739615071748;
        points[11] = -0.903847383022899508081720680359423051782922927439914211;
        points[12] = -0.887115548905063340740519411797588216942025725382058274;
        points[13] = -0.869128102178716983499116049039934332225791105632660958;
        points[14] = -0.849910501998933797338429363277848299021815929626533652;
        points[15] = -0.82948994868498427640175541617147063642982128307057604;
        points[16] = -0.807895345214589632297864886204047175629929995243333385;
        points[17] = -0.78515725631081584028763616360196948140392629842054754;
        points[18] = -0.761307865178458740719255283826584159577784712548478551;
        points[19] = -0.736380927950564267407382317424284003406334799195314593;
        points[20] = -0.71041172590921746448045764914599886458731785587893038;
        points[21] = -0.683437015548021780255840789565324548063012486648464173;
        points[22] = -0.655494976546823717483086336568517471216227211222936227;
        points[23] = -0.626625157732239358494922932206761611950185051157995772;
        points[24] = -0.5968684211004183123918305767892608876953604863249077;
        points[25] = -0.566266883981240803007683851598942951931953028852008197;
        points[26] = -0.534863859425785310580242847526897575482966881018213523;
        points[27] = -0.502703794901426132021111193520837839441864976929869634;
        points[28] = -0.469832209381320328717450207074953698112667649907262862;
        points[29] = -0.436295628917319275485497472310187925631329192834245564;
        points[30] = -0.402141520787488735564028835804112841975765684033220595;
        points[31] = -0.367418226311440367401592804394160884390333773690930974;
        points[32] = -0.332174892428564182315161995735882718825207201588248066;
        points[33] = -0.296461402136003191110713260687941943504475685970901897;
        points[34] = -0.260328303884825917912495782485382383856082793553216594;
        points[35] = -0.223826740034327399193191872608188168693787522148502246;
        points[36] = -0.187008374465722680789553368793413314351081704243831874;
        points[37] = -0.149925319457686817796109061778142702420939086258807232;
        points[38] = -0.112630061927240307807978465143760507617552744792702955;
        points[39] = -0.0751753891403772823268138564887436404969647277075448179;
        points[40] = -0.0376143139975843826675787046693321052168803287691042025;
        points[41] = 0;
        points[42] = 0.0376143139975843826675787046693321052168803287691042025;
        points[43] = 0.0751753891403772823268138564887436404969647277075448179;
        points[44] = 0.112630061927240307807978465143760507617552744792702955;
        points[45] = 0.149925319457686817796109061778142702420939086258807232;
        points[46] = 0.187008374465722680789553368793413314351081704243831874;
        points[47] = 0.223826740034327399193191872608188168693787522148502246;
        points[48] = 0.260328303884825917912495782485382383856082793553216594;
        points[49] = 0.296461402136003191110713260687941943504475685970901897;
        points[50] = 0.332174892428564182315161995735882718825207201588248066;
        points[51] = 0.367418226311440367401592804394160884390333773690930974;
        points[52] = 0.402141520787488735564028835804112841975765684033220595;
        points[53] = 0.436295628917319275485497472310187925631329192834245564;
        points[54] = 0.469832209381320328717450207074953698112667649907262862;
        points[55] = 0.502703794901426132021111193520837839441864976929869634;
        points[56] = 0.534863859425785310580242847526897575482966881018213523;
        points[57] = 0.566266883981240803007683851598942951931953028852008197;
        points[58] = 0.5968684211004183123918305767892608876953604863249077;
        points[59] = 0.626625157732239358494922932206761611950185051157995772;
        points[60] = 0.655494976546823717483086336568517471216227211222936227;
        points[61] = 0.683437015548021780255840789565324548063012486648464173;
        points[62] = 0.71041172590921746448045764914599886458731785587893038;
        points[63] = 0.736380927950564267407382317424284003406334799195314593;
        points[64] = 0.761307865178458740719255283826584159577784712548478551;
        points[65] = 0.78515725631081584028763616360196948140392629842054754;
        points[66] = 0.807895345214589632297864886204047175629929995243333385;
        points[67] = 0.82948994868498427640175541617147063642982128307057604;
        points[68] = 0.849910501998933797338429363277848299021815929626533652;
        points[69] = 0.869128102178716983499116049039934332225791105632660958;
        points[70] = 0.887115548905063340740519411797588216942025725382058274;
        points[71] = 0.903847383022899508081720680359423051782922927439914211;
        points[72] = 0.919299922587207943780996219175625575382509739615071748;
        points[73] = 0.933451296401838619235679773572839778659517293133588729;
        points[74] = 0.946281475011790874442295256371980327303829346330153813;
        points[75] = 0.957772299122767105961511740153088049085772463550661347;
        points[76] = 0.967907505450128729547014851893800133768508785146304657;
        points[77] = 0.976672750072842934232187870211190741212806053965758312;
        points[78] = 0.984055629596681471537066851699230729588099873062654272;
        points[79] = 0.990045701297265222772328057225512439088831027390690426;
        points[80] = 0.994634507631780323407966478826055559037071023433838435;
        points[81] = 0.997815640403429961756266273637745524427507816254882029;
        points[82] = 0.999585304807049343812604479811704835944572799856613551;
        weights[0] = 0.00106416821966656775638075248260211729606948037346137473;
        weights[1] = 0.00247571932254593974332876510963975379139401789468984188;
        weights[2] = 0.00388585943535320219200250247004140950510214724407158183;
        weights[3] = 0.00529068144585986555523849945036997493347658157605543286;
        weights[4] = 0.00668805163524368574135675292572032153973691424044123176;
        weights[5] = 0.0080759665931234522835930513436350677272231944285249302;
        weights[6] = 0.00945245509247969988824301652116866456272619720479507162;
        weights[7] = 0.0108155665580371587203612613902796011551650438676702222;
        weights[8] = 0.0121633707277986120630332637268732614214490781123748592;
        weights[9] = 0.0134939595123752349806995496246982237393842858674789815;
        weights[10] = 0.0148054494007178776808494292592399014569915134078369975;
        weights[11] = 0.0160959840119353709154380712946657750597133739817869245;
        weights[12] = 0.0173637366738246223501656114994715615224791494515541894;
        weights[13] = 0.0186069129854784728416677485982258460031268629342628471;
        weights[14] = 0.0198237533456549390493120494584803233142515206948427081;
        weights[15] = 0.0210125354372699178740093449998655498545339435257680432;
        weights[16] = 0.0221715766618036226219904411517353459116347118901456441;
        weights[17] = 0.023299236518900549370160963607473872806158218905915058;
        weights[18] = 0.0243939189271585574974342076865916368960913548181968758;
        weights[19] = 0.0254540744824894967508181690470537561832735747423484126;
        weights[20] = 0.0264782026506737624851086121390072963657180150296493888;
        weights[21] = 0.0274648538909032612389280346271643288245565870505677809;
        weights[22] = 0.0284126317072476415637507397322082140234465215396688163;
        weights[23] = 0.0293201946251045279180413927763185390705130913618218372;
        weights[24] = 0.030186258089814417054101741935957664658832805094591723;
        weights[25] = 0.0310095962847391948430670456171858902683955377946720731;
        weights[26] = 0.0317890438662221506435487555603910051844412479270258453;
        weights[27] = 0.0325234976129680659912911552479751944348198010398745614;
        weights[28] = 0.0332119179875050151811732516261181956258775584191181952;
        weights[29] = 0.0338533306075151986993099423119281179416331719096995833;
        weights[30] = 0.0344468276249505168325219137675345409215114773437427278;
        weights[31] = 0.0349915690109796547315246152933513772543692288197404612;
        weights[32] = 0.0354867837449471026458432432420452134915369451606852843;
        weights[33] = 0.0359317709056606473473307456940882442742492014110550478;
        weights[34] = 0.0363259006634622888998958092482453775670724758971489873;
        weights[35] = 0.0366686151716780900439006442072459261395191222386436387;
        weights[36] = 0.0369594293561849710797579864020557181008981814051101237;
        weights[37] = 0.0371979316019767305440012707401922465074625132540635312;
        weights[38] = 0.0373837843357574044109175955963427815227573719687044886;
        weights[39] = 0.0375167245037372727150576433374922347692567213708364901;
        weights[40] = 0.0375965639439551775919693443091918821201300799110273379;
        weights[41] = 0.0376231896526001233257501298802560925060423577806616976;
        weights[42] = 0.0375965639439551775919693443091918821201300799110273379;
        weights[43] = 0.0375167245037372727150576433374922347692567213708364901;
        weights[44] = 0.0373837843357574044109175955963427815227573719687044886;
        weights[45] = 0.0371979316019767305440012707401922465074625132540635312;
        weights[46] = 0.0369594293561849710797579864020557181008981814051101237;
        weights[47] = 0.0366686151716780900439006442072459261395191222386436387;
        weights[48] = 0.0363259006634622888998958092482453775670724758971489873;
        weights[49] = 0.0359317709056606473473307456940882442742492014110550478;
        weights[50] = 0.0354867837449471026458432432420452134915369451606852843;
        weights[51] = 0.0349915690109796547315246152933513772543692288197404612;
        weights[52] = 0.0344468276249505168325219137675345409215114773437427278;
        weights[53] = 0.0338533306075151986993099423119281179416331719096995833;
        weights[54] = 0.0332119179875050151811732516261181956258775584191181952;
        weights[55] = 0.0325234976129680659912911552479751944348198010398745614;
        weights[56] = 0.0317890438662221506435487555603910051844412479270258453;
        weights[57] = 0.0310095962847391948430670456171858902683955377946720731;
        weights[58] = 0.030186258089814417054101741935957664658832805094591723;
        weights[59] = 0.0293201946251045279180413927763185390705130913618218372;
        weights[60] = 0.0284126317072476415637507397322082140234465215396688163;
        weights[61] = 0.0274648538909032612389280346271643288245565870505677809;
        weights[62] = 0.0264782026506737624851086121390072963657180150296493888;
        weights[63] = 0.0254540744824894967508181690470537561832735747423484126;
        weights[64] = 0.0243939189271585574974342076865916368960913548181968758;
        weights[65] = 0.023299236518900549370160963607473872806158218905915058;
        weights[66] = 0.0221715766618036226219904411517353459116347118901456441;
        weights[67] = 0.0210125354372699178740093449998655498545339435257680432;
        weights[68] = 0.0198237533456549390493120494584803233142515206948427081;
        weights[69] = 0.0186069129854784728416677485982258460031268629342628471;
        weights[70] = 0.0173637366738246223501656114994715615224791494515541894;
        weights[71] = 0.0160959840119353709154380712946657750597133739817869245;
        weights[72] = 0.0148054494007178776808494292592399014569915134078369975;
        weights[73] = 0.0134939595123752349806995496246982237393842858674789815;
        weights[74] = 0.0121633707277986120630332637268732614214490781123748592;
        weights[75] = 0.0108155665580371587203612613902796011551650438676702222;
        weights[76] = 0.00945245509247969988824301652116866456272619720479507162;
        weights[77] = 0.0080759665931234522835930513436350677272231944285249302;
        weights[78] = 0.00668805163524368574135675292572032153973691424044123176;
        weights[79] = 0.00529068144585986555523849945036997493347658157605543286;
        weights[80] = 0.00388585943535320219200250247004140950510214724407158183;
        weights[81] = 0.00247571932254593974332876510963975379139401789468984188;
        weights[82] = 0.00106416821966656775638075248260211729606948037346137473;
        return;
    case 84:
        points[0] = -0.999595061226923242204747258251234425958700507449560769;
        points[1] = -0.997867016421711961561418965783363048995245214749477667;
        points[2] = -0.994760638261284641195837406212398265863948982125494602;
        points[3] = -0.99027952896535668733421589757165133427654773627138041;
        points[4] = -0.984429797127581651519074993626654564509877016777782529;
        points[5] = -0.977219507358315782654300664267100950473858714486669985;
        points[6] = -0.968658618173621897690627907168918638103335056128446584;
        points[7] = -0.958758958729693472019949185677910335804571748516776533;
        points[8] = -0.947534209947443122811275741168411874743128984853046247;
        points[9] = -0.934999884763558817752400569091661324507238305735699621;
        points[10] = -0.921173306363051217727206729807140741351429336208602232;
        points[11] = -0.906073584094008421339975508645814779774834929280339518;
        points[12] = -0.889721586988315460803939462826577771143721736012543045;
        points[13] = -0.872139914883579032029810582828381729882569824247594417;
        points[14] = -0.85335286716891866159874083644058430587596404991737629;
        points[15] = -0.833386409190021428846052446606800827151972951153726152;
        points[16] = -0.812268136356123039022937870542735356189774657361849253;
        points[17] = -0.790027235996596867967737656856101778573804340167762539;
        points[18] = -0.766694447018836282666900185380416642103496557875208932;
        points[19] = -0.742302017422609920773521739617602544086576867813144264;
        points[20] = -0.716883659729274823822882252870558821096409044976779281;
        points[21] = -0.690474504387248471220307205020714539379586217769685683;
        points[22] = -0.663111051218014634336199142606922515016037183756992726;
        points[23] = -0.634831118969691483644014248840422564411342075375014152;
        points[24] = -0.605673793047833389684268721807679839509576446995627834;
        points[25] = -0.575679371495674156041915893775171521867946782031651956;
        points[26] = -0.544889309298449688912646789907581232948173207675651098;
        points[27] = -0.513346161088761400048103842910033109470978124882249078;
        points[28] = -0.481093522332156176054308936231752826126483501906041917;
        points[29] = -0.448175969074202331158499729529122460965542110250116717;
        points[30] = -0.414638996332331219339989683299679830982633098580442514;
        points[31] = -0.380528955217588700538801264084052439731187630739562534;
        points[32] = -0.345892988873197059033129971717818769665829621728794332;
        points[33] = -0.310778967318463972627970735728000014336607738972434602;
        points[34] = -0.275235421288088560499353715303497712913923045843065706;
        points[35] = -0.239311475158303365709292619050534272798965149317029357;
        points[36] = -0.203056779052553478128809419528948846737484420677354894;
        points[37] = -0.166521440220548158966445103780456022131540968289852664;
        points[38] = -0.12975595378552474180053757130102217441923285646275742;
        points[39] = -0.0928111329554378827462503406450995751679516963464410038;
        points[40] = -0.0557380387945282169992728423223793681128781790265235652;
        points[41] = -0.0185879096523321332868301027854343340631972350092110522;
        points[42] = 0.0185879096523321332868301027854343340631972350092110522;
        points[43] = 0.0557380387945282169992728423223793681128781790265235652;
        points[44] = 0.0928111329554378827462503406450995751679516963464410038;
        points[45] = 0.12975595378552474180053757130102217441923285646275742;
        points[46] = 0.166521440220548158966445103780456022131540968289852664;
        points[47] = 0.203056779052553478128809419528948846737484420677354894;
        points[48] = 0.239311475158303365709292619050534272798965149317029357;
        points[49] = 0.275235421288088560499353715303497712913923045843065706;
        points[50] = 0.310778967318463972627970735728000014336607738972434602;
        points[51] = 0.345892988873197059033129971717818769665829621728794332;
        points[52] = 0.380528955217588700538801264084052439731187630739562534;
        points[53] = 0.414638996332331219339989683299679830982633098580442514;
        points[54] = 0.448175969074202331158499729529122460965542110250116717;
        points[55] = 0.481093522332156176054308936231752826126483501906041917;
        points[56] = 0.513346161088761400048103842910033109470978124882249078;
        points[57] = 0.544889309298449688912646789907581232948173207675651098;
        points[58] = 0.575679371495674156041915893775171521867946782031651956;
        points[59] = 0.605673793047833389684268721807679839509576446995627834;
        points[60] = 0.634831118969691483644014248840422564411342075375014152;
        points[61] = 0.663111051218014634336199142606922515016037183756992726;
        points[62] = 0.690474504387248471220307205020714539379586217769685683;
        points[63] = 0.716883659729274823822882252870558821096409044976779281;
        points[64] = 0.742302017422609920773521739617602544086576867813144264;
        points[65] = 0.766694447018836282666900185380416642103496557875208932;
        points[66] = 0.790027235996596867967737656856101778573804340167762539;
        points[67] = 0.812268136356123039022937870542735356189774657361849253;
        points[68] = 0.833386409190021428846052446606800827151972951153726152;
        points[69] = 0.85335286716891866159874083644058430587596404991737629;
        points[70] = 0.872139914883579032029810582828381729882569824247594417;
        points[71] = 0.889721586988315460803939462826577771143721736012543045;
        points[72] = 0.906073584094008421339975508645814779774834929280339518;
        points[73] = 0.921173306363051217727206729807140741351429336208602232;
        points[74] = 0.934999884763558817752400569091661324507238305735699621;
        points[75] = 0.947534209947443122811275741168411874743128984853046247;
        points[76] = 0.958758958729693472019949185677910335804571748516776533;
        points[77] = 0.968658618173621897690627907168918638103335056128446584;
        points[78] = 0.977219507358315782654300664267100950473858714486669985;
        points[79] = 0.984429797127581651519074993626654564509877016777782529;
        points[80] = 0.99027952896535668733421589757165133427654773627138041;
        points[81] = 0.994760638261284641195837406212398265863948982125494602;
        points[82] = 0.997867016421711961561418965783363048995245214749477667;
        points[83] = 0.999595061226923242204747258251234425958700507449560769;
        weights[0] = 0.00103913351645197188918811353908122911915450374509819569;
        weights[1] = 0.00241751126544312285523519175329055816706297781472028675;
        weights[2] = 0.00379459165045234969639339440752350426954477649903649851;
        weights[3] = 0.00516660518274680832988102111602604482069488215661602708;
        weights[4] = 0.00653151368771365460112134939319078215006993934956811285;
        weights[5] = 0.0078874057526481463821061278247736423952224058995539734;
        weights[6] = 0.00923240078419024701438294561421525730676686111424185426;
        weights[7] = 0.0105646376230082452648484785699581669174784627109199525;
        weights[8] = 0.011882274089801223495051961643096779052147563055314888;
        weights[9] = 0.0131834886791823459867994674340018676644523998036324669;
        weights[10] = 0.0144664827891611862422748721229512144888013454723692986;
        weights[11] = 0.0157294830955835982015998235831063007556159838441403153;
        weights[12] = 0.0169707439552116113430816822898765092678039087060276601;
        weights[13] = 0.0181885497960565499276002407845758873793564015907627646;
        weights[14] = 0.0193812174773188086478070583120437772624875111407294814;
        weights[15] = 0.0205470986097562786115244396366892794049978523911430081;
        weights[16] = 0.021684581830644822989244037171501478058228789485716073;
        weights[17] = 0.0227920950289421293388886334012873783168701678434647138;
        weights[18] = 0.0238681075169582393847154219004387659905402172395572946;
        weights[19] = 0.024911132145206428884391359783210120679717922229965035;
        weights[20] = 0.0259197273573346477251602155204057173582796824404834214;
        weights[21] = 0.0268924991821976375158164234534642811096781507695481783;
        weights[22] = 0.0278281031602584060357669203286374338980418950342779043;
        weights[23] = 0.0287252462016218022126647793795872530547656018451548083;
        weights[24] = 0.0295826883731108452896052613482587628117544787110740899;
        weights[25] = 0.0303992446119024697731137023090169956239837675138615041;
        weights[26] = 0.0311737863633456612919674695492219850960773805441297743;
        weights[27] = 0.0319052431406927274840229657768828741032142942342603385;
        weights[28] = 0.0325926040045842571836133353160918964878695502559554495;
        weights[29] = 0.0332349189602404440747156266588090841259842223351663097;
        weights[30] = 0.0338313002704259848037248913812260789256065059263059226;
        weights[31] = 0.0343809236823727006213349333041121432421609924543345141;
        weights[32] = 0.0348830295669633084564166620759768362781065297948796328;
        weights[33] = 0.0353369239686012761603887249704209550119024714470940282;
        weights[34] = 0.0357419795643153072778889730279038920457662828529613448;
        weights[35] = 0.0360976365307725667017526226798206427511378582342012502;
        weights[36] = 0.0364034033180021224886262601287836206386381746607612423;
        weights[37] = 0.0366588573287590756365769173427926049753384859970012852;
        weights[38] = 0.0368636455025903077184520716378216273298094686116136351;
        weights[39] = 0.0370174848037945205852444236981303050927920345619995297;
        weights[40] = 0.0371201626126020942737275872868440687313590190315391965;
        weights[41] = 0.0371715370190340676032836125449523978407182806508187399;
        weights[42] = 0.0371715370190340676032836125449523978407182806508187399;
        weights[43] = 0.0371201626126020942737275872868440687313590190315391965;
        weights[44] = 0.0370174848037945205852444236981303050927920345619995297;
        weights[45] = 0.0368636455025903077184520716378216273298094686116136351;
        weights[46] = 0.0366588573287590756365769173427926049753384859970012852;
        weights[47] = 0.0364034033180021224886262601287836206386381746607612423;
        weights[48] = 0.0360976365307725667017526226798206427511378582342012502;
        weights[49] = 0.0357419795643153072778889730279038920457662828529613448;
        weights[50] = 0.0353369239686012761603887249704209550119024714470940282;
        weights[51] = 0.0348830295669633084564166620759768362781065297948796328;
        weights[52] = 0.0343809236823727006213349333041121432421609924543345141;
        weights[53] = 0.0338313002704259848037248913812260789256065059263059226;
        weights[54] = 0.0332349189602404440747156266588090841259842223351663097;
        weights[55] = 0.0325926040045842571836133353160918964878695502559554495;
        weights[56] = 0.0319052431406927274840229657768828741032142942342603385;
        weights[57] = 0.0311737863633456612919674695492219850960773805441297743;
        weights[58] = 0.0303992446119024697731137023090169956239837675138615041;
        weights[59] = 0.0295826883731108452896052613482587628117544787110740899;
        weights[60] = 0.0287252462016218022126647793795872530547656018451548083;
        weights[61] = 0.0278281031602584060357669203286374338980418950342779043;
        weights[62] = 0.0268924991821976375158164234534642811096781507695481783;
        weights[63] = 0.0259197273573346477251602155204057173582796824404834214;
        weights[64] = 0.024911132145206428884391359783210120679717922229965035;
        weights[65] = 0.0238681075169582393847154219004387659905402172395572946;
        weights[66] = 0.0227920950289421293388886334012873783168701678434647138;
        weights[67] = 0.021684581830644822989244037171501478058228789485716073;
        weights[68] = 0.0205470986097562786115244396366892794049978523911430081;
        weights[69] = 0.0193812174773188086478070583120437772624875111407294814;
        weights[70] = 0.0181885497960565499276002407845758873793564015907627646;
        weights[71] = 0.0169707439552116113430816822898765092678039087060276601;
        weights[72] = 0.0157294830955835982015998235831063007556159838441403153;
        weights[73] = 0.0144664827891611862422748721229512144888013454723692986;
        weights[74] = 0.0131834886791823459867994674340018676644523998036324669;
        weights[75] = 0.011882274089801223495051961643096779052147563055314888;
        weights[76] = 0.0105646376230082452648484785699581669174784627109199525;
        weights[77] = 0.00923240078419024701438294561421525730676686111424185426;
        weights[78] = 0.0078874057526481463821061278247736423952224058995539734;
        weights[79] = 0.00653151368771365460112134939319078215006993934956811285;
        weights[80] = 0.00516660518274680832988102111602604482069488215661602708;
        weights[81] = 0.00379459165045234969639339440752350426954477649903649851;
        weights[82] = 0.00241751126544312285523519175329055816706297781472028675;
        weights[83] = 0.00103913351645197188918811353908122911915450374509819569;
        return;
    case 85:
        points[0] = -0.999604477357478454326303594990157090942990007364103724;
        points[1] = -0.997916601198116933150308835969062924255730030854874003;
        points[2] = -0.994882374295616278453367144083987370721290463132734579;
        points[3] = -0.990505217716415963787124329921325405197454438109328298;
        points[4] = -0.984790957685580497327164094874408863246469614624162944;
        points[5] = -0.977747288412243391933333872939103123698474719005927342;
        points[6] = -0.969383711923678328005136203614252944073526668172089271;
        points[7] = -0.959711515957188362396346852856422880728865510968939497;
        points[8] = -0.948743756254578953404648576761948983273098185125769091;
        points[9] = -0.936495238116430699686697601650461886703531982251589277;
        points[10] = -0.922982496096090045588769455885738075324286614435633822;
        points[11] = -0.908223771539091884896825081042592625811904010335347996;
        points[12] = -0.892238987891355901581713742646718680280104491677439803;
        points[13] = -0.875049723769097087638652949360223710332690846638221363;
        points[14] = -0.85667918380995618909581132254445923753400770611199386;
        points[15] = -0.837152167337082650198541848709333397775684173552840752;
        points[16] = -0.816495034874791614720573247999196249474258709231300449;
        points[17] = -0.794735672559116505447149321514210578884881895878370676;
        points[18] = -0.771903454490293078660311061111389554418916424365318715;
        points[19] = -0.748029203077434073956269902811813149619904108011852232;
        points[20] = -0.723145147428601021384583393214557907836558043817664638;
        points[21] = -0.69728487984224954765096398989609677028575335840638066;
        points[22] = -0.670483310458662660702672074545307885627507135964673379;
        points[23] = -0.642776620132514714843399431608996576605170212520158328;
        points[24] = -0.614202211590136993071296934860449005837563709727037458;
        points[25] = -0.584798658937388085710292056422697554100257090142587505;
        points[26] = -0.554605655586269433158990751210338114227708429241530408;
        points[27] = -0.523663960670567874788045336170929928296507768238612495;
        points[28] = -0.492015344022851310477142125447098982950773253751655952;
        points[29] = -0.459702529787088720761469421282517747962424117394406571;
        points[30] = -0.426769138743009701721994413332130021012417624960087469;
        points[31] = -0.393259629420059190650214752960096877484257939216815209;
        points[32] = -0.359219238080438048756644806232914968067304261008915988;
        points[33] = -0.324693917652247557454016555336952763403695389317604909;
        points[34] = -0.289730275695173703538709627406360728631582547867898969;
        points[35] = -0.25437551148245352249773066037398799147830587862329658;
        points[36] = -0.218677352284059015710243291188240268264447189025146044;
        points[37] = -0.182683988937112673876281089537086593919829302050803331;
        points[38] = -0.146444010790510989210901521697215068869880639037141577;
        points[39] = -0.110006340111577237352680016914204006452507107694412367;
        points[40] = -0.0734201660432911256195077272351553999356636623078544739;
        points[41] = -0.0367348782012496635204687686412114736089252374458312539;
        points[42] = 0;
        points[43] = 0.0367348782012496635204687686412114736089252374458312539;
        points[44] = 0.0734201660432911256195077272351553999356636623078544739;
        points[45] = 0.110006340111577237352680016914204006452507107694412367;
        points[46] = 0.146444010790510989210901521697215068869880639037141577;
        points[47] = 0.182683988937112673876281089537086593919829302050803331;
        points[48] = 0.218677352284059015710243291188240268264447189025146044;
        points[49] = 0.25437551148245352249773066037398799147830587862329658;
        points[50] = 0.289730275695173703538709627406360728631582547867898969;
        points[51] = 0.324693917652247557454016555336952763403695389317604909;
        points[52] = 0.359219238080438048756644806232914968067304261008915988;
        points[53] = 0.393259629420059190650214752960096877484257939216815209;
        points[54] = 0.426769138743009701721994413332130021012417624960087469;
        points[55] = 0.459702529787088720761469421282517747962424117394406571;
        points[56] = 0.492015344022851310477142125447098982950773253751655952;
        points[57] = 0.523663960670567874788045336170929928296507768238612495;
        points[58] = 0.554605655586269433158990751210338114227708429241530408;
        points[59] = 0.584798658937388085710292056422697554100257090142587505;
        points[60] = 0.614202211590136993071296934860449005837563709727037458;
        points[61] = 0.642776620132514714843399431608996576605170212520158328;
        points[62] = 0.670483310458662660702672074545307885627507135964673379;
        points[63] = 0.69728487984224954765096398989609677028575335840638066;
        points[64] = 0.723145147428601021384583393214557907836558043817664638;
        points[65] = 0.748029203077434073956269902811813149619904108011852232;
        points[66] = 0.771903454490293078660311061111389554418916424365318715;
        points[67] = 0.794735672559116505447149321514210578884881895878370676;
        points[68] = 0.816495034874791614720573247999196249474258709231300449;
        points[69] = 0.837152167337082650198541848709333397775684173552840752;
        points[70] = 0.85667918380995618909581132254445923753400770611199386;
        points[71] = 0.875049723769097087638652949360223710332690846638221363;
        points[72] = 0.892238987891355901581713742646718680280104491677439803;
        points[73] = 0.908223771539091884896825081042592625811904010335347996;
        points[74] = 0.922982496096090045588769455885738075324286614435633822;
        points[75] = 0.936495238116430699686697601650461886703531982251589277;
        points[76] = 0.948743756254578953404648576761948983273098185125769091;
        points[77] = 0.959711515957188362396346852856422880728865510968939497;
        points[78] = 0.969383711923678328005136203614252944073526668172089271;
        points[79] = 0.977747288412243391933333872939103123698474719005927342;
        points[80] = 0.984790957685580497327164094874408863246469614624162944;
        points[81] = 0.990505217716415963787124329921325405197454438109328298;
        points[82] = 0.994882374295616278453367144083987370721290463132734579;
        points[83] = 0.997916601198116933150308835969062924255730030854874003;
        points[84] = 0.999604477357478454326303594990157090942990007364103724;
        weights[0] = 0.00101497190896774369537302254678204493041127802544663327;
        weights[1] = 0.00236133170428502089676737879786271842675556874811911839;
        weights[2] = 0.00370650012575931670687099874347388387223739439224686839;
        weights[3] = 0.00504683842692444272545177185277587768721421009198190309;
        weights[4] = 0.00638039858789751509868592523345426701126793146795117777;
        weights[5] = 0.0077053559603827570798971704036137323149988917568522386;
        weights[6] = 0.00901991543999363127896719365335704968848409514872202866;
        weights[7] = 0.0103223002305242458938162097228536045210267854377125345;
        weights[8] = 0.0116107512867038980096243119023725195021919819684771238;
        weights[9] = 0.012883528856498084290506282311472674967855614490416489;
        weights[10] = 0.0141389145484008329305554204793362441526929459658609298;
        weights[11] = 0.0153752135423896268744083905318223899100393359267737279;
        weights[12] = 0.0165907568311546700752050496204174347267183151554580938;
        weights[13] = 0.017783903451398170907743693479141265358700676750611114;
        weights[14] = 0.0189530426881828404468051959934882242843210642258866109;
        weights[15] = 0.0200965962435754217417945413855980098685225994692699678;
        weights[16] = 0.0212130203640893796724167094099740775915079786558973441;
        weights[17] = 0.0223008079228393741894575401537016050632124875460276331;
        weights[18] = 0.0233584904529898918976984331521214888157540398758504121;
        weights[19] = 0.0243846401294356831424158213218527724815481254272392322;
        weights[20] = 0.025377871695866088477369675217938313751997565491789884;
        weights[21] = 0.0263368443345143598217315378122494222804484425417006876;
        weights[22] = 0.0272602634760111647857699512380349793622660022157304121;
        weights[23] = 0.0281468825468650758463830934009779104254038733849119714;
        weights[24] = 0.0289955046521901520898662724900177986592564395093198297;
        weights[25] = 0.0298049841913958873756123674554846431690709851294565198;
        weights[26] = 0.0305742284046499957239241118161391068683974018909795713;
        weights[27] = 0.0313021988480208704483969703043519495559167502313019581;
        weights[28] = 0.0319879127953046744597700005754962989666275490189846159;
        weights[29] = 0.0326304445646421781890377122562590533177998566857916499;
        weights[30] = 0.0332289267681327697625285749638690333308878465214180271;
        weights[31] = 0.0337825514827575303313117325538792694765108553598659199;
        weights[32] = 0.0342905713410298467082222575899932937681990970959774145;
        weights[33] = 0.0347523005399006375292473538143687217344072864625574092;
        weights[34] = 0.035167115766555788249812850966948916742910705932962312;
        weights[35] = 0.0355344570398556990819915135007879559970354234212172815;
        weights[36] = 0.0358538284662808125569151982664331905008381076721435276;
        weights[37] = 0.0361247989093624603747518806650170906002713111716841777;
        weights[38] = 0.0363470025716952037667567744435830894598158539605570888;
        weights[39] = 0.0365201394887448848574766127853175464233565047608209354;
        weights[40] = 0.0366439759337857024864069266032386355418181719235210523;
        weights[41] = 0.0367183447334196162221522545678728991319507545230083765;
        weights[42] = 0.0367431454932521066002066320325379915187037891349963929;
        weights[43] = 0.0367183447334196162221522545678728991319507545230083765;
        weights[44] = 0.0366439759337857024864069266032386355418181719235210523;
        weights[45] = 0.0365201394887448848574766127853175464233565047608209354;
        weights[46] = 0.0363470025716952037667567744435830894598158539605570888;
        weights[47] = 0.0361247989093624603747518806650170906002713111716841777;
        weights[48] = 0.0358538284662808125569151982664331905008381076721435276;
        weights[49] = 0.0355344570398556990819915135007879559970354234212172815;
        weights[50] = 0.035167115766555788249812850966948916742910705932962312;
        weights[51] = 0.0347523005399006375292473538143687217344072864625574092;
        weights[52] = 0.0342905713410298467082222575899932937681990970959774145;
        weights[53] = 0.0337825514827575303313117325538792694765108553598659199;
        weights[54] = 0.0332289267681327697625285749638690333308878465214180271;
        weights[55] = 0.0326304445646421781890377122562590533177998566857916499;
        weights[56] = 0.0319879127953046744597700005754962989666275490189846159;
        weights[57] = 0.0313021988480208704483969703043519495559167502313019581;
        weights[58] = 0.0305742284046499957239241118161391068683974018909795713;
        weights[59] = 0.0298049841913958873756123674554846431690709851294565198;
        weights[60] = 0.0289955046521901520898662724900177986592564395093198297;
        weights[61] = 0.0281468825468650758463830934009779104254038733849119714;
        weights[62] = 0.0272602634760111647857699512380349793622660022157304121;
        weights[63] = 0.0263368443345143598217315378122494222804484425417006876;
        weights[64] = 0.025377871695866088477369675217938313751997565491789884;
        weights[65] = 0.0243846401294356831424158213218527724815481254272392322;
        weights[66] = 0.0233584904529898918976984331521214888157540398758504121;
        weights[67] = 0.0223008079228393741894575401537016050632124875460276331;
        weights[68] = 0.0212130203640893796724167094099740775915079786558973441;
        weights[69] = 0.0200965962435754217417945413855980098685225994692699678;
        weights[70] = 0.0189530426881828404468051959934882242843210642258866109;
        weights[71] = 0.017783903451398170907743693479141265358700676750611114;
        weights[72] = 0.0165907568311546700752050496204174347267183151554580938;
        weights[73] = 0.0153752135423896268744083905318223899100393359267737279;
        weights[74] = 0.0141389145484008329305554204793362441526929459658609298;
        weights[75] = 0.012883528856498084290506282311472674967855614490416489;
        weights[76] = 0.0116107512867038980096243119023725195021919819684771238;
        weights[77] = 0.0103223002305242458938162097228536045210267854377125345;
        weights[78] = 0.00901991543999363127896719365335704968848409514872202866;
        weights[79] = 0.0077053559603827570798971704036137323149988917568522386;
        weights[80] = 0.00638039858789751509868592523345426701126793146795117777;
        weights[81] = 0.00504683842692444272545177185277587768721421009198190309;
        weights[82] = 0.00370650012575931670687099874347388387223739439224686839;
        weights[83] = 0.00236133170428502089676737879786271842675556874811911839;
        weights[84] = 0.00101497190896774369537302254678204493041127802544663327;
        return;
    case 86:
        points[0] = -0.999613568841325857017351942969189805662156431607311505;
        points[1] = -0.997964477035243944785198247037693717989841467033960124;
        points[2] = -0.994999917485337896224027829686526778730686972048891776;
        points[3] = -0.990723140745518705219946159575732456404618918668602702;
        points[4] = -0.985139706732502413611134932129692229690872310642600225;
        points[5] = -0.978256960253684716622481710089679414549364736104473188;
        points[6] = -0.970083972685740131358566785675323840556745243601627866;
        points[7] = -0.960631520942898448629414608891630081837933563312261272;
        points[8] = -0.949912070852210255712008462219368834642259326694715145;
        points[9] = -0.937939759909892614433043182946540196979601063166068843;
        points[10] = -0.924730378322861949777045863854848696212997022719643422;
        points[11] = -0.910301348046165830210553097015580656307155615707807724;
        points[12] = -0.894671699739446334379038964327568760598544218252495284;
        points[13] = -0.877862047633365937339915658790179840142397661490775922;
        points[14] = -0.859894562322684955300208689675310061501496387000605906;
        points[15] = -0.840792941514433051699710688726689025464895759407154757;
        points[16] = -0.820582378766160221537050317049006497553274685444453047;
        points[17] = -0.799289530253661788136252701433591201826329711587800958;
        points[18] = -0.776942479611023371054469712741487635270857534302835418;
        points[19] = -0.753570700888808903497940761706162657230879364141624534;
        points[20] = -0.729205019678928322898717965166186322924324496751915945;
        points[21] = -0.703877572457267694796427306989338223524315949332220486;
        points[22] = -0.677621764197588510655952137522972613833843511010524051;
        points[23] = -0.650472224312526232850994715897838812096138528833436655;
        points[24] = -0.62246476097975081191325369984740427080596500612070024;
        points[25] = -0.59363631391349803367208749156142935359940119053528005;
        points[26] = -0.564024905643741329015105021679339346125959284430937662;
        points[27] = -0.533669591367248683303849130238501028146310628379303721;
        points[28] = -0.502610407436657274501912677149549922778530898345567019;
        points[29] = -0.470888318555497783577945256477108396680421372407993307;
        points[30] = -0.43854516374880909401178309868219586490787916033391833;
        points[31] = -0.405623601180600396151174199921872054557457478763151016;
        points[32] = -0.372167051890939610324135387848147850545038487825618239;
        points[33] = -0.338219642526872666411964213679980311628743678368428325;
        points[34] = -0.303826147142705735062771703175477132086676043422578652;
        points[35] = -0.269031928146410305100409500112038447227013476222821846;
        points[36] = -0.233882876470037463740116140835403543424167189183911468;
        points[37] = -0.198425351043051402814531474417231133977355773999573314;
        points[38] = -0.162706117648411714337532407117268930639171402038404761;
        points[39] = -0.12677228724204825298619878567461410319322009935876121;
        points[40] = -0.0906712538170801670313767656081154115432657898629839801;
        points[41] = -0.0544506318947312060299349172716317683343996509916633964;
        points[42] = -0.0181581937243858159334428947157603639317037294693078434;
        points[43] = 0.0181581937243858159334428947157603639317037294693078434;
        points[44] = 0.0544506318947312060299349172716317683343996509916633964;
        points[45] = 0.0906712538170801670313767656081154115432657898629839801;
        points[46] = 0.12677228724204825298619878567461410319322009935876121;
        points[47] = 0.162706117648411714337532407117268930639171402038404761;
        points[48] = 0.198425351043051402814531474417231133977355773999573314;
        points[49] = 0.233882876470037463740116140835403543424167189183911468;
        points[50] = 0.269031928146410305100409500112038447227013476222821846;
        points[51] = 0.303826147142705735062771703175477132086676043422578652;
        points[52] = 0.338219642526872666411964213679980311628743678368428325;
        points[53] = 0.372167051890939610324135387848147850545038487825618239;
        points[54] = 0.405623601180600396151174199921872054557457478763151016;
        points[55] = 0.43854516374880909401178309868219586490787916033391833;
        points[56] = 0.470888318555497783577945256477108396680421372407993307;
        points[57] = 0.502610407436657274501912677149549922778530898345567019;
        points[58] = 0.533669591367248683303849130238501028146310628379303721;
        points[59] = 0.564024905643741329015105021679339346125959284430937662;
        points[60] = 0.59363631391349803367208749156142935359940119053528005;
        points[61] = 0.62246476097975081191325369984740427080596500612070024;
        points[62] = 0.650472224312526232850994715897838812096138528833436655;
        points[63] = 0.677621764197588510655952137522972613833843511010524051;
        points[64] = 0.703877572457267694796427306989338223524315949332220486;
        points[65] = 0.729205019678928322898717965166186322924324496751915945;
        points[66] = 0.753570700888808903497940761706162657230879364141624534;
        points[67] = 0.776942479611023371054469712741487635270857534302835418;
        points[68] = 0.799289530253661788136252701433591201826329711587800958;
        points[69] = 0.820582378766160221537050317049006497553274685444453047;
        points[70] = 0.840792941514433051699710688726689025464895759407154757;
        points[71] = 0.859894562322684955300208689675310061501496387000605906;
        points[72] = 0.877862047633365937339915658790179840142397661490775922;
        points[73] = 0.894671699739446334379038964327568760598544218252495284;
        points[74] = 0.910301348046165830210553097015580656307155615707807724;
        points[75] = 0.924730378322861949777045863854848696212997022719643422;
        points[76] = 0.937939759909892614433043182946540196979601063166068843;
        points[77] = 0.949912070852210255712008462219368834642259326694715145;
        points[78] = 0.960631520942898448629414608891630081837933563312261272;
        points[79] = 0.970083972685740131358566785675323840556745243601627866;
        points[80] = 0.978256960253684716622481710089679414549364736104473188;
        points[81] = 0.985139706732502413611134932129692229690872310642600225;
        points[82] = 0.990723140745518705219946159575732456404618918668602702;
        points[83] = 0.994999917485337896224027829686526778730686972048891776;
        points[84] = 0.997964477035243944785198247037693717989841467033960124;
        points[85] = 0.999613568841325857017351942969189805662156431607311505;
        weights[0] = 0.000991643266620363525577582382932217540577394251344239277;
        weights[1] = 0.00230708748880990292596782267410227329579519820326411922;
        weights[2] = 0.00362143924961090143755572039359292442832542194383014386;
        weights[3] = 0.00493118409696010369642156396089006585487148856820422564;
        weights[4] = 0.00623445913914012346388694591988185136218845348398034145;
        weights[5] = 0.00752952161219456260684489504788698398795572491820680165;
        weights[6] = 0.00881465710195481570378200724240157836016670816053169431;
        weights[7] = 0.0100881684603861056546730282172430413489417563873061859;
        weights[8] = 0.0113483751561777039771665897513133594372480468314072366;
        weights[9] = 0.0125936146780696978104092545424971057894429190199890995;
        weights[10] = 0.0138222444527666708666481916995773101825878752060200952;
        weights[11] = 0.0150326439050813786849451862612062385712188342586905399;
        weights[12] = 0.0162232165497290225880836076053843190641988403283081192;
        weights[13] = 0.0173923920756905423867196462384649403536089190044800483;
        weights[14] = 0.0185386284067098592063147228260076567552595435141728905;
        weights[15] = 0.0196604137295621798074019960079526988933924366884644979;
        weights[16] = 0.0207562684849091427905816947459433612234544371049016096;
        weights[17] = 0.021824747316927627800684218815890313560448446943089103;
        weights[18] = 0.0228644409785480064457728459328347326615083224987145673;
        weights[19] = 0.0238739781894790049732174117578445359700002482780705929;
        weights[20] = 0.0248520274443998359183258284984757181605454698521834407;
        weights[21] = 0.0257972987688395354077711033170694206226818425830984696;
        weights[22] = 0.0267085454203722095753067430520971149586396158682636187;
        weights[23] = 0.0275845655328512483873842027913599447461150042856283341;
        weights[24] = 0.0284242037014934947573124312298211188320881793443512899;
        weights[25] = 0.0292263525067099445836614968452255989582412864753473202;
        weights[26] = 0.0299899539746649324913384897796552099917880914247616215;
        weights[27] = 0.0307140009726320531830400490733605485542773360163445548;
        weights[28] = 0.0313975385373028655585332241447571566398198510152229168;
        weights[29] = 0.0320396651342940161102283489694564891501812646141269416;
        weights[30] = 0.0326395338471899219560986782670532170323091040227089687;
        weights[31] = 0.0331963534945515971200903413374642017737755387426929704;
        weights[32] = 0.0337093896734175548649715361110166737414081514421014106;
        weights[33] = 0.0341779657279199046342381194826236549739805914956132281;
        weights[34] = 0.0346014636417376922599344091372423474580623290271581995;
        weights[35] = 0.034979324853210099371413175087053766553669290800799273;
        weights[36] = 0.0353110509920342050805847119454982728408803904478828853;
        weights[37] = 0.0355962045365754955906911483839783802434271099822066093;
        weights[38] = 0.0358344093909240557897794220892032494486863691465998231;
        weights[39] = 0.0360253513809352577100895612002752565557873680126060258;
        weights[40] = 0.0361687786686006375827449538310791186386589106886723842;
        weights[41] = 0.036264502084202387431491952519968198299044586363483966;
        weights[42] = 0.0363123953758133382823151408824178331847413027551695965;
        weights[43] = 0.0363123953758133382823151408824178331847413027551695965;
        weights[44] = 0.036264502084202387431491952519968198299044586363483966;
        weights[45] = 0.0361687786686006375827449538310791186386589106886723842;
        weights[46] = 0.0360253513809352577100895612002752565557873680126060258;
        weights[47] = 0.0358344093909240557897794220892032494486863691465998231;
        weights[48] = 0.0355962045365754955906911483839783802434271099822066093;
        weights[49] = 0.0353110509920342050805847119454982728408803904478828853;
        weights[50] = 0.034979324853210099371413175087053766553669290800799273;
        weights[51] = 0.0346014636417376922599344091372423474580623290271581995;
        weights[52] = 0.0341779657279199046342381194826236549739805914956132281;
        weights[53] = 0.0337093896734175548649715361110166737414081514421014106;
        weights[54] = 0.0331963534945515971200903413374642017737755387426929704;
        weights[55] = 0.0326395338471899219560986782670532170323091040227089687;
        weights[56] = 0.0320396651342940161102283489694564891501812646141269416;
        weights[57] = 0.0313975385373028655585332241447571566398198510152229168;
        weights[58] = 0.0307140009726320531830400490733605485542773360163445548;
        weights[59] = 0.0299899539746649324913384897796552099917880914247616215;
        weights[60] = 0.0292263525067099445836614968452255989582412864753473202;
        weights[61] = 0.0284242037014934947573124312298211188320881793443512899;
        weights[62] = 0.0275845655328512483873842027913599447461150042856283341;
        weights[63] = 0.0267085454203722095753067430520971149586396158682636187;
        weights[64] = 0.0257972987688395354077711033170694206226818425830984696;
        weights[65] = 0.0248520274443998359183258284984757181605454698521834407;
        weights[66] = 0.0238739781894790049732174117578445359700002482780705929;
        weights[67] = 0.0228644409785480064457728459328347326615083224987145673;
        weights[68] = 0.021824747316927627800684218815890313560448446943089103;
        weights[69] = 0.0207562684849091427905816947459433612234544371049016096;
        weights[70] = 0.0196604137295621798074019960079526988933924366884644979;
        weights[71] = 0.0185386284067098592063147228260076567552595435141728905;
        weights[72] = 0.0173923920756905423867196462384649403536089190044800483;
        weights[73] = 0.0162232165497290225880836076053843190641988403283081192;
        weights[74] = 0.0150326439050813786849451862612062385712188342586905399;
        weights[75] = 0.0138222444527666708666481916995773101825878752060200952;
        weights[76] = 0.0125936146780696978104092545424971057894429190199890995;
        weights[77] = 0.0113483751561777039771665897513133594372480468314072366;
        weights[78] = 0.0100881684603861056546730282172430413489417563873061859;
        weights[79] = 0.00881465710195481570378200724240157836016670816053169431;
        weights[80] = 0.00752952161219456260684489504788698398795572491820680165;
        weights[81] = 0.00623445913914012346388694591988185136218845348398034145;
        weights[82] = 0.00493118409696010369642156396089006585487148856820422564;
        weights[83] = 0.00362143924961090143755572039359292442832542194383014386;
        weights[84] = 0.00230708748880990292596782267410227329579519820326411922;
        weights[85] = 0.000991643266620363525577582382932217540577394251344239277;
        return;
    case 87:
        points[0] = -0.999622350432484272389096185749497565390399490658400321;
        points[1] = -0.998010721562982358081678891431846376473477063856642147;
        points[2] = -0.995113458137992005945508330416231027159975293631828542;
        points[3] = -0.990933650110964570522867823538884007517445869471778344;
        points[4] = -0.985476606068420367963807908226506489677366069337711888;
        points[5] = -0.978749341003816272426478037569423482079549354651570436;
        points[6] = -0.97076051974728427435354730906652230253226916339579217;
        points[7] = -0.961520436936073169264229683224874930506868697980601585;
        points[8] = -0.951041001389313573919119010523278447884229172195199194;
        points[9] = -0.939335719974205747877988092886009230635921825321442135;
        points[10] = -0.926419679891237219951464182782721360929554385340338017;
        points[11] = -0.912309529094122884382983357958241900636278714509489184;
        points[12] = -0.897023454767569367017326260558706439993815747209982633;
        points[13] = -0.880581159852041841057713216080658147566397776298470145;
        points[14] = -0.863003837629706602570190489180595063884886011815494163;
        points[15] = -0.844314144397035220240557020019893007885642704413705486;
        points[16] = -0.824536170255780480133434725494634095816369960992382109;
        points[17] = -0.803695408058177778235321113896313089865922367958761702;
        points[18] = -0.781818720545437736354677988571770601388956953294154692;
        points[19] = -0.758934305721349315735428041268913993363472266318015482;
        points[20] = -0.735071660505313794102036048985008750457224270019665554;
        points[21] = -0.710261542711472902841968378563206824963289622972237316;
        points[22] = -0.684535931402823674119861517328756456249806653504923551;
        points[23] = -0.657927985671349391042954035196771193374441089327331597;
        points[24] = -0.630472001897250447293694777075813497067786559898796095;
        points[25] = -0.60220336954233520168795496689113700447241675798051574;
        points[26] = -0.573158525534530411874212784992110484655464762126392147;
        points[27] = -0.543374907302293353442616149349503999769504125296562223;
        points[28] = -0.512890904519452259140909518153736565633971802210266474;
        points[29] = -0.48174580962266680508946178150304493711052163482664568;
        points[30] = -0.449979767165284378401573103410581060242108638006767662;
        points[31] = -0.417633722072869055029910756144652150836662693283229751;
        points[32] = -0.384749366867096863663811170222353558160106937644079202;
        points[33] = -0.351369087926041315715693878667645702381599860664916302;
        points[34] = -0.317535910850115714331343646849279471874506368970341056;
        points[35] = -0.283293445004091873194452195365228723423785964523055878;
        points[36] = -0.248685827306677131599537923360315256640515832788089432;
        points[37] = -0.213757665340101603593762577694925815743044846375573117;
        points[38] = -0.178553979853044214298229486984192442580625528214368878;
        points[39] = -0.143120146731008139012399367020744511971910730901968526;
        points[40] = -0.107501838508942771605762475899963289063181068820247075;
        points[41] = -0.07174496550149942971283085435657413616349796594446608;
        points[42] = -0.0358956166268008994727171826528239644536190599614857113;
        points[43] = 0;
        points[44] = 0.0358956166268008994727171826528239644536190599614857113;
        points[45] = 0.07174496550149942971283085435657413616349796594446608;
        points[46] = 0.107501838508942771605762475899963289063181068820247075;
        points[47] = 0.143120146731008139012399367020744511971910730901968526;
        points[48] = 0.178553979853044214298229486984192442580625528214368878;
        points[49] = 0.213757665340101603593762577694925815743044846375573117;
        points[50] = 0.248685827306677131599537923360315256640515832788089432;
        points[51] = 0.283293445004091873194452195365228723423785964523055878;
        points[52] = 0.317535910850115714331343646849279471874506368970341056;
        points[53] = 0.351369087926041315715693878667645702381599860664916302;
        points[54] = 0.384749366867096863663811170222353558160106937644079202;
        points[55] = 0.417633722072869055029910756144652150836662693283229751;
        points[56] = 0.449979767165284378401573103410581060242108638006767662;
        points[57] = 0.48174580962266680508946178150304493711052163482664568;
        points[58] = 0.512890904519452259140909518153736565633971802210266474;
        points[59] = 0.543374907302293353442616149349503999769504125296562223;
        points[60] = 0.573158525534530411874212784992110484655464762126392147;
        points[61] = 0.60220336954233520168795496689113700447241675798051574;
        points[62] = 0.630472001897250447293694777075813497067786559898796095;
        points[63] = 0.657927985671349391042954035196771193374441089327331597;
        points[64] = 0.684535931402823674119861517328756456249806653504923551;
        points[65] = 0.710261542711472902841968378563206824963289622972237316;
        points[66] = 0.735071660505313794102036048985008750457224270019665554;
        points[67] = 0.758934305721349315735428041268913993363472266318015482;
        points[68] = 0.781818720545437736354677988571770601388956953294154692;
        points[69] = 0.803695408058177778235321113896313089865922367958761702;
        points[70] = 0.824536170255780480133434725494634095816369960992382109;
        points[71] = 0.844314144397035220240557020019893007885642704413705486;
        points[72] = 0.863003837629706602570190489180595063884886011815494163;
        points[73] = 0.880581159852041841057713216080658147566397776298470145;
        points[74] = 0.897023454767569367017326260558706439993815747209982633;
        points[75] = 0.912309529094122884382983357958241900636278714509489184;
        points[76] = 0.926419679891237219951464182782721360929554385340338017;
        points[77] = 0.939335719974205747877988092886009230635921825321442135;
        points[78] = 0.951041001389313573919119010523278447884229172195199194;
        points[79] = 0.961520436936073169264229683224874930506868697980601585;
        points[80] = 0.97076051974728427435354730906652230253226916339579217;
        points[81] = 0.978749341003816272426478037569423482079549354651570436;
        points[82] = 0.985476606068420367963807908226506489677366069337711888;
        points[83] = 0.990933650110964570522867823538884007517445869471778344;
        points[84] = 0.995113458137992005945508330416231027159975293631828542;
        points[85] = 0.998010721562982358081678891431846376473477063856642147;
        points[86] = 0.999622350432484272389096185749497565390399490658400321;
        weights[0] = 0.000969109738177075337606534844073158609219399100860734508;
        weights[1] = 0.00225469075375285309248121079524468288253738212014449711;
        weights[2] = 0.00353927165538862854018158597794360363930017609197353381;
        weights[3] = 0.00481945623850188589930869857798673411821144257606209929;
        weights[4] = 0.00609346204763487213010225546423321907894505561300168961;
        weights[5] = 0.00735962364881806366077058272195326059299370954780678178;
        weights[6] = 0.00861630283848895183295010359405048883821094572451843712;
        weights[7] = 0.00986187771370182671658413047915197025086757837002910204;
        weights[8] = 0.0110947419405607192797208445532497634309577771825685036;
        weights[9] = 0.0123133060300480365422870033776865955466501386345657307;
        weights[10] = 0.0135159991182456580818806860732984855439527862773732854;
        weights[11] = 0.0147012708872398422298939219588069862305160296066634053;
        weights[12] = 0.0158675935188263190029217420439597874435765636978634431;
        weights[13] = 0.0170134636430015344336453457845621178853960588406587419;
        weights[14] = 0.0181374042653542520502180437558712984991627845325813938;
        weights[15] = 0.0192379666653565587850506678969678045663623318796190866;
        weights[16] = 0.0203137322606555695265697959360221456532767573670160766;
        weights[17] = 0.021363314433802531593616152250173626956631412817494231;
        weights[18] = 0.0223853603184854782141974991443797293574934476141097821;
        weights[19] = 0.0233785525426601722578239510147896269113004758419777667;
        weights[20] = 0.0243416109261676323392138052124014332994889114605731798;
        weights[21] = 0.0252732941305570731641186103564666982031947513290186319;
        weights[22] = 0.0261724012589335589497255190784256465235825187607078587;
        weights[23] = 0.027037773403735807283977294623090728289450187572927352;
        weights[24] = 0.0278682951404292059896343597691460587621302839935356988;
        weights[25] = 0.0286628959651762183885872833366483073683426794114193866;
        weights[26] = 0.0294205516746230482492247702047457384235583103069247927;
        weights[27] = 0.0301402856860188247439511596049378212336627653850588018;
        weights[28] = 0.0308211702959622341537190428775453963512389728763956492;
        weights[29] = 0.0314623278761507639379622233045357486873011583452691142;
        weights[30] = 0.0320629320045896677776581819429928870453596571477949632;
        weights[31] = 0.032622208530801443925800340678041720061026566843928688;
        weights[32] = 0.0331394365736620235362888366989244014908887649609093156;
        weights[33] = 0.0336139494505769355842222573437893275679560969886330452;
        weights[34] = 0.0340451355367993734551836364704381525233461232917916521;
        weights[35] = 0.0344324390537822437659381927582490663303123029097159181;
        weights[36] = 0.0347753607855478292487112240861533654267739788673218435;
        weights[37] = 0.0350734587221515365566253471912599677435215963253485235;
        weights[38] = 0.0353263486294102136984305309687057106248890720875159864;
        weights[39] = 0.0355337045441605939113347570492830616759378105099849323;
        weights[40] = 0.0356952591944094337764794300999495915595639769389437875;
        weights[41] = 0.0358108043438337417566255992050249211164368889880586844;
        weights[42] = 0.0358801910601870158777352072237696045818057740594291743;
        weights[43] = 0.0359033299072655014420832673421391181493371944038093965;
        weights[44] = 0.0358801910601870158777352072237696045818057740594291743;
        weights[45] = 0.0358108043438337417566255992050249211164368889880586844;
        weights[46] = 0.0356952591944094337764794300999495915595639769389437875;
        weights[47] = 0.0355337045441605939113347570492830616759378105099849323;
        weights[48] = 0.0353263486294102136984305309687057106248890720875159864;
        weights[49] = 0.0350734587221515365566253471912599677435215963253485235;
        weights[50] = 0.0347753607855478292487112240861533654267739788673218435;
        weights[51] = 0.0344324390537822437659381927582490663303123029097159181;
        weights[52] = 0.0340451355367993734551836364704381525233461232917916521;
        weights[53] = 0.0336139494505769355842222573437893275679560969886330452;
        weights[54] = 0.0331394365736620235362888366989244014908887649609093156;
        weights[55] = 0.032622208530801443925800340678041720061026566843928688;
        weights[56] = 0.0320629320045896677776581819429928870453596571477949632;
        weights[57] = 0.0314623278761507639379622233045357486873011583452691142;
        weights[58] = 0.0308211702959622341537190428775453963512389728763956492;
        weights[59] = 0.0301402856860188247439511596049378212336627653850588018;
        weights[60] = 0.0294205516746230482492247702047457384235583103069247927;
        weights[61] = 0.0286628959651762183885872833366483073683426794114193866;
        weights[62] = 0.0278682951404292059896343597691460587621302839935356988;
        weights[63] = 0.027037773403735807283977294623090728289450187572927352;
        weights[64] = 0.0261724012589335589497255190784256465235825187607078587;
        weights[65] = 0.0252732941305570731641186103564666982031947513290186319;
        weights[66] = 0.0243416109261676323392138052124014332994889114605731798;
        weights[67] = 0.0233785525426601722578239510147896269113004758419777667;
        weights[68] = 0.0223853603184854782141974991443797293574934476141097821;
        weights[69] = 0.021363314433802531593616152250173626956631412817494231;
        weights[70] = 0.0203137322606555695265697959360221456532767573670160766;
        weights[71] = 0.0192379666653565587850506678969678045663623318796190866;
        weights[72] = 0.0181374042653542520502180437558712984991627845325813938;
        weights[73] = 0.0170134636430015344336453457845621178853960588406587419;
        weights[74] = 0.0158675935188263190029217420439597874435765636978634431;
        weights[75] = 0.0147012708872398422298939219588069862305160296066634053;
        weights[76] = 0.0135159991182456580818806860732984855439527862773732854;
        weights[77] = 0.0123133060300480365422870033776865955466501386345657307;
        weights[78] = 0.0110947419405607192797208445532497634309577771825685036;
        weights[79] = 0.00986187771370182671658413047915197025086757837002910204;
        weights[80] = 0.00861630283848895183295010359405048883821094572451843712;
        weights[81] = 0.00735962364881806366077058272195326059299370954780678178;
        weights[82] = 0.00609346204763487213010225546423321907894505561300168961;
        weights[83] = 0.00481945623850188589930869857798673411821144257606209929;
        weights[84] = 0.00353927165538862854018158597794360363930017609197353381;
        weights[85] = 0.00225469075375285309248121079524468288253738212014449711;
        weights[86] = 0.000969109738177075337606534844073158609219399100860734508;
        return;
    case 88:
        points[0] = -0.999630836056270655781323305214305365386584383734613322;
        points[1] = -0.998055408053249677606002447275870811548192067884961037;
        points[2] = -0.995223175887988870781101179686137537814596632156369692;
        points[3] = -0.991137078154015555111612198999272226966438925061374086;
        points[4] = -0.985802186087763552283935751841427521787034674090642987;
        points[5] = -0.979225203154296703776892312893896976268613889198973538;
        points[6] = -0.971414410141322276480367510866149171092116434712301729;
        points[7] = -0.962379646063770682989887837116989158008093105049742881;
        points[8] = -0.952132293463802112522033239679696318244932493483238087;
        points[9] = -0.940685263302643545262005131476710619146403697783478727;
        points[10] = -0.928052978394692055580503380497096889553239751534475526;
        points[11] = -0.91425135510452719133997809584604721091369602472645127;
        points[12] = -0.899297783230057054844672906498550424595149633899205088;
        points[13] = -0.883211104059450581623721965407830080934526613225287913;
        points[14] = -0.866011586613781334022913274559504414169857595307629007;
        points[15] = -0.847720902098209087197014518342744484832793529176104735;
        points[16] = -0.828362096590456244850838190093674077791492393611481326;
        points[17] = -0.807959561999236491824533126134410927260942248545256304;
        points[18] = -0.786539005328287157479978973381470256045705738747456954;
        points[19] = -0.764127416284206841967597389772746224972634206339644575;
        points[20] = -0.740753033268607773581767433914688064755047914044780164;
        points[21] = -0.716445307797250485659941889802670291401246952511434326;
        points[22] = -0.691234867390880438020343073446042988307920703260756661;
        points[23] = -0.665153476984453172221993670053620916530286374404378924;
        points[24] = -0.638233998903326450283540740289342854835760765045650815;
        points[25] = -0.610510351456818986239587271031617705870468875658855493;
        points[26] = -0.5820174662012873575807583235459321647006146345523768;
        points[27] = -0.552791243926555472797175822240195638423208089037324052;
        points[28] = -0.522868509421143753727045179076190682882672618004725908;
        points[29] = -0.492286965073286722885887488482286546994372938989974225;
        points[30] = -0.461085143366196510612751277304942810277120387604316441;
        points[31] = -0.429302358327424370211024585478765366799411593444245834;
        points[32] = -0.396978655993491050245983803820688154387137782652602684;
        points[33] = -0.36415476395219828781530114261604892407692577782468883;
        points[34] = -0.330872040026196275109125577647024705044834634018239312;
        points[35] = -0.297172420162464305587542270167969287258618113379840131;
        points[36] = -0.26309836559336260022849801034710564632814169992576445;
        points[37] = -0.228692809335831313896401104272092658777602463036532928;
        points[38] = -0.193999102096146788577960057704802223912843365172956829;
        points[39] = -0.159060957648394215944091062730736761074315439486395217;
        points[40] = -0.123922397755479061647621909752535818296479387968876999;
        points[41] = -0.0886276967020760588046135404284702295483982880318106954;
        points[42] = -0.0532213255094035765219642014163975024377917439443705788;
        points[43] = -0.0177478959021120982889020913579522553070664842012846697;
        points[44] = 0.0177478959021120982889020913579522553070664842012846697;
        points[45] = 0.0532213255094035765219642014163975024377917439443705788;
        points[46] = 0.0886276967020760588046135404284702295483982880318106954;
        points[47] = 0.123922397755479061647621909752535818296479387968876999;
        points[48] = 0.159060957648394215944091062730736761074315439486395217;
        points[49] = 0.193999102096146788577960057704802223912843365172956829;
        points[50] = 0.228692809335831313896401104272092658777602463036532928;
        points[51] = 0.26309836559336260022849801034710564632814169992576445;
        points[52] = 0.297172420162464305587542270167969287258618113379840131;
        points[53] = 0.330872040026196275109125577647024705044834634018239312;
        points[54] = 0.36415476395219828781530114261604892407692577782468883;
        points[55] = 0.396978655993491050245983803820688154387137782652602684;
        points[56] = 0.429302358327424370211024585478765366799411593444245834;
        points[57] = 0.461085143366196510612751277304942810277120387604316441;
        points[58] = 0.492286965073286722885887488482286546994372938989974225;
        points[59] = 0.522868509421143753727045179076190682882672618004725908;
        points[60] = 0.552791243926555472797175822240195638423208089037324052;
        points[61] = 0.5820174662012873575807583235459321647006146345523768;
        points[62] = 0.610510351456818986239587271031617705870468875658855493;
        points[63] = 0.638233998903326450283540740289342854835760765045650815;
        points[64] = 0.665153476984453172221993670053620916530286374404378924;
        points[65] = 0.691234867390880438020343073446042988307920703260756661;
        points[66] = 0.716445307797250485659941889802670291401246952511434326;
        points[67] = 0.740753033268607773581767433914688064755047914044780164;
        points[68] = 0.764127416284206841967597389772746224972634206339644575;
        points[69] = 0.786539005328287157479978973381470256045705738747456954;
        points[70] = 0.807959561999236491824533126134410927260942248545256304;
        points[71] = 0.828362096590456244850838190093674077791492393611481326;
        points[72] = 0.847720902098209087197014518342744484832793529176104735;
        points[73] = 0.866011586613781334022913274559504414169857595307629007;
        points[74] = 0.883211104059450581623721965407830080934526613225287913;
        points[75] = 0.899297783230057054844672906498550424595149633899205088;
        points[76] = 0.91425135510452719133997809584604721091369602472645127;
        points[77] = 0.928052978394692055580503380497096889553239751534475526;
        points[78] = 0.940685263302643545262005131476710619146403697783478727;
        points[79] = 0.952132293463802112522033239679696318244932493483238087;
        points[80] = 0.962379646063770682989887837116989158008093105049742881;
        points[81] = 0.971414410141322276480367510866149171092116434712301729;
        points[82] = 0.979225203154296703776892312893896976268613889198973538;
        points[83] = 0.985802186087763552283935751841427521787034674090642987;
        points[84] = 0.991137078154015555111612198999272226966438925061374086;
        points[85] = 0.995223175887988870781101179686137537814596632156369692;
        points[86] = 0.998055408053249677606002447275870811548192067884961037;
        points[87] = 0.999630836056270655781323305214305365386584383734613322;
        weights[0] = 0.000947335598161927266771246363854571245435691877014451994;
        weights[1] = 0.00220405856314369662854005044863567647201280029545016244;
        weights[2] = 0.00345986766786279642397536614537204515583572292782785025;
        weights[3] = 0.00471147927959866174302181468910030598096573529194186063;
        weights[4] = 0.00595718699613804658312938493184717004588249483215112398;
        weights[5] = 0.00719539845979637205975995832168083337564673043671418749;
        weights[6] = 0.00842454749270247301509858127620447434452397129245114041;
        weights[7] = 0.00964308332205320440077019026562435726665859078763337087;
        weights[8] = 0.0108494697754292712594018436429298723001815506766989689;
        weights[9] = 0.0120421864395812123097395529418040787809847198282815245;
        weights[10] = 0.0132197303136279117081813349508989914718121700127887443;
        weights[11] = 0.0143806176012999442359345921216224050120562904659973972;
        weights[12] = 0.0155233855369335538401648163475402111118620810031264212;
        weights[13] = 0.0166465942082176560451128233344095567697192902843812941;
        weights[14] = 0.0177488283603240745564950651508932551005104397831604584;
        weights[15] = 0.0188286991737554513947100394321205214392487174939884547;
        weights[16] = 0.019884846011274113243600999308091108461812221192456978;
        weights[17] = 0.0209159381305766242322542794019033036623100879566828222;
        weights[18] = 0.0219206763599898535956343880689520662321049555121511457;
        weights[19] = 0.0228977947347811423272477950965091380866088928538746899;
        weights[20] = 0.0238460620918596612635786196630022409325371012528095238;
        weights[21] = 0.0247642836207687330253214953251406589360170419239252666;
        weights[22] = 0.0256513023689619478847793550240758632861712457730974923;
        weights[23] = 0.0265060006994347377214089018936688661016683362381880609;
        weights[24] = 0.0273273016988553308356238087979413937524079111887436483;
        weights[25] = 0.0281141705344086134915789398240334656162605925454933443;
        weights[26] = 0.0288656157576354292464769854544929165351360366820725165;
        weights[27] = 0.0295806905536193491133523956018877656234313908787835484;
        weights[28] = 0.0302584939339435253351374324604073600561601942335557422;
        weights[29] = 0.0308981718719121976337028795634572098425758138740644667;
        weights[30] = 0.0314989183786048923200417516427941725300124296778586518;
        weights[31] = 0.0320599765184063880692669641769384810712027174849446108;
        weights[32] = 0.0325806393627321086862394297547169330052777499986105223;
        weights[33] = 0.0330602508807467001452807467610328162216104951597634598;
        weights[34] = 0.0334982067659530925280651621502652463016540939604318749;
        weights[35] = 0.0338939551976102592398925375054796215224274268059331199;
        weights[36] = 0.0342469975360200787373695975885978553509224580201145498;
        weights[37] = 0.0345568889508070841348653139789570453060301383379540644;
        weights[38] = 0.0348232389813993549931290463186540148591281191774683626;
        weights[39] = 0.0350457120290042613965862097017689665478360421364927988;
        weights[40] = 0.0352240277794591085328786718524109618300554470040637458;
        weights[41] = 0.0353579615564238437936690271432532118430600658581031381;
        weights[42] = 0.0354473446044707697061431526180094607083247197468516179;
        weights[43] = 0.0354920643017145452960674529590195299039192772359028261;
        weights[44] = 0.0354920643017145452960674529590195299039192772359028261;
        weights[45] = 0.0354473446044707697061431526180094607083247197468516179;
        weights[46] = 0.0353579615564238437936690271432532118430600658581031381;
        weights[47] = 0.0352240277794591085328786718524109618300554470040637458;
        weights[48] = 0.0350457120290042613965862097017689665478360421364927988;
        weights[49] = 0.0348232389813993549931290463186540148591281191774683626;
        weights[50] = 0.0345568889508070841348653139789570453060301383379540644;
        weights[51] = 0.0342469975360200787373695975885978553509224580201145498;
        weights[52] = 0.0338939551976102592398925375054796215224274268059331199;
        weights[53] = 0.0334982067659530925280651621502652463016540939604318749;
        weights[54] = 0.0330602508807467001452807467610328162216104951597634598;
        weights[55] = 0.0325806393627321086862394297547169330052777499986105223;
        weights[56] = 0.0320599765184063880692669641769384810712027174849446108;
        weights[57] = 0.0314989183786048923200417516427941725300124296778586518;
        weights[58] = 0.0308981718719121976337028795634572098425758138740644667;
        weights[59] = 0.0302584939339435253351374324604073600561601942335557422;
        weights[60] = 0.0295806905536193491133523956018877656234313908787835484;
        weights[61] = 0.0288656157576354292464769854544929165351360366820725165;
        weights[62] = 0.0281141705344086134915789398240334656162605925454933443;
        weights[63] = 0.0273273016988553308356238087979413937524079111887436483;
        weights[64] = 0.0265060006994347377214089018936688661016683362381880609;
        weights[65] = 0.0256513023689619478847793550240758632861712457730974923;
        weights[66] = 0.0247642836207687330253214953251406589360170419239252666;
        weights[67] = 0.0238460620918596612635786196630022409325371012528095238;
        weights[68] = 0.0228977947347811423272477950965091380866088928538746899;
        weights[69] = 0.0219206763599898535956343880689520662321049555121511457;
        weights[70] = 0.0209159381305766242322542794019033036623100879566828222;
        weights[71] = 0.019884846011274113243600999308091108461812221192456978;
        weights[72] = 0.0188286991737554513947100394321205214392487174939884547;
        weights[73] = 0.0177488283603240745564950651508932551005104397831604584;
        weights[74] = 0.0166465942082176560451128233344095567697192902843812941;
        weights[75] = 0.0155233855369335538401648163475402111118620810031264212;
        weights[76] = 0.0143806176012999442359345921216224050120562904659973972;
        weights[77] = 0.0132197303136279117081813349508989914718121700127887443;
        weights[78] = 0.0120421864395812123097395529418040787809847198282815245;
        weights[79] = 0.0108494697754292712594018436429298723001815506766989689;
        weights[80] = 0.00964308332205320440077019026562435726665859078763337087;
        weights[81] = 0.00842454749270247301509858127620447434452397129245114041;
        weights[82] = 0.00719539845979637205975995832168083337564673043671418749;
        weights[83] = 0.00595718699613804658312938493184717004588249483215112398;
        weights[84] = 0.00471147927959866174302181468910030598096573529194186063;
        weights[85] = 0.00345986766786279642397536614537204515583572292782785025;
        weights[86] = 0.00220405856314369662854005044863567647201280029545016244;
        weights[87] = 0.000947335598161927266771246363854571245435691877014451994;
        return;
    case 89:
        points[0] = -0.999639038864533459581454128691478560762616968769958304;
        points[1] = -0.998098605710273929484265080649175413772974293537890397;
        points[2] = -0.995329240406749760327228223128720527907400456695134301;
        points[3] = -0.991333738808665300673174703823355780369077757697648592;
        points[4] = -0.986116947861103674004151316045079423509046809324573813;
        points[5] = -0.979685276583876641129616524844196235463657067066525026;
        points[6] = -0.97204664274890935970416461860227129041158065648120928;
        points[7] = -0.963210454656535441853845356349271061107242443432106218;
        points[8] = -0.953187597292840940578782389765535649736866898982382921;
        points[9] = -0.9419904181702149190678786898651335378030552739199298;
        points[10] = -0.929632711823718603373074061197521139799938133929450658;
        points[11] = -0.916129702688823431211062425026411475724729245157031825;
        points[12] = -0.901498026283997752087531205278411079797077856094555704;
        points[13] = -0.885755708684469948280780672175162182257715685481859107;
        points[14] = -0.868922144297083719255345284077279828111552243214114405;
        points[15] = -0.851018071956677446875566874663942766276577842080003419;
        points[16] = -0.832065549370079127108473140185363885546512824237973281;
        points[17] = -0.812087925937486030236493416990236553536165745273050149;
        points[18] = -0.791109813983793371456487618748169042736933608791124993;
        points[19] = -0.769157058434801100328116588867057031076347256252120431;
        points[20] = -0.74625670497536000938088999361382192296128936225374559;
        points[21] = -0.72243696672850824337039996081356388727444452367546937;
        points[22] = -0.697727189496539905894596229470512996336165419449917766;
        points[23] = -0.672157815606759550822669967365789770755169446732129029;
        points[24] = -0.645760346406419848716586825259593922175885357652317009;
        points[25] = -0.618567303453019120698681242117347263161956898621047806;
        points[26] = -0.590612188447752393043094573999011226485338724136444107;
        points[27] = -0.561929441961464304933287778854821754218592230553197283;
        points[28] = -0.532554401003943956969124821197444503353687063598513557;
        points[29] = -0.502523255488829551445760041748311936732418898938242961;
        points[30] = -0.471873003647753163790075610801141928759135616995683991;
        points[31] = -0.44064140644865181859485029422786886145559746643235944;
        points[32] = -0.408866941074398818696415454976332084282891565849541469;
        points[33] = -0.376588753519067603880406152474985657055193252077508373;
        points[34] = -0.343846610360227952477910770481199456855663592636038413;
        points[35] = -0.310680849766689799743267191895015568366395471992434493;
        points[36] = -0.277132331802052117947072883935868743118113609404435083;
        points[37] = -0.243242388085282049589001028575769193603778540264810077;
        points[38] = -0.209052770870341755872910385827209083653770333530961005;
        points[39] = -0.174605601607596274075495096940797564323408444094077697;
        points[40] = -0.139943319050374196667503800108747821061331823349967111;
        points[41] = -0.105108626970613411698690916273986979269883239011060262;
        points[42] = -0.0701444415480057921325572183314057569856594374052061755;
        points[43] = -0.0350938384974570013847471580908925466956068790777640308;
        points[44] = 0;
        points[45] = 0.0350938384974570013847471580908925466956068790777640308;
        points[46] = 0.0701444415480057921325572183314057569856594374052061755;
        points[47] = 0.105108626970613411698690916273986979269883239011060262;
        points[48] = 0.139943319050374196667503800108747821061331823349967111;
        points[49] = 0.174605601607596274075495096940797564323408444094077697;
        points[50] = 0.209052770870341755872910385827209083653770333530961005;
        points[51] = 0.243242388085282049589001028575769193603778540264810077;
        points[52] = 0.277132331802052117947072883935868743118113609404435083;
        points[53] = 0.310680849766689799743267191895015568366395471992434493;
        points[54] = 0.343846610360227952477910770481199456855663592636038413;
        points[55] = 0.376588753519067603880406152474985657055193252077508373;
        points[56] = 0.408866941074398818696415454976332084282891565849541469;
        points[57] = 0.44064140644865181859485029422786886145559746643235944;
        points[58] = 0.471873003647753163790075610801141928759135616995683991;
        points[59] = 0.502523255488829551445760041748311936732418898938242961;
        points[60] = 0.532554401003943956969124821197444503353687063598513557;
        points[61] = 0.561929441961464304933287778854821754218592230553197283;
        points[62] = 0.590612188447752393043094573999011226485338724136444107;
        points[63] = 0.618567303453019120698681242117347263161956898621047806;
        points[64] = 0.645760346406419848716586825259593922175885357652317009;
        points[65] = 0.672157815606759550822669967365789770755169446732129029;
        points[66] = 0.697727189496539905894596229470512996336165419449917766;
        points[67] = 0.72243696672850824337039996081356388727444452367546937;
        points[68] = 0.74625670497536000938088999361382192296128936225374559;
        points[69] = 0.769157058434801100328116588867057031076347256252120431;
        points[70] = 0.791109813983793371456487618748169042736933608791124993;
        points[71] = 0.812087925937486030236493416990236553536165745273050149;
        points[72] = 0.832065549370079127108473140185363885546512824237973281;
        points[73] = 0.851018071956677446875566874663942766276577842080003419;
        points[74] = 0.868922144297083719255345284077279828111552243214114405;
        points[75] = 0.885755708684469948280780672175162182257715685481859107;
        points[76] = 0.901498026283997752087531205278411079797077856094555704;
        points[77] = 0.916129702688823431211062425026411475724729245157031825;
        points[78] = 0.929632711823718603373074061197521139799938133929450658;
        points[79] = 0.9419904181702149190678786898651335378030552739199298;
        points[80] = 0.953187597292840940578782389765535649736866898982382921;
        points[81] = 0.963210454656535441853845356349271061107242443432106218;
        points[82] = 0.97204664274890935970416461860227129041158065648120928;
        points[83] = 0.979685276583876641129616524844196235463657067066525026;
        points[84] = 0.986116947861103674004151316045079423509046809324573813;
        points[85] = 0.991333738808665300673174703823355780369077757697648592;
        points[86] = 0.995329240406749760327228223128720527907400456695134301;
        points[87] = 0.998098605710273929484265080649175413772974293537890397;
        points[88] = 0.999639038864533459581454128691478560762616968769958304;
        weights[0] = 0.000926287105193472815530427432001525301335613313403645588;
        weights[1] = 0.0021551125822191137646356391258611176083492401527097842;
        weights[2] = 0.00338310479240745513263419896717055112243083998395322846;
        weights[3] = 0.00460708734346324143305481636904115807710256690332275193;
        weights[4] = 0.00582542578877010745964465375130247066726883262028723021;
        weights[5] = 0.00703659687098911413739019878816718436305280639546989197;
        weights[6] = 0.00823910252538907873057285088760168107931764095802427302;
        weights[7] = 0.00943145926079789053971093961078375582650523394865361791;
        weights[8] = 0.0106121972899721880326807253777263513014495634611952406;
        weights[9] = 0.0117798615808748921766191553888873776605086327571927636;
        weights[10] = 0.0129330133926026772915864974676500606293186243481843303;
        weights[11] = 0.0140702319486444828138872260948703198362304355732701811;
        weights[12] = 0.0151901161446661233974731423775399627721544251890652867;
        weights[13] = 0.0162912862547923845775409647625996884142202568339155597;
        weights[14] = 0.0173723856215024016696408445473634977466821706631213496;
        weights[15] = 0.0184320823217841156758459606283476818475043355774717704;
        weights[16] = 0.0194690708051518731386745257878746340207959192471417003;
        weights[17] = 0.020482073500400270212245011276061895578701682291224876;
        weights[18] = 0.0214698423885611408434126856553615748146038573087330488;
        weights[19] = 0.0224311605398363671283588361280518737033816104733358385;
        weights[20] = 0.0233648436124554458271687542613841198802952142415795212;
        weights[21] = 0.0242697413115223392736616203714754037763681968967681713;
        weights[22] = 0.0251447388060025686228155160936454550175078756369468877;
        weights[23] = 0.0259887581020738362514814094771669636795689337633321523;
        weights[24] = 0.0268007593711291777125656353318410850355097938730970062;
        weights[25] = 0.0275797422307845825334773620296621719716521240840181496;
        weights[26] = 0.0283247469773052072280348402016246521847195597988200105;
        weights[27] = 0.0290348557679268118300193238552030052962779007666079885;
        weights[28] = 0.0297091937516124596273020280091647693107176566632083671;
        weights[29] = 0.0303469301468491293434077135432252303497336817864842434;
        weights[30] = 0.0309472792651548447894789597858015128653520130205309307;
        weights[31] = 0.0315095014790342836587985691591136004427866266303242546;
        weights[32] = 0.0320329041331895855070315635864694108773212794219945941;
        weights[33] = 0.0325168423978632069675856667135208402008579756614456152;
        weights[34] = 0.0329607200632611170742922822299296582909258674399569518;
        weights[35] = 0.0333639902740773209397192590003098191084338772636050835;
        weights[36] = 0.0337261562032145707063095038986984192444296320780025522;
        weights[37] = 0.0340467716638710871673558597484123853338792819599427853;
        weights[38] = 0.034325441659239087817965419842009141419943083899133669;
        weights[39] = 0.0345618228691378081364338257323415671877955071148932709;
        weights[40] = 0.034755624072981420920811511875417882277438344110275561;
        weights[41] = 0.0349066065085607098910114915808540163523043461399235875;
        weights[42] = 0.0350145841661964433691530435967665177956160229915110863;
        weights[43] = 0.0350794240179020253171675953077057530102678064522085307;
        weights[44] = 0.0351010461812730770316238886879845134387662206114253208;
        weights[45] = 0.0350794240179020253171675953077057530102678064522085307;
        weights[46] = 0.0350145841661964433691530435967665177956160229915110863;
        weights[47] = 0.0349066065085607098910114915808540163523043461399235875;
        weights[48] = 0.034755624072981420920811511875417882277438344110275561;
        weights[49] = 0.0345618228691378081364338257323415671877955071148932709;
        weights[50] = 0.034325441659239087817965419842009141419943083899133669;
        weights[51] = 0.0340467716638710871673558597484123853338792819599427853;
        weights[52] = 0.0337261562032145707063095038986984192444296320780025522;
        weights[53] = 0.0333639902740773209397192590003098191084338772636050835;
        weights[54] = 0.0329607200632611170742922822299296582909258674399569518;
        weights[55] = 0.0325168423978632069675856667135208402008579756614456152;
        weights[56] = 0.0320329041331895855070315635864694108773212794219945941;
        weights[57] = 0.0315095014790342836587985691591136004427866266303242546;
        weights[58] = 0.0309472792651548447894789597858015128653520130205309307;
        weights[59] = 0.0303469301468491293434077135432252303497336817864842434;
        weights[60] = 0.0297091937516124596273020280091647693107176566632083671;
        weights[61] = 0.0290348557679268118300193238552030052962779007666079885;
        weights[62] = 0.0283247469773052072280348402016246521847195597988200105;
        weights[63] = 0.0275797422307845825334773620296621719716521240840181496;
        weights[64] = 0.0268007593711291777125656353318410850355097938730970062;
        weights[65] = 0.0259887581020738362514814094771669636795689337633321523;
        weights[66] = 0.0251447388060025686228155160936454550175078756369468877;
        weights[67] = 0.0242697413115223392736616203714754037763681968967681713;
        weights[68] = 0.0233648436124554458271687542613841198802952142415795212;
        weights[69] = 0.0224311605398363671283588361280518737033816104733358385;
        weights[70] = 0.0214698423885611408434126856553615748146038573087330488;
        weights[71] = 0.020482073500400270212245011276061895578701682291224876;
        weights[72] = 0.0194690708051518731386745257878746340207959192471417003;
        weights[73] = 0.0184320823217841156758459606283476818475043355774717704;
        weights[74] = 0.0173723856215024016696408445473634977466821706631213496;
        weights[75] = 0.0162912862547923845775409647625996884142202568339155597;
        weights[76] = 0.0151901161446661233974731423775399627721544251890652867;
        weights[77] = 0.0140702319486444828138872260948703198362304355732701811;
        weights[78] = 0.0129330133926026772915864974676500606293186243481843303;
        weights[79] = 0.0117798615808748921766191553888873776605086327571927636;
        weights[80] = 0.0106121972899721880326807253777263513014495634611952406;
        weights[81] = 0.00943145926079789053971093961078375582650523394865361791;
        weights[82] = 0.00823910252538907873057285088760168107931764095802427302;
        weights[83] = 0.00703659687098911413739019878816718436305280639546989197;
        weights[84] = 0.00582542578877010745964465375130247066726883262028723021;
        weights[85] = 0.00460708734346324143305481636904115807710256690332275193;
        weights[86] = 0.00338310479240745513263419896717055112243083998395322846;
        weights[87] = 0.0021551125822191137646356391258611176083492401527097842;
        weights[88] = 0.000926287105193472815530427432001525301335613313403645588;
        return;
    case 90:
        points[0] = -0.999646971286638437463248450036529905440311818735888551;
        points[1] = -0.998140379938568153561305618953067835072376215143348148;
        points[2] = -0.995431812058344663926755406970786433156976657738727864;
        points[3] = -0.99152392881106278612914692430217948880601242903662987;
        points[4] = -0.986421365057832848734254057112423009228298197871279079;
        points[5] = -0.980130251345148385458953222812292650415564926566829588;
        points[6] = -0.972658162090193139997464830445228620133928785452382721;
        points[7] = -0.964014098171505483393666591970162318013595118462241411;
        points[8] = -0.95420847388150033616072026336948023829072571917236113;
        points[9] = -0.943253103645357768153575216428200747545501429577251916;
        points[10] = -0.93116118750043200700584661222945753392303706996788031;
        points[11] = -0.917947295066586383372356315970884314118808835378778405;
        points[12] = -0.90362734793130269386998558261532724014816668249019277;
        points[13] = -0.888218600434745981298375725559433993133040443310076325;
        points[14] = -0.871739618862903434474027887638563424103463236715035853;
        points[15] = -0.854210259067071882286021508597155444032545870695895225;
        points[16] = -0.835651642533377045564199152014447703577986735931598305;
        points[17] = -0.816086130929481056443753617370403895186094353927190018;
        points[18] = -0.795537299158248134863600587483460045320192634246573681;
        points[19] = -0.774029906950334246806957991699956636104425892790894755;
        points[20] = -0.751589869029638468178415202477978628929505460087142065;
        points[21] = -0.72824422388739036362579949768585383163504910348475192;
        points[22] = -0.704021101202391143555469364207119098830043987389267836;
        points[23] = -0.678949687946597146181268645280289087755984500639587644;
        points[24] = -0.653060193216842191961262116286676474307119022721300107;
        points[25] = -0.626383811835045126762609331696754194675158059243979083;
        points[26] = -0.598952686760742185888769383038813747359727746729126866;
        points[27] = -0.570799870361220978705361671412247345057625373003680378;
        points[28] = -0.541959284585913426189304504840911877628992181594799666;
        points[29] = -0.512465680093027970988462488278230420909134734724569028;
        points[30] = -0.482354594377665692520121221950974222913029135565124695;
        points[31] = -0.45166230895186936757637863295448285407603020012438627;
        points[32] = -0.420425805628197756101395445870356536543129323971209249;
        points[33] = -0.388682721959498206776509085806602300400947990159291589;
        points[34] = -0.356471305888567846131188515045608594746750167628365129;
        points[35] = -0.323830369662345966511395248499410078831102459907956517;
        points[36] = -0.290799243066166651549602120227442527846327543300500202;
        points[37] = -0.257417726034420129920887566793180033171913824302447017;
        points[38] = -0.223726040694722859268958407399448139355602205857815495;
        points[39] = -0.189764782903379019020874253181167886653503082453265743;
        points[40] = -0.155574873330529119511405126371919786866127410301570827;
        points[41] = -0.121197508153924082968749277397529167925153553154092804;
        points[42] = -0.0866741094207347700852365464770847166192082905960724302;
        points[43] = -0.0520462751372069490592787303842848510544633812652962427;
        points[44] = -0.0173557291462996524612983727081818825521528692461744514;
        points[45] = 0.0173557291462996524612983727081818825521528692461744514;
        points[46] = 0.0520462751372069490592787303842848510544633812652962427;
        points[47] = 0.0866741094207347700852365464770847166192082905960724302;
        points[48] = 0.121197508153924082968749277397529167925153553154092804;
        points[49] = 0.155574873330529119511405126371919786866127410301570827;
        points[50] = 0.189764782903379019020874253181167886653503082453265743;
        points[51] = 0.223726040694722859268958407399448139355602205857815495;
        points[52] = 0.257417726034420129920887566793180033171913824302447017;
        points[53] = 0.290799243066166651549602120227442527846327543300500202;
        points[54] = 0.323830369662345966511395248499410078831102459907956517;
        points[55] = 0.356471305888567846131188515045608594746750167628365129;
        points[56] = 0.388682721959498206776509085806602300400947990159291589;
        points[57] = 0.420425805628197756101395445870356536543129323971209249;
        points[58] = 0.45166230895186936757637863295448285407603020012438627;
        points[59] = 0.482354594377665692520121221950974222913029135565124695;
        points[60] = 0.512465680093027970988462488278230420909134734724569028;
        points[61] = 0.541959284585913426189304504840911877628992181594799666;
        points[62] = 0.570799870361220978705361671412247345057625373003680378;
        points[63] = 0.598952686760742185888769383038813747359727746729126866;
        points[64] = 0.626383811835045126762609331696754194675158059243979083;
        points[65] = 0.653060193216842191961262116286676474307119022721300107;
        points[66] = 0.678949687946597146181268645280289087755984500639587644;
        points[67] = 0.704021101202391143555469364207119098830043987389267836;
        points[68] = 0.72824422388739036362579949768585383163504910348475192;
        points[69] = 0.751589869029638468178415202477978628929505460087142065;
        points[70] = 0.774029906950334246806957991699956636104425892790894755;
        points[71] = 0.795537299158248134863600587483460045320192634246573681;
        points[72] = 0.816086130929481056443753617370403895186094353927190018;
        points[73] = 0.835651642533377045564199152014447703577986735931598305;
        points[74] = 0.854210259067071882286021508597155444032545870695895225;
        points[75] = 0.871739618862903434474027887638563424103463236715035853;
        points[76] = 0.888218600434745981298375725559433993133040443310076325;
        points[77] = 0.90362734793130269386998558261532724014816668249019277;
        points[78] = 0.917947295066586383372356315970884314118808835378778405;
        points[79] = 0.93116118750043200700584661222945753392303706996788031;
        points[80] = 0.943253103645357768153575216428200747545501429577251916;
        points[81] = 0.95420847388150033616072026336948023829072571917236113;
        points[82] = 0.964014098171505483393666591970162318013595118462241411;
        points[83] = 0.972658162090193139997464830445228620133928785452382721;
        points[84] = 0.980130251345148385458953222812292650415564926566829588;
        points[85] = 0.986421365057832848734254057112423009228298197871279079;
        points[86] = 0.99152392881106278612914692430217948880601242903662987;
        points[87] = 0.995431812058344663926755406970786433156976657738727864;
        points[88] = 0.998140379938568153561305618953067835072376215143348148;
        points[89] = 0.999646971286638437463248450036529905440311818735888551;
        weights[0] = 0.000905932371214833093724514208676867618320676464809921794;
        weights[1] = 0.00210777877452632989147570567786679955119175617230989633;
        weights[2] = 0.00330886724333601819543178369482621426975329077016628104;
        weights[3] = 0.00450612361367497786413799637464266160768424776908905655;
        weights[4] = 0.00569798156074735260084782204535913539752522221338541358;
        weights[5] = 0.00688298320846328431473007048696900552589278179463065836;
        weights[6] = 0.00805969494462001565867178776568157549821365563090271353;
        weights[7] = 0.0092266969577419909403196983823566215340408844616600477;
        weights[8] = 0.0103825823098932146138077066652438224225600426103104291;
        weights[9] = 0.0115259578891480588505937631794883233030700057209761;
        weights[10] = 0.0126554458371681288688760239416174371578300258947702787;
        weights[11] = 0.0137696851123370934307514036294055186697533595222099476;
        weights[12] = 0.0148673330880433240503845797896002474947130532146155911;
        weights[13] = 0.0159470671510066390132068013372140191697474780560639888;
        weights[14] = 0.0170075862852226757093973341213835670672606407841280678;
        weights[15] = 0.0180476126344602361640497073919141668280447375358252624;
        weights[16] = 0.0190658930391373184253235301262648335214900066014380075;
        weights[17] = 0.0200612005446395959645324726142401557495367077277554206;
        weights[18] = 0.0210323358787225631170623196214244601977580042586225514;
        weights[19] = 0.0219781288959341338386918188398510663651080119436177561;
        weights[20] = 0.0228974399871631846349886389888329367973649642012700839;
        weights[21] = 0.0237891614525287232101008844471321631903659204467770424;
        weights[22] = 0.0246522188359048529359660620629704887104454842156381383;
        weights[23] = 0.0254855722194432284844673207476370614847954085235005365;
        weights[24] = 0.0262882174765145873615958882973237405614553876881367159;
        weights[25] = 0.0270591874815479585216142354496520911533816147895932213;
        weights[26] = 0.0277975532753022751580386497773601975251250912120537287;
        weights[27] = 0.0285024251841614163187553339309557944885986626216237181;
        weights[28] = 0.0291729538921007424865579906301615887103473470305904611;
        weights[29] = 0.0298083314640312754871478354582798107981485580420530805;
        weights[30] = 0.0304077923192869526903943309389610462462739971488387173;
        weights[31] = 0.0309706141540809209459366049180368106687358279461365345;
        weights[32] = 0.0314961188118186360769579304529577022146495221476710395;
        weights[33] = 0.0319836731002185760394559754354448613126726694709223921;
        weights[34] = 0.0324326895542556169117895440515501988213467782878730669;
        weights[35] = 0.0328426271440075045786302847995380084443702081107652869;
        weights[36] = 0.0332129919265513165140408290865795105328088652719689424;
        weights[37] = 0.0335433376411242766829331069386480136080141608377020992;
        weights[38] = 0.0338332662468316872579275082464883578341080433542262385;
        weights[39] = 0.0340824284022539954636050217599882841322349842871416595;
        weights[40] = 0.0342905238863750419316973050281440777564662780010161899;
        weights[41] = 0.0344573019603242561745956387045695363224927732375644249;
        weights[42] = 0.0345825616694968914180537973084053236838752700836177067;
        weights[43] = 0.0346661520856882401882723085219480732094601594826840011;
        weights[44] = 0.0347079724889500579204601341244078228429674344133475839;
        weights[45] = 0.0347079724889500579204601341244078228429674344133475839;
        weights[46] = 0.0346661520856882401882723085219480732094601594826840011;
        weights[47] = 0.0345825616694968914180537973084053236838752700836177067;
        weights[48] = 0.0344573019603242561745956387045695363224927732375644249;
        weights[49] = 0.0342905238863750419316973050281440777564662780010161899;
        weights[50] = 0.0340824284022539954636050217599882841322349842871416595;
        weights[51] = 0.0338332662468316872579275082464883578341080433542262385;
        weights[52] = 0.0335433376411242766829331069386480136080141608377020992;
        weights[53] = 0.0332129919265513165140408290865795105328088652719689424;
        weights[54] = 0.0328426271440075045786302847995380084443702081107652869;
        weights[55] = 0.0324326895542556169117895440515501988213467782878730669;
        weights[56] = 0.0319836731002185760394559754354448613126726694709223921;
        weights[57] = 0.0314961188118186360769579304529577022146495221476710395;
        weights[58] = 0.0309706141540809209459366049180368106687358279461365345;
        weights[59] = 0.0304077923192869526903943309389610462462739971488387173;
        weights[60] = 0.0298083314640312754871478354582798107981485580420530805;
        weights[61] = 0.0291729538921007424865579906301615887103473470305904611;
        weights[62] = 0.0285024251841614163187553339309557944885986626216237181;
        weights[63] = 0.0277975532753022751580386497773601975251250912120537287;
        weights[64] = 0.0270591874815479585216142354496520911533816147895932213;
        weights[65] = 0.0262882174765145873615958882973237405614553876881367159;
        weights[66] = 0.0254855722194432284844673207476370614847954085235005365;
        weights[67] = 0.0246522188359048529359660620629704887104454842156381383;
        weights[68] = 0.0237891614525287232101008844471321631903659204467770424;
        weights[69] = 0.0228974399871631846349886389888329367973649642012700839;
        weights[70] = 0.0219781288959341338386918188398510663651080119436177561;
        weights[71] = 0.0210323358787225631170623196214244601977580042586225514;
        weights[72] = 0.0200612005446395959645324726142401557495367077277554206;
        weights[73] = 0.0190658930391373184253235301262648335214900066014380075;
        weights[74] = 0.0180476126344602361640497073919141668280447375358252624;
        weights[75] = 0.0170075862852226757093973341213835670672606407841280678;
        weights[76] = 0.0159470671510066390132068013372140191697474780560639888;
        weights[77] = 0.0148673330880433240503845797896002474947130532146155911;
        weights[78] = 0.0137696851123370934307514036294055186697533595222099476;
        weights[79] = 0.0126554458371681288688760239416174371578300258947702787;
        weights[80] = 0.0115259578891480588505937631794883233030700057209761;
        weights[81] = 0.0103825823098932146138077066652438224225600426103104291;
        weights[82] = 0.0092266969577419909403196983823566215340408844616600477;
        weights[83] = 0.00805969494462001565867178776568157549821365563090271353;
        weights[84] = 0.00688298320846328431473007048696900552589278179463065836;
        weights[85] = 0.00569798156074735260084782204535913539752522221338541358;
        weights[86] = 0.00450612361367497786413799637464266160768424776908905655;
        weights[87] = 0.00330886724333601819543178369482621426975329077016628104;
        weights[88] = 0.00210777877452632989147570567786679955119175617230989633;
        weights[89] = 0.000905932371214833093724514208676867618320676464809921794;
        return;
    case 91:
        points[0] = -0.999654645076576130382989227515597563656832743077605154;
        points[1] = -0.998180792590534754673220140020205897297799157794282507;
        points[2] = -0.9955310425053524536893831182064874353682566026891659;
        points[3] = -0.99170792881727710156762025503223837464856502757795066;
        points[4] = -0.986715885723469786907936385937422161641316371942370113;
        points[5] = -0.980560780241213439036862799957754592362509402029375782;
        points[6] = -0.97324986183069073432246752375461367009682669030939183;
        points[7] = -0.964791745747276075776495103702787255466990075472382081;
        points[8] = -0.955196400732276363874021897272205421990346978866176982;
        points[9] = -0.944475136545718668062791481282661749580152882993897003;
        points[10] = -0.932640590356264406612214487853506931360165308956785065;
        points[11] = -0.919706711723450488141330604789459287800724992654457299;
        points[12] = -0.905688746096571865002580532751926096589893192071751914;
        points[13] = -0.89060321681439740379149866598567505135776067905444388;
        points[14] = -0.874467905612230385893604643693701201001877881317353018;
        points[15] = -0.857301831652642579078184410158914731907389118138914372;
        points[16] = -0.839125229101387031796118461456726383222939554200154474;
        points[17] = -0.819959523273280333976318164186844696309416758173168991;
        points[18] = -0.79982730537529224065049025181448369275065479541380371;
        points[19] = -0.778752305876122344694652910716029923327254381493052023;
        points[20] = -0.756759366533369288592606731652972908809584201304494444;
        points[21] = -0.733874411111094782254467801313768918081957901304737665;
        points[22] = -0.710124414822193871743145495795752922900956401628652886;
        points[23] = -0.685537372531524655146344202941148313870373783315464068;
        points[24] = -0.660142265757234790190264552440185603514855044142893891;
        points[25] = -0.633969028509153281498803697731992966916940034531068588;
        points[26] = -0.60704851200449605277823559498322918874432011490667947;
        points[27] = -0.579412448302463132325791960076963297957074612286356427;
        points[28] = -0.551093412900583559842207845114741393619531411928996576;
        points[29] = -0.522124786336890588473257049700045318355758375647809858;
        points[30] = -0.492540714843183417561821755601973099228503423189420106;
        points[31] = -0.46237607009575145163824651607415232302816147339994071;
        points[32] = -0.431666408111001803186172763086980179693694562573473339;
        points[33] = -0.40044792733443930503032520640641593353516563012585975;
        points[34] = -0.36875742597239956286238846332090367888408792257928499;
        points[35] = -0.336632258616828491012942440829618879441021574637457644;
        points[36] = -0.304110292214235318462596312780901424656523970519217997;
        points[37] = -0.27122986143071926939008513195201473738922132884583758;
        points[38] = -0.238029723465682118992550495973161931326151235623699415;
        points[39] = -0.204549012367488773656851060619249029963359415154583335;
        points[40] = -0.170827192904925167218355600231733802191929731993729156;
        points[41] = -0.136904014048826416020621807715359448207770939738499441;
        points[42] = -0.102819462118707721920624841465695667367056207627511945;
        points[43] = -0.0686137136496254157503652228138108699089989056092946652;
        points[44] = -0.0343270880348253308469914158137768990152474437851910779;
        points[45] = 0;
        points[46] = 0.0343270880348253308469914158137768990152474437851910779;
        points[47] = 0.0686137136496254157503652228138108699089989056092946652;
        points[48] = 0.102819462118707721920624841465695667367056207627511945;
        points[49] = 0.136904014048826416020621807715359448207770939738499441;
        points[50] = 0.170827192904925167218355600231733802191929731993729156;
        points[51] = 0.204549012367488773656851060619249029963359415154583335;
        points[52] = 0.238029723465682118992550495973161931326151235623699415;
        points[53] = 0.27122986143071926939008513195201473738922132884583758;
        points[54] = 0.304110292214235318462596312780901424656523970519217997;
        points[55] = 0.336632258616828491012942440829618879441021574637457644;
        points[56] = 0.36875742597239956286238846332090367888408792257928499;
        points[57] = 0.40044792733443930503032520640641593353516563012585975;
        points[58] = 0.431666408111001803186172763086980179693694562573473339;
        points[59] = 0.46237607009575145163824651607415232302816147339994071;
        points[60] = 0.492540714843183417561821755601973099228503423189420106;
        points[61] = 0.522124786336890588473257049700045318355758375647809858;
        points[62] = 0.551093412900583559842207845114741393619531411928996576;
        points[63] = 0.579412448302463132325791960076963297957074612286356427;
        points[64] = 0.60704851200449605277823559498322918874432011490667947;
        points[65] = 0.633969028509153281498803697731992966916940034531068588;
        points[66] = 0.660142265757234790190264552440185603514855044142893891;
        points[67] = 0.685537372531524655146344202941148313870373783315464068;
        points[68] = 0.710124414822193871743145495795752922900956401628652886;
        points[69] = 0.733874411111094782254467801313768918081957901304737665;
        points[70] = 0.756759366533369288592606731652972908809584201304494444;
        points[71] = 0.778752305876122344694652910716029923327254381493052023;
        points[72] = 0.79982730537529224065049025181448369275065479541380371;
        points[73] = 0.819959523273280333976318164186844696309416758173168991;
        points[74] = 0.839125229101387031796118461456726383222939554200154474;
        points[75] = 0.857301831652642579078184410158914731907389118138914372;
        points[76] = 0.874467905612230385893604643693701201001877881317353018;
        points[77] = 0.89060321681439740379149866598567505135776067905444388;
        points[78] = 0.905688746096571865002580532751926096589893192071751914;
        points[79] = 0.919706711723450488141330604789459287800724992654457299;
        points[80] = 0.932640590356264406612214487853506931360165308956785065;
        points[81] = 0.944475136545718668062791481282661749580152882993897003;
        points[82] = 0.955196400732276363874021897272205421990346978866176982;
        points[83] = 0.964791745747276075776495103702787255466990075472382081;
        points[84] = 0.97324986183069073432246752375461367009682669030939183;
        points[85] = 0.980560780241213439036862799957754592362509402029375782;
        points[86] = 0.986715885723469786907936385937422161641316371942370113;
        points[87] = 0.99170792881727710156762025503223837464856502757795066;
        points[88] = 0.9955310425053524536893831182064874353682566026891659;
        points[89] = 0.998180792590534754673220140020205897297799157794282507;
        points[90] = 0.999654645076576130382989227515597563656832743077605154;
        weights[0] = 0.000886241240669414176583428997272659952095873629864218483;
        weights[1] = 0.00206198712203222966068207951957255850243113331137748986;
        weights[2] = 0.00323704550797210497709945689711985030499971449878906087;
        weights[3] = 0.00440843974730267681906299833854145369979378398751577817;
        weights[4] = 0.0055746680474797889978318064868009040600173356043204776;
        weights[5] = 0.00673433443226888466526113354590729091615337518909355533;
        weights[6] = 0.00788606631462890159963061088924060608843035449557698779;
        weights[7] = 0.0090285041892344877489133819327914156434210857268059022;
        weights[8] = 0.010160300654415476728892193494355092612817190491238023;
        weights[9] = 0.0112801212737696829834087179980630542430021030470155838;
        weights[10] = 0.0123866459035567430545350604226045112892290973663499999;
        weights[11] = 0.0134785701538309791943186223122484981990054694635986027;
        weights[12] = 0.0145546068852086960848410704762550702727804185334244784;
        weights[13] = 0.0156134877070500597509505933242811286807898278968471806;
        weights[14] = 0.0166539644630612401722580235803609704912632494613275528;
        weights[15] = 0.0176748106975219050603720454334554189656653300618436211;
        weights[16] = 0.0186748230981681254217856193941925408141254451443451448;
        weights[17] = 0.0196528229129691466047416647999719627107443400340535406;
        weights[18] = 0.020607657338598460740458973659126383222276549345955341;
        weights[19] = 0.0215382008786856662962243403468892470171136865319959731;
        weights[20] = 0.0224433566700973733733212220292209693655822913963422219;
        weights[21] = 0.0233220577755988028359959975895073302386711661502887588;
        weights[22] = 0.0241732684413228794222178583147201531346765351896055428;
        weights[23] = 0.0249959853175349574325614967907158596403817401844084145;
        weights[24] = 0.0257892386412360161887900090311699429266509670824634086;
        weights[25] = 0.0265520933791989081030792151327225326056527605063963825;
        weights[26] = 0.0272836503300829802789898375829604098969303738068740136;
        weights[27] = 0.0279830471843231663811858831870769685245650800749738132;
        weights[28] = 0.0286494595405410243964962673113874105284893803785312383;
        weights[29] = 0.0292821018772774797182639980807793917880055682270224649;
        weights[30] = 0.0298802284789003749327712041007182878189814614496390561;
        weights[31] = 0.0304431343145943949034471720292737282551903053750670198;
        weights[32] = 0.030970155869396544215618836513784719382975764484446419;
        weights[33] = 0.0314606719262970885451903345434205879746677448852380542;
        weights[34] = 0.0319141042984836972885987663847741626553157151586982074;
        weights[35] = 0.0323299185108653944840938951895890336840711811183345207;
        weights[36] = 0.0327076244300727829484204260248188797889491842292266387;
        weights[37] = 0.0330467768421917912001690503238481403757599048887767554;
        weights[38] = 0.0333469759775498386369783522266903814507369529274573236;
        weights[39] = 0.0336078679819357531098242472905126817649150710714016725;
        weights[40] = 0.0338291453336979357936561995652978109665323713010702082;
        weights[41] = 0.0340105472062290786654886655310021184743984962307685266;
        weights[42] = 0.0341518597754101261856745006332986155398462361462170208;
        weights[43] = 0.0342529164716510600671922464499929051274844370838388178;
        weights[44] = 0.0343135981762313985724201959451169968701785654191522673;
        weights[45] = 0.0343338333617089631634046006970987270684707628248454412;
        weights[46] = 0.0343135981762313985724201959451169968701785654191522673;
        weights[47] = 0.0342529164716510600671922464499929051274844370838388178;
        weights[48] = 0.0341518597754101261856745006332986155398462361462170208;
        weights[49] = 0.0340105472062290786654886655310021184743984962307685266;
        weights[50] = 0.0338291453336979357936561995652978109665323713010702082;
        weights[51] = 0.0336078679819357531098242472905126817649150710714016725;
        weights[52] = 0.0333469759775498386369783522266903814507369529274573236;
        weights[53] = 0.0330467768421917912001690503238481403757599048887767554;
        weights[54] = 0.0327076244300727829484204260248188797889491842292266387;
        weights[55] = 0.0323299185108653944840938951895890336840711811183345207;
        weights[56] = 0.0319141042984836972885987663847741626553157151586982074;
        weights[57] = 0.0314606719262970885451903345434205879746677448852380542;
        weights[58] = 0.030970155869396544215618836513784719382975764484446419;
        weights[59] = 0.0304431343145943949034471720292737282551903053750670198;
        weights[60] = 0.0298802284789003749327712041007182878189814614496390561;
        weights[61] = 0.0292821018772774797182639980807793917880055682270224649;
        weights[62] = 0.0286494595405410243964962673113874105284893803785312383;
        weights[63] = 0.0279830471843231663811858831870769685245650800749738132;
        weights[64] = 0.0272836503300829802789898375829604098969303738068740136;
        weights[65] = 0.0265520933791989081030792151327225326056527605063963825;
        weights[66] = 0.0257892386412360161887900090311699429266509670824634086;
        weights[67] = 0.0249959853175349574325614967907158596403817401844084145;
        weights[68] = 0.0241732684413228794222178583147201531346765351896055428;
        weights[69] = 0.0233220577755988028359959975895073302386711661502887588;
        weights[70] = 0.0224433566700973733733212220292209693655822913963422219;
        weights[71] = 0.0215382008786856662962243403468892470171136865319959731;
        weights[72] = 0.020607657338598460740458973659126383222276549345955341;
        weights[73] = 0.0196528229129691466047416647999719627107443400340535406;
        weights[74] = 0.0186748230981681254217856193941925408141254451443451448;
        weights[75] = 0.0176748106975219050603720454334554189656653300618436211;
        weights[76] = 0.0166539644630612401722580235803609704912632494613275528;
        weights[77] = 0.0156134877070500597509505933242811286807898278968471806;
        weights[78] = 0.0145546068852086960848410704762550702727804185334244784;
        weights[79] = 0.0134785701538309791943186223122484981990054694635986027;
        weights[80] = 0.0123866459035567430545350604226045112892290973663499999;
        weights[81] = 0.0112801212737696829834087179980630542430021030470155838;
        weights[82] = 0.010160300654415476728892193494355092612817190491238023;
        weights[83] = 0.0090285041892344877489133819327914156434210857268059022;
        weights[84] = 0.00788606631462890159963061088924060608843035449557698779;
        weights[85] = 0.00673433443226888466526113354590729091615337518909355533;
        weights[86] = 0.0055746680474797889978318064868009040600173356043204776;
        weights[87] = 0.00440843974730267681906299833854145369979378398751577817;
        weights[88] = 0.00323704550797210497709945689711985030499971449878906087;
        weights[89] = 0.00206198712203222966068207951957255850243113331137748986;
        weights[90] = 0.000886241240669414176583428997272659952095873629864218483;
        return;
    case 92:
        points[0] = -0.999662071356524554448781399594657012318842729999607637;
        points[1] = -0.99821990219545015378221456594294280816492600181409459;
        points[2] = -0.995627075269215169124287961356391090027932265983393132;
        points[3] = -0.991886004437253478622237199662527827381605302956578392;
        points[4] = -0.98700093392401204090004045039122904399356467778920195;
        points[5] = -0.980977481210154027373163058887535615395818843161610379;
        points[6] = -0.973822588026941934734001787142659191191721511235423039;
        points[7] = -0.965544504421595901364173806138602169530860883359577297;
        points[8] = -0.956152777134006946598194920445797703918998506504779503;
        points[9] = -0.945658237884362956543101669964785933949212997248533521;
        points[10] = -0.934072990607095498232951998777256031577527853360585581;
        points[11] = -0.921410397371076054635722905856515888772178469603803294;
        points[12] = -0.907685062910925043607568008291101783338914158795588124;
        points[13] = -0.892912817752776204232152380949257998944917593349071874;
        points[14] = -0.877110699939569669620166752383099323553535479551971315;
        points[15] = -0.86029693537044688297953756512263106175226820495869558;
        points[16] = -0.842490916773780940406621712657757876584501120591643562;
        points[17] = -0.823713181336488764363311510391657818432398916630850268;
        points[18] = -0.803985387014566437670438017813932393957762384373676536;
        points[19] = -0.783330287551689979201917797775277485339427275587255913;
        points[20] = -0.761771706234416275709129985095874230991884593108604726;
        points[21] = -0.739334508414088037773129275466122799859601405508058529;
        points[22] = -0.716044572827033202401024992910775231287456715890090871;
        points[23] = -0.691928761746073039103276770460675484558064182911950699;
        points[24] = -0.667014889997724077606074239400966286950601014063011038;
        points[25] = -0.641331692880801492841387767120848804342203496808422635;
        points[26] = -0.614908793023407720149117754364316276392831507890921404;
        points[27] = -0.587776666216520372693531676038949762142295497430962454;
        points[28] = -0.559966606263577766234105048681074828139743621197109429;
        points[29] = -0.531510688886597878431759780080549661494868405561638897;
        points[30] = -0.502441734730456513888600829912502707031938787376340506;
        points[31] = -0.472793271507991835096430111150156724465307304008248225;
        points[32] = -0.442599495329594231680832540992631739859105504030561246;
        points[33] = -0.411895231261881708602945602845532176031845490107792249;
        points[34] = -0.380715893160950569903094917457463491586026393380418591;
        points[35] = -0.349097442826528183794752472326976341987036550568730163;
        points[36] = -0.317076348524138107148509461711430579561593284882375139;
        points[37] = -0.284689542923116943093884758715528951943736513464156918;
        points[38] = -0.251974380498996180444597286193033936222533348848624667;
        points[39] = -0.218968594449380152453026949257906036188527051202709997;
        points[40] = -0.185710253173012450702391384717744051021071162054142982;
        points[41] = -0.152237716362226996438540730277914489674282978252028081;
        points[42] = -0.118589590759425929470548886722866069216388118827248834;
        points[43] = -0.0848046856286140126782523302697332361821563750714545051;
        points[44] = -0.0509219679933479234303762198894329210107906354570165028;
        points[45] = -0.016980517692728234384056534225145843185687517618248;
        points[46] = 0.016980517692728234384056534225145843185687517618248;
        points[47] = 0.0509219679933479234303762198894329210107906354570165028;
        points[48] = 0.0848046856286140126782523302697332361821563750714545051;
        points[49] = 0.118589590759425929470548886722866069216388118827248834;
        points[50] = 0.152237716362226996438540730277914489674282978252028081;
        points[51] = 0.185710253173012450702391384717744051021071162054142982;
        points[52] = 0.218968594449380152453026949257906036188527051202709997;
        points[53] = 0.251974380498996180444597286193033936222533348848624667;
        points[54] = 0.284689542923116943093884758715528951943736513464156918;
        points[55] = 0.317076348524138107148509461711430579561593284882375139;
        points[56] = 0.349097442826528183794752472326976341987036550568730163;
        points[57] = 0.380715893160950569903094917457463491586026393380418591;
        points[58] = 0.411895231261881708602945602845532176031845490107792249;
        points[59] = 0.442599495329594231680832540992631739859105504030561246;
        points[60] = 0.472793271507991835096430111150156724465307304008248225;
        points[61] = 0.502441734730456513888600829912502707031938787376340506;
        points[62] = 0.531510688886597878431759780080549661494868405561638897;
        points[63] = 0.559966606263577766234105048681074828139743621197109429;
        points[64] = 0.587776666216520372693531676038949762142295497430962454;
        points[65] = 0.614908793023407720149117754364316276392831507890921404;
        points[66] = 0.641331692880801492841387767120848804342203496808422635;
        points[67] = 0.667014889997724077606074239400966286950601014063011038;
        points[68] = 0.691928761746073039103276770460675484558064182911950699;
        points[69] = 0.716044572827033202401024992910775231287456715890090871;
        points[70] = 0.739334508414088037773129275466122799859601405508058529;
        points[71] = 0.761771706234416275709129985095874230991884593108604726;
        points[72] = 0.783330287551689979201917797775277485339427275587255913;
        points[73] = 0.803985387014566437670438017813932393957762384373676536;
        points[74] = 0.823713181336488764363311510391657818432398916630850268;
        points[75] = 0.842490916773780940406621712657757876584501120591643562;
        points[76] = 0.86029693537044688297953756512263106175226820495869558;
        points[77] = 0.877110699939569669620166752383099323553535479551971315;
        points[78] = 0.892912817752776204232152380949257998944917593349071874;
        points[79] = 0.907685062910925043607568008291101783338914158795588124;
        points[80] = 0.921410397371076054635722905856515888772178469603803294;
        points[81] = 0.934072990607095498232951998777256031577527853360585581;
        points[82] = 0.945658237884362956543101669964785933949212997248533521;
        points[83] = 0.956152777134006946598194920445797703918998506504779503;
        points[84] = 0.965544504421595901364173806138602169530860883359577297;
        points[85] = 0.973822588026941934734001787142659191191721511235423039;
        points[86] = 0.980977481210154027373163058887535615395818843161610379;
        points[87] = 0.98700093392401204090004045039122904399356467778920195;
        points[88] = 0.991886004437253478622237199662527827381605302956578392;
        points[89] = 0.995627075269215169124287961356391090027932265983393132;
        points[90] = 0.99821990219545015378221456594294280816492600181409459;
        points[91] = 0.999662071356524554448781399594657012318842729999607637;
        weights[0] = 0.000867185178767142135353974325994490742396081482868707402;
        weights[1] = 0.00201767136626283859187966471561660783656485200640787878;
        weights[2] = 0.0031675359433960978742590562082864394996467233335299317;
        weights[3] = 0.00431389533186170047233911487331014144817533332426542383;
        weights[4] = 0.00545530890800087098715696184302176136051931987040249866;
        weights[5] = 0.00659043933421489522317783034568600654390482512479528659;
        weights[6] = 0.00771797183737356850453277816075472427161059860339223349;
        weights[7] = 0.00883660405646787737454808010765274779359230474278797215;
        weights[8] = 0.00994504501972608204177051119545042577158230894670408266;
        weights[9] = 0.0110420159226353942239852048709808096285552727341686689;
        weights[10] = 0.0121262513626377105292967314753923879026603905993878884;
        weights[11] = 0.0131965007057111380291116906206134961868484932530494266;
        weights[12] = 0.0142515294889539252658071854977576336899879647731621695;
        weights[13] = 0.0152901208257965015069060201484705861575317082792547821;
        weights[14] = 0.0163110768002559580048140831497579537774700921647710496;
        weights[15] = 0.0173132198436897763611401606843947594202728574612706618;
        weights[16] = 0.0182953940902675572911872923867642515379425675250666487;
        weights[17] = 0.0192564667085594747123721808291567832787339040656558079;
        weights[18] = 0.0201953292071874837495644306958155165568535451575363299;
        weights[19] = 0.0211108987127624618099760941923831922788638345798600575;
        weights[20] = 0.0220021192184858573987437085531586993915690306248030416;
        weights[21] = 0.0228679628018925424043408933093611529992587580173125925;
        weights[22] = 0.0237074308102819123935371534115454404292062349519884959;
        weights[23] = 0.0245195550124409742571709043811396392240442263100453312;
        weights[24] = 0.025303398715313225697548324915707543595224767560361488;
        weights[25] = 0.0260580578443141792224576934100370836408123313841590646;
        weights[26] = 0.0267826619860403233004881602495794119755568533739778345;
        weights[27] = 0.0274763753921641733951792775645408299417911798882358053;
        weights[28] = 0.0281383979433544045144513188021272073252467538532336892;
        weights[29] = 0.028767966072107175822379503473288361111410498690370866;
        weights[30] = 0.0293643536434228126127466204792589311747554530021036094;
        weights[31] = 0.0299268727923110733078676614729821602195411763585204246;
        weights[32] = 0.0304548747171583209806354159261107679137628048403633426;
        weights[33] = 0.0309477504280410316680409700166083802047649147172419486;
        weights[34] = 0.0314049314491221779161403327452211018941311776096654317;
        weights[35] = 0.0318258904743200858259725376343985500409079991002175649;
        weights[36] = 0.0322101419754933295357444381132401148264135399766926435;
        weights[37] = 0.0325572427624400452431618955892398376283713042368582935;
        weights[38] = 0.03286679249406566032646801723002290082449295434727483;
        weights[39] = 0.0331384341401293818226205207813220476955324606445558515;
        weights[40] = 0.0333718543930368103078011237617524773795045911777031549;
        weights[41] = 0.0335667840292036763100755225540028636139014460359423741;
        weights[42] = 0.0337229982195738716938007349145128185705624213092121138;
        weights[43] = 0.0338403167889336018914183992637652145257822085979392596;
        weights[44] = 0.0339186044237225494950272314374481808887787583939480564;
        weights[45] = 0.0339577708281023479670025936823675672809631769689353859;
        weights[46] = 0.0339577708281023479670025936823675672809631769689353859;
        weights[47] = 0.0339186044237225494950272314374481808887787583939480564;
        weights[48] = 0.0338403167889336018914183992637652145257822085979392596;
        weights[49] = 0.0337229982195738716938007349145128185705624213092121138;
        weights[50] = 0.0335667840292036763100755225540028636139014460359423741;
        weights[51] = 0.0333718543930368103078011237617524773795045911777031549;
        weights[52] = 0.0331384341401293818226205207813220476955324606445558515;
        weights[53] = 0.03286679249406566032646801723002290082449295434727483;
        weights[54] = 0.0325572427624400452431618955892398376283713042368582935;
        weights[55] = 0.0322101419754933295357444381132401148264135399766926435;
        weights[56] = 0.0318258904743200858259725376343985500409079991002175649;
        weights[57] = 0.0314049314491221779161403327452211018941311776096654317;
        weights[58] = 0.0309477504280410316680409700166083802047649147172419486;
        weights[59] = 0.0304548747171583209806354159261107679137628048403633426;
        weights[60] = 0.0299268727923110733078676614729821602195411763585204246;
        weights[61] = 0.0293643536434228126127466204792589311747554530021036094;
        weights[62] = 0.028767966072107175822379503473288361111410498690370866;
        weights[63] = 0.0281383979433544045144513188021272073252467538532336892;
        weights[64] = 0.0274763753921641733951792775645408299417911798882358053;
        weights[65] = 0.0267826619860403233004881602495794119755568533739778345;
        weights[66] = 0.0260580578443141792224576934100370836408123313841590646;
        weights[67] = 0.025303398715313225697548324915707543595224767560361488;
        weights[68] = 0.0245195550124409742571709043811396392240442263100453312;
        weights[69] = 0.0237074308102819123935371534115454404292062349519884959;
        weights[70] = 0.0228679628018925424043408933093611529992587580173125925;
        weights[71] = 0.0220021192184858573987437085531586993915690306248030416;
        weights[72] = 0.0211108987127624618099760941923831922788638345798600575;
        weights[73] = 0.0201953292071874837495644306958155165568535451575363299;
        weights[74] = 0.0192564667085594747123721808291567832787339040656558079;
        weights[75] = 0.0182953940902675572911872923867642515379425675250666487;
        weights[76] = 0.0173132198436897763611401606843947594202728574612706618;
        weights[77] = 0.0163110768002559580048140831497579537774700921647710496;
        weights[78] = 0.0152901208257965015069060201484705861575317082792547821;
        weights[79] = 0.0142515294889539252658071854977576336899879647731621695;
        weights[80] = 0.0131965007057111380291116906206134961868484932530494266;
        weights[81] = 0.0121262513626377105292967314753923879026603905993878884;
        weights[82] = 0.0110420159226353942239852048709808096285552727341686689;
        weights[83] = 0.00994504501972608204177051119545042577158230894670408266;
        weights[84] = 0.00883660405646787737454808010765274779359230474278797215;
        weights[85] = 0.00771797183737356850453277816075472427161059860339223349;
        weights[86] = 0.00659043933421489522317783034568600654390482512479528659;
        weights[87] = 0.00545530890800087098715696184302176136051931987040249866;
        weights[88] = 0.00431389533186170047233911487331014144817533332426542383;
        weights[89] = 0.0031675359433960978742590562082864394996467233335299317;
        weights[90] = 0.00201767136626283859187966471561660783656485200640787878;
        weights[91] = 0.000867185178767142135353974325994490742396081482868707402;
        return;
    case 93:
        points[0] = -0.999669260657168688326820857745187241280325160156497247;
        points[1] = -0.998257764171412775752493196293681305810040549643142666;
        points[2] = -0.995720046248950179380264604122186175252285092765267258;
        points[3] = -0.992058407192062741161221584057628652135535024521657368;
        points[4] = -0.987276911268572265931696323000710515814674480302371171;
        points[5] = -0.981380939533501606767866159454720167520558954133875787;
        points[6] = -0.974377142133410456975732109236891443228402340242014969;
        points[7] = -0.966273423040059125621511331258230344921107085388491322;
        points[8] = -0.957078929065123352230644283310283124962121151821721034;
        points[9] = -0.946804038848475454452154718577911517572122715237806909;
        points[10] = -0.935460350875189251367484848513280155474152767514715463;
        points[11] = -0.923060670265853484389249716365123238586213045170489101;
        points[12] = -0.909618994265676445699938522517054569564628302182008953;
        points[13] = -0.895150496414999027485759765053473830490390051557491737;
        points[14] = -0.879671509405002962140067541580194850156201297925557603;
        points[15] = -0.863199506631601715124533650646048238763943439890742475;
        points[16] = -0.845753082465261302946519737571421220493462805875725293;
        points[17] = -0.8273519312574519163514766329830071000775689961193787;
        points[18] = -0.808016825106586578646116469379007210755874058808819559;
        points[19] = -0.787769590408075201199532030100172572586971409200120185;
        points[20] = -0.766633083214692959396041265059606212679742003200204666;
        points[21] = -0.744631163434914460185216229500895732277307066712539984;
        points[22] = -0.721788667898239650908217728707763835487144842526636791;
        points[23] = -0.698131382317853409145990775560434119617278232738723412;
        points[24] = -0.67368601218222791557145489132309820186694768575396267;
        points[25] = -0.648480152608499893383398556379075089374903056077628596;
        points[26] = -0.622542257191635632724261532380659571661463519932538244;
        points[27] = -0.59590160588453604434129825363338755643956340348328848;
        points[28] = -0.568588271945331683331925687930522525538981359364107801;
        points[29] = -0.540633087989173217270796747984773250007599104267668297;
        points[30] = -0.512067611182835427355166711243704610382877600588427498;
        points[31] = -0.482924087621421657446984362655831094061185574175909912;
        points[32] = -0.453235415927379745929265464214109195187382275927984228;
        points[33] = -0.423035110112918960207128824320281815074244110465680261;
        points[34] = -0.392357261747749387298647332414555257965049545359831198;
        points[35] = -0.361236501474849727744629400660034333509321996870239443;
        points[36] = -0.329707959917705642792370280358575709629954646526266246;
        points[37] = -0.297807228023147909018027461642690950314228819198080737;
        points[38] = -0.265570316884556881013475784464668279252827577588315063;
        points[39] = -0.233033617090786443643250648713844420895201379630058496;
        points[40] = -0.200233857646696096572340175419340715421556194651086069;
        points[41] = -0.167208064511663456666399611408428284847256869943010019;
        points[42] = -0.133993518802880746725403009282180842980378442608208466;
        points[43] = -0.100627714710617278030890949871781091118252905982238872;
        points[44] = -0.0671483171729551043876143396550300879188224811178582084;
        points[45] = -0.0335931193577765612711877373330596469381759578138640616;
        points[46] = 0;
        points[47] = 0.0335931193577765612711877373330596469381759578138640616;
        points[48] = 0.0671483171729551043876143396550300879188224811178582084;
        points[49] = 0.100627714710617278030890949871781091118252905982238872;
        points[50] = 0.133993518802880746725403009282180842980378442608208466;
        points[51] = 0.167208064511663456666399611408428284847256869943010019;
        points[52] = 0.200233857646696096572340175419340715421556194651086069;
        points[53] = 0.233033617090786443643250648713844420895201379630058496;
        points[54] = 0.265570316884556881013475784464668279252827577588315063;
        points[55] = 0.297807228023147909018027461642690950314228819198080737;
        points[56] = 0.329707959917705642792370280358575709629954646526266246;
        points[57] = 0.361236501474849727744629400660034333509321996870239443;
        points[58] = 0.392357261747749387298647332414555257965049545359831198;
        points[59] = 0.423035110112918960207128824320281815074244110465680261;
        points[60] = 0.453235415927379745929265464214109195187382275927984228;
        points[61] = 0.482924087621421657446984362655831094061185574175909912;
        points[62] = 0.512067611182835427355166711243704610382877600588427498;
        points[63] = 0.540633087989173217270796747984773250007599104267668297;
        points[64] = 0.568588271945331683331925687930522525538981359364107801;
        points[65] = 0.59590160588453604434129825363338755643956340348328848;
        points[66] = 0.622542257191635632724261532380659571661463519932538244;
        points[67] = 0.648480152608499893383398556379075089374903056077628596;
        points[68] = 0.67368601218222791557145489132309820186694768575396267;
        points[69] = 0.698131382317853409145990775560434119617278232738723412;
        points[70] = 0.721788667898239650908217728707763835487144842526636791;
        points[71] = 0.744631163434914460185216229500895732277307066712539984;
        points[72] = 0.766633083214692959396041265059606212679742003200204666;
        points[73] = 0.787769590408075201199532030100172572586971409200120185;
        points[74] = 0.808016825106586578646116469379007210755874058808819559;
        points[75] = 0.8273519312574519163514766329830071000775689961193787;
        points[76] = 0.845753082465261302946519737571421220493462805875725293;
        points[77] = 0.863199506631601715124533650646048238763943439890742475;
        points[78] = 0.879671509405002962140067541580194850156201297925557603;
        points[79] = 0.895150496414999027485759765053473830490390051557491737;
        points[80] = 0.909618994265676445699938522517054569564628302182008953;
        points[81] = 0.923060670265853484389249716365123238586213045170489101;
        points[82] = 0.935460350875189251367484848513280155474152767514715463;
        points[83] = 0.946804038848475454452154718577911517572122715237806909;
        points[84] = 0.957078929065123352230644283310283124962121151821721034;
        points[85] = 0.966273423040059125621511331258230344921107085388491322;
        points[86] = 0.974377142133410456975732109236891443228402340242014969;
        points[87] = 0.981380939533501606767866159454720167520558954133875787;
        points[88] = 0.987276911268572265931696323000710515814674480302371171;
        points[89] = 0.992058407192062741161221584057628652135535024521657368;
        points[90] = 0.995720046248950179380264604122186175252285092765267258;
        points[91] = 0.998257764171412775752493196293681305810040549643142666;
        points[92] = 0.999669260657168688326820857745187241280325160156497247;
        weights[0] = 0.000848737168067911004879633675769820421638179752390931871;
        weights[1] = 0.00197476876868680838893967153464177276652590956715146444;
        weights[2] = 0.00310024040309931677546474458325848257256483736887172084;
        weights[3] = 0.00422235738240660799863333401744338242554406285108308511;
        weights[4] = 0.00533973709816921461375840043586338933796748857339270363;
        weights[5] = 0.00645109779431127588905802198035418330378567315630411489;
        weights[6] = 0.00755517950076982075161888519137533507917679178169004919;
        weights[7] = 0.00865073403542864831414058105578897485955254642871150274;
        weights[8] = 0.00973652394188768782694672736568351629536255410168888153;
        weights[9] = 0.0108113231905424893820261082876789940502727450599168152;
        weights[10] = 0.0118739183274471250986137776017611700868017776623619656;
        weights[11] = 0.0129231097531853504560269268827094843483674248439712384;
        weights[12] = 0.0139577130380079707240702980874663606230729232982821784;
        weights[13] = 0.014976560240671880953918871892361128036745711420712775;
        weights[14] = 0.015978501217782116788317429988826007114346767564572125;
        weights[15] = 0.0169624049173290109012270408655662099485468771904991582;
        weights[16] = 0.0179271606528137131788532190675699733131392734836451275;
        weights[17] = 0.0188716793555080346144300144422094811850176993384806494;
        weights[18] = 0.019794894802927928668055443305344388662940512646694447;
        weights[19] = 0.0206957648218687344885893577880669395793016804241908515;
        weights[20] = 0.0215732724644998180150575531094374125016887388285984515;
        weights[21] = 0.0224264271561095718891067577136508464139749719179687252;
        weights[22] = 0.0232542658131577516899199750886652383997568894919638564;
        weights[23] = 0.0240558539303446561530654186459036539889189845862935157;
        weights[24] = 0.0248302866354525818918352850242489719325703487056052276;
        weights[25] = 0.0255766897107578389221757117730514623049970564923904293;
        weights[26] = 0.0262942205798532747522980359852452402538181572382039604;
        weights[27] = 0.0269820692587627330487877249811649595806400136575261967;
        weights[28] = 0.0276394592702707197131161703293693414224073655534224785;
        weights[29] = 0.0282656485204330643574288815803239738949742037492842589;
        weights[30] = 0.0288599301362777063629067728575961836794699533988211164;
        weights[31] = 0.0294216332637489774855157506583538826893104980864164292;
        weights[32] = 0.0299501238249939241658776387639711230128591825036532717;
        weights[33] = 0.0304448052341353094964758816678807293767205267241569174;
        weights[34] = 0.0309051190707229359087680795018816987061748791728935515;
        weights[35] = 0.0313305457101028019259149861626732372357439675727809118;
        weights[36] = 0.0317206049099923088325875561571632658154829162753476369;
        weights[37] = 0.0320748563525992195817159136490555225869190906422280358;
        weights[38] = 0.0323929001416722927063034327585231931442611535512836358;
        weights[39] = 0.032674377253922415754863987714537282137641201492911352;
        weights[40] = 0.0329189699443045911324771790917088059097624346592330441;
        weights[41] = 0.0331264021047032259729396401391756886016802459143348092;
        weights[42] = 0.0332964395756157893452421703571147841592232641427198747;
        weights[43] = 0.0334288904104829662942552341666955854117672800878757491;
        weights[44] = 0.03352360509236689973246712914639683738284629312140234;
        weights[45] = 0.0335804767027329082042332269417198813812296097780856302;
        weights[46] = 0.0335994410421441396941908359695044081289786722799736171;
        weights[47] = 0.0335804767027329082042332269417198813812296097780856302;
        weights[48] = 0.03352360509236689973246712914639683738284629312140234;
        weights[49] = 0.0334288904104829662942552341666955854117672800878757491;
        weights[50] = 0.0332964395756157893452421703571147841592232641427198747;
        weights[51] = 0.0331264021047032259729396401391756886016802459143348092;
        weights[52] = 0.0329189699443045911324771790917088059097624346592330441;
        weights[53] = 0.032674377253922415754863987714537282137641201492911352;
        weights[54] = 0.0323929001416722927063034327585231931442611535512836358;
        weights[55] = 0.0320748563525992195817159136490555225869190906422280358;
        weights[56] = 0.0317206049099923088325875561571632658154829162753476369;
        weights[57] = 0.0313305457101028019259149861626732372357439675727809118;
        weights[58] = 0.0309051190707229359087680795018816987061748791728935515;
        weights[59] = 0.0304448052341353094964758816678807293767205267241569174;
        weights[60] = 0.0299501238249939241658776387639711230128591825036532717;
        weights[61] = 0.0294216332637489774855157506583538826893104980864164292;
        weights[62] = 0.0288599301362777063629067728575961836794699533988211164;
        weights[63] = 0.0282656485204330643574288815803239738949742037492842589;
        weights[64] = 0.0276394592702707197131161703293693414224073655534224785;
        weights[65] = 0.0269820692587627330487877249811649595806400136575261967;
        weights[66] = 0.0262942205798532747522980359852452402538181572382039604;
        weights[67] = 0.0255766897107578389221757117730514623049970564923904293;
        weights[68] = 0.0248302866354525818918352850242489719325703487056052276;
        weights[69] = 0.0240558539303446561530654186459036539889189845862935157;
        weights[70] = 0.0232542658131577516899199750886652383997568894919638564;
        weights[71] = 0.0224264271561095718891067577136508464139749719179687252;
        weights[72] = 0.0215732724644998180150575531094374125016887388285984515;
        weights[73] = 0.0206957648218687344885893577880669395793016804241908515;
        weights[74] = 0.019794894802927928668055443305344388662940512646694447;
        weights[75] = 0.0188716793555080346144300144422094811850176993384806494;
        weights[76] = 0.0179271606528137131788532190675699733131392734836451275;
        weights[77] = 0.0169624049173290109012270408655662099485468771904991582;
        weights[78] = 0.015978501217782116788317429988826007114346767564572125;
        weights[79] = 0.014976560240671880953918871892361128036745711420712775;
        weights[80] = 0.0139577130380079707240702980874663606230729232982821784;
        weights[81] = 0.0129231097531853504560269268827094843483674248439712384;
        weights[82] = 0.0118739183274471250986137776017611700868017776623619656;
        weights[83] = 0.0108113231905424893820261082876789940502727450599168152;
        weights[84] = 0.00973652394188768782694672736568351629536255410168888153;
        weights[85] = 0.00865073403542864831414058105578897485955254642871150274;
        weights[86] = 0.00755517950076982075161888519137533507917679178169004919;
        weights[87] = 0.00645109779431127588905802198035418330378567315630411489;
        weights[88] = 0.00533973709816921461375840043586338933796748857339270363;
        weights[89] = 0.00422235738240660799863333401744338242554406285108308511;
        weights[90] = 0.00310024040309931677546474458325848257256483736887172084;
        weights[91] = 0.00197476876868680838893967153464177276652590956715146444;
        weights[92] = 0.000848737168067911004879633675769820421638179752390931871;
        return;
    case 94:
        points[0] = -0.999676222955049794478464366747409848139627829966572507;
        points[1] = -0.998294431021687606243546768058108042268091990605787668;
        points[2] = -0.995810084201718879423190934329107625238200964530385004;
        points[3] = -0.992225375400876658453786226905471650962464631321317773;
        points[4] = -0.987544198320479788678849762273555804440481684177014213;
        points[5] = -0.981771709883378229724351495417030267613749904916552386;
        points[6] = -0.974914283790465042598315322290912137196945548117358912;
        points[7] = -0.966979495881343388944631968710041505060598929440661577;
        points[8] = -0.957976113742955023987958964211027895290644502348615627;
        points[9] = -0.947914086348761722901954497614121229896636040741233284;
        points[10] = -0.936804532802825378210920024727472995242274601280116652;
        points[11] = -0.924659729937951474687734347705735326661574475709144287;
        points[12] = -0.911493098694057485956075786934980212480860796188506197;
        points[13] = -0.897319189258767992575133736578988059508835299423273975;
        points[14] = -0.882153664972872260771444347183289471857227221030741041;
        points[15] = -0.866013285012198673277729201207061921090687709201026088;
        points[16] = -0.848915885862033400150190403137137154357769045291369543;
        points[17] = -0.830880361603017377979288666448146904367211322881633515;
        points[18] = -0.811926643029482883145495289557898822298981060277520796;
        points[19] = -0.792075675622845165701440470454136154953557954125613998;
        points[20] = -0.771349396404123699387453908757799276327366709247219679;
        points[21] = -0.749770709691013517218791630829918522774825347988665074;
        points[22] = -0.7273634617861990593946367207889628717631412079222838;
        points[23] = -0.704152414624820241445597884335076885574816244466164089;
        points[24] = -0.680163218410172621032254201433052036138924387297520534;
        points[25] = -0.655422383267855255435989393002321078921744846911619746;
        points[26] = -0.629957249949673190129546625483633665189697467096240387;
        points[27] = -0.603795959619657222727320674947337989748020588318004395;
        points[28] = -0.57696742275558162059258138870441364880246409378461286;
        points[29] = -0.549501287200340399755088240113266045478299406261543523;
        points[30] = -0.521427905398483940978551968247777716737108697507760625;
        points[31] = -0.492778300854119354040167915332133733135761653235448184;
        points[32] = -0.463584133847239278989446940447910116503396314123237043;
        points[33] = -0.433877666446363893398922792804568935469571347189232784;
        points[34] = -0.403691726856158945048468748336183399349271200036631157;
        points[35] = -0.37305967313942783980613913540455615215517385910736278;
        points[36] = -0.342015356353567405830147012994406180627723128000904626;
        points[37] = -0.310593083142224186454217839275709604963353501438097899;
        points[38] = -0.278827577823490286044163594893108464608364675488588673;
        points[39] = -0.246753944016534251555295321377782621229833120264582988;
        points[40] = -0.214407625849072610544954074596143552386529539771582782;
        points[41] = -0.181824368788550945981578342253664054732464364826965719;
        points[42] = -0.149040180140319261529605407442555929296518461656166225;
        points[43] = -0.116091289256454421500442570234603160479283072919194245;
        points[44] = -0.0830141074992022328247687231070251764170435580615164015;
        points[45] = -0.0498451880032829204296412530386891695662834551648080578;
        points[46] = -0.0166211852815260337764030684225555148097106249581399813;
        points[47] = 0.0166211852815260337764030684225555148097106249581399813;
        points[48] = 0.0498451880032829204296412530386891695662834551648080578;
        points[49] = 0.0830141074992022328247687231070251764170435580615164015;
        points[50] = 0.116091289256454421500442570234603160479283072919194245;
        points[51] = 0.149040180140319261529605407442555929296518461656166225;
        points[52] = 0.181824368788550945981578342253664054732464364826965719;
        points[53] = 0.214407625849072610544954074596143552386529539771582782;
        points[54] = 0.246753944016534251555295321377782621229833120264582988;
        points[55] = 0.278827577823490286044163594893108464608364675488588673;
        points[56] = 0.310593083142224186454217839275709604963353501438097899;
        points[57] = 0.342015356353567405830147012994406180627723128000904626;
        points[58] = 0.37305967313942783980613913540455615215517385910736278;
        points[59] = 0.403691726856158945048468748336183399349271200036631157;
        points[60] = 0.433877666446363893398922792804568935469571347189232784;
        points[61] = 0.463584133847239278989446940447910116503396314123237043;
        points[62] = 0.492778300854119354040167915332133733135761653235448184;
        points[63] = 0.521427905398483940978551968247777716737108697507760625;
        points[64] = 0.549501287200340399755088240113266045478299406261543523;
        points[65] = 0.57696742275558162059258138870441364880246409378461286;
        points[66] = 0.603795959619657222727320674947337989748020588318004395;
        points[67] = 0.629957249949673190129546625483633665189697467096240387;
        points[68] = 0.655422383267855255435989393002321078921744846911619746;
        points[69] = 0.680163218410172621032254201433052036138924387297520534;
        points[70] = 0.704152414624820241445597884335076885574816244466164089;
        points[71] = 0.7273634617861990593946367207889628717631412079222838;
        points[72] = 0.749770709691013517218791630829918522774825347988665074;
        points[73] = 0.771349396404123699387453908757799276327366709247219679;
        points[74] = 0.792075675622845165701440470454136154953557954125613998;
        points[75] = 0.811926643029482883145495289557898822298981060277520796;
        points[76] = 0.830880361603017377979288666448146904367211322881633515;
        points[77] = 0.848915885862033400150190403137137154357769045291369543;
        points[78] = 0.866013285012198673277729201207061921090687709201026088;
        points[79] = 0.882153664972872260771444347183289471857227221030741041;
        points[80] = 0.897319189258767992575133736578988059508835299423273975;
        points[81] = 0.911493098694057485956075786934980212480860796188506197;
        points[82] = 0.924659729937951474687734347705735326661574475709144287;
        points[83] = 0.936804532802825378210920024727472995242274601280116652;
        points[84] = 0.947914086348761722901954497614121229896636040741233284;
        points[85] = 0.957976113742955023987958964211027895290644502348615627;
        points[86] = 0.966979495881343388944631968710041505060598929440661577;
        points[87] = 0.974914283790465042598315322290912137196945548117358912;
        points[88] = 0.981771709883378229724351495417030267613749904916552386;
        points[89] = 0.987544198320479788678849762273555804440481684177014213;
        points[90] = 0.992225375400876658453786226905471650962464631321317773;
        points[91] = 0.995810084201718879423190934329107625238200964530385004;
        points[92] = 0.998294431021687606243546768058108042268091990605787668;
        points[93] = 0.999676222955049794478464366747409848139627829966572507;
        weights[0] = 0.000830871612682162494641546324375110864622214772073354996;
        weights[1] = 0.00193321988872541894311762727600750366946723564068460693;
        weights[2] = 0.00303506589103862802739195607149431334962246491017460846;
        weights[3] = 0.00413369987540777648329713978750620172398360512921686863;
        weights[4] = 0.00522779428950776754530552172781598429761406907606819141;
        weights[5] = 0.00631612009103644822310764930106036886294979302588826901;
        weights[6] = 0.00739746928814235620086287840017360433714378904023085415;
        weights[7] = 0.00847064509453463599990965679935241906859701611312539086;
        weights[8] = 0.00953446083286515825006317020991343620548590355620144837;
        weights[9] = 0.0105877405649541222367243510962109022310985714685046869;
        weights[10] = 0.0116293201611224145960741283712199003995361454872051081;
        weights[11] = 0.0126580484976389944448251137900186573874499116420926219;
        weights[12] = 0.0136727886906068785064401933159972607496367824473291975;
        weights[13] = 0.0146724193344994642042645450238501024486329699044873327;
        weights[14] = 0.0156558357325155578600224341784309847555613964457064927;
        weights[15] = 0.0166219511126654966383287524278131752227961860806962678;
        weights[16] = 0.0175696978261432519987255770001927674788053795871177939;
        weights[17] = 0.0184980285256659109538092555914945590215641174376280211;
        weights[18] = 0.0194059173219820048860518000260869511750575923969089218;
        weights[19] = 0.0202923609170111321798884289184195432814587434351818039;
        weights[20] = 0.0211563797122213898150452802905460959140922388999151204;
        weights[21] = 0.0219970188909400771733972260876431309649127113106295751;
        weights[22] = 0.0228133494733552364100120709752462141486809255831789777;
        weights[23] = 0.0236044693430143822805078668890496363294443840066293924;
        weights[24] = 0.0243695042436689883063465661684850502006359973665515837;
        weights[25] = 0.0251076087453524051285803448418566609943330911692926214;
        weights[26] = 0.0258179671786167281644027179298299915081600816733820082;
        weights[27] = 0.0264997945358916991966939328758809936913792117433596078;
        weights[28] = 0.0271523373389665647238825617484023584515020127432364946;
        weights[29] = 0.0277748744716342206206510478782326761730535380119375082;
        weights[30] = 0.0283667179765761068127294943265861848236344924917036396;
        weights[31] = 0.0289272138156062558422752107531591755211870220215548701;
        weights[32] = 0.0294557425924336763971915811949758187422430525843416989;
        weights[33] = 0.0299517202371438692000879897654083686755836389518951174;
        weights[34] = 0.0304145986516427122032814246978614096405987303061118055;
        weights[35] = 0.0308438663153491874111068279978917567959722531203732961;
        weights[36] = 0.0312390488504674178821911177861703731465515811193530368;
        weights[37] = 0.0315997095462132004647739918125143674597839426291385576;
        weights[38] = 0.0319254498414156139258407501131795303548396423311023386;
        weights[39] = 0.0322159097649603071128181449147394015515406504864829692;
        weights[40] = 0.0324707683335876794845084447841014090343839329504606667;
        weights[41] = 0.0326897439066063071525284519649607937663364009891135911;
        weights[42] = 0.0328725944971295907261477133981679420516062172140313057;
        weights[43] = 0.0330191180394916550766707419018238301410396939926840883;
        weights[44] = 0.0331291526125469632160051739396855714420333886021224712;
        weights[45] = 0.0332025766186068637987663578521218688383339483664954133;
        weights[46] = 0.0332393089178153208007052414740456431070533317384004034;
        weights[47] = 0.0332393089178153208007052414740456431070533317384004034;
        weights[48] = 0.0332025766186068637987663578521218688383339483664954133;
        weights[49] = 0.0331291526125469632160051739396855714420333886021224712;
        weights[50] = 0.0330191180394916550766707419018238301410396939926840883;
        weights[51] = 0.0328725944971295907261477133981679420516062172140313057;
        weights[52] = 0.0326897439066063071525284519649607937663364009891135911;
        weights[53] = 0.0324707683335876794845084447841014090343839329504606667;
        weights[54] = 0.0322159097649603071128181449147394015515406504864829692;
        weights[55] = 0.0319254498414156139258407501131795303548396423311023386;
        weights[56] = 0.0315997095462132004647739918125143674597839426291385576;
        weights[57] = 0.0312390488504674178821911177861703731465515811193530368;
        weights[58] = 0.0308438663153491874111068279978917567959722531203732961;
        weights[59] = 0.0304145986516427122032814246978614096405987303061118055;
        weights[60] = 0.0299517202371438692000879897654083686755836389518951174;
        weights[61] = 0.0294557425924336763971915811949758187422430525843416989;
        weights[62] = 0.0289272138156062558422752107531591755211870220215548701;
        weights[63] = 0.0283667179765761068127294943265861848236344924917036396;
        weights[64] = 0.0277748744716342206206510478782326761730535380119375082;
        weights[65] = 0.0271523373389665647238825617484023584515020127432364946;
        weights[66] = 0.0264997945358916991966939328758809936913792117433596078;
        weights[67] = 0.0258179671786167281644027179298299915081600816733820082;
        weights[68] = 0.0251076087453524051285803448418566609943330911692926214;
        weights[69] = 0.0243695042436689883063465661684850502006359973665515837;
        weights[70] = 0.0236044693430143822805078668890496363294443840066293924;
        weights[71] = 0.0228133494733552364100120709752462141486809255831789777;
        weights[72] = 0.0219970188909400771733972260876431309649127113106295751;
        weights[73] = 0.0211563797122213898150452802905460959140922388999151204;
        weights[74] = 0.0202923609170111321798884289184195432814587434351818039;
        weights[75] = 0.0194059173219820048860518000260869511750575923969089218;
        weights[76] = 0.0184980285256659109538092555914945590215641174376280211;
        weights[77] = 0.0175696978261432519987255770001927674788053795871177939;
        weights[78] = 0.0166219511126654966383287524278131752227961860806962678;
        weights[79] = 0.0156558357325155578600224341784309847555613964457064927;
        weights[80] = 0.0146724193344994642042645450238501024486329699044873327;
        weights[81] = 0.0136727886906068785064401933159972607496367824473291975;
        weights[82] = 0.0126580484976389944448251137900186573874499116420926219;
        weights[83] = 0.0116293201611224145960741283712199003995361454872051081;
        weights[84] = 0.0105877405649541222367243510962109022310985714685046869;
        weights[85] = 0.00953446083286515825006317020991343620548590355620144837;
        weights[86] = 0.00847064509453463599990965679935241906859701611312539086;
        weights[87] = 0.00739746928814235620086287840017360433714378904023085415;
        weights[88] = 0.00631612009103644822310764930106036886294979302588826901;
        weights[89] = 0.00522779428950776754530552172781598429761406907606819141;
        weights[90] = 0.00413369987540777648329713978750620172398360512921686863;
        weights[91] = 0.00303506589103862802739195607149431334962246491017460846;
        weights[92] = 0.00193321988872541894311762727600750366946723564068460693;
        weights[93] = 0.000830871612682162494641546324375110864622214772073354996;
        return;
    case 95:
        points[0] = -0.999682967707192019483573499623227492053318190764088977;
        points[1] = -0.998329952516746331615185023021732293429021998548509149;
        points[2] = -0.995897311188423402061515735452842108114861670048389865;
        points[3] = -0.992387135003501404489007395656823257654664455602174762;
        points[4] = -0.987803155906081287771609210267257178270672178957677653;
        points[5] = -0.98215031822162564610297086953165090104179061704572117;
        points[6] = -0.975434733411440911686142374579832670645956346668607075;
        points[7] = -0.96766366602219652411560894187490228464624768746386157;
        points[8] = -0.958845523847909449427667101142842751079581401783416078;
        points[9] = -0.948989848174295482042094922135074307261863638777220683;
        points[10] = -0.93810730319847803713625398072599718068138333102892825;
        points[11] = -0.926209664377719775633337969408961932808127530027122382;
        points[12] = -0.9133098056340673473978713272956811446980815442070563;
        points[13] = -0.899421685396393203740819738779921503742975664773115468;
        points[14] = -0.884560331481440557481542165750103421496938320779767702;
        points[15] = -0.868741824824129904742857793524387250297229162360632541;
        points[16] = -0.851983282071784280841952168647158581553031970684304971;
        points[17] = -0.834302837059601322207667365947626813569907265467492072;
        points[18] = -0.815719621186609653860229620898905731289793701749518451;
        points[19] = -0.796253742712893188667862788753426110200572924084949371;
        points[20] = -0.775926265000223956226837850592158053871511413726409357;
        points[21] = -0.754759183719492392253656515325417266208296901955887506;
        points[22] = -0.73277540304950211834271096929971069591369107056623448;
        points[23] = -0.709998710892823105801742982684734509547081268804850332;
        points[24] = -0.686453753135482209243488554856873441861382679573310624;
        points[25] = -0.662166006978318026262700936057387987989611054769143739;
        points[26] = -0.637161753368840027179724860511464629015919947495534227;
        points[27] = -0.611468048563410696074958268580060894873434913339159128;
        points[28] = -0.585112694850514089292358503597483519618486085696547039;
        points[29] = -0.558124210466784403949682407246020749851857293490388366;
        points[30] = -0.530531798738343289256909367452984067269701297408099995;
        points[31] = -0.502365316480834043324796972747022173997339307368089208;
        points[32] = -0.473655241692343777570580766948865430734572563172590103;
        points[33] = -0.444432640574170340460531680699199138927009784585191026;
        points[34] = -0.414729133915118515972148187530323025364069263138440545;
        points[35] = -0.384576862875699010848323446551268375907501365176347971;
        points[36] = -0.354008454209253305823369256584624441253463840643493412;
        points[37] = -0.323056984957636889277322416080176055584218056884952289;
        points[38] = -0.291755946659662073485054343459786023017058517142642558;
        points[39] = -0.260139209111028909464385597949174294809795757351324793;
        points[40] = -0.228240983714958103638210341000215032492173215857833028;
        points[41] = -0.196095786463182778498270954665938395869285142680167378;
        points[42] = -0.163738400587355934951945188446057818330888690434522491;
        points[43] = -0.131203838921287136147017106515162168821494227603567606;
        points[44] = -0.0985273060147348575202068516569647475498347736946310749;
        points[45] = -0.0657441600397497985725330818688104590313235378646452463;
        points[46] = -0.032889874530788938676985995672218424681578843835129408;
        points[47] = 0;
        points[48] = 0.032889874530788938676985995672218424681578843835129408;
        points[49] = 0.0657441600397497985725330818688104590313235378646452463;
        points[50] = 0.0985273060147348575202068516569647475498347736946310749;
        points[51] = 0.131203838921287136147017106515162168821494227603567606;
        points[52] = 0.163738400587355934951945188446057818330888690434522491;
        points[53] = 0.196095786463182778498270954665938395869285142680167378;
        points[54] = 0.228240983714958103638210341000215032492173215857833028;
        points[55] = 0.260139209111028909464385597949174294809795757351324793;
        points[56] = 0.291755946659662073485054343459786023017058517142642558;
        points[57] = 0.323056984957636889277322416080176055584218056884952289;
        points[58] = 0.354008454209253305823369256584624441253463840643493412;
        points[59] = 0.384576862875699010848323446551268375907501365176347971;
        points[60] = 0.414729133915118515972148187530323025364069263138440545;
        points[61] = 0.444432640574170340460531680699199138927009784585191026;
        points[62] = 0.473655241692343777570580766948865430734572563172590103;
        points[63] = 0.502365316480834043324796972747022173997339307368089208;
        points[64] = 0.530531798738343289256909367452984067269701297408099995;
        points[65] = 0.558124210466784403949682407246020749851857293490388366;
        points[66] = 0.585112694850514089292358503597483519618486085696547039;
        points[67] = 0.611468048563410696074958268580060894873434913339159128;
        points[68] = 0.637161753368840027179724860511464629015919947495534227;
        points[69] = 0.662166006978318026262700936057387987989611054769143739;
        points[70] = 0.686453753135482209243488554856873441861382679573310624;
        points[71] = 0.709998710892823105801742982684734509547081268804850332;
        points[72] = 0.73277540304950211834271096929971069591369107056623448;
        points[73] = 0.754759183719492392253656515325417266208296901955887506;
        points[74] = 0.775926265000223956226837850592158053871511413726409357;
        points[75] = 0.796253742712893188667862788753426110200572924084949371;
        points[76] = 0.815719621186609653860229620898905731289793701749518451;
        points[77] = 0.834302837059601322207667365947626813569907265467492072;
        points[78] = 0.851983282071784280841952168647158581553031970684304971;
        points[79] = 0.868741824824129904742857793524387250297229162360632541;
        points[80] = 0.884560331481440557481542165750103421496938320779767702;
        points[81] = 0.899421685396393203740819738779921503742975664773115468;
        points[82] = 0.9133098056340673473978713272956811446980815442070563;
        points[83] = 0.926209664377719775633337969408961932808127530027122382;
        points[84] = 0.93810730319847803713625398072599718068138333102892825;
        points[85] = 0.948989848174295482042094922135074307261863638777220683;
        points[86] = 0.958845523847909449427667101142842751079581401783416078;
        points[87] = 0.96766366602219652411560894187490228464624768746386157;
        points[88] = 0.975434733411440911686142374579832670645956346668607075;
        points[89] = 0.98215031822162564610297086953165090104179061704572117;
        points[90] = 0.987803155906081287771609210267257178270672178957677653;
        points[91] = 0.992387135003501404489007395656823257654664455602174762;
        points[92] = 0.995897311188423402061515735452842108114861670048389865;
        points[93] = 0.998329952516746331615185023021732293429021998548509149;
        points[94] = 0.999682967707192019483573499623227492053318190764088977;
        weights[0] = 0.000813564249454116501054404039377358554799629627435070514;
        weights[1] = 0.00189296837792293576277861288129759917163040375586804035;
        weights[2] = 0.00297192424081819071843905024107641580330529794004675397;
        weights[3] = 0.0040478033163717599068796916005031570546348206111970641;
        weights[4] = 0.00511933032992771828003244551879859354023071093300936021;
        weights[5] = 0.00618532626103332376931175732291119652647681763302468012;
        weights[6] = 0.00724463244393319967262590383897778816357663398181206931;
        weights[7] = 0.00829610087453099023814609554860888082356785729914726961;
        weights[8] = 0.00933859308387639708674062211995308868254747003668216223;
        weights[9] = 0.0103709807031160968408398445280165639034799094284966222;
        weights[10] = 0.0113921464590858440392424266514331450334374688985513316;
        weights[11] = 0.0124009852961160610401815021591699732124868378673805975;
        weights[12] = 0.0133964055343682854413657437462429289507714469710329121;
        weights[13] = 0.01437733003365908208357508213684241709964369611045004;
        weights[14] = 0.0153426973502883566345920132356366503111318309098246685;
        weights[15] = 0.0162914628809910432659155856713266014585819410574518237;
        weights[16] = 0.0172225999907169844133397098587060526180663331537437538;
        weights[17] = 0.018135101122045144107597008095462962041391592578161539;
        weights[18] = 0.0190279788845457063930701238893128290364462609858147705;
        weights[19] = 0.0199002671226572112448716509728688476242371975608056792;
        weights[20] = 0.020751021960784901817908466805241618371436786498402998;
        weights[21] = 0.0215793228244114012067686697456239652391678986904297164;
        weights[22] = 0.0223842734360693918404190424444346126396623188032292337;
        weights[23] = 0.0231650027850713917492001934063467024684570477307601153;
        weights[24] = 0.0239206660699306100770751932496647717776014758244404518;
        weights[25] = 0.0246504456124426199761296849076023329450282487789064196;
        weights[26] = 0.0253535517424320129365998605022552602579430701949699081;
        weights[27] = 0.0260292236522022715329006105730980414092161797371771335;
        weights[28] = 0.026676730219761354318968475882195997245892119925170275;
        weights[29] = 0.027295370799930222665783818463381580016299798939140088;
        weights[30] = 0.0278844759824769142430933778316287847322703733051891931;
        weights[31] = 0.0284434083164548626131188372175969889277854374533626744;
        weights[32] = 0.0289715629999610115348418392392462020178160463755541928;
        weights[33] = 0.0294683685345668823751514642708032182028492931066957049;
        weights[34] = 0.0299332873437141122524001181346421094297506419399806712;
        weights[35] = 0.0303658163544050667772436722529850232139174335845848727;
        weights[36] = 0.0307654875415589147529577676911123670299650397423429514;
        weights[37] = 0.0311318684344439982568226039751473448228284338324613601;
        weights[38] = 0.031464562584638402013217429855682404598683350582995066;
        weights[39] = 0.0317632099950122802909790019835383835381827568168188553;
        weights[40] = 0.0320274875092676952929573330991375502503271996470465265;
        weights[41] = 0.0322571091616144143473483488302403406749934675307959426;
        weights[42] = 0.03245182648620325926685945942981969238983433737403725;
        weights[43] = 0.0326114287859821542567065337383288474814298943246545522;
        weights[44] = 0.0327357433606839322691965867194363625607716567780799468;
        weights[45] = 0.0328246356936991866930888843050598348977668578607390341;
        weights[46] = 0.0328780095976319482355764582243212974475924973227719607;
        weights[47] = 0.032895807318380677932173986329810631604172359918653394;
        weights[48] = 0.0328780095976319482355764582243212974475924973227719607;
        weights[49] = 0.0328246356936991866930888843050598348977668578607390341;
        weights[50] = 0.0327357433606839322691965867194363625607716567780799468;
        weights[51] = 0.0326114287859821542567065337383288474814298943246545522;
        weights[52] = 0.03245182648620325926685945942981969238983433737403725;
        weights[53] = 0.0322571091616144143473483488302403406749934675307959426;
        weights[54] = 0.0320274875092676952929573330991375502503271996470465265;
        weights[55] = 0.0317632099950122802909790019835383835381827568168188553;
        weights[56] = 0.031464562584638402013217429855682404598683350582995066;
        weights[57] = 0.0311318684344439982568226039751473448228284338324613601;
        weights[58] = 0.0307654875415589147529577676911123670299650397423429514;
        weights[59] = 0.0303658163544050667772436722529850232139174335845848727;
        weights[60] = 0.0299332873437141122524001181346421094297506419399806712;
        weights[61] = 0.0294683685345668823751514642708032182028492931066957049;
        weights[62] = 0.0289715629999610115348418392392462020178160463755541928;
        weights[63] = 0.0284434083164548626131188372175969889277854374533626744;
        weights[64] = 0.0278844759824769142430933778316287847322703733051891931;
        weights[65] = 0.027295370799930222665783818463381580016299798939140088;
        weights[66] = 0.026676730219761354318968475882195997245892119925170275;
        weights[67] = 0.0260292236522022715329006105730980414092161797371771335;
        weights[68] = 0.0253535517424320129365998605022552602579430701949699081;
        weights[69] = 0.0246504456124426199761296849076023329450282487789064196;
        weights[70] = 0.0239206660699306100770751932496647717776014758244404518;
        weights[71] = 0.0231650027850713917492001934063467024684570477307601153;
        weights[72] = 0.0223842734360693918404190424444346126396623188032292337;
        weights[73] = 0.0215793228244114012067686697456239652391678986904297164;
        weights[74] = 0.020751021960784901817908466805241618371436786498402998;
        weights[75] = 0.0199002671226572112448716509728688476242371975608056792;
        weights[76] = 0.0190279788845457063930701238893128290364462609858147705;
        weights[77] = 0.018135101122045144107597008095462962041391592578161539;
        weights[78] = 0.0172225999907169844133397098587060526180663331537437538;
        weights[79] = 0.0162914628809910432659155856713266014585819410574518237;
        weights[80] = 0.0153426973502883566345920132356366503111318309098246685;
        weights[81] = 0.01437733003365908208357508213684241709964369611045004;
        weights[82] = 0.0133964055343682854413657437462429289507714469710329121;
        weights[83] = 0.0124009852961160610401815021591699732124868378673805975;
        weights[84] = 0.0113921464590858440392424266514331450334374688985513316;
        weights[85] = 0.0103709807031160968408398445280165639034799094284966222;
        weights[86] = 0.00933859308387639708674062211995308868254747003668216223;
        weights[87] = 0.00829610087453099023814609554860888082356785729914726961;
        weights[88] = 0.00724463244393319967262590383897778816357663398181206931;
        weights[89] = 0.00618532626103332376931175732291119652647681763302468012;
        weights[90] = 0.00511933032992771828003244551879859354023071093300936021;
        weights[91] = 0.0040478033163717599068796916005031570546348206111970641;
        weights[92] = 0.00297192424081819071843905024107641580330529794004675397;
        weights[93] = 0.00189296837792293576277861288129759917163040375586804035;
        weights[94] = 0.000813564249454116501054404039377358554799629627435070514;
        return;
    case 96:
        points[0] = -0.999689503883230766827690105784365519281545462732461992;
        points[1] = -0.998364375863181677724149439526719363387594139835729017;
        points[2] = -0.995981842987209290650399084879356600517402559209160943;
        points[3] = -0.99254390032376262457189229770160114087692506973570775;
        points[4] = -0.988054126329623799480762772418451194550464600614148887;
        points[5] = -0.982517263563014677447045831882548117944975813090718914;
        points[6] = -0.975939174585136466452601034241879909198402954596115603;
        points[7] = -0.968326828463264212173659366443651058392644248094522139;
        points[8] = -0.959688291448742539300068025884734741187348366471208901;
        points[9] = -0.950032717784437635756098948443863487809719004506856487;
        points[10] = -0.939370339752755216931857379431615218355268147050047161;
        points[11] = -0.927712456722308690964690472696546386905782485701430507;
        points[12] = -0.915071423120898074205884466150421542087076418905500877;
        points[13] = -0.901460635315852341319232697309686837840871379740481507;
        points[14] = -0.886894517402420416056877433393786158831992645040230133;
        points[15] = -0.871388505909296502873774764493042714723198637127069591;
        points[16] = -0.854959033434601455462786969893569260642796030025999113;
        points[17] = -0.837623511228187121494302816764692856979480843148001739;
        points[18] = -0.81940031073793167553899962422447803513534721938361199;
        points[19] = -0.800308744139140817228796143971327683216455575426421064;
        points[20] = -0.780369043867433217603604455889317748020183381435905391;
        points[21] = -0.759602341176647498702970441119621615853418684350547741;
        points[22] = -0.738030643744400132851165731096497105229719705861680951;
        points[23] = -0.715676812348967626225144148057624855297579970512471934;
        points[24] = -0.69256453664217156134424576981824255945409652925885549;
        points[25] = -0.668718310043916153952557207572774189024490620911704758;
        points[26] = -0.644163403784967106798412350063301562303099204075871448;
        points[27] = -0.618925840125468570386369286987862797385924304294141342;
        points[28] = -0.593032364777572080683555755043758213173602137510373637;
        points[29] = -0.566510418561397168404250195083462632310682605494345364;
        points[30] = -0.539388108324357436226802597325560638174530629095712515;
        points[31] = -0.511694177154667673585509745428854303249444739448960954;
        points[32] = -0.483457973920596359768405609363895255471251618004483453;
        points[33] = -0.454709422167743008635676148086307813004007115883888851;
        points[34] = -0.425478988407300545364819203569997944814789637986203949;
        points[35] = -0.395797649828908603285000243135164159712183375710416394;
        points[36] = -0.365696861472313635030895593995473177231187449038795705;
        points[37] = -0.335208522892625422616325624805628672187087106202021356;
        points[38] = -0.304364944354496353023929779295203318151177118276838665;
        points[39] = -0.273198812591049141487272155724564794448183995393695188;
        points[40] = -0.241743156163840012327931903740627670311558222423913512;
        points[41] = -0.210031310460567203602847185712295775144230109414068965;
        points[42] = -0.178096882367618602759402625176491514914388330285849051;
        points[43] = -0.145973714654896941989107333343326460474308991614777126;
        points[44] = -0.113695850110665920911208095414328080625474625430467506;
        points[45] = -0.0812974954644255589944712629747528587782948873116646446;
        points[46] = -0.048812985136049731111958204261275057080951125710578124;
        points[47] = -0.016276744849602969579134563695238453562045890115891553;
        points[48] = 0.016276744849602969579134563695238453562045890115891553;
        points[49] = 0.048812985136049731111958204261275057080951125710578124;
        points[50] = 0.0812974954644255589944712629747528587782948873116646446;
        points[51] = 0.113695850110665920911208095414328080625474625430467506;
        points[52] = 0.145973714654896941989107333343326460474308991614777126;
        points[53] = 0.178096882367618602759402625176491514914388330285849051;
        points[54] = 0.210031310460567203602847185712295775144230109414068965;
        points[55] = 0.241743156163840012327931903740627670311558222423913512;
        points[56] = 0.273198812591049141487272155724564794448183995393695188;
        points[57] = 0.304364944354496353023929779295203318151177118276838665;
        points[58] = 0.335208522892625422616325624805628672187087106202021356;
        points[59] = 0.365696861472313635030895593995473177231187449038795705;
        points[60] = 0.395797649828908603285000243135164159712183375710416394;
        points[61] = 0.425478988407300545364819203569997944814789637986203949;
        points[62] = 0.454709422167743008635676148086307813004007115883888851;
        points[63] = 0.483457973920596359768405609363895255471251618004483453;
        points[64] = 0.511694177154667673585509745428854303249444739448960954;
        points[65] = 0.539388108324357436226802597325560638174530629095712515;
        points[66] = 0.566510418561397168404250195083462632310682605494345364;
        points[67] = 0.593032364777572080683555755043758213173602137510373637;
        points[68] = 0.618925840125468570386369286987862797385924304294141342;
        points[69] = 0.644163403784967106798412350063301562303099204075871448;
        points[70] = 0.668718310043916153952557207572774189024490620911704758;
        points[71] = 0.69256453664217156134424576981824255945409652925885549;
        points[72] = 0.715676812348967626225144148057624855297579970512471934;
        points[73] = 0.738030643744400132851165731096497105229719705861680951;
        points[74] = 0.759602341176647498702970441119621615853418684350547741;
        points[75] = 0.780369043867433217603604455889317748020183381435905391;
        points[76] = 0.800308744139140817228796143971327683216455575426421064;
        points[77] = 0.81940031073793167553899962422447803513534721938361199;
        points[78] = 0.837623511228187121494302816764692856979480843148001739;
        points[79] = 0.854959033434601455462786969893569260642796030025999113;
        points[80] = 0.871388505909296502873774764493042714723198637127069591;
        points[81] = 0.886894517402420416056877433393786158831992645040230133;
        points[82] = 0.901460635315852341319232697309686837840871379740481507;
        points[83] = 0.915071423120898074205884466150421542087076418905500877;
        points[84] = 0.927712456722308690964690472696546386905782485701430507;
        points[85] = 0.939370339752755216931857379431615218355268147050047161;
        points[86] = 0.950032717784437635756098948443863487809719004506856487;
        points[87] = 0.959688291448742539300068025884734741187348366471208901;
        points[88] = 0.968326828463264212173659366443651058392644248094522139;
        points[89] = 0.975939174585136466452601034241879909198402954596115603;
        points[90] = 0.982517263563014677447045831882548117944975813090718914;
        points[91] = 0.988054126329623799480762772418451194550464600614148887;
        points[92] = 0.99254390032376262457189229770160114087692506973570775;
        points[93] = 0.995981842987209290650399084879356600517402559209160943;
        points[94] = 0.998364375863181677724149439526719363387594139835729017;
        points[95] = 0.999689503883230766827690105784365519281545462732461992;
        weights[0] = 0.000796792065552012429438143496943568759931086922826873755;
        weights[1] = 0.00185396078894692173233592535089391058820828837627717792;
        weights[2] = 0.00291073181793494640841061798940072500974716933723432247;
        weights[3] = 0.00396455433844468667373341576741965987769124792286589082;
        weights[4] = 0.00501420274292751769247019496903089847407411247388113445;
        weights[5] = 0.00605854550423596168331674203172908796957815120935606594;
        weights[6] = 0.00709647079115386526914416081214339193477209930469355064;
        weights[7] = 0.00812687692569875921738242770785593773424476032083815331;
        weights[8] = 0.00914867123078338663258460266520792852644880197113323965;
        weights[9] = 0.010160770535008415757587636953825368848984845861045913;
        weights[10] = 0.0111621020998384985912132638285620686108639634221780364;
        weights[11] = 0.0121516046710883196351813527366672521223706438505791112;
        weights[12] = 0.0131282295669615726370636669025991088987756993130077046;
        weights[13] = 0.0140909417723148609158616247246366395183921510371114713;
        weights[14] = 0.0150387210269949380058762752220975528373848339706362924;
        weights[15] = 0.0159705629025622913806164567914930510609914827093368478;
        weights[16] = 0.01688547986424517245047754060686192665259961412081062;
        weights[17] = 0.0177825023160452608376142264860710160638992399079067546;
        weights[18] = 0.0186606796274114673851567586221322190641440517092818581;
        weights[19] = 0.0195190811401450224100852202812046864878588810137370017;
        weights[20] = 0.0203567971543333245952452154172716143420689695539518086;
        weights[21] = 0.021172939892191298987673867191003700767616976373645352;
        weights[22] = 0.0219666444387443491947563868015622362501689564134981285;
        weights[23] = 0.0227370696583293740013478419774902863557003246008265383;
        weights[24] = 0.0234833990859262198422359326676125809547655951822102066;
        weights[25] = 0.0242048417923646912822673378726770389498324915750324734;
        weights[26] = 0.0249006332224836102883821808683327364536780586124404411;
        weights[27] = 0.0255700360053493614987971679436000860963400546942244664;
        weights[28] = 0.026212340735672413913457963964463343561605997311238191;
        weights[29] = 0.026826866725591762198056728714156645865322720814034198;
        weights[30] = 0.0274129627260292428234210874890912706985729610745407043;
        weights[31] = 0.0279700076168483344398185765890225078448913058867776799;
        weights[32] = 0.0284974110650853856455995129458056045696972983517557954;
        weights[33] = 0.0289946141505552365426787812796815730550155009176210465;
        weights[34] = 0.0294610899581679059704363321828584492516225204134311777;
        weights[35] = 0.0298963441363283859843880757944000605401611633433841899;
        weights[36] = 0.0302999154208275937940887642065009140703177802176811632;
        weights[37] = 0.0306713761236691490142288303562042762724238454828697272;
        weights[38] = 0.0310103325863138374232497799706326368443931363825004859;
        weights[39] = 0.0313164255968613558127842667150631281757102946068500425;
        weights[40] = 0.0315893307707271685580207461699641601250344711893854736;
        weights[41] = 0.031828758894411006534753739885532253497890898885610561;
        weights[42] = 0.0320344562319926632181389774702111629945035791824089311;
        weights[43] = 0.03220620479403025066866711455723251850391779338813946;
        weights[44] = 0.0323438225685759284287748388289432704281009628999695491;
        weights[45] = 0.0324471637140642693640127884488458583333736353005470493;
        weights[46] = 0.0325161187138688359872054914477783546690035691334899915;
        weights[47] = 0.0325506144923631662419614182972857314873080134571971482;
        weights[48] = 0.0325506144923631662419614182972857314873080134571971482;
        weights[49] = 0.0325161187138688359872054914477783546690035691334899915;
        weights[50] = 0.0324471637140642693640127884488458583333736353005470493;
        weights[51] = 0.0323438225685759284287748388289432704281009628999695491;
        weights[52] = 0.03220620479403025066866711455723251850391779338813946;
        weights[53] = 0.0320344562319926632181389774702111629945035791824089311;
        weights[54] = 0.031828758894411006534753739885532253497890898885610561;
        weights[55] = 0.0315893307707271685580207461699641601250344711893854736;
        weights[56] = 0.0313164255968613558127842667150631281757102946068500425;
        weights[57] = 0.0310103325863138374232497799706326368443931363825004859;
        weights[58] = 0.0306713761236691490142288303562042762724238454828697272;
        weights[59] = 0.0302999154208275937940887642065009140703177802176811632;
        weights[60] = 0.0298963441363283859843880757944000605401611633433841899;
        weights[61] = 0.0294610899581679059704363321828584492516225204134311777;
        weights[62] = 0.0289946141505552365426787812796815730550155009176210465;
        weights[63] = 0.0284974110650853856455995129458056045696972983517557954;
        weights[64] = 0.0279700076168483344398185765890225078448913058867776799;
        weights[65] = 0.0274129627260292428234210874890912706985729610745407043;
        weights[66] = 0.026826866725591762198056728714156645865322720814034198;
        weights[67] = 0.026212340735672413913457963964463343561605997311238191;
        weights[68] = 0.0255700360053493614987971679436000860963400546942244664;
        weights[69] = 0.0249006332224836102883821808683327364536780586124404411;
        weights[70] = 0.0242048417923646912822673378726770389498324915750324734;
        weights[71] = 0.0234833990859262198422359326676125809547655951822102066;
        weights[72] = 0.0227370696583293740013478419774902863557003246008265383;
        weights[73] = 0.0219666444387443491947563868015622362501689564134981285;
        weights[74] = 0.021172939892191298987673867191003700767616976373645352;
        weights[75] = 0.0203567971543333245952452154172716143420689695539518086;
        weights[76] = 0.0195190811401450224100852202812046864878588810137370017;
        weights[77] = 0.0186606796274114673851567586221322190641440517092818581;
        weights[78] = 0.0177825023160452608376142264860710160638992399079067546;
        weights[79] = 0.01688547986424517245047754060686192665259961412081062;
        weights[80] = 0.0159705629025622913806164567914930510609914827093368478;
        weights[81] = 0.0150387210269949380058762752220975528373848339706362924;
        weights[82] = 0.0140909417723148609158616247246366395183921510371114713;
        weights[83] = 0.0131282295669615726370636669025991088987756993130077046;
        weights[84] = 0.0121516046710883196351813527366672521223706438505791112;
        weights[85] = 0.0111621020998384985912132638285620686108639634221780364;
        weights[86] = 0.010160770535008415757587636953825368848984845861045913;
        weights[87] = 0.00914867123078338663258460266520792852644880197113323965;
        weights[88] = 0.00812687692569875921738242770785593773424476032083815331;
        weights[89] = 0.00709647079115386526914416081214339193477209930469355064;
        weights[90] = 0.00605854550423596168331674203172908796957815120935606594;
        weights[91] = 0.00501420274292751769247019496903089847407411247388113445;
        weights[92] = 0.00396455433844468667373341576741965987769124792286589082;
        weights[93] = 0.00291073181793494640841061798940072500974716933723432247;
        weights[94] = 0.00185396078894692173233592535089391058820828837627717792;
        weights[95] = 0.000796792065552012429438143496943568759931086922826873755;
        return;
    case 97:
        points[0] = -0.99969583999524672491196788854352537581119252485288877;
        points[1] = -0.998397745860566436733244243116458367064560140420794061;
        points[2] = -0.996063789477488413024311805476864021704936793172046161;
        points[3] = -0.992695874778551609258150292615755375704630700215522603;
        points[4] = -0.988297434501838787317893544167560492623267262012596279;
        points[5] = -0.982873019613528351035923788570189794543087349506517103;
        points[6] = -0.976428256308619764924244830883045963832042867057827175;
        points[7] = -0.968969833034950922100110122032254599876716832877701312;
        points[8] = -0.960505491652787246157486450449083606115726514251227074;
        points[9] = -0.951044018766639195210907419168001353062000032213508227;
        points[10] = -0.940595236358027984371684870846900069928592775372540588;
        points[11] = -0.929169991481619140822260180012453443566425578738645079;
        points[12] = -0.916780144953188888049795999482303912739355736058778694;
        points[13] = -0.90343855901012161641491233419273437246449165501717415;
        points[14] = -0.889159083944300362039028599158112839358544428882262663;
        points[15] = -0.873956543715414215359203312388027335331203249978449263;
        points[16] = -0.857846720556790301260558105700068093719671730014923443;
        points[17] = -0.840846338588286767457514933820386752859836017313906709;
        points[18] = -0.822973046452484441750419840027657701437432055393491895;
        points[19] = -0.804245398991770565478887960139870890551767394106937079;
        points[20] = -0.784682837985085728830414310449783609929658481485677151;
        points[21] = -0.764305671964182056902005659311732623700666373595803584;
        points[22] = -0.743135055130253938043062157536985240899541761099823768;
        points[23] = -0.721192965392770524946237090905544813400920926729921004;
        points[24] = -0.698502181553271116636779300611390854424510513152205639;
        points[25] = -0.675086259657784965824565276043240850115525530190918509;
        points[26] = -0.650969508542408255109624198700846224445681840957016011;
        points[27] = -0.626176964597413854512988540320122727615147984676477535;
        points[28] = -0.600734365776084208376919266344799599299384963266109414;
        points[29] = -0.5746681248752441043273775149362131861939964055426648;
        points[30] = -0.548005302115227734655985852214177297820924129161164055;
        points[31] = -0.520773577047742836547220111589787726137864533721980232;
        points[32] = -0.493001219820793197245320592043697216551987356880315449;
        points[33] = -0.464717061830488813407275677399384001806951137851317031;
        points[34] = -0.435950465790209876438385537127269005718960069660890058;
        points[35] = -0.406731295248195902884205980773356372064962831094281464;
        points[36] = -0.377089883585204144300973019465418252757471625829204612;
        points[37] = -0.347057002524421321481913370351534699489484535421236812;
        points[38] = -0.316663830186319188061197580532581021443754951430887061;
        points[39] = -0.285941918721616923173769417728987280460575816863239639;
        points[40] = -0.254923161555951399025067249830567318049582926196165818;
        points[41] = -0.223639760280259517555185298303289074859557250369009994;
        points[42] = -0.192124191221244646235720057751940384944653449612336774;
        points[43] = -0.160409171726631327382780433059152053317921224654898102;
        points[44] = -0.128527626200208545469683297152297233604962210369004994;
        points[45] = -0.0965126519219216069016568762186200136723225580323167795;
        points[46] = -0.0643974846884958480218846428579015402280462001640249501;
        points[47] = -0.0322154643102617089110519882517114965433055717679583487;
        points[48] = 0;
        points[49] = 0.0322154643102617089110519882517114965433055717679583487;
        points[50] = 0.0643974846884958480218846428579015402280462001640249501;
        points[51] = 0.0965126519219216069016568762186200136723225580323167795;
        points[52] = 0.128527626200208545469683297152297233604962210369004994;
        points[53] = 0.160409171726631327382780433059152053317921224654898102;
        points[54] = 0.192124191221244646235720057751940384944653449612336774;
        points[55] = 0.223639760280259517555185298303289074859557250369009994;
        points[56] = 0.254923161555951399025067249830567318049582926196165818;
        points[57] = 0.285941918721616923173769417728987280460575816863239639;
        points[58] = 0.316663830186319188061197580532581021443754951430887061;
        points[59] = 0.347057002524421321481913370351534699489484535421236812;
        points[60] = 0.377089883585204144300973019465418252757471625829204612;
        points[61] = 0.406731295248195902884205980773356372064962831094281464;
        points[62] = 0.435950465790209876438385537127269005718960069660890058;
        points[63] = 0.464717061830488813407275677399384001806951137851317031;
        points[64] = 0.493001219820793197245320592043697216551987356880315449;
        points[65] = 0.520773577047742836547220111589787726137864533721980232;
        points[66] = 0.548005302115227734655985852214177297820924129161164055;
        points[67] = 0.5746681248752441043273775149362131861939964055426648;
        points[68] = 0.600734365776084208376919266344799599299384963266109414;
        points[69] = 0.626176964597413854512988540320122727615147984676477535;
        points[70] = 0.650969508542408255109624198700846224445681840957016011;
        points[71] = 0.675086259657784965824565276043240850115525530190918509;
        points[72] = 0.698502181553271116636779300611390854424510513152205639;
        points[73] = 0.721192965392770524946237090905544813400920926729921004;
        points[74] = 0.743135055130253938043062157536985240899541761099823768;
        points[75] = 0.764305671964182056902005659311732623700666373595803584;
        points[76] = 0.784682837985085728830414310449783609929658481485677151;
        points[77] = 0.804245398991770565478887960139870890551767394106937079;
        points[78] = 0.822973046452484441750419840027657701437432055393491895;
        points[79] = 0.840846338588286767457514933820386752859836017313906709;
        points[80] = 0.857846720556790301260558105700068093719671730014923443;
        points[81] = 0.873956543715414215359203312388027335331203249978449263;
        points[82] = 0.889159083944300362039028599158112839358544428882262663;
        points[83] = 0.90343855901012161641491233419273437246449165501717415;
        points[84] = 0.916780144953188888049795999482303912739355736058778694;
        points[85] = 0.929169991481619140822260180012453443566425578738645079;
        points[86] = 0.940595236358027984371684870846900069928592775372540588;
        points[87] = 0.951044018766639195210907419168001353062000032213508227;
        points[88] = 0.960505491652787246157486450449083606115726514251227074;
        points[89] = 0.968969833034950922100110122032254599876716832877701312;
        points[90] = 0.976428256308619764924244830883045963832042867057827175;
        points[91] = 0.982873019613528351035923788570189794543087349506517103;
        points[92] = 0.988297434501838787317893544167560492623267262012596279;
        points[93] = 0.992695874778551609258150292615755375704630700215522603;
        points[94] = 0.996063789477488413024311805476864021704936793172046161;
        points[95] = 0.998397745860566436733244243116458367064560140420794061;
        points[96] = 0.99969583999524672491196788854352537581119252485288877;
        weights[0] = 0.000780533221942561245723572332866176518622107896005783394;
        weights[1] = 0.00181614639821003960950769507938420753651272086567298998;
        weights[2] = 0.00285140924321305577141950805574457616237735876647148964;
        weights[3] = 0.00388384532948929442173265234923397750815878430035947075;
        weights[4] = 0.00491227626216602813083528224219242846894464943163170327;
        weights[5] = 0.00593561563078822295418329695333740671716672386724488882;
        weights[6] = 0.00695279609646940552646513099899337572289804499663949081;
        weights[7] = 0.00796275999786549559559865886374410518347820967141719618;
        weights[8] = 0.00896445817669799943256518441260437338732559902614255614;
        weights[9] = 0.00995685042708404494823785358207602476015081569263179632;
        weights[10] = 0.0109389063591959489539671602004854943371675833757700648;
        weights[11] = 0.0119096063853307568327362308910829165610195649060208163;
        weights[12] = 0.0128679427424933866757113519643176127583399222302706375;
        weights[13] = 0.0138129205218530432711490047584341318241797656840677778;
        weights[14] = 0.0147435586932369501763598246196342940030076800063990049;
        weights[15] = 0.0156588911191569205202070069102609730867731977545383319;
        weights[16] = 0.0165579675553424566290280726106140976952323062053492874;
        weights[17] = 0.0174398546358078046394054910249783339419529491760455616;
        weights[18] = 0.0183036368409641408222915990396983152310172729856617059;
        weights[19] = 0.0191484174475281293352566903485527880973850268720641473;
        weights[20] = 0.0199733194591080468881891659731113248962725356228994396;
        weights[21] = 0.0207774865164265684979897752277945947021085885851748164;
        weights[22] = 0.0215600837861917182784347109816934260834268957535106912;
        weights[23] = 0.022320298827667132378623154626353982933503589099979288;
        weights[24] = 0.0230573424360259957963961659968939432560876720469157305;
        weights[25] = 0.0237704494616030688210418479536270384947014045072118036;
        weights[26] = 0.0244588796041878472905995990660240188760674469211676956;
        weights[27] = 0.0251219181815300467356521274132282565098754101353833133;
        weights[28] = 0.0257588768712567848953522565851150176347000101221757151;
        weights[29] = 0.0263690944254293497570785297109834441360173559521287614;
        weights[30] = 0.0269519373569964406736335798685139244148451868235457572;
        weights[31] = 0.0275068005974303425600962000268501086459677918597999421;
        weights[32] = 0.028033108124862677526805309563267814726477642816348804;
        weights[33] = 0.0285303135620671875182380016416915478204231258304116514;
        weights[34] = 0.0289979007436684318720523443203490661679141134897799947;
        weights[35] = 0.0294353842519873208642428892799745176606555639074319714;
        weights[36] = 0.0298423099209670290345781913333839914526306476679316139;
        weights[37] = 0.0302182553076560145345207512480239079288104127841631919;
        weights[38] = 0.0305628301307585838613509917693859281619171567286102445;
        weights[39] = 0.030875676675797653824326456949727271198983329980642752;
        weights[40] = 0.0311564701664690414577510966539452003375409399935674546;
        weights[41] = 0.0314049191018017236245779804169194196460245679434191801;
        weights[42] = 0.0316207655587740160429490535003384111271148501189199173;
        weights[43] = 0.0318037854600714904449536939937412170413620803666995578;
        weights[44] = 0.0319537888067086419452838195298000831877559560011244458;
        weights[45] = 0.032070619875272799349279527313301872116939327714776323;
        weights[46] = 0.0321541573795855015357799897485343342502113244718008061;
        weights[47] = 0.0322043145966135053347574824254700989220276730375748261;
        weights[48] = 0.0322210394564987063261680792874412563358542320129992219;
        weights[49] = 0.0322043145966135053347574824254700989220276730375748261;
        weights[50] = 0.0321541573795855015357799897485343342502113244718008061;
        weights[51] = 0.032070619875272799349279527313301872116939327714776323;
        weights[52] = 0.0319537888067086419452838195298000831877559560011244458;
        weights[53] = 0.0318037854600714904449536939937412170413620803666995578;
        weights[54] = 0.0316207655587740160429490535003384111271148501189199173;
        weights[55] = 0.0314049191018017236245779804169194196460245679434191801;
        weights[56] = 0.0311564701664690414577510966539452003375409399935674546;
        weights[57] = 0.030875676675797653824326456949727271198983329980642752;
        weights[58] = 0.0305628301307585838613509917693859281619171567286102445;
        weights[59] = 0.0302182553076560145345207512480239079288104127841631919;
        weights[60] = 0.0298423099209670290345781913333839914526306476679316139;
        weights[61] = 0.0294353842519873208642428892799745176606555639074319714;
        weights[62] = 0.0289979007436684318720523443203490661679141134897799947;
        weights[63] = 0.0285303135620671875182380016416915478204231258304116514;
        weights[64] = 0.028033108124862677526805309563267814726477642816348804;
        weights[65] = 0.0275068005974303425600962000268501086459677918597999421;
        weights[66] = 0.0269519373569964406736335798685139244148451868235457572;
        weights[67] = 0.0263690944254293497570785297109834441360173559521287614;
        weights[68] = 0.0257588768712567848953522565851150176347000101221757151;
        weights[69] = 0.0251219181815300467356521274132282565098754101353833133;
        weights[70] = 0.0244588796041878472905995990660240188760674469211676956;
        weights[71] = 0.0237704494616030688210418479536270384947014045072118036;
        weights[72] = 0.0230573424360259957963961659968939432560876720469157305;
        weights[73] = 0.022320298827667132378623154626353982933503589099979288;
        weights[74] = 0.0215600837861917182784347109816934260834268957535106912;
        weights[75] = 0.0207774865164265684979897752277945947021085885851748164;
        weights[76] = 0.0199733194591080468881891659731113248962725356228994396;
        weights[77] = 0.0191484174475281293352566903485527880973850268720641473;
        weights[78] = 0.0183036368409641408222915990396983152310172729856617059;
        weights[79] = 0.0174398546358078046394054910249783339419529491760455616;
        weights[80] = 0.0165579675553424566290280726106140976952323062053492874;
        weights[81] = 0.0156588911191569205202070069102609730867731977545383319;
        weights[82] = 0.0147435586932369501763598246196342940030076800063990049;
        weights[83] = 0.0138129205218530432711490047584341318241797656840677778;
        weights[84] = 0.0128679427424933866757113519643176127583399222302706375;
        weights[85] = 0.0119096063853307568327362308910829165610195649060208163;
        weights[86] = 0.0109389063591959489539671602004854943371675833757700648;
        weights[87] = 0.00995685042708404494823785358207602476015081569263179632;
        weights[88] = 0.00896445817669799943256518441260437338732559902614255614;
        weights[89] = 0.00796275999786549559559865886374410518347820967141719618;
        weights[90] = 0.00695279609646940552646513099899337572289804499663949081;
        weights[91] = 0.00593561563078822295418329695333740671716672386724488882;
        weights[92] = 0.00491227626216602813083528224219242846894464943163170327;
        weights[93] = 0.00388384532948929442173265234923397750815878430035947075;
        weights[94] = 0.00285140924321305577141950805574457616237735876647148964;
        weights[95] = 0.00181614639821003960950769507938420753651272086567298998;
        weights[96] = 0.000780533221942561245723572332866176518622107896005783394;
        return;
    case 98:
        points[0] = -0.999701984125490903637294903699706698825676784610738649;
        points[1] = -0.998430105047230453778693200770121165749238679985637869;
        points[2] = -0.99614325499685929606297970911180555420353178169281862;
        points[3] = -0.992843251536906730131880047397721659511641185333128291;
        points[4] = -0.988533388989158168372172990935676966211626408179278801;
        points[5] = -0.98321803629372299128533775926417861282577069031497232;
        points[6] = -0.976902595063886082499069431875122190687578326086182361;
        points[7] = -0.969593487100794472319864017318487637329609603245505799;
        points[8] = -0.961298146002891057710417600091940500190714386886636804;
        points[9] = -0.952025008986401501308772191988785114081292397890323885;
        points[10] = -0.941783508062711821098796246330444590047470643352623648;
        points[11] = -0.930584060339307042124495170042601405566973168248991396;
        points[12] = -0.918438057373568117197213650489391816781848365287489137;
        points[13] = -0.905357853559839135953333026220753117895395580294922074;
        points[14] = -0.891356753548891066431956996858751273237690167048383563;
        points[15] = -0.876448998706844105112915085046742391678118361255516751;
        points[16] = -0.86064975262455175315900723441226512349318277732135176;
        points[17] = -0.843975085690770467285956239472304867206402468364355599;
        points[18] = -0.82644195874404785510778528296337807985532579922546133;
        points[19] = -0.808068205819534351294907251735630275481729292351433805;
        points[20] = -0.788872516008022266700966733336040199286314430150783778;
        points[21] = -0.768874414445517797116596242056560065791105414921354637;
        points[22] = -0.74809424245259245064056664920918849892790840699835234;
        points[23] = -0.726553136843658480912569837242185078841461216120635205;
        points[24] = -0.704273008427177423656976748521318030528705945340488294;
        points[25] = -0.681276519718646320796038782746286817763451676655437321;
        points[26] = -0.657587061889014905160305196086080612021245660178114949;
        points[27] = -0.633228730971969861881956414614178268259499575813721331;
        points[28] = -0.608226303354279533514416933120736286571522576444287933;
        points[29] = -0.582605210574123959653296159508791403228997587364459963;
        points[30] = -0.556391513453040586457397532838283759096584540195504431;
        points[31] = -0.529611875587794876248435658463843494434719182150991514;
        points[32] = -0.502293536229136859823462424437551884560780465067272195;
        points[33] = -0.4744642825750288441270225534663890651780903840685333;
        points[34] = -0.446152421506525448597056953273226189617475606013645839;
        points[35] = -0.417386750795054334181470372049974237341031611083531067;
        points[36] = -0.38819652981038386372030425860145438340283486164797454;
        points[37] = -0.358611449759071965248416706709047801533514768549076151;
        points[38] = -0.328661603483668158817608889932987324014075292021351094;
        points[39] = -0.298377454853387577158828103964937088323076296876494332;
        points[40] = -0.267789807777391413732746928877745895212939100556565912;
        points[41] = -0.236929774872192150992227780227777657334481201867947245;
        points[42] = -0.205828745815053770307664547996454120924784011052122826;
        points[43] = -0.174518355415576567874967402495222369632185287939365438;
        points[44] = -0.143030451437942875166029985625521584600296619398096478;
        points[45] = -0.111397062206553617998208088256728671871195075963248823;
        points[46] = -0.079650364028005988212933627785257437986072375832257598;
        points[47] = -0.0478226484625493229627676881272504249903922269714368276;
        points[48] = -0.0159462894783093992875635674154467722381434065330484679;
        points[49] = 0.0159462894783093992875635674154467722381434065330484679;
        points[50] = 0.0478226484625493229627676881272504249903922269714368276;
        points[51] = 0.079650364028005988212933627785257437986072375832257598;
        points[52] = 0.111397062206553617998208088256728671871195075963248823;
        points[53] = 0.143030451437942875166029985625521584600296619398096478;
        points[54] = 0.174518355415576567874967402495222369632185287939365438;
        points[55] = 0.205828745815053770307664547996454120924784011052122826;
        points[56] = 0.236929774872192150992227780227777657334481201867947245;
        points[57] = 0.267789807777391413732746928877745895212939100556565912;
        points[58] = 0.298377454853387577158828103964937088323076296876494332;
        points[59] = 0.328661603483668158817608889932987324014075292021351094;
        points[60] = 0.358611449759071965248416706709047801533514768549076151;
        points[61] = 0.38819652981038386372030425860145438340283486164797454;
        points[62] = 0.417386750795054334181470372049974237341031611083531067;
        points[63] = 0.446152421506525448597056953273226189617475606013645839;
        points[64] = 0.4744642825750288441270225534663890651780903840685333;
        points[65] = 0.502293536229136859823462424437551884560780465067272195;
        points[66] = 0.529611875587794876248435658463843494434719182150991514;
        points[67] = 0.556391513453040586457397532838283759096584540195504431;
        points[68] = 0.582605210574123959653296159508791403228997587364459963;
        points[69] = 0.608226303354279533514416933120736286571522576444287933;
        points[70] = 0.633228730971969861881956414614178268259499575813721331;
        points[71] = 0.657587061889014905160305196086080612021245660178114949;
        points[72] = 0.681276519718646320796038782746286817763451676655437321;
        points[73] = 0.704273008427177423656976748521318030528705945340488294;
        points[74] = 0.726553136843658480912569837242185078841461216120635205;
        points[75] = 0.74809424245259245064056664920918849892790840699835234;
        points[76] = 0.768874414445517797116596242056560065791105414921354637;
        points[77] = 0.788872516008022266700966733336040199286314430150783778;
        points[78] = 0.808068205819534351294907251735630275481729292351433805;
        points[79] = 0.82644195874404785510778528296337807985532579922546133;
        points[80] = 0.843975085690770467285956239472304867206402468364355599;
        points[81] = 0.86064975262455175315900723441226512349318277732135176;
        points[82] = 0.876448998706844105112915085046742391678118361255516751;
        points[83] = 0.891356753548891066431956996858751273237690167048383563;
        points[84] = 0.905357853559839135953333026220753117895395580294922074;
        points[85] = 0.918438057373568117197213650489391816781848365287489137;
        points[86] = 0.930584060339307042124495170042601405566973168248991396;
        points[87] = 0.941783508062711821098796246330444590047470643352623648;
        points[88] = 0.952025008986401501308772191988785114081292397890323885;
        points[89] = 0.961298146002891057710417600091940500190714386886636804;
        points[90] = 0.969593487100794472319864017318487637329609603245505799;
        points[91] = 0.976902595063886082499069431875122190687578326086182361;
        points[92] = 0.98321803629372299128533775926417861282577069031497232;
        points[93] = 0.988533388989158168372172990935676966211626408179278801;
        points[94] = 0.992843251536906730131880047397721659511641185333128291;
        points[95] = 0.99614325499685929606297970911180555420353178169281862;
        points[96] = 0.998430105047230453778693200770121165749238679985637869;
        points[97] = 0.999701984125490903637294903699706698825676784610738649;
        weights[0] = 0.000764766982274313458039246045523111842930560138505291125;
        weights[1] = 0.00177947704101452874169543580849208305416400789392746247;
        weights[2] = 0.00279388113572213087062971717882947178044724939260580443;
        weights[3] = 0.00380557408535235956551511904981042603803666944760404742;
        weights[4] = 0.0048134223985867709184778146773680437849528281067933371;
        weights[5] = 0.00581638254643963911276316673944398970454508763774376218;
        weights[6] = 0.00681342947916521599877209570929536815846397676814820051;
        weights[7] = 0.00780354737910075489097998010383950616743912582382996564;
        weights[8] = 0.00878572846739226320269938871004306412487794931814659483;
        weights[9] = 0.0097589734021740968353478749292888170820862440651088737;
        weights[10] = 0.0107222920832243171202440477009196327435549038757565031;
        weights[11] = 0.0116747045771381242874287672806583956745173455381915229;
        weights[12] = 0.0126152420789219528577814324588362573358398405403538904;
        weights[13] = 0.0135429478810294651436476062409750333189575737141294463;
        weights[14] = 0.0144568783383044019775689108017987574569742783857159773;
        weights[15] = 0.0153561038234977557684980062839143812795622869188414764;
        weights[16] = 0.016239709670453695652726504931672437751910690409692368;
        weights[17] = 0.0171067971030899002623544089284553995218405919835664385;
        weights[18] = 0.0179564841487706281224428044717023363046281522619512051;
        weights[19] = 0.0187879065349046865614869661652120128281686927231492665;
        weights[20] = 0.0196002185677263307732372645893510749341431412563993441;
        weights[21] = 0.0203925939922919145794837805258651187397139183612137588;
        weights[22] = 0.0211642268327748569112801584711221517623375526987123132;
        weights[23] = 0.0219143322121786504190191224637520252669649186517217645;
        weights[24] = 0.0226421471506184331112630427298908595725394915510895414;
        weights[25] = 0.0233469313413492747126829405281667367204049962657027763;
        weights[26] = 0.0240279679037454988032412266592417206941212601662388335;
        weights[27] = 0.0246845641124609961819796162623304249762788076360921702;
        weights[28] = 0.0253160521020260973431466029770497324988902024907187205;
        weights[29] = 0.0259217895461624489184681803440827744804642525157235011;
        weights[30] = 0.0265011603111236393524875130820384843345239845075635619;
        weights[31] = 0.0270535750823961282776759150622401867666668024355766015;
        weights[32] = 0.0275784719641223939000999472603294435487663929589814256;
        weights[33] = 0.0280753170506361387532456984119366840610686524807698483;
        weights[34] = 0.0285436049695278857034903905270917363061601483868357524;
        weights[35] = 0.0289828593956883420474490617434003298374195328432432974;
        weights[36] = 0.0293926335358064921677631615445958214733182487376047133;
        weights[37] = 0.0297725105828294762661757159255180412136072379086462157;
        weights[38] = 0.0301221041399218988485309814856926870339058320994415238;
        weights[39] = 0.0304410586134932583949076494674724991122220303764814232;
        weights[40] = 0.0307290495748936699200136060827964056578357194149578342;
        weights[41] = 0.0309857840904099346310428655690205836134263205341013193;
        weights[42] = 0.0312110010192262644168406273350979510775090796493746619;
        weights[43] = 0.0314044712790465615174886120645896148027561161144939464;
        weights[44] = 0.0315659980791080529014509075416542472567102347175662948;
        weights[45] = 0.0316954171203492516090740793477558669653287803575023577;
        weights[46] = 0.0317925967625286301983178383855117427695927832843815114;
        weights[47] = 0.0318574381581240107130991888420487106427746154671923388;
        weights[48] = 0.0318898753528764672779450105542778179266508911879112149;
        weights[49] = 0.0318898753528764672779450105542778179266508911879112149;
        weights[50] = 0.0318574381581240107130991888420487106427746154671923388;
        weights[51] = 0.0317925967625286301983178383855117427695927832843815114;
        weights[52] = 0.0316954171203492516090740793477558669653287803575023577;
        weights[53] = 0.0315659980791080529014509075416542472567102347175662948;
        weights[54] = 0.0314044712790465615174886120645896148027561161144939464;
        weights[55] = 0.0312110010192262644168406273350979510775090796493746619;
        weights[56] = 0.0309857840904099346310428655690205836134263205341013193;
        weights[57] = 0.0307290495748936699200136060827964056578357194149578342;
        weights[58] = 0.0304410586134932583949076494674724991122220303764814232;
        weights[59] = 0.0301221041399218988485309814856926870339058320994415238;
        weights[60] = 0.0297725105828294762661757159255180412136072379086462157;
        weights[61] = 0.0293926335358064921677631615445958214733182487376047133;
        weights[62] = 0.0289828593956883420474490617434003298374195328432432974;
        weights[63] = 0.0285436049695278857034903905270917363061601483868357524;
        weights[64] = 0.0280753170506361387532456984119366840610686524807698483;
        weights[65] = 0.0275784719641223939000999472603294435487663929589814256;
        weights[66] = 0.0270535750823961282776759150622401867666668024355766015;
        weights[67] = 0.0265011603111236393524875130820384843345239845075635619;
        weights[68] = 0.0259217895461624489184681803440827744804642525157235011;
        weights[69] = 0.0253160521020260973431466029770497324988902024907187205;
        weights[70] = 0.0246845641124609961819796162623304249762788076360921702;
        weights[71] = 0.0240279679037454988032412266592417206941212601662388335;
        weights[72] = 0.0233469313413492747126829405281667367204049962657027763;
        weights[73] = 0.0226421471506184331112630427298908595725394915510895414;
        weights[74] = 0.0219143322121786504190191224637520252669649186517217645;
        weights[75] = 0.0211642268327748569112801584711221517623375526987123132;
        weights[76] = 0.0203925939922919145794837805258651187397139183612137588;
        weights[77] = 0.0196002185677263307732372645893510749341431412563993441;
        weights[78] = 0.0187879065349046865614869661652120128281686927231492665;
        weights[79] = 0.0179564841487706281224428044717023363046281522619512051;
        weights[80] = 0.0171067971030899002623544089284553995218405919835664385;
        weights[81] = 0.016239709670453695652726504931672437751910690409692368;
        weights[82] = 0.0153561038234977557684980062839143812795622869188414764;
        weights[83] = 0.0144568783383044019775689108017987574569742783857159773;
        weights[84] = 0.0135429478810294651436476062409750333189575737141294463;
        weights[85] = 0.0126152420789219528577814324588362573358398405403538904;
        weights[86] = 0.0116747045771381242874287672806583956745173455381915229;
        weights[87] = 0.0107222920832243171202440477009196327435549038757565031;
        weights[88] = 0.0097589734021740968353478749292888170820862440651088737;
        weights[89] = 0.00878572846739226320269938871004306412487794931814659483;
        weights[90] = 0.00780354737910075489097998010383950616743912582382996564;
        weights[91] = 0.00681342947916521599877209570929536815846397676814820051;
        weights[92] = 0.00581638254643963911276316673944398970454508763774376218;
        weights[93] = 0.0048134223985867709184778146773680437849528281067933371;
        weights[94] = 0.00380557408535235956551511904981042603803666944760404742;
        weights[95] = 0.00279388113572213087062971717882947178044724939260580443;
        weights[96] = 0.00177947704101452874169543580849208305416400789392746247;
        weights[97] = 0.000764766982274313458039246045523111842930560138505291125;
        return;
    case 99:
        points[0] = -0.999707943952169355863583849420399106219497796196195092;
        points[1] = -0.998461493835841338972881273993047268071486676751321263;
        points[2] = -0.99622033867308860856289526193808469555479369796200775;
        points[3] = -0.992986214133112277329634210291697600516940560890751009;
        points[4] = -0.9887622829898736125103418548230837465510432462685431;
        points[5] = -0.983552741156280012965562202054412888361747518637213762;
        points[6] = -0.977362776750705944569794030883332371671824085265659599;
        points[7] = -0.970198558074290215480729887888217158406637000406220133;
        points[8] = -0.962067225640901942739071328599599567589050217162806878;
        points[9] = -0.952976884453373502575668035663991678911402837764670234;
        points[10] = -0.942936595688479410294659489983257232003552769929096784;
        points[11] = -0.931956367561496964361650357642342244637391980766094829;
        points[12] = -0.920047145300500218715130281872226283218857286340834954;
        points[13] = -0.907220800210573568237880375241235038926135069188526745;
        points[14] = -0.893490117826414215002244712777587066998978968816141234;
        points[15] = -0.878868785159513850270077233162361495720201646291544979;
        points[16] = -0.863371377049917044434898377959772190352037292175010497;
        points[17] = -0.847013341634774147299139968967872769507184649471258048;
        points[18] = -0.829810984947430565029049617166623999066170141397391118;
        points[19] = -0.811781454661989134683012382925258011186816357706723087;
        points[20] = -0.792942722999308893908499502774478180347238862711166664;
        points[21] = -0.773313568811336145198437387411997220553149365638203549;
        points[22] = -0.752913558861538118254508147385464836868966655213613972;
        points[23] = -0.7317630283200435221808184283124956246960925964711194;
        points[24] = -0.709883060492896858206503244397636115695132662017840826;
        points[25] = -0.687295465805609097500626207482371068447138253842955482;
        points[26] = -0.664022760061938457558342323004931551478397297736481697;
        points[27] = -0.640088141999562525102820426428547086936956996284006212;
        points[28] = -0.615515470165007177050707181742611456386991744144826562;
        points[29] = -0.590329239130878564216650012806939192151699867489534773;
        points[30] = -0.564554555079101550743094404497593632495357079989551306;
        points[31] = -0.538217110774501032544868975915610039896142675515477536;
        points[32] = -0.511343159953671014219136815756192061412825948952089746;
        points[33] = -0.483959491154659700177256719778156215257373911345148249;
        points[34] = -0.456093401013556637292960551355338878066836940862635494;
        points[35] = -0.427772667054599621755167603235507671138203653446836884;
        points[36] = -0.399025520000924152379317790613792417815933258751466799;
        points[37] = -0.369880615633556193728666925661311377818614759535032491;
        points[38] = -0.340367006226699443041390989923755884474369412519026735;
        points[39] = -0.310514111587790736323991216381810971063371272899878543;
        points[40] = -0.280351689731191267177664844289316089375719455497295842;
        points[41] = -0.249909807214746539358834394695103537631701144644707153;
        points[42] = -0.219218809168784070389443830105524692323526477835731338;
        points[43] = -0.188309289047424476421634946930761628006208196602328643;
        points[44] = -0.157212058132358394383799434404284325839669994608899868;
        points[45] = -0.125958114819488461718240752955369452793175718037845584;
        points[46] = -0.0945786137190520318764385504821390925594316236512925076;
        points[47] = -0.0631048346000262402065079283750402047079982712873570575;
        points[48] = -0.0315681512097722652034581264672610219776578295680179303;
        points[49] = 0;
        points[50] = 0.0315681512097722652034581264672610219776578295680179303;
        points[51] = 0.0631048346000262402065079283750402047079982712873570575;
        points[52] = 0.0945786137190520318764385504821390925594316236512925076;
        points[53] = 0.125958114819488461718240752955369452793175718037845584;
        points[54] = 0.157212058132358394383799434404284325839669994608899868;
        points[55] = 0.188309289047424476421634946930761628006208196602328643;
        points[56] = 0.219218809168784070389443830105524692323526477835731338;
        points[57] = 0.249909807214746539358834394695103537631701144644707153;
        points[58] = 0.280351689731191267177664844289316089375719455497295842;
        points[59] = 0.310514111587790736323991216381810971063371272899878543;
        points[60] = 0.340367006226699443041390989923755884474369412519026735;
        points[61] = 0.369880615633556193728666925661311377818614759535032491;
        points[62] = 0.399025520000924152379317790613792417815933258751466799;
        points[63] = 0.427772667054599621755167603235507671138203653446836884;
        points[64] = 0.456093401013556637292960551355338878066836940862635494;
        points[65] = 0.483959491154659700177256719778156215257373911345148249;
        points[66] = 0.511343159953671014219136815756192061412825948952089746;
        points[67] = 0.538217110774501032544868975915610039896142675515477536;
        points[68] = 0.564554555079101550743094404497593632495357079989551306;
        points[69] = 0.590329239130878564216650012806939192151699867489534773;
        points[70] = 0.615515470165007177050707181742611456386991744144826562;
        points[71] = 0.640088141999562525102820426428547086936956996284006212;
        points[72] = 0.664022760061938457558342323004931551478397297736481697;
        points[73] = 0.687295465805609097500626207482371068447138253842955482;
        points[74] = 0.709883060492896858206503244397636115695132662017840826;
        points[75] = 0.7317630283200435221808184283124956246960925964711194;
        points[76] = 0.752913558861538118254508147385464836868966655213613972;
        points[77] = 0.773313568811336145198437387411997220553149365638203549;
        points[78] = 0.792942722999308893908499502774478180347238862711166664;
        points[79] = 0.811781454661989134683012382925258011186816357706723087;
        points[80] = 0.829810984947430565029049617166623999066170141397391118;
        points[81] = 0.847013341634774147299139968967872769507184649471258048;
        points[82] = 0.863371377049917044434898377959772190352037292175010497;
        points[83] = 0.878868785159513850270077233162361495720201646291544979;
        points[84] = 0.893490117826414215002244712777587066998978968816141234;
        points[85] = 0.907220800210573568237880375241235038926135069188526745;
        points[86] = 0.920047145300500218715130281872226283218857286340834954;
        points[87] = 0.931956367561496964361650357642342244637391980766094829;
        points[88] = 0.942936595688479410294659489983257232003552769929096784;
        points[89] = 0.952976884453373502575668035663991678911402837764670234;
        points[90] = 0.962067225640901942739071328599599567589050217162806878;
        points[91] = 0.970198558074290215480729887888217158406637000406220133;
        points[92] = 0.977362776750705944569794030883332371671824085265659599;
        points[93] = 0.983552741156280012965562202054412888361747518637213762;
        points[94] = 0.9887622829898736125103418548230837465510432462685431;
        points[95] = 0.992986214133112277329634210291697600516940560890751009;
        points[96] = 0.99622033867308860856289526193808469555479369796200775;
        points[97] = 0.998461493835841338972881273993047268071486676751321263;
        points[98] = 0.999707943952169355863583849420399106219497796196195092;
        weights[0] = 0.000749473646737405363375249945977729983177987495063871063;
        weights[1] = 0.00174390695821924493863662319990976912877349523140884423;
        weights[2] = 0.00273807587362687809132467628146107326355941978342209682;
        weights[3] = 0.00372964348724303474919882421521076299607004880398885934;
        weights[4] = 0.00471751903752083007968745536441738634932153114833891801;
        weights[5] = 0.00570069977339592687515239347814999432777600477865079225;
        weights[6] = 0.00667820086057509816518406288930005236950286284523642805;
        weights[7] = 0.00764904627933525793539046729075476061105438645603279415;
        weights[8] = 0.00861226761547888899173284404688800756994939800607704796;
        weights[9] = 0.00956690441132613635689886634158596646736542500696059615;
        weights[10] = 0.0105120049155247454057489841868629750981768348709067883;
        weights[11] = 0.0114466269514982537611325466627994587268300814964784611;
        weights[12] = 0.0123698388221751621034334158893849341521079124405456856;
        weights[13] = 0.013280720222657283479953915067273578352499317318411435;
        weights[14] = 0.014178363149579446066142955159092753107410393542685506;
        weights[15] = 0.0150618728019902333129529739651460149287012206466083391;
        weights[16] = 0.0159303684709608497110377844132446576003497222207970259;
        weights[17] = 0.0167829844161387070895026810247372592811897154155225678;
        weights[18] = 0.0176188707279243805067572544207632340926791065374257728;
        weights[19] = 0.0184371941741784992709854519039826811926374887907387902;
        weights[20] = 0.0192371390304871847986738231110730474895577210793922451;
        weights[21] = 0.0200179078930865662079476792930684980449610594961166605;
        weights[22] = 0.0207787224735942112074252299070887453719103595748744308;
        weights[23] = 0.0215188243747302238182466600984630077527937648955892608;
        weights[24] = 0.0222374758462393715843557740800879863995730886505282378;
        weights[25] = 0.0229339605202510552840832469028682854373775071475831518;
        weights[26] = 0.0236075841253378940466179128892762441052016627713061555;
        weights[27] = 0.0242576751785570782316404026990736752264823568976952721;
        weights[28] = 0.0248835856547819464459872830315098085635120925786763268;
        weights[29] = 0.0254846916326547546505823492427660345455073534135598169;
        weights[30] = 0.0260603939165154825409286756915010989872879073225607853;
        weights[31] = 0.0266101186336858513017921736445690255462232705772068784;
        weights[32] = 0.0271333178065125509263932658767166045754548979749342761;
        weights[33] = 0.0276294698985990123220761081411213270919480635898055968;
        weights[34] = 0.0280980803346809112659342505294548853298339858085634346;
        weights[35] = 0.0285386819936269497266369321043978658578239870154417249;
        weights[36] = 0.0289508356740733104037385645763869954942826540394712802;
        weights[37] = 0.0293341305322275034764333089971823190469311853677240632;
        weights[38] = 0.0296881844914050984480176356068396956601636865666506017;
        weights[39] = 0.0300126446228910344719028256941974465678279970487736421;
        weights[40] = 0.0303071874977458039796127056384741237937017018933031759;
        weights[41] = 0.0305715195092057799921820994191640449014488310514566502;
        weights[42] = 0.0308053771653562794991792442702943185882459313236988371;
        weights[43] = 0.0310085273517855953583349186590341264219731071003717352;
        weights[44] = 0.0311807675639581583703344141315390874417730074824891073;
        weights[45] = 0.0313219261090751801281746928009648269888281028411811855;
        weights[46] = 0.03143186227722154616152127518684064449961555559252695;
        weights[47] = 0.0315104664816283477132379491399539982333342233467873548;
        weights[48] = 0.0315576603679112288580920882306150621511205591959303628;
        weights[49] = 0.0315733968921756530513741693170682405723440510410003599;
        weights[50] = 0.0315576603679112288580920882306150621511205591959303628;
        weights[51] = 0.0315104664816283477132379491399539982333342233467873548;
        weights[52] = 0.03143186227722154616152127518684064449961555559252695;
        weights[53] = 0.0313219261090751801281746928009648269888281028411811855;
        weights[54] = 0.0311807675639581583703344141315390874417730074824891073;
        weights[55] = 0.0310085273517855953583349186590341264219731071003717352;
        weights[56] = 0.0308053771653562794991792442702943185882459313236988371;
        weights[57] = 0.0305715195092057799921820994191640449014488310514566502;
        weights[58] = 0.0303071874977458039796127056384741237937017018933031759;
        weights[59] = 0.0300126446228910344719028256941974465678279970487736421;
        weights[60] = 0.0296881844914050984480176356068396956601636865666506017;
        weights[61] = 0.0293341305322275034764333089971823190469311853677240632;
        weights[62] = 0.0289508356740733104037385645763869954942826540394712802;
        weights[63] = 0.0285386819936269497266369321043978658578239870154417249;
        weights[64] = 0.0280980803346809112659342505294548853298339858085634346;
        weights[65] = 0.0276294698985990123220761081411213270919480635898055968;
        weights[66] = 0.0271333178065125509263932658767166045754548979749342761;
        weights[67] = 0.0266101186336858513017921736445690255462232705772068784;
        weights[68] = 0.0260603939165154825409286756915010989872879073225607853;
        weights[69] = 0.0254846916326547546505823492427660345455073534135598169;
        weights[70] = 0.0248835856547819464459872830315098085635120925786763268;
        weights[71] = 0.0242576751785570782316404026990736752264823568976952721;
        weights[72] = 0.0236075841253378940466179128892762441052016627713061555;
        weights[73] = 0.0229339605202510552840832469028682854373775071475831518;
        weights[74] = 0.0222374758462393715843557740800879863995730886505282378;
        weights[75] = 0.0215188243747302238182466600984630077527937648955892608;
        weights[76] = 0.0207787224735942112074252299070887453719103595748744308;
        weights[77] = 0.0200179078930865662079476792930684980449610594961166605;
        weights[78] = 0.0192371390304871847986738231110730474895577210793922451;
        weights[79] = 0.0184371941741784992709854519039826811926374887907387902;
        weights[80] = 0.0176188707279243805067572544207632340926791065374257728;
        weights[81] = 0.0167829844161387070895026810247372592811897154155225678;
        weights[82] = 0.0159303684709608497110377844132446576003497222207970259;
        weights[83] = 0.0150618728019902333129529739651460149287012206466083391;
        weights[84] = 0.014178363149579446066142955159092753107410393542685506;
        weights[85] = 0.013280720222657283479953915067273578352499317318411435;
        weights[86] = 0.0123698388221751621034334158893849341521079124405456856;
        weights[87] = 0.0114466269514982537611325466627994587268300814964784611;
        weights[88] = 0.0105120049155247454057489841868629750981768348709067883;
        weights[89] = 0.00956690441132613635689886634158596646736542500696059615;
        weights[90] = 0.00861226761547888899173284404688800756994939800607704796;
        weights[91] = 0.00764904627933525793539046729075476061105438645603279415;
        weights[92] = 0.00667820086057509816518406288930005236950286284523642805;
        weights[93] = 0.00570069977339592687515239347814999432777600477865079225;
        weights[94] = 0.00471751903752083007968745536441738634932153114833891801;
        weights[95] = 0.00372964348724303474919882421521076299607004880398885934;
        weights[96] = 0.00273807587362687809132467628146107326355941978342209682;
        weights[97] = 0.00174390695821924493863662319990976912877349523140884423;
        weights[98] = 0.000749473646737405363375249945977729983177987495063871063;
        return;
    case 100:
        points[0] = -0.999713726773441233678228469342300676718349527308403227;
        points[1] = -0.998491950639595818400163359186349162304854850420569702;
        points[2] = -0.996295134733125149186131732241131035436431288140430379;
        points[3] = -0.993124937037443459652009892848783470731771458866520379;
        points[4] = -0.988984395242991748004418745807736631839333637106947528;
        points[5] = -0.98387754070605701549610015551100816734436701685080221;
        points[6] = -0.977809358486918288553781088429201928635234494266253978;
        points[7] = -0.970785775763706331930897857897505388550557199478207136;
        points[8] = -0.962813654255815527293659326030166386437331506730414141;
        points[9] = -0.953900782925491742849336930894357644645221451014667748;
        points[10] = -0.944055870136255977962774706415218746739720373382096872;
        points[11] = -0.933288535043079545924333668130862504083546074297019296;
        points[12] = -0.921609298145333952666951328481987459124582797732196147;
        points[13] = -0.909029570982529690467126337789146064443277289584588938;
        points[14] = -0.89556164497072698669852102243022776984818176899771983;
        points[15] = -0.881218679385018415573316825427805582445494411021257803;
        points[16] = -0.866014688497164623410739969676242966380314839305593072;
        points[17] = -0.849964527879591284293362591420104654073790779500672354;
        points[18] = -0.833083879888400823542915833844755679907494830309962259;
        points[19] = -0.815389238339176254393988758649258005382550376513702723;
        points[20] = -0.796897892390314476389572882183245982889526855964290502;
        points[21] = -0.777627909649495475627551386834490106538539799936078875;
        points[22] = -0.757598118519707176035667964438400772313108971900041713;
        points[23] = -0.736828089802020705512427714820101002843278446247123442;
        points[24] = -0.715338117573056446459967122704365964084397838595629635;
        points[25] = -0.693149199355801965948647941675437265587000017930728454;
        points[26] = -0.670283015603141015802587014323226613669805684028823954;
        points[27] = -0.646761908514129279832630304458630435019733784248528001;
        points[28] = -0.622608860203707771604190845172312244653817732289816002;
        points[29] = -0.597847470247178721264806545149340636394899192320485336;
        points[30] = -0.572501932621381191316870443525725448960033949675560278;
        points[31] = -0.546597012065094167467994257181749903956241775937527812;
        points[32] = -0.520158019881763056646815749455208530768937690420093853;
        points[33] = -0.493210789208190933569308793449333990990723325358556127;
        points[34] = -0.465781649773358042249216623395754581611651110212210966;
        points[35] = -0.437897402172031513108978043622195962125701763484104595;
        points[36] = -0.409585291678301542528868400057157701495364389164754559;
        points[37] = -0.380872981624629956763362548869587403749707265123710924;
        points[38] = -0.351788526372421720972343829548970565249318096389071201;
        points[39] = -0.322360343900529151722476582398325427402191623023085707;
        points[40] = -0.292617188038471964737555888235494384561538989172580972;
        points[41] = -0.262588120371503479168929336254982141132022694535522136;
        points[42] = -0.232302481844973969649509963207964110697509771507136914;
        points[43] = -0.201789864095735997236048859530396462943692003559048911;
        points[44] = -0.171080080538603274887532374707089807465859725118066775;
        points[45] = -0.140203137236113973207514604682405516616873006263359772;
        points[46] = -0.109189203580061115003426006579384886884899629969163393;
        points[47] = -0.0780685828134366366948173712015525739763500274485301161;
        points[48] = -0.0468716824215916316149239129338483095370653990860240796;
        points[49] = -0.0156289844215430828722166999974293401477561828555614727;
        points[50] = 0.0156289844215430828722166999974293401477561828555614727;
        points[51] = 0.0468716824215916316149239129338483095370653990860240796;
        points[52] = 0.0780685828134366366948173712015525739763500274485301161;
        points[53] = 0.109189203580061115003426006579384886884899629969163393;
        points[54] = 0.140203137236113973207514604682405516616873006263359772;
        points[55] = 0.171080080538603274887532374707089807465859725118066775;
        points[56] = 0.201789864095735997236048859530396462943692003559048911;
        points[57] = 0.232302481844973969649509963207964110697509771507136914;
        points[58] = 0.262588120371503479168929336254982141132022694535522136;
        points[59] = 0.292617188038471964737555888235494384561538989172580972;
        points[60] = 0.322360343900529151722476582398325427402191623023085707;
        points[61] = 0.351788526372421720972343829548970565249318096389071201;
        points[62] = 0.380872981624629956763362548869587403749707265123710924;
        points[63] = 0.409585291678301542528868400057157701495364389164754559;
        points[64] = 0.437897402172031513108978043622195962125701763484104595;
        points[65] = 0.465781649773358042249216623395754581611651110212210966;
        points[66] = 0.493210789208190933569308793449333990990723325358556127;
        points[67] = 0.520158019881763056646815749455208530768937690420093853;
        points[68] = 0.546597012065094167467994257181749903956241775937527812;
        points[69] = 0.572501932621381191316870443525725448960033949675560278;
        points[70] = 0.597847470247178721264806545149340636394899192320485336;
        points[71] = 0.622608860203707771604190845172312244653817732289816002;
        points[72] = 0.646761908514129279832630304458630435019733784248528001;
        points[73] = 0.670283015603141015802587014323226613669805684028823954;
        points[74] = 0.693149199355801965948647941675437265587000017930728454;
        points[75] = 0.715338117573056446459967122704365964084397838595629635;
        points[76] = 0.736828089802020705512427714820101002843278446247123442;
        points[77] = 0.757598118519707176035667964438400772313108971900041713;
        points[78] = 0.777627909649495475627551386834490106538539799936078875;
        points[79] = 0.796897892390314476389572882183245982889526855964290502;
        points[80] = 0.815389238339176254393988758649258005382550376513702723;
        points[81] = 0.833083879888400823542915833844755679907494830309962259;
        points[82] = 0.849964527879591284293362591420104654073790779500672354;
        points[83] = 0.866014688497164623410739969676242966380314839305593072;
        points[84] = 0.881218679385018415573316825427805582445494411021257803;
        points[85] = 0.89556164497072698669852102243022776984818176899771983;
        points[86] = 0.909029570982529690467126337789146064443277289584588938;
        points[87] = 0.921609298145333952666951328481987459124582797732196147;
        points[88] = 0.933288535043079545924333668130862504083546074297019296;
        points[89] = 0.944055870136255977962774706415218746739720373382096872;
        points[90] = 0.953900782925491742849336930894357644645221451014667748;
        points[91] = 0.962813654255815527293659326030166386437331506730414141;
        points[92] = 0.970785775763706331930897857897505388550557199478207136;
        points[93] = 0.977809358486918288553781088429201928635234494266253978;
        points[94] = 0.98387754070605701549610015551100816734436701685080221;
        points[95] = 0.988984395242991748004418745807736631839333637106947528;
        points[96] = 0.993124937037443459652009892848783470731771458866520379;
        points[97] = 0.996295134733125149186131732241131035436431288140430379;
        points[98] = 0.998491950639595818400163359186349162304854850420569702;
        points[99] = 0.999713726773441233678228469342300676718349527308403227;
        weights[0] = 0.000734634490505671730406320658330336390670473562482907839;
        weights[1] = 0.0017093926535181052395293583714911952437313854914625798;
        weights[2] = 0.00268392537155348241943959042900112008193111495099827627;
        weights[3] = 0.00365596120132637518234245872752519569920656740515220382;
        weights[4] = 0.00462445006342211935109578908297847665035249529489452936;
        weights[5] = 0.00558842800386551515721194634843921073131869400807715264;
        weights[6] = 0.006546948450845322764152103331495263699938363366476002;
        weights[7] = 0.00749907325546471157882874401639778316358347894814509342;
        weights[8] = 0.00844387146966897140262083490230100193464445988410141344;
        weights[9] = 0.00938041965369445795141823766081211873078704323867416532;
        weights[10] = 0.0103078025748689695857821017278353779760583438414260083;
        weights[11] = 0.0112251140231859771172215733663335847772264195643824067;
        weights[12] = 0.0121314576629794974077447924487481707369631233112609139;
        weights[13] = 0.0130259478929715422855585837589017901349647358417496076;
        weights[14] = 0.0139077107037187726879541491080046377951808121431190723;
        weights[15] = 0.0147758845274413017688799875203542571693887431146036254;
        weights[16] = 0.0156296210775460027239368659537919255524699798099369497;
        weights[17] = 0.01646808617614521264310498008821078082116766160379837;
        weights[18] = 0.017290460568323582439344198366741674811623508565167627;
        weights[19] = 0.018095940722128116664390751420493031347578744958389888;
        weights[20] = 0.01888373961337490455294116588154323429711127634742448;
        weights[21] = 0.0196530874944353058653814702454440655552695994912506944;
        weights[22] = 0.020403232646209432766838851657583770605709699302619548;
        weights[23] = 0.0211334421125276415426723004409696816353297288745146919;
        weights[24] = 0.0218430024162473863139537413043980247653489998232464788;
        weights[25] = 0.0225312202563362727017969709316739623401589353487094168;
        weights[26] = 0.02319742318525412162248885418272728845115448573608693;
        weights[27] = 0.0238409602659682059625604119022834321447074490926169874;
        weights[28] = 0.0244612027079570527199750233497728906462957323978044633;
        weights[29] = 0.0250575444815795897037642256209232642238385585279288442;
        weights[30] = 0.025629402910208116075642009862150870926977670020267908;
        weights[31] = 0.026176219239545676342308741757301885011275131190694938;
        weights[32] = 0.0266974591835709626603846641863363506346557503900118191;
        weights[33] = 0.0271926134465768801364915678021706922669878960120012612;
        weights[34] = 0.0276611982207923882942041558704264552924003586642202001;
        weights[35] = 0.028102755659101173317648330186994550451418099400205024;
        weights[36] = 0.0285168543223950979909367628644578732598427254839685792;
        weights[37] = 0.0289030896011252031348762281345152653156078680552609867;
        weights[38] = 0.0292610841106382766201190234956409544430841950453482862;
        weights[39] = 0.0295904880599126425117545106788365851728062850713677427;
        weights[40] = 0.0298909795933328309168368066685958276580914142607989685;
        weights[41] = 0.030162265105169144919068681610479232657102325782705607;
        weights[42] = 0.0304040795264548200165078598188251766056072483101173462;
        weights[43] = 0.0306161865839804484964594432620531928530860237890577847;
        weights[44] = 0.0307983790311525904277139030305597600949708344703709681;
        weights[45] = 0.0309504788504909882340634634707479273829871777669407437;
        weights[46] = 0.0310723374275665165878101702429180348459154363479573876;
        weights[47] = 0.0311638356962099067838183212171866533438363686839280712;
        weights[48] = 0.0312248842548493577323764986480981348818027406821841401;
        weights[49] = 0.0312554234538633569476424743861980287878338367260909099;
        weights[50] = 0.0312554234538633569476424743861980287878338367260909099;
        weights[51] = 0.0312248842548493577323764986480981348818027406821841401;
        weights[52] = 0.0311638356962099067838183212171866533438363686839280712;
        weights[53] = 0.0310723374275665165878101702429180348459154363479573876;
        weights[54] = 0.0309504788504909882340634634707479273829871777669407437;
        weights[55] = 0.0307983790311525904277139030305597600949708344703709681;
        weights[56] = 0.0306161865839804484964594432620531928530860237890577847;
        weights[57] = 0.0304040795264548200165078598188251766056072483101173462;
        weights[58] = 0.030162265105169144919068681610479232657102325782705607;
        weights[59] = 0.0298909795933328309168368066685958276580914142607989685;
        weights[60] = 0.0295904880599126425117545106788365851728062850713677427;
        weights[61] = 0.0292610841106382766201190234956409544430841950453482862;
        weights[62] = 0.0289030896011252031348762281345152653156078680552609867;
        weights[63] = 0.0285168543223950979909367628644578732598427254839685792;
        weights[64] = 0.028102755659101173317648330186994550451418099400205024;
        weights[65] = 0.0276611982207923882942041558704264552924003586642202001;
        weights[66] = 0.0271926134465768801364915678021706922669878960120012612;
        weights[67] = 0.0266974591835709626603846641863363506346557503900118191;
        weights[68] = 0.026176219239545676342308741757301885011275131190694938;
        weights[69] = 0.025629402910208116075642009862150870926977670020267908;
        weights[70] = 0.0250575444815795897037642256209232642238385585279288442;
        weights[71] = 0.0244612027079570527199750233497728906462957323978044633;
        weights[72] = 0.0238409602659682059625604119022834321447074490926169874;
        weights[73] = 0.02319742318525412162248885418272728845115448573608693;
        weights[74] = 0.0225312202563362727017969709316739623401589353487094168;
        weights[75] = 0.0218430024162473863139537413043980247653489998232464788;
        weights[76] = 0.0211334421125276415426723004409696816353297288745146919;
        weights[77] = 0.020403232646209432766838851657583770605709699302619548;
        weights[78] = 0.0196530874944353058653814702454440655552695994912506944;
        weights[79] = 0.01888373961337490455294116588154323429711127634742448;
        weights[80] = 0.018095940722128116664390751420493031347578744958389888;
        weights[81] = 0.017290460568323582439344198366741674811623508565167627;
        weights[82] = 0.01646808617614521264310498008821078082116766160379837;
        weights[83] = 0.0156296210775460027239368659537919255524699798099369497;
        weights[84] = 0.0147758845274413017688799875203542571693887431146036254;
        weights[85] = 0.0139077107037187726879541491080046377951808121431190723;
        weights[86] = 0.0130259478929715422855585837589017901349647358417496076;
        weights[87] = 0.0121314576629794974077447924487481707369631233112609139;
        weights[88] = 0.0112251140231859771172215733663335847772264195643824067;
        weights[89] = 0.0103078025748689695857821017278353779760583438414260083;
        weights[90] = 0.00938041965369445795141823766081211873078704323867416532;
        weights[91] = 0.00844387146966897140262083490230100193464445988410141344;
        weights[92] = 0.00749907325546471157882874401639778316358347894814509342;
        weights[93] = 0.006546948450845322764152103331495263699938363366476002;
        weights[94] = 0.00558842800386551515721194634843921073131869400807715264;
        weights[95] = 0.00462445006342211935109578908297847665035249529489452936;
        weights[96] = 0.00365596120132637518234245872752519569920656740515220382;
        weights[97] = 0.00268392537155348241943959042900112008193111495099827627;
        weights[98] = 0.0017093926535181052395293583714911952437313854914625798;
        weights[99] = 0.000734634490505671730406320658330336390670473562482907839;
        return;
    case 101:
        points[0] = -0.999719339529770275768398605056361111120391898353362471;
        points[1] = -0.998521511989757508253895241260837200011108993367802158;
        points[2] = -0.996367732790944138905167301837743391424626741587127184;
        points[3] = -0.993259586187867438580741844242591650919168535658869689;
        points[4] = -0.989199990875033603767660922963491139475925732493585843;
        points[5] = -0.98419282163022063506446539882923787091558671032620961;
        points[6] = -0.97824287028644346533612532111505277572422353272612164;
        points[7] = -0.971355834558171220182708415620798622659289560982974757;
        points[8] = -0.963538310833134435589923319956369444222185914342626112;
        points[9] = -0.95479778727119134407371609297406081558010798447435167;
        points[10] = -0.94514263640464845388006471593317516729423992252214875;
        points[11] = -0.934582107018945690466337060756935901333747173457545425;
        points[12] = -0.923126315245613799010999469552011173721304532584587873;
        points[13] = -0.910786234847393747181099690244113103371602026617589812;
        points[14] = -0.897573686692878581314716711071599838917983042488431026;
        points[15] = -0.883501327425360660775526250924405470653596689211643951;
        points[16] = -0.868582637334130138884569486580425649082895766220990257;
        points[17] = -0.852831907438510356568202546905242291643468642555951507;
        points[18] = -0.836264225796288437769520268139724032261275674440051318;
        points[19] = -0.818895463049257659150623728337223276640837075164816372;
        points[20] = -0.800742257219486880919327978553588107695315832467512986;
        points[21] = -0.781821997770742990210275980522509292827878114586185417;
        points[22] = -0.762152808950249417701517395784067529351599574853990486;
        points[23] = -0.741753532426684540130867437397466809542367148833862476;
        points[24] = -0.720643709241016938662759594081190585752009218171846805;
        points[25] = -0.698843561087444535715260466554411079160275059221098919;
        points[26] = -0.676373970942353834409166357901023479788884452718683834;
        points[27] = -0.653256463059844884440857961078637118040611447014385932;
        points[28] = -0.629513182352977581445605726737575693803281831991894927;
        points[29] = -0.605166873180485487431577348228605212581338988670011945;
        points[30] = -0.580240857559274341122044419979888288619608862682889494;
        points[31] = -0.554759012823573494441128574777659945807956656225004694;
        points[32] = -0.528745748752139285835033717767416723444180263834564864;
        points[33] = -0.502225984185419431041204631995422606148618180159468443;
        points[34] = -0.475225123155076452683148592837094962595163423154821943;
        points[35] = -0.447769030548735556186779291563596250513365796088428245;
        points[36] = -0.419884007333267772372414684965323632720817969422412368;
        points[37] = -0.391596765360342220007283190958060353100494343646222161;
        points[38] = -0.362934401778381603279213592238702374060963488090846858;
        points[39] = -0.333924373075432175924291188129665175067184595694803676;
        points[40] = -0.304594468777813021296153415429142007103936366119378686;
        points[41] = -0.274972784829739282233078734125518376337933521146693851;
        points[42] = -0.245087696679419613844730430582979833055001441191789998;
        points[43] = -0.214967832097409336141902953940576302772558731497783858;
        points[44] = -0.184642043753257264319747071638937089716677433442586976;
        points[45] = -0.154139381576715748189308744024722446449791318256142028;
        points[46] = -0.123489064929989837977726765603174485455426975884091796;
        points[47] = -0.09272045461768251456861542638934617607662973139866785;
        points[48] = -0.0618630247612484054137640515069193268753639378432195955;
        points[49] = -0.0309463345648982043112390737786277901755600192576462155;
        points[50] = 0;
        points[51] = 0.0309463345648982043112390737786277901755600192576462155;
        points[52] = 0.0618630247612484054137640515069193268753639378432195955;
        points[53] = 0.09272045461768251456861542638934617607662973139866785;
        points[54] = 0.123489064929989837977726765603174485455426975884091796;
        points[55] = 0.154139381576715748189308744024722446449791318256142028;
        points[56] = 0.184642043753257264319747071638937089716677433442586976;
        points[57] = 0.214967832097409336141902953940576302772558731497783858;
        points[58] = 0.245087696679419613844730430582979833055001441191789998;
        points[59] = 0.274972784829739282233078734125518376337933521146693851;
        points[60] = 0.304594468777813021296153415429142007103936366119378686;
        points[61] = 0.333924373075432175924291188129665175067184595694803676;
        points[62] = 0.362934401778381603279213592238702374060963488090846858;
        points[63] = 0.391596765360342220007283190958060353100494343646222161;
        points[64] = 0.419884007333267772372414684965323632720817969422412368;
        points[65] = 0.447769030548735556186779291563596250513365796088428245;
        points[66] = 0.475225123155076452683148592837094962595163423154821943;
        points[67] = 0.502225984185419431041204631995422606148618180159468443;
        points[68] = 0.528745748752139285835033717767416723444180263834564864;
        points[69] = 0.554759012823573494441128574777659945807956656225004694;
        points[70] = 0.580240857559274341122044419979888288619608862682889494;
        points[71] = 0.605166873180485487431577348228605212581338988670011945;
        points[72] = 0.629513182352977581445605726737575693803281831991894927;
        points[73] = 0.653256463059844884440857961078637118040611447014385932;
        points[74] = 0.676373970942353834409166357901023479788884452718683834;
        points[75] = 0.698843561087444535715260466554411079160275059221098919;
        points[76] = 0.720643709241016938662759594081190585752009218171846805;
        points[77] = 0.741753532426684540130867437397466809542367148833862476;
        points[78] = 0.762152808950249417701517395784067529351599574853990486;
        points[79] = 0.781821997770742990210275980522509292827878114586185417;
        points[80] = 0.800742257219486880919327978553588107695315832467512986;
        points[81] = 0.818895463049257659150623728337223276640837075164816372;
        points[82] = 0.836264225796288437769520268139724032261275674440051318;
        points[83] = 0.852831907438510356568202546905242291643468642555951507;
        points[84] = 0.868582637334130138884569486580425649082895766220990257;
        points[85] = 0.883501327425360660775526250924405470653596689211643951;
        points[86] = 0.897573686692878581314716711071599838917983042488431026;
        points[87] = 0.910786234847393747181099690244113103371602026617589812;
        points[88] = 0.923126315245613799010999469552011173721304532584587873;
        points[89] = 0.934582107018945690466337060756935901333747173457545425;
        points[90] = 0.94514263640464845388006471593317516729423992252214875;
        points[91] = 0.95479778727119134407371609297406081558010798447435167;
        points[92] = 0.963538310833134435589923319956369444222185914342626112;
        points[93] = 0.971355834558171220182708415620798622659289560982974757;
        points[94] = 0.97824287028644346533612532111505277572422353272612164;
        points[95] = 0.98419282163022063506446539882923787091558671032620961;
        points[96] = 0.989199990875033603767660922963491139475925732493585843;
        points[97] = 0.993259586187867438580741844242591650919168535658869689;
        points[98] = 0.996367732790944138905167301837743391424626741587127184;
        points[99] = 0.998521511989757508253895241260837200011108993367802158;
        points[100] = 0.999719339529770275768398605056361111120391898353362471;
        weights[0] = 0.000720231706401863701765546133087639624182568561269659549;
        weights[1] = 0.00167589276049902887991083167753902692853168669060375991;
        weights[2] = 0.00263136487318234322347709059110150451559195787768121217;
        weights[3] = 0.00358443939880224876088261122433560154231729003336295091;
        weights[4] = 0.00453410501009302341293473090392556395031535986502109214;
        weights[5] = 0.00547943468378208156695892012635115149311165061586844511;
        weights[6] = 0.0064195182701775452950355731934239924332777953586781351;
        weights[7] = 0.00735345367479127803686950133232972839200197109299574109;
        weights[8] = 0.00828034562572336197472674129981978258098411415809474956;
        weights[9] = 0.00919930594092143381100622702137684178144823983681001747;
        weights[10] = 0.0101094541795120865759187511605832711673337622971696691;
        weights[11] = 0.0110099184080599701173852836462987453087608367227243951;
        weights[12] = 0.011899836002711939318099734793242585658818993650707585;
        weights[13] = 0.0127783544600899533506145094724914225950049569197796854;
        weights[14] = 0.0136446322062219022582188806662637268524880143264390478;
        weights[15] = 0.0144978393986382994411102589906107613736665387129039352;
        weights[16] = 0.0153371587190456951261498213648825185077551051221844544;
        weights[17] = 0.0161617861549559384164105941930782641915607779274357188;
        weights[18] = 0.016970931769092475947367280620408344578699426584450898;
        weights[19] = 0.0177638204556118146252692025604262186227924555801444776;
        weights[20] = 0.0185396926822933590364095654939777190651176980083349862;
        weights[21] = 0.0192978052179176316959047239153194981635989201917636402;
        weights[22] = 0.0200374318440959180193069607751518857286050574705912092;
        weights[23] = 0.0207578640508453937186257559094190318427784323155967862;
        weights[24] = 0.0214584117152286455451826413724675837936601146080572533;
        weights[25] = 0.0221384037623982096540703534123633043259412260992766554;
        weights[26] = 0.0227971888084069338296509101980355925597265524068831674;
        weights[27] = 0.0234341357841644983988488869801062075786169555417141674;
        weights[28] = 0.0240486345399397947686755025308373869893497208945739557;
        weights[29] = 0.0246400964298283358395658669755125264222318704583832018;
        weights[30] = 0.0252079548756236148186046350867173626826104682308319931;
        weights[31] = 0.0257516659095514248053878766302074001008041804213697504;
        weights[32] = 0.0262707086953466467769578394776350023238247383762121619;
        weights[33] = 0.0267645860271729294701195771862772316891023138472539698;
        weights[34] = 0.0272328248059070271728889159799636282846324322215261891;
        weights[35] = 0.0276749764923313270279740353352988073817312603656551371;
        weights[36] = 0.0280906175368002763619851969674944188672550621534467371;
        weights[37] = 0.0284793497849689989245688662598753902884212541931553745;
        weights[38] = 0.0288408008591953501035075438790412303539749066610400282;
        weights[39] = 0.0291746245152499865775918963598741920624627880427738567;
        weights[40] = 0.0294805009739926954788018593292343887842179869986326501;
        weights[41] = 0.0297581372276972209195873407427408076253941394775663837;
        weights[42] = 0.0300072673207311198674654295323634106002745130610549261;
        weights[43] = 0.0302276526043217523642141024353852872625466242112754068;
        weights[44] = 0.0304190819651643400389970253347216948757857698081624093;
        weights[45] = 0.0305813720276530883951579213571288042131585638611681871;
        weights[46] = 0.0307143673295416387634480194607797337526427298735579559;
        weights[47] = 0.0308179404708645711330048554358770134028035839467553619;
        weights[48] = 0.0308919922359772950831842565587769412711278251889591314;
        weights[49] = 0.0309364516885974183365096307954456286810379920332483112;
        weights[50] = 0.0309512762397565464673798346407883938558416341937068522;
        weights[51] = 0.0309364516885974183365096307954456286810379920332483112;
        weights[52] = 0.0308919922359772950831842565587769412711278251889591314;
        weights[53] = 0.0308179404708645711330048554358770134028035839467553619;
        weights[54] = 0.0307143673295416387634480194607797337526427298735579559;
        weights[55] = 0.0305813720276530883951579213571288042131585638611681871;
        weights[56] = 0.0304190819651643400389970253347216948757857698081624093;
        weights[57] = 0.0302276526043217523642141024353852872625466242112754068;
        weights[58] = 0.0300072673207311198674654295323634106002745130610549261;
        weights[59] = 0.0297581372276972209195873407427408076253941394775663837;
        weights[60] = 0.0294805009739926954788018593292343887842179869986326501;
        weights[61] = 0.0291746245152499865775918963598741920624627880427738567;
        weights[62] = 0.0288408008591953501035075438790412303539749066610400282;
        weights[63] = 0.0284793497849689989245688662598753902884212541931553745;
        weights[64] = 0.0280906175368002763619851969674944188672550621534467371;
        weights[65] = 0.0276749764923313270279740353352988073817312603656551371;
        weights[66] = 0.0272328248059070271728889159799636282846324322215261891;
        weights[67] = 0.0267645860271729294701195771862772316891023138472539698;
        weights[68] = 0.0262707086953466467769578394776350023238247383762121619;
        weights[69] = 0.0257516659095514248053878766302074001008041804213697504;
        weights[70] = 0.0252079548756236148186046350867173626826104682308319931;
        weights[71] = 0.0246400964298283358395658669755125264222318704583832018;
        weights[72] = 0.0240486345399397947686755025308373869893497208945739557;
        weights[73] = 0.0234341357841644983988488869801062075786169555417141674;
        weights[74] = 0.0227971888084069338296509101980355925597265524068831674;
        weights[75] = 0.0221384037623982096540703534123633043259412260992766554;
        weights[76] = 0.0214584117152286455451826413724675837936601146080572533;
        weights[77] = 0.0207578640508453937186257559094190318427784323155967862;
        weights[78] = 0.0200374318440959180193069607751518857286050574705912092;
        weights[79] = 0.0192978052179176316959047239153194981635989201917636402;
        weights[80] = 0.0185396926822933590364095654939777190651176980083349862;
        weights[81] = 0.0177638204556118146252692025604262186227924555801444776;
        weights[82] = 0.016970931769092475947367280620408344578699426584450898;
        weights[83] = 0.0161617861549559384164105941930782641915607779274357188;
        weights[84] = 0.0153371587190456951261498213648825185077551051221844544;
        weights[85] = 0.0144978393986382994411102589906107613736665387129039352;
        weights[86] = 0.0136446322062219022582188806662637268524880143264390478;
        weights[87] = 0.0127783544600899533506145094724914225950049569197796854;
        weights[88] = 0.011899836002711939318099734793242585658818993650707585;
        weights[89] = 0.0110099184080599701173852836462987453087608367227243951;
        weights[90] = 0.0101094541795120865759187511605832711673337622971696691;
        weights[91] = 0.00919930594092143381100622702137684178144823983681001747;
        weights[92] = 0.00828034562572336197472674129981978258098411415809474956;
        weights[93] = 0.00735345367479127803686950133232972839200197109299574109;
        weights[94] = 0.0064195182701775452950355731934239924332777953586781351;
        weights[95] = 0.00547943468378208156695892012635115149311165061586844511;
        weights[96] = 0.00453410501009302341293473090392556395031535986502109214;
        weights[97] = 0.00358443939880224876088261122433560154231729003336295091;
        weights[98] = 0.00263136487318234322347709059110150451559195787768121217;
        weights[99] = 0.00167589276049902887991083167753902692853168669060375991;
        weights[100] = 0.000720231706401863701765546133087639624182568561269659549;
        return;
    case 102:
        points[0] = -0.999724788824757584049721307536866588051993271530371346;
        points[1] = -0.998550212645212665298458888988769685801079183954812131;
        points[2] = -0.996438218115862869659094158776484487512292819800029795;
        points[3] = -0.993390319485722202009559354804261605803548454049933816;
        points[4] = -0.989409322189570931781209884383785270168159552993400619;
        points[5] = -0.984498951945387236698119090253758796514068751783150689;
        points[6] = -0.978663816624404607978549739537497608238217891623236471;
        points[7] = -0.971909395467173489841056235026722773098239420184621509;
        points[8] = -0.964242032220576721229620521197848558475951659503574837;
        points[9] = -0.955668928608015375673766010332702288672416231395456316;
        points[10] = -0.946198137342464995670134184566784573102681660291164088;
        points[11] = -0.935838554465221983988501048496828091032839416583286072;
        points[12] = -0.924599910943141594570569087702063448387377362867589805;
        points[13] = -0.912492763504174951995861380616353012160990619149342279;
        points[14] = -0.899528484708100246304064328648785738848564783874949878;
        points[15] = -0.885719252256480435470579708856048560473556517728759134;
        points[16] = -0.871078037549331156171472366360095762067129208247009215;
        points[17] = -0.855618593497941105273679087388626996227557513826712998;
        points[18] = -0.839355441604592312920505972708601422258932153546743429;
        points[19] = -0.822303858320925519406944705169690804340063258723154865;
        points[20] = -0.804479860697538108308369923845051237802854170626284815;
        points[21] = -0.785900191338158918251648807991213482543618732861387037;
        points[22] = -0.766582302672449628702892162308796303908511635457545143;
        points[23] = -0.746544340562153202950817168430554695199639944527194364;
        points[24] = -0.725805127255954712872666085372878856028611495730158135;
        points[25] = -0.704384143709043213001564237429852638146373405255521707;
        points[26] = -0.682301511283967429293076505770145573391280731673794866;
        points[27] = -0.659577972849963951865948039346940771481318265477162005;
        points[28] = -0.636234873298504789668052986264223639303383663855646031;
        points[29] = -0.612294139493361611070756653338530550276790199818908325;
        points[30] = -0.587778259674016602774792442569437378988110118327103611;
        points[31] = -0.562710262331764357641432580170503004659059294686655573;
        points[32] = -0.537113694578345212773295290986923261202749151090102151;
        points[33] = -0.511012600027427631397853530387045544947026175298706539;
        points[34] = -0.484431496209715170371521667396345795569242434728527236;
        points[35] = -0.457395351542891911298137966951114920467132743453152009;
        points[36] = -0.429929561878038574140681950003769736487432054764095518;
        points[37] = -0.402059926644549504453563288678260582077445842954742407;
        points[38] = -0.373812624615957968783430040737357155655049053820071964;
        points[39] = -0.345214189319433362605360247167182405039674535342708392;
        points[40] = -0.316291484112048703619591951438853871457948124402579881;
        points[41] = -0.287071676947229840748047495928863918435910882379295201;
        points[42] = -0.257582214855088865199730800920261264954128944162528483;
        points[43] = -0.227850798160612993690990334647340678258270169566958644;
        points[44] = -0.197905354463926454720923518492449893557865002431926162;
        points[45] = -0.167774012407066416788907354535352289984416203365208446;
        points[46] = -0.137485075251914543690210021224322607643059947168159893;
        points[47] = -0.107066994294103158932742848760945170462378443689254867;
        points[48] = -0.076548342137869082829202888880448280751058103022549912;
        points[49] = -0.0459577858569588276347763608985710608269607153726867303;
        points[50] = -0.0153240600667958758470582943356736945047311265657981128;
        points[51] = 0.0153240600667958758470582943356736945047311265657981128;
        points[52] = 0.0459577858569588276347763608985710608269607153726867303;
        points[53] = 0.076548342137869082829202888880448280751058103022549912;
        points[54] = 0.107066994294103158932742848760945170462378443689254867;
        points[55] = 0.137485075251914543690210021224322607643059947168159893;
        points[56] = 0.167774012407066416788907354535352289984416203365208446;
        points[57] = 0.197905354463926454720923518492449893557865002431926162;
        points[58] = 0.227850798160612993690990334647340678258270169566958644;
        points[59] = 0.257582214855088865199730800920261264954128944162528483;
        points[60] = 0.287071676947229840748047495928863918435910882379295201;
        points[61] = 0.316291484112048703619591951438853871457948124402579881;
        points[62] = 0.345214189319433362605360247167182405039674535342708392;
        points[63] = 0.373812624615957968783430040737357155655049053820071964;
        points[64] = 0.402059926644549504453563288678260582077445842954742407;
        points[65] = 0.429929561878038574140681950003769736487432054764095518;
        points[66] = 0.457395351542891911298137966951114920467132743453152009;
        points[67] = 0.484431496209715170371521667396345795569242434728527236;
        points[68] = 0.511012600027427631397853530387045544947026175298706539;
        points[69] = 0.537113694578345212773295290986923261202749151090102151;
        points[70] = 0.562710262331764357641432580170503004659059294686655573;
        points[71] = 0.587778259674016602774792442569437378988110118327103611;
        points[72] = 0.612294139493361611070756653338530550276790199818908325;
        points[73] = 0.636234873298504789668052986264223639303383663855646031;
        points[74] = 0.659577972849963951865948039346940771481318265477162005;
        points[75] = 0.682301511283967429293076505770145573391280731673794866;
        points[76] = 0.704384143709043213001564237429852638146373405255521707;
        points[77] = 0.725805127255954712872666085372878856028611495730158135;
        points[78] = 0.746544340562153202950817168430554695199639944527194364;
        points[79] = 0.766582302672449628702892162308796303908511635457545143;
        points[80] = 0.785900191338158918251648807991213482543618732861387037;
        points[81] = 0.804479860697538108308369923845051237802854170626284815;
        points[82] = 0.822303858320925519406944705169690804340063258723154865;
        points[83] = 0.839355441604592312920505972708601422258932153546743429;
        points[84] = 0.855618593497941105273679087388626996227557513826712998;
        points[85] = 0.871078037549331156171472366360095762067129208247009215;
        points[86] = 0.885719252256480435470579708856048560473556517728759134;
        points[87] = 0.899528484708100246304064328648785738848564783874949878;
        points[88] = 0.912492763504174951995861380616353012160990619149342279;
        points[89] = 0.924599910943141594570569087702063448387377362867589805;
        points[90] = 0.935838554465221983988501048496828091032839416583286072;
        points[91] = 0.946198137342464995670134184566784573102681660291164088;
        points[92] = 0.955668928608015375673766010332702288672416231395456316;
        points[93] = 0.964242032220576721229620521197848558475951659503574837;
        points[94] = 0.971909395467173489841056235026722773098239420184621509;
        points[95] = 0.978663816624404607978549739537497608238217891623236471;
        points[96] = 0.984498951945387236698119090253758796514068751783150689;
        points[97] = 0.989409322189570931781209884383785270168159552993400619;
        points[98] = 0.993390319485722202009559354804261605803548454049933816;
        points[99] = 0.996438218115862869659094158776484487512292819800029795;
        points[100] = 0.998550212645212665298458888988769685801079183954812131;
        points[101] = 0.999724788824757584049721307536866588051993271530371346;
        weights[0] = 0.000706248351458089058042068327400414996991352846922540662;
        weights[1] = 0.00164336791872493954564044541951189783811590917197391012;
        weights[2] = 0.0025803327578890424184802979625372124266351709531227728;
        weights[3] = 0.00351499449488977302959501258847373796148986486460309249;
        weights[4] = 0.00444637873444317845612639632768913503607255070358847307;
        weights[5] = 0.00537359362439905890396083666379616693643806400265157041;
        weights[6] = 0.00629576370193630538289571026212923499292591207316103224;
        weights[7] = 0.00721202121392052594305284356575140148814963907564339345;
        weights[8] = 0.00812150487599544758311709893020387928254180024476146796;
        weights[9] = 0.00902336010274050281074437927638461059757969677979068755;
        weights[10] = 0.00991673961480364037980831487622296257553443022319604025;
        weights[11] = 0.0108008041591362936307064702948120050660600277457481633;
        weights[12] = 0.0116747232648673149990290326530588827251627914995214953;
        weights[13] = 0.0125376760082505681770735185842678700998714041317103149;
        weights[14] = 0.0133888517762267707940010225414699708949288132216703362;
        weights[15] = 0.014227451023864885329514976832457918654161965810603883;
        weights[16] = 0.0150526860231862069476744688440533536391385339716903927;
        weights[17] = 0.0158637816018229777527384480426283225607757548052329226;
        weights[18] = 0.0166599758703959909220086450752161883395326549816114143;
        weights[19] = 0.017440520937707480866609935029023640657649816150506581;
        weights[20] = 0.0182046836129574992003019895113346567751799575845270978;
        weights[21] = 0.0189517460942564825606548414932012054580484219945960938;
        weights[22] = 0.0196810066427478739211760877865589729092959137790503185;
        weights[23] = 0.0203917802416839830856745649755679994618590577074573546;
        weights[24] = 0.021083399239821507465834882046319388817343659616181662;
        weights[25] = 0.0217552139785232463950120198853183578212203273223459455;
        weights[26] = 0.0224065934019711097777293572927945296629949287288667517;
        weights[27] = 0.0230369256499134072326832860708229205552826536868556616;
        weights[28] = 0.0236456186323870879696845348553119398663882393587920805;
        weights[29] = 0.0242321005858733563322794768428165909155103635293112221;
        weights[30] = 0.0247958206103630675662818268676649115388948646588909065;
        weights[31] = 0.0253362491868265995226716051455733380216709555879392619;
        weights[32] = 0.0258528786746015452987349154896370479025245639788810375;
        weights[33] = 0.0263452237882306017945876358436894649550236902405850932;
        weights[34] = 0.0268128220533014474881009297269356013421989792401870601;
        weights[35] = 0.0272552342408602077202962438438897238160549512499669013;
        weights[36] = 0.0276720447799902897069592770431007698490056834673909321;
        weights[37] = 0.0280628621481689206325016615149818757391423906010599208;
        weights[38] = 0.0284273192390346261172177684935349997374891906926703153;
        weights[39] = 0.0287650737072201267744549124930663440347637952108581676;
        weights[40] = 0.0290758082899266898361137769550344652816709415545399751;
        weights[41] = 0.0293592311049378322742042154582441891213108373140400185;
        weights[42] = 0.0296150759247924120778916861692798000910006491426851859;
        weights[43] = 0.0298431024268595453647631424030031796616924752526528495;
        weights[44] = 0.0300430964190804283456349724142804332091711474808923747;
        weights[45] = 0.0302148700411650039733508155579760944602150993351575047;
        weights[46] = 0.0303582619410544722185850979799619166404491301407353061;
        weights[47] = 0.0304731374264838788944997721273555359023404149331083096;
        weights[48] = 0.0305593885915024091387512199322889799602404114120672699;
        weights[49] = 0.0306169344178325362105321570887526996080632423152309021;
        weights[50] = 0.0306457208509728121720154045946132601141969096247660352;
        weights[51] = 0.0306457208509728121720154045946132601141969096247660352;
        weights[52] = 0.0306169344178325362105321570887526996080632423152309021;
        weights[53] = 0.0305593885915024091387512199322889799602404114120672699;
        weights[54] = 0.0304731374264838788944997721273555359023404149331083096;
        weights[55] = 0.0303582619410544722185850979799619166404491301407353061;
        weights[56] = 0.0302148700411650039733508155579760944602150993351575047;
        weights[57] = 0.0300430964190804283456349724142804332091711474808923747;
        weights[58] = 0.0298431024268595453647631424030031796616924752526528495;
        weights[59] = 0.0296150759247924120778916861692798000910006491426851859;
        weights[60] = 0.0293592311049378322742042154582441891213108373140400185;
        weights[61] = 0.0290758082899266898361137769550344652816709415545399751;
        weights[62] = 0.0287650737072201267744549124930663440347637952108581676;
        weights[63] = 0.0284273192390346261172177684935349997374891906926703153;
        weights[64] = 0.0280628621481689206325016615149818757391423906010599208;
        weights[65] = 0.0276720447799902897069592770431007698490056834673909321;
        weights[66] = 0.0272552342408602077202962438438897238160549512499669013;
        weights[67] = 0.0268128220533014474881009297269356013421989792401870601;
        weights[68] = 0.0263452237882306017945876358436894649550236902405850932;
        weights[69] = 0.0258528786746015452987349154896370479025245639788810375;
        weights[70] = 0.0253362491868265995226716051455733380216709555879392619;
        weights[71] = 0.0247958206103630675662818268676649115388948646588909065;
        weights[72] = 0.0242321005858733563322794768428165909155103635293112221;
        weights[73] = 0.0236456186323870879696845348553119398663882393587920805;
        weights[74] = 0.0230369256499134072326832860708229205552826536868556616;
        weights[75] = 0.0224065934019711097777293572927945296629949287288667517;
        weights[76] = 0.0217552139785232463950120198853183578212203273223459455;
        weights[77] = 0.021083399239821507465834882046319388817343659616181662;
        weights[78] = 0.0203917802416839830856745649755679994618590577074573546;
        weights[79] = 0.0196810066427478739211760877865589729092959137790503185;
        weights[80] = 0.0189517460942564825606548414932012054580484219945960938;
        weights[81] = 0.0182046836129574992003019895113346567751799575845270978;
        weights[82] = 0.017440520937707480866609935029023640657649816150506581;
        weights[83] = 0.0166599758703959909220086450752161883395326549816114143;
        weights[84] = 0.0158637816018229777527384480426283225607757548052329226;
        weights[85] = 0.0150526860231862069476744688440533536391385339716903927;
        weights[86] = 0.014227451023864885329514976832457918654161965810603883;
        weights[87] = 0.0133888517762267707940010225414699708949288132216703362;
        weights[88] = 0.0125376760082505681770735185842678700998714041317103149;
        weights[89] = 0.0116747232648673149990290326530588827251627914995214953;
        weights[90] = 0.0108008041591362936307064702948120050660600277457481633;
        weights[91] = 0.00991673961480364037980831487622296257553443022319604025;
        weights[92] = 0.00902336010274050281074437927638461059757969677979068755;
        weights[93] = 0.00812150487599544758311709893020387928254180024476146796;
        weights[94] = 0.00721202121392052594305284356575140148814963907564339345;
        weights[95] = 0.00629576370193630538289571026212923499292591207316103224;
        weights[96] = 0.00537359362439905890396083666379616693643806400265157041;
        weights[97] = 0.00444637873444317845612639632768913503607255070358847307;
        weights[98] = 0.00351499449488977302959501258847373796148986486460309249;
        weights[99] = 0.0025803327578890424184802979625372124266351709531227728;
        weights[100] = 0.00164336791872493954564044541951189783811590917197391012;
        weights[101] = 0.000706248351458089058042068327400414996991352846922540662;
        return;
    case 103:
        points[0] = -0.999730080944572485964195475006327876462406659441080331;
        points[1] = -0.998578085694657405589078320916577013438736557499307277;
        points[2] = -0.996506671882827049549857093168067824963282999848656433;
        points[3] = -0.993517287258134597228005289442806048902012182248921166;
        points[4] = -0.989612629403879880438556740280809055864641401329937316;
        points[5] = -0.984796282068103625318675452011626237875455333591823052;
        points[6] = -0.979072677897943717661449071028520756010967306137826433;
        points[7] = -0.972447088024582167575311253460124825453855395188733453;
        points[8] = -0.964925615523988933109550823954699750477075564690893335;
        points[9] = -0.956515189234407571077865899793109463718152159059072119;
        points[10] = -0.947223557155171072973379083051882471653840876187699271;
        points[11] = -0.937059279213492787643287773953077011952028464582569323;
        points[12] = -0.926031719332933555713539530500705726124619357588429211;
        points[13] = -0.914151036783307517339008744032875810819349544420305001;
        points[14] = -0.901428176808508018416973325044397384941880219305722174;
        points[15] = -0.887874860535695418451439863314254564899622813069168093;
        points[16] = -0.873503574172634683683796744585478006956527751215576305;
        points[17] = -0.858327557501853317373814831813939704584646025251424273;
        points[18] = -0.84236079168153274363737890105756119690853779585327493;
        points[19] = -0.825617986363988150600625365799421508429349909031559922;
        points[20] = -0.808114566143381955329621936265531671287615441943641595;
        points[21] = -0.789866656345023353179811661584551531174588348560984928;
        points[22] = -0.770891068169264123920919902802043087757191953277484343;
        points[23] = -0.751205283203625615749655504934372852562151814014468046;
        points[24] = -0.730827437317392130626043465508225887238578415349387007;
        points[25] = -0.709776303953486193344992190970135688979540661625950289;
        points[26] = -0.688071276833003651956904958304486449197712762455062032;
        points[27] = -0.665732352088332317258181034328895139743566093314162815;
        points[28] = -0.64278010984130735174760679642837326297626415778989956;
        points[29] = -0.619235695243369950819634754809456810998232993251995635;
        points[30] = -0.595120798995192903145756330016604969858655086176782018;
        points[31] = -0.570457637363717138681671305324774661691669486622975128;
        points[32] = -0.545268931715007071912783241545506530442671668859351074;
        points[33] = -0.519577887581779090740503790320963896560510166528882453;
        points[34] = -0.493408173284886577956579998817642941261577778389250129;
        points[35] = -0.466783898128456028519795225325414521662608822031913751;
        points[36] = -0.439729590188761791022702142561310584044256038890165103;
        points[37] = -0.412270173717301373023764750470147512569620855302650924;
        points[38] = -0.384430946178888775761022278729911493922578980887648399;
        points[39] = -0.35623755494591964601930488706507487149259591488040469;
        points[40] = -0.32771597367027884842176833380223819175433144840872145;
        points[41] = -0.298892478354658083066611535304011106149883914121894935;
        points[42] = -0.269793623145328131051378334003610111488647546689394332;
        points[43] = -0.240446215868666951388199297051775824588671220683995489;
        points[44] = -0.210877293333980942530121056988874188012239729657769084;
        points[45] = -0.181114096425372004069126125984613625004335795467689222;
        points[46] = -0.151184045005597391780412895567126342758482403413923928;
        points[47] = -0.121114712655042573781943196321877132031144420723336307;
        points[48] = -0.0909338012690792081481255974725601844562761507923926502;
        points[49] = -0.0606691155372108333390693881238819157794000327502810624;
        points[50] = -0.0303485373275177724047542840183400206089081420026293134;
        points[51] = 0;
        points[52] = 0.0303485373275177724047542840183400206089081420026293134;
        points[53] = 0.0606691155372108333390693881238819157794000327502810624;
        points[54] = 0.0909338012690792081481255974725601844562761507923926502;
        points[55] = 0.121114712655042573781943196321877132031144420723336307;
        points[56] = 0.151184045005597391780412895567126342758482403413923928;
        points[57] = 0.181114096425372004069126125984613625004335795467689222;
        points[58] = 0.210877293333980942530121056988874188012239729657769084;
        points[59] = 0.240446215868666951388199297051775824588671220683995489;
        points[60] = 0.269793623145328131051378334003610111488647546689394332;
        points[61] = 0.298892478354658083066611535304011106149883914121894935;
        points[62] = 0.32771597367027884842176833380223819175433144840872145;
        points[63] = 0.35623755494591964601930488706507487149259591488040469;
        points[64] = 0.384430946178888775761022278729911493922578980887648399;
        points[65] = 0.412270173717301373023764750470147512569620855302650924;
        points[66] = 0.439729590188761791022702142561310584044256038890165103;
        points[67] = 0.466783898128456028519795225325414521662608822031913751;
        points[68] = 0.493408173284886577956579998817642941261577778389250129;
        points[69] = 0.519577887581779090740503790320963896560510166528882453;
        points[70] = 0.545268931715007071912783241545506530442671668859351074;
        points[71] = 0.570457637363717138681671305324774661691669486622975128;
        points[72] = 0.595120798995192903145756330016604969858655086176782018;
        points[73] = 0.619235695243369950819634754809456810998232993251995635;
        points[74] = 0.64278010984130735174760679642837326297626415778989956;
        points[75] = 0.665732352088332317258181034328895139743566093314162815;
        points[76] = 0.688071276833003651956904958304486449197712762455062032;
        points[77] = 0.709776303953486193344992190970135688979540661625950289;
        points[78] = 0.730827437317392130626043465508225887238578415349387007;
        points[79] = 0.751205283203625615749655504934372852562151814014468046;
        points[80] = 0.770891068169264123920919902802043087757191953277484343;
        points[81] = 0.789866656345023353179811661584551531174588348560984928;
        points[82] = 0.808114566143381955329621936265531671287615441943641595;
        points[83] = 0.825617986363988150600625365799421508429349909031559922;
        points[84] = 0.84236079168153274363737890105756119690853779585327493;
        points[85] = 0.858327557501853317373814831813939704584646025251424273;
        points[86] = 0.873503574172634683683796744585478006956527751215576305;
        points[87] = 0.887874860535695418451439863314254564899622813069168093;
        points[88] = 0.901428176808508018416973325044397384941880219305722174;
        points[89] = 0.914151036783307517339008744032875810819349544420305001;
        points[90] = 0.926031719332933555713539530500705726124619357588429211;
        points[91] = 0.937059279213492787643287773953077011952028464582569323;
        points[92] = 0.947223557155171072973379083051882471653840876187699271;
        points[93] = 0.956515189234407571077865899793109463718152159059072119;
        points[94] = 0.964925615523988933109550823954699750477075564690893335;
        points[95] = 0.972447088024582167575311253460124825453855395188733453;
        points[96] = 0.979072677897943717661449071028520756010967306137826433;
        points[97] = 0.984796282068103625318675452011626237875455333591823052;
        points[98] = 0.989612629403879880438556740280809055864641401329937316;
        points[99] = 0.993517287258134597228005289442806048902012182248921166;
        points[100] = 0.996506671882827049549857093168067824963282999848656433;
        points[101] = 0.998578085694657405589078320916577013438736557499307277;
        points[102] = 0.999730080944572485964195475006327876462406659441080331;
        weights[0] = 0.000692668297071954591104451247362428848664396143115499552;
        weights[1] = 0.00161178065814391268301288531983163621784244140616916941;
        weights[2] = 0.00253077036035695151863850673460833756558106492542326288;
        weights[3] = 0.00344754690527307695347905809844341470906865312284150199;
        weights[4] = 0.00436117111199139706518135370953295142266957231776183143;
        weights[5] = 0.00527078463964770917006734773306622674538854275616180903;
        weights[6] = 0.0061755450752270700353998658470110683169137938090445077;
        weights[7] = 0.00707461739047212242783634301310778164082466071670400376;
        weights[8] = 0.00796717269471874380582308698520105174351659667657898723;
        weights[9] = 0.00885238843079684038042661298870501737037842086526606621;
        weights[10] = 0.00972944894098748575680589827493311456044170840946344251;
        weights[11] = 0.0105975461442792581782494219543456333098443911228624997;
        weights[12] = 0.0114558802489912080985886776375623426216350083347792345;
        weights[13] = 0.0123036604747484426487145333433470732634607717954370365;
        weights[14] = 0.013140105773591919348660702355056534862896633463853421;
        weights[15] = 0.0139644455456180414563067304016155909649179593894182127;
        weights[16] = 0.0147759203467378001609390867272688186561167024342295865;
        weights[17] = 0.0155737825870749353071138536657919020273472923895823458;
        weights[18] = 0.0163572972189461426653227964262804349869950041584016334;
        weights[19] = 0.0171257424135733105698844852864826460505957349884776532;
        weights[20] = 0.017878410225786670654313897061292317021326401259819381;
        weights[21] = 0.0186146072460401188844439878250549367695006652566033009;
        weights[22] = 0.019333655239099389414844653900927264416586036150714592;
        weights[23] = 0.0200348917687915436721011115265469491418654255049128749;
        weights[24] = 0.020717670808226004099560225872776308614989339410351918;
        weights[25] = 0.0213813633349160257323290399108216974323292154320134934;
        weights[26] = 0.022025357910246608741011484659956289818885093069921787;
        weights[27] = 0.0226490612427512584053986586154972538715591118093534779;
        weights[28] = 0.0232518987346761686487973967693238362972772737189229002;
        weights[29] = 0.0238333150113266093082785020687161136597304188243925919;
        weights[30] = 0.0243927744327066885104605744820950174873695044614956538;
        weights[31] = 0.0249297615869803262378379803489665224354406109166436989;
        weights[32] = 0.0254437817652982606298732439455136476767677478932367902;
        weights[33] = 0.0259343614175532383919873847302061930589176581749671077;
        weights[34] = 0.0264010485886432239746506815724722413783071257201730584;
        weights[35] = 0.0268434133348404988733875119911722456441302827203976003;
        weights[36] = 0.0272610481198829065363130298586702547461268265412766551;
        weights[37] = 0.0276535681904222201131061725958151800066477634952190236;
        weights[38] = 0.0280206119304836571781989720250498106111978790542863211;
        weights[39] = 0.0283618411946099233305599652755771724250630565227216235;
        weights[40] = 0.0286769416193828196324320132145832941400733154775071922;
        weights[41] = 0.0289656229130353806649282913921191466701481272829380845;
        weights[42] = 0.0292276191228877032930993958280239153428623728696202607;
        weights[43] = 0.0294626888803600632298706344702059882847095664719398792;
        weights[44] = 0.0296706156233375789033672576014815172261294138238333095;
        weights[45] = 0.0298512077956815513384497176259599098875571849992647899;
        weights[46] = 0.0300042990237036658330402763943814181255071306012562573;
        weights[47] = 0.0301297482694404669638524237104597972869178594646386172;
        weights[48] = 0.0302274399605868935036849660949360621056853004566152033;
        weights[49] = 0.0302972840969691646047950093023678839796630855340132282;
        weights[50] = 0.0303392163334589233826309406650275830036905439638079135;
        weights[51] = 0.0303531980392522489816778018288964510958786277831394184;
        weights[52] = 0.0303392163334589233826309406650275830036905439638079135;
        weights[53] = 0.0302972840969691646047950093023678839796630855340132282;
        weights[54] = 0.0302274399605868935036849660949360621056853004566152033;
        weights[55] = 0.0301297482694404669638524237104597972869178594646386172;
        weights[56] = 0.0300042990237036658330402763943814181255071306012562573;
        weights[57] = 0.0298512077956815513384497176259599098875571849992647899;
        weights[58] = 0.0296706156233375789033672576014815172261294138238333095;
        weights[59] = 0.0294626888803600632298706344702059882847095664719398792;
        weights[60] = 0.0292276191228877032930993958280239153428623728696202607;
        weights[61] = 0.0289656229130353806649282913921191466701481272829380845;
        weights[62] = 0.0286769416193828196324320132145832941400733154775071922;
        weights[63] = 0.0283618411946099233305599652755771724250630565227216235;
        weights[64] = 0.0280206119304836571781989720250498106111978790542863211;
        weights[65] = 0.0276535681904222201131061725958151800066477634952190236;
        weights[66] = 0.0272610481198829065363130298586702547461268265412766551;
        weights[67] = 0.0268434133348404988733875119911722456441302827203976003;
        weights[68] = 0.0264010485886432239746506815724722413783071257201730584;
        weights[69] = 0.0259343614175532383919873847302061930589176581749671077;
        weights[70] = 0.0254437817652982606298732439455136476767677478932367902;
        weights[71] = 0.0249297615869803262378379803489665224354406109166436989;
        weights[72] = 0.0243927744327066885104605744820950174873695044614956538;
        weights[73] = 0.0238333150113266093082785020687161136597304188243925919;
        weights[74] = 0.0232518987346761686487973967693238362972772737189229002;
        weights[75] = 0.0226490612427512584053986586154972538715591118093534779;
        weights[76] = 0.022025357910246608741011484659956289818885093069921787;
        weights[77] = 0.0213813633349160257323290399108216974323292154320134934;
        weights[78] = 0.020717670808226004099560225872776308614989339410351918;
        weights[79] = 0.0200348917687915436721011115265469491418654255049128749;
        weights[80] = 0.019333655239099389414844653900927264416586036150714592;
        weights[81] = 0.0186146072460401188844439878250549367695006652566033009;
        weights[82] = 0.017878410225786670654313897061292317021326401259819381;
        weights[83] = 0.0171257424135733105698844852864826460505957349884776532;
        weights[84] = 0.0163572972189461426653227964262804349869950041584016334;
        weights[85] = 0.0155737825870749353071138536657919020273472923895823458;
        weights[86] = 0.0147759203467378001609390867272688186561167024342295865;
        weights[87] = 0.0139644455456180414563067304016155909649179593894182127;
        weights[88] = 0.013140105773591919348660702355056534862896633463853421;
        weights[89] = 0.0123036604747484426487145333433470732634607717954370365;
        weights[90] = 0.0114558802489912080985886776375623426216350083347792345;
        weights[91] = 0.0105975461442792581782494219543456333098443911228624997;
        weights[92] = 0.00972944894098748575680589827493311456044170840946344251;
        weights[93] = 0.00885238843079684038042661298870501737037842086526606621;
        weights[94] = 0.00796717269471874380582308698520105174351659667657898723;
        weights[95] = 0.00707461739047212242783634301310778164082466071670400376;
        weights[96] = 0.0061755450752270700353998658470110683169137938090445077;
        weights[97] = 0.00527078463964770917006734773306622674538854275616180903;
        weights[98] = 0.00436117111199139706518135370953295142266957231776183143;
        weights[99] = 0.00344754690527307695347905809844341470906865312284150199;
        weights[100] = 0.00253077036035695151863850673460833756558106492542326288;
        weights[101] = 0.00161178065814391268301288531983163621784244140616916941;
        weights[102] = 0.000692668297071954591104451247362428848664396143115499552;
        return;
    case 104:
        points[0] = -0.999735221876088270319271941299655537812421958781160153;
        points[1] = -0.998605162651977346207698175741067883806631979643435469;
        points[2] = -0.996573171406038938608421383989730970197876516770522887;
        points[3] = -0.993640632689703059843546644610149283466512195479849238;
        points[4] = -0.989810141336719305821213927387160201734387553840580487;
        points[5] = -0.985085145814462050635904475886708546811609795892940264;
        points[6] = -0.979469911790591978029328965328060661503492295261447595;
        points[7] = -0.972969512067358381023768305912942663004127878644785857;
        points[8] = -0.96558982034615708551863438549137344883988677101656305;
        points[9] = -0.957337505370073351199550967706684725847471969410162652;
        points[10] = -0.948220024683483849970313308435647168666179126536780948;
        points[11] = -0.938245617799104275916961634160274433966622690037870453;
        points[12] = -0.92742329870708648999387144585231400472279864955851999;
        points[13] = -0.915762847705915732789711426379742380684298393727521308;
        points[14] = -0.903274802551222088059484549592445732335380684091453742;
        points[15] = -0.889970448925411852635629828492097518883139307027488833;
        points[16] = -0.875861810234271061896714475361421215680363616625595724;
        points[17] = -0.860961636738505093718849875405909271767221761604980343;
        points[18] = -0.845283394029362697009879562063579613450211734193102701;
        points[19] = -0.828841250858382969051484620510789542134035276503857021;
        points[20] = -0.811650066332045885955997035064066721730685995087440542;
        points[21] = -0.793725376482768577455317437010658346556746945547539705;
        points[22] = -0.775083380228303303151172022896095761290455340526988209;
        points[23] = -0.755740924732175383866113154201879306705453377295222678;
        points[24] = -0.735715490178358559028487890920158988094862117943848251;
        points[25] = -0.715025173973925735133402047431128642811988510961533038;
        points[26] = -0.693688674393937103711162468630356329802228324201524076;
        points[27] = -0.671725273683336242471668623050431437514408423096627853;
        points[28] = -0.64915482063111854298381542692137145484785074751646256;
        points[29] = -0.625997712632515250140509103891964489621974607280352353;
        points[30] = -0.602274877255400468146662795969759828904733936684690668;
        points[31] = -0.578007753327577484592388058949721187098997941305361302;
        points[32] = -0.553218271562034422897775829101570937481320746980629265;
        points[33] = -0.527928834737677253465177766736142412559001846986542762;
        points[34] = -0.502162297453450257821181939002543858548243573817269805;
        points[35] = -0.475941945474139824953892670676504720633812177098525947;
        points[36] = -0.449291474686526643759598850647891702000467437827284527;
        points[37] = -0.422234969684903625231438116072397624524607295339926664;
        points[38] = -0.394796882005311937512482527338679830655220984105296713;
        points[39] = -0.367002008028165072621697265025762324099965705226103727;
        points[40] = -0.338875466569230605122243073432472707930761653449460916;
        points[41] = -0.310442676179220984043787404585505469295118924131437817;
        points[42] = -0.281729332172508068823313608562493497735141901702162601;
        points[43] = -0.252761383405720942352125113615013134452058307956358321;
        points[44] = -0.223565008827212589975946068184907954869386852602286876;
        points[45] = -0.194166593818588119543308579683627714376391396549288957;
        points[46] = -0.164592706349675128187788338402793114637042813426035922;
        points[47] = -0.134870072968485427374800894758252586314807966322035849;
        points[48] = -0.105025554647866467034240782295049965385383862136768447;
        points[49] = -0.0750861225106703179890681594105076119893639471686049413;
        points[50] = -0.0450788334553778626474421259008150357964863269985446473;
        points[51] = -0.0150308057042058080702446658612512308682602267836511196;
        points[52] = 0.0150308057042058080702446658612512308682602267836511196;
        points[53] = 0.0450788334553778626474421259008150357964863269985446473;
        points[54] = 0.0750861225106703179890681594105076119893639471686049413;
        points[55] = 0.105025554647866467034240782295049965385383862136768447;
        points[56] = 0.134870072968485427374800894758252586314807966322035849;
        points[57] = 0.164592706349675128187788338402793114637042813426035922;
        points[58] = 0.194166593818588119543308579683627714376391396549288957;
        points[59] = 0.223565008827212589975946068184907954869386852602286876;
        points[60] = 0.252761383405720942352125113615013134452058307956358321;
        points[61] = 0.281729332172508068823313608562493497735141901702162601;
        points[62] = 0.310442676179220984043787404585505469295118924131437817;
        points[63] = 0.338875466569230605122243073432472707930761653449460916;
        points[64] = 0.367002008028165072621697265025762324099965705226103727;
        points[65] = 0.394796882005311937512482527338679830655220984105296713;
        points[66] = 0.422234969684903625231438116072397624524607295339926664;
        points[67] = 0.449291474686526643759598850647891702000467437827284527;
        points[68] = 0.475941945474139824953892670676504720633812177098525947;
        points[69] = 0.502162297453450257821181939002543858548243573817269805;
        points[70] = 0.527928834737677253465177766736142412559001846986542762;
        points[71] = 0.553218271562034422897775829101570937481320746980629265;
        points[72] = 0.578007753327577484592388058949721187098997941305361302;
        points[73] = 0.602274877255400468146662795969759828904733936684690668;
        points[74] = 0.625997712632515250140509103891964489621974607280352353;
        points[75] = 0.64915482063111854298381542692137145484785074751646256;
        points[76] = 0.671725273683336242471668623050431437514408423096627853;
        points[77] = 0.693688674393937103711162468630356329802228324201524076;
        points[78] = 0.715025173973925735133402047431128642811988510961533038;
        points[79] = 0.735715490178358559028487890920158988094862117943848251;
        points[80] = 0.755740924732175383866113154201879306705453377295222678;
        points[81] = 0.775083380228303303151172022896095761290455340526988209;
        points[82] = 0.793725376482768577455317437010658346556746945547539705;
        points[83] = 0.811650066332045885955997035064066721730685995087440542;
        points[84] = 0.828841250858382969051484620510789542134035276503857021;
        points[85] = 0.845283394029362697009879562063579613450211734193102701;
        points[86] = 0.860961636738505093718849875405909271767221761604980343;
        points[87] = 0.875861810234271061896714475361421215680363616625595724;
        points[88] = 0.889970448925411852635629828492097518883139307027488833;
        points[89] = 0.903274802551222088059484549592445732335380684091453742;
        points[90] = 0.915762847705915732789711426379742380684298393727521308;
        points[91] = 0.92742329870708648999387144585231400472279864955851999;
        points[92] = 0.938245617799104275916961634160274433966622690037870453;
        points[93] = 0.948220024683483849970313308435647168666179126536780948;
        points[94] = 0.957337505370073351199550967706684725847471969410162652;
        points[95] = 0.96558982034615708551863438549137344883988677101656305;
        points[96] = 0.972969512067358381023768305912942663004127878644785857;
        points[97] = 0.979469911790591978029328965328060661503492295261447595;
        points[98] = 0.985085145814462050635904475886708546811609795892940264;
        points[99] = 0.989810141336719305821213927387160201734387553840580487;
        points[100] = 0.993640632689703059843546644610149283466512195479849238;
        points[101] = 0.996573171406038938608421383989730970197876516770522887;
        points[102] = 0.998605162651977346207698175741067883806631979643435469;
        points[103] = 0.999735221876088270319271941299655537812421958781160153;
        weights[0] = 0.000679476182484552964878983443019505190886362193398614816;
        weights[1] = 0.00158109529119484232133520615003959460625640106003732719;
        weights[2] = 0.00248262180217678465149962945059600426315445990708994881;
        weights[3] = 0.0033820208186870304830989231262799988652959139855013312;
        weights[4] = 0.00427838675247227464157219186883721245419982460298781012;
        weights[5] = 0.0051708932073277532916270909567499487720031354579822327;
        weights[6] = 0.00605872927475065191931876088398179881423707445987845498;
        weights[7] = 0.00694109112518097602627030518904308318019715486001244213;
        weights[8] = 0.00781718075642534954170737726193363527431548268189162107;
        weights[9] = 0.0086862061579237202554919238838116961444225348040536764;
        weights[10] = 0.00954738183832692301639848705268493486070078508360712168;
        weights[11] = 0.0103999294625946865339640619106154808766805360315015382;
        weights[12] = 0.0112430785241654301199942266622107541530615426063315641;
        weights[13] = 0.0120760670267164512624887531680472893055510538641919671;
        weights[14] = 0.0128981421655273319995832544066889392919055002256628182;
        weights[15] = 0.0137085610039659059705385684073632027943902681821435746;
        weights[16] = 0.0145065911427678912484512387420631992599203287820855383;
        weights[17] = 0.0152915113806926720929266939593418728549530792477852162;
        weights[18] = 0.0160626123655525193854422752756836667969711279817461652;
        weights[19] = 0.016819197234814828465523716376558020137429281289040814;
        weights[20] = 0.0175605822450830157355638513153547535961296785083697144;
        weights[21] = 0.0182860973898220936824165018533744854584487246034764416;
        weights[22] = 0.0189950870047327748410807016344099654636693696942344119;
        weights[23] = 0.0196869103602043231471967294241148778552638253664967656;
        weights[24] = 0.0203609422402968033930350389977742954085481635102127096;
        weights[25] = 0.0210165735077207312987416096822994786352622955673244189;
        weights[26] = 0.0216532116542979191490379317211442070417024672017776787;
        weights[27] = 0.022270281336402377142922609096705923017412284968918089;
        weights[28] = 0.0228672248948949337196895838710047625367154604189708467;
        weights[29] = 0.023443502859080043295277654749764352996170994180250516;
        weights[30] = 0.023998594434228208183516639141804554092875148919444486;
        weights[31] = 0.0245319979722226389991770253899527570373155916171747469;
        weights[32] = 0.0250432314249042621869948688366353849395861134826593316;
        weights[33] = 0.0255318327797049790213588921480740943558283245984207952;
        weights[34] = 0.025997360477175197775993812501425943789556983803506616;
        weights[35] = 0.0264393938100281011254651110210959279142417380331456743;
        weights[36] = 0.0268575333033398698129002680024285414764558572285973925;
        weights[37] = 0.0272514010755621530202570951091059302863347093385516836;
        weights[38] = 0.0276206411800204449786848884533158927778298552937929086;
        weights[39] = 0.0279649199265896836638227253545198953488328399196557111;
        weights[40] = 0.0282839261832563171878489061443261710377804383049338251;
        weights[41] = 0.0285773716572942720638213640271374662713223336325797981;
        weights[42] = 0.0288449911558006895256677113402739497233766535239181442;
        weights[43] = 0.0290865428253559556527517041962552705193370414031834244;
        weights[44] = 0.0293018083705914218613348052672233266947225429099198276;
        weights[45] = 0.0294905932514672777328410200294134092318538522831484906;
        weights[46] = 0.0296527268590822812131108568705402723262133805943794696;
        weights[47] = 0.0297880626698564547627763387683942570275507201338334394;
        weights[48] = 0.0298964783779474026912614557436293328061573912758300599;
        weights[49] = 0.0299778760057805771213510150733845530341343810656526964;
        weights[50] = 0.0300321819925936001211654134699201179454929461763687198;
        weights[51] = 0.0300593472609146197008242025896460114573460451343413895;
        weights[52] = 0.0300593472609146197008242025896460114573460451343413895;
        weights[53] = 0.0300321819925936001211654134699201179454929461763687198;
        weights[54] = 0.0299778760057805771213510150733845530341343810656526964;
        weights[55] = 0.0298964783779474026912614557436293328061573912758300599;
        weights[56] = 0.0297880626698564547627763387683942570275507201338334394;
        weights[57] = 0.0296527268590822812131108568705402723262133805943794696;
        weights[58] = 0.0294905932514672777328410200294134092318538522831484906;
        weights[59] = 0.0293018083705914218613348052672233266947225429099198276;
        weights[60] = 0.0290865428253559556527517041962552705193370414031834244;
        weights[61] = 0.0288449911558006895256677113402739497233766535239181442;
        weights[62] = 0.0285773716572942720638213640271374662713223336325797981;
        weights[63] = 0.0282839261832563171878489061443261710377804383049338251;
        weights[64] = 0.0279649199265896836638227253545198953488328399196557111;
        weights[65] = 0.0276206411800204449786848884533158927778298552937929086;
        weights[66] = 0.0272514010755621530202570951091059302863347093385516836;
        weights[67] = 0.0268575333033398698129002680024285414764558572285973925;
        weights[68] = 0.0264393938100281011254651110210959279142417380331456743;
        weights[69] = 0.025997360477175197775993812501425943789556983803506616;
        weights[70] = 0.0255318327797049790213588921480740943558283245984207952;
        weights[71] = 0.0250432314249042621869948688366353849395861134826593316;
        weights[72] = 0.0245319979722226389991770253899527570373155916171747469;
        weights[73] = 0.023998594434228208183516639141804554092875148919444486;
        weights[74] = 0.023443502859080043295277654749764352996170994180250516;
        weights[75] = 0.0228672248948949337196895838710047625367154604189708467;
        weights[76] = 0.022270281336402377142922609096705923017412284968918089;
        weights[77] = 0.0216532116542979191490379317211442070417024672017776787;
        weights[78] = 0.0210165735077207312987416096822994786352622955673244189;
        weights[79] = 0.0203609422402968033930350389977742954085481635102127096;
        weights[80] = 0.0196869103602043231471967294241148778552638253664967656;
        weights[81] = 0.0189950870047327748410807016344099654636693696942344119;
        weights[82] = 0.0182860973898220936824165018533744854584487246034764416;
        weights[83] = 0.0175605822450830157355638513153547535961296785083697144;
        weights[84] = 0.016819197234814828465523716376558020137429281289040814;
        weights[85] = 0.0160626123655525193854422752756836667969711279817461652;
        weights[86] = 0.0152915113806926720929266939593418728549530792477852162;
        weights[87] = 0.0145065911427678912484512387420631992599203287820855383;
        weights[88] = 0.0137085610039659059705385684073632027943902681821435746;
        weights[89] = 0.0128981421655273319995832544066889392919055002256628182;
        weights[90] = 0.0120760670267164512624887531680472893055510538641919671;
        weights[91] = 0.0112430785241654301199942266622107541530615426063315641;
        weights[92] = 0.0103999294625946865339640619106154808766805360315015382;
        weights[93] = 0.00954738183832692301639848705268493486070078508360712168;
        weights[94] = 0.0086862061579237202554919238838116961444225348040536764;
        weights[95] = 0.00781718075642534954170737726193363527431548268189162107;
        weights[96] = 0.00694109112518097602627030518904308318019715486001244213;
        weights[97] = 0.00605872927475065191931876088398179881423707445987845498;
        weights[98] = 0.0051708932073277532916270909567499487720031354579822327;
        weights[99] = 0.00427838675247227464157219186883721245419982460298781012;
        weights[100] = 0.0033820208186870304830989231262799988652959139855013312;
        weights[101] = 0.00248262180217678465149962945059600426315445990708994881;
        weights[102] = 0.00158109529119484232133520615003959460625640106003732719;
        weights[103] = 0.000679476182484552964878983443019505190886362193398614816;
        return;
    case 105:
        points[0] = -0.999740217323820519937185283863421054333432372697945156;
        points[1] = -0.998631473545333039042866620482556832962592682506685429;
        points[2] = -0.996637790357182194112598446586492022888613608870701372;
        points[3] = -0.993760492225756944007150515950181528714493561456041625;
        points[4] = -0.990002076050902796865124595022277731719875924015289875;
        points[5] = -0.985365861334156126968416645333579013686204472561172444;
        points[6] = -0.979855954547394608899458248180808486302123919115914737;
        points[7] = -0.973477239398280172058649712504719396750327190254710863;
        points[8] = -0.966235370880153598238904917378777573426644034544472765;
        points[9] = -0.958136769719022258255776026708201005534603324135591415;
        points[10] = -0.949188616470811540043752819147416873654370009263692442;
        points[11] = -0.939398845062925726953542361122604246216794429037440249;
        points[12] = -0.928776135715625632551102089104827100190126968381319306;
        points[13] = -0.917329907222990796762959563633523324108075848627519591;
        points[14] = -0.905070308589255082432832450352918240137033983014689235;
        points[15] = -0.892008210022934454856880279620671374653925147154277617;
        points[16] = -0.878155193294318192992585908004081717511881237945374137;
        points[17] = -0.863523541463639957824996432662456413760749517945539657;
        points[18] = -0.848126227988375499721007460974754212103892722650559337;
        points[19] = -0.831976905218956083033376678790925173671448012076565526;
        points[20] = -0.81508989229288436970558958519859595862263901266519283;
        points[21] = -0.797480162437858900209951678175664186170240188092589135;
        points[22] = -0.779163329695086531479791222052048512759609429463066882;
        points[23] = -0.76015563507450531575787077756518424635923586628767443;
        points[24] = -0.740473932154161597594165167282333235604369334468725638;
        points[25] = -0.720135672136488875754834831440574183263546354482977946;
        points[26] = -0.699158888374724455081498909296254864451791580629221952;
        points[27] = -0.677562180383174213518864416902147047063107298835845893;
        points[28] = -0.655364697345496425665277939089874029239047603684022683;
        points[29] = -0.632586121135622661130394530188019486452586261938506485;
        points[30] = -0.609246648866367258916886592089572071099965283358692965;
        points[31] = -0.585366974981196598596868657623199214822763876442806075;
        points[32] = -0.560968272905035110740870084648550799307904666766760118;
        points[33] = -0.536072176270376422734267346487864875987459591577684634;
        points[34] = -0.510700759735344933890981967314121609762645829416966576;
        points[35] = -0.484876519410715161128152076596785823320476409115450239;
        points[36] = -0.458622352913243099309457381133588783088161741561460093;
        points[37] = -0.431961539062995309616293971784600219239033915918594724;
        points[38] = -0.404917717242677203926197608222346875433543897344042621;
        points[39] = -0.377514866437261762237213924411718701366251399943608998;
        points[40] = -0.34977728397250344429686443714859334237339383205576169;
        points[41] = -0.321729563971189088982169576097147561323724617854228102;
        points[42] = -0.293396575546227902189333278014904788832681790408702216;
        points[43] = -0.264803440749915996513715701342397706273109340267047258;
        points[44] = -0.23597551229892715869961655111863074673666393361666039;
        points[45] = -0.206938351094780393325343037382760769290465429968749518;
        points[46] = -0.177717703559716148110845216959681252843357097391865496;
        points[47] = -0.148339478808076807525642602006364567144120266518353899;
        points[48] = -0.118829725673432902456782660199013008361096032534283359;
        points[49] = -0.0892146096118243956577198765398602093141415245153900783;
        points[50] = -0.0595203895015962524392094013092000403297697883087078363;
        points[51] = -0.0297733943603991964194196586387290432678709920242316615;
        points[52] = 0;
        points[53] = 0.0297733943603991964194196586387290432678709920242316615;
        points[54] = 0.0595203895015962524392094013092000403297697883087078363;
        points[55] = 0.0892146096118243956577198765398602093141415245153900783;
        points[56] = 0.118829725673432902456782660199013008361096032534283359;
        points[57] = 0.148339478808076807525642602006364567144120266518353899;
        points[58] = 0.177717703559716148110845216959681252843357097391865496;
        points[59] = 0.206938351094780393325343037382760769290465429968749518;
        points[60] = 0.23597551229892715869961655111863074673666393361666039;
        points[61] = 0.264803440749915996513715701342397706273109340267047258;
        points[62] = 0.293396575546227902189333278014904788832681790408702216;
        points[63] = 0.321729563971189088982169576097147561323724617854228102;
        points[64] = 0.34977728397250344429686443714859334237339383205576169;
        points[65] = 0.377514866437261762237213924411718701366251399943608998;
        points[66] = 0.404917717242677203926197608222346875433543897344042621;
        points[67] = 0.431961539062995309616293971784600219239033915918594724;
        points[68] = 0.458622352913243099309457381133588783088161741561460093;
        points[69] = 0.484876519410715161128152076596785823320476409115450239;
        points[70] = 0.510700759735344933890981967314121609762645829416966576;
        points[71] = 0.536072176270376422734267346487864875987459591577684634;
        points[72] = 0.560968272905035110740870084648550799307904666766760118;
        points[73] = 0.585366974981196598596868657623199214822763876442806075;
        points[74] = 0.609246648866367258916886592089572071099965283358692965;
        points[75] = 0.632586121135622661130394530188019486452586261938506485;
        points[76] = 0.655364697345496425665277939089874029239047603684022683;
        points[77] = 0.677562180383174213518864416902147047063107298835845893;
        points[78] = 0.699158888374724455081498909296254864451791580629221952;
        points[79] = 0.720135672136488875754834831440574183263546354482977946;
        points[80] = 0.740473932154161597594165167282333235604369334468725638;
        points[81] = 0.76015563507450531575787077756518424635923586628767443;
        points[82] = 0.779163329695086531479791222052048512759609429463066882;
        points[83] = 0.797480162437858900209951678175664186170240188092589135;
        points[84] = 0.81508989229288436970558958519859595862263901266519283;
        points[85] = 0.831976905218956083033376678790925173671448012076565526;
        points[86] = 0.848126227988375499721007460974754212103892722650559337;
        points[87] = 0.863523541463639957824996432662456413760749517945539657;
        points[88] = 0.878155193294318192992585908004081717511881237945374137;
        points[89] = 0.892008210022934454856880279620671374653925147154277617;
        points[90] = 0.905070308589255082432832450352918240137033983014689235;
        points[91] = 0.917329907222990796762959563633523324108075848627519591;
        points[92] = 0.928776135715625632551102089104827100190126968381319306;
        points[93] = 0.939398845062925726953542361122604246216794429037440249;
        points[94] = 0.949188616470811540043752819147416873654370009263692442;
        points[95] = 0.958136769719022258255776026708201005534603324135591415;
        points[96] = 0.966235370880153598238904917378777573426644034544472765;
        points[97] = 0.973477239398280172058649712504719396750327190254710863;
        points[98] = 0.979855954547394608899458248180808486302123919115914737;
        points[99] = 0.985365861334156126968416645333579013686204472561172444;
        points[100] = 0.990002076050902796865124595022277731719875924015289875;
        points[101] = 0.993760492225756944007150515950181528714493561456041625;
        points[102] = 0.996637790357182194112598446586492022888613608870701372;
        points[103] = 0.998631473545333039042866620482556832962592682506685429;
        points[104] = 0.999740217323820519937185283863421054333432372697945156;
        weights[0] = 0.000666657371329679146748510800318679296006970930009334895;
        weights[1] = 0.00155127781202870953346701316462836596962978183198773461;
        weights[2] = 0.00243583383453167402867630389070618320530501283409145797;
        weights[3] = 0.00331834398443293714112808927184850487518965494931062834;
        weights[4] = 0.00419793473404644477482766544850387232458639833995091842;
        weights[5] = 0.00507381015236053977620613143816500546727857379322857275;
        weights[6] = 0.0059451893759213917432373877462646174830237465016585676;
        weights[7] = 0.00681129833216419331311603935033457936039226350729709583;
        weights[8] = 0.00767136848509315023924137559479424118856459569601656105;
        weights[9] = 0.0085246369703332916749596002103462007622576489012354594;
        weights[10] = 0.0093703470869164893322208657773355920395596421161997048;
        weights[11] = 0.0102077488968346892314711169570037431809754246643542681;
        weights[12] = 0.0110360998593509118825208168278870941098628745717094733;
        weights[13] = 0.0118546654751014965170665866229843245407409522976206721;
        weights[14] = 0.0126627199302244886857160068605970074703507089515134399;
        weights[15] = 0.0134595467361511900277577922543156728516027356018462159;
        weights[16] = 0.0142444393628085159147502820653810990115772086650773699;
        weights[17] = 0.0150167018638734129409901572335256355976352944568896344;
        weights[18] = 0.0157756494931269539366979422881842350594182699029884645;
        weights[19] = 0.0165206093111535481750106302822941558319697234508410779;
        weights[20] = 0.0172509207817340766231121141285993154896859310213959382;
        weights[21] = 0.0179659363573402755271271488685537806683166630825196311;
        weights[22] = 0.0186650220531740475479812591554664509134079461473380881;
        weights[23] = 0.0193475580092204542395380882784575615363384469529056707;
        weights[24] = 0.0200129390398023607865161243453011196972581180222407792;
        weights[25] = 0.0206605751701408658399829467497983581169693846514812403;
        weights[26] = 0.021289892159440249383007171400312440462362633462840269;
        weights[27] = 0.0219003320100300272502847240839806884128528875734016731;
        weights[28] = 0.0224913534621102696360903684621200507739766659754496225;
        weights[29] = 0.0230624324736598828815071414270084926818536161954712563;
        weights[30] = 0.0236130626850812184050671451735832500751258355624587016;
        weights[31] = 0.0241427558681682453582335426860791487043675788063192942;
        weights[32] = 0.0246510423589996523616459010155759047042839795908213254;
        weights[33] = 0.0251374714743726537732879968149733500781935394072346514;
        weights[34] = 0.0256016119114079786881145686664949948986715399495152567;
        weights[35] = 0.0260430521299715188507565822214185064216425885204501669;
        weights[36] = 0.0264614007175734018414893301077792254941452640643528098;
        weights[37] = 0.0268562867364208315456871474274390249805070541466539568;
        weights[38] = 0.027227360052316889834603232162543078678637554071651;
        weights[39] = 0.0275742916451136106577063132160184593128140071413832773;
        weights[40] = 0.0278967739004440082510991866251479196559769033144493288;
        weights[41] = 0.0281945208824743518986584368237553661300150118127773557;
        weights[42] = 0.0284672685874348169781659039201622460003567280577665145;
        weights[43] = 0.0287147751777036917109241802120275381721359327685788387;
        weights[44] = 0.0289368211962375665350946974953863338679179259208548551;
        weights[45] = 0.0291332097611573634398804254997517735920695381281312244;
        weights[46] = 0.0293037667403176607611038830752518790736283966769213896;
        weights[47] = 0.029448340905704519455819272997201063919323856377033595;
        weights[48] = 0.0295668040675249041621483686245905289139290608298226032;
        weights[49] = 0.0296590511878688006679370327115928746122447815946311086;
        weights[50] = 0.0297250004738432448798087487138033711027897861137859745;
        weights[51] = 0.0297645934500956810106394055644821945904128977825003077;
        weights[52] = 0.0297777950106623424023425945198497972837209286260712879;
        weights[53] = 0.0297645934500956810106394055644821945904128977825003077;
        weights[54] = 0.0297250004738432448798087487138033711027897861137859745;
        weights[55] = 0.0296590511878688006679370327115928746122447815946311086;
        weights[56] = 0.0295668040675249041621483686245905289139290608298226032;
        weights[57] = 0.029448340905704519455819272997201063919323856377033595;
        weights[58] = 0.0293037667403176607611038830752518790736283966769213896;
        weights[59] = 0.0291332097611573634398804254997517735920695381281312244;
        weights[60] = 0.0289368211962375665350946974953863338679179259208548551;
        weights[61] = 0.0287147751777036917109241802120275381721359327685788387;
        weights[62] = 0.0284672685874348169781659039201622460003567280577665145;
        weights[63] = 0.0281945208824743518986584368237553661300150118127773557;
        weights[64] = 0.0278967739004440082510991866251479196559769033144493288;
        weights[65] = 0.0275742916451136106577063132160184593128140071413832773;
        weights[66] = 0.027227360052316889834603232162543078678637554071651;
        weights[67] = 0.0268562867364208315456871474274390249805070541466539568;
        weights[68] = 0.0264614007175734018414893301077792254941452640643528098;
        weights[69] = 0.0260430521299715188507565822214185064216425885204501669;
        weights[70] = 0.0256016119114079786881145686664949948986715399495152567;
        weights[71] = 0.0251374714743726537732879968149733500781935394072346514;
        weights[72] = 0.0246510423589996523616459010155759047042839795908213254;
        weights[73] = 0.0241427558681682453582335426860791487043675788063192942;
        weights[74] = 0.0236130626850812184050671451735832500751258355624587016;
        weights[75] = 0.0230624324736598828815071414270084926818536161954712563;
        weights[76] = 0.0224913534621102696360903684621200507739766659754496225;
        weights[77] = 0.0219003320100300272502847240839806884128528875734016731;
        weights[78] = 0.021289892159440249383007171400312440462362633462840269;
        weights[79] = 0.0206605751701408658399829467497983581169693846514812403;
        weights[80] = 0.0200129390398023607865161243453011196972581180222407792;
        weights[81] = 0.0193475580092204542395380882784575615363384469529056707;
        weights[82] = 0.0186650220531740475479812591554664509134079461473380881;
        weights[83] = 0.0179659363573402755271271488685537806683166630825196311;
        weights[84] = 0.0172509207817340766231121141285993154896859310213959382;
        weights[85] = 0.0165206093111535481750106302822941558319697234508410779;
        weights[86] = 0.0157756494931269539366979422881842350594182699029884645;
        weights[87] = 0.0150167018638734129409901572335256355976352944568896344;
        weights[88] = 0.0142444393628085159147502820653810990115772086650773699;
        weights[89] = 0.0134595467361511900277577922543156728516027356018462159;
        weights[90] = 0.0126627199302244886857160068605970074703507089515134399;
        weights[91] = 0.0118546654751014965170665866229843245407409522976206721;
        weights[92] = 0.0110360998593509118825208168278870941098628745717094733;
        weights[93] = 0.0102077488968346892314711169570037431809754246643542681;
        weights[94] = 0.0093703470869164893322208657773355920395596421161997048;
        weights[95] = 0.0085246369703332916749596002103462007622576489012354594;
        weights[96] = 0.00767136848509315023924137559479424118856459569601656105;
        weights[97] = 0.00681129833216419331311603935033457936039226350729709583;
        weights[98] = 0.0059451893759213917432373877462646174830237465016585676;
        weights[99] = 0.00507381015236053977620613143816500546727857379322857275;
        weights[100] = 0.00419793473404644477482766544850387232458639833995091842;
        weights[101] = 0.00331834398443293714112808927184850487518965494931062834;
        weights[102] = 0.00243583383453167402867630389070618320530501283409145797;
        weights[103] = 0.00155127781202870953346701316462836596962978183198773461;
        weights[104] = 0.000666657371329679146748510800318679296006970930009334895;
        return;
    case 106:
        points[0] = -0.999745072725757546707659659754832748548377969215208141;
        points[1] = -0.998657047000421422869261089780696537610845530645758121;
        points[2] = -0.996700598969393002704593666220368995908150170141118128;
        points[3] = -0.99387699594931061243469105684193383708587510985752239;
        points[4] = -0.990188641454026682414764531594875654348886655244327247;
        points[5] = -0.985638731983841774389809096535512713399995845106019589;
        points[6] = -0.980231222167392157734507808648590715068161915070198287;
        points[7] = -0.973970815341230469497425334259304011848831567401209497;
        points[8] = -0.966862957867899415836995239006367705885666632923224787;
        points[9] = -0.958913833868248448754981625367902362247720264490935437;
        points[10] = -0.950130359634884006869243763204907204503670874775137587;
        points[11] = -0.940520177524377016926890209370948642029181959542625469;
        points[12] = -0.930091649264636846651304918659040551468880509485724452;
        points[13] = -0.918853848657262557852609606665914971149340162344723585;
        points[14] = -0.906816553670372741364813275931844737613985070972967399;
        points[15] = -0.893990237923890523223821307139859701360850781416994331;
        points[16] = -0.88038606157232362811769978170815110013067745006640429;
        points[17] = -0.866015861591762199685411346428523077620262421435502607;
        points[18] = -0.850892141478897099037201864094243547561021351256814183;
        points[19] = -0.83502806037065932020838128136418823370764185302662667;
        points[20] = -0.81843742159373775408330811992162005984912856785465704;
        points[21] = -0.801134660653812959384863036438973190879504740782582616;
        points[22] = -0.783134832674880384933630498488267870813354384250378176;
        points[23] = -0.764453599299543440970046980530896325637882281096591643;
        points[24] = -0.745107215061643081511541983901382068688214169496362087;
        points[25] = -0.725112513243060391337516200500437945207773165920607664;
        points[26] = -0.704486891226984290410711252163211632868505290329495921;
        points[27] = -0.683248295360378996178162885125999004778302920067585076;
        points[28] = -0.661415205338815832641566130462415772763909953707857049;
        points[29] = -0.63900661812725151310923749707418421516908141801764984;
        points[30] = -0.616042031430740123043073974715484673227232991711076662;
        points[31] = -0.592541426729458548851875699742195211239729512154100112;
        points[32] = -0.568525251892804831403585800262543058278328119385899221;
        points[33] = -0.544014403387695626941053755101837272156242707801297448;
        points[34] = -0.519030208096542372004678347142246543783514863583032306;
        points[35] = -0.493594404760725604304425286288100250327603686738989567;
        points[36] = -0.467729125065712918956264685526324095057065207327405525;
        points[37] = -0.441456874384277973585376333069235776387254798304368534;
        points[38] = -0.414800512194575537709874330297313819502228839872972855;
        points[39] = -0.387783232190110561499100096471843726860520656373495012;
        points[40] = -0.360428542098907376526582038662224809905004623433290414;
        points[41] = -0.332760243229438207716645548515085289027885201421082559;
        points[42] = -0.304802409761107954386294788645444530067970666129339088;
        points[43] = -0.2765793677973144845997054060854630090517266500592514;
        points[44] = -0.248115674199310289320046163032269253311453860859101644;
        points[45] = -0.219436095219282082593478779429876204014162450157268721;
        points[46] = -0.190565584951239646236224314410283008498518251253937987;
        points[47] = -0.161529263618463750924538646828145748355915662136259362;
        points[48] = -0.132352395716405202814920391066613002809144360020593944;
        points[49] = -0.103060368030052842517095646632547391206839875527693927;
        points[50] = -0.0736786675448975522783274394889836748864488250352069695;
        points[51] = -0.0442328592707119128101346748361077743780757686330129235;
        points[52] = -0.0147485639974410129159409695234463944327095559613199442;
        points[53] = 0.0147485639974410129159409695234463944327095559613199442;
        points[54] = 0.0442328592707119128101346748361077743780757686330129235;
        points[55] = 0.0736786675448975522783274394889836748864488250352069695;
        points[56] = 0.103060368030052842517095646632547391206839875527693927;
        points[57] = 0.132352395716405202814920391066613002809144360020593944;
        points[58] = 0.161529263618463750924538646828145748355915662136259362;
        points[59] = 0.190565584951239646236224314410283008498518251253937987;
        points[60] = 0.219436095219282082593478779429876204014162450157268721;
        points[61] = 0.248115674199310289320046163032269253311453860859101644;
        points[62] = 0.2765793677973144845997054060854630090517266500592514;
        points[63] = 0.304802409761107954386294788645444530067970666129339088;
        points[64] = 0.332760243229438207716645548515085289027885201421082559;
        points[65] = 0.360428542098907376526582038662224809905004623433290414;
        points[66] = 0.387783232190110561499100096471843726860520656373495012;
        points[67] = 0.414800512194575537709874330297313819502228839872972855;
        points[68] = 0.441456874384277973585376333069235776387254798304368534;
        points[69] = 0.467729125065712918956264685526324095057065207327405525;
        points[70] = 0.493594404760725604304425286288100250327603686738989567;
        points[71] = 0.519030208096542372004678347142246543783514863583032306;
        points[72] = 0.544014403387695626941053755101837272156242707801297448;
        points[73] = 0.568525251892804831403585800262543058278328119385899221;
        points[74] = 0.592541426729458548851875699742195211239729512154100112;
        points[75] = 0.616042031430740123043073974715484673227232991711076662;
        points[76] = 0.63900661812725151310923749707418421516908141801764984;
        points[77] = 0.661415205338815832641566130462415772763909953707857049;
        points[78] = 0.683248295360378996178162885125999004778302920067585076;
        points[79] = 0.704486891226984290410711252163211632868505290329495921;
        points[80] = 0.725112513243060391337516200500437945207773165920607664;
        points[81] = 0.745107215061643081511541983901382068688214169496362087;
        points[82] = 0.764453599299543440970046980530896325637882281096591643;
        points[83] = 0.783134832674880384933630498488267870813354384250378176;
        points[84] = 0.801134660653812959384863036438973190879504740782582616;
        points[85] = 0.81843742159373775408330811992162005984912856785465704;
        points[86] = 0.83502806037065932020838128136418823370764185302662667;
        points[87] = 0.850892141478897099037201864094243547561021351256814183;
        points[88] = 0.866015861591762199685411346428523077620262421435502607;
        points[89] = 0.88038606157232362811769978170815110013067745006640429;
        points[90] = 0.893990237923890523223821307139859701360850781416994331;
        points[91] = 0.906816553670372741364813275931844737613985070972967399;
        points[92] = 0.918853848657262557852609606665914971149340162344723585;
        points[93] = 0.930091649264636846651304918659040551468880509485724452;
        points[94] = 0.940520177524377016926890209370948642029181959542625469;
        points[95] = 0.950130359634884006869243763204907204503670874775137587;
        points[96] = 0.958913833868248448754981625367902362247720264490935437;
        points[97] = 0.966862957867899415836995239006367705885666632923224787;
        points[98] = 0.973970815341230469497425334259304011848831567401209497;
        points[99] = 0.980231222167392157734507808648590715068161915070198287;
        points[100] = 0.985638731983841774389809096535512713399995845106019589;
        points[101] = 0.990188641454026682414764531594875654348886655244327247;
        points[102] = 0.99387699594931061243469105684193383708587510985752239;
        points[103] = 0.996700598969393002704593666220368995908150170141118128;
        points[104] = 0.998657047000421422869261089780696537610845530645758121;
        points[105] = 0.999745072725757546707659659754832748548377969215208141;
        weights[0] = 0.000654197911024732930569490759967884281111555052812183788;
        weights[1] = 0.00152229580231423211191533811590755011106572501842509606;
        weights[2] = 0.00239035569114186568251893042231364528269758685374225243;
        weights[3] = 0.00325644751371521518752143779993592853493447146422620063;
        weights[4] = 0.00411972835473820750684679138220941111139537726929888582;
        weights[5] = 0.0049794313504809830513456334746184190371588264880435538;
        weights[6] = 0.0058348043034015616520647093069230385893207155208920547;
        weights[7] = 0.00668510153531001409815267883261698699728551841250530245;
        weights[8] = 0.00752958263181271462762164181716646353025946728025531942;
        weights[9] = 0.00836751255038196411571063661897944179181388296694183873;
        weights[10] = 0.0091981620787474900222824035832840368371897231338081849;
        weights[11] = 0.010020808399328509191377365799139571321110664717752641;
        weights[12] = 0.0108347356880933021353885388555037837333332412672171338;
        weights[13] = 0.0116392357233777857955249676746169895159130764310913937;
        weights[14] = 0.0124336084951114423541533128554270695839412049786919691;
        weights[15] = 0.0132171628101996580296679353632381730666817680690958191;
        weights[16] = 0.0139892168918822175045873377085365946121562962978813122;
        weights[17] = 0.0147490989717640836595380026410302497278607684818169811;
        weights[18] = 0.0154961478736128083344925234281775805973068599851452136;
        weights[19] = 0.0162297135882104540758056271152312670666306446049352684;
        weights[20] = 0.0169491578386487250957126491763600159583148991751492708;
        weights[21] = 0.0176538546355127708203339538035140839041565254060306091;
        weights[22] = 0.0183431908214341150542813084147708282819368678523493364;
        weights[23] = 0.0190165666045170515637704765555783943345081525317773492;
        weights[24] = 0.019673396080160956089424783067281539965820397551547848;
        weights[25] = 0.0203131077408160461325427822373049662922028192313051257;
        weights[26] = 0.0209351449732236396388040659016057601251527515688971243;
        weights[27] = 0.0215389665427047249641837672404170520457746311369184915;
        weights[28] = 0.0221240470640731070433885169120479532163348702848369637;
        weights[29] = 0.02268987745876179480572140624074786797109565126421729;
        weights[30] = 0.0232359653977637901563544828249526582241222154948146522;
        weights[31] = 0.0237618357300011142005550365259531112139074569473353974;
        weights[32] = 0.0242670308957488098882855353873375100509378756400319022;
        weights[33] = 0.024751111324753817750479581104193259115655142786183694;
        weights[34] = 0.0252136558187020450940752123914000991545816931361609106;
        weights[35] = 0.0256542619177006425639935892783653758869883710229212548;
        weights[36] = 0.0260725462504564635199426027622067731089303907082584481;
        weights[37] = 0.0264681448678459057700124798079330741660372491706340065;
        weights[38] = 0.0268407135595858139949473468762577209659076460818962489;
        weights[39] = 0.0271899281537298451721328000662950825033970329914905212;
        weights[40] = 0.0275154847987296577823434682501088545870899111033198703;
        weights[41] = 0.0278171002278154670223986743164020190193915006735919691;
        weights[42] = 0.0280945120054659004875118404519709282018039275798007332;
        weights[43] = 0.0283474787557526791773481369140513950958255921379431867;
        weights[44] = 0.0285757803723614241864586279802154351095323132787763041;
        weights[45] = 0.0287792182101058367214724377142688331958524204537890207;
        weights[46] = 0.0289576152577686045493150605357695694160576380894438591;
        weights[47] = 0.0291108162921186378160794062685636012446699927662862206;
        weights[48] = 0.0292386880129706173994216108114791150780758246150035464;
        weights[49] = 0.029341119159169335430969600432113421211389601481315618;
        weights[50] = 0.0294180206053979060826189091786591129183738999815066963;
        weights[51] = 0.0294693254397256107760800296903708334072419931647737844;
        weights[52] = 0.0294949890218279011819545173266796696997653703971141418;
        weights[53] = 0.0294949890218279011819545173266796696997653703971141418;
        weights[54] = 0.0294693254397256107760800296903708334072419931647737844;
        weights[55] = 0.0294180206053979060826189091786591129183738999815066963;
        weights[56] = 0.029341119159169335430969600432113421211389601481315618;
        weights[57] = 0.0292386880129706173994216108114791150780758246150035464;
        weights[58] = 0.0291108162921186378160794062685636012446699927662862206;
        weights[59] = 0.0289576152577686045493150605357695694160576380894438591;
        weights[60] = 0.0287792182101058367214724377142688331958524204537890207;
        weights[61] = 0.0285757803723614241864586279802154351095323132787763041;
        weights[62] = 0.0283474787557526791773481369140513950958255921379431867;
        weights[63] = 0.0280945120054659004875118404519709282018039275798007332;
        weights[64] = 0.0278171002278154670223986743164020190193915006735919691;
        weights[65] = 0.0275154847987296577823434682501088545870899111033198703;
        weights[66] = 0.0271899281537298451721328000662950825033970329914905212;
        weights[67] = 0.0268407135595858139949473468762577209659076460818962489;
        weights[68] = 0.0264681448678459057700124798079330741660372491706340065;
        weights[69] = 0.0260725462504564635199426027622067731089303907082584481;
        weights[70] = 0.0256542619177006425639935892783653758869883710229212548;
        weights[71] = 0.0252136558187020450940752123914000991545816931361609106;
        weights[72] = 0.024751111324753817750479581104193259115655142786183694;
        weights[73] = 0.0242670308957488098882855353873375100509378756400319022;
        weights[74] = 0.0237618357300011142005550365259531112139074569473353974;
        weights[75] = 0.0232359653977637901563544828249526582241222154948146522;
        weights[76] = 0.02268987745876179480572140624074786797109565126421729;
        weights[77] = 0.0221240470640731070433885169120479532163348702848369637;
        weights[78] = 0.0215389665427047249641837672404170520457746311369184915;
        weights[79] = 0.0209351449732236396388040659016057601251527515688971243;
        weights[80] = 0.0203131077408160461325427822373049662922028192313051257;
        weights[81] = 0.019673396080160956089424783067281539965820397551547848;
        weights[82] = 0.0190165666045170515637704765555783943345081525317773492;
        weights[83] = 0.0183431908214341150542813084147708282819368678523493364;
        weights[84] = 0.0176538546355127708203339538035140839041565254060306091;
        weights[85] = 0.0169491578386487250957126491763600159583148991751492708;
        weights[86] = 0.0162297135882104540758056271152312670666306446049352684;
        weights[87] = 0.0154961478736128083344925234281775805973068599851452136;
        weights[88] = 0.0147490989717640836595380026410302497278607684818169811;
        weights[89] = 0.0139892168918822175045873377085365946121562962978813122;
        weights[90] = 0.0132171628101996580296679353632381730666817680690958191;
        weights[91] = 0.0124336084951114423541533128554270695839412049786919691;
        weights[92] = 0.0116392357233777857955249676746169895159130764310913937;
        weights[93] = 0.0108347356880933021353885388555037837333332412672171338;
        weights[94] = 0.010020808399328509191377365799139571321110664717752641;
        weights[95] = 0.0091981620787474900222824035832840368371897231338081849;
        weights[96] = 0.00836751255038196411571063661897944179181388296694183873;
        weights[97] = 0.00752958263181271462762164181716646353025946728025531942;
        weights[98] = 0.00668510153531001409815267883261698699728551841250530245;
        weights[99] = 0.0058348043034015616520647093069230385893207155208920547;
        weights[100] = 0.0049794313504809830513456334746184190371588264880435538;
        weights[101] = 0.00411972835473820750684679138220941111139537726929888582;
        weights[102] = 0.00325644751371521518752143779993592853493447146422620063;
        weights[103] = 0.00239035569114186568251893042231364528269758685374225243;
        weights[104] = 0.00152229580231423211191533811590755011106572501842509606;
        weights[105] = 0.000654197911024732930569490759967884281111555052812183788;
        return;
    case 107:
        points[0] = -0.999749793268164977652399475427399211440774566440964165;
        points[1] = -0.998681910318344368116355194146628209095507590512475352;
        points[2] = -0.996761664228031467389798770805049691192650427769505078;
        points[3] = -0.993990267933654565897274880492864397522977456776720517;
        points[4] = -0.990370035860437707290574020079229404112209296948600614;
        points[5] = -0.985904047144265362136758572575914584327917992916054488;
        points[6] = -0.980596111519516400527643693220490234261853565071399362;
        points[7] = -0.974450760196896832322565218940370104218716937331673839;
        points[8] = -0.967473240433748439814427729005652227926243285796717009;
        points[9] = -0.959669510533953464467243574340029304317376531295828277;
        points[10] = -0.951046234557681985113404197346524167399681036184797867;
        points[11] = -0.941610776542103651402284642793186481550096348812701979;
        points[12] = -0.931371194170371473137446926652483422193194929979437415;
        points[13] = -0.920336231868754270665521588339378996834081835649802752;
        points[14] = -0.908515313327165600671202535706765411950768667877029058;
        points[15] = -0.895918533444664096083609947588974922198880842446157334;
        points[16] = -0.882556649704478878381720538582405522540763089342013374;
        points[17] = -0.868441072984737954479738591668262932487177313091239346;
        points[18] = -0.853583857812110619772782956368451329028926470950444825;
        points[19] = -0.837997692066331633597139715021835182256892817828271171;
        points[20] = -0.821695886144193516829970781874377156777590045599502444;
        points[21] = -0.804692361592137725764454711168109313173332502038685278;
        points[22] = -0.787001639217076651706670176630589781213152767108843079;
        points[23] = -0.768638826685551927387238638394150295359766148906334118;
        points[24] = -0.749619605621788409175268374991826113644368951153318533;
        points[25] = -0.729960218215641653621866575517774443708212819639673339;
        points[26] = -0.709677453351861923714469810537018426440548039273150249;
        points[27] = -0.688788632272510870314904855635025612727847707334879582;
        points[28] = -0.667311593784768565539979903921914312020557086393481323;
        points[29] = -0.645264679026758707183591858459999472932320756990704958;
        points[30] = -0.622666715804398562461645811635666605584095802333596745;
        points[31] = -0.599537002512647458946021008453133367861268323545023457;
        points[32] = -0.575895291654883179484840262400287709968994401193848411;
        points[33] = -0.551761772974479258823928728811437127353989316291436555;
        points[34] = -0.527157056212987676085384120819000637996953937586840757;
        points[35] = -0.502102153509650544322868328182357299728012424768159053;
        points[36] = -0.476618461457270869474084912038384929614955887588902115;
        points[37] = -0.450727742829766042265146699561273971825560058825633362;
        points[38] = -0.424452107997008199653224106479027066802735220657602609;
        points[39] = -0.397813996042822716407505577353910933391505457217289711;
        points[40] = -0.370836155602269640483245972928890861515346975260146393;
        points[41] = -0.343541625434572655837548653143780197068938622943634032;
        points[42] = -0.315953714748285941711124794004408112290549586610093601;
        points[43] = -0.288095983295500907675927422028094544504112585135006231;
        points[44] = -0.259992221252092039929186578844200358401809437866225056;
        points[45] = -0.231666428901183829217563258248741729546510837678295563;
        points[46] = -0.203142796137188809295895776660016979889354618638546074;
        points[47] = -0.174445681807919974154819466357231393765953274182004815;
        points[48] = -0.145599592912419132062302334606870024272648879821589047;
        points[49] = -0.116629163672265977064132344231477494429414131933151534;
        points[50] = -0.0875591344942407090551452443161260474601810894074600507;
        points[51] = -0.0584143308423058198264518641483220014136934470941064752;
        points[52] = -0.0292196420369501055523021059877019529246371971809667805;
        points[53] = 0;
        points[54] = 0.0292196420369501055523021059877019529246371971809667805;
        points[55] = 0.0584143308423058198264518641483220014136934470941064752;
        points[56] = 0.0875591344942407090551452443161260474601810894074600507;
        points[57] = 0.116629163672265977064132344231477494429414131933151534;
        points[58] = 0.145599592912419132062302334606870024272648879821589047;
        points[59] = 0.174445681807919974154819466357231393765953274182004815;
        points[60] = 0.203142796137188809295895776660016979889354618638546074;
        points[61] = 0.231666428901183829217563258248741729546510837678295563;
        points[62] = 0.259992221252092039929186578844200358401809437866225056;
        points[63] = 0.288095983295500907675927422028094544504112585135006231;
        points[64] = 0.315953714748285941711124794004408112290549586610093601;
        points[65] = 0.343541625434572655837548653143780197068938622943634032;
        points[66] = 0.370836155602269640483245972928890861515346975260146393;
        points[67] = 0.397813996042822716407505577353910933391505457217289711;
        points[68] = 0.424452107997008199653224106479027066802735220657602609;
        points[69] = 0.450727742829766042265146699561273971825560058825633362;
        points[70] = 0.476618461457270869474084912038384929614955887588902115;
        points[71] = 0.502102153509650544322868328182357299728012424768159053;
        points[72] = 0.527157056212987676085384120819000637996953937586840757;
        points[73] = 0.551761772974479258823928728811437127353989316291436555;
        points[74] = 0.575895291654883179484840262400287709968994401193848411;
        points[75] = 0.599537002512647458946021008453133367861268323545023457;
        points[76] = 0.622666715804398562461645811635666605584095802333596745;
        points[77] = 0.645264679026758707183591858459999472932320756990704958;
        points[78] = 0.667311593784768565539979903921914312020557086393481323;
        points[79] = 0.688788632272510870314904855635025612727847707334879582;
        points[80] = 0.709677453351861923714469810537018426440548039273150249;
        points[81] = 0.729960218215641653621866575517774443708212819639673339;
        points[82] = 0.749619605621788409175268374991826113644368951153318533;
        points[83] = 0.768638826685551927387238638394150295359766148906334118;
        points[84] = 0.787001639217076651706670176630589781213152767108843079;
        points[85] = 0.804692361592137725764454711168109313173332502038685278;
        points[86] = 0.821695886144193516829970781874377156777590045599502444;
        points[87] = 0.837997692066331633597139715021835182256892817828271171;
        points[88] = 0.853583857812110619772782956368451329028926470950444825;
        points[89] = 0.868441072984737954479738591668262932487177313091239346;
        points[90] = 0.882556649704478878381720538582405522540763089342013374;
        points[91] = 0.895918533444664096083609947588974922198880842446157334;
        points[92] = 0.908515313327165600671202535706765411950768667877029058;
        points[93] = 0.920336231868754270665521588339378996834081835649802752;
        points[94] = 0.931371194170371473137446926652483422193194929979437415;
        points[95] = 0.941610776542103651402284642793186481550096348812701979;
        points[96] = 0.951046234557681985113404197346524167399681036184797867;
        points[97] = 0.959669510533953464467243574340029304317376531295828277;
        points[98] = 0.967473240433748439814427729005652227926243285796717009;
        points[99] = 0.974450760196896832322565218940370104218716937331673839;
        points[100] = 0.980596111519516400527643693220490234261853565071399362;
        points[101] = 0.985904047144265362136758572575914584327917992916054488;
        points[102] = 0.990370035860437707290574020079229404112209296948600614;
        points[103] = 0.993990267933654565897274880492864397522977456776720517;
        points[104] = 0.996761664228031467389798770805049691192650427769505078;
        points[105] = 0.998681910318344368116355194146628209095507590512475352;
        points[106] = 0.999749793268164977652399475427399211440774566440964165;
        weights[0] = 0.000642084494792885286653827879589106806021622711576866196;
        weights[1] = 0.00149411834314087156650234682681582438128185449773331325;
        weights[2] = 0.00234613895071169191444337792153744110292785218405235265;
        weights[3] = 0.00319626569378184336636120429019025477922113774629436304;
        weights[4] = 0.00404368489983760955717341160375794153254341171019000392;
        weights[5] = 0.00488765745087747171820009365103143572987124850025434971;
        weights[6] = 0.00572745851135465170001446638335800505000144608002218324;
        weights[7] = 0.00656236950890958124308464500097533229403984180666428373;
        weights[8] = 0.00739167687894090682859698327499654295822592163413707282;
        weights[9] = 0.00821467214775462632016774904909837369182859667203571568;
        weights[10] = 0.00903065235978261529410475406845403301349939650623657689;
        weights[11] = 0.00983892060914247665427828383098023747875847931136078778;
        weights[12] = 0.0106387866052810200604606293829702184087247696278814896;
        weights[13] = 0.0114295672487148231299223206604400791268666789634419628;
        weights[14] = 0.0122105872075215845918807438350446074568502091211460181;
        weights[15] = 0.0129811794904381097115853714417851978939916952955806906;
        weights[16] = 0.0137406860144526768837145586461308360794937790272096357;
        weights[17] = 0.014488458165639220258759828356121330020087167262930477;
        weights[18] = 0.0152238573523711048526705781003640600457518605454194468;
        weights[19] = 0.0159462555502416898853382643845049201417956804584161719;
        weights[20] = 0.0166550358381172660476219941665083873981831061972069411;
        weights[21] = 0.0173495929248030752913632426394057623696692972842390206;
        weights[22] = 0.0180293336658368432784677945484861316189407642282431503;
        weights[23] = 0.018693677569947051440711344836655730571541925841390527;
        weights[24] = 0.0193420572947302731250239040628000523201628090857809258;
        weights[25] = 0.0199739191311159970093395073000364179677104589679039743;
        weights[26] = 0.0205887234761999008021034115452888916353950381692312026;
        weights[27] = 0.0211859452940383081353205683640432597261248012740334193;
        weights[28] = 0.0217650745640080038082728658486662355617731030022918395;
        weights[29] = 0.0223256167163469495485536971894535992226127334921929822;
        weights[30] = 0.022867093054502879925933838827940638190378546189736624;
        weights[31] = 0.0233890411639283502433331260140279755371652062991378887;
        weights[32] = 0.0238910153069726032215029340501461413515206625665013579;
        weights[33] = 0.0243725868035326454079424453419491369723527802956533015;
        weights[34] = 0.0248333443971381904233324229156195031117309020036947919;
        weights[35] = 0.0252728946061576389731217254019934945875228093122659221;
        weights[36] = 0.0256908620598250241924082610526535534640742558111513397;
        weights[37] = 0.0260868898188008510419269466312964026399166965726244473;
        weights[38] = 0.0264606396799929934653003390247025472315387067882080472;
        weights[39] = 0.0268117924653772745760252295740737939048716914931473904;
        weights[40] = 0.0271400482945710338581313682845587718265372473082098902;
        weights[41] = 0.0274451268409268710104632248469657330930656269858352894;
        weights[42] = 0.0277267675709278378071493881368717599008938951057979634;
        weights[43] = 0.0279847299666796158882810413263292536619042148193703562;
        weights[44] = 0.0282187937313096580736318673912705928212339657133780356;
        weights[45] = 0.0284287589770978716546641966104795487924735811279160134;
        weights[46] = 0.028614446396178171972532410416455607399001772900869117;
        weights[47] = 0.0287756974136651210386954719414680102767282126522535079;
        weights[48] = 0.0289123743230748764374972179686388031191667563874362125;
        weights[49] = 0.0290243604039247975603290680375996321176769239027621983;
        weights[50] = 0.0291115600214112765298542213177029485747560573351497651;
        weights[51] = 0.0291738987080806670471741274886243273900270359981558001;
        weights[52] = 0.0292113232274235628139737076835396769493259034891400087;
        weights[53] = 0.0292238016193381150522073012512038014044797234730139742;
        weights[54] = 0.0292113232274235628139737076835396769493259034891400087;
        weights[55] = 0.0291738987080806670471741274886243273900270359981558001;
        weights[56] = 0.0291115600214112765298542213177029485747560573351497651;
        weights[57] = 0.0290243604039247975603290680375996321176769239027621983;
        weights[58] = 0.0289123743230748764374972179686388031191667563874362125;
        weights[59] = 0.0287756974136651210386954719414680102767282126522535079;
        weights[60] = 0.028614446396178171972532410416455607399001772900869117;
        weights[61] = 0.0284287589770978716546641966104795487924735811279160134;
        weights[62] = 0.0282187937313096580736318673912705928212339657133780356;
        weights[63] = 0.0279847299666796158882810413263292536619042148193703562;
        weights[64] = 0.0277267675709278378071493881368717599008938951057979634;
        weights[65] = 0.0274451268409268710104632248469657330930656269858352894;
        weights[66] = 0.0271400482945710338581313682845587718265372473082098902;
        weights[67] = 0.0268117924653772745760252295740737939048716914931473904;
        weights[68] = 0.0264606396799929934653003390247025472315387067882080472;
        weights[69] = 0.0260868898188008510419269466312964026399166965726244473;
        weights[70] = 0.0256908620598250241924082610526535534640742558111513397;
        weights[71] = 0.0252728946061576389731217254019934945875228093122659221;
        weights[72] = 0.0248333443971381904233324229156195031117309020036947919;
        weights[73] = 0.0243725868035326454079424453419491369723527802956533015;
        weights[74] = 0.0238910153069726032215029340501461413515206625665013579;
        weights[75] = 0.0233890411639283502433331260140279755371652062991378887;
        weights[76] = 0.022867093054502879925933838827940638190378546189736624;
        weights[77] = 0.0223256167163469495485536971894535992226127334921929822;
        weights[78] = 0.0217650745640080038082728658486662355617731030022918395;
        weights[79] = 0.0211859452940383081353205683640432597261248012740334193;
        weights[80] = 0.0205887234761999008021034115452888916353950381692312026;
        weights[81] = 0.0199739191311159970093395073000364179677104589679039743;
        weights[82] = 0.0193420572947302731250239040628000523201628090857809258;
        weights[83] = 0.018693677569947051440711344836655730571541925841390527;
        weights[84] = 0.0180293336658368432784677945484861316189407642282431503;
        weights[85] = 0.0173495929248030752913632426394057623696692972842390206;
        weights[86] = 0.0166550358381172660476219941665083873981831061972069411;
        weights[87] = 0.0159462555502416898853382643845049201417956804584161719;
        weights[88] = 0.0152238573523711048526705781003640600457518605454194468;
        weights[89] = 0.014488458165639220258759828356121330020087167262930477;
        weights[90] = 0.0137406860144526768837145586461308360794937790272096357;
        weights[91] = 0.0129811794904381097115853714417851978939916952955806906;
        weights[92] = 0.0122105872075215845918807438350446074568502091211460181;
        weights[93] = 0.0114295672487148231299223206604400791268666789634419628;
        weights[94] = 0.0106387866052810200604606293829702184087247696278814896;
        weights[95] = 0.00983892060914247665427828383098023747875847931136078778;
        weights[96] = 0.00903065235978261529410475406845403301349939650623657689;
        weights[97] = 0.00821467214775462632016774904909837369182859667203571568;
        weights[98] = 0.00739167687894090682859698327499654295822592163413707282;
        weights[99] = 0.00656236950890958124308464500097533229403984180666428373;
        weights[100] = 0.00572745851135465170001446638335800505000144608002218324;
        weights[101] = 0.00488765745087747171820009365103143572987124850025434971;
        weights[102] = 0.00404368489983760955717341160375794153254341171019000392;
        weights[103] = 0.00319626569378184336636120429019025477922113774629436304;
        weights[104] = 0.00234613895071169191444337792153744110292785218405235265;
        weights[105] = 0.00149411834314087156650234682681582438128185449773331325;
        weights[106] = 0.000642084494792885286653827879589106806021622711576866196;
        return;
    case 108:
        points[0] = -0.999754383899439767571526368922549896880606364160632165;
        points[1] = -0.998706089548479825415612043180378026871710412966204866;
        points[2] = -0.99682105004922036102380458894783744053656342627904866;
        points[3] = -0.994100426572366085639974340092973001832002827427910183;
        points[4] = -0.990546448517270881729994300566077198300426513121094949;
        points[5] = -0.986162082985255844436706819849945619161083932398679464;
        points[6] = -0.980951001387464542237033257328203662164656172953282727;
        points[7] = -0.974917570606093407558546509233127114185190360976937269;
        points[8] = -0.968066847802107571184125259344389321061957255817088801;
        points[9] = -0.960404575666256925952678149479751828303118218234131221;
        points[10] = -0.951937177406643110178407494758939165835738287298027912;
        points[11] = -0.94267175127737845886751708569778125667792367890858;
        points[12] = -0.932616064586538157794241192641232387565396110474137066;
        points[13] = -0.921778547163367939821017321736562089341888188929132284;
        points[14] = -0.910168284279772437064676846582425472977940427532410577;
        points[15] = -0.897795009027294290268972694618850478443079072226704734;
        points[16] = -0.88466909415369251873021525512057605611639758336824623;
        points[17] = -0.870801543364797852125589228772863026392148891178282889;
        points[18] = -0.856203982098312063459340912011391962040811348320636577;
        points[19] = -0.840888647776936852232148505169689108382536885171144455;
        points[20] = -0.824868379548801204243438622463979864885899103564691222;
        points[21] = -0.808156607523667234519113254892309460115490435747366109;
        points[22] = -0.79076734151386373108044858359669964620362156016253851;
        points[23] = -0.772715159289339245916205003345871780354326757849822256;
        points[24] = -0.754015194356650523822417336306105452494948926802034274;
        points[25] = -0.7346831232721114728084892362648635508550020161980381;
        points[26] = -0.714735152499724950912027247022904195354757375406930485;
        points[27] = -0.694188004824905502274766235433493124521150230664439924;
        points[28] = -0.673058905335376361256415396619949381135723582492781669;
        points[29] = -0.651365566980988765620360710234496264486424532784177855;
        points[30] = -0.629126175724565895560414080031320296145333043022767875;
        points[31] = -0.606359375296217490744390988365826999558902497233304899;
        points[32] = -0.583084251563904234583632582429295996225945777641011329;
        points[33] = -0.559320316533353139088548526473285534158180212315117196;
        points[34] = -0.535087491990736200828361785713225373231399377371878273;
        points[35] = -0.510406092801824305417483343012564311874826435559881598;
        points[36] = -0.485296809881616508800009928891146389124128682009234572;
        points[37] = -0.459780692848721194324574319573565679018132697158852487;
        points[38] = -0.433879132379029975665505658674285272608154832694642317;
        points[39] = -0.407613842273477373969588885988224147835596358728259596;
        points[40] = -0.381006841254919037866908283515284836234005753015188097;
        points[41] = -0.35408043450938840054775081475673949007002960971115097;
        points[42] = -0.326857194987205991715662817718049562979872277066374892;
        points[43] = -0.299359944479616966501109576358011097000575571105016363;
        points[44] = -0.271611734486820611255990548450079623626579093695045799;
        points[45] = -0.243635826893430481025439876537945237837979143211459282;
        points[46] = -0.215455674467565269723489892868260357783211468663471132;
        points[47] = -0.187094901199918376978730353271436603885669347558036022;
        points[48] = -0.15857728249928829183606995358748637514334071757441191;
        points[49] = -0.12992672526117225093503430971339668855017474292833459;
        points[50] = -0.101167247826132046856348106700420654311358704666122332;
        points[51] = -0.0723229598447332720556994319281183754057237703711268904;
        points[52] = -0.0434180420659376078932127608256103844992109052892413086;
        points[53] = -0.0144767260658919411909197928303990435774459346213745591;
        points[54] = 0.0144767260658919411909197928303990435774459346213745591;
        points[55] = 0.0434180420659376078932127608256103844992109052892413086;
        points[56] = 0.0723229598447332720556994319281183754057237703711268904;
        points[57] = 0.101167247826132046856348106700420654311358704666122332;
        points[58] = 0.12992672526117225093503430971339668855017474292833459;
        points[59] = 0.15857728249928829183606995358748637514334071757441191;
        points[60] = 0.187094901199918376978730353271436603885669347558036022;
        points[61] = 0.215455674467565269723489892868260357783211468663471132;
        points[62] = 0.243635826893430481025439876537945237837979143211459282;
        points[63] = 0.271611734486820611255990548450079623626579093695045799;
        points[64] = 0.299359944479616966501109576358011097000575571105016363;
        points[65] = 0.326857194987205991715662817718049562979872277066374892;
        points[66] = 0.35408043450938840054775081475673949007002960971115097;
        points[67] = 0.381006841254919037866908283515284836234005753015188097;
        points[68] = 0.407613842273477373969588885988224147835596358728259596;
        points[69] = 0.433879132379029975665505658674285272608154832694642317;
        points[70] = 0.459780692848721194324574319573565679018132697158852487;
        points[71] = 0.485296809881616508800009928891146389124128682009234572;
        points[72] = 0.510406092801824305417483343012564311874826435559881598;
        points[73] = 0.535087491990736200828361785713225373231399377371878273;
        points[74] = 0.559320316533353139088548526473285534158180212315117196;
        points[75] = 0.583084251563904234583632582429295996225945777641011329;
        points[76] = 0.606359375296217490744390988365826999558902497233304899;
        points[77] = 0.629126175724565895560414080031320296145333043022767875;
        points[78] = 0.651365566980988765620360710234496264486424532784177855;
        points[79] = 0.673058905335376361256415396619949381135723582492781669;
        points[80] = 0.694188004824905502274766235433493124521150230664439924;
        points[81] = 0.714735152499724950912027247022904195354757375406930485;
        points[82] = 0.7346831232721114728084892362648635508550020161980381;
        points[83] = 0.754015194356650523822417336306105452494948926802034274;
        points[84] = 0.772715159289339245916205003345871780354326757849822256;
        points[85] = 0.79076734151386373108044858359669964620362156016253851;
        points[86] = 0.808156607523667234519113254892309460115490435747366109;
        points[87] = 0.824868379548801204243438622463979864885899103564691222;
        points[88] = 0.840888647776936852232148505169689108382536885171144455;
        points[89] = 0.856203982098312063459340912011391962040811348320636577;
        points[90] = 0.870801543364797852125589228772863026392148891178282889;
        points[91] = 0.88466909415369251873021525512057605611639758336824623;
        points[92] = 0.897795009027294290268972694618850478443079072226704734;
        points[93] = 0.910168284279772437064676846582425472977940427532410577;
        points[94] = 0.921778547163367939821017321736562089341888188929132284;
        points[95] = 0.932616064586538157794241192641232387565396110474137066;
        points[96] = 0.94267175127737845886751708569778125667792367890858;
        points[97] = 0.951937177406643110178407494758939165835738287298027912;
        points[98] = 0.960404575666256925952678149479751828303118218234131221;
        points[99] = 0.968066847802107571184125259344389321061957255817088801;
        points[100] = 0.974917570606093407558546509233127114185190360976937269;
        points[101] = 0.980951001387464542237033257328203662164656172953282727;
        points[102] = 0.986162082985255844436706819849945619161083932398679464;
        points[103] = 0.990546448517270881729994300566077198300426513121094949;
        points[104] = 0.994100426572366085639974340092973001832002827427910183;
        points[105] = 0.99682105004922036102380458894783744053656342627904866;
        points[106] = 0.998706089548479825415612043180378026871710412966204866;
        points[107] = 0.999754383899439767571526368922549896880606364160632165;
        weights[0] = 0.000630304426123453985773409113570013682119309055943184965;
        weights[1] = 0.00146671593257232249710538248447612734300309683022880133;
        weights[2] = 0.0023031374081837722563928744717590069844215231560763084;
        weights[3] = 0.00313773581393474619654864824564236387890245767591044399;
        weights[4] = 0.00396972542410714363151711289312266454219450056790009587;
        weights[5] = 0.0047983936164099499007110031594306965471281374825690408;
        weights[6] = 0.00562304168385699836995984690176188210418524107601798495;
        weights[7] = 0.00644297694080253960177493742674122693932723379121109949;
        weights[8] = 0.00725751146886894950208799148241146488328036756882337771;
        weights[9] = 0.00806596217708015554928443823216576067304214849945086191;
        weights[10] = 0.00886765119996740121972790745476980919817129455391591022;
        weights[11] = 0.00966190639834513482863810348879922767846344767764932497;
        weights[12] = 0.0104480618938153352549595411589942071021040227523734602;
        weights[13] = 0.0112254586134804077946485121376951785237222202792599091;
        weights[14] = 0.0119934448357160750714119576880348035570814424708597041;
        weights[15] = 0.0127513767329620001217522713776202186947671785421499837;
        weights[16] = 0.0134986189094821098661756769766964007756190538919252232;
        weights[17] = 0.0142345449328900756388883343238624044065484389823092485;
        weights[18] = 0.0149585378586181349798373585018720073382188623710586582;
        weights[19] = 0.015669990746692902830188701281438329515383516352885165;
        weights[20] = 0.0163683071702778976663855157318407559527015289586261931;
        weights[21] = 0.0170529017154960853958311799991316227269286736759762876;
        weights[22] = 0.0177232004720782860811615288128348512600041575522126799;
        weights[23] = 0.0183786415144050807475009223103430384428378034665011259;
        weights[24] = 0.0190186753725260278328908944266016899259052475842894504;
        weights[25] = 0.0196427654927532028441191609220775856493246910962302425;
        weights[26] = 0.0202503886874377246629344769150108143674309672837891834;
        weights[27] = 0.020841035573548802886523115776334346252970602730487886;
        weights[28] = 0.0214142109996853674729343626887828111727293840666935055;
        weights[29] = 0.0219694344611607733268116591169040733083621736744148068;
        weights[30] = 0.0225062405028115520999151499671452062289211846229604698;
        weights[31] = 0.023024179109191794904428874886973408811638378666599059;
        weights[32] = 0.0235228160818255408635104766359199015577689849091771125;
        weights[33] = 0.0240017334032005441261575956430727515931057411992531701;
        weights[34] = 0.0244605295871980097200469779016275112253725628081212622;
        weights[35] = 0.0248988200156643317628699275911457034945555444703297195;
        weights[36] = 0.0253162372608425362047491920719985533642242932028998122;
        weights[37] = 0.0257124313933930211067209536295101433253834125129575675;
        weights[38] = 0.0260870702757452948581774641531286184648638645866642597;
        weights[39] = 0.026439839840534729519580484657649491683516245090941599;
        weights[40] = 0.0267704443538908643688109890082613302185211207215950059;
        weights[41] = 0.0270786066633565046641196864007833590087318989540336544;
        weights[42] = 0.0273640684302297529640010935637068936527872952115233684;
        weights[43] = 0.0276265903461341749708703440929564514112989908996355003;
        weights[44] = 0.027865952333635528351049624231721195119066255333022795;
        weights[45] = 0.0280819537307368606106994725565407018872136205371011201;
        weights[46] = 0.0282744134590972999314035545785600918661516224363554695;
        weights[47] = 0.0284431701758335097565308667919208880927922908377892216;
        weights[48] = 0.0285880824087765425770697848728096155546589192209198817;
        weights[49] = 0.0287090286750706993642656088254113031447174615212947278;
        weights[50] = 0.0288059075830149668908168835436620832221491089023502371;
        weights[51] = 0.0288786379170616541280855031623013115011243649198318546;
        weights[52] = 0.0289271587059009692750640955296453070014221002851072247;
        weights[53] = 0.0289514292735744589665785702028227951431360144817967594;
        weights[54] = 0.0289514292735744589665785702028227951431360144817967594;
        weights[55] = 0.0289271587059009692750640955296453070014221002851072247;
        weights[56] = 0.0288786379170616541280855031623013115011243649198318546;
        weights[57] = 0.0288059075830149668908168835436620832221491089023502371;
        weights[58] = 0.0287090286750706993642656088254113031447174615212947278;
        weights[59] = 0.0285880824087765425770697848728096155546589192209198817;
        weights[60] = 0.0284431701758335097565308667919208880927922908377892216;
        weights[61] = 0.0282744134590972999314035545785600918661516224363554695;
        weights[62] = 0.0280819537307368606106994725565407018872136205371011201;
        weights[63] = 0.027865952333635528351049624231721195119066255333022795;
        weights[64] = 0.0276265903461341749708703440929564514112989908996355003;
        weights[65] = 0.0273640684302297529640010935637068936527872952115233684;
        weights[66] = 0.0270786066633565046641196864007833590087318989540336544;
        weights[67] = 0.0267704443538908643688109890082613302185211207215950059;
        weights[68] = 0.026439839840534729519580484657649491683516245090941599;
        weights[69] = 0.0260870702757452948581774641531286184648638645866642597;
        weights[70] = 0.0257124313933930211067209536295101433253834125129575675;
        weights[71] = 0.0253162372608425362047491920719985533642242932028998122;
        weights[72] = 0.0248988200156643317628699275911457034945555444703297195;
        weights[73] = 0.0244605295871980097200469779016275112253725628081212622;
        weights[74] = 0.0240017334032005441261575956430727515931057411992531701;
        weights[75] = 0.0235228160818255408635104766359199015577689849091771125;
        weights[76] = 0.023024179109191794904428874886973408811638378666599059;
        weights[77] = 0.0225062405028115520999151499671452062289211846229604698;
        weights[78] = 0.0219694344611607733268116591169040733083621736744148068;
        weights[79] = 0.0214142109996853674729343626887828111727293840666935055;
        weights[80] = 0.020841035573548802886523115776334346252970602730487886;
        weights[81] = 0.0202503886874377246629344769150108143674309672837891834;
        weights[82] = 0.0196427654927532028441191609220775856493246910962302425;
        weights[83] = 0.0190186753725260278328908944266016899259052475842894504;
        weights[84] = 0.0183786415144050807475009223103430384428378034665011259;
        weights[85] = 0.0177232004720782860811615288128348512600041575522126799;
        weights[86] = 0.0170529017154960853958311799991316227269286736759762876;
        weights[87] = 0.0163683071702778976663855157318407559527015289586261931;
        weights[88] = 0.015669990746692902830188701281438329515383516352885165;
        weights[89] = 0.0149585378586181349798373585018720073382188623710586582;
        weights[90] = 0.0142345449328900756388883343238624044065484389823092485;
        weights[91] = 0.0134986189094821098661756769766964007756190538919252232;
        weights[92] = 0.0127513767329620001217522713776202186947671785421499837;
        weights[93] = 0.0119934448357160750714119576880348035570814424708597041;
        weights[94] = 0.0112254586134804077946485121376951785237222202792599091;
        weights[95] = 0.0104480618938153352549595411589942071021040227523734602;
        weights[96] = 0.00966190639834513482863810348879922767846344767764932497;
        weights[97] = 0.00886765119996740121972790745476980919817129455391591022;
        weights[98] = 0.00806596217708015554928443823216576067304214849945086191;
        weights[99] = 0.00725751146886894950208799148241146488328036756882337771;
        weights[100] = 0.00644297694080253960177493742674122693932723379121109949;
        weights[101] = 0.00562304168385699836995984690176188210418524107601798495;
        weights[102] = 0.0047983936164099499007110031594306965471281374825690408;
        weights[103] = 0.00396972542410714363151711289312266454219450056790009587;
        weights[104] = 0.00313773581393474619654864824564236387890245767591044399;
        weights[105] = 0.0023031374081837722563928744717590069844215231560763084;
        weights[106] = 0.00146671593257232249710538248447612734300309683022880133;
        weights[107] = 0.000630304426123453985773409113570013682119309055943184965;
        return;
    case 109:
        points[0] = -0.9997588493430827563751163674201139994732399651674625;
        points[1] = -0.998729609556718755785030602583796835173596293179168387;
        points[2] = -0.996878817447039380863287099730242386535700637233601276;
        points[3] = -0.994207584888376528097520283664684558538037816424492203;
        points[4] = -0.990718060097157701251820161114264381607956005477690429;
        points[5] = -0.986413103182345205751462596397611206478498000449826338;
        points[6] = -0.981296253448665314508190812333627421212774975339277183;
        points[7] = -0.975371720827334424558331416664830471704989030801839497;
        points[8] = -0.968644380907382429465524751317680232204413267167805333;
        points[9] = -0.961119770422466977292653305518584081692434078692936891;
        points[10] = -0.952804082499092928804165000975572985086567113478209868;
        points[11] = -0.943704161474120326073958281464695513862462816043167406;
        points[12] = -0.933827497220649287925965811103423929295556477332367833;
        points[13] = -0.923182218962347440250589841818133581423082103570555474;
        points[14] = -0.911777088571050068916120810366553168071222834867553133;
        points[15] = -0.899621493348511708701558304171080341038023730417893538;
        points[16] = -0.88672543829600992165242819287175969196643419237284299;
        points[17] = -0.873099537877019391535035321672750383107298155999000104;
        points[18] = -0.858755007279122912887519171740610520078965929019035389;
        points[19] = -0.843703653182008822443633332266490248341748676897234677;
        points[20] = -0.82795786403895516074510305318401592064442985425275692;
        points[21] = -0.811530599879681080120912733498173206052266618353749052;
        points[22] = -0.794435381642885631190398964790998295624768465223425658;
        points[23] = -0.7766862800472080956533932656526114441867250339174754;
        points[24] = -0.758297904009740266116992952300670508744691913115913553;
        points[25] = -0.739285388621603604199457701685238272055410088688042281;
        points[26] = -0.719664382690475207690054611434660655296907600614631762;
        points[27] = -0.699451035860307115723731373157083690634915861533252823;
        points[28] = -0.678661985318834229689592170776664947116954990758268707;
        points[29] = -0.657314342103807251632496053419164103543432278005188418;
        points[30] = -0.635425677019218577456282846460631600075236856508900418;
        points[31] = -0.613014006173110955891445336185883688040785145663215085;
        points[32] = -0.590097776148870798758856488242465800582203121578792342;
        points[33] = -0.566695848822210129816023745185693720778856745622057258;
        points[34] = -0.542827485836333094685311847989572431200782104234055719;
        points[35] = -0.518512332748064519550341376953629713478592320306817369;
        points[36] = -0.493770402857988994699859811416571148780734873292694712;
        points[37] = -0.468622060737909164722007027162550401686914700347625273;
        points[38] = -0.443088005469181127971803764399293954649828000337459545;
        points[39] = -0.417189253605722887110013732435893935618194371409758073;
        points[40] = -0.390947121875718460071675368704457157015163531844247029;
        points[41] = -0.36438320963625537447009519941775552589154557379987109;
        points[42] = -0.337519381095336654208106688943958293462258881499848469;
        points[43] = -0.310377747315899899801868161866751338792357001176201559;
        points[44] = -0.282980648016655507665219181650473321390164254670969268;
        points[45] = -0.255350633184723321884626472211442894221796960345038674;
        points[46] = -0.227510444515201928092306976643048060379247724533358158;
        points[47] = -0.199482996692947256096832525442347772785784752998051569;
        points[48] = -0.171291358531967039221507087065312891321336107615046973;
        points[49] = -0.142958733987954877321851218404286705401400864454625261;
        points[50] = -0.114508443059592071040045434105085086986917384970718646;
        points[51] = -0.0859639025943369512882045226130866485278082506874648392;
        points[52] = -0.0573486070145000450498080963388846456857770322091815639;
        points[53] = -0.0286861089794690317734982088250319445747175511403293874;
        points[54] = 0;
        points[55] = 0.0286861089794690317734982088250319445747175511403293874;
        points[56] = 0.0573486070145000450498080963388846456857770322091815639;
        points[57] = 0.0859639025943369512882045226130866485278082506874648392;
        points[58] = 0.114508443059592071040045434105085086986917384970718646;
        points[59] = 0.142958733987954877321851218404286705401400864454625261;
        points[60] = 0.171291358531967039221507087065312891321336107615046973;
        points[61] = 0.199482996692947256096832525442347772785784752998051569;
        points[62] = 0.227510444515201928092306976643048060379247724533358158;
        points[63] = 0.255350633184723321884626472211442894221796960345038674;
        points[64] = 0.282980648016655507665219181650473321390164254670969268;
        points[65] = 0.310377747315899899801868161866751338792357001176201559;
        points[66] = 0.337519381095336654208106688943958293462258881499848469;
        points[67] = 0.36438320963625537447009519941775552589154557379987109;
        points[68] = 0.390947121875718460071675368704457157015163531844247029;
        points[69] = 0.417189253605722887110013732435893935618194371409758073;
        points[70] = 0.443088005469181127971803764399293954649828000337459545;
        points[71] = 0.468622060737909164722007027162550401686914700347625273;
        points[72] = 0.493770402857988994699859811416571148780734873292694712;
        points[73] = 0.518512332748064519550341376953629713478592320306817369;
        points[74] = 0.542827485836333094685311847989572431200782104234055719;
        points[75] = 0.566695848822210129816023745185693720778856745622057258;
        points[76] = 0.590097776148870798758856488242465800582203121578792342;
        points[77] = 0.613014006173110955891445336185883688040785145663215085;
        points[78] = 0.635425677019218577456282846460631600075236856508900418;
        points[79] = 0.657314342103807251632496053419164103543432278005188418;
        points[80] = 0.678661985318834229689592170776664947116954990758268707;
        points[81] = 0.699451035860307115723731373157083690634915861533252823;
        points[82] = 0.719664382690475207690054611434660655296907600614631762;
        points[83] = 0.739285388621603604199457701685238272055410088688042281;
        points[84] = 0.758297904009740266116992952300670508744691913115913553;
        points[85] = 0.7766862800472080956533932656526114441867250339174754;
        points[86] = 0.794435381642885631190398964790998295624768465223425658;
        points[87] = 0.811530599879681080120912733498173206052266618353749052;
        points[88] = 0.82795786403895516074510305318401592064442985425275692;
        points[89] = 0.843703653182008822443633332266490248341748676897234677;
        points[90] = 0.858755007279122912887519171740610520078965929019035389;
        points[91] = 0.873099537877019391535035321672750383107298155999000104;
        points[92] = 0.88672543829600992165242819287175969196643419237284299;
        points[93] = 0.899621493348511708701558304171080341038023730417893538;
        points[94] = 0.911777088571050068916120810366553168071222834867553133;
        points[95] = 0.923182218962347440250589841818133581423082103570555474;
        points[96] = 0.933827497220649287925965811103423929295556477332367833;
        points[97] = 0.943704161474120326073958281464695513862462816043167406;
        points[98] = 0.952804082499092928804165000975572985086567113478209868;
        points[99] = 0.961119770422466977292653305518584081692434078692936891;
        points[100] = 0.968644380907382429465524751317680232204413267167805333;
        points[101] = 0.975371720827334424558331416664830471704989030801839497;
        points[102] = 0.981296253448665314508190812333627421212774975339277183;
        points[103] = 0.986413103182345205751462596397611206478498000449826338;
        points[104] = 0.990718060097157701251820161114264381607956005477690429;
        points[105] = 0.994207584888376528097520283664684558538037816424492203;
        points[106] = 0.996878817447039380863287099730242386535700637233601276;
        points[107] = 0.998729609556718755785030602583796835173596293179168387;
        points[108] = 0.9997588493430827563751163674201139994732399651674625;
        weights[0] = 0.000618845585493223424278449042418914764801589245407557758;
        weights[1] = 0.00144006040844011475105107078322044140781544126895718891;
        weights[2] = 0.00226130695416205030158104980459232925715568611129361941;
        weights[3] = 0.00308079800255216930226316331622634524200101155861537268;
        weights[4] = 0.0038977745477270674128704626561702813191546287407663577;
        weights[5] = 0.00471154928014658301624303327432131997361049875654346311;
        weights[6] = 0.00552144845403190375815302679972790104840406801498692352;
        weights[7] = 0.00632680411644444005813598372310673182361857739459801001;
        weights[8] = 0.00712695285567947625263922234838547611461719598068870289;
        weights[9] = 0.00792123584014456248252802797124733012110679651298508799;
        weights[10] = 0.00870899918926429204488941297235328173951683282991742898;
        weights[11] = 0.0094895944454125034179939499756790891188385579875053007;
        weights[12] = 0.0102623790792084645010973101206887069977073105507335427;
        weights[13] = 0.0110267170051092829466142921497966804171819168866420387;
        weights[14] = 0.0117819790983404762961858377656019906373221900754169359;
        weights[15] = 0.0125275437092197748207771602618495801473225467156905724;
        weights[16] = 0.0132627971728868453707878342526964525089901806539864086;
        weights[17] = 0.0139871343132793939474774383882435599428496077452319584;
        weights[18] = 0.0146999589405714649638300000477109803792696832406611222;
        weights[19] = 0.0154006843414714131184372754639608589795995398296547361;
        weights[20] = 0.0160887337618708955396930691836746914358870180481084256;
        weights[21] = 0.0167635408813883517935032528797296559974722885793310799;
        weights[22] = 0.0174245502793818827724820959978376293505112504706155816;
        weights[23] = 0.018071217892027304911671834564901090217390756204642424;
        weights[24] = 0.0187030114600724810554862656836731520527564119904312426;
        weights[25] = 0.0193194109668914175760680084762829711953534760952106534;
        weights[26] = 0.019919909066472458086107262306415991197724005399876727;
        weights[27] = 0.020504011500984959003160878197800165717116301090769681;
        weights[28] = 0.0210712375075785289369918630418911623427726367506417502;
        weights[29] = 0.0216211202140784970638886114665020185416886316356361888;
        weights[30] = 0.0221532070232508871915765997175462545862463979915876653;
        weights[31] = 0.0226670599853198968040800383613939487049592362198432422;
        weights[32] = 0.0231622561584307618800308479825500940327189463011666789;
        weights[33] = 0.0236383879567609556342132699367383772978992705478606997;
        weights[34] = 0.0240950634859929366252194916718230652299041736478422898;
        weights[35] = 0.0245319068658721349416500652976917575248605077619751285;
        weights[36] = 0.0249485585395845453255068083651312190235125824106053659;
        weights[37] = 0.0253446755696991806627150885771093055952902256449079934;
        weights[38] = 0.025719931920431723581990739372420074746394130590720176;
        weights[39] = 0.0260740187259969917467139543933222033749074831024543183;
        weights[40] = 0.0264066445448292965285082867736149975668155501992835999;
        weights[41] = 0.0267175355994614170816721919955964532432432806084126794;
        weights[42] = 0.0270064360018647237986408113351865962120812880168363263;
        weights[43] = 0.0272731079640649576972604414222515221120106024777256226;
        weights[44] = 0.0275173319938602961192036600596503730439425133430327312;
        weights[45] = 0.0277389070754806005900377759783645810807929601042603188;
        weights[46] = 0.0279376508350391399749382183107995155602990428834405442;
        weights[47] = 0.0281133996906406011507453519930018436251566559564265026;
        weights[48] = 0.028266008987021830145203552840903398729328385114177662;
        weights[49] = 0.0283953531146144787795814991258910432316055290259891953;
        weights[50] = 0.0285013256129315548932199876731532059728975086865678084;
        weights[51] = 0.0285838392581927777353323072624111000071349658803441401;
        weights[52] = 0.0286428261351166135075265640371154682760360413581299078;
        weights[53] = 0.0286782376928198986889523426522300894934173013744802302;
        weights[54] = 0.0286900447847790399771859238947934634779775687727661809;
        weights[55] = 0.0286782376928198986889523426522300894934173013744802302;
        weights[56] = 0.0286428261351166135075265640371154682760360413581299078;
        weights[57] = 0.0285838392581927777353323072624111000071349658803441401;
        weights[58] = 0.0285013256129315548932199876731532059728975086865678084;
        weights[59] = 0.0283953531146144787795814991258910432316055290259891953;
        weights[60] = 0.028266008987021830145203552840903398729328385114177662;
        weights[61] = 0.0281133996906406011507453519930018436251566559564265026;
        weights[62] = 0.0279376508350391399749382183107995155602990428834405442;
        weights[63] = 0.0277389070754806005900377759783645810807929601042603188;
        weights[64] = 0.0275173319938602961192036600596503730439425133430327312;
        weights[65] = 0.0272731079640649576972604414222515221120106024777256226;
        weights[66] = 0.0270064360018647237986408113351865962120812880168363263;
        weights[67] = 0.0267175355994614170816721919955964532432432806084126794;
        weights[68] = 0.0264066445448292965285082867736149975668155501992835999;
        weights[69] = 0.0260740187259969917467139543933222033749074831024543183;
        weights[70] = 0.025719931920431723581990739372420074746394130590720176;
        weights[71] = 0.0253446755696991806627150885771093055952902256449079934;
        weights[72] = 0.0249485585395845453255068083651312190235125824106053659;
        weights[73] = 0.0245319068658721349416500652976917575248605077619751285;
        weights[74] = 0.0240950634859929366252194916718230652299041736478422898;
        weights[75] = 0.0236383879567609556342132699367383772978992705478606997;
        weights[76] = 0.0231622561584307618800308479825500940327189463011666789;
        weights[77] = 0.0226670599853198968040800383613939487049592362198432422;
        weights[78] = 0.0221532070232508871915765997175462545862463979915876653;
        weights[79] = 0.0216211202140784970638886114665020185416886316356361888;
        weights[80] = 0.0210712375075785289369918630418911623427726367506417502;
        weights[81] = 0.020504011500984959003160878197800165717116301090769681;
        weights[82] = 0.019919909066472458086107262306415991197724005399876727;
        weights[83] = 0.0193194109668914175760680084762829711953534760952106534;
        weights[84] = 0.0187030114600724810554862656836731520527564119904312426;
        weights[85] = 0.018071217892027304911671834564901090217390756204642424;
        weights[86] = 0.0174245502793818827724820959978376293505112504706155816;
        weights[87] = 0.0167635408813883517935032528797296559974722885793310799;
        weights[88] = 0.0160887337618708955396930691836746914358870180481084256;
        weights[89] = 0.0154006843414714131184372754639608589795995398296547361;
        weights[90] = 0.0146999589405714649638300000477109803792696832406611222;
        weights[91] = 0.0139871343132793939474774383882435599428496077452319584;
        weights[92] = 0.0132627971728868453707878342526964525089901806539864086;
        weights[93] = 0.0125275437092197748207771602618495801473225467156905724;
        weights[94] = 0.0117819790983404762961858377656019906373221900754169359;
        weights[95] = 0.0110267170051092829466142921497966804171819168866420387;
        weights[96] = 0.0102623790792084645010973101206887069977073105507335427;
        weights[97] = 0.0094895944454125034179939499756790891188385579875053007;
        weights[98] = 0.00870899918926429204488941297235328173951683282991742898;
        weights[99] = 0.00792123584014456248252802797124733012110679651298508799;
        weights[100] = 0.00712695285567947625263922234838547611461719598068870289;
        weights[101] = 0.00632680411644444005813598372310673182361857739459801001;
        weights[102] = 0.00552144845403190375815302679972790104840406801498692352;
        weights[103] = 0.00471154928014658301624303327432131997361049875654346311;
        weights[104] = 0.0038977745477270674128704626561702813191546287407663577;
        weights[105] = 0.00308079800255216930226316331622634524200101155861537268;
        weights[106] = 0.00226130695416205030158104980459232925715568611129361941;
        weights[107] = 0.00144006040844011475105107078322044140781544126895718891;
        weights[108] = 0.000618845585493223424278449042418914764801589245407557758;
        return;
    case 110:
        points[0] = -0.99976319410985328632167669427573396663283842887325933;
        points[1] = -0.998752494089401597367182492931261843150301520983867569;
        points[2] = -0.996935024690191162091585102102029279323940077728454745;
        points[3] = -0.994311850823600121067410908821636627760838197443075173;
        points[4] = -0.990885043159995250227202243771303787482613813507552433;
        points[5] = -0.986657359588478746663753910130079725603622638899282887;
        points[6] = -0.981632213192040526124427001604641271758291500064690604;
        points[7] = -0.975813663934758919548813068759284678409023574057403262;
        points[8] = -0.969206413903879355841480810039067181608008752721603883;
        points[9] = -0.961815803018185106050625024544961902548090655210718423;
        points[10] = -0.953647804520908752138177708099273676414252430588793895;
        points[11] = -0.944709020068334346687288477205986848547210614042837124;
        points[12] = -0.935006674354058328233926031980539572585823543351895515;
        points[13] = -0.924548609249093418846190247664011363757669149472790645;
        points[14] = -0.91334327745247584610711289808345916298378892393083369;
        points[15] = -0.901399735652953627238206642934393433324850394011728113;
        points[16] = -0.888727637205083009097673284425282769656242354994356366;
        points[17] = -0.875337224324528689398906206146557649649111310881600373;
        points[18] = -0.861239319808273663708312314195569369932838352638960369;
        points[19] = -0.846445318286094444256727509551566998575199578079065348;
        points[20] = -0.83096717701017785544898827692512188619237784345739301;
        points[21] = -0.814817406190207255081086050115798698720263675045885282;
        points[22] = -0.798009058881658242179467496807356438073907710512723008;
        points[23] = -0.780555720435431474710280578567769784539007280455501839;
        points[24] = -0.762471497517320791784383524056098500605500391266500254;
        points[25] = -0.743771006706172462158267871722877652074274769069760845;
        points[26] = -0.724469362679938216197958034493973882488619880565605352;
        points[27] = -0.704582165999161890710545898074813880911481420281868119;
        points[28] = -0.684125490497767586022920261091602712642799845539709795;
        points[29] = -0.66311587029133644134089909731990907601396671719006606;
        points[30] = -0.641570286413369531017822146105182236286640032159646597;
        points[31] = -0.619506153090335915885591746652110110607378840853227482;
        points[32] = -0.596941303666597431963022273430827805300515512791315974;
        points[33] = -0.573893976190585208831097444130959866116883679940763407;
        points[34] = -0.550382798673877006616045331484758460149601845458631638;
        points[35] = -0.526426774035089058444345923680483907720278647161131696;
        points[36] = -0.502045264740751015097227523653555257004922058920764581;
        points[37] = -0.477257977155577621222419619845168602413873014297816276;
        points[38] = -0.452084945614785721529193953576913084595231525633589756;
        points[39] = -0.426546516231329919220536659344078583028294782682617541;
        points[40] = -0.400663330451144511716945706748891557142113949141342584;
        points[41] = -0.374456308369683041479964735382909056373429983559951028;
        points[42] = -0.347946631823239760830024332298258960758946369400949707;
        points[43] = -0.321155727268719365322401702045806193320257078569422087;
        points[44] = -0.294105248465692354976229133983052369406234410803445392;
        points[45] = -0.266817058974733199434268701609685425290851610160632978;
        points[46] = -0.239313214486186983692279204484016526682292321806887954;
        points[47] = -0.211615944993647276025424393237274499848054489507662617;
        points[48] = -0.18374763682655347888221349067949803837237109071966672;
        points[49] = -0.155730814556429795750015270074270396106138735547469144;
        points[50] = -0.127588122791390080577953622538061366823827328403358654;
        points[51] = -0.0993423078736231489489132914268883487236546140038288943;
        points[52] = -0.0710161994946515489996472435245946017744439821901164318;
        points[53] = -0.042632692243223251846010301462980094372702857363479148;
        points[54] = -0.0142147271007501723608675100949834484616286737626066154;
        points[55] = 0.0142147271007501723608675100949834484616286737626066154;
        points[56] = 0.042632692243223251846010301462980094372702857363479148;
        points[57] = 0.0710161994946515489996472435245946017744439821901164318;
        points[58] = 0.0993423078736231489489132914268883487236546140038288943;
        points[59] = 0.127588122791390080577953622538061366823827328403358654;
        points[60] = 0.155730814556429795750015270074270396106138735547469144;
        points[61] = 0.18374763682655347888221349067949803837237109071966672;
        points[62] = 0.211615944993647276025424393237274499848054489507662617;
        points[63] = 0.239313214486186983692279204484016526682292321806887954;
        points[64] = 0.266817058974733199434268701609685425290851610160632978;
        points[65] = 0.294105248465692354976229133983052369406234410803445392;
        points[66] = 0.321155727268719365322401702045806193320257078569422087;
        points[67] = 0.347946631823239760830024332298258960758946369400949707;
        points[68] = 0.374456308369683041479964735382909056373429983559951028;
        points[69] = 0.400663330451144511716945706748891557142113949141342584;
        points[70] = 0.426546516231329919220536659344078583028294782682617541;
        points[71] = 0.452084945614785721529193953576913084595231525633589756;
        points[72] = 0.477257977155577621222419619845168602413873014297816276;
        points[73] = 0.502045264740751015097227523653555257004922058920764581;
        points[74] = 0.526426774035089058444345923680483907720278647161131696;
        points[75] = 0.550382798673877006616045331484758460149601845458631638;
        points[76] = 0.573893976190585208831097444130959866116883679940763407;
        points[77] = 0.596941303666597431963022273430827805300515512791315974;
        points[78] = 0.619506153090335915885591746652110110607378840853227482;
        points[79] = 0.641570286413369531017822146105182236286640032159646597;
        points[80] = 0.66311587029133644134089909731990907601396671719006606;
        points[81] = 0.684125490497767586022920261091602712642799845539709795;
        points[82] = 0.704582165999161890710545898074813880911481420281868119;
        points[83] = 0.724469362679938216197958034493973882488619880565605352;
        points[84] = 0.743771006706172462158267871722877652074274769069760845;
        points[85] = 0.762471497517320791784383524056098500605500391266500254;
        points[86] = 0.780555720435431474710280578567769784539007280455501839;
        points[87] = 0.798009058881658242179467496807356438073907710512723008;
        points[88] = 0.814817406190207255081086050115798698720263675045885282;
        points[89] = 0.83096717701017785544898827692512188619237784345739301;
        points[90] = 0.846445318286094444256727509551566998575199578079065348;
        points[91] = 0.861239319808273663708312314195569369932838352638960369;
        points[92] = 0.875337224324528689398906206146557649649111310881600373;
        points[93] = 0.888727637205083009097673284425282769656242354994356366;
        points[94] = 0.901399735652953627238206642934393433324850394011728113;
        points[95] = 0.91334327745247584610711289808345916298378892393083369;
        points[96] = 0.924548609249093418846190247664011363757669149472790645;
        points[97] = 0.935006674354058328233926031980539572585823543351895515;
        points[98] = 0.944709020068334346687288477205986848547210614042837124;
        points[99] = 0.953647804520908752138177708099273676414252430588793895;
        points[100] = 0.961815803018185106050625024544961902548090655210718423;
        points[101] = 0.969206413903879355841480810039067181608008752721603883;
        points[102] = 0.975813663934758919548813068759284678409023574057403262;
        points[103] = 0.981632213192040526124427001604641271758291500064690604;
        points[104] = 0.986657359588478746663753910130079725603622638899282887;
        points[105] = 0.990885043159995250227202243771303787482613813507552433;
        points[106] = 0.994311850823600121067410908821636627760838197443075173;
        points[107] = 0.996935024690191162091585102102029279323940077728454745;
        points[108] = 0.998752494089401597367182492931261843150301520983867569;
        points[109] = 0.99976319410985328632167669427573396663283842887325933;
        weights[0] = 0.00060769639918581115768295719301930762967809134964467342;
        weights[1] = 0.00141412487600018094316925925464926351312238820749576261;
        weights[2] = 0.00222060546191684591909120752638614963722470163907485045;
        weights[3] = 0.00302539507433418674577210532354976094632150903846129698;
        weights[4] = 0.00382776026499882640365075736433185272753870032215437623;
        weights[5] = 0.00462703791705988056410850128276849415769201378032967584;
        weights[6] = 0.00542257814058414137801202353245396328314219039448811034;
        weights[7] = 0.00621373662242900087970527724944083668267690193603107491;
        weights[8] = 0.00699987337810130758120619886930948233837878216533321295;
        weights[9] = 0.00778035277100898743094791205882668022193107914447633971;
        weights[10] = 0.00855454385793994038828661783534605197710744448657534282;
        weights[11] = 0.00932182083395447039357184025325243166972837351326988226;
        weights[12] = 0.0100815635102697961361104058561434589082570465121425025;
        weights[13] = 0.0108331578025070939214889398192601992560433364626722761;
        weights[14] = 0.0115759962205267084489734767816410500204148950192461613;
        weights[15] = 0.01230947835599968013381491213439441873030785807375703;
        weights[16] = 0.0130330113657857576251952429714615258128436483004427906;
        weights[17] = 0.0137460104500005722609221264783555108419233172870340086;
        weights[18] = 0.0144478993240228783772204553651409297156360339646843704;
        weights[19] = 0.0151381106838707554467456682353672033260812546145227768;
        weights[20] = 0.0158160866644674330122616535817045269237628715995551885;
        weights[21] = 0.0164812792903681427071337555834965227790765323806777693;
        weights[22] = 0.017133150918549819301357320070292328094414090863887302;
        weights[23] = 0.0177711746728854817087971625122844929720580634627574654;
        weights[24] = 0.0183948348699396724132648126176396823246707305407450322;
        weights[25] = 0.0190036274357329773554153906193806075651911175946456644;
        weights[26] = 0.0195970603131337525456420949400163408053206179000156613;
        weights[27] = 0.0201746538595444970632501173631010891678633383925779521;
        weights[28] = 0.0207359412345592551671020640158567317162645595857604132;
        weights[29] = 0.021280468777277243839366295289208899297823781873748244;
        weights[30] = 0.021807796372966726136563387100126265063547748737374109;
        weights[31] = 0.0223174978087820670692165221737772789163594579165220644;
        weights[32] = 0.0228091611182459650298732603117110661717110814655808887;
        weights[33] = 0.0232823889142180751514165751706335894070332958834881275;
        weights[34] = 0.0237367987100806459143203030843709577872315073385175616;
        weights[35] = 0.024172023228881383459196576514371083199745227942347395;
        weights[36] = 0.024587710700183540993911899445114862797169999201610765;
        weights[37] = 0.0249835251443832017297246188670194370830781349214343884;
        weights[38] = 0.0253591466442638790754548103169473487409190146849060506;
        weights[39] = 0.0257142716035688920171358813215119713066081527962815707;
        weights[40] = 0.0260486129923824803347407601341228400998404188662650841;
        weights[41] = 0.0263619005791212964415631032302686959395323876848062534;
        weights[42] = 0.0266538811489487405186711243720577618447523438963840166;
        weights[43] = 0.0269243187084355851916607341630539190739251348637229528;
        weights[44] = 0.0271729946763014568790129782359331882702499361735900312;
        weights[45] = 0.0273997080600829944991390870851758874121009736275037293;
        weights[46] = 0.0276042756185858836211842799909705770913301590056633766;
        weights[47] = 0.0277865320099894563783027657748723231560500682157534869;
        weights[48] = 0.0279463299254841453844590835706689564231328152739514078;
        weights[49] = 0.0280835402083337742385870989917620443174877585674219942;
        weights[50] = 0.0281980519582664485907991046777187769679056598023263475;
        weights[51] = 0.0282897726211096707224270430294593669931646630767341242;
        weights[52] = 0.0283586280635972276163492696773119571041819423331483377;
        weights[53] = 0.0284045626332873879622931537719215490429752389041349538;
        weights[54] = 0.0284275392035439777947300270110385027474716084143237758;
        weights[55] = 0.0284275392035439777947300270110385027474716084143237758;
        weights[56] = 0.0284045626332873879622931537719215490429752389041349538;
        weights[57] = 0.0283586280635972276163492696773119571041819423331483377;
        weights[58] = 0.0282897726211096707224270430294593669931646630767341242;
        weights[59] = 0.0281980519582664485907991046777187769679056598023263475;
        weights[60] = 0.0280835402083337742385870989917620443174877585674219942;
        weights[61] = 0.0279463299254841453844590835706689564231328152739514078;
        weights[62] = 0.0277865320099894563783027657748723231560500682157534869;
        weights[63] = 0.0276042756185858836211842799909705770913301590056633766;
        weights[64] = 0.0273997080600829944991390870851758874121009736275037293;
        weights[65] = 0.0271729946763014568790129782359331882702499361735900312;
        weights[66] = 0.0269243187084355851916607341630539190739251348637229528;
        weights[67] = 0.0266538811489487405186711243720577618447523438963840166;
        weights[68] = 0.0263619005791212964415631032302686959395323876848062534;
        weights[69] = 0.0260486129923824803347407601341228400998404188662650841;
        weights[70] = 0.0257142716035688920171358813215119713066081527962815707;
        weights[71] = 0.0253591466442638790754548103169473487409190146849060506;
        weights[72] = 0.0249835251443832017297246188670194370830781349214343884;
        weights[73] = 0.024587710700183540993911899445114862797169999201610765;
        weights[74] = 0.024172023228881383459196576514371083199745227942347395;
        weights[75] = 0.0237367987100806459143203030843709577872315073385175616;
        weights[76] = 0.0232823889142180751514165751706335894070332958834881275;
        weights[77] = 0.0228091611182459650298732603117110661717110814655808887;
        weights[78] = 0.0223174978087820670692165221737772789163594579165220644;
        weights[79] = 0.021807796372966726136563387100126265063547748737374109;
        weights[80] = 0.021280468777277243839366295289208899297823781873748244;
        weights[81] = 0.0207359412345592551671020640158567317162645595857604132;
        weights[82] = 0.0201746538595444970632501173631010891678633383925779521;
        weights[83] = 0.0195970603131337525456420949400163408053206179000156613;
        weights[84] = 0.0190036274357329773554153906193806075651911175946456644;
        weights[85] = 0.0183948348699396724132648126176396823246707305407450322;
        weights[86] = 0.0177711746728854817087971625122844929720580634627574654;
        weights[87] = 0.017133150918549819301357320070292328094414090863887302;
        weights[88] = 0.0164812792903681427071337555834965227790765323806777693;
        weights[89] = 0.0158160866644674330122616535817045269237628715995551885;
        weights[90] = 0.0151381106838707554467456682353672033260812546145227768;
        weights[91] = 0.0144478993240228783772204553651409297156360339646843704;
        weights[92] = 0.0137460104500005722609221264783555108419233172870340086;
        weights[93] = 0.0130330113657857576251952429714615258128436483004427906;
        weights[94] = 0.01230947835599968013381491213439441873030785807375703;
        weights[95] = 0.0115759962205267084489734767816410500204148950192461613;
        weights[96] = 0.0108331578025070939214889398192601992560433364626722761;
        weights[97] = 0.0100815635102697961361104058561434589082570465121425025;
        weights[98] = 0.00932182083395447039357184025325243166972837351326988226;
        weights[99] = 0.00855454385793994038828661783534605197710744448657534282;
        weights[100] = 0.00778035277100898743094791205882668022193107914447633971;
        weights[101] = 0.00699987337810130758120619886930948233837878216533321295;
        weights[102] = 0.00621373662242900087970527724944083668267690193603107491;
        weights[103] = 0.00542257814058414137801202353245396328314219039448811034;
        weights[104] = 0.00462703791705988056410850128276849415769201378032967584;
        weights[105] = 0.00382776026499882640365075736433185272753870032215437623;
        weights[106] = 0.00302539507433418674577210532354976094632150903846129698;
        weights[107] = 0.00222060546191684591909120752638614963722470163907485045;
        weights[108] = 0.00141412487600018094316925925464926351312238820749576261;
        weights[109] = 0.00060769639918581115768295719301930762967809134964467342;
        return;
    case 111:
        points[0] = -0.999767422509164291636450881914727977459970664331235327;
        points[1] = -0.998774765833261225426604935006083828983257704528608979;
        points[2] = -0.99698972744888983612479908217507607676038182649730338;
        points[3] = -0.99441332751050858828281398484962662715841631948509435;
        points[4] = -0.991047562585975629866603298075672010087979434647514173;
        points[5] = -0.986895092864000755485967212365547859022973952578991592;
        points[6] = -0.981959210778891748474971071529301508735712497469417495;
        points[7] = -0.976243832942023283757251441909065256431792446521077513;
        points[8] = -0.969753495582692505160909462208437250017630892082615616;
        points[9] = -0.962493350464792066398225180018379396836506785056674272;
        points[10] = -0.954469160609565123037905920312230073056359217551029352;
        points[11] = -0.945687295638784849488840328460251392960808544826565355;
        points[12] = -0.936154726679197654795692149566417340243371119923792437;
        points[13] = -0.925879020808546338932171519411705766850609570427492248;
        points[14] = -0.914868335037686337752191398141871722875509123803179982;
        points[15] = -0.903131409829099486479733791407677667205829384969026575;
        points[16] = -0.890677562154789827848964356501513336244534434368079205;
        points[17] = -0.877516678097968438002234094049711641338063989285233971;
        points[18] = -0.863659205003808672225514952038475028001167153452266164;
        points[19] = -0.849116143185172337850851879133157639848256350254957619;
        points[20] = -0.83389903718969964190161722414480909027645724532621705;
        points[21] = -0.818019966635080901864047457430122920766258244375545635;
        points[22] = -0.801491536619714827081152395919827599140798601162673933;
        points[23] = -0.784326867716321213875031483715340769396640160605532133;
        points[24] = -0.766539585556422690560929524550186431449751434548880691;
        points[25] = -0.74814381001394469215737566148470706219471654804669202;
        points[26] = -0.729154143996507270965002332974384002233338694925494483;
        points[27] = -0.709585661853297784504261922230407169377829052032658244;
        points[28] = -0.689453897408720514617400606667332107867391437266119754;
        points[29] = -0.668774831631318112204851883924775920498466492990224564;
        points[30] = -0.647564879947750499534014863173706905300768553864761408;
        points[31] = -0.625840879211899457885517575273509167870351706800288946;
        points[32] = -0.603620074339441481329892778908188531058937518697462934;
        points[33] = -0.580920104618497450030689224536374804045376215866129686;
        points[34] = -0.55775898970722511047540020502890590835842686804441881;
        points[35] = -0.534155115329469076571901892378722694097552436885033284;
        points[36] = -0.510127218679822911260267475462949699311649002297208539;
        points[37] = -0.485694373549688639338189383043446989104538497265329469;
        points[38] = -0.460875975186140606884725772801603191535004719771622339;
        points[39] = -0.435691724895612773196654129878717700411145301103655457;
        points[40] = -0.410161614404631134840652289308576464315413648785642337;
        points[41] = -0.384305909990005881549374554986189260716189849913498022;
        points[42] = -0.358145136391080920098840781509386889860404006739858459;
        points[43] = -0.331700060516811431871824076237519916021992157172130879;
        points[44] = -0.304991674960603016779578808922443572271491728575488834;
        points[45] = -0.278041181335998592462555572587076412573238449301589359;
        points[46] = -0.250869973446441442952829682008227856512523214120158604;
        points[47] = -0.223499620302474533018818848780809373270884722876193644;
        points[48] = -0.195951848999857319164108833299785341591435469649343566;
        points[49] = -0.168248527472191699954308190537773054950167973582772463;
        points[50] = -0.140411647131748369642358476359108462360667259138795951;
        points[51] = -0.112463305412273591094689682297558047489790591065699585;
        points[52] = -0.0844256882276342165054247878299091130755109232040555437;
        points[53] = -0.0563210523602255956849879672306944273097441277752909479;
        points[54] = -0.0281717077931227688863015630371909571596535276524084465;
        points[55] = 0;
        points[56] = 0.0281717077931227688863015630371909571596535276524084465;
        points[57] = 0.0563210523602255956849879672306944273097441277752909479;
        points[58] = 0.0844256882276342165054247878299091130755109232040555437;
        points[59] = 0.112463305412273591094689682297558047489790591065699585;
        points[60] = 0.140411647131748369642358476359108462360667259138795951;
        points[61] = 0.168248527472191699954308190537773054950167973582772463;
        points[62] = 0.195951848999857319164108833299785341591435469649343566;
        points[63] = 0.223499620302474533018818848780809373270884722876193644;
        points[64] = 0.250869973446441442952829682008227856512523214120158604;
        points[65] = 0.278041181335998592462555572587076412573238449301589359;
        points[66] = 0.304991674960603016779578808922443572271491728575488834;
        points[67] = 0.331700060516811431871824076237519916021992157172130879;
        points[68] = 0.358145136391080920098840781509386889860404006739858459;
        points[69] = 0.384305909990005881549374554986189260716189849913498022;
        points[70] = 0.410161614404631134840652289308576464315413648785642337;
        points[71] = 0.435691724895612773196654129878717700411145301103655457;
        points[72] = 0.460875975186140606884725772801603191535004719771622339;
        points[73] = 0.485694373549688639338189383043446989104538497265329469;
        points[74] = 0.510127218679822911260267475462949699311649002297208539;
        points[75] = 0.534155115329469076571901892378722694097552436885033284;
        points[76] = 0.55775898970722511047540020502890590835842686804441881;
        points[77] = 0.580920104618497450030689224536374804045376215866129686;
        points[78] = 0.603620074339441481329892778908188531058937518697462934;
        points[79] = 0.625840879211899457885517575273509167870351706800288946;
        points[80] = 0.647564879947750499534014863173706905300768553864761408;
        points[81] = 0.668774831631318112204851883924775920498466492990224564;
        points[82] = 0.689453897408720514617400606667332107867391437266119754;
        points[83] = 0.709585661853297784504261922230407169377829052032658244;
        points[84] = 0.729154143996507270965002332974384002233338694925494483;
        points[85] = 0.74814381001394469215737566148470706219471654804669202;
        points[86] = 0.766539585556422690560929524550186431449751434548880691;
        points[87] = 0.784326867716321213875031483715340769396640160605532133;
        points[88] = 0.801491536619714827081152395919827599140798601162673933;
        points[89] = 0.818019966635080901864047457430122920766258244375545635;
        points[90] = 0.83389903718969964190161722414480909027645724532621705;
        points[91] = 0.849116143185172337850851879133157639848256350254957619;
        points[92] = 0.863659205003808672225514952038475028001167153452266164;
        points[93] = 0.877516678097968438002234094049711641338063989285233971;
        points[94] = 0.890677562154789827848964356501513336244534434368079205;
        points[95] = 0.903131409829099486479733791407677667205829384969026575;
        points[96] = 0.914868335037686337752191398141871722875509123803179982;
        points[97] = 0.925879020808546338932171519411705766850609570427492248;
        points[98] = 0.936154726679197654795692149566417340243371119923792437;
        points[99] = 0.945687295638784849488840328460251392960808544826565355;
        points[100] = 0.954469160609565123037905920312230073056359217551029352;
        points[101] = 0.962493350464792066398225180018379396836506785056674272;
        points[102] = 0.969753495582692505160909462208437250017630892082615616;
        points[103] = 0.976243832942023283757251441909065256431792446521077513;
        points[104] = 0.981959210778891748474971071529301508735712497469417495;
        points[105] = 0.986895092864000755485967212365547859022973952578991592;
        points[106] = 0.991047562585975629866603298075672010087979434647514173;
        points[107] = 0.99441332751050858828281398484962662715841631948509435;
        points[108] = 0.99698972744888983612479908217507607676038182649730338;
        points[109] = 0.998774765833261225426604935006083828983257704528608979;
        points[110] = 0.999767422509164291636450881914727977459970664331235327;
        weights[0] = 0.000596845810059268920570441411555248779023253827623760066;
        weights[1] = 0.00138888364010550276334401324974779736031366579807638266;
        weights[2] = 0.00218099268143208820449530406847558674009385500205149967;
        weights[3] = 0.00297147238704545057547799710156120531003380019576799655;
        weights[4] = 0.00375961376490400761072794512329838670793470123671650674;
        weights[5] = 0.00454477682981480106321278336471056576403347817139745311;
        weights[6] = 0.00532633450051659364673224200735626160368124097467536089;
        weights[7] = 0.00610366506811257316638644819419769115701108146256570232;
        weights[8] = 0.00687615095229344748770567207598589486712620663248658407;
        weights[9] = 0.00764317870246880487855072784080700067199999414606698846;
        weights[10] = 0.00840413931946931458001748256465871413386376395423049565;
        weights[11] = 0.00915842867507755835961666467654652463393816199750373721;
        weights[12] = 0.00990544796417320118172181619205502613323727181181175875;
        weights[13] = 0.0106446041672878820627077199538905247400358073863634398;
        weights[14] = 0.0113753105149727259842389155448053492293521245095914795;
        weights[15] = 0.0120969869502157172131995122556677358178596753993562874;
        weights[16] = 0.0128090605870335799859483069647304004879039662051538521;
        weights[17] = 0.0135109661641604976005071570010851348535078918311435815;
        weights[18] = 0.0142021464931173176063369035041207326610994728088411136;
        weights[19] = 0.0148820529001193485348911351080643337770124279533856808;
        weights[20] = 0.015550145661370603587261490872988629359901071281201174;
        weights[21] = 0.0162058944313417874073269700779581970349230206348108416;
        weights[22] = 0.0168487786636587803367283169373194237590839585869589094;
        weights[23] = 0.0174782880242475907232296825607437363081277961190185457;
        weights[24] = 0.0180939227963955792060476024812324709575957008024281749;
        weights[25] = 0.0186951942773997217534491426898410569418671467827150722;
        weights[26] = 0.0192816251664821112630733274127955302109866387268799856;
        weights[27] = 0.0198527499436615364134601007173558709472958800629397818;
        weights[28] = 0.0204081152392782346760115165470560767558147050345290588;
        weights[29] = 0.020947280193877031048763963527066221370666555293051328;
        weights[30] = 0.02146981680816218312767492390437215040268623779113656;
        weights[31] = 0.0219753102827454375256574000215153210696499924505285163;
        weights[32] = 0.0224633593474171097667828772030735711420688289045627377;
        weights[33] = 0.0229335765796784568428630828385943476261493507039774514;
        weights[34] = 0.0233855887122822334800596863096487849224533063583054319;
        weights[35] = 0.0238190369295371169525045416640182876153469244703295158;
        weights[36] = 0.0242335771521406531974898981350942883983462463530596174;
        weights[37] = 0.0246288803103145180259276825683533531837230373750304729;
        weights[38] = 0.0250046326050251982469440766732062837739564979361171928;
        weights[39] = 0.0253605357570826739564299724924312933508555581050798381;
        weights[40] = 0.0256963072439193194924456497512634402049465888430896961;
        weights[41] = 0.0260116805238610303375508567866343946771379625272710295;
        weights[42] = 0.0263064052477125197293805675874722915480499000187763079;
        weights[43] = 0.0265802474574888047142938548353429275835724473506847418;
        weights[44] = 0.0268329897721351093307970796270459552792274792237236093;
        weights[45] = 0.0270644315600877447868198562974322135326842264798598419;
        weights[46] = 0.0272743890985389749513702884966050113938868776544662893;
        weights[47] = 0.0274626957192794321101335453764524078811258409890479909;
        weights[48] = 0.0276292019410023044951491630433269723797368349247806985;
        weights[49] = 0.0277737755879642652351551823111678456405780361682362179;
        weights[50] = 0.0278963018949089436314681605435140346162725439251533311;
        weights[51] = 0.0279966835981696455054978730955813507864456697929564494;
        weights[52] = 0.0280748410128790011762163147089980801849863450477504045;
        weights[53] = 0.0281307120962242487345438084932407414015102344403475844;
        weights[54] = 0.0281642524966979379590691728718038547502052420818582726;
        weights[55] = 0.0281754355893049576920663646722669351581469509090553355;
        weights[56] = 0.0281642524966979379590691728718038547502052420818582726;
        weights[57] = 0.0281307120962242487345438084932407414015102344403475844;
        weights[58] = 0.0280748410128790011762163147089980801849863450477504045;
        weights[59] = 0.0279966835981696455054978730955813507864456697929564494;
        weights[60] = 0.0278963018949089436314681605435140346162725439251533311;
        weights[61] = 0.0277737755879642652351551823111678456405780361682362179;
        weights[62] = 0.0276292019410023044951491630433269723797368349247806985;
        weights[63] = 0.0274626957192794321101335453764524078811258409890479909;
        weights[64] = 0.0272743890985389749513702884966050113938868776544662893;
        weights[65] = 0.0270644315600877447868198562974322135326842264798598419;
        weights[66] = 0.0268329897721351093307970796270459552792274792237236093;
        weights[67] = 0.0265802474574888047142938548353429275835724473506847418;
        weights[68] = 0.0263064052477125197293805675874722915480499000187763079;
        weights[69] = 0.0260116805238610303375508567866343946771379625272710295;
        weights[70] = 0.0256963072439193194924456497512634402049465888430896961;
        weights[71] = 0.0253605357570826739564299724924312933508555581050798381;
        weights[72] = 0.0250046326050251982469440766732062837739564979361171928;
        weights[73] = 0.0246288803103145180259276825683533531837230373750304729;
        weights[74] = 0.0242335771521406531974898981350942883983462463530596174;
        weights[75] = 0.0238190369295371169525045416640182876153469244703295158;
        weights[76] = 0.0233855887122822334800596863096487849224533063583054319;
        weights[77] = 0.0229335765796784568428630828385943476261493507039774514;
        weights[78] = 0.0224633593474171097667828772030735711420688289045627377;
        weights[79] = 0.0219753102827454375256574000215153210696499924505285163;
        weights[80] = 0.02146981680816218312767492390437215040268623779113656;
        weights[81] = 0.020947280193877031048763963527066221370666555293051328;
        weights[82] = 0.0204081152392782346760115165470560767558147050345290588;
        weights[83] = 0.0198527499436615364134601007173558709472958800629397818;
        weights[84] = 0.0192816251664821112630733274127955302109866387268799856;
        weights[85] = 0.0186951942773997217534491426898410569418671467827150722;
        weights[86] = 0.0180939227963955792060476024812324709575957008024281749;
        weights[87] = 0.0174782880242475907232296825607437363081277961190185457;
        weights[88] = 0.0168487786636587803367283169373194237590839585869589094;
        weights[89] = 0.0162058944313417874073269700779581970349230206348108416;
        weights[90] = 0.015550145661370603587261490872988629359901071281201174;
        weights[91] = 0.0148820529001193485348911351080643337770124279533856808;
        weights[92] = 0.0142021464931173176063369035041207326610994728088411136;
        weights[93] = 0.0135109661641604976005071570010851348535078918311435815;
        weights[94] = 0.0128090605870335799859483069647304004879039662051538521;
        weights[95] = 0.0120969869502157172131995122556677358178596753993562874;
        weights[96] = 0.0113753105149727259842389155448053492293521245095914795;
        weights[97] = 0.0106446041672878820627077199538905247400358073863634398;
        weights[98] = 0.00990544796417320118172181619205502613323727181181175875;
        weights[99] = 0.00915842867507755835961666467654652463393816199750373721;
        weights[100] = 0.00840413931946931458001748256465871413386376395423049565;
        weights[101] = 0.00764317870246880487855072784080700067199999414606698846;
        weights[102] = 0.00687615095229344748770567207598589486712620663248658407;
        weights[103] = 0.00610366506811257316638644819419769115701108146256570232;
        weights[104] = 0.00532633450051659364673224200735626160368124097467536089;
        weights[105] = 0.00454477682981480106321278336471056576403347817139745311;
        weights[106] = 0.00375961376490400761072794512329838670793470123671650674;
        weights[107] = 0.00297147238704545057547799710156120531003380019576799655;
        weights[108] = 0.00218099268143208820449530406847558674009385500205149967;
        weights[109] = 0.00138888364010550276334401324974779736031366579807638266;
        weights[110] = 0.000596845810059268920570441411555248779023253827623760066;
        return;
    case 112:
        points[0] = -0.999771538659771621693486533995941988741881358353317498;
        points[1] = -0.998796446471654933572221167436981855904705608522460568;
        points[2] = -0.997042978932663229867526568376838996124800297769484688;
        points[3] = -0.994512113526926034109948921802451765672052678409805579;
        points[4] = -0.991205775981900889806917985896822046770946366355745729;
        points[5] = -0.98712653306784933987468824805040762273164285089397105;
        points[6] = -0.982277561850900639568924121614470127899098098520769585;
        points[7] = -0.976662641857337205442055401685444892217246239438094254;
        points[8] = -0.970286150702055198785245872458028588003344055087296127;
        points[9] = -0.963153060201196493550936997300052016783438444642805857;
        points[10] = -0.955268932310924177714753253178133239348091830452726694;
        points[11] = -0.946639914709804307447283013334546075663680935208583409;
        points[12] = -0.937272735966494805201384862583349188290269391908768641;
        points[13] = -0.927174700273201407787886244601336532988358692222111555;
        points[14] = -0.916353681739287079481379183043984940614368104427433416;
        points[15] = -0.904818118245091198115498527506216321234660941660477645;
        points[16] = -0.892577004858628850420196354689501248210232051657826216;
        points[17] = -0.879639886819219486164130428213067578246625825648032286;
        points[18] = -0.866016852092935069618786206904943986707323326783609111;
        points[19] = -0.851718523505348264372962557552000356619828868411026469;
        points[20] = -0.836756050457527395704312217653799147078224139868701161;
        points[21] = -0.821141100231625483317254802205362475350427895357530149;
        points[22] = -0.804885848892773911028235013610468549110930318355302275;
        points[23] = -0.788002971794331597550287757728275288087816615977971923;
        points[24] = -0.770505633693865278752555094004415954234067667914764713;
        points[25] = -0.752407478487549646082168745626324611268076106339202019;
        points[26] = -0.733722618570979719201576244105124122237628551847614249;
        points[27] = -0.714465623834683085730954564828054148890103113436285557;
        points[28] = -0.69465151030290709096756354992142422485444666835466478;
        points[29] = -0.674295728424535967702545124992140108579559388788107447;
        points[30] = -0.653414151025265342751527285494391070968351203790724633;
        points[31] = -0.632023060930426519041018204414777244408542957034077172;
        points[32] = -0.610139138268110324418130086165774765184364888856004856;
        points[33] = -0.587779447462490018804205392612784215745112973808855681;
        points[34] = -0.564961423927484617202515398828472226627289147760821435;
        points[35] = -0.541702860471137863649134268626019392917165956440331335;
        points[36] = -0.518021893421313821753076476163502358565944652651696851;
        points[37] = -0.493936988483527471248146813165185200074661896927346231;
        points[38] = -0.469466926341937658737115491438778171640433356701876565;
        points[39] = -0.44463078801473008955193835567249613526134548284298145;
        points[40] = -0.419447939975309615802462970360435913778003379616798088;
        points[41] = -0.39393801905090372790297982310478220249170710239497866;
        points[42] = -0.368120917110352753647637641729891825647713961005394488;
        points[43] = -0.342016765553026677019060935537132185935515105543568079;
        points[44] = -0.315645919610963581727181873577816985391728476913609001;
        points[45] = -0.289028942476470382212648030191331501950830857545154192;
        points[46] = -0.262186589267562614798891921743108721404639463273720225;
        points[47] = -0.235139790843746518356121711616720970742102571451944229;
        points[48] = -0.207909637484763339134465670891722987884472138607920241;
        points[49] = -0.180517362445022657703285865816238042635490267980395174;
        points[50] = -0.152984325396548474156308985713377697376762749751876445;
        points[51] = -0.125331995773348725537246740141967654179927177876335437;
        points[52] = -0.0975819360301957791847797834121892055300417941678903019;
        points[53] = -0.0697557848288721875777063476236090438105405067754560449;
        points[54] = -0.0418752401649925523363890649971841646353114495356913252;
        points[55] = -0.0139620424485586832751437213321379394055263504067966561;
        points[56] = 0.0139620424485586832751