/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.Tuple2;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.Verifiable;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContext {
    public static final boolean DEFAULT_LOCAL_ONLY = false;
    private final ValidationContext _parent;
    private Collection<Column> _columns;
    private Collection<Table> _tables;
    private boolean _localOnly;
    private Collection<Tuple2<ValidationContext, ? extends Verifiable<?>>> _verifiables;

    public ValidationContext() {
        this(null, null, null, false);
    }

    public ValidationContext(ValidationContext parent) {
        this(parent, null, null, false);
    }

    public ValidationContext(boolean localOnly) {
        this(null, null, null, localOnly);
    }

    public ValidationContext(Collection<Table> tables, Collection<Column> columns) {
        this(null, tables, columns, false);
    }

    public ValidationContext(ValidationContext parent, Collection<Table> tables, Collection<Column> columns, boolean localOnly) {
        this._parent = parent;
        this._tables = tables != null ? tables : new HashSet();
        this._columns = columns != null ? columns : new HashSet();
        this._localOnly = localOnly;
        this._verifiables = this._parent != null ? this._parent._verifiables : new ArrayList(2);
    }

    public ValidationContext getParent() {
        return this._parent;
    }

    public Collection<Table> getTables() {
        return this._tables;
    }

    public void setTables(Collection<Table> newTables) {
        this._tables = newTables;
    }

    public void addTable(Table table) {
        this._tables.add(table);
    }

    public Collection<Column> getColumns() {
        return this._columns;
    }

    public void setColumns(Collection<Column> newColumns) {
        this._columns = newColumns;
    }

    public void addColumn(Column column) {
        this._columns.add(column);
    }

    public boolean isLocalOnly() {
        return this._localOnly;
    }

    public void setLocalOnly(boolean newLocalOnly) {
        this._localOnly = newLocalOnly;
    }

    public void addVerifiable(Verifiable<?> verifiable) {
        if (verifiable == null) {
            throw new IllegalArgumentException("verifiable was null");
        }
        this._verifiables.add(Tuple2.create(this, verifiable));
    }

    public void validateAll() throws ValidationException {
        for (Tuple2<ValidationContext, Verifiable<?>> verifiable : this._verifiables) {
            try {
                verifiable.get1().validate((ValidationContext)verifiable.get0());
            }
            catch (ValidationException e) {
                e.setFailedVerifiable(verifiable);
                throw e;
            }
        }
    }

    public void collectNestedQuerySchemaObjects(SqlObject nestedQuery) {
        if (nestedQuery != null && !this.isLocalOnly()) {
            nestedQuery.collectSchemaObjects(new ValidationContext(this));
        }
    }

    protected Collection<Table> getColumnTables() {
        return this.getColumnTables(null);
    }

    protected Collection<Table> getColumnTables(Collection<Table> columnTables) {
        if (columnTables == null) {
            columnTables = new HashSet<Table>();
        }
        for (Column column : this._columns) {
            columnTables.add(column.getTable());
        }
        return columnTables;
    }
}

