/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.search.bayesian;

import org.linqs.psl.application.learning.weight.search.bayesian.GaussianProcessKernel;
import org.linqs.psl.util.FloatMatrix;

public class SquaredExpKernel
extends GaussianProcessKernel {
    public SquaredExpKernel() {
    }

    public SquaredExpKernel(float[] scalingWeights) {
        super(scalingWeights);
    }

    @Override
    public float kernel(FloatMatrix pt1, FloatMatrix pt2) {
        FloatMatrix diff;
        assert (pt1.size() == pt2.size());
        if (this.weighted) {
            pt1.elementMul(this.scalingWeights, true);
            pt2.elementMul(this.scalingWeights, true);
        }
        switch (this.space) {
            case OS: {
                diff = pt1.elementSub(pt2, true);
                break;
            }
            case LS: {
                diff = pt1.elementLog(true).elementSub(pt2.elementLog(true), true);
                break;
            }
            case SS: {
                float pt1LogBaseline = (float)Math.log(pt1.get(0, 0));
                float pt2LogBaseline = (float)Math.log(pt2.get(0, 0));
                pt1.elementLog(true).sub(pt1LogBaseline, true);
                pt2.elementLog(true).sub(pt2LogBaseline, true);
                diff = pt1.elementSub(pt2, true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Space: " + (Object)((Object)this.space));
            }
        }
        return this.scale * (float)Math.exp(-0.5 * (double)this.relDep * (double)diff.norm2());
    }
}

