/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.atom;

import java.util.HashMap;
import java.util.Map;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.util.IteratorUtils;

public class AtomCache {
    protected final Database db;
    protected final Map<QueryAtom, GroundAtom> cache;
    private int rvaCount;
    private int obsCount;

    public AtomCache(Database db) {
        this.db = db;
        this.cache = new HashMap<QueryAtom, GroundAtom>();
        this.rvaCount = 0;
        this.obsCount = 0;
    }

    public GroundAtom getCachedAtom(QueryAtom atom) {
        return this.cache.get(atom);
    }

    public Iterable<GroundAtom> getCachedAtoms() {
        return this.cache.values();
    }

    public int getRVACount() {
        return this.rvaCount;
    }

    public int getObsCount() {
        return this.obsCount;
    }

    public Iterable<GroundAtom> getCachedAtoms(final Predicate predicate) {
        return IteratorUtils.filter(this.cache.values(), new IteratorUtils.FilterFunction<GroundAtom>(){

            @Override
            public boolean keep(GroundAtom atom) {
                return atom.getPredicate().equals(predicate);
            }
        });
    }

    public synchronized boolean removeCachedAtom(QueryAtom qAtom) {
        if (this.cache.containsKey(qAtom)) {
            GroundAtom atom = this.cache.remove(qAtom);
            if (atom instanceof RandomVariableAtom) {
                --this.rvaCount;
            } else if (atom instanceof ObservedAtom) {
                --this.obsCount;
            }
            return true;
        }
        return false;
    }

    public Iterable<ObservedAtom> getCachedObservedAtoms() {
        return IteratorUtils.filterClass(this.cache.values(), ObservedAtom.class);
    }

    public Iterable<RandomVariableAtom> getCachedRandomVariableAtoms() {
        return IteratorUtils.filterClass(this.cache.values(), RandomVariableAtom.class);
    }

    public synchronized ObservedAtom instantiateObservedAtom(Predicate predicate, Constant[] args, float value) {
        QueryAtom key = new QueryAtom(predicate, args);
        if (this.cache.containsKey(key)) {
            if (!(this.cache.get(key) instanceof ObservedAtom)) {
                throw new IllegalStateException("Asked to instantiate an observed atom that already exists as a random variable atom (target): " + key);
            }
            return (ObservedAtom)this.cache.get(key);
        }
        ObservedAtom atom = new ObservedAtom(predicate, args, value);
        this.cache.put(key, atom);
        ++this.obsCount;
        return atom;
    }

    public synchronized RandomVariableAtom instantiateRandomVariableAtom(StandardPredicate predicate, Constant[] args, float value) {
        QueryAtom key = new QueryAtom(predicate, args);
        if (this.cache.containsKey(key)) {
            if (!(this.cache.get(key) instanceof RandomVariableAtom)) {
                throw new IllegalStateException("Asked to instantiate a random variable atom (target) that already exists as an observed atom: " + key);
            }
            return (RandomVariableAtom)this.cache.get(key);
        }
        RandomVariableAtom atom = new RandomVariableAtom(predicate, args, value);
        this.cache.put(key, atom);
        ++this.rvaCount;
        return atom;
    }
}

