/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.loading.Inserter;
import org.linqs.psl.database.rdbms.DataStoreMetadata;
import org.linqs.psl.database.rdbms.PredicateInfo;
import org.linqs.psl.database.rdbms.RDBMSDatabase;
import org.linqs.psl.database.rdbms.RDBMSInserter;
import org.linqs.psl.database.rdbms.driver.DatabaseDriver;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.Parallel;

public class RDBMSDataStore
implements DataStore {
    private static final Logger log = Logger.getLogger(RDBMSDataStore.class);
    private static final Set<RDBMSDataStore> openDataStores = new HashSet<RDBMSDataStore>();
    private DatabaseDriver dbDriver;
    private DataStoreMetadata metadata;
    private final Map<Partition, List<Database>> openDatabases;
    private final Set<Partition> writePartitionIDs;
    private final Map<Predicate, PredicateInfo> predicates;
    private boolean predicatesIndexed;

    public RDBMSDataStore(DatabaseDriver dbDriver) {
        openDataStores.add(this);
        this.openDatabases = new HashMap<Partition, List<Database>>();
        this.writePartitionIDs = new HashSet<Partition>();
        this.predicates = new HashMap<Predicate, PredicateInfo>();
        this.dbDriver = dbDriver;
        this.metadata = new DataStoreMetadata(this);
        this.predicatesIndexed = true;
    }

    @Override
    public void registerPredicate(StandardPredicate predicate) {
        if (this.predicates.containsKey(predicate)) {
            return;
        }
        PredicateInfo predicateInfo = new PredicateInfo(predicate);
        this.predicates.put(predicate, predicateInfo);
        this.predicatesIndexed = false;
        try (Connection connection = this.getConnection();){
            predicateInfo.setupTable(connection, this.dbDriver);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Unable to setup predicate table for: " + predicate + ".", ex);
        }
    }

    @Override
    public Database getDatabase(Partition write, Partition ... read) {
        return this.getDatabase(write, (Set<StandardPredicate>)null, read);
    }

    @Override
    public Database getDatabase(Partition write, StandardPredicate[] toClose, Partition ... read) {
        if (toClose == null) {
            return this.getDatabase(write, (Set<StandardPredicate>)null, read);
        }
        HashSet<StandardPredicate> closeSet = new HashSet<StandardPredicate>();
        for (StandardPredicate predicate : toClose) {
            closeSet.add(predicate);
        }
        return this.getDatabase(write, closeSet, read);
    }

    @Override
    public Database getDatabase(Partition write, Set<StandardPredicate> toClose, Partition ... read) {
        if (this.writePartitionIDs.contains(write)) {
            throw new IllegalArgumentException("The specified write partition ID is already used by another database.");
        }
        if (this.openDatabases.containsKey(write)) {
            throw new IllegalArgumentException("The specified write partition ID is also a read partition.");
        }
        for (Partition partition : read) {
            if (!this.writePartitionIDs.contains(partition)) continue;
            throw new IllegalArgumentException("Another database is writing to a specified read partition: " + partition);
        }
        this.indexPredicates();
        RDBMSDatabase db = new RDBMSDatabase(this, write, read, toClose);
        for (Partition partition : read) {
            if (!this.openDatabases.containsKey(partition)) {
                this.openDatabases.put(partition, new ArrayList());
            }
            this.openDatabases.get(partition).add(db);
        }
        this.writePartitionIDs.add(write);
        return db;
    }

    public void indexPredicates() {
        if (this.predicatesIndexed) {
            return;
        }
        this.predicatesIndexed = true;
        ArrayList<PredicateInfo> toIndex = new ArrayList<PredicateInfo>();
        for (PredicateInfo predicateInfo : this.predicates.values()) {
            if (predicateInfo.indexed()) continue;
            toIndex.add(predicateInfo);
        }
        if (toIndex.size() == 0) {
            return;
        }
        log.debug("Indexing predicates.");
        if (this.dbDriver.canConcurrentWrite()) {
            Parallel.foreach(toIndex, new Parallel.Worker<PredicateInfo>(){

                @Override
                public void work(long index, PredicateInfo predicateInfo) {
                    log.trace("Parallel Indexing " + predicateInfo.predicate());
                    try (Connection connection = RDBMSDataStore.this.getConnection();){
                        predicateInfo.index(connection, RDBMSDataStore.this.dbDriver);
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException("Unable to index predicate: " + predicateInfo.predicate(), ex);
                    }
                }
            });
        } else {
            for (PredicateInfo predicateInfo : toIndex) {
                log.trace("Serial Indexing " + predicateInfo.predicate());
                try {
                    Connection connection = this.getConnection();
                    Throwable throwable = null;
                    try {
                        predicateInfo.index(connection, this.dbDriver);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (connection == null) continue;
                        if (throwable != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        connection.close();
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException("Unable to index predicate: " + predicateInfo.predicate(), ex);
                }
            }
        }
        this.dbDriver.updateDBStats();
        log.debug("Predicate indexing complete.");
    }

    @Override
    public Iterable<Database> getOpenDatabases() {
        HashSet<Database> databases = new HashSet<Database>();
        for (List<Database> partitionDatabases : this.openDatabases.values()) {
            databases.addAll(partitionDatabases);
        }
        return databases;
    }

    @Override
    public Inserter getInserter(StandardPredicate predicate, Partition partition) {
        if (!this.predicates.containsKey(predicate)) {
            throw new IllegalArgumentException("Unknown predicate specified: " + predicate);
        }
        if (this.writePartitionIDs.contains(partition) || this.openDatabases.containsKey(partition)) {
            throw new IllegalStateException("Partition [" + partition + "] is currently in use, cannot insert into it.");
        }
        return new RDBMSInserter(this, this.predicates.get(predicate), partition);
    }

    @Override
    public Set<StandardPredicate> getRegisteredPredicates() {
        HashSet<StandardPredicate> standardPredicates = new HashSet<StandardPredicate>();
        for (Predicate predicate : this.predicates.keySet()) {
            if (!(predicate instanceof StandardPredicate)) continue;
            standardPredicates.add((StandardPredicate)predicate);
        }
        return standardPredicates;
    }

    @Override
    public int deletePartition(Partition partition) {
        if (this.writePartitionIDs.contains(partition) || this.openDatabases.containsKey(partition)) {
            throw new IllegalArgumentException("Cannot delete partition that is in use.");
        }
        int deletedEntries = 0;
        try (Connection connection = this.getConnection();
             Statement stmt = connection.createStatement();){
            for (PredicateInfo pred : this.predicates.values()) {
                String sql = "DELETE FROM " + pred.tableName() + " WHERE " + "partition_id" + " = " + partition.getID();
                deletedEntries += stmt.executeUpdate(sql);
            }
            this.metadata.removePartition(partition);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return deletedEntries;
    }

    @Override
    public void close() {
        openDataStores.remove(this);
        if (!this.openDatabases.isEmpty()) {
            throw new IllegalStateException("Cannot close data store when databases are still open!");
        }
        if (this.dbDriver != null) {
            this.dbDriver.close();
            this.dbDriver = null;
        }
    }

    public DataStoreMetadata getMetadata() {
        return this.metadata;
    }

    public void releasePartitions(RDBMSDatabase db) {
        if (!db.getDataStore().equals(this)) {
            throw new IllegalArgumentException("Database has not been opened with this data store.");
        }
        for (Partition partition : db.getReadPartitions()) {
            this.openDatabases.get(partition).remove(db);
            if (!this.openDatabases.get(partition).isEmpty()) continue;
            this.openDatabases.remove(partition);
        }
        this.writePartitionIDs.remove(db.getWritePartition());
    }

    @Override
    public Partition getNewPartition() {
        return this.metadata.getNewPartition();
    }

    @Override
    public Partition getPartition(String partitionName) {
        return this.metadata.getPartition(partitionName);
    }

    @Override
    public Set<Partition> getPartitions() {
        return this.metadata.getAllPartitions();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPredicateRowCount(StandardPredicate predicate) {
        try (Connection connection = this.getConnection();){
            int n = this.predicates.get(predicate).getCount(connection);
            return n;
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to close connection for count.", ex);
        }
    }

    public DatabaseDriver getDriver() {
        return this.dbDriver;
    }

    public Connection getConnection() {
        return this.dbDriver.getConnection();
    }

    public static Set<RDBMSDataStore> getOpenDataStores() {
        return Collections.unmodifiableSet(openDataStores);
    }

    public synchronized PredicateInfo getPredicateInfo(Predicate predicate) {
        PredicateInfo info = this.predicates.get(predicate);
        if (info == null) {
            throw new IllegalArgumentException("Predicate not registered with data store.");
        }
        return info;
    }
}

