/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms.driver;

import com.healthmarketscience.sqlbuilder.SelectQuery;
import java.util.ArrayList;
import org.linqs.psl.database.rdbms.driver.DatabaseDriver;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.util.ListUtils;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.StringUtils;

public class SQLiteDriver
extends DatabaseDriver {
    private static final Logger log = Logger.getLogger(SQLiteDriver.class);
    private boolean inMemory;

    public SQLiteDriver(boolean inMemory, String path, boolean clearDatabase) {
        this(SQLiteDriver.formatConnectionString(inMemory, path), clearDatabase);
        if (inMemory) {
            log.debug("Using in-memory database.");
        } else {
            log.debug("Using on-disk database: " + path);
        }
    }

    public SQLiteDriver(String connectionString, boolean clearDatabase) {
        super("org.sqlite.JDBC", connectionString, clearDatabase);
        log.debug("Connected to SQLite database.");
        if (connectionString.contains(":memory:")) {
            this.inMemory = true;
        }
    }

    @Override
    protected void clearDatabase() {
        this.executeUpdate("PRAGMA writable_schema = ON");
        this.executeUpdate("DELETE FROM sqlite_master");
        this.executeUpdate("PRAGMA writable_schema = OFF");
        this.executeUpdate("VACUUM");
        this.executeUpdate("PRAGMA integrity_check");
    }

    @Override
    public String getTypeName(ConstantType type) {
        switch (type) {
            case Double: {
                return "REAL";
            }
            case Integer: {
                return "INTEGER";
            }
            case String: {
                return "TEXT";
            }
            case Long: {
                return "INTEGER";
            }
            case UniqueIntID: {
                return "INTEGER";
            }
            case UniqueStringID: {
                return "TEXT";
            }
        }
        throw new IllegalStateException("Unknown ConstantType: " + (Object)((Object)type));
    }

    @Override
    public String getSurrogateKeyColumnDefinition(String columnName) {
        return columnName + " INTEGER PRIMARY KEY";
    }

    @Override
    public String getDoubleTypeName() {
        return "REAL";
    }

    @Override
    public String getUpsert(String tableName, String[] columns, String[] keyColumns) {
        ArrayList<String> updateValues = new ArrayList<String>();
        for (String column : columns) {
            updateValues.add(String.format("%s = EXCLUDED.%s", column, column));
        }
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("INSERT INTO " + tableName + "");
        sql.add("    (" + StringUtils.join(", ", (Object[])columns) + ")");
        sql.add("VALUES");
        sql.add("    (" + StringUtils.repeat("?", ", ", columns.length) + ")");
        sql.add("ON CONFLICT");
        sql.add("    (" + StringUtils.join(", ", (Object[])keyColumns) + ")");
        sql.add("DO UPDATE SET");
        sql.add("    " + ListUtils.join(", ", updateValues));
        return ListUtils.join(System.lineSeparator(), sql);
    }

    private static String formatConnectionString(boolean inMemory, String path) {
        if (inMemory) {
            return "jdbc:sqlite:file::memory:?cache=shared&read_uncommitted=true";
        }
        return String.format("jdbc:sqlite:%s?read_uncommitted=true", path);
    }

    @Override
    public void updateDBStats() {
        this.executeUpdate("VACUUM");
    }

    @Override
    public String setLimit(SelectQuery query, int count) {
        String queryString = ((SelectQuery)query.validate()).toString();
        return queryString + " LIMIT " + count;
    }

    @Override
    public boolean canConcurrentWrite() {
        return this.inMemory;
    }
}

