/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding.collective;

import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.util.MathUtils;

public class CandidateSearchNode
implements Comparable<CandidateSearchNode> {
    public final long atomsBitSet;
    public final Formula formula;
    public final int numAtoms;
    public boolean approximateCost;
    public double optimisticCost;
    public double pessimisticCost;

    public CandidateSearchNode(long atomsBitSet, Formula formula, int numAtoms, double optimisticCost, double pessimisticCost) {
        this.atomsBitSet = atomsBitSet;
        this.formula = formula;
        this.numAtoms = numAtoms;
        this.approximateCost = true;
        this.optimisticCost = optimisticCost;
        this.pessimisticCost = pessimisticCost;
    }

    public String toString() {
        return String.format("{Atom Bits: %d, Optimistic: %f, Pessimistic: %f, Approximate: %s, Formula: %s}", this.atomsBitSet, this.optimisticCost, this.pessimisticCost, this.approximateCost, this.formula);
    }

    @Override
    public int compareTo(CandidateSearchNode other) {
        if (other == null) {
            return 1;
        }
        return MathUtils.compare(this.optimisticCost, other.optimisticCost);
    }

    public int hashCode() {
        return (int)this.atomsBitSet;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof CandidateSearchNode) || this.hashCode() != other.hashCode()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        CandidateSearchNode otherNode = (CandidateSearchNode)other;
        return otherNode.atomsBitSet == this.atomsBitSet && otherNode.formula.equals(this.formula);
    }
}

