/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding.collective;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.grounding.collective.CandidateQuery;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.formula.Conjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.BitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Containment {
    private static final Logger log = LoggerFactory.getLogger(Containment.class);

    private Containment() {
    }

    public static void computeContainement(List<Rule> collectiveRules, Collection<CandidateQuery> candidates) {
        HashMap<CandidateQuery, Map<Variable, Set<VariableInstance>>> candidateVariableUsages = new HashMap<CandidateQuery, Map<Variable, Set<VariableInstance>>>();
        HashMap<CandidateQuery, ArrayList<Variable>> candidateVariables = new HashMap<CandidateQuery, ArrayList<Variable>>();
        for (CandidateQuery candidate : candidates) {
            Map<Variable, Set<VariableInstance>> variableUsage = Containment.getVariableUsage(candidate.getFormula());
            candidateVariableUsages.put(candidate, variableUsage);
            candidateVariables.put(candidate, new ArrayList<Variable>(variableUsage.keySet()));
        }
        for (Rule rule : collectiveRules) {
            Formula ruleFormula = rule.getRewritableGroundingFormula();
            Map<Variable, Set<VariableInstance>> ruleVariableUsage = Containment.getVariableUsage(rule);
            ArrayList<Variable> ruleVariables = new ArrayList<Variable>(ruleVariableUsage.keySet());
            for (CandidateQuery candidate : candidates) {
                Map<Variable, Variable> variableMap;
                if (candidate.getVariableMapping(rule) != null || (variableMap = Containment.computeVariableMapping(candidate.getFormula(), (Map)candidateVariableUsages.get(candidate), (List)candidateVariables.get(candidate), ruleFormula, ruleVariableUsage, ruleVariables)) == null) continue;
                candidate.getCoveredVariableMappings().put(rule, variableMap);
            }
        }
    }

    private static Map<Variable, Variable> computeVariableMapping(Formula superFormula, Map<Variable, Set<VariableInstance>> superVariableUsage, List<Variable> superVariables, Formula subFormula, Map<Variable, Set<VariableInstance>> subVariableUsage, List<Variable> subVariables) {
        assert (superVariables.size() < 64);
        if (superVariables.size() != subVariables.size()) {
            return null;
        }
        HashMap<Variable, Variable> mapping = new HashMap<Variable, Variable>();
        long usedVariables = 0L;
        for (int superStartIndex = 0; superStartIndex < superVariables.size(); ++superStartIndex) {
            mapping.clear();
            usedVariables = 0L;
            for (int superIndexOffset = 0; superIndexOffset < superVariables.size(); ++superIndexOffset) {
                int superIndex = (superStartIndex + superIndexOffset) % superVariables.size();
                boolean foundSubVariable = false;
                for (int subIndex = 0; subIndex < subVariables.size(); ++subIndex) {
                    if (BitUtils.getBit(usedVariables, subIndex)) continue;
                    Set<VariableInstance> superVariableInstances = superVariableUsage.get(superVariables.get(superIndex));
                    Set<VariableInstance> subVariableInstances = subVariableUsage.get(subVariables.get(subIndex));
                    if (!subVariableInstances.containsAll(superVariableInstances)) continue;
                    mapping.put(superVariables.get(superIndex), subVariables.get(subIndex));
                    usedVariables = BitUtils.setBit(usedVariables, subIndex, true);
                    foundSubVariable = true;
                    break;
                }
                if (!foundSubVariable) break;
            }
            if (mapping.size() != superVariables.size()) continue;
            return mapping;
        }
        return null;
    }

    private static Map<Variable, Set<VariableInstance>> getVariableUsage(Rule rule) {
        HashSet<Atom> atoms = new HashSet<Atom>();
        rule.getCoreAtoms(atoms);
        if (atoms.size() == 1) {
            return Containment.getVariableUsage((Formula)atoms.iterator().next());
        }
        Conjunction formula = new Conjunction(atoms.toArray(new Formula[0]));
        return Containment.getVariableUsage(formula);
    }

    private static Map<Variable, Set<VariableInstance>> getVariableUsage(Formula formula) {
        HashSet<Atom> tempAtoms = new HashSet<Atom>();
        StringBuilder atomModifier = new StringBuilder();
        HashMap<Variable, Set<VariableInstance>> variableUsage = new HashMap<Variable, Set<VariableInstance>>();
        formula.getAtoms(tempAtoms);
        for (Atom atom : tempAtoms) {
            int i;
            Term[] arguments = atom.getArguments();
            atomModifier.setLength(0);
            for (i = 0; i < arguments.length; ++i) {
                if (!(arguments[i] instanceof Constant)) continue;
                if (atomModifier.length() != 0) {
                    atomModifier.append(",");
                }
                atomModifier.append("" + i + ":" + arguments[i]);
            }
            for (i = 0; i < arguments.length; ++i) {
                if (!(arguments[i] instanceof Variable)) {
                    if (arguments[i] instanceof Constant) continue;
                    throw new RuntimeException(String.format("Expecting only variables and constants, found: %s (%s).", arguments[i], arguments[i].getClass()));
                }
                Variable variable = (Variable)arguments[i];
                if (!variableUsage.containsKey(variable)) {
                    variableUsage.put(variable, new HashSet());
                }
                ((Set)variableUsage.get(variable)).add(new VariableInstance(atom.getPredicate(), i, atomModifier.toString()));
            }
        }
        return variableUsage;
    }

    private static class VariableInstance {
        public final String predicate;
        public final int position;
        public final String atomModifier;
        private final int hashCode;

        public VariableInstance(Predicate predicate, int position, String atomModifier) {
            this.predicate = predicate.getName();
            this.position = position;
            this.atomModifier = atomModifier;
            this.hashCode = this.toString().hashCode();
        }

        public String toString() {
            if (this.atomModifier.length() == 0) {
                return this.predicate + "::" + this.position;
            }
            return this.predicate + "(" + this.atomModifier + ")::" + this.position;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass() || other.hashCode() != this.hashCode()) {
                return false;
            }
            VariableInstance otherInstance = (VariableInstance)other;
            return this.position == otherInstance.position && this.predicate.equals(otherInstance.predicate) && this.atomModifier.equals(otherInstance.atomModifier);
        }
    }
}

